/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.queryframework;

import java.util.Vector;
import oracle.toplink.essentials.descriptors.ClassDescriptor;
import oracle.toplink.essentials.descriptors.DescriptorQueryManager;
import oracle.toplink.essentials.exceptions.DatabaseException;
import oracle.toplink.essentials.exceptions.QueryException;
import oracle.toplink.essentials.expressions.Expression;
import oracle.toplink.essentials.expressions.ExpressionBuilder;
import oracle.toplink.essentials.internal.descriptors.ObjectBuilder;
import oracle.toplink.essentials.internal.helper.InvalidObject;
import oracle.toplink.essentials.internal.sessions.AbstractRecord;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.internal.sessions.UnitOfWorkImpl;
import oracle.toplink.essentials.queryframework.Call;
import oracle.toplink.essentials.queryframework.ComplexQueryResult;
import oracle.toplink.essentials.queryframework.DatabaseQuery;
import oracle.toplink.essentials.queryframework.ObjectLevelReadQuery;

public class ReadObjectQuery
extends ObjectLevelReadQuery {
    protected transient Object selectionObject;
    protected Vector selectionKey;
    protected boolean shouldLoadResultIntoSelectionObject = false;

    public ReadObjectQuery() {
    }

    public ReadObjectQuery(Class classToRead) {
        this();
        this.setReferenceClass(classToRead);
    }

    public ReadObjectQuery(Class classToRead, Expression selectionCriteria) {
        this();
        this.setReferenceClass(classToRead);
        this.setSelectionCriteria(selectionCriteria);
    }

    public ReadObjectQuery(Class classToRead, ExpressionBuilder builder) {
        this();
        this.defaultBuilder = builder;
        this.setReferenceClass(classToRead);
    }

    public ReadObjectQuery(Class classToRead, Call call) {
        this();
        this.setReferenceClass(classToRead);
        this.setCall(call);
    }

    public ReadObjectQuery(Call call) {
        this();
        this.setCall(call);
    }

    public ReadObjectQuery(Object objectToRead) {
        this();
        this.setSelectionObject(objectToRead);
    }

    public ReadObjectQuery(ExpressionBuilder builder) {
        this();
        this.defaultBuilder = builder;
    }

    public void checkCacheByExactPrimaryKey() {
        this.setCacheUsage(1);
    }

    public void checkCacheByPrimaryKey() {
        this.setCacheUsage(2);
    }

    public void checkCacheThenDatabase() {
        this.setCacheUsage(3);
    }

    public void checkDescriptor(AbstractSession session) throws QueryException {
        if (this.getReferenceClass() == null) {
            throw QueryException.referenceClassMissing(this);
        }
        if (this.getDescriptor() == null) {
            ClassDescriptor referenceDescriptor = this.getSelectionObject() != null && session.getProject().hasProxyIndirection() ? session.getDescriptor(this.getSelectionObject()) : session.getDescriptor(this.getReferenceClass());
            if (referenceDescriptor == null) {
                throw QueryException.descriptorIsMissing(this.getReferenceClass(), this);
            }
            this.setDescriptor(referenceDescriptor);
        }
    }

    protected Object checkEarlyReturnImpl(AbstractSession session, AbstractRecord translationRow) {
        if (!(!this.shouldMaintainCache() || this.shouldRefreshIdentityMapResult() || this.shouldCheckDescriptorForCacheUsage() && this.getDescriptor().shouldDisableCacheHits() || !this.shouldCheckCache())) {
            Object cachedObject = this.getQueryMechanism().checkCacheForObject(translationRow, session);
            if (cachedObject == InvalidObject.instance) {
                return cachedObject;
            }
            if (cachedObject != null) {
                if (this.shouldLoadResultIntoSelectionObject()) {
                    ObjectBuilder builder = this.getDescriptor().getObjectBuilder();
                    builder.copyInto(cachedObject, this.getSelectionObject());
                    session.getIdentityMapAccessorInstance().putInIdentityMap(this.getSelectionObject());
                    cachedObject = this.getSelectionObject();
                }
                if (this.isLockQuery() && session.isUnitOfWork() && !((UnitOfWorkImpl)session).isPessimisticLocked(cachedObject)) {
                    return null;
                }
            }
            if (this.shouldUseWrapperPolicy()) {
                cachedObject = this.getDescriptor().getObjectBuilder().wrapObject(cachedObject, session);
            }
            return cachedObject;
        }
        return null;
    }

    protected DatabaseQuery checkForCustomQuery(AbstractSession session, AbstractRecord translationRow) {
        this.checkDescriptor(session);
        if (!this.isUserDefined()) {
            if (this.isCallQuery()) {
                return null;
            }
            DescriptorQueryManager descriptorQueryManager = this.getDescriptor().getQueryManager();
            if (descriptorQueryManager.hasReadObjectQuery()) {
                AbstractRecord primaryKeyRow;
                if (this.getJoinedAttributeManager().hasJoinedAttributeExpressions() || this.hasPartialAttributeExpressions() || this.hasAsOfClause() || this.hasNonDefaultFetchGroup() || !this.wasDefaultLockMode() || !this.shouldIgnoreBindAllParameters()) {
                    return null;
                }
                if (this.getSelectionKey() != null || this.getSelectionObject() != null) {
                    return descriptorQueryManager.getReadObjectQuery();
                }
                if (this.getSelectionCriteria() != null && (primaryKeyRow = this.getDescriptor().getObjectBuilder().extractPrimaryKeyRowFromExpression(this.getSelectionCriteria(), translationRow, session)) != null) {
                    return descriptorQueryManager.getReadObjectQuery();
                }
            }
        }
        return null;
    }

    protected Object conformResult(Object result, UnitOfWorkImpl unitOfWork, AbstractRecord databaseRow, boolean buildDirectlyFromRows) {
        Object clone;
        Object implementation = null;
        implementation = buildDirectlyFromRows ? result : this.getDescriptor().getObjectBuilder().unwrapObject(result, unitOfWork.getParent());
        Expression selectionCriteriaClone = null;
        if (this.getSelectionCriteria() != null && this.getSelectionKey() == null && this.getSelectionObject() == null) {
            selectionCriteriaClone = (Expression)this.getSelectionCriteria().clone();
            selectionCriteriaClone.getBuilder().setSession(unitOfWork.getRootSession(null));
            selectionCriteriaClone.getBuilder().setQueryClass(this.getReferenceClass());
        }
        if ((clone = this.conformIndividualResult(implementation, unitOfWork, databaseRow, selectionCriteriaClone, null, buildDirectlyFromRows)) == null) {
            return clone;
        }
        if (this.shouldUseWrapperPolicy()) {
            return this.getDescriptor().getObjectBuilder().wrapObject(clone, unitOfWork);
        }
        return clone;
    }

    public void dontLoadResultIntoSelectionObject() {
        this.setShouldLoadResultIntoSelectionObject(false);
    }

    protected Object executeObjectLevelReadQuery() throws DatabaseException {
        AbstractRecord row = null;
        if (this.getJoinedAttributeManager().isToManyJoin()) {
            Vector rows = this.getQueryMechanism().selectAllRows();
            if (rows.size() > 0) {
                row = (AbstractRecord)rows.get(0);
            }
            this.getJoinedAttributeManager().setDataResults(rows, this.getSession());
        } else {
            row = this.getQueryMechanism().selectOneRow();
        }
        this.setExecutionTime(System.currentTimeMillis());
        Object result = null;
        if (this.getSession().isUnitOfWork()) {
            result = this.registerResultInUnitOfWork(row, (UnitOfWorkImpl)this.getSession(), this.getTranslationRow(), true);
        } else if (row != null) {
            result = this.buildObject(row);
        }
        if (this.shouldIncludeData()) {
            ComplexQueryResult complexResult = new ComplexQueryResult();
            complexResult.setResult(result);
            complexResult.setData(row);
            return complexResult;
        }
        return result;
    }

    public Vector getSelectionKey() {
        return this.selectionKey;
    }

    public Object getSelectionObject() {
        return this.selectionObject;
    }

    public boolean isReadObjectQuery() {
        return true;
    }

    public void loadResultIntoSelectionObject() {
        this.setShouldLoadResultIntoSelectionObject(true);
    }

    protected void prepare() throws QueryException {
        super.prepare();
        if (this.getSelectionKey() != null || this.getSelectionObject() != null) {
            this.setSelectionCriteria(this.getDescriptor().getObjectBuilder().getPrimaryKeyExpression());
            if (!this.shouldPrepare()) {
                if (this.getSelectionKey() != null) {
                    this.setTranslationRow(this.getDescriptor().getObjectBuilder().buildRowFromPrimaryKeyValues(this.getSelectionKey(), this.getSession()));
                } else {
                    this.setTranslationRow(this.getDescriptor().getObjectBuilder().buildRowForTranslation(this.getSelectionObject(), this.getSession()));
                }
            }
        }
        if (this.getJoinedAttributeManager().isToManyJoin()) {
            this.getQueryMechanism().prepareSelectAllRows();
        } else {
            this.getQueryMechanism().prepareSelectOneRow();
        }
    }

    protected void prepareCustomQuery(DatabaseQuery customQuery) {
        ReadObjectQuery customReadQuery = (ReadObjectQuery)customQuery;
        customReadQuery.setShouldRefreshIdentityMapResult(this.shouldRefreshIdentityMapResult());
        customReadQuery.setCascadePolicy(this.getCascadePolicy());
        customReadQuery.setShouldMaintainCache(this.shouldMaintainCache());
        customReadQuery.setShouldUseWrapperPolicy(this.shouldUseWrapperPolicy());
        customReadQuery.setQueryId(this.getQueryId());
        customReadQuery.setExecutionTime(this.getExecutionTime());
        customReadQuery.setShouldLoadResultIntoSelectionObject(this.shouldLoadResultIntoSelectionObject());
        if (this.getSelectionObject() != null) {
            customReadQuery.setSelectionObject(this.getSelectionObject());
        } else if (this.getSelectionKey() != null) {
            customReadQuery.setSelectionKey(this.getSelectionKey());
        } else {
            AbstractRecord primaryKeyRow = customQuery.getDescriptor().getObjectBuilder().extractPrimaryKeyRowFromExpression(this.getSelectionCriteria(), customQuery.getTranslationRow(), customReadQuery.getSession());
            customReadQuery.setTranslationRow(primaryKeyRow);
        }
    }

    public void prepareForExecution() throws QueryException {
        super.prepareForExecution();
        if (this.shouldPrepare()) {
            if (this.getSelectionKey() != null) {
                this.setTranslationRow(this.getDescriptor().getObjectBuilder().buildRowFromPrimaryKeyValues(this.getSelectionKey(), this.getSession()));
            } else if (this.getSelectionObject() != null) {
                this.setTranslationRow(this.getDescriptor().getObjectBuilder().buildRowForTranslation(this.getSelectionObject(), this.getSession()));
            }
        }
    }

    public Object registerResultInUnitOfWork(Object result, UnitOfWorkImpl unitOfWork, AbstractRecord arguments, boolean buildDirectlyFromRows) {
        if (result == null) {
            return null;
        }
        if (this.shouldConformResultsInUnitOfWork() || this.getDescriptor().shouldAlwaysConformResultsInUnitOfWork()) {
            return this.conformResult(result, unitOfWork, arguments, buildDirectlyFromRows);
        }
        Object clone = this.registerIndividualResult(result, unitOfWork, buildDirectlyFromRows, null);
        if (this.shouldUseWrapperPolicy()) {
            clone = this.getDescriptor().getObjectBuilder().wrapObject(clone, unitOfWork);
        }
        return clone;
    }

    public void setSelectionKey(Vector selectionKey) {
        this.selectionKey = selectionKey;
        this.setIsPrepared(false);
    }

    public void setSelectionObject(Object selectionObject) {
        if (selectionObject == null) {
            throw QueryException.selectionObjectCannotBeNull(this);
        }
        this.setSelectionKey(null);
        this.setReferenceClass(selectionObject.getClass());
        this.selectionObject = selectionObject;
    }

    public void setShouldLoadResultIntoSelectionObject(boolean shouldLoadResultIntoSelectionObject) {
        this.shouldLoadResultIntoSelectionObject = shouldLoadResultIntoSelectionObject;
    }

    public void setSingletonSelectionKey(Object selectionKey) {
        Vector<Object> key = new Vector<Object>();
        key.addElement(selectionKey);
        this.setSelectionKey(key);
    }

    public boolean shouldCheckCache() {
        return this.getCacheUsage() != 0;
    }

    public boolean shouldCheckCacheByExactPrimaryKey() {
        return this.getCacheUsage() == 1;
    }

    public boolean shouldCheckCacheByPrimaryKey() {
        return this.getCacheUsage() == 2 || this.getCacheUsage() == -1;
    }

    public boolean shouldCheckCacheThenDatabase() {
        return this.getCacheUsage() == 3;
    }

    public boolean shouldLoadResultIntoSelectionObject() {
        return this.shouldLoadResultIntoSelectionObject;
    }

    protected boolean hasNonDefaultFetchGroup() {
        return this.getDescriptor().hasFetchGroupManager() && (this.getFetchGroup() != null || this.getFetchGroupName() != null || !this.shouldUseDefaultFetchGroup());
    }
}

