/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform;

import groovyjarjarasm.asm.Opcodes;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassCodeExpressionTransformer;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.ForStatement;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;
import org.codehaus.groovy.syntax.SyntaxException;
import org.codehaus.groovy.transform.ASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;

@GroovyASTTransformation(phase=CompilePhase.CANONICALIZATION)
public class CategoryASTTransformation
implements ASTTransformation,
Opcodes {
    private static final VariableExpression THIS_EXPRESSION = new VariableExpression("$this");

    public void visit(ASTNode[] nodes, final SourceUnit source) {
        if (nodes.length != 2 || !(nodes[0] instanceof AnnotationNode) || !(nodes[1] instanceof ClassNode)) {
            throw new RuntimeException("Internal error: expecting [AnnotationNode, ClassNode] but got: " + Arrays.asList(nodes));
        }
        AnnotationNode annotation = (AnnotationNode)nodes[0];
        ClassNode parent = (ClassNode)nodes[1];
        ClassNode targetClass = this.getTargetClass(source, annotation);
        final LinkedList varStack = new LinkedList();
        HashSet<String> names = new HashSet<String>();
        for (FieldNode field : parent.getFields()) {
            names.add(field.getName());
        }
        varStack.add(names);
        ClassCodeExpressionTransformer expressionTransformer = new ClassCodeExpressionTransformer(){

            protected SourceUnit getSourceUnit() {
                return source;
            }

            public void visitMethod(MethodNode node) {
                Parameter[] params;
                HashSet<String> names = new HashSet<String>();
                names.addAll((Collection)varStack.getLast());
                for (Parameter param : params = node.getParameters()) {
                    names.add(param.getName());
                }
                varStack.add(names);
                super.visitMethod(node);
                varStack.removeLast();
            }

            public void visitBlockStatement(BlockStatement block) {
                HashSet names = new HashSet();
                names.addAll((Collection)varStack.getLast());
                varStack.add(names);
                super.visitBlockStatement(block);
                varStack.remove(names);
            }

            public void visitDeclarationExpression(DeclarationExpression expression) {
                ((Set)varStack.getLast()).add(expression.getVariableExpression().getName());
                super.visitDeclarationExpression(expression);
            }

            public void visitForLoop(ForStatement forLoop) {
                Expression exp = forLoop.getCollectionExpression();
                exp.visit(this);
                Parameter loopParam = forLoop.getVariable();
                if (loopParam != null) {
                    ((Set)varStack.getLast()).add(loopParam.getName());
                }
                super.visitForLoop(forLoop);
            }

            public void visitExpressionStatement(ExpressionStatement es) {
                Expression exp = es.getExpression();
                if (exp instanceof DeclarationExpression) {
                    exp.visit(this);
                }
                super.visitExpressionStatement(es);
            }

            public Expression transform(Expression exp) {
                VariableExpression vex;
                PropertyExpression pe;
                if (exp instanceof VariableExpression) {
                    VariableExpression ve = (VariableExpression)exp;
                    if (ve.getName().equals("this")) {
                        return THIS_EXPRESSION;
                    }
                    if (!((Set)varStack.getLast()).contains(ve.getName())) {
                        return new PropertyExpression((Expression)THIS_EXPRESSION, ve.getName());
                    }
                } else if (exp instanceof PropertyExpression && (pe = (PropertyExpression)exp).getObjectExpression() instanceof VariableExpression && (vex = (VariableExpression)pe.getObjectExpression()).isThisExpression()) {
                    pe.setObjectExpression(THIS_EXPRESSION);
                    return pe;
                }
                return super.transform(exp);
            }
        };
        for (MethodNode method : parent.getMethods()) {
            if (method.isStatic()) continue;
            method.setModifiers(method.getModifiers() | 8);
            Parameter[] origParams = method.getParameters();
            Parameter[] newParams = new Parameter[origParams.length + 1];
            newParams[0] = new Parameter(targetClass, "$this");
            System.arraycopy(origParams, 0, newParams, 1, origParams.length);
            method.setParameters(newParams);
            expressionTransformer.visitMethod(method);
        }
    }

    private ClassNode getTargetClass(SourceUnit source, AnnotationNode annotation) {
        Expression value = annotation.getMember("value");
        if (value == null || !(value instanceof ClassExpression)) {
            source.getErrorCollector().addErrorAndContinue(new SyntaxErrorMessage(new SyntaxException("@groovy.lang.Category must define 'value' which is the class to apply this category to", annotation.getLineNumber(), annotation.getColumnNumber()), source));
        }
        return value != null ? value.getType() : null;
    }
}

