/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.ui.service;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.JTextComponent;
import javax.swing.undo.UndoManager;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.websvc.wsitconf.ui.service.InputPanel;
import org.netbeans.modules.websvc.wsitconf.ui.service.subpanels.TargetsPanel;
import org.netbeans.modules.websvc.wsitconf.util.UndoCounter;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.PolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.ProfilesModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityPolicyModelHelper;
import org.netbeans.modules.xml.multiview.ui.SectionInnerPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.BindingFault;
import org.netbeans.modules.xml.wsdl.model.BindingOperation;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.xam.ComponentEvent;
import org.netbeans.modules.xml.xam.ComponentListener;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class FaultPanel
extends SectionInnerPanel {
    private WSDLModel model;
    private BindingOperation operation;
    private BindingFault fault;
    private Binding binding;
    private UndoManager undoManager;
    private JButton targetsButton;

    public FaultPanel(SectionView view, BindingFault fault, UndoManager undoManager) {
        super(view);
        this.model = fault.getModel();
        this.fault = fault;
        this.operation = (BindingOperation)fault.getParent();
        this.binding = (Binding)this.operation.getParent();
        this.undoManager = undoManager;
        this.initComponents();
        this.sync();
        this.model.addComponentListener(new ComponentListener(){

            public void valueChanged(ComponentEvent evt) {
                FaultPanel.this.sync();
            }

            public void childrenAdded(ComponentEvent evt) {
                FaultPanel.this.sync();
            }

            public void childrenDeleted(ComponentEvent evt) {
                FaultPanel.this.sync();
            }
        });
    }

    private void sync() {
        this.enableDisable();
    }

    public void setValue(JComponent source, Object value) {
    }

    public void documentChanged(JTextComponent comp, String value) {
        SectionView view = this.getSectionView();
        this.enableDisable();
        if (view != null) {
            view.getErrorPanel().clearError();
        }
    }

    public void rollbackValue(JTextComponent source) {
    }

    protected void endUIChange() {
    }

    public void linkButtonPressed(Object ddBean, String ddProperty) {
    }

    public JComponent getErrorComponent(String errorId) {
        return new JButton();
    }

    private void enableDisable() {
        boolean bSecurityEnabled = SecurityPolicyModelHelper.isSecurityEnabled((WSDLComponent)this.binding);
        boolean oSecurityEnabled = SecurityPolicyModelHelper.isSecurityEnabled((WSDLComponent)this.operation);
        String profile = null;
        if (bSecurityEnabled) {
            profile = ProfilesModelHelper.getSecurityProfile((WSDLComponent)this.binding);
        }
        boolean securityEnabled = bSecurityEnabled || oSecurityEnabled;
        this.targetsButton.setEnabled(securityEnabled && !ProfilesModelHelper.isSSLProfile(profile));
    }

    private void initComponents() {
        this.targetsButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.targetsButton, (String)NbBundle.getMessage(FaultPanel.class, (String)"LBL_SignEncrypt"));
        this.targetsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FaultPanel.this.targetsButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.targetsButton).addContainerGap(156, Short.MAX_VALUE)));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.targetsButton).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void targetsButtonActionPerformed(ActionEvent evt) {
        UndoCounter undoCounter = new UndoCounter();
        this.model.addUndoableEditListener((UndoableEditListener)undoCounter);
        TargetsPanel targetsPanel = new TargetsPanel((WSDLComponent)this.fault);
        DialogDescriptor dlgDesc = new DialogDescriptor((Object)targetsPanel, NbBundle.getMessage(InputPanel.class, (String)"LBL_Targets_Panel_Title"));
        Dialog dlg = DialogDisplayer.getDefault().createDialog(dlgDesc);
        dlg.setVisible(true);
        if (dlgDesc.getValue() == DialogDescriptor.CANCEL_OPTION) {
            for (int i = 0; i < undoCounter.getCounter(); ++i) {
                if (!this.undoManager.canUndo()) continue;
                this.undoManager.undo();
            }
        } else {
            SecurityPolicyModelHelper.getInstance(PolicyModelHelper.getConfigVersion((WSDLComponent)this.fault)).setTargets((WSDLComponent)this.fault, targetsPanel.getTargetsModel());
        }
        this.model.removeUndoableEditListener((UndoableEditListener)undoCounter);
    }
}

