/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.project;

import java.awt.EventQueue;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.javacard.project.JCProject;
import org.netbeans.spi.actions.Single;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.netbeans.spi.project.ui.support.NodeFactorySupport;
import org.netbeans.spi.project.ui.support.ProjectSensitiveActions;
import org.openide.ErrorManager;
import org.openide.actions.FindAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileStatusListener;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;

class JCLogicalViewProvider
implements LogicalViewProvider {
    private final RequestProcessor RP = new RequestProcessor("JavaCardPhysicalViewProvider.RP");
    private JCProject project;

    public JCLogicalViewProvider(JCProject project) {
        this.project = project;
    }

    public Node createLogicalView() {
        return new JavaCardLogicalViewRootNode();
    }

    public Node findPath(Node root, Object target) {
        Project project = (Project)root.getLookup().lookup(Project.class);
        if (project == null) {
            return null;
        }
        if (target instanceof FileObject) {
            FileObject fo = (FileObject)target;
            Project owner = FileOwnerQuery.getOwner((FileObject)fo);
            if (!project.equals(owner)) {
                return null;
            }
            for (Node n : root.getChildren().getNodes(true)) {
                Node result = PackageView.findPath((Node)n, (Object)target);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    private static final class ResolveAction
    extends Single<JCProject> {
        ResolveAction() {
            super(JCProject.class, NbBundle.getMessage(ResolveAction.class, (String)"RESOLVE_BROKEN_PLATFORM_ACTION"), null);
        }

        protected void actionPerformed(JCProject target) {
            target.showSelectPlatformAndDeviceDialog();
        }
    }

    private class JavaCardLogicalViewRootNode
    extends AbstractNode
    implements ChangeListener,
    PropertyChangeListener,
    FileStatusListener,
    Runnable {
        private Set<FileObject> files;
        private ChangeListener sourcesListener;
        private Map<FileSystem, FileStatusListener> fileSystemListeners;
        private Map<SourceGroup, PropertyChangeListener> groupsListeners;
        private RequestProcessor.Task task;
        private final Object privateLock;
        private boolean iconChange;
        private boolean nameChange;

        public JavaCardLogicalViewRootNode() {
            super(NodeFactorySupport.createCompositeChildren((Project)JCLogicalViewProvider.this.project, (String)JCLogicalViewProvider.this.project.kind().nodeFactoryPath()), Lookups.singleton((Object)JCLogicalViewProvider.this.project));
            this.privateLock = new Object();
            this.setIconBaseWithExtension(JCLogicalViewProvider.this.project.kind().iconPath());
            super.setName(ProjectUtils.getInformation((Project)JCLogicalViewProvider.this.project).getDisplayName());
            this.setProjectFiles(JCLogicalViewProvider.this.project);
            JCLogicalViewProvider.this.project.addChangeListener(this);
        }

        public String getHtmlDisplayName() {
            if (JCLogicalViewProvider.this.project.isBadPlatformOrCard()) {
                return "<font color='!nb.errorForeground'>" + this.getDisplayName();
            }
            return null;
        }

        public Image getIcon(int type) {
            Image result = super.getIcon(type);
            if (JCLogicalViewProvider.this.project.isBadPlatformOrCard()) {
                Image brokenProjectBadge = ImageUtilities.loadImage((String)"org/netbeans/modules/javacard/resources/brokenProjectBadge.png");
                result = ImageUtilities.mergeImages((Image)result, (Image)brokenProjectBadge, (int)8, (int)0);
            }
            return result;
        }

        public Action[] getActions(boolean context) {
            return this.getAdditionalActions();
        }

        final void setProjectFiles(Project project) {
            Sources sources = ProjectUtils.getSources((Project)project);
            if (this.sourcesListener == null) {
                this.sourcesListener = WeakListeners.change((ChangeListener)this, (Object)sources);
                sources.addChangeListener(this.sourcesListener);
            }
            this.setGroups(Arrays.asList(sources.getSourceGroups("generic")));
        }

        private Action[] getAdditionalActions() {
            ResourceBundle bundle = NbBundle.getBundle(JCLogicalViewProvider.class);
            ArrayList<Object> actions = new ArrayList<Object>();
            actions.add(CommonProjectActions.newFileAction());
            actions.add(null);
            actions.add(ProjectSensitiveActions.projectCommandAction((String)"build", (String)bundle.getString("LBL_BuildAction_Name"), null));
            actions.add(ProjectSensitiveActions.projectCommandAction((String)"rebuild", (String)bundle.getString("LBL_ReBuildAction_Name"), null));
            actions.add(ProjectSensitiveActions.projectCommandAction((String)"clean", (String)bundle.getString("LBL_CleanAction_Name"), null));
            actions.add(null);
            actions.add(ProjectSensitiveActions.projectCommandAction((String)"JCLoad", (String)bundle.getString("LBL_JCLoad_Action_Name"), null));
            if (JCLogicalViewProvider.this.project.kind().isApplication()) {
                actions.add(ProjectSensitiveActions.projectCommandAction((String)"JCCreate", (String)bundle.getString("LBL_JCCreate_Action_Name"), null));
                actions.add(ProjectSensitiveActions.projectCommandAction((String)"JCDelete", (String)bundle.getString("LBL_JCDelete_Action_Name"), null));
            }
            actions.add(ProjectSensitiveActions.projectCommandAction((String)"JCUnload", (String)bundle.getString("LBL_JCUnload_Action_Name"), null));
            actions.add(null);
            if (JCLogicalViewProvider.this.project.kind().isClassic()) {
                actions.add(ProjectSensitiveActions.projectCommandAction((String)"JCGenProxy", (String)bundle.getString("LBL_JCGenProxy_Action_Name"), null));
                actions.add(null);
            }
            if (!JCLogicalViewProvider.this.project.kind().isLibrary()) {
                actions.add(ProjectSensitiveActions.projectCommandAction((String)"run", (String)bundle.getString("LBL_RunAction_Name"), null));
                actions.add(ProjectSensitiveActions.projectCommandAction((String)"debug", (String)bundle.getString("LBL_DebugAction_Name"), null));
            }
            actions.add(null);
            actions.add(CommonProjectActions.setAsMainProjectAction());
            actions.add(CommonProjectActions.closeProjectAction());
            actions.add(null);
            actions.add(CommonProjectActions.renameProjectAction());
            actions.add(CommonProjectActions.moveProjectAction());
            actions.add(CommonProjectActions.copyProjectAction());
            actions.add(CommonProjectActions.deleteProjectAction());
            actions.add(null);
            actions.add(SystemAction.get(FindAction.class));
            if (JCLogicalViewProvider.this.project.isBadPlatformOrCard()) {
                actions.add((Object)new ResolveAction());
            }
            actions.add(null);
            actions.add(CommonProjectActions.customizeProjectAction());
            return actions.toArray(new Action[actions.size()]);
        }

        private final void setGroups(Collection<SourceGroup> groups) {
            if (this.groupsListeners != null) {
                for (Map.Entry<SourceGroup, PropertyChangeListener> e : this.groupsListeners.entrySet()) {
                    e.getKey().removePropertyChangeListener(e.getValue());
                }
            }
            this.groupsListeners = new HashMap<SourceGroup, PropertyChangeListener>();
            HashSet<FileObject> roots = new HashSet<FileObject>();
            for (SourceGroup group : groups) {
                PropertyChangeListener pcl = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)group);
                this.groupsListeners.put(group, pcl);
                group.addPropertyChangeListener(pcl);
                FileObject fo = group.getRootFolder();
                roots.add(fo);
            }
            this.setFiles(roots);
        }

        final void setFiles(Set<FileObject> files) {
            if (this.fileSystemListeners != null) {
                for (Map.Entry<FileSystem, FileStatusListener> e : this.fileSystemListeners.entrySet()) {
                    e.getKey().removeFileStatusListener(e.getValue());
                }
            }
            this.fileSystemListeners = new HashMap<FileSystem, FileStatusListener>();
            this.files = files;
            if (files == null) {
                return;
            }
            HashSet<FileSystem> hookedFileSystems = new HashSet<FileSystem>();
            for (FileObject fo : files) {
                try {
                    FileSystem fs = fo.getFileSystem();
                    if (hookedFileSystems.contains(fs)) continue;
                    hookedFileSystems.add(fs);
                    FileStatusListener fsl = FileUtil.weakFileStatusListener((FileStatusListener)this, (Object)fs);
                    fs.addFileStatusListener(fsl);
                    this.fileSystemListeners.put(fs, fsl);
                }
                catch (FileStateInvalidException e) {
                    ErrorManager err = ErrorManager.getDefault();
                    err.annotate((Throwable)e, 0, "Cannot get " + fo + " filesystem, ignoring...", null, null, null);
                    err.notify(1, (Throwable)e);
                }
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() instanceof SourceGroup) {
                this.setProjectFiles(JCLogicalViewProvider.this.project);
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (e.getSource() instanceof Sources) {
                JCLogicalViewProvider.this.RP.post(new Runnable(){

                    @Override
                    public void run() {
                        JavaCardLogicalViewRootNode.this.setProjectFiles(JCLogicalViewProvider.this.project);
                    }
                });
            } else if (e.getSource() instanceof JCProject) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JavaCardLogicalViewRootNode.this.fireIconChange();
                        JavaCardLogicalViewRootNode.this.fireDisplayNameChange(null, JavaCardLogicalViewRootNode.this.getDisplayName());
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void annotationChanged(FileStatusEvent event) {
            if (this.task == null) {
                this.task = JCLogicalViewProvider.this.RP.create((Runnable)this);
            }
            Object object = this.privateLock;
            synchronized (object) {
                if (!this.iconChange && event.isIconChange() || !this.nameChange && event.isNameChange()) {
                    for (FileObject fo : this.files) {
                        if (!event.hasChanged(fo)) continue;
                        this.iconChange |= event.isIconChange();
                        this.nameChange |= event.isNameChange();
                    }
                }
            }
            this.task.schedule(100);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean fireName;
            boolean fireIcon;
            Object object = this.privateLock;
            synchronized (object) {
                fireIcon = this.iconChange;
                fireName = this.nameChange;
                this.iconChange = false;
                this.nameChange = false;
            }
            if (fireIcon) {
                this.fireIconChange();
                this.fireOpenedIconChange();
            }
            if (fireName) {
                this.fireDisplayNameChange(null, null);
            }
        }
    }
}

