/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.jackpot.spi.HintContext;
import org.netbeans.modules.java.hints.jackpot.spi.support.ErrorDescriptionFactory;
import org.netbeans.modules.java.hints.spi.support.FixFactory;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public final class NoLoggers {
    public static Iterable<ErrorDescription> checkNoLoggers(HintContext hintContext) {
        Element element = hintContext.getInfo().getTrees().getElement(hintContext.getPath());
        if (element == null || element.getKind() != ElementKind.CLASS || element.getModifiers().contains((Object)Modifier.ABSTRACT) || element.getEnclosingElement() != null && element.getEnclosingElement().getKind() != ElementKind.PACKAGE) {
            return null;
        }
        TypeElement typeElement = hintContext.getInfo().getElements().getTypeElement("java.util.logging.Logger");
        if (typeElement == null) {
            return null;
        }
        TypeMirror typeMirror = typeElement.asType();
        if (typeMirror == null || typeMirror.getKind() != TypeKind.DECLARED) {
            return null;
        }
        LinkedList<VariableElement> linkedList = new LinkedList<VariableElement>();
        List<VariableElement> list = ElementFilter.fieldsIn(element.getEnclosedElements());
        for (VariableElement variableElement : list) {
            if (variableElement.getKind() != ElementKind.FIELD || !((Object)variableElement.asType()).equals(typeMirror)) continue;
            linkedList.add(variableElement);
        }
        if (linkedList.size() == 0) {
            return Collections.singleton(ErrorDescriptionFactory.forName(hintContext, hintContext.getPath(), NbBundle.getMessage(NoLoggers.class, (String)"MSG_NoLoggers_checkNoLoggers", (Object)element), new NoLoggersFix(NbBundle.getMessage(NoLoggers.class, (String)"MSG_NoLoggers_checkNoLoggers_Fix", (Object)element), TreePathHandle.create((Element)element, (CompilationInfo)hintContext.getInfo())), FixFactory.createSuppressWarningsFix(hintContext.getInfo(), hintContext.getPath(), "ClassWithoutLogger")));
        }
        return null;
    }

    private static final class NoLoggersFix
    implements Fix {
        private final String description;
        private final TreePathHandle loggerFieldHandle;

        public NoLoggersFix(String string, TreePathHandle treePathHandle) {
            this.description = string;
            this.loggerFieldHandle = treePathHandle;
        }

        public String getText() {
            return this.description;
        }

        public ChangeInfo implement() throws Exception {
            JavaSource.forFileObject((FileObject)this.loggerFieldHandle.getFileObject()).runModificationTask((Task)new Task<WorkingCopy>(){

                public void run(WorkingCopy workingCopy) throws Exception {
                    Object object;
                    workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                    TreePath treePath = NoLoggersFix.this.loggerFieldHandle.resolve((CompilationInfo)workingCopy);
                    if (treePath == null) {
                        return;
                    }
                    TreeMaker treeMaker = workingCopy.getTreeMaker();
                    ClassTree classTree = (ClassTree)treePath.getLeaf();
                    Element element = workingCopy.getTrees().getElement(treePath);
                    String string = null;
                    List<VariableElement> list = ElementFilter.fieldsIn(element.getEnclosedElements());
                    if (!NoLoggersFix.contains(list, "LOG")) {
                        string = "LOG";
                    } else if (!NoLoggersFix.contains(list, "LOGGER")) {
                        string = "LOGGER";
                    } else {
                        for (int i = 1; i < Integer.MAX_VALUE; ++i) {
                            object = "LOG" + i;
                            if (NoLoggersFix.contains(list, (String)object)) continue;
                            string = object;
                            break;
                        }
                    }
                    if (string == null) {
                        return;
                    }
                    HashSet<Modifier> hashSet = new HashSet<Modifier>();
                    hashSet.add(Modifier.PRIVATE);
                    hashSet.add(Modifier.STATIC);
                    hashSet.add(Modifier.FINAL);
                    object = treeMaker.Modifiers(hashSet);
                    TypeElement typeElement = workingCopy.getElements().getTypeElement("java.util.logging.Logger");
                    ExpressionTree expressionTree = treeMaker.QualIdent((Element)typeElement);
                    MemberSelectTree memberSelectTree = treeMaker.MemberSelect(expressionTree, (CharSequence)"getLogger");
                    MethodInvocationTree methodInvocationTree = treeMaker.MethodInvocation(Collections.emptyList(), (ExpressionTree)memberSelectTree, Collections.singletonList(treeMaker.MethodInvocation(Collections.emptyList(), (ExpressionTree)treeMaker.MemberSelect(treeMaker.QualIdent(element), (CharSequence)"class.getName"), Collections.emptyList())));
                    VariableTree variableTree = treeMaker.Variable((ModifiersTree)object, (CharSequence)string, (Tree)expressionTree, (ExpressionTree)methodInvocationTree);
                    ClassTree classTree2 = treeMaker.addClassMember(classTree, (Tree)variableTree);
                    workingCopy.rewrite((Tree)classTree, (Tree)classTree2);
                }
            }).commit();
            return null;
        }

        private static boolean contains(Collection<VariableElement> collection, String string) {
            for (VariableElement variableElement : collection) {
                if (!variableElement.getSimpleName().contentEquals(string)) continue;
                return true;
            }
            return false;
        }
    }
}

