/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.queries;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.queries.BinaryForSourceQuery;
import org.netbeans.modules.java.api.common.SourceRoots;
import org.netbeans.spi.java.queries.BinaryForSourceQueryImplementation;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;

final class BinaryForSourceQueryImpl
implements BinaryForSourceQueryImplementation {
    private final Map<URL, BinaryForSourceQuery.Result> cache = new HashMap<URL, BinaryForSourceQuery.Result>();
    private final SourceRoots src;
    private final SourceRoots test;
    private final PropertyEvaluator eval;
    private final AntProjectHelper helper;
    private String[] sourceProps;
    private String[] testProps;

    BinaryForSourceQueryImpl(SourceRoots src, SourceRoots test, AntProjectHelper helper, PropertyEvaluator eval, String[] sourceProps, String[] testProps) {
        assert (src != null);
        assert (test != null);
        assert (helper != null);
        assert (eval != null);
        assert (sourceProps != null && sourceProps.length > 0);
        assert (testProps != null && testProps.length > 0);
        this.src = src;
        this.test = test;
        this.eval = eval;
        this.helper = helper;
        this.sourceProps = sourceProps;
        this.testProps = testProps;
    }

    public BinaryForSourceQuery.Result findBinaryRoots(URL sourceRoot) {
        assert (sourceRoot != null);
        BinaryForSourceQuery.Result result = this.cache.get(sourceRoot);
        if (result == null) {
            for (URL root : this.src.getRootURLs()) {
                if (!root.equals(sourceRoot)) continue;
                result = new R(this.sourceProps);
                this.cache.put(sourceRoot, result);
                return result;
            }
            for (URL root : this.test.getRootURLs()) {
                if (!root.equals(sourceRoot)) continue;
                result = new R(this.testProps);
                this.cache.put(sourceRoot, result);
                return result;
            }
            String buildGeneratedDirS = this.eval.getProperty("build.generated.sources.dir");
            if (buildGeneratedDirS != null) {
                String parent = this.helper.resolveFile(buildGeneratedDirS).toURI().toString();
                if (sourceRoot.toString().startsWith(parent)) {
                    result = new R(this.sourceProps);
                    this.cache.put(sourceRoot, result);
                    return result;
                }
            }
        }
        return result;
    }

    class R
    implements BinaryForSourceQuery.Result,
    PropertyChangeListener {
        private final String[] propNames;
        private final ChangeSupport changeSupport = new ChangeSupport((Object)this);

        R(String[] propNames) {
            assert (propNames != null && propNames.length > 0);
            this.propNames = propNames;
            BinaryForSourceQueryImpl.this.eval.addPropertyChangeListener((PropertyChangeListener)this);
        }

        public URL[] getRoots() {
            ArrayList<URL> urls = new ArrayList<URL>();
            for (String propName : this.propNames) {
                String val = BinaryForSourceQueryImpl.this.eval.getProperty(propName);
                if (val == null) continue;
                urls.add(FileUtil.urlForArchiveOrDir((File)BinaryForSourceQueryImpl.this.helper.resolveFile(val)));
            }
            return urls.toArray(new URL[urls.size()]);
        }

        public void addChangeListener(ChangeListener l) {
            assert (l != null);
            this.changeSupport.addChangeListener(l);
        }

        public void removeChangeListener(ChangeListener l) {
            assert (l != null);
            this.changeSupport.removeChangeListener(l);
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            this.changeSupport.fireChange();
        }
    }
}

