/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.cpu;

import java.text.NumberFormat;
import org.netbeans.lib.profiler.results.CCTNode;
import org.netbeans.lib.profiler.results.ExportDataDumper;
import org.netbeans.lib.profiler.results.cpu.CPUCCTContainer;
import org.netbeans.lib.profiler.results.cpu.PrestimeCPUCCTNode;

public class PrestimeCPUCCTNodeBacked
extends PrestimeCPUCCTNode {
    private static NumberFormat percentFormat = null;
    protected int compactDataOfs;
    protected int nChildren;

    public PrestimeCPUCCTNodeBacked(CPUCCTContainer container, PrestimeCPUCCTNode parent, int compactDataOfs) {
        super(container, parent);
        this.compactDataOfs = compactDataOfs;
        this.container = container;
        this.nChildren = container.getNChildrenForNodeOfs(compactDataOfs);
    }

    protected PrestimeCPUCCTNodeBacked(CPUCCTContainer container, PrestimeCPUCCTNode[] children) {
        super(container, null);
        this.setThreadNode();
        this.children = children;
        this.nChildren = children.length;
        for (int i = 0; i < this.nChildren; ++i) {
            children[i].parent = this;
        }
    }

    protected PrestimeCPUCCTNodeBacked() {
    }

    @Override
    public CCTNode getChild(int index) {
        this.getChildren();
        if (index < this.children.length) {
            return this.children[index];
        }
        return null;
    }

    @Override
    public CCTNode[] getChildren() {
        if (this.nChildren == 0) {
            return null;
        }
        if (this.children != null) {
            return this.children;
        }
        int addChild = this.isThreadNode() ? 0 : 1;
        this.children = new PrestimeCPUCCTNode[this.nChildren + addChild];
        for (int i = 0; i < this.nChildren; ++i) {
            int dataOfs = this.container.getChildOfsForNodeOfs(this.compactDataOfs, i);
            this.children[i + addChild] = new PrestimeCPUCCTNodeBacked(this.container, this, dataOfs);
        }
        if (addChild > 0) {
            this.children[0] = this.createSelfTimeNodeForThisNode();
            ++this.nChildren;
        }
        this.sortChildren(this.container.getCPUResSnapshot().getSortBy(), this.container.getCPUResSnapshot().getSortOrder());
        return this.children;
    }

    @Override
    public int getMethodId() {
        return this.container.getMethodIdForNodeOfs(this.compactDataOfs);
    }

    @Override
    public int getNCalls() {
        return this.container.getNCallsForNodeOfs(this.compactDataOfs);
    }

    @Override
    public int getNChildren() {
        if (this.children == null) {
            int addChild = this.nChildren > 0 ? (this.isThreadNode() ? 0 : 1) : 0;
            return this.nChildren + addChild;
        }
        return this.nChildren;
    }

    @Override
    public long getSleepTime0() {
        return this.container.getSleepTime0ForNodeOfs(this.compactDataOfs);
    }

    @Override
    public int getThreadId() {
        return this.container.getThreadId();
    }

    @Override
    public long getTotalTime0() {
        if (!this.isSelfTimeNode()) {
            return this.container.getTotalTime0ForNodeOfs(this.compactDataOfs);
        }
        return this.container.getSelfTime0ForNodeOfs(this.compactDataOfs);
    }

    @Override
    public float getTotalTime0InPerCent() {
        float result = (float)(this.container.getWholeGraphNetTime0() > 0L ? (double)this.getTotalTime0() / (double)this.container.getWholeGraphNetTime0() * 100.0 : 0.0);
        return result < 100.0f ? result : 100.0f;
    }

    @Override
    public long getTotalTime1() {
        if (!this.isSelfTimeNode()) {
            return this.container.getTotalTime1ForNodeOfs(this.compactDataOfs);
        }
        return this.container.getSelfTime1ForNodeOfs(this.compactDataOfs);
    }

    @Override
    public float getTotalTime1InPerCent() {
        return (float)(this.container.getWholeGraphNetTime1() > 0L ? (double)this.getTotalTime1() / (double)this.container.getWholeGraphNetTime1() * 100.0 : 0.0);
    }

    @Override
    public long getWaitTime0() {
        return this.container.getWaitTime0ForNodeOfs(this.compactDataOfs);
    }

    @Override
    public void sortChildren(int sortBy, boolean sortOrder) {
        this.container.getCPUResSnapshot().saveSortParams(sortBy, sortOrder);
        if (this.nChildren == 0 || this.children == null) {
            return;
        }
        this.doSortChildren(sortBy, sortOrder);
    }

    protected PrestimeCPUCCTNode createSelfTimeNodeForThisNode() {
        PrestimeCPUCCTNodeBacked selfTimeChild = new PrestimeCPUCCTNodeBacked();
        selfTimeChild.setSelfTimeNode();
        selfTimeChild.compactDataOfs = this.compactDataOfs;
        selfTimeChild.container = this.container;
        selfTimeChild.parent = this;
        return selfTimeChild;
    }

    public void exportXMLData(ExportDataDumper eDD, String indent) {
        String newline = System.getProperty("line.separator");
        StringBuffer result = new StringBuffer(indent + "<node>" + newline);
        result.append(indent + " <Name>" + this.replaceHTMLCharacters(this.getNodeName()) + "</Name>" + newline);
        result.append(indent + " <Parent>" + this.replaceHTMLCharacters(this.getParent() == null ? "none" : ((PrestimeCPUCCTNodeBacked)this.getParent()).getNodeName()) + "</Parent>" + newline);
        result.append(indent + " <Time_Relative>" + percentFormat.format((double)this.getTotalTime0InPerCent() / 100.0) + "</Time_Relative>" + newline);
        result.append(indent + " <Time>" + this.getTotalTime0() + "</Time>" + newline);
        result.append(indent + " <Invocations>" + this.getNCalls() + "</Invocations>" + newline);
        eDD.dumpData(result);
        if (this.children != null) {
            for (int i = 0; i < this.nChildren; ++i) {
                ((PrestimeCPUCCTNodeBacked)this.children[i]).exportXMLData(eDD, indent + "  ");
            }
        } else if (this.nChildren > 0) {
            int tempNChildren = this.nChildren;
            PrestimeCPUCCTNode[] tempChildren = (PrestimeCPUCCTNode[])this.getChildren();
            this.children = null;
            for (int i = 0; i < this.nChildren; ++i) {
                ((PrestimeCPUCCTNodeBacked)tempChildren[i]).exportXMLData(eDD, indent + "  ");
            }
            tempChildren = null;
            this.nChildren = tempNChildren;
        }
        result = new StringBuffer(indent + "</node>");
        eDD.dumpData(result);
    }

    public void exportHTMLData(ExportDataDumper eDD, int depth) {
        int i;
        StringBuffer result = new StringBuffer("<tr><td class=\"method\"><pre class=\"method\">.");
        for (i = 0; i < depth; ++i) {
            result.append(".");
        }
        result.append(this.replaceHTMLCharacters(this.getNodeName()) + "</pre></td><td class=\"right\">" + percentFormat.format((double)this.getTotalTime0InPerCent() / 100.0) + "</td><td class=\"right\">" + this.getTotalTime0() + "</td><td class=\"right\">" + this.getNCalls() + "</td></tr>");
        eDD.dumpData(result);
        if (this.children != null) {
            for (i = 0; i < this.nChildren; ++i) {
                ((PrestimeCPUCCTNodeBacked)this.children[i]).exportHTMLData(eDD, depth + 1);
            }
        } else if (this.nChildren > 0) {
            int tempNChildren = this.nChildren;
            PrestimeCPUCCTNode[] tempChildren = (PrestimeCPUCCTNode[])this.getChildren();
            this.children = null;
            for (int i2 = 0; i2 < this.nChildren; ++i2) {
                ((PrestimeCPUCCTNodeBacked)tempChildren[i2]).exportHTMLData(eDD, depth + 1);
            }
            tempChildren = null;
            this.nChildren = tempNChildren;
        }
    }

    private String replaceHTMLCharacters(String s) {
        StringBuffer sb = new StringBuffer();
        int len = s.length();
        block6: for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    continue block6;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block6;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block6;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public void exportCSVData(String separator, int depth, ExportDataDumper eDD) {
        int i;
        StringBuffer result = new StringBuffer();
        String newLine = "\r\n";
        String quote = "\"";
        String indent = " ";
        result.append(quote);
        for (i = 0; i < depth; ++i) {
            result.append(indent);
        }
        result.append(this.getNodeName() + quote + separator);
        result.append(quote + this.getTotalTime0InPerCent() + quote + separator);
        result.append(quote + this.getTotalTime0() + quote + separator);
        result.append(quote + this.getNCalls() + quote + newLine);
        eDD.dumpData(result);
        if (this.children != null) {
            for (i = 0; i < this.nChildren; ++i) {
                ((PrestimeCPUCCTNodeBacked)this.children[i]).exportCSVData(separator, depth + 1, eDD);
            }
        } else if (this.nChildren > 0) {
            int tempNChildren = this.nChildren;
            PrestimeCPUCCTNode[] tempChildren = (PrestimeCPUCCTNode[])this.getChildren();
            this.children = null;
            for (int i2 = 0; i2 < this.nChildren; ++i2) {
                ((PrestimeCPUCCTNodeBacked)tempChildren[i2]).exportCSVData(separator, depth + 1, eDD);
            }
            tempChildren = null;
            this.nChildren = tempNChildren;
        }
    }

    public static void setPercentFormat(NumberFormat percentFormat) {
        PrestimeCPUCCTNodeBacked.percentFormat = percentFormat;
    }
}

