/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.model;

import com.sun.perseus.model.DocumentNode;
import com.sun.perseus.model.ElementNode;
import com.sun.perseus.model.Font;
import com.sun.perseus.model.Glyph;
import com.sun.perseus.model.ModelNode;
import org.w3c.dom.DOMException;

public class FontFace
extends ElementNode {
    public static final int FONT_WEIGHT_ALL = 511;
    public static final int FONT_STYLE_ALL = 7;
    public static final float UNITS_PER_EM_DEFAULT = 1000.0f;
    public static final float[] FONT_SIZE_ALL = null;
    protected String[] fontFamilies;
    protected int fontStyles = 7;
    protected int fontWeights = 511;
    protected float[] fontSizes;
    protected float unitsPerEm = 1000.0f;
    protected Font font;
    protected float emSquareScale = 1.0f;

    public String getLocalName() {
        return "font-face";
    }

    public ElementNode newInstance(DocumentNode doc) {
        return new FontFace(doc);
    }

    public void setFontFamilies(String[] newFontFamilies) {
        if (FontFace.equal(this.fontFamilies, newFontFamilies)) {
            return;
        }
        this.modifyingNode();
        this.fontFamilies = newFontFamilies;
        this.modifiedNode();
    }

    public String[] getFontFamilies() {
        return this.fontFamilies;
    }

    public void setFontStyles(int newFontStyles) {
        if (newFontStyles == this.fontStyles) {
            return;
        }
        this.modifyingNode();
        this.fontStyles = newFontStyles;
        this.modifiedNode();
    }

    public int getFontStyles() {
        return this.fontStyles;
    }

    public void setFontSizes(float[] newFontSizes) {
        if (FontFace.equal(newFontSizes, this.fontSizes)) {
            return;
        }
        this.modifyingNode();
        this.fontSizes = newFontSizes;
        this.modifiedNode();
    }

    public float[] getFontSizes() {
        return this.fontSizes;
    }

    public int getFontWeights() {
        return this.fontWeights;
    }

    public void setFontWeights(int newFontWeights) {
        if (newFontWeights == this.fontWeights) {
            return;
        }
        this.modifyingNode();
        this.fontWeights = newFontWeights;
        this.modifiedNode();
    }

    public void setUnitsPerEm(float newUnitsPerEm) {
        if (newUnitsPerEm == this.unitsPerEm) {
            return;
        }
        this.modifyingNode();
        this.unitsPerEm = newUnitsPerEm;
        this.computeEmSquareScale();
        this.modifiedNode();
    }

    public float getUnitsPerEm() {
        return this.unitsPerEm;
    }

    public FontFace(DocumentNode ownerDocument) {
        super(ownerDocument);
        this.computeEmSquareScale();
    }

    public float getEmSquareScale() {
        return this.emSquareScale;
    }

    protected void computeEmSquareScale() {
        this.emSquareScale = 1.0f / this.unitsPerEm;
    }

    public void setParent(ModelNode parent) {
        super.setParent(parent);
        this.font = parent instanceof Font ? (Font)parent : null;
    }

    Glyph canDisplay(char[] s, int index) {
        return this.font.canDisplay(s, index);
    }

    Glyph getMissingGlyph() {
        return this.font.getMissingGlyph();
    }

    public int fontWeightDistance(int refFontWeight) {
        if (this.fontWeights == 511) {
            return 0;
        }
        if ((this.fontWeights & refFontWeight) != 0) {
            return 0;
        }
        int dA = this.fontWeights;
        int i = 0;
        while ((dA & 1) == 0) {
            dA >>= 1;
            ++i;
        }
        dA = i;
        i = 0;
        int curD = 100;
        int d = 100;
        for (i = 0; i < 9; ++i) {
            if ((refFontWeight >> i & 1) == 0 || (d = (dA - i) * (dA - i)) >= curD) continue;
            curD = d;
        }
        return curD;
    }

    boolean supportsTrait(String traitName) {
        if ("font-family" == traitName || "font-style" == traitName || "font-weight" == traitName || "font-size" == traitName || "units-per-em" == traitName) {
            return true;
        }
        return super.supportsTrait(traitName);
    }

    public String getTraitImpl(String name) throws DOMException {
        if ("font-family" == name) {
            return this.toStringTraitQuote(this.getFontFamilies());
        }
        if ("font-style" == name) {
            return this.fontStylesToStringTrait(this.getFontStyles());
        }
        if ("font-weight" == name) {
            return this.fontWeightsToStringTrait(this.getFontWeights());
        }
        if ("font-size" == name) {
            if (this.getFontSizes() == FONT_SIZE_ALL) {
                return "all";
            }
            return this.toStringTrait(this.getFontSizes());
        }
        if ("units-per-em" == name) {
            return Float.toString(this.getUnitsPerEm());
        }
        return super.getTraitImpl(name);
    }

    public void setTraitImpl(String name, String value) throws DOMException {
        if ("font-family" == name) {
            this.checkWriteLoading(name);
            this.setFontFamilies(this.parseFontFamilyTrait(name, value));
        } else if ("font-style" == name) {
            this.checkWriteLoading(name);
            this.setFontStyles(this.parseFontStylesTrait(name, value));
        } else if ("font-weight" == name) {
            this.checkWriteLoading(name);
            this.setFontWeights(this.parseFontWeightsTrait(name, value));
        } else if ("font-size" == name) {
            this.checkWriteLoading(name);
            if ("all".equals(value)) {
                this.setFontSizes(FONT_SIZE_ALL);
            } else {
                this.setFontSizes(this.parseFloatArrayTrait(name, value));
            }
        } else if ("units-per-em" == name) {
            this.checkWriteLoading(name);
            this.setUnitsPerEm(this.parseFloatTrait(name, value));
        } else {
            super.setTraitImpl(name, value);
        }
    }

    static class Match {
        public FontFace fontFace;
        public int distance;
        public Match next;

        public Match(FontFace fontFace) {
            this.fontFace = fontFace;
        }
    }
}

