/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.indexer.api;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.netbeans.modules.maven.indexer.api.RepositoryInfo;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbPreferences;

public final class RepositoryPreferences {
    private static RepositoryPreferences instance;
    public static final String LOCAL_REPO_ID = "local";
    public static final String TYPE_NEXUS = "nexus";
    static final String KEY_TYPE = "provider";
    static final String KEY_DISPLAY_NAME = "displayName";
    static final String KEY_PATH = "path";
    static final String KEY_INDEX_URL = "repoIndexUrl";
    static final String KEY_REPO_URL = "repoUrl";
    public static final String PROP_INDEX_FREQ = "indexUpdateFrequency";
    public static final String PROP_LAST_INDEX_UPDATE = "lastIndexUpdate";
    public static final String PROP_SNAPSHOTS = "includeSnapshots";
    public static final int FREQ_ONCE_WEEK = 0;
    public static final int FREQ_ONCE_DAY = 1;
    public static final int FREQ_STARTUP = 2;
    public static final int FREQ_NEVER = 3;
    private final Map<FileObject, RepositoryInfo> infoCache = new TreeMap<FileObject, RepositoryInfo>(new Comp());
    private static final String REPO_FOLDER = "Projects/org-netbeans-modules-maven/Repositories";
    private static final char[] forbiddenChars;
    private static final char replaceChar = '-';

    private RepositoryPreferences() {
    }

    private Preferences getPreferences() {
        return NbPreferences.root().node("org/netbeans/modules/maven/nexus/indexing");
    }

    private FileObject getRepoFolder() {
        FileObject repo = FileUtil.getConfigFile((String)REPO_FOLDER);
        if (repo == null) {
            Logger.getLogger(RepositoryPreferences.class.getName()).warning("Maven Repository root folder Projects/org-netbeans-modules-maven/Repositories was deleted somehow, creating dummy (empty) one.");
            try {
                repo = FileUtil.createFolder((FileObject)FileUtil.getConfigRoot(), (String)REPO_FOLDER);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return repo;
    }

    public static synchronized RepositoryPreferences getInstance() {
        if (instance == null) {
            instance = new RepositoryPreferences();
        }
        return instance;
    }

    public RepositoryInfo getRepositoryInfoById(String id) {
        for (RepositoryInfo ri : this.getRepositoryInfos()) {
            if (!ri.getId().equals(id)) continue;
            return ri;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RepositoryInfo> getRepositoryInfos() {
        FileObject repoFolder = this.getRepoFolder();
        ArrayList<RepositoryInfo> toRet = new ArrayList<RepositoryInfo>();
        if (repoFolder != null) {
            Map<FileObject, RepositoryInfo> map = this.infoCache;
            synchronized (map) {
                for (FileObject fo : repoFolder.getChildren()) {
                    if (this.infoCache.containsKey(fo)) continue;
                    RepositoryInfo ri = RepositoryInfo.createRepositoryInfo(fo);
                    this.infoCache.put(fo, ri);
                }
                HashSet<FileObject> gone = new HashSet<FileObject>(this.infoCache.keySet());
                gone.removeAll(Arrays.asList(repoFolder.getChildren()));
                for (FileObject g : gone) {
                    this.infoCache.remove(g);
                }
                toRet.addAll(this.infoCache.values());
            }
        }
        return toRet;
    }

    public Set<String> getKnownRepositoryUrls() {
        HashSet<String> urls = new HashSet<String>();
        for (RepositoryInfo ri : this.getRepositoryInfos()) {
            if (ri.getRepositoryUrl() == null) continue;
            urls.add(ri.getRepositoryUrl());
        }
        urls.add("http://repo1.maven.org/maven2");
        urls.add("http://download.java.net/maven/2");
        urls.add("http://download.java.net/maven/1");
        urls.add("http://download.java.net/maven/glassfish");
        return urls;
    }

    public synchronized void addOrModifyRepositoryInfo(RepositoryInfo info) {
        try {
            FileObject fo = this.getRepoFolder().getFileObject(this.getFileObjectName(info.getId()));
            if (fo == null) {
                int position = this.calculatePosition();
                fo = this.getRepoFolder().createData(this.getFileObjectName(info.getId()));
                fo.setAttribute("position", (Object)position);
            } else if (this.infoCache.containsKey(fo)) {
                this.infoCache.put(fo, info);
            }
            fo.setAttribute(KEY_TYPE, (Object)info.getType());
            fo.setAttribute(KEY_DISPLAY_NAME, (Object)info.getName());
            if (info.getRepositoryPath() != null) {
                fo.setAttribute(KEY_PATH, (Object)info.getRepositoryPath());
            }
            if (info.getRepositoryUrl() != null) {
                fo.setAttribute(KEY_REPO_URL, (Object)info.getRepositoryUrl());
                fo.setAttribute(KEY_INDEX_URL, (Object)info.getIndexUpdateUrl());
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private int calculatePosition() {
        int customStart = 5000;
        for (FileObject fo : this.getRepoFolder().getChildren()) {
            Integer attr = (Integer)fo.getAttribute("position");
            if (attr == null || attr <= customStart) continue;
            customStart = attr;
        }
        return customStart + 1;
    }

    private String getFileObjectName(String id) {
        char[] chars = id.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            for (int j = 0; j < forbiddenChars.length; ++j) {
                if (chars[i] != forbiddenChars[j]) continue;
                chars[i] = 45;
            }
        }
        String toRet = String.valueOf(chars);
        if (toRet.contains(".")) {
            toRet = toRet + ".ext";
        }
        return toRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRepositoryInfo(RepositoryInfo info) {
        FileObject fo = this.getRepoFolder().getFileObject(this.getFileObjectName(info.getId()));
        if (fo != null) {
            Map<FileObject, RepositoryInfo> map = this.infoCache;
            synchronized (map) {
                this.infoCache.remove(fo);
            }
            try {
                fo.delete();
            }
            catch (IOException x) {
                Logger.getLogger(RepositoryPreferences.class.getName()).log(Level.FINE, "Cannot delete repository in system filesystem", x);
            }
        }
    }

    public void setIndexUpdateFrequency(int fr) {
        this.getPreferences().putInt(PROP_INDEX_FREQ, fr);
    }

    public int getIndexUpdateFrequency() {
        return this.getPreferences().getInt(PROP_INDEX_FREQ, 0);
    }

    public Date getLastIndexUpdate(String repoId) {
        return new Date(this.getPreferences().getLong("lastIndexUpdate." + repoId, 0L));
    }

    public void setLastIndexUpdate(String repoId, Date date) {
        this.getPreferences().putLong("lastIndexUpdate." + repoId, date.getTime());
    }

    public boolean isIncludeSnapshots() {
        return this.getPreferences().getBoolean(PROP_SNAPSHOTS, true);
    }

    public void setIncludeSnapshots(boolean includeSnapshots) {
        this.getPreferences().putBoolean(PROP_SNAPSHOTS, includeSnapshots);
    }

    static {
        forbiddenChars = new char[]{'/', '\\', '?', '%', '*', ':', '|', '\"', '<', '>'};
    }

    private static class Comp
    implements Comparator<FileObject> {
        private Comp() {
        }

        @Override
        public int compare(FileObject o1, FileObject o2) {
            Integer pos2;
            if (!o1.isValid() && !o2.isValid()) {
                return 0;
            }
            if (!o1.isValid()) {
                return 1;
            }
            if (!o2.isValid()) {
                return -1;
            }
            Integer pos1 = (Integer)o1.getAttribute("position");
            if (pos1 == null) {
                Logger.getLogger(RepositoryPreferences.class.getName()).warning("FileObject " + o1.getPath() + " doesn't have attribute 'position' defined.");
                pos1 = o1.hashCode();
            }
            if ((pos2 = (Integer)o2.getAttribute("position")) == null) {
                Logger.getLogger(RepositoryPreferences.class.getName()).warning("FileObject " + o1.getPath() + " doesn't have attribute 'position' defined.");
                pos2 = o1.hashCode();
            }
            if (pos2 > pos1) {
                return -1;
            }
            if (pos2 < pos1) {
                return 1;
            }
            return 0;
        }
    }
}

