/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.debug.watchesfiltering;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.modules.web.debug.watchesfiltering.JspElWatch;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.RequestProcessor;

public class JspWatchesNodeModel
implements NodeModel {
    private static final String ICON_BASE = "org/netbeans/modules/debugger/resources/watchesView/Watch";
    private final Collection<ModelListener> modelListeners = new HashSet<ModelListener>();
    private final Map<JspElWatch, String> shortDescriptionMap = new HashMap<JspElWatch, String>();
    private RequestProcessor evaluationRP;

    public JspWatchesNodeModel(ContextProvider contextProvider) {
        this.evaluationRP = (RequestProcessor)contextProvider.lookupFirst(null, RequestProcessor.class);
    }

    public String getDisplayName(Object object) throws UnknownTypeException {
        if (!(object instanceof JspElWatch)) {
            throw new UnknownTypeException(object);
        }
        JspElWatch jspElWatch = (JspElWatch)object;
        return jspElWatch.getExpression();
    }

    public String getIconBase(Object object) throws UnknownTypeException {
        if (!(object instanceof JspElWatch)) {
            throw new UnknownTypeException(object);
        }
        return ICON_BASE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getShortDescription(Object object) throws UnknownTypeException {
        if (!(object instanceof JspElWatch)) {
            throw new UnknownTypeException(object);
        }
        final JspElWatch jspElWatch = (JspElWatch)object;
        Map<JspElWatch, String> map = this.shortDescriptionMap;
        synchronized (map) {
            String string = this.shortDescriptionMap.remove(jspElWatch);
            if (string != null) {
                return string;
            }
        }
        this.evaluationRP.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String string = JspWatchesNodeModel.getShortDescriptionSynch(jspElWatch);
                if (string != null && !"".equals(string)) {
                    Map map = JspWatchesNodeModel.this.shortDescriptionMap;
                    synchronized (map) {
                        JspWatchesNodeModel.this.shortDescriptionMap.put(jspElWatch, string);
                    }
                    JspWatchesNodeModel.this.fireModelChange((ModelEvent)new ModelEvent.NodeChanged((Object)JspWatchesNodeModel.this, (Object)jspElWatch, 4));
                }
            }
        });
        return "";
    }

    private static String getShortDescriptionSynch(JspElWatch jspElWatch) {
        String string = jspElWatch.getType();
        String string2 = jspElWatch.getExceptionDescription();
        if (string2 != null) {
            return jspElWatch.getExpression() + " = >" + string2 + "<";
        }
        if (string == null) {
            return jspElWatch.getExpression() + " = " + jspElWatch.getValue();
        }
        try {
            return jspElWatch.getExpression() + " = (" + jspElWatch.getType() + ") " + jspElWatch.getToStringValue();
        }
        catch (InvalidExpressionException invalidExpressionException) {
            return invalidExpressionException.getLocalizedMessage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModelListener(ModelListener modelListener) {
        Collection<ModelListener> collection = this.modelListeners;
        synchronized (collection) {
            this.modelListeners.add(modelListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeModelListener(ModelListener modelListener) {
        Collection<ModelListener> collection = this.modelListeners;
        synchronized (collection) {
            this.modelListeners.remove(modelListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireModelChange(ModelEvent modelEvent) {
        ModelListener[] modelListenerArray;
        Collection<ModelListener> collection = this.modelListeners;
        synchronized (collection) {
            modelListenerArray = this.modelListeners.toArray(new ModelListener[0]);
        }
        for (int i = 0; i < modelListenerArray.length; ++i) {
            modelListenerArray[i].modelChanged(modelEvent);
        }
    }
}

