/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.visualizers;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.KeyboardFocusManager;
import java.awt.event.ComponentListener;
import java.awt.event.HierarchyListener;
import java.beans.FeatureDescriptor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.EventObject;
import java.util.List;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.tree.TreePath;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.api.storage.types.Time;
import org.netbeans.swing.etable.ETable;
import org.netbeans.swing.outline.Outline;
import org.openide.explorer.propertysheet.ExPropertyModel;
import org.openide.explorer.propertysheet.PropertyPanel;
import org.openide.explorer.view.Visualizer;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

abstract class FunctionsListSheetCell
extends AbstractCellEditor
implements TableModelListener,
PropertyChangeListener,
TableCellEditor,
TableCellRenderer {
    private Boolean flat;
    private final List<DataTableMetadata.Column> columns;
    private Node node;
    private Node.Property<?> prop;
    private TableCellRenderer headerRenderer = new JTableHeader().getDefaultRenderer();
    private NullPanel nullPanel;
    private FocusedPropertyPanel renderer = null;
    private PropertyPanel editor = null;
    private static Color noFocusSelectionBackground = null;
    private static Color noFocusSelectionForeground = null;

    public FunctionsListSheetCell(List<DataTableMetadata.Column> columns) {
        this.columns = columns;
        this.setFlat(false);
    }

    public final void setFlat(boolean f) {
        this.flat = f ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public Object getCellEditorValue() {
        return null;
    }

    public abstract Node nodeForRow(int var1);

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int r, int c) {
        this.prop = (Node.Property)value;
        this.node = this.nodeForRow(r);
        this.node.addPropertyChangeListener((PropertyChangeListener)this);
        PropertyPanel propPanel = this.getEditor(this.prop, this.node);
        propPanel.setBackground(table.getSelectionBackground());
        propPanel.setForeground(table.getSelectionForeground());
        propPanel.setBorder((Border)BorderFactory.createMatteBorder(0, 1, 0, 0, table.getSelectionBackground()));
        return propPanel;
    }

    @Override
    public boolean shouldSelectCell(EventObject ev) {
        return true;
    }

    @Override
    public boolean isCellEditable(EventObject e) {
        return true;
    }

    @Override
    public boolean stopCellEditing() {
        if (this.prop != null) {
            this.detachEditor();
        }
        return super.stopCellEditing();
    }

    @Override
    public void cancelCellEditing() {
        if (this.prop != null) {
            this.detachEditor();
        }
        super.cancelCellEditing();
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.cancelCellEditing();
    }

    protected void detachEditor() {
        this.node.removePropertyChangeListener((PropertyChangeListener)this);
        this.node = null;
        this.prop = null;
    }

    private JComponent getNumberRenderer(Node.Property<?> property, Node n, boolean hasFocus) throws IllegalAccessException, InvocationTargetException {
        Object value = property.getValue();
        PropertyEditor propEd = property.getPropertyEditor();
        if (propEd != null) {
            try {
                propEd.setValue(value);
                value = propEd.getAsText();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        JLabel result = new JLabel(value + "", 4);
        if (hasFocus) {
            result.setBorder(new LineBorder(UIManager.getColor("Tree.selectionBorderColor"), 1));
        }
        return result;
    }

    private FocusedPropertyPanel getRenderer(Node.Property<?> p, Node n, boolean hasFocus) {
        if (this.renderer == null) {
            this.renderer = new FocusedPropertyPanel(p, 9);
            this.renderer.putClientProperty("beanBridgeIdentifier", this);
        }
        this.renderer.setProperty(p);
        this.renderer.putClientProperty("flat", Boolean.TRUE);
        this.renderer.setFocused(hasFocus);
        return this.renderer;
    }

    public abstract String getShortDescription(int var1);

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (row == -1) {
            Component comp = this.headerRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (comp instanceof JComponent) {
                String tip = column > 0 ? this.getShortDescription(column) : table.getColumnName(0);
                ((JComponent)comp).setToolTipText(tip);
            }
            return comp;
        }
        Node.Property property = (Node.Property)value;
        Node n = this.nodeForRow(row);
        if (property != null) {
            Object computeTooltip;
            Object propPanel = null;
            if (column > 0 && (this.columns.get(column - 1).getColumnClass() == Time.class || this.columns.get(column - 1).getColumnClass().getSuperclass() == Number.class)) {
                try {
                    propPanel = this.getNumberRenderer(property, n, hasFocus);
                }
                catch (IllegalAccessException ex) {
                    propPanel = this.getRenderer(this.prop, n, hasFocus);
                }
                catch (InvocationTargetException ex) {
                    propPanel = this.getRenderer(this.prop, n, hasFocus);
                }
            } else {
                propPanel = this.getRenderer(property, n, hasFocus);
            }
            if (Boolean.TRUE.equals(computeTooltip = table.getClientProperty("ComputingTooltip"))) {
                String toolT = null;
                PropertyEditor propEd = property.getPropertyEditor();
                if (propEd != null) {
                    try {
                        propEd.setValue(property.getValue());
                        toolT = propEd.getAsText();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                if (toolT == null) {
                    Object val = null;
                    try {
                        val = property.getValue();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    if (val != null) {
                        toolT = val.toString();
                    }
                }
                if (toolT != null && toolT.trim().length() > 0) {
                    ((JComponent)propPanel).setToolTipText(toolT.trim());
                } else {
                    ((JComponent)propPanel).setToolTipText(null);
                }
            }
            ((JComponent)propPanel).setOpaque(true);
            if (isSelected) {
                boolean tableHasFocus;
                Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                boolean bl = tableHasFocus = table == focusOwner || table.isAncestorOf(focusOwner) || focusOwner instanceof Container && ((Container)focusOwner).isAncestorOf(table);
                if (table == focusOwner && table.isEditing()) {
                    tableHasFocus = true;
                }
                ((JComponent)propPanel).setBackground(tableHasFocus ? table.getSelectionBackground() : FunctionsListSheetCell.getNoFocusSelectionBackground());
                ((JComponent)propPanel).setForeground(tableHasFocus ? table.getSelectionForeground() : FunctionsListSheetCell.getNoFocusSelectionForeground());
            } else {
                ((JComponent)propPanel).setBackground(table.getBackground());
                ((JComponent)propPanel).setForeground(table.getForeground());
            }
            if (table instanceof ETable) {
                ETable et = (ETable)table;
                et.setCellBackground((Component)propPanel, isSelected, row, column);
            }
            return propPanel;
        }
        if (this.nullPanel == null) {
            this.nullPanel = new NullPanel(n);
            this.nullPanel.setOpaque(true);
        } else {
            this.nullPanel.setNode(n);
        }
        if (isSelected) {
            Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            boolean tableHasFocus = hasFocus || table == focusOwner || table.isAncestorOf(focusOwner) || focusOwner instanceof Container && ((Container)focusOwner).isAncestorOf(table);
            this.nullPanel.setBackground(tableHasFocus ? table.getSelectionBackground() : FunctionsListSheetCell.getNoFocusSelectionBackground());
            this.nullPanel.setForeground(table.getSelectionForeground().darker());
        } else {
            this.nullPanel.setBackground(table.getBackground());
            this.nullPanel.setForeground(table.getForeground());
        }
        if (table instanceof ETable) {
            ETable et = (ETable)table;
            et.setCellBackground((Component)this.nullPanel, isSelected, row, column);
        }
        this.nullPanel.setFocused(hasFocus);
        return this.nullPanel;
    }

    private PropertyPanel getEditor(Node.Property<?> p, Node n) {
        int prefs = 8;
        if (this.editor == null) {
            this.editor = new PropertyPanel(p, prefs);
            this.editor.putClientProperty((Object)"flat", (Object)Boolean.TRUE);
            this.editor.putClientProperty((Object)"beanBridgeIdentifier", (Object)this);
            this.editor.setProperty(p);
            return this.editor;
        }
        this.editor.setProperty(p);
        return this.editor;
    }

    private static String getString(String key) {
        return NbBundle.getBundle(FunctionsListSheetCell.class).getString(key);
    }

    static Color getNoFocusSelectionBackground() {
        if (noFocusSelectionBackground == null && (noFocusSelectionBackground = UIManager.getColor("nb.explorer.noFocusSelectionBackground")) == null) {
            noFocusSelectionBackground = UIManager.getColor("controlShadow");
            if (noFocusSelectionBackground == null) {
                noFocusSelectionBackground = Color.lightGray;
            }
            noFocusSelectionBackground = noFocusSelectionBackground.brighter();
        }
        return noFocusSelectionBackground;
    }

    static Color getNoFocusSelectionForeground() {
        if (noFocusSelectionForeground == null && (noFocusSelectionForeground = UIManager.getColor("nb.explorer.noFocusSelectionForeground")) == null && (noFocusSelectionForeground = UIManager.getColor("textText")) == null) {
            noFocusSelectionForeground = Color.BLACK;
        }
        return noFocusSelectionForeground;
    }

    public static class OutlineSheetCell
    extends FunctionsListSheetCell {
        private Outline outline;

        public OutlineSheetCell(Outline outline, List<DataTableMetadata.Column> columns) {
            super(columns);
            this.outline = outline;
        }

        @Override
        public Node nodeForRow(int row) {
            int r = this.outline.convertRowIndexToModel(row);
            TreePath tp = this.outline.getLayoutCache().getPathForRow(r);
            return Visualizer.findNode((Object)tp.getLastPathComponent());
        }

        @Override
        public String getShortDescription(int column) {
            return this.outline.getOutlineModel().getColumnName(column);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.stopCellEditing();
            if (SwingUtilities.isEventDispatchThread()) {
                this.outline.tableChanged(new TableModelEvent(this.outline.getModel(), 0, this.outline.getRowCount()));
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        OutlineSheetCell.this.outline.tableChanged(new TableModelEvent(OutlineSheetCell.this.outline.getModel(), 0, OutlineSheetCell.this.outline.getRowCount()));
                    }
                });
            }
        }

        @Override
        protected void detachEditor() {
            super.detachEditor();
            TableModel tableModel = this.outline.getModel();
            tableModel.removeTableModelListener(this);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int r, int c) {
            TableModel tableModel = this.outline.getModel();
            tableModel.addTableModelListener(this);
            return super.getTableCellEditorComponent(table, value, isSelected, r, c);
        }
    }

    private static class FocusedPropertyPanel
    extends PropertyPanel {
        private boolean focused;

        public FocusedPropertyPanel(Node.Property<?> p, int preferences) {
            super(p, preferences);
            this.setDoubleBuffered(true);
        }

        public void setFocused(boolean focused) {
            this.focused = focused;
        }

        public void addComponentListener(ComponentListener l) {
        }

        public void addHierarchyListener(HierarchyListener l) {
        }

        public void repaint(long tm, int x, int y, int width, int height) {
        }

        public void revalidate() {
        }

        public void firePropertyChange(String s, Object a, Object b) {
            if ("flat".equals(s)) {
                super.firePropertyChange(s, a, b);
            }
        }

        public boolean isShowing() {
            return true;
        }

        public void update(Graphics g) {
        }

        public void paint(Graphics g) {
            Color c = this.getBackground();
            Color old = g.getColor();
            g.setColor(c);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(old);
            super.paint(g);
            if (this.focused) {
                Color bdr = UIManager.getColor("Tree.selectionBorderColor");
                if (bdr == null) {
                    bdr = this.getForeground().equals(Color.BLACK) ? this.getBackground().darker() : this.getForeground().darker();
                }
                g.setColor(bdr);
                g.drawRect(1, 1, this.getWidth() - 3, this.getHeight() - 3);
            }
            g.setColor(old);
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleFocusedPropertyPanel();
            }
            return this.accessibleContext;
        }

        private class AccessibleFocusedPropertyPanel
        extends JComponent.AccessibleJComponent {
            AccessibleFocusedPropertyPanel() {
                super((JComponent)((Object)FocusedPropertyPanel.this));
            }

            @Override
            public AccessibleRole getAccessibleRole() {
                return AccessibleRole.PANEL;
            }

            @Override
            public String getAccessibleName() {
                FeatureDescriptor fd = ((ExPropertyModel)FocusedPropertyPanel.this.getModel()).getFeatureDescriptor();
                PropertyEditor editor = FocusedPropertyPanel.this.getPropertyEditor();
                return MessageFormat.format(FunctionsListSheetCell.getString("ACS_PropertyPanelRenderer"), fd.getDisplayName(), editor == null ? FunctionsListSheetCell.getString("CTL_No_value") : editor.getAsText());
            }

            @Override
            public String getAccessibleDescription() {
                FeatureDescriptor fd = ((ExPropertyModel)FocusedPropertyPanel.this.getModel()).getFeatureDescriptor();
                Node node = (Node)((ExPropertyModel)FocusedPropertyPanel.this.getModel()).getBeans()[0];
                Class clazz = FocusedPropertyPanel.this.getModel().getPropertyType();
                return MessageFormat.format(FunctionsListSheetCell.getString("ACSD_PropertyPanelRenderer"), fd.getShortDescription(), clazz == null ? FunctionsListSheetCell.getString("CTL_No_type") : clazz.getName(), node.getDisplayName());
            }
        }
    }

    private static class NullPanel
    extends JPanel {
        private WeakReference<Node> weakNode;
        private boolean focused = false;

        NullPanel(Node node) {
            this.weakNode = new WeakReference<Node>(node);
        }

        void setNode(Node node) {
            this.weakNode = new WeakReference<Node>(node);
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleNullPanel();
            }
            return this.accessibleContext;
        }

        public void setFocused(boolean val) {
            this.focused = val;
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.focused) {
                Color bdr = UIManager.getColor("Tree.selectionBorderColor");
                if (bdr == null) {
                    bdr = this.getForeground().equals(Color.BLACK) ? this.getBackground().darker() : this.getForeground().darker();
                }
                g.setColor(bdr);
                g.drawRect(1, 1, this.getWidth() - 3, this.getHeight() - 3);
                g.setColor(bdr);
            }
        }

        @Override
        public void addComponentListener(ComponentListener l) {
        }

        @Override
        public void addHierarchyListener(HierarchyListener l) {
        }

        @Override
        public void repaint() {
        }

        @Override
        public void repaint(int x, int y, int width, int height) {
        }

        @Override
        public void invalidate() {
        }

        @Override
        public void revalidate() {
        }

        @Override
        public void validate() {
        }

        @Override
        public void firePropertyChange(String s, Object a, Object b) {
        }

        private class AccessibleNullPanel
        extends JPanel.AccessibleJPanel {
            AccessibleNullPanel() {
                super(NullPanel.this);
            }

            @Override
            public String getAccessibleName() {
                String name = super.getAccessibleName();
                if (name == null) {
                    name = FunctionsListSheetCell.getString("ACS_NullPanel");
                }
                return name;
            }

            @Override
            public String getAccessibleDescription() {
                Node node;
                String description = super.getAccessibleDescription();
                if (description == null && (node = (Node)NullPanel.this.weakNode.get()) != null) {
                    description = MessageFormat.format(FunctionsListSheetCell.getString("ACSD_NullPanel"), node.getDisplayName());
                }
                return description;
            }
        }
    }
}

