/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.visualizers;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.netbeans.modules.dlight.visualizers.MultiSortTableCellHeaderRenderer;

final class TableSorter
extends AbstractTableModel
implements TableModelListener {
    private static final boolean TRACE = Boolean.getBoolean("table.sorter.trace");
    private int[] indexes;
    private List<Integer> sortingColumns = new Vector<Integer>();
    private int compares;
    private TableModel model;
    List<Boolean> sortingColumnsOrder = new Vector<Boolean>();

    public TableSorter() {
        this.indexes = new int[0];
    }

    List<Integer> getSortingColumns() {
        return this.sortingColumns;
    }

    public TableSorter(TableModel model) {
        this.setModel(model);
    }

    private void setModel(TableModel tablemodel) {
        if (this.model != null) {
            this.model.removeTableModelListener(this);
        }
        this.model = tablemodel;
        this.sortingColumns.clear();
        this.sortingColumnsOrder.clear();
        this.fireTableStructureChanged();
        this.fireTableChanged(new TableModelEvent(this));
        tablemodel.addTableModelListener(this);
        if (TRACE) {
            System.out.printf("Sorter: @%d setModel\n", this.hashCode());
        }
        this.reallocateIndexes();
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        super.addTableModelListener(l);
        if (this.model != null) {
            this.model.addTableModelListener(l);
        }
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        super.removeTableModelListener(l);
        if (this.model != null) {
            this.model.removeTableModelListener(l);
        }
    }

    @Override
    public synchronized int getRowCount() {
        return this.model != null ? this.model.getRowCount() : 0;
    }

    @Override
    public int getColumnCount() {
        return this.model != null ? this.model.getColumnCount() : 0;
    }

    @Override
    public String getColumnName(int i) {
        return this.model.getColumnName(i);
    }

    @Override
    public Class<?> getColumnClass(int i) {
        return this.model.getColumnClass(i);
    }

    @Override
    public boolean isCellEditable(int i, int j) {
        return this.model.isCellEditable(i, j);
    }

    public int compareRowsByColumn(int row1, int row2, int column) {
        Object v2;
        String s2;
        Class<?> type = this.model.getColumnClass(column);
        TableModel data = this.model;
        Object o1 = data.getValueAt(row1, column);
        Object o2 = data.getValueAt(row2, column);
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        if (type.getSuperclass() == Number.class) {
            Number n2;
            double d2;
            Number n1 = (Number)data.getValueAt(row1, column);
            double d1 = n1.doubleValue();
            if (d1 < (d2 = (n2 = (Number)data.getValueAt(row2, column)).doubleValue())) {
                return -1;
            }
            if (d1 > d2) {
                return 1;
            }
            return 0;
        }
        if (type == Date.class) {
            Date d2;
            long n2;
            Date d1 = (Date)data.getValueAt(row1, column);
            long n1 = d1.getTime();
            if (n1 < (n2 = (d2 = (Date)data.getValueAt(row2, column)).getTime())) {
                return -1;
            }
            if (n1 > n2) {
                return 1;
            }
            return 0;
        }
        if (type == String.class) {
            String s22;
            String s1 = (String)data.getValueAt(row1, column);
            int result = s1.compareTo(s22 = (String)data.getValueAt(row2, column));
            if (result < 0) {
                return -1;
            }
            if (result > 0) {
                return 1;
            }
            return 0;
        }
        if (type == Boolean.class) {
            Boolean bool2;
            boolean b2;
            Boolean bool1 = (Boolean)data.getValueAt(row1, column);
            boolean b1 = bool1;
            if (b1 == (b2 = (bool2 = (Boolean)data.getValueAt(row2, column)).booleanValue())) {
                return 0;
            }
            if (b1) {
                return 1;
            }
            return -1;
        }
        Object v1 = data.getValueAt(row1, column);
        String s1 = v1.toString();
        int result = s1.compareTo(s2 = (v2 = data.getValueAt(row2, column)).toString());
        if (result < 0) {
            return -1;
        }
        if (result > 0) {
            return 1;
        }
        return 0;
    }

    public int compare(int row1, int row2) {
        ++this.compares;
        for (int level = 0; level < this.sortingColumns.size(); ++level) {
            Integer column = this.sortingColumns.get(level);
            int result = this.compareRowsByColumn(row1, row2, column);
            if (result == 0) continue;
            return this.sortingColumnsOrder.get(level) != false ? result : -result;
        }
        return 0;
    }

    public synchronized void reallocateIndexes() {
        int rowCount = this.model.getRowCount();
        this.indexes = new int[rowCount];
        for (int row = 0; row < rowCount; ++row) {
            this.indexes[row] = row;
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (TRACE) {
            System.out.printf("Sorter: @%d tableChanged\n", this.hashCode());
        }
        this.reallocateIndexes();
        this.fireTableChanged(e);
    }

    public synchronized void checkModel() {
        if (this.indexes.length != this.model.getRowCount()) {
            if (TRACE) {
                System.out.printf("Sorter: @%d not informed of a change in model.\n", this.hashCode());
            }
            this.reallocateIndexes();
        }
    }

    public void sort(Object sender) {
        this.checkModel();
        this.compares = 0;
        this.shuttlesort((int[])this.indexes.clone(), this.indexes, 0, this.indexes.length);
    }

    public void n2sort() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            for (int j = i + 1; j < this.getRowCount(); ++j) {
                if (this.compare(this.indexes[i], this.indexes[j]) != -1) continue;
                this.swap(i, j);
            }
        }
    }

    public void shuttlesort(int[] from, int[] to, int low, int high) {
        if (high - low < 2) {
            return;
        }
        int middle = (low + high) / 2;
        this.shuttlesort(to, from, low, middle);
        this.shuttlesort(to, from, middle, high);
        int p = low;
        int q = middle;
        if (high - low >= 4 && this.compare(from[middle - 1], from[middle]) <= 0) {
            for (int i = low; i < high; ++i) {
                to[i] = from[i];
            }
            return;
        }
        for (int i = low; i < high; ++i) {
            to[i] = q >= high || p < middle && this.compare(from[p], from[q]) <= 0 ? from[p++] : from[q++];
        }
    }

    public void swap(int i, int j) {
        int tmp = this.indexes[i];
        this.indexes[i] = this.indexes[j];
        this.indexes[j] = tmp;
    }

    @Override
    public synchronized Object getValueAt(int aRow, int aColumn) {
        this.checkModel();
        return this.model.getValueAt(this.indexes[aRow], aColumn);
    }

    @Override
    public synchronized void setValueAt(Object aValue, int aRow, int aColumn) {
        this.checkModel();
        this.model.setValueAt(aValue, this.indexes[aRow], aColumn);
    }

    public void sortByColumn(int column) {
        this.sortByColumn(column, true);
    }

    public void sortByColumn(int column, boolean ascending) {
        this.sortingColumnsOrder.clear();
        this.sortingColumnsOrder.add(ascending);
        this.sortingColumns.clear();
        this.sortingColumns.add(column);
        this.sort(this);
        this.fireTableChanged(new TableModelEvent(this));
    }

    public void clickOnColumn(int column) {
        boolean ascending = true;
        if (this.sortingColumns.contains(column)) {
            ascending = this.sortingColumnsOrder.get(this.sortingColumns.indexOf(column)) == false;
        }
        this.sortByColumn(column, ascending);
    }

    public void addMouseListenerToHeaderInTable(JTable table) {
        final TableSorter sorter = this;
        final JTable tableView = table;
        tableView.setColumnSelectionAllowed(false);
        MouseAdapter listMouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TableColumnModel columnModel = tableView.getColumnModel();
                int viewColumn = columnModel.getColumnIndexAtX(e.getX());
                int column = tableView.convertColumnIndexToModel(viewColumn);
                if (e.getClickCount() == 1 && column != -1) {
                    boolean ascending = true;
                    if (TableSorter.this.sortingColumns.contains(column)) {
                        ascending = TableSorter.this.sortingColumnsOrder.get(TableSorter.this.sortingColumns.indexOf(column)) == false;
                    }
                    sorter.sortByColumn(column, ascending);
                }
            }
        };
        JTableHeader th = tableView.getTableHeader();
        th.setDefaultRenderer(new MultiSortTableCellHeaderRenderer());
        th.addMouseListener(listMouseListener);
    }
}

