/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf;

import java.io.IOException;
import java.util.logging.Logger;
import javax.swing.Icon;
import org.netbeans.modules.gsf.GsfTypeProvider;
import org.netbeans.modules.gsf.LanguageRegistry;
import org.netbeans.modules.gsf.api.CancellableTask;
import org.netbeans.modules.gsf.api.ElementHandle;
import org.netbeans.modules.gsfret.navigation.Icons;
import org.netbeans.napi.gsfret.source.ClasspathInfo;
import org.netbeans.napi.gsfret.source.CompilationController;
import org.netbeans.napi.gsfret.source.Source;
import org.netbeans.napi.gsfret.source.UiUtils;
import org.netbeans.spi.jumpto.type.TypeDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class GsfTypeDescription
extends TypeDescriptor {
    private Icon icon;
    private final GsfTypeProvider.CacheItem cacheItem;
    private final ElementHandle handle;
    private String simpleName;
    private String outerName;
    private String packageName;

    public GsfTypeDescription(GsfTypeProvider.CacheItem cacheItem, ElementHandle handle) {
        this.cacheItem = cacheItem;
        this.handle = handle;
        this.init();
    }

    public void open() {
        if (this.cacheItem.isBinary()) {
            ClasspathInfo ci = ClasspathInfo.create(this.cacheItem.getRoot());
            Source js = Source.create(ci, new FileObject[0]);
            if (js == null) {
                return;
            }
            final ElementHandle eh = this.handle;
            ElementHandle[] el = new ElementHandle[1];
            try {
                js.runUserActionTask(new CancellableTask<CompilationController>(){

                    public void cancel() {
                    }

                    public void run(CompilationController info) {
                        FileObject fo = info.getFileObject();
                        Source js = Source.forFileObject(fo);
                        UiUtils.open(js, eh);
                    }
                }, true);
            }
            catch (IOException e) {
                Logger.getLogger(GsfTypeDescription.class.getName()).info("Source not found: " + eh);
                Exceptions.printStackTrace((Throwable)e);
            }
        } else {
            FileObject folder;
            FileObject fileObject = folder = this.packageName != null ? this.cacheItem.getRoot().getFileObject(this.packageName.replace(".", "/")) : this.cacheItem.getRoot();
            if (folder != null) {
                FileObject[] ch = folder.getChildren();
                String name = this.outerName == null ? this.simpleName : this.outerName;
                int lastDot = name.indexOf(46);
                if (lastDot != -1) {
                    name = name.substring(0, lastDot);
                }
                for (FileObject fileObject2 : ch) {
                    Source js;
                    if (!name.equals(fileObject2.getName()) || !LanguageRegistry.getInstance().isSupported(fileObject2.getMIMEType()) || (js = Source.forFileObject(fileObject2)) == null) continue;
                    UiUtils.open(js, this.handle);
                }
            } else {
                Logger.getLogger(GsfTypeDescription.class.getName()).info("Package " + this.packageName + " doesn't exist in root: " + FileUtil.getFileDisplayName((FileObject)this.cacheItem.getRoot()));
            }
        }
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public String getOuterName() {
        throw null;
    }

    public FileObject getFileObject() {
        return this.cacheItem.getRoot();
    }

    public String getTypeName() {
        StringBuilder sb = new StringBuilder(this.simpleName);
        if (this.outerName != null) {
            sb.append(" in ").append(this.outerName);
        }
        return sb.toString();
    }

    public String getContextName() {
        StringBuilder sb = new StringBuilder();
        sb.append(" (").append(this.packageName == null ? "Default Package" : this.packageName).append(")");
        return sb.toString();
    }

    public String getProjectName() {
        String projectName = this.cacheItem.getProjectName();
        return projectName == null ? "" : projectName;
    }

    public Icon getProjectIcon() {
        return this.cacheItem.getProjectIcon();
    }

    private void init() {
        ElementHandle element = this.handle;
        this.icon = Icons.getElementIcon(element.getKind(), null);
        this.simpleName = element.getName();
        this.packageName = element.getIn();
        this.outerName = null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.simpleName);
        if (this.outerName != null) {
            sb.append(" in ").append(this.outerName);
        }
        sb.append(" (").append(this.packageName == null ? "Default Package" : this.packageName).append(")");
        if (this.cacheItem.getProjectName() != null) {
            sb.append(" [").append(this.cacheItem.getProjectName()).append("]");
        }
        return sb.toString();
    }

    public synchronized Icon getIcon() {
        return this.icon;
    }

    public int getOffset() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

