/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsfret.source.parsing;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URI;
import java.nio.CharBuffer;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.modules.gsf.Language;
import org.netbeans.modules.gsf.LanguageRegistry;
import org.netbeans.modules.gsf.api.DataLoadersBridge;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.text.NbDocument;

public class SourceFileObject {
    final FileObject file;
    private URI uri;
    private String text;
    private TokenHierarchy tokens;
    static final String encodingName = new OutputStreamWriter(new ByteArrayOutputStream()).getEncoding();

    public static SourceFileObject create(FileObject file) {
        try {
            return new SourceFileObject(file, false);
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().notify((Throwable)ioe);
            return null;
        }
    }

    public SourceFileObject(FileObject file, boolean renderNow) throws IOException {
        assert (file != null);
        this.file = file;
        if (renderNow) {
            this.text = this.getCharContentImpl().toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CharBuffer getCharContent(boolean ignoreEncodingErrors) throws IOException {
        String _text;
        SourceFileObject sourceFileObject = this;
        synchronized (sourceFileObject) {
            _text = this.text;
        }
        if (_text != null) {
            return CharBuffer.wrap(_text);
        }
        return this.getCharContentImpl();
    }

    public TokenHierarchy getTokenHierarchy() throws IOException {
        if (this.tokens == null) {
            this.getCharContentImpl();
        }
        return this.tokens;
    }

    public Writer openWriter() throws IOException {
        return new OutputStreamWriter(this.openOutputStream(), encodingName);
    }

    public Reader openReader(boolean ignoreEncodingErrors) throws IOException {
        return new InputStreamReader(this.openInputStream(), encodingName);
    }

    public OutputStream openOutputStream() throws IOException {
        StyledDocument doc = DataLoadersBridge.getDefault().getDocument(this.file);
        if (doc == null) {
            return new LckStream(this.file);
        }
        return new DocumentStream(doc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream openInputStream() throws IOException {
        String _text;
        SourceFileObject sourceFileObject = this;
        synchronized (sourceFileObject) {
            _text = this.text;
        }
        if (_text != null) {
            return new ByteArrayInputStream(_text.getBytes());
        }
        final StyledDocument doc = DataLoadersBridge.getDefault().getDocument(this.file);
        if (doc == null) {
            return this.file.getInputStream();
        }
        final StringBuilder builder = new StringBuilder();
        doc.render(new Runnable(){

            @Override
            public void run() {
                try {
                    builder.append(doc.getText(0, doc.getLength()));
                }
                catch (BadLocationException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                }
            }
        });
        return new ByteArrayInputStream(builder.toString().getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete() {
        boolean bl;
        if (this.isModified() != null) {
            return false;
        }
        FileLock lock = this.file.lock();
        try {
            this.file.delete(lock);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                lock.releaseLock();
                throw throwable;
            }
            catch (IOException e) {
                return false;
            }
        }
        lock.releaseLock();
        return bl;
    }

    public String getName() {
        return this.file.getNameExt();
    }

    public String getNameWithoutExtension() {
        return this.file.getName();
    }

    public synchronized URI toUri() {
        if (this.uri == null) {
            try {
                this.uri = URI.create(this.file.getURL().toExternalForm());
            }
            catch (FileStateInvalidException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
        return this.uri;
    }

    public long getLastModified() {
        if (this.isModified() == null) {
            return this.file.lastModified().getTime();
        }
        return System.currentTimeMillis();
    }

    public boolean equals(Object other) {
        if (other instanceof SourceFileObject) {
            SourceFileObject otherSource = (SourceFileObject)other;
            return this.file.equals(otherSource.file);
        }
        return false;
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    public StyledDocument getDocument() {
        return DataLoadersBridge.getDefault().getDocument(this.file);
    }

    public void runAtomic(Runnable r) {
        assert (r != null);
        StyledDocument doc = this.getDocument();
        if (doc == null) {
            throw new IllegalStateException();
        }
        NbDocument.runAtomic((StyledDocument)doc, (Runnable)r);
    }

    private EditorCookie isModified() {
        return DataLoadersBridge.getDefault().isModified(this.file);
    }

    public EditorCookie isOpened() {
        return (EditorCookie)DataLoadersBridge.getDefault().getSafeCookie(this.file, EditorCookie.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CharBuffer getCharContentImpl() throws IOException {
        final StyledDocument doc = DataLoadersBridge.getDefault().getDocument(this.file);
        final char[][] result = new char[1][];
        final int[] length = new int[1];
        if (doc == null) {
            Reader in = this.openReader(true);
            int red = 0;
            try {
                int rv;
                int len = (int)this.file.getSize();
                result[0] = new char[len + 1];
                while ((rv = in.read(result[0], red, len - red)) > 0 && (red += rv) < len) {
                }
            }
            finally {
                in.close();
            }
            int j = 0;
            for (int i = 0; i < red; ++i) {
                if (result[0][i] == '\r') {
                    if (i + 1 < red && result[0][i + 1] == '\n') continue;
                    result[0][j++] = 10;
                    continue;
                }
                result[0][j++] = result[0][i];
            }
            length[0] = j;
        } else {
            doc.render(new Runnable(){

                @Override
                public void run() {
                    try {
                        int len = doc.getLength();
                        result[0] = new char[len + 1];
                        doc.getText(0, len).getChars(0, len, result[0], 0);
                        length[0] = len;
                    }
                    catch (BadLocationException e) {
                        ErrorManager.getDefault().notify((Throwable)e);
                    }
                }
            });
        }
        result[0][length[0]] = 10;
        CharBuffer charBuffer = CharBuffer.wrap(result[0], 0, length[0]);
        Language language = LanguageRegistry.getInstance().getLanguageByMimeType(this.file.getMIMEType());
        if (language != null && language.getGsfLanguage() != null) {
            org.netbeans.api.lexer.Language lexerLanguage = language.getGsfLanguage().getLexerLanguage();
            InputAttributes attributes = new InputAttributes();
            attributes.setValue(lexerLanguage, FileObject.class, (Object)this.file, false);
            this.tokens = TokenHierarchy.create((CharSequence)charBuffer, (boolean)true, (org.netbeans.api.lexer.Language)lexerLanguage, null, (InputAttributes)attributes);
        }
        return charBuffer;
    }

    private static StyledDocument getDocument(EditorCookie ec) {
        return ec == null ? null : ec.getDocument();
    }

    private class DocumentStream
    extends OutputStream {
        private static final int BUF_SIZ = 2048;
        private final StyledDocument doc;
        private byte[] data;
        private int pos;

        public DocumentStream(StyledDocument doc) {
            assert (doc != null);
            this.doc = doc;
            this.data = new byte[2048];
            this.pos = 0;
        }

        @Override
        public synchronized void write(byte[] b, int off, int len) throws IOException {
            this.ensureSize(len);
            System.arraycopy(b, off, this.data, this.pos, len);
            this.pos += len;
        }

        @Override
        public synchronized void write(byte[] b) throws IOException {
            this.ensureSize(b.length);
            System.arraycopy(b, 0, this.data, this.pos, b.length);
            this.pos += b.length;
        }

        @Override
        public synchronized void write(int b) throws IOException {
            this.ensureSize(1);
            this.data[this.pos++] = (byte)(b & 0xFF);
        }

        private void ensureSize(int delta) {
            int requiredLength = this.pos + delta;
            if (this.data.length < requiredLength) {
                int newSize;
                for (newSize = this.data.length + 2048; newSize < requiredLength; newSize += 2048) {
                }
                byte[] newData = new byte[newSize];
                System.arraycopy(this.data, 0, newData, 0, this.pos);
                this.data = newData;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void close() throws IOException {
            try {
                NbDocument.runAtomic((StyledDocument)this.doc, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        try {
                            DocumentStream.this.doc.remove(0, DocumentStream.this.doc.getLength());
                            DocumentStream.this.doc.insertString(0, new String(DocumentStream.this.data, 0, DocumentStream.this.pos, encodingName), null);
                        }
                        catch (BadLocationException e) {
                            ErrorManager.getDefault().notify((Throwable)e);
                        }
                        catch (UnsupportedEncodingException ee) {
                            ErrorManager.getDefault().notify((Throwable)ee);
                        }
                    }
                });
            }
            finally {
                SourceFileObject sourceFileObject = SourceFileObject.this;
                synchronized (sourceFileObject) {
                    SourceFileObject.this.text = null;
                }
            }
        }
    }

    private class LckStream
    extends OutputStream {
        private final OutputStream delegate;
        private final FileLock lock;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public LckStream(FileObject fo) throws IOException {
            assert (fo != null);
            this.lock = fo.lock();
            try {
                this.delegate = fo.getOutputStream(this.lock);
            }
            finally {
                if (this.delegate == null) {
                    this.lock.releaseLock();
                }
            }
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.delegate.write(b, off, len);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.delegate.write(b);
        }

        @Override
        public void write(int b) throws IOException {
            this.delegate.write(b);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            try {
                this.delegate.close();
            }
            finally {
                this.lock.releaseLock();
                SourceFileObject sourceFileObject = SourceFileObject.this;
                synchronized (sourceFileObject) {
                    SourceFileObject.this.text = null;
                }
            }
        }
    }
}

