/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsfret.source.usages;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.netbeans.modules.gsf.Language;
import org.netbeans.modules.gsf.LanguageRegistry;
import org.netbeans.modules.gsfret.source.usages.ClassIndexImpl;
import org.netbeans.modules.gsfret.source.usages.Index;
import org.netbeans.modules.gsfret.source.usages.PersistentClassIndex;
import org.openide.util.Exceptions;

public final class ClassIndexManager {
    private final Map<URL, ClassIndexImpl> instances = new HashMap<URL, ClassIndexImpl>();
    private static final ReentrantReadWriteLock lock = new ReentrantReadWriteLock(false);
    private static boolean invalid;
    private Language language;
    private static Map<Language, ClassIndexManager> instanceMap;
    private static final Set<URL> allBootRoots;
    private final Set<URL> bootRoots = new HashSet<URL>();
    private Set<ClassIndexImpl> bootIndices;

    private ClassIndexManager(Language language) {
        this.language = language;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T writeLock(ExceptionAction<T> r) throws IOException {
        lock.writeLock().lock();
        try {
            T t = r.run();
            return t;
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T readLock(ExceptionAction<T> r) throws IOException {
        lock.readLock().lock();
        try {
            T t = r.run();
            return t;
        }
        finally {
            lock.readLock().unlock();
        }
    }

    public static boolean holdsWriteLock() {
        return lock.isWriteLockedByCurrentThread();
    }

    public synchronized ClassIndexImpl getUsagesQuery(URL root) throws IOException {
        assert (root != null);
        if (invalid) {
            return null;
        }
        return this.instances.get(root);
    }

    public synchronized ClassIndexImpl createUsagesQuery(URL root, boolean source) throws IOException {
        assert (root != null);
        if (invalid) {
            return null;
        }
        ClassIndexImpl qi = this.instances.get(root);
        if (qi == null) {
            qi = PersistentClassIndex.create(this.language, root, Index.getDataFolder(this.language, root), source);
            this.instances.put(root, qi);
        }
        return qi;
    }

    synchronized void removeRoot(URL root) throws IOException {
        if (this.bootRoots.contains(root)) {
            return;
        }
        ClassIndexImpl ci = this.instances.remove(root);
        if (ci != null) {
            ci.close();
        }
    }

    public synchronized void close() {
        invalid = true;
        for (ClassIndexImpl ci : this.instances.values()) {
            try {
                ci.close();
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
            }
        }
    }

    public static synchronized ClassIndexManager get(Language language) {
        ClassIndexManager manager = instanceMap.get(language);
        if (manager == null) {
            manager = new ClassIndexManager(language);
            instanceMap.put(language, manager);
        }
        return manager;
    }

    public synchronized Map<URL, ClassIndexImpl> getAllIndices() {
        if (invalid) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.instances);
    }

    public static boolean isBootRoot(URL root) {
        return allBootRoots.contains(root);
    }

    public void addBootRoot(URL root) {
        this.bootRoots.add(root);
        allBootRoots.add(root);
    }

    public void setBootRoots(List<URL> urls) {
        if (this.bootRoots.size() > 0) {
            allBootRoots.removeAll(this.bootRoots);
            this.bootRoots.clear();
        }
        for (URL url : LanguageRegistry.getInstance().getLibraryUrls()) {
            this.bootRoots.add(url);
            allBootRoots.add(url);
        }
        for (URL url : urls) {
            this.bootRoots.add(url);
            allBootRoots.add(url);
        }
        this.bootIndices = null;
    }

    public Set<URL> getBootRoots() {
        return this.bootRoots;
    }

    public static Set<URL> getAllBootRoots() {
        return allBootRoots;
    }

    public Set<ClassIndexImpl> getBootIndices() {
        if (this.bootIndices == null) {
            this.bootIndices = new HashSet<ClassIndexImpl>();
            Set<URL> roots = this.getBootRoots();
            for (URL u : roots) {
                try {
                    ClassIndexImpl ci = this.getUsagesQuery(u);
                    if (ci != null) {
                        this.bootIndices.add(ci);
                        continue;
                    }
                    ci = this.createUsagesQuery(u, false);
                    this.bootIndices.add(ci);
                }
                catch (IOException ioe) {
                    Exceptions.printStackTrace((Throwable)ioe);
                }
            }
        }
        return this.bootIndices;
    }

    static {
        instanceMap = new HashMap<Language, ClassIndexManager>();
        allBootRoots = new HashSet<URL>();
    }

    public static interface ExceptionAction<T> {
        public T run() throws IOException;
    }
}

