/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.impl.structure;

import java.io.Serializable;
import java.util.logging.Level;
import org.netbeans.modules.cnd.apt.impl.structure.APTTokenAndChildBasedNode;
import org.netbeans.modules.cnd.apt.structure.APTFile;
import org.netbeans.modules.cnd.apt.support.APTToken;
import org.netbeans.modules.cnd.apt.utils.APTTraceUtils;
import org.netbeans.modules.cnd.apt.utils.APTUtils;
import org.netbeans.modules.cnd.debug.DebugUtils;

public abstract class APTIfdefConditionBaseNode
extends APTTokenAndChildBasedNode
implements Serializable {
    private static final long serialVersionUID = -5900095440680811076L;
    private APTToken macroName;
    private int endOffset;

    APTIfdefConditionBaseNode(APTIfdefConditionBaseNode orig) {
        super(orig);
        this.macroName = orig.macroName;
        this.endOffset = orig.endOffset;
    }

    protected APTIfdefConditionBaseNode() {
    }

    protected APTIfdefConditionBaseNode(APTToken token) {
        super(token);
    }

    @Override
    public boolean accept(APTFile curFile, APTToken token) {
        if (APTUtils.isID(token)) {
            if (this.macroName != null) {
                if (DebugUtils.STANDALONE) {
                    System.err.printf("%s, line %d: extra tokens after %s at end of %s directive\n", APTTraceUtils.toFileString(curFile), this.getToken().getLine(), this.macroName.getText(), this.getToken().getText().trim());
                } else {
                    APTUtils.LOG.log(Level.SEVERE, "{0}, line {1}: extra tokens after {2} at end of {3} directive", new Object[]{APTTraceUtils.toFileString(curFile), this.getToken().getLine(), this.macroName.getText(), this.getToken().getText().trim()});
                }
            } else {
                this.macroName = token;
            }
        } else if (token.getType() == 56) {
            if (DebugUtils.STANDALONE) {
                System.err.printf("%s, line %d: \"defined\" cannot be used as a macro name\n", APTTraceUtils.toFileString(curFile), this.getToken().getLine());
            } else {
                APTUtils.LOG.log(Level.SEVERE, "{0}, line {1}: \"defined\" cannot be used as a macro name", new Object[]{APTTraceUtils.toFileString(curFile), this.getToken().getLine()});
            }
        }
        if (APTUtils.isEndDirectiveToken(token.getType())) {
            this.endOffset = token.getOffset();
            if (this.macroName == null) {
                if (DebugUtils.STANDALONE) {
                    System.err.printf("%s, line %d: no macro name given in %s directive\n", APTTraceUtils.toFileString(curFile), this.getToken().getLine(), this.getToken().getText().trim());
                } else {
                    APTUtils.LOG.log(Level.SEVERE, "{0}, line {1}: no macro name given in {2} directive ", new Object[]{APTTraceUtils.toFileString(curFile), this.getToken().getLine(), this.getToken().getText().trim()});
                }
            }
            return false;
        }
        return true;
    }

    @Override
    public int getEndOffset() {
        return this.endOffset;
    }

    @Override
    public String getText() {
        assert (this.getToken() != null) : "must have valid preproc directive";
        String retValue = super.getText();
        if (this.getMacroName() != null) {
            retValue = retValue + " MACRO{" + this.getMacroName() + "}";
        }
        return retValue;
    }

    public APTToken getMacroName() {
        return this.macroName;
    }
}

