/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2.view;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextHitInfo;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import org.netbeans.api.editor.settings.EditorStyleConstants;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.editor.lib2.view.DocumentView;
import org.netbeans.modules.editor.lib2.view.EditorView;
import org.netbeans.modules.editor.lib2.view.HighlightsViewPart;
import org.netbeans.modules.editor.lib2.view.PaintState;
import org.netbeans.modules.editor.lib2.view.ParagraphView;
import org.netbeans.modules.editor.lib2.view.TextLayoutView;
import org.netbeans.modules.editor.lib2.view.ViewUtils;

public class HighlightsView
extends EditorView
implements TextLayoutView {
    private static final Logger LOG = Logger.getLogger(HighlightsView.class.getName());
    private int rawOffset;
    private int length;
    private final AttributeSet attributes;

    public HighlightsView(int offset, int length, AttributeSet attributes) {
        super(null);
        assert (length > 0) : "length=" + length + " <= 0";
        this.rawOffset = offset;
        this.length = length;
        this.attributes = attributes;
    }

    @Override
    public float getPreferredSpan(int axis) {
        TextLayout textLayout = this.getTextLayout();
        if (textLayout == null) {
            return 0.0f;
        }
        float span = axis == 0 ? textLayout.getAdvance() : textLayout.getAscent() + textLayout.getDescent() + textLayout.getLeading();
        return ViewUtils.cutFractions(span);
    }

    @Override
    public int getRawOffset() {
        return this.rawOffset;
    }

    @Override
    public void setRawOffset(int rawOffset) {
        this.rawOffset = rawOffset;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public boolean setLength(int length) {
        this.length = length;
        return true;
    }

    @Override
    public int getStartOffset() {
        EditorView.Parent parent = (EditorView.Parent)((Object)this.getParent());
        return parent != null ? parent.getViewOffset(this.rawOffset) : this.rawOffset;
    }

    @Override
    public int getEndOffset() {
        return this.getStartOffset() + this.getLength();
    }

    @Override
    public Document getDocument() {
        View parent = this.getParent();
        return parent != null ? parent.getDocument() : null;
    }

    @Override
    public AttributeSet getAttributes() {
        return this.attributes;
    }

    @Override
    public TextLayout createTextLayout() {
        return this.createTextLayout(0, this.getLength());
    }

    TextLayout createTextLayout(int shift, int length) {
        String text;
        DocumentView documentView = this.getDocumentView();
        if (documentView == null) {
            return null;
        }
        Document doc = documentView.getDocument();
        FontRenderContext frc = documentView.getFontRenderContext();
        if (doc == null || frc == null) {
            return null;
        }
        try {
            text = doc.getText(this.getStartOffset() + shift, length);
            if (documentView.isShowNonprintingCharacters()) {
                text = text.replace(' ', '\u00b7');
            }
        }
        catch (BadLocationException e) {
            return null;
        }
        Font font = ViewUtils.getFont(this.getAttributes(), documentView.getTextComponent().getFont());
        TextLayout textLayout = new TextLayout(text, font, frc);
        return textLayout;
    }

    ParagraphView getParagraphView() {
        return (ParagraphView)this.getParent();
    }

    DocumentView getDocumentView() {
        ParagraphView paragraphView = this.getParagraphView();
        return paragraphView != null ? paragraphView.getDocumentView() : null;
    }

    private TextLayout getTextLayout() {
        EditorView.Parent parent = (EditorView.Parent)((Object)this.getParent());
        return parent != null ? parent.getTextLayout(this) : null;
    }

    @Override
    public Shape modelToViewChecked(int offset, Shape alloc, Position.Bias bias) {
        return HighlightsView.modelToViewChecked(offset, alloc, bias, this.getTextLayout(), this.getStartOffset(), this.getLength());
    }

    static Shape modelToViewChecked(int offset, Shape alloc, Position.Bias bias, TextLayout textLayout, int startOffset, int textLength) {
        float width;
        if (textLayout == null) {
            return alloc;
        }
        assert (textLayout.getCharacterCount() == textLength) : "textLayout.getCharacterCount()=" + textLayout.getCharacterCount() + " != textLength=" + textLength;
        int charIndex = Math.min(offset - startOffset, textLength);
        TextHitInfo hit = bias == Position.Bias.Forward ? TextHitInfo.afterOffset(charIndex) : TextHitInfo.beforeOffset(charIndex);
        float[] locs = textLayout.getCaretInfo(hit);
        if (charIndex < textLength) {
            TextHitInfo endHit = bias == Position.Bias.Forward ? TextHitInfo.afterOffset(charIndex + 1) : TextHitInfo.beforeOffset(charIndex + 1);
            float[] endLocs = textLayout.getCaretInfo(endHit);
            width = endLocs[0] - locs[0];
        } else {
            width = 1.0f;
        }
        Rectangle2D.Double bounds = ViewUtils.shape2Bounds(alloc);
        bounds.setRect(bounds.getX() + (double)locs[0], bounds.getY(), width, bounds.getHeight());
        return bounds;
    }

    @Override
    public int viewToModelChecked(double x, double y, Shape alloc, Position.Bias[] biasReturn) {
        return HighlightsView.viewToModelChecked(x, y, alloc, biasReturn, this.getTextLayout(), this.getStartOffset());
    }

    static int viewToModelChecked(double x, double y, Shape alloc, Position.Bias[] biasReturn, TextLayout textLayout, int startOffset) {
        if (textLayout == null) {
            return startOffset;
        }
        Rectangle2D.Double mutableBounds = ViewUtils.shape2Bounds(alloc);
        TextHitInfo hitInfo = HighlightsView.x2RelOffset(textLayout, (float)(x - mutableBounds.getX()));
        if (biasReturn != null) {
            biasReturn[0] = hitInfo.isLeadingEdge() ? Position.Bias.Forward : Position.Bias.Backward;
        }
        return startOffset + hitInfo.getInsertionIndex();
    }

    static TextHitInfo x2RelOffset(TextLayout textLayout, float x) {
        TextHitInfo hit = x >= textLayout.getAdvance() ? TextHitInfo.trailing(textLayout.getCharacterCount()) : textLayout.hitTestChar(x, 0.0f);
        return hit;
    }

    @Override
    public int getNextVisualPositionFromChecked(int offset, Position.Bias bias, Shape alloc, int direction, Position.Bias[] biasRet) {
        return HighlightsView.getNextVisualPositionFromChecked(offset, bias, alloc, direction, biasRet, this.getTextLayout(), this.getStartOffset(), this.getLength(), this.getDocumentView());
    }

    static int getNextVisualPositionFromChecked(int offset, Position.Bias bias, Shape alloc, int direction, Position.Bias[] biasRet, TextLayout textLayout, int startOffset, int textLength, DocumentView docView) {
        switch (direction) {
            case 1: 
            case 5: {
                Point magicPoint;
                if (offset != -1) {
                    return -1;
                }
                if (docView == null) break;
                JTextComponent textComponent = docView.getTextComponent();
                Caret caret = textComponent.getCaret();
                Point point = magicPoint = caret != null ? caret.getMagicCaretPosition() : null;
                if (magicPoint == null) {
                    biasRet[0] = Position.Bias.Forward;
                    return startOffset;
                }
                return HighlightsView.viewToModelChecked(magicPoint.x, 0.0, alloc, biasRet, textLayout, startOffset);
            }
            case 7: {
                if (offset == -1) {
                    offset = Math.max(0, startOffset + textLength - 1);
                    break;
                }
                offset = Math.max(0, offset - 1);
                break;
            }
            case 3: {
                if (offset == -1) {
                    offset = startOffset;
                    break;
                }
                if (docView == null) break;
                offset = Math.min(offset + 1, docView.getDocument().getLength());
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad direction: " + direction);
            }
        }
        return offset;
    }

    @Override
    public void paint(Graphics2D g, Shape alloc, Rectangle clipBounds) {
        HighlightsView.paint(g, alloc, clipBounds, this, this.getTextLayout(), 0, this.getLength());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void paint(Graphics2D g, Shape alloc, Rectangle clipBounds, HighlightsView view, TextLayout textLayout, int shift, int len) {
        Rectangle2D.Double allocBounds = ViewUtils.shape2Bounds(alloc);
        DocumentView docView = view.getDocumentView();
        if (docView != null && allocBounds.intersects(clipBounds) && docView != null) {
            PaintState paintState = PaintState.save(g);
            try {
                AttributeSet attrs = view.getAttributes();
                HighlightsView.paintBackground(g, allocBounds, attrs, docView);
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.finest(view.getDumpId() + ":paint-bkg: " + ViewUtils.toString(g.getColor()) + ", bounds=" + ViewUtils.toString(allocBounds) + '\n');
                }
                if (textLayout != null) {
                    HighlightsView.paintForeground(g, allocBounds, docView, textLayout, attrs);
                    if (LOG.isLoggable(Level.FINEST)) {
                        int startOffset = view.getStartOffset() + shift;
                        Document doc = docView.getDocument();
                        CharSequence text = DocumentUtilities.getText((Document)doc).subSequence(startOffset, startOffset + len);
                        LOG.finest(view.getDumpId() + ":paint-txt: \"" + CharSequenceUtilities.debugText((CharSequence)text) + "\", XY[" + ViewUtils.toStringPrec1(allocBounds.getX()) + ";" + ViewUtils.toStringPrec1(allocBounds.getY()) + "(B" + ViewUtils.toStringPrec1(docView.getDefaultAscent()) + ")], color=" + ViewUtils.toString(g.getColor()) + '\n');
                    }
                }
            }
            finally {
                paintState.restore();
            }
        }
    }

    static void paintBackground(Graphics2D g, Rectangle2D.Double allocBounds, AttributeSet attrs, DocumentView docView) {
        JTextComponent textComponent = docView.getTextComponent();
        Color componentBackground = textComponent.getBackground();
        float ascent = docView.getDefaultAscent();
        ViewUtils.applyBackgroundAttributes(attrs, componentBackground, g);
        if (!componentBackground.equals(g.getColor())) {
            ViewUtils.fillRect(g, allocBounds);
        }
        if (attrs != null) {
            Color underlineColor;
            Object underlineValue;
            Color waveUnderlineColor;
            int lineX;
            int xInt = (int)allocBounds.getX();
            int yInt = (int)allocBounds.getY();
            int endXInt = (int)(allocBounds.getX() + allocBounds.getWidth() - 1.0);
            int endYInt = (int)(allocBounds.getY() + allocBounds.getHeight() - 1.0);
            Color leftBorderLineColor = (Color)attrs.getAttribute(EditorStyleConstants.LeftBorderLineColor);
            Color rightBorderLineColor = (Color)attrs.getAttribute(EditorStyleConstants.RightBorderLineColor);
            Color topBorderLineColor = (Color)attrs.getAttribute(EditorStyleConstants.TopBorderLineColor);
            Color bottomBorderLineColor = (Color)attrs.getAttribute(EditorStyleConstants.BottomBorderLineColor);
            Color textLimitLineColor = docView.getTextLimitLineColor();
            boolean drawTextLimitLine = docView.isTextLimitLineDrawn();
            int textLimitWidth = docView.getTextLimitWidth();
            float defaultCharWidth = docView.getDefaultCharWidth();
            if (drawTextLimitLine && textLimitWidth > 0 && (lineX = (int)((float)textLimitWidth * defaultCharWidth)) >= xInt && lineX <= endXInt) {
                g.setColor(textLimitLineColor);
                g.drawLine(lineX, yInt, lineX, endYInt);
            }
            if (leftBorderLineColor != null) {
                g.setColor(leftBorderLineColor);
                g.drawLine(xInt, yInt, xInt, endYInt);
            }
            if (rightBorderLineColor != null) {
                g.setColor(rightBorderLineColor);
                g.drawLine(endXInt, yInt, endXInt, endYInt);
            }
            if (topBorderLineColor != null) {
                g.setColor(topBorderLineColor);
                g.drawLine(xInt, yInt, endXInt, yInt);
            }
            if (bottomBorderLineColor != null) {
                g.setColor(bottomBorderLineColor);
                g.drawLine(xInt, endYInt, endXInt, endYInt);
            }
            if ((waveUnderlineColor = (Color)attrs.getAttribute(EditorStyleConstants.WaveUnderlineColor)) != null && bottomBorderLineColor == null) {
                g.setColor(waveUnderlineColor);
                float underlineOffset = docView.getDefaultUnderlineOffset() + ascent;
                int y = (int)(allocBounds.getY() + (double)underlineOffset + 0.5);
                int wavePixelCount = (int)allocBounds.getWidth() + 1;
                if (wavePixelCount > 0) {
                    int[] waveForm = new int[]{0, 0, -1, -1};
                    int[] xArray = new int[wavePixelCount];
                    int[] yArray = new int[wavePixelCount];
                    int waveFormIndex = xInt % 4;
                    for (int i = 0; i < wavePixelCount; ++i) {
                        xArray[i] = xInt + i;
                        yArray[i] = y + waveForm[waveFormIndex];
                        ++waveFormIndex;
                        waveFormIndex &= 3;
                    }
                    g.drawPolyline(xArray, yArray, wavePixelCount - 1);
                }
            }
            if ((underlineValue = attrs.getAttribute(StyleConstants.Underline)) != null && (underlineColor = underlineValue instanceof Boolean ? (Boolean.TRUE.equals(underlineValue) ? textComponent.getForeground() : null) : (Color)underlineValue) != null) {
                g.setColor(underlineColor);
                float underlineOffset = docView.getDefaultUnderlineOffset();
                float underlineThickness = docView.getDefaultUnderlineThickness();
                g.fillRect((int)allocBounds.getX(), (int)(allocBounds.getY() + (double)docView.getDefaultAscent() + (double)underlineOffset), (int)allocBounds.getWidth(), Math.max(1, Math.round(underlineThickness)));
            }
        }
    }

    static void paintForeground(Graphics2D g, Rectangle2D.Double allocBounds, DocumentView docView, TextLayout textLayout, AttributeSet attrs) {
        Color strikeThroughColor;
        Object strikeThroughValue;
        JTextComponent textComponent = docView.getTextComponent();
        ViewUtils.applyForegroundAttributes(attrs, textComponent.getFont(), textComponent.getForeground(), g);
        HighlightsView.paintTextLayout(g, allocBounds, docView, textLayout);
        if (attrs != null && (strikeThroughValue = attrs.getAttribute(StyleConstants.StrikeThrough)) != null && (strikeThroughColor = strikeThroughValue instanceof Boolean ? (Boolean.TRUE.equals(strikeThroughValue) ? textComponent.getForeground() : null) : (Color)strikeThroughValue) != null) {
            g.setColor(strikeThroughColor);
            float strikeOffset = docView.getDefaultStrikethroughOffset();
            float strikeThickness = docView.getDefaultStrikethroughThickness();
            g.fillRect((int)allocBounds.getX(), (int)(allocBounds.getY() + (double)docView.getDefaultAscent() + (double)strikeOffset), (int)allocBounds.getWidth(), Math.max(1, Math.round(strikeThickness)));
        }
    }

    static void paintTextLayout(Graphics2D g, Rectangle2D.Double bounds, DocumentView docView, TextLayout textLayout) {
        float baselineOffset = docView.getDefaultAscent();
        float x = (float)bounds.getX();
        float y = (float)bounds.getY();
        textLayout.draw(g, x, y + baselineOffset);
    }

    @Override
    public View breakView(int axis, int offset, float x, float len) {
        View part = HighlightsView.breakView(axis, offset, x, len, this, 0, this.getLength(), this.getTextLayout());
        return part != null ? part : this;
    }

    static View breakView(int axis, int breakPartStartOffset, float x, float len, HighlightsView fullView, int partShift, int partLength, TextLayout textLayout) {
        DocumentView docView;
        if (axis == 0 && (docView = fullView.getDocumentView()) != null && textLayout != null && partLength > 1) {
            boolean breakFailed;
            float breakCharIndexX;
            int fullViewStartOffset = fullView.getStartOffset();
            int partStartOffset = fullViewStartOffset + partShift;
            if (breakPartStartOffset - partStartOffset < 0 || breakPartStartOffset - partStartOffset > partLength) {
                throw new IllegalArgumentException("offset=" + breakPartStartOffset + "partStartOffset=" + partStartOffset + ", partLength=" + partLength);
            }
            int breakCharIndex = breakPartStartOffset - partStartOffset;
            assert (breakCharIndex >= 0);
            if (breakCharIndex != 0) {
                TextHitInfo hit = TextHitInfo.afterOffset(breakCharIndex);
                float[] locs = textLayout.getCaretInfo(hit);
                breakCharIndexX = locs[0];
            } else {
                breakCharIndexX = 0.0f;
            }
            TextHitInfo hitInfo = HighlightsView.x2RelOffset(textLayout, breakCharIndexX + len);
            int breakPartEndOffset = partStartOffset + hitInfo.getCharIndex();
            if (docView.getLineWrapType() == DocumentView.LineWrapType.WORD_BOUND) {
                CharSequence docText = DocumentUtilities.getText((Document)docView.getDocument());
                if (breakPartEndOffset > breakPartStartOffset) {
                    boolean searchNonLetterForward = false;
                    char ch = docText.charAt(breakPartEndOffset - 1);
                    if (Character.isLetterOrDigit(ch) && breakPartEndOffset < docText.length() && Character.isLetterOrDigit(docText.charAt(breakPartEndOffset))) {
                        int offset;
                        for (offset = breakPartEndOffset - 1; offset >= breakPartStartOffset && Character.isLetterOrDigit(docText.charAt(offset)); --offset) {
                        }
                        if (++offset == breakPartStartOffset) {
                            searchNonLetterForward = true;
                        } else {
                            breakPartEndOffset = offset;
                        }
                    }
                    if (searchNonLetterForward) {
                        ++breakPartEndOffset;
                        while (breakPartEndOffset < partStartOffset + partLength && Character.isLetterOrDigit(docText.charAt(breakPartEndOffset))) {
                            ++breakPartEndOffset;
                        }
                    }
                }
            }
            boolean bl = breakFailed = breakPartEndOffset - breakPartStartOffset == 0 || breakPartEndOffset - breakPartStartOffset >= partLength;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("HV.breakView(): <" + partStartOffset + "," + (partStartOffset + partLength) + "> => <" + breakPartStartOffset + "," + (partStartOffset + breakPartEndOffset) + ">, x=" + x + ", len=" + len + ", charIndexX=" + breakCharIndexX + "\n");
            }
            if (breakFailed) {
                return null;
            }
            return new HighlightsViewPart(fullView, breakPartStartOffset - fullViewStartOffset, breakPartEndOffset - breakPartStartOffset);
        }
        return null;
    }

    @Override
    public View createFragment(int p0, int p1) {
        int startOffset = this.getStartOffset();
        ViewUtils.checkFragmentBounds(p0, p1, startOffset, this.getLength());
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("HV.createFragment(" + p0 + "," + p1 + "): <" + this.getStartOffset() + "," + this.getEndOffset() + ">\n");
        }
        return new HighlightsViewPart(this, p0 - startOffset, p1 - p0);
    }

    @Override
    protected String getDumpName() {
        return "HV";
    }

    public String toString() {
        return this.appendViewInfo(new StringBuilder(200), 0, -1).toString();
    }
}

