/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2.view;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.util.logging.Logger;
import javax.swing.text.AttributeSet;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.TabExpander;
import javax.swing.text.TabableView;
import javax.swing.text.View;
import org.netbeans.modules.editor.lib2.view.DocumentView;
import org.netbeans.modules.editor.lib2.view.EditorView;
import org.netbeans.modules.editor.lib2.view.HighlightsView;
import org.netbeans.modules.editor.lib2.view.ParagraphView;
import org.netbeans.modules.editor.lib2.view.ViewUtils;

public final class TabView
extends EditorView
implements TabableView {
    private static final Logger LOG = Logger.getLogger(TabView.class.getName());
    private int rawOffset;
    private int length;
    private final AttributeSet attributes;
    private float firstTabWidth;
    private float width;

    public TabView(int offset, int length, AttributeSet attributes) {
        super(null);
        assert (length > 0) : "Length == 0";
        this.rawOffset = offset;
        this.length = length;
        this.attributes = attributes;
    }

    @Override
    public float getPreferredSpan(int axis) {
        DocumentView docView = this.getDocumentView();
        return axis == 0 ? this.width : (docView != null ? docView.getDefaultLineHeight() : 0.0f);
    }

    @Override
    public float getTabbedSpan(float x, TabExpander e) {
        int offset = this.getStartOffset();
        int endOffset = offset + this.getLength();
        float tabX = e.nextTabStop(x, offset++);
        this.firstTabWidth = tabX - x;
        while (offset < endOffset) {
            tabX = e.nextTabStop(tabX, offset++);
        }
        this.width = tabX - x;
        return this.width;
    }

    @Override
    public float getPartialSpan(int p0, int p1) {
        return 0.0f;
    }

    @Override
    public int getRawOffset() {
        return this.rawOffset;
    }

    @Override
    public void setRawOffset(int rawOffset) {
        this.rawOffset = rawOffset;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public boolean setLength(int length) {
        this.length = length;
        return true;
    }

    @Override
    public int getStartOffset() {
        EditorView.Parent parent = (EditorView.Parent)((Object)this.getParent());
        return parent != null ? parent.getViewOffset(this.rawOffset) : this.rawOffset;
    }

    @Override
    public int getEndOffset() {
        return this.getStartOffset() + this.getLength();
    }

    @Override
    public AttributeSet getAttributes() {
        return this.attributes;
    }

    ParagraphView getParagraphView() {
        return (ParagraphView)this.getParent();
    }

    DocumentView getDocumentView() {
        ParagraphView paragraphView = this.getParagraphView();
        return paragraphView != null ? paragraphView.getDocumentView() : null;
    }

    @Override
    public Shape modelToViewChecked(int offset, Shape alloc, Position.Bias bias) {
        int startOffset = this.getStartOffset();
        Rectangle2D.Double mutableBounds = ViewUtils.shape2Bounds(alloc);
        int charIndex = offset - startOffset;
        if (charIndex == 1) {
            mutableBounds.x += (double)this.firstTabWidth;
        } else {
            int extraTabCount = this.getLength() - 1;
            if (extraTabCount > 0) {
                mutableBounds.x += (double)(this.firstTabWidth + (float)(charIndex - 1) * ((this.width - this.firstTabWidth) / (float)extraTabCount));
            }
        }
        mutableBounds.width = 1.0;
        return mutableBounds;
    }

    @Override
    public int viewToModelChecked(double x, double y, Shape alloc, Position.Bias[] biasReturn) {
        int endOffset;
        int offset = this.getStartOffset();
        Rectangle2D.Double mutableBounds = ViewUtils.shape2Bounds(alloc);
        double cmpX = mutableBounds.x + (double)(this.firstTabWidth / 2.0f);
        if (x > cmpX && ++offset < (endOffset = offset + this.getLength())) {
            float tabWidth = (this.width - this.firstTabWidth) / (float)(endOffset - offset);
            cmpX += (double)(this.firstTabWidth / 2.0f + tabWidth / 2.0f);
            while (x > cmpX && offset < endOffset) {
                cmpX += (double)tabWidth;
                ++offset;
            }
        }
        return offset;
    }

    @Override
    public int getNextVisualPositionFromChecked(int offset, Position.Bias bias, Shape alloc, int direction, Position.Bias[] biasRet) {
        int startOffset = this.getStartOffset();
        switch (direction) {
            case 1: 
            case 5: {
                Point magicPoint;
                if (offset != -1) {
                    return -1;
                }
                DocumentView docView = this.getDocumentView();
                if (docView == null) break;
                JTextComponent textComponent = docView.getTextComponent();
                Caret caret = textComponent.getCaret();
                Point point = magicPoint = caret != null ? caret.getMagicCaretPosition() : null;
                if (magicPoint == null) {
                    biasRet[0] = Position.Bias.Forward;
                    return startOffset;
                }
                return this.viewToModelChecked(magicPoint.x, 0.0, alloc, biasRet);
            }
            case 7: {
                if (offset == -1) {
                    offset = Math.max(0, this.getEndOffset() - 1);
                    break;
                }
                offset = Math.max(0, offset - 1);
                break;
            }
            case 3: {
                if (offset == -1) {
                    offset = this.getStartOffset();
                    break;
                }
                offset = Math.min(offset + 1, this.getDocument().getLength());
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad direction: " + direction);
            }
        }
        return offset;
    }

    @Override
    public void paint(Graphics2D g, Shape alloc, Rectangle clipBounds) {
        DocumentView docView = this.getDocumentView();
        if (docView != null) {
            TextLayout showTabLayout;
            AttributeSet attrs = this.getAttributes();
            Rectangle2D.Double mutableBounds = ViewUtils.shape2Bounds(alloc);
            HighlightsView.paintBackground(g, mutableBounds, attrs, docView);
            TextLayout textLayout = showTabLayout = docView.isShowNonprintingCharacters() ? docView.getTabCharTextLayout(this.firstTabWidth) : null;
            if (showTabLayout != null) {
                HighlightsView.paintForeground(g, mutableBounds, docView, showTabLayout, attrs);
                mutableBounds.x += (double)this.firstTabWidth;
                mutableBounds.width -= (double)this.firstTabWidth;
                int len = this.getLength() - 1;
                if (len > 0) {
                    float nextTabWidth = (this.width - this.firstTabWidth) / (float)len;
                    showTabLayout = docView.getTabCharTextLayout(nextTabWidth);
                    while (--len >= 0) {
                        HighlightsView.paintTextLayout(g, mutableBounds, docView, showTabLayout);
                        mutableBounds.x += (double)nextTabWidth;
                        mutableBounds.width -= (double)nextTabWidth;
                    }
                }
            }
        }
    }

    @Override
    public View breakView(int axis, int offset, float pos, float len) {
        return this;
    }

    @Override
    public View createFragment(int p0, int p1) {
        ViewUtils.checkFragmentBounds(p0, p1, this.getStartOffset(), this.getLength());
        return this;
    }

    @Override
    protected String getDumpName() {
        return "TV";
    }

    public String toString() {
        return this.appendViewInfo(new StringBuilder(200), 0, -1).toString();
    }
}

