/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.asm.base;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.cnd.asm.base.BaseAsmModel;
import org.netbeans.modules.cnd.asm.model.AsmModel;
import org.netbeans.modules.cnd.asm.model.AsmModelProvider;
import org.netbeans.modules.cnd.asm.model.util.EmptyModel;

public abstract class BaseModelProvider
implements AsmModelProvider {
    private final String resource;
    private Reference<AsmModel> modelRef;

    public BaseModelProvider(String resource) {
        this.resource = resource;
        this.modelRef = new SoftReference<Object>(null);
    }

    @Override
    public synchronized AsmModel getModel() {
        AsmModel model = this.modelRef.get();
        if (model == null) {
            model = this.load();
            this.modelRef = new SoftReference<AsmModel>(model);
        }
        return model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AsmModel load() {
        BaseAsmModel model;
        InputStream stream = null;
        try {
            stream = this.getClass().getResourceAsStream(this.resource);
            model = new BaseAsmModel(new InputStreamReader(stream));
        }
        catch (Exception ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Can't load xml model", ex);
            AsmModel asmModel = EmptyModel.getInstance();
            return asmModel;
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Exception ex) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Can't load xml model", ex);
                    return EmptyModel.getInstance();
                }
            }
        }
        return model;
    }
}

