/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.text.BadLocationException;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.EditList;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.php.editor.api.ElementQuery;
import org.netbeans.modules.php.editor.api.PhpElementKind;
import org.netbeans.modules.php.editor.api.elements.BaseFunctionElement;
import org.netbeans.modules.php.editor.api.elements.ElementFilter;
import org.netbeans.modules.php.editor.api.elements.MethodElement;
import org.netbeans.modules.php.editor.api.elements.PhpElement;
import org.netbeans.modules.php.editor.api.elements.TypeElement;
import org.netbeans.modules.php.editor.model.MethodScope;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.TypeScope;
import org.netbeans.modules.php.editor.verification.AbstractRule;
import org.netbeans.modules.php.editor.verification.PHPHintsProvider;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;
import org.openide.util.NbBundle;

public class ImplementAbstractMethods
extends AbstractRule {
    public String getId() {
        return "Implement.Abstract.Methods";
    }

    public String getDescription() {
        return NbBundle.getMessage(ImplementAbstractMethods.class, (String)"ImplementAbstractMethodsDesc");
    }

    public String getDisplayName() {
        return NbBundle.getMessage(ImplementAbstractMethods.class, (String)"ImplementAbstractMethodsDispName");
    }

    @Override
    void computeHintsImpl(PHPRuleContext context, List<Hint> hints, PHPHintsProvider.Kind kind) throws BadLocationException {
        BaseDocument doc = context.doc;
        int caretOffset = context.caretOffset;
        int lineBegin = -1;
        int lineEnd = -1;
        lineBegin = caretOffset > 0 ? Utilities.getRowStart((BaseDocument)doc, (int)caretOffset) : -1;
        int n = lineEnd = lineBegin != -1 ? Utilities.getRowEnd((BaseDocument)doc, (int)caretOffset) : -1;
        if (lineBegin != -1 && lineEnd != -1 && caretOffset > lineBegin) {
            Collection<? extends TypeScope> allTypes = ModelUtils.getDeclaredTypes(context.fileScope);
            for (FixInfo fixInfo : this.checkHints(allTypes, lineBegin, lineEnd, context)) {
                hints.add(new Hint((Rule)this, this.getDisplayName(), context.parserResult.getSnapshot().getSource().getFileObject(), fixInfo.classNameRange, Collections.singletonList(new Fix(context, fixInfo)), 500));
            }
        }
    }

    private static boolean isInside(int carret, int left, int right) {
        return carret >= left && carret <= right;
    }

    private Collection<FixInfo> checkHints(Collection<? extends TypeScope> allTypes, int lineBegin, int lineEnd, PHPRuleContext context) throws BadLocationException {
        ArrayList<FixInfo> retval = new ArrayList<FixInfo>();
        for (TypeScope typeScope : allTypes) {
            int offset;
            if (!ImplementAbstractMethods.isInside(typeScope.getOffset(), lineBegin, lineEnd)) continue;
            ElementQuery.Index index = context.getIndex();
            ElementFilter declaredMethods = ElementFilter.forExcludedNames(ImplementAbstractMethods.toNames(index.getDeclaredMethods(typeScope)), PhpElementKind.METHOD);
            Set<MethodElement> accessibleMethods = declaredMethods.filter(index.getAccessibleMethods(typeScope, typeScope));
            LinkedHashSet<String> methodSkeletons = new LinkedHashSet<String>();
            for (MethodElement methodElement : accessibleMethods) {
                TypeElement type = methodElement.getType();
                if (!type.isInterface() && !methodElement.isAbstract() || methodElement.isFinal()) continue;
                String skeleton = methodElement.asString(BaseFunctionElement.PrintAs.DeclarationWithEmptyBody);
                skeleton = skeleton.replace("abstract ", "");
                methodSkeletons.add(skeleton);
            }
            if (methodSkeletons.isEmpty() || (offset = ImplementAbstractMethods.getOffset(typeScope, context)) == -1) continue;
            retval.add(new FixInfo(typeScope, methodSkeletons, offset));
        }
        return retval;
    }

    private static Set<String> toNames(Set<? extends PhpElement> elements) {
        HashSet<String> names = new HashSet<String>();
        for (PhpElement phpElement : elements) {
            names.add(phpElement.getName());
        }
        return names;
    }

    private static int getOffset(TypeScope typeScope, PHPRuleContext context) throws BadLocationException {
        int offset = -1;
        Collection<? extends MethodScope> declaredMethods = typeScope.getDeclaredMethods();
        for (MethodScope methodScope : declaredMethods) {
            OffsetRange blockRange = methodScope.getBlockRange();
            if (blockRange == null || blockRange.getEnd() <= offset) continue;
            offset = blockRange.getEnd();
        }
        if (offset == -1 && typeScope.getBlockRange() != null) {
            offset = Utilities.getRowStart((BaseDocument)context.doc, (int)typeScope.getBlockRange().getEnd()) - 1;
        }
        if (offset != -1) {
            offset = Utilities.getRowEnd((BaseDocument)context.doc, (int)offset);
        }
        return offset;
    }

    private static class FixInfo {
        private List<String> methodSkeletons;
        private int offset;
        private OffsetRange classNameRange;

        FixInfo(TypeScope typeScope, LinkedHashSet<String> methodSkeletons, int offset) {
            this.methodSkeletons = new ArrayList<String>(methodSkeletons);
            Collections.sort(this.methodSkeletons);
            this.classNameRange = typeScope.getNameRange();
            this.offset = offset;
        }
    }

    private class Fix
    implements HintFix {
        private RuleContext context;
        private final FixInfo fixInfo;

        Fix(RuleContext context, FixInfo fixInfo) {
            this.context = context;
            this.fixInfo = fixInfo;
        }

        public String getDescription() {
            return ImplementAbstractMethods.this.getDescription();
        }

        public void implement() throws Exception {
            this.getEditList().apply();
        }

        public boolean isSafe() {
            return true;
        }

        public boolean isInteractive() {
            return false;
        }

        EditList getEditList() throws Exception {
            BaseDocument doc = this.context.doc;
            EditList edits = new EditList(doc);
            for (String methodScope : this.fixInfo.methodSkeletons) {
                edits.replace(this.fixInfo.offset, 0, "\n" + methodScope, true, 0);
            }
            return edits;
        }
    }
}

