/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.peephole;

import java.util.HashSet;
import java.util.Set;
import proguard.classfile.Clazz;
import proguard.classfile.ProgramClass;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.constant.visitor.ExceptClassConstantFilter;
import proguard.classfile.editor.AttributeAdder;
import proguard.classfile.editor.InterfaceAdder;
import proguard.classfile.editor.MemberAdder;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.AllMethodVisitor;
import proguard.classfile.visitor.ClassCollector;
import proguard.classfile.visitor.ClassHierarchyTraveler;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.ImplementedClassConstantFilter;
import proguard.classfile.visitor.ImplementingClassConstantFilter;
import proguard.classfile.visitor.MemberAccessFilter;
import proguard.classfile.visitor.MemberCollector;
import proguard.classfile.visitor.MemberCounter;
import proguard.classfile.visitor.MemberNameFilter;
import proguard.classfile.visitor.MemberToClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.classfile.visitor.MultiMemberVisitor;
import proguard.classfile.visitor.NamedMethodVisitor;
import proguard.classfile.visitor.ReferencedClassVisitor;
import proguard.classfile.visitor.SimilarMemberVisitor;
import proguard.optimize.KeepMarker;
import proguard.optimize.info.CaughtClassFilter;
import proguard.optimize.info.ClassOptimizationInfo;
import proguard.optimize.info.DotClassMarker;
import proguard.optimize.info.InstanceofClassFilter;
import proguard.optimize.info.InstantiationClassMarker;
import proguard.optimize.info.PackageVisibleMemberContainingClassMarker;
import proguard.optimize.info.PackageVisibleMemberInvokingClassMarker;
import proguard.util.FixedStringMatcher;
import proguard.util.NotMatcher;

public class ClassMerger
extends SimplifiedVisitor
implements ClassVisitor,
ConstantVisitor {
    private static final boolean DEBUG = false;
    private final ProgramClass targetClass;
    private final boolean allowAccessModification;
    private final boolean mergeInterfacesAggressively;
    private final ClassVisitor extraClassVisitor;

    public ClassMerger(ProgramClass programClass, boolean bl, boolean bl2) {
        this(programClass, bl, bl2, null);
    }

    public ClassMerger(ProgramClass programClass, boolean bl, boolean bl2, ClassVisitor classVisitor) {
        this.targetClass = programClass;
        this.allowAccessModification = bl;
        this.mergeInterfacesAggressively = bl2;
        this.extraClassVisitor = classVisitor;
    }

    public void visitProgramClass(ProgramClass programClass) {
        try {
            this.visitProgramClass0(programClass);
        }
        catch (RuntimeException runtimeException) {
            System.err.println("Unexpected error while merging classes:");
            System.err.println("  Class        = [" + programClass.getName() + "]");
            System.err.println("  Target class = [" + this.targetClass.getName() + "]");
            System.err.println("  Exception    = [" + runtimeException.getClass().getName() + "] (" + runtimeException.getMessage() + ")");
            throw runtimeException;
        }
    }

    public void visitProgramClass0(ProgramClass programClass) {
        if (!(programClass.equals(this.targetClass) || KeepMarker.isKept(programClass) || KeepMarker.isKept(this.targetClass) || ClassMerger.getTargetClass(programClass) != null || ClassMerger.getTargetClass(this.targetClass) != null || (programClass.getAccessFlags() & 0x2000) != 0 || !this.allowAccessModification && ((programClass.getAccessFlags() & this.targetClass.getAccessFlags() & 1) == 0 || PackageVisibleMemberContainingClassMarker.containsPackageVisibleMembers(programClass) || PackageVisibleMemberInvokingClassMarker.invokesPackageVisibleMembers(programClass)) && !ClassUtil.internalPackageName(programClass.getName()).equals(ClassUtil.internalPackageName(this.targetClass.getName())) || (programClass.getAccessFlags() & 0x600) != (this.targetClass.getAccessFlags() & 0x600) && (!this.isOnlySubClass(programClass, this.targetClass) || !programClass.getSuperClass().equals(this.targetClass) && !programClass.getSuperClass().equals(this.targetClass.getSuperClass())) || this.indirectlyImplementedInterfaces(programClass).contains(this.targetClass) || this.targetClass.extendsOrImplements(programClass) || !((Object)this.initializedSuperClasses(programClass)).equals(this.initializedSuperClasses(this.targetClass)) || !((Object)this.instanceofedSuperClasses(programClass)).equals(this.instanceofedSuperClasses(this.targetClass)) || !((Object)this.caughtSuperClasses(programClass)).equals(this.caughtSuperClasses(this.targetClass)) || DotClassMarker.isDotClassed(programClass) && DotClassMarker.isDotClassed(this.targetClass) || this.introducesUnwantedFields(programClass, this.targetClass) || this.introducesUnwantedFields(this.targetClass, programClass) || this.haveAnyIdenticalInitializers(programClass, this.targetClass) || !this.mergeInterfacesAggressively && (this.introducesUnwantedAbstractMethods(programClass, this.targetClass) || this.introducesUnwantedAbstractMethods(this.targetClass, programClass)) || this.overridesAnyMethods(programClass, this.targetClass) || this.overridesAnyMethods(this.targetClass, programClass) || this.shadowsAnyMethods(programClass, this.targetClass) || this.shadowsAnyMethods(this.targetClass, programClass))) {
            int n = this.targetClass.getAccessFlags();
            int n2 = programClass.getAccessFlags();
            this.targetClass.u2accessFlags = n & n2 & 0x600 | (n | n2) & 0x6001;
            programClass.interfaceConstantsAccept(new ExceptClassConstantFilter(this.targetClass.getName(), new ImplementedClassConstantFilter(this.targetClass, new ImplementingClassConstantFilter(this.targetClass, new InterfaceAdder(this.targetClass)))));
            MemberAdder memberAdder = new MemberAdder(this.targetClass);
            programClass.fieldsAccept(memberAdder);
            programClass.methodsAccept(memberAdder);
            programClass.attributesAccept(new AttributeAdder(this.targetClass, true));
            ClassOptimizationInfo classOptimizationInfo = ClassOptimizationInfo.getClassOptimizationInfo(this.targetClass);
            if (classOptimizationInfo != null) {
                classOptimizationInfo.merge(ClassOptimizationInfo.getClassOptimizationInfo(programClass));
            }
            ClassMerger.setTargetClass(programClass, this.targetClass);
            if (this.extraClassVisitor != null) {
                this.extraClassVisitor.visitProgramClass(programClass);
            }
        }
    }

    private boolean isOnlySubClass(Clazz clazz, ProgramClass programClass) {
        return programClass.subClasses != null && programClass.subClasses.length == 1 && programClass.subClasses[0].equals(clazz);
    }

    private Set indirectlyImplementedInterfaces(Clazz clazz) {
        HashSet hashSet = new HashSet();
        ReferencedClassVisitor referencedClassVisitor = new ReferencedClassVisitor(new ClassHierarchyTraveler(false, false, true, false, new ClassCollector(hashSet)));
        clazz.superClassConstantAccept(referencedClassVisitor);
        clazz.interfaceConstantsAccept(referencedClassVisitor);
        return hashSet;
    }

    private Set initializedSuperClasses(Clazz clazz) {
        HashSet hashSet = new HashSet();
        clazz.hierarchyAccept(true, true, true, false, new NamedMethodVisitor("<clinit>", "()V", new MemberToClassVisitor(new ClassCollector(hashSet))));
        return hashSet;
    }

    private Set instanceofedSuperClasses(Clazz clazz) {
        HashSet hashSet = new HashSet();
        clazz.hierarchyAccept(true, true, true, false, new InstanceofClassFilter(new ClassCollector(hashSet)));
        return hashSet;
    }

    private Set caughtSuperClasses(Clazz clazz) {
        HashSet hashSet = new HashSet();
        clazz.hierarchyAccept(true, true, false, false, new CaughtClassFilter(new ClassCollector(hashSet)));
        return hashSet;
    }

    private boolean introducesUnwantedFields(ProgramClass programClass, ProgramClass programClass2) {
        return programClass.u2fieldsCount != 0 && (InstantiationClassMarker.isInstantiated(programClass2) || programClass2.subClasses != null && !this.isOnlySubClass(programClass, programClass2));
    }

    private boolean haveAnyIdenticalInitializers(Clazz clazz, Clazz clazz2) {
        MemberCounter memberCounter = new MemberCounter();
        clazz.methodsAccept(new SimilarMemberVisitor(clazz2, true, false, false, false, new MemberAccessFilter(0, 1024, memberCounter)));
        return memberCounter.getCount() > 0;
    }

    private boolean introducesUnwantedAbstractMethods(Clazz clazz, ProgramClass programClass) {
        if ((programClass.getAccessFlags() & 0x600) != 0 && (programClass.subClasses == null || this.isOnlySubClass(clazz, programClass))) {
            return false;
        }
        MemberCounter memberCounter = new MemberCounter();
        HashSet hashSet = new HashSet();
        clazz.methodsAccept(new MemberAccessFilter(1024, 0, new MultiMemberVisitor(new MemberVisitor[]{memberCounter, new SimilarMemberVisitor(programClass, true, true, true, false, new MemberAccessFilter(1024, 0, new MemberCollector(hashSet)))})));
        return hashSet.size() < memberCounter.getCount();
    }

    private boolean overridesAnyMethods(Clazz clazz, Clazz clazz2) {
        MemberCounter memberCounter = new MemberCounter();
        clazz.methodsAccept(new MemberAccessFilter(0, 1034, new MemberNameFilter(new NotMatcher(new FixedStringMatcher("<clinit>")), (MemberVisitor)new MemberNameFilter(new NotMatcher(new FixedStringMatcher("<init>")), (MemberVisitor)new SimilarMemberVisitor(clazz2, true, true, false, false, new MemberAccessFilter(0, 1034, memberCounter))))));
        return memberCounter.getCount() > 0;
    }

    private boolean shadowsAnyMethods(Clazz clazz, Clazz clazz2) {
        MemberCounter memberCounter = new MemberCounter();
        clazz.hierarchyAccept(true, false, false, true, new AllMethodVisitor(new MemberAccessFilter(2, 0, new MemberNameFilter(new NotMatcher(new FixedStringMatcher("<init>")), (MemberVisitor)new SimilarMemberVisitor(clazz2, true, true, true, false, new MemberAccessFilter(0, 2, memberCounter))))));
        clazz.hierarchyAccept(true, false, false, true, new AllMethodVisitor(new MemberAccessFilter(8, 0, new MemberNameFilter(new NotMatcher(new FixedStringMatcher("<clinit>")), (MemberVisitor)new SimilarMemberVisitor(clazz2, true, true, true, false, new MemberAccessFilter(0, 2, memberCounter))))));
        return memberCounter.getCount() > 0;
    }

    public static void setTargetClass(Clazz clazz, Clazz clazz2) {
        ClassOptimizationInfo classOptimizationInfo = ClassOptimizationInfo.getClassOptimizationInfo(clazz);
        if (classOptimizationInfo != null) {
            classOptimizationInfo.setTargetClass(clazz2);
        }
    }

    public static Clazz getTargetClass(Clazz clazz) {
        Clazz clazz2 = null;
        ClassOptimizationInfo classOptimizationInfo;
        while ((classOptimizationInfo = ClassOptimizationInfo.getClassOptimizationInfo(clazz)) != null) {
            clazz = classOptimizationInfo.getTargetClass();
            if (clazz == null) {
                return clazz2;
            }
            clazz2 = clazz;
        }
        return clazz2;
    }
}

