/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import org.netbeans.modules.search.Utils;

class SearchTypeInputStream
extends ObjectInputStream {
    private Class extSearchType = null;
    private ClassLoader extClassLoader = null;

    public SearchTypeInputStream(InputStream in) throws IOException {
        super(in);
    }

    protected Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
        try {
            return super.resolveClass(objectStreamClass);
        }
        catch (ClassNotFoundException ex) {
            Class extClass = this.resolveExtClass(objectStreamClass.getName());
            if (extClass != null) {
                return extClass;
            }
            throw ex;
        }
    }

    private Class resolveExtClass(String className) {
        if (this.extSearchType == null) {
            this.extSearchType = Utils.searchTypeForName(className);
            return this.extSearchType;
        }
        if (this.extClassLoader == null) {
            try {
                this.extClassLoader = this.extSearchType.getClassLoader();
            }
            catch (SecurityException ex) {
                return null;
            }
        }
        try {
            return this.extClassLoader.loadClass(className);
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
    }
}

