/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.BeanInfo;
import java.beans.Customizer;
import java.beans.IntrospectionException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.netbeans.modules.search.DialogLifetime;
import org.openide.ErrorManager;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openidex.search.SearchType;

public final class SearchTypePanel
extends JPanel
implements PropertyChangeListener,
ActionListener,
DialogLifetime {
    public static final String PROP_CUSTOMIZED = "customized";
    private static final String MODIFICATOR_SUFFIX = " *";
    private boolean customized;
    private SearchType searchType;
    private boolean initialized = false;
    final Customizer customizer;
    final Component customizerComponent;
    private String lastSavedName;
    private final JCheckBox applyCheckBox = new JCheckBox();
    private JPanel customizerPanel;

    public SearchTypePanel(SearchType searchType) {
        this.initComponents();
        this.initAccessibility();
        this.searchType = searchType;
        this.customizer = SearchTypePanel.createCustomizer(this.searchType);
        if (this.customizer != null) {
            this.customizerComponent = (Component)((Object)this.customizer);
        } else {
            this.customizerComponent = null;
            this.initialized = true;
            System.err.println("No customizer for " + this.searchType.getName() + ", skipping...");
        }
        this.customizer.setObject(this.searchType);
        this.searchType.addPropertyChangeListener((PropertyChangeListener)this);
        ResourceBundle bundle = NbBundle.getBundle(SearchTypePanel.class);
        Mnemonics.setLocalizedText((AbstractButton)this.applyCheckBox, (String)bundle.getString("TEXT_BUTTON_APPLY"));
        this.customizerPanel.add(this.customizerComponent, "Center");
        this.setCustomized(this.searchType.isValid());
        this.setName(this.createName());
    }

    private void initAccessibility() {
        ResourceBundle bundle = NbBundle.getBundle(SearchTypePanel.class);
        this.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_DIALOG_DESC"));
        this.applyCheckBox.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_TEXT_BUTTON_APPLY"));
    }

    private void initComponents() {
        this.customizerPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.customizerPanel.setLayout(new BorderLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(11, 11, 0, 11);
        this.add((Component)this.customizerPanel, gridBagConstraints);
        this.applyCheckBox.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(17, 11, 0, 11);
        this.add((Component)this.applyCheckBox, gridBagConstraints);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.applyCheckBox) {
            boolean selected = this.applyCheckBox.isSelected();
            this.setCustomized(selected);
            this.searchType.setValid(selected);
        } else assert (false);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == this.searchType && "valid".equals(evt.getPropertyName())) {
            if (evt.getNewValue().equals(Boolean.FALSE)) {
                this.setCustomized(false);
                return;
            }
            this.setCustomized(true);
        }
    }

    @Override
    public void onOk() {
        if (this.customizer instanceof DialogLifetime) {
            ((DialogLifetime)((Object)this.customizer)).onOk();
        }
    }

    @Override
    public void onCancel() {
        if (this.customizer instanceof DialogLifetime) {
            ((DialogLifetime)((Object)this.customizer)).onCancel();
        }
    }

    private String createName() {
        String name = this.searchType.getName();
        if (this.customized) {
            return name + MODIFICATOR_SUFFIX;
        }
        return name;
    }

    private static Customizer createCustomizer(SearchType searchType) {
        Object o;
        Class<?> searchTypeClass = searchType.getClass();
        Class<?> clazz = null;
        if (SearchTypePanel.isDefaultSearchType(searchTypeClass)) {
            String typeClassName = searchType.getClass().getName();
            assert (typeClassName.endsWith("Type"));
            int typeNameLen = typeClassName.length();
            String customizerClassName = new StringBuffer(typeNameLen + 6).append(typeClassName.substring(0, typeNameLen - 4)).append("Customizer").toString();
            try {
                clazz = Class.forName(customizerClassName);
            }
            catch (Exception ex) {
                assert (false);
                ErrorManager.getDefault().notify(65536, (Throwable)ex);
            }
        }
        if (clazz == null) {
            BeanInfo beanInfo;
            try {
                beanInfo = Utilities.getBeanInfo(searchTypeClass);
            }
            catch (IntrospectionException ie) {
                ErrorManager.getDefault().notify(1, (Throwable)ie);
                return null;
            }
            clazz = beanInfo.getBeanDescriptor().getCustomizerClass();
        }
        if (clazz == null) {
            return null;
        }
        try {
            o = clazz.newInstance();
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        if (!(o instanceof Component) || !(o instanceof Customizer)) {
            return null;
        }
        return (Customizer)o;
    }

    private static boolean isDefaultSearchType(Class searchTypeClass) {
        assert (SearchType.class.isAssignableFrom(searchTypeClass));
        String mandatoryPackage = "org.netbeans.modules.search.types";
        String className = searchTypeClass.getName();
        return className.startsWith(mandatoryPackage) && className.lastIndexOf(46) == mandatoryPackage.length();
    }

    private void setCustomized(boolean cust) {
        this.customized = cust;
        this.applyCheckBox.setSelected(this.customized);
        this.setName(this.createName());
        this.firePropertyChange(PROP_CUSTOMIZED, !cust, cust);
    }

    public boolean isCustomized() {
        return this.customized;
    }

    private void restoreSearchType(SearchType searchType) {
        this.searchType.removePropertyChangeListener((PropertyChangeListener)this);
        this.searchType = (SearchType)searchType.clone();
        this.initialized = false;
        this.initializeWithObject();
        this.searchType.addPropertyChangeListener((PropertyChangeListener)this);
        this.setCustomized(true);
    }

    final void initializeWithObject() {
        if (!this.initialized) {
            this.customizer.setObject(this.searchType);
            this.initialized = true;
        }
    }

    public SearchType getSearchType() {
        return this.searchType;
    }

    public boolean equals(Object obj) {
        try {
            return this.searchType.getClass().equals(((SearchTypePanel)obj).getSearchType().getClass());
        }
        catch (ClassCastException ex) {
            return false;
        }
    }

    public HelpCtx getHelpCtx() {
        return this.searchType.getHelpCtx();
    }
}

