/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.ui.dashboard;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.modules.kenai.ui.dashboard.ColorManager;
import org.netbeans.modules.kenai.ui.dashboard.LinkButton;
import org.netbeans.modules.kenai.ui.spi.SourceAccessor;
import org.netbeans.modules.kenai.ui.spi.SourceHandle;
import org.netbeans.modules.kenai.ui.treelist.LeafNode;
import org.netbeans.modules.kenai.ui.treelist.TreeLabel;
import org.netbeans.modules.kenai.ui.treelist.TreeListNode;
import org.openide.util.NbBundle;

public class SourceNode
extends LeafNode {
    private final SourceHandle source;
    private JPanel panel;
    private JLabel lbl;
    private JLabel lbl1;
    private JLabel lbl2;
    private LinkButton btn;

    public SourceNode(SourceHandle source, TreeListNode parent) {
        super(parent);
        this.source = source;
    }

    @Override
    protected JComponent getComponent(Color foreground, Color background, boolean isSelected, boolean hasFocus) {
        if (null == this.panel) {
            this.panel = new JPanel(new GridBagLayout());
            this.panel.setOpaque(false);
            this.lbl = new TreeLabel(this.source.getDisplayName());
            this.panel.add((Component)this.lbl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            if (this.source.isSupported()) {
                this.btn = new LinkButton(NbBundle.getMessage(SourceNode.class, (String)"LBL_GetSources"), SourceAccessor.getDefault().getOpenSourcesAction(this.source));
                String featureName = this.source.getScmFeatureName();
                String repotype = "MSG_UNKNOWN_SCM";
                if (featureName.equals("subversion")) {
                    repotype = "MSG_SUBVERSION";
                } else if (featureName.equals("git")) {
                    repotype = "MSG_GIT";
                } else if (featureName.equals("mercurial")) {
                    repotype = "MSG_MERCURIAL";
                }
                this.btn.setToolTipText(NbBundle.getMessage(SourceNode.class, (String)repotype));
                this.lbl1 = new TreeLabel("(");
                this.lbl2 = new TreeLabel(")");
                this.panel.add((Component)this.lbl1, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 4, 0, 0), 0, 0));
                this.panel.add((Component)this.btn, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.panel.add((Component)this.lbl2, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            }
            this.panel.add((Component)new JLabel(), new GridBagConstraints(5, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
        if (!isSelected && !this.source.isSupported()) {
            this.lbl.setForeground(ColorManager.getDefault().getDisabledColor());
        } else {
            this.lbl.setForeground(foreground);
        }
        if (null != this.btn) {
            this.lbl1.setForeground(foreground);
            this.lbl2.setForeground(foreground);
            this.btn.setForeground(foreground, isSelected);
        }
        return this.panel;
    }

    @Override
    public Action getDefaultAction() {
        return SourceAccessor.getDefault().getDefaultAction(this.source);
    }
}

