/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.api.completion;

import groovy.lang.MetaMethod;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;
import javax.swing.ImageIcon;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.Variable;
import org.netbeans.api.java.source.ui.ElementIcons;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.HtmlFormatter;
import org.netbeans.modules.csl.spi.DefaultCompletionProposal;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.groovy.editor.api.NbUtilities;
import org.netbeans.modules.groovy.editor.api.completion.CompletionHandler;
import org.netbeans.modules.groovy.editor.api.elements.AstMethodElement;
import org.netbeans.modules.groovy.editor.api.elements.ElementHandleSupport;
import org.netbeans.modules.groovy.editor.api.elements.GroovyElement;
import org.netbeans.modules.groovy.editor.api.elements.KeywordElement;
import org.netbeans.modules.groovy.editor.java.Utilities;
import org.openide.util.ImageUtilities;

public abstract class CompletionItem
extends DefaultCompletionProposal {
    private static final Logger LOG = Logger.getLogger(CompletionItem.class.getName());
    protected final GroovyElement element;
    private static volatile ImageIcon groovyIcon;
    private static volatile ImageIcon javaIcon;
    private static volatile ImageIcon newConstructorIcon;

    private CompletionItem(GroovyElement groovyElement, int n) {
        this.element = groovyElement;
        this.anchorOffset = n;
        LOG.setLevel(Level.OFF);
    }

    public String getName() {
        return this.element.getName();
    }

    public ElementHandle getElement() {
        LOG.log(Level.FINEST, "getElement() element : {0}", this.element);
        return null;
    }

    public org.netbeans.modules.csl.api.ElementKind getKind() {
        return this.element.getKind();
    }

    public Set<org.netbeans.modules.csl.api.Modifier> getModifiers() {
        return this.element.getModifiers();
    }

    public String toString() {
        String string = ((Object)((Object)this)).getClass().getName();
        string = string.substring(string.lastIndexOf(46) + 1);
        return string + "(" + this.getKind() + "): " + this.getName();
    }

    public static CompletionItem forJavaMethod(String string, String string2, String string3, TypeMirror typeMirror, Set<Modifier> set, int n, boolean bl, boolean bl2) {
        return new JavaMethodItem(string, string2, string3, typeMirror, set, n, bl, bl2);
    }

    public static CompletionItem forJavaMethod(String string, String string2, String string3, String string4, Set<Modifier> set, int n, boolean bl, boolean bl2) {
        return new JavaMethodItem(string, string2, string3, string4, set, n, bl, bl2);
    }

    public static CompletionItem forDynamicMethod(int n, String string, String[] stringArray, String string2, boolean bl, boolean bl2) {
        return new DynamicMethodItem(n, string, stringArray, string2, bl, bl2);
    }

    public static CompletionItem forDynamicField(int n, String string, String string2) {
        return new DynamicFieldItem(n, string, string2);
    }

    public static class ParameterDescriptor {
        private final String fullTypeName;
        private final String typeName;
        private final String name;

        public ParameterDescriptor(String string, String string2, String string3) {
            this.fullTypeName = string;
            this.typeName = string2;
            this.name = string3;
        }

        public String getName() {
            return this.name;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public String getFullTypeName() {
            return this.fullTypeName;
        }
    }

    public static class NewVarItem
    extends CompletionItem {
        private final String var;

        public NewVarItem(String string, int n) {
            super(null, n);
            this.var = string;
        }

        @Override
        public String getName() {
            return this.var;
        }

        @Override
        public org.netbeans.modules.csl.api.ElementKind getKind() {
            return org.netbeans.modules.csl.api.ElementKind.VARIABLE;
        }

        public String getRhsHtml(HtmlFormatter htmlFormatter) {
            return null;
        }

        public ImageIcon getIcon() {
            return (ImageIcon)ElementIcons.getElementIcon((ElementKind)ElementKind.LOCAL_VARIABLE, null);
        }

        @Override
        public Set<org.netbeans.modules.csl.api.Modifier> getModifiers() {
            return Collections.emptySet();
        }

        @Override
        public ElementHandle getElement() {
            return null;
        }
    }

    public static class LocalVarItem
    extends CompletionItem {
        private final Variable var;

        public LocalVarItem(Variable variable, int n) {
            super(null, n);
            this.var = variable;
        }

        @Override
        public String getName() {
            return this.var.getName();
        }

        @Override
        public org.netbeans.modules.csl.api.ElementKind getKind() {
            return org.netbeans.modules.csl.api.ElementKind.VARIABLE;
        }

        public String getRhsHtml(HtmlFormatter htmlFormatter) {
            return NbUtilities.stripPackage(Utilities.translateClassLoaderTypeName(this.var.getType().getName()));
        }

        public ImageIcon getIcon() {
            return (ImageIcon)ElementIcons.getElementIcon((ElementKind)ElementKind.LOCAL_VARIABLE, null);
        }

        @Override
        public Set<org.netbeans.modules.csl.api.Modifier> getModifiers() {
            return Collections.emptySet();
        }

        @Override
        public ElementHandle getElement() {
            return null;
        }
    }

    public static class FieldItem
    extends CompletionItem {
        private final String name;
        private final ParserResult info;
        private final String typeName;
        private final int modifiers;

        public FieldItem(String string, int n, int n2, ParserResult parserResult, String string2) {
            super(null, n2);
            this.name = string;
            this.info = parserResult;
            this.typeName = string2;
            this.modifiers = n;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public org.netbeans.modules.csl.api.ElementKind getKind() {
            return org.netbeans.modules.csl.api.ElementKind.FIELD;
        }

        public String getRhsHtml(HtmlFormatter htmlFormatter) {
            return this.typeName;
        }

        public ImageIcon getIcon() {
            return (ImageIcon)ElementIcons.getElementIcon((ElementKind)ElementKind.FIELD, Utilities.reflectionModifiersToModel(this.modifiers));
        }

        @Override
        public Set<org.netbeans.modules.csl.api.Modifier> getModifiers() {
            return Collections.emptySet();
        }

        @Override
        public ElementHandle getElement() {
            return ElementHandleSupport.createHandle(this.info, new KeywordElement(this.name));
        }
    }

    public static class JavaFieldItem
    extends CompletionItem {
        private final String className;
        private final String name;
        private final TypeMirror type;
        private final Set<Modifier> modifiers;
        private final boolean emphasise;

        public JavaFieldItem(String string, String string2, TypeMirror typeMirror, Set<Modifier> set, int n, boolean bl) {
            super(null, n);
            this.className = string;
            this.name = string2;
            this.type = typeMirror;
            this.modifiers = set;
            this.emphasise = bl;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public org.netbeans.modules.csl.api.ElementKind getKind() {
            return org.netbeans.modules.csl.api.ElementKind.FIELD;
        }

        public String getRhsHtml(HtmlFormatter htmlFormatter) {
            String string = "";
            if (this.type != null) {
                string = ((Object)Utilities.getTypeName(this.type, false)).toString();
            }
            htmlFormatter.appendText(string);
            return htmlFormatter.getText();
        }

        public ImageIcon getIcon() {
            return (ImageIcon)ElementIcons.getElementIcon((ElementKind)ElementKind.FIELD, this.modifiers);
        }

        @Override
        public Set<org.netbeans.modules.csl.api.Modifier> getModifiers() {
            return Utilities.modelModifiersToGsf(this.modifiers);
        }

        @Override
        public ElementHandle getElement() {
            return ElementHandleSupport.createHandle(this.className, this.name, org.netbeans.modules.csl.api.ElementKind.FIELD, Utilities.modelModifiersToGsf(this.modifiers));
        }
    }

    public static class ConstructorItem
    extends CompletionItem {
        private final String name;
        private static final String NEW_CSTR = "org/netbeans/modules/groovy/editor/resources/new_constructor_16.png";
        private boolean expand;
        private final String paramListString;
        private final List<ParameterDescriptor> paramList;

        public ConstructorItem(String string, String string2, List<ParameterDescriptor> list, int n, boolean bl) {
            super(null, n);
            this.name = string;
            this.expand = bl;
            this.paramListString = string2;
            this.paramList = list;
        }

        public String getLhsHtml(HtmlFormatter htmlFormatter) {
            if (this.expand) {
                return this.name + " - generate";
            }
            return this.name + "(" + this.paramListString + ")";
        }

        @Override
        public String getName() {
            if (this.expand) {
                return this.name + "()\n{\n}";
            }
            return this.name;
        }

        @Override
        public org.netbeans.modules.csl.api.ElementKind getKind() {
            return org.netbeans.modules.csl.api.ElementKind.CONSTRUCTOR;
        }

        public String getRhsHtml(HtmlFormatter htmlFormatter) {
            return null;
        }

        public ImageIcon getIcon() {
            if (newConstructorIcon == null) {
                newConstructorIcon = ImageUtilities.loadImageIcon((String)NEW_CSTR, (boolean)false);
            }
            return newConstructorIcon;
        }

        @Override
        public Set<org.netbeans.modules.csl.api.Modifier> getModifiers() {
            return Collections.emptySet();
        }

        @Override
        public ElementHandle getElement() {
            return null;
        }

        public boolean isSmart() {
            return true;
        }

        public String getCustomInsertTemplate() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.getInsertPrefix());
            stringBuilder.append("(");
            int n = 1;
            for (ParameterDescriptor parameterDescriptor : this.paramList) {
                LOG.log(Level.FINEST, "-------------------------------------------------------------------");
                LOG.log(Level.FINEST, "paramDesc.fullTypeName : {0}", parameterDescriptor.getFullTypeName());
                LOG.log(Level.FINEST, "paramDesc.typeName     : {0}", parameterDescriptor.getTypeName());
                LOG.log(Level.FINEST, "paramDesc.name         : {0}", parameterDescriptor.getName());
                stringBuilder.append("${");
                stringBuilder.append("groovy-cc-");
                stringBuilder.append(Integer.toString(n));
                stringBuilder.append(" default=\"");
                stringBuilder.append(parameterDescriptor.getName());
                stringBuilder.append("\"");
                stringBuilder.append("}");
                if (n < this.paramList.size()) {
                    stringBuilder.append(", ");
                }
                ++n;
            }
            stringBuilder.append(")");
            LOG.log(Level.FINEST, "Template returned : {0}", stringBuilder.toString());
            return stringBuilder.toString();
        }
    }

    public static class TypeItem
    extends CompletionItem {
        private final String name;
        private final ElementKind ek;

        public TypeItem(String string, int n, ElementKind elementKind) {
            super(null, n);
            this.name = string;
            this.ek = elementKind;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public org.netbeans.modules.csl.api.ElementKind getKind() {
            return org.netbeans.modules.csl.api.ElementKind.CLASS;
        }

        public String getRhsHtml(HtmlFormatter htmlFormatter) {
            return null;
        }

        public ImageIcon getIcon() {
            return (ImageIcon)ElementIcons.getElementIcon((ElementKind)this.ek, null);
        }

        @Override
        public Set<org.netbeans.modules.csl.api.Modifier> getModifiers() {
            return Collections.emptySet();
        }

        @Override
        public ElementHandle getElement() {
            return null;
        }
    }

    public static class PackageItem
    extends CompletionItem {
        private final String keyword;
        private final ParserResult info;

        public PackageItem(String string, int n, ParserResult parserResult) {
            super(null, n);
            this.keyword = string;
            this.info = parserResult;
        }

        @Override
        public String getName() {
            return this.keyword;
        }

        @Override
        public org.netbeans.modules.csl.api.ElementKind getKind() {
            return org.netbeans.modules.csl.api.ElementKind.PACKAGE;
        }

        public String getRhsHtml(HtmlFormatter htmlFormatter) {
            return null;
        }

        public ImageIcon getIcon() {
            return (ImageIcon)ElementIcons.getElementIcon((ElementKind)ElementKind.PACKAGE, null);
        }

        @Override
        public Set<org.netbeans.modules.csl.api.Modifier> getModifiers() {
            return Collections.emptySet();
        }

        @Override
        public ElementHandle getElement() {
            return ElementHandleSupport.createHandle(this.info, new KeywordElement(this.keyword));
        }
    }

    public static class KeywordItem
    extends CompletionItem {
        private static final String JAVA_KEYWORD = "org/netbeans/modules/groovy/editor/resources/duke.png";
        private final String keyword;
        private final String description;
        private final boolean isGroovy;
        private final ParserResult info;

        public KeywordItem(String string, String string2, int n, ParserResult parserResult, boolean bl) {
            super(null, n);
            this.keyword = string;
            this.description = string2;
            this.info = parserResult;
            this.isGroovy = bl;
        }

        @Override
        public String getName() {
            return this.keyword;
        }

        @Override
        public org.netbeans.modules.csl.api.ElementKind getKind() {
            return org.netbeans.modules.csl.api.ElementKind.KEYWORD;
        }

        public String getRhsHtml(HtmlFormatter htmlFormatter) {
            if (this.description != null) {
                htmlFormatter.appendHtml(this.description);
                return htmlFormatter.getText();
            }
            return null;
        }

        public ImageIcon getIcon() {
            if (this.isGroovy) {
                if (groovyIcon == null) {
                    groovyIcon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/groovy/support/resources/GroovyFile16x16.png", (boolean)false);
                }
                return groovyIcon;
            }
            if (javaIcon == null) {
                javaIcon = ImageUtilities.loadImageIcon((String)JAVA_KEYWORD, (boolean)false);
            }
            return javaIcon;
        }

        @Override
        public Set<org.netbeans.modules.csl.api.Modifier> getModifiers() {
            return Collections.emptySet();
        }

        @Override
        public ElementHandle getElement() {
            return ElementHandleSupport.createHandle(this.info, new KeywordElement(this.keyword));
        }
    }

    public static class MetaMethodItem
    extends CompletionItem {
        private final MetaMethod method;
        private final boolean isGDK;
        private final AstMethodElement methodElement;
        private final boolean nameOnly;

        public MetaMethodItem(Class clazz, MetaMethod metaMethod, int n, boolean bl, boolean bl2) {
            super(null, n);
            this.method = metaMethod;
            this.isGDK = bl;
            this.nameOnly = bl2;
            this.methodElement = new AstMethodElement(null, new ASTNode(), clazz, metaMethod, bl);
        }

        public MetaMethod getMethod() {
            return this.method;
        }

        @Override
        public String getName() {
            return this.method.getName() + "()";
        }

        @Override
        public org.netbeans.modules.csl.api.ElementKind getKind() {
            return org.netbeans.modules.csl.api.ElementKind.METHOD;
        }

        public String getLhsHtml(HtmlFormatter htmlFormatter) {
            org.netbeans.modules.csl.api.ElementKind elementKind = this.getKind();
            htmlFormatter.name(elementKind, true);
            if (this.isGDK) {
                htmlFormatter.appendText(this.method.getName());
                String string = this.method.getSignature();
                int n = string.indexOf("(");
                int n2 = string.indexOf(")");
                String string2 = string.substring(n + 1, n2);
                StringBuffer stringBuffer = new StringBuffer();
                for (String string3 : string2.split(",")) {
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(NbUtilities.stripPackage(Utilities.translateClassLoaderTypeName(string3)));
                }
                String string4 = stringBuffer.toString();
                htmlFormatter.appendText("(" + string4 + ")");
            } else {
                htmlFormatter.appendText(CompletionHandler.getMethodSignature(this.method, false, this.isGDK));
            }
            htmlFormatter.name(elementKind, false);
            return htmlFormatter.getText();
        }

        public String getRhsHtml(HtmlFormatter htmlFormatter) {
            String string = this.method.getReturnType().getSimpleName();
            string = NbUtilities.stripPackage(string);
            htmlFormatter.appendText(string);
            return htmlFormatter.getText();
        }

        public ImageIcon getIcon() {
            if (!this.isGDK) {
                return (ImageIcon)ElementIcons.getElementIcon((ElementKind)ElementKind.METHOD, Utilities.reflectionModifiersToModel(this.method.getModifiers()));
            }
            if (groovyIcon == null) {
                groovyIcon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/groovy/support/resources/GroovyFile16x16.png", (boolean)false);
            }
            return groovyIcon;
        }

        @Override
        public Set<org.netbeans.modules.csl.api.Modifier> getModifiers() {
            return Collections.emptySet();
        }

        @Override
        public ElementHandle getElement() {
            return this.methodElement;
        }

        public String getCustomInsertTemplate() {
            if (this.nameOnly) {
                return this.method.getName();
            }
            return super.getCustomInsertTemplate();
        }
    }

    private static class DynamicMethodItem
    extends CompletionItem {
        private final String name;
        private final String[] parameters;
        private final String returnType;
        private final boolean nameOnly;
        private final boolean prefix;

        public DynamicMethodItem(int n, String string, String[] stringArray, String string2, boolean bl, boolean bl2) {
            super(null, n);
            this.name = string;
            this.parameters = stringArray;
            this.returnType = string2;
            this.nameOnly = bl;
            this.prefix = bl2;
        }

        @Override
        public String getName() {
            return this.name + "()";
        }

        public String getSortText() {
            return this.name + (this.prefix ? 1 : 0) + this.parameters.length;
        }

        @Override
        public org.netbeans.modules.csl.api.ElementKind getKind() {
            return org.netbeans.modules.csl.api.ElementKind.METHOD;
        }

        public String getLhsHtml(HtmlFormatter htmlFormatter) {
            org.netbeans.modules.csl.api.ElementKind elementKind = this.getKind();
            htmlFormatter.name(elementKind, true);
            htmlFormatter.appendText(this.name);
            if (!this.prefix) {
                StringBuilder stringBuilder = new StringBuilder();
                for (String string : this.parameters) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(NbUtilities.stripPackage(Utilities.translateClassLoaderTypeName(string)));
                }
                String string = stringBuilder.toString();
                htmlFormatter.appendText("(" + string + ")");
            } else {
                htmlFormatter.appendText("...");
            }
            htmlFormatter.name(elementKind, false);
            return htmlFormatter.getText();
        }

        public String getRhsHtml(HtmlFormatter htmlFormatter) {
            String string = this.returnType;
            string = NbUtilities.stripPackage(string);
            htmlFormatter.appendText(string);
            return htmlFormatter.getText();
        }

        public ImageIcon getIcon() {
            if (groovyIcon == null) {
                groovyIcon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/groovy/support/resources/GroovyFile16x16.png", (boolean)false);
            }
            return groovyIcon;
        }

        @Override
        public Set<org.netbeans.modules.csl.api.Modifier> getModifiers() {
            return Collections.singleton(org.netbeans.modules.csl.api.Modifier.PROTECTED);
        }

        @Override
        public ElementHandle getElement() {
            return ElementHandleSupport.createHandle(null, this.name, org.netbeans.modules.csl.api.ElementKind.METHOD, Collections.singleton(org.netbeans.modules.csl.api.Modifier.PROTECTED));
        }

        public String getCustomInsertTemplate() {
            if (this.nameOnly) {
                return this.name;
            }
            return super.getCustomInsertTemplate();
        }
    }

    public static class DynamicFieldItem
    extends CompletionItem {
        private final String name;
        private final String type;

        public DynamicFieldItem(int n, String string, String string2) {
            super(null, n);
            this.name = string;
            this.type = string2;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public org.netbeans.modules.csl.api.ElementKind getKind() {
            return org.netbeans.modules.csl.api.ElementKind.FIELD;
        }

        public String getRhsHtml(HtmlFormatter htmlFormatter) {
            String string = this.type;
            string = NbUtilities.stripPackage(string);
            htmlFormatter.appendText(string);
            return htmlFormatter.getText();
        }

        public ImageIcon getIcon() {
            if (groovyIcon == null) {
                groovyIcon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/groovy/support/resources/GroovyFile16x16.png", (boolean)false);
            }
            return groovyIcon;
        }

        @Override
        public Set<org.netbeans.modules.csl.api.Modifier> getModifiers() {
            return Collections.singleton(org.netbeans.modules.csl.api.Modifier.PROTECTED);
        }

        @Override
        public ElementHandle getElement() {
            return ElementHandleSupport.createHandle(null, this.name, org.netbeans.modules.csl.api.ElementKind.FIELD, Collections.singleton(org.netbeans.modules.csl.api.Modifier.PROTECTED));
        }
    }

    private static class JavaMethodItem
    extends CompletionItem {
        private final String className;
        private final String simpleName;
        private final String parameterString;
        private final String returnType;
        private final Set<Modifier> modifiers;
        private final boolean emphasise;
        private final boolean nameOnly;

        public JavaMethodItem(String string, String string2, String string3, TypeMirror typeMirror, Set<Modifier> set, int n, boolean bl, boolean bl2) {
            this(string, string2, string3, ((Object)Utilities.getTypeName(typeMirror, false)).toString(), set, n, bl, bl2);
        }

        public JavaMethodItem(String string, String string2, String string3, String string4, Set<Modifier> set, int n, boolean bl, boolean bl2) {
            super(null, n);
            this.className = string;
            this.simpleName = string2;
            this.parameterString = string3;
            this.returnType = NbUtilities.stripPackage(string4);
            this.modifiers = set;
            this.emphasise = bl;
            this.nameOnly = bl2;
        }

        @Override
        public String getName() {
            return this.simpleName + "()";
        }

        @Override
        public org.netbeans.modules.csl.api.ElementKind getKind() {
            return org.netbeans.modules.csl.api.ElementKind.METHOD;
        }

        public String getLhsHtml(HtmlFormatter htmlFormatter) {
            if (this.emphasise) {
                htmlFormatter.emphasis(true);
            }
            htmlFormatter.appendText(this.simpleName + "(" + this.parameterString + ")");
            if (this.emphasise) {
                htmlFormatter.emphasis(false);
            }
            return htmlFormatter.getText();
        }

        public String getRhsHtml(HtmlFormatter htmlFormatter) {
            String string = "";
            if (this.returnType != null) {
                string = this.returnType;
            }
            htmlFormatter.appendText(string);
            return htmlFormatter.getText();
        }

        public ImageIcon getIcon() {
            return (ImageIcon)ElementIcons.getElementIcon((ElementKind)ElementKind.METHOD, this.modifiers);
        }

        @Override
        public Set<org.netbeans.modules.csl.api.Modifier> getModifiers() {
            return Utilities.modelModifiersToGsf(this.modifiers);
        }

        @Override
        public ElementHandle getElement() {
            return ElementHandleSupport.createHandle(this.className, this.simpleName, org.netbeans.modules.csl.api.ElementKind.METHOD, Utilities.modelModifiersToGsf(this.modifiers));
        }

        public String getCustomInsertTemplate() {
            if (this.nameOnly) {
                return this.simpleName;
            }
            return super.getCustomInsertTemplate();
        }
    }
}

