/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.cnd.actions.ShellRunAction;
import org.netbeans.modules.cnd.api.remote.HostInfoProvider;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.remote.ServerRecord;
import org.netbeans.modules.cnd.api.toolchain.CompilerFlavor;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.CompilerSetManager;
import org.netbeans.modules.cnd.api.toolchain.PredefinedToolKind;
import org.netbeans.modules.cnd.api.toolchain.Tool;
import org.netbeans.modules.cnd.api.toolchain.ToolKind;
import org.netbeans.modules.cnd.api.toolchain.ui.BuildToolsAction;
import org.netbeans.modules.cnd.api.toolchain.ui.LocalToolsPanelModel;
import org.netbeans.modules.cnd.api.toolchain.ui.ToolsPanelModel;
import org.netbeans.modules.cnd.api.toolchain.ui.ToolsPanelSupport;
import org.netbeans.modules.cnd.api.utils.PlatformInfo;
import org.netbeans.modules.cnd.execution.ShellExecSupport;
import org.netbeans.modules.cnd.makeproject.MakeOptions;
import org.netbeans.modules.cnd.makeproject.MakeProject;
import org.netbeans.modules.cnd.makeproject.api.MakeArtifact;
import org.netbeans.modules.cnd.makeproject.api.MakeCustomizerProvider;
import org.netbeans.modules.cnd.makeproject.api.PackagerManager;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionEvent;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionHandler;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionSupport;
import org.netbeans.modules.cnd.makeproject.api.ProjectSupport;
import org.netbeans.modules.cnd.makeproject.api.RunDialogPanel;
import org.netbeans.modules.cnd.makeproject.api.StepControllerProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.AssemblerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.CCCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.CCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.CompilerSet2Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.CustomToolConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.FortranCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.ItemConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.runprofiles.RunProfile;
import org.netbeans.modules.cnd.makeproject.platform.Platform;
import org.netbeans.modules.cnd.makeproject.platform.Platforms;
import org.netbeans.modules.cnd.makeproject.ui.utils.ConfSelectorPanel;
import org.netbeans.modules.cnd.spi.remote.RemoteSyncFactory;
import org.netbeans.modules.cnd.spi.toolchain.CompilerSetFactory;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.NamedRunnable;
import org.netbeans.modules.cnd.utils.ui.ModalMessageDlg;
import org.netbeans.modules.dlight.util.usagetracking.SunStudioUserCounter;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.Path;
import org.netbeans.modules.nativeexecution.api.util.Shell;
import org.netbeans.modules.nativeexecution.api.util.ShellValidationSupport;
import org.netbeans.modules.nativeexecution.api.util.WindowsSupport;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.ui.support.DefaultProjectOperations;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.LifecycleManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.SystemAction;
import org.openide.windows.WindowManager;

public final class MakeActionProvider
implements ActionProvider {
    public static final String COMMAND_BATCH_BUILD = "batch_build";
    public static final String COMMAND_BUILD_PACKAGE = "build_packages";
    public static final String COMMAND_DEBUG_LOAD_ONLY = "debug.load.only";
    public static final String COMMAND_CUSTOM_ACTION = "custom.action";
    private static final String[] supportedActions = new String[]{"build", "clean", "rebuild", "compile.single", "run", "run.single", "debug", "debug.stepinto", "debug.load.only", "debug.single", "batch_build", "build_packages", "delete", "copy", "move", "rename", "custom.action", "test", "test.single"};
    private MakeProject project;
    private MakeConfigurationDescriptor projectDescriptor = null;
    private Map<String, String[]> commands;
    private Map<String, String[]> commandsNoBuild;
    private boolean lastValidation = false;
    private static final String SAVE_STEP = "save";
    private static final String BUILD_STEP = "build";
    private static final String BUILD_PACKAGE_STEP = "build-package";
    private static final String CLEAN_STEP = "clean";
    private static final String RUN_STEP = "run";
    private static final String DEBUG_STEP = "debug";
    private static final String DEBUG_STEPINTO_STEP = "debug-stepinto";
    private static final String DEBUG_LOAD_ONLY_STEP = "debug-load-only";
    private static final String RUN_SINGLE_STEP = "run-single";
    private static final String DEBUG_SINGLE_STEP = "debug-single";
    private static final String COMPILE_SINGLE_STEP = "compile-single";
    private static final String CUSTOM_ACTION_STEP = "custom-action";
    private static final String VALIDATE_TOOLCHAIN = "validate-toolchain";
    private static final String BUILD_TESTS_STEP = "build-tests";
    private static final String TEST_STEP = "test";
    private static final String TEST_SINGLE_STEP = "test-single";
    private static final RequestProcessor RP = new RequestProcessor("Make Action RP", 1);
    private static Map<String, Boolean> fileExistenceCache = new HashMap<String, Boolean>();
    private static Map<String, Boolean> validExecutablesCache = new HashMap<String, Boolean>();

    public MakeActionProvider(MakeProject project) {
        this.project = project;
        this.commands = this.loadAcrionSteps("CND/BuildAction");
        this.commandsNoBuild = this.loadAcrionSteps("CND/NoBuildAction");
    }

    private Map<String, String[]> loadAcrionSteps(String root) {
        HashMap<String, String[]> res = new HashMap<String, String[]>();
        FileObject folder = FileUtil.getConfigFile((String)root);
        if (folder != null && folder.isFolder()) {
            for (FileObject subFolder : folder.getChildren()) {
                if (!subFolder.isFolder()) continue;
                TreeMap<Integer, String> map = new TreeMap<Integer, String>();
                for (FileObject file : subFolder.getChildren()) {
                    Integer position = (Integer)file.getAttribute("position");
                    map.put(position, file.getNameExt());
                }
                res.put(subFolder.getNameExt(), map.values().toArray(new String[map.size()]));
            }
        }
        return res;
    }

    private boolean isProjectDescriptorLoaded() {
        if (this.projectDescriptor == null) {
            ConfigurationDescriptorProvider pdp = (ConfigurationDescriptorProvider)this.project.getLookup().lookup(ConfigurationDescriptorProvider.class);
            return pdp.gotDescriptor();
        }
        return true;
    }

    private MakeConfigurationDescriptor getProjectDescriptor() {
        if (this.projectDescriptor == null) {
            ConfigurationDescriptorProvider pdp = (ConfigurationDescriptorProvider)this.project.getLookup().lookup(ConfigurationDescriptorProvider.class);
            this.projectDescriptor = pdp.getConfigurationDescriptor();
        }
        return this.projectDescriptor;
    }

    public String[] getSupportedActions() {
        return supportedActions;
    }

    public void invokeAction(String command, final Lookup context) throws IllegalArgumentException {
        if ("delete".equals(command)) {
            DefaultProjectOperations.performDefaultDeleteOperation((Project)this.project);
            return;
        }
        if ("copy".equals(command)) {
            DefaultProjectOperations.performDefaultCopyOperation((Project)this.project);
            return;
        }
        if ("move".equals(command)) {
            DefaultProjectOperations.performDefaultMoveOperation((Project)this.project);
            return;
        }
        if ("rename".equals(command)) {
            DefaultProjectOperations.performDefaultRenameOperation((Project)this.project, null);
            return;
        }
        if ("run.single".equals(command)) {
            Node node = (Node)context.lookup(Node.class);
            if (node != null) {
                ShellRunAction.performAction((Node)node);
            }
            return;
        }
        final MakeConfigurationDescriptor pd = this.getProjectDescriptor();
        MakeConfiguration activeConf = pd.getActiveConfiguration();
        if (activeConf == null) {
            return;
        }
        final ArrayList<MakeConfiguration> confs = new ArrayList<MakeConfiguration>();
        if (command.equals(COMMAND_BATCH_BUILD)) {
            BatchConfigurationSelector batchConfigurationSelector = new BatchConfigurationSelector(this.project, pd.getConfs().toArray());
            String batchCommand = batchConfigurationSelector.getCommand();
            Configuration[] confsArray = batchConfigurationSelector.getSelectedConfs();
            if (batchCommand == null || confsArray == null || confsArray.length == 0) {
                return;
            }
            command = batchCommand;
            for (Configuration conf : confsArray) {
                confs.add((MakeConfiguration)conf);
            }
        } else {
            confs.add(activeConf);
        }
        final String finalCommand = command;
        CancellableTask actionWorker = new CancellableTask(){

            @Override
            protected void runImpl() {
                final ArrayList actionEvents = new ArrayList();
                for (MakeConfiguration conf : confs) {
                    MakeActionProvider.this.addAction(actionEvents, pd, conf, finalCommand, context, this.cancelled);
                }
                if (actionEvents.size() > 0 && !this.cancelled.get()) {
                    RP.post((Runnable)new NamedRunnable("Make Project Action Worker"){

                        protected void runImpl() {
                            ProjectActionSupport.getInstance().fireActionPerformed(actionEvents.toArray(new ProjectActionEvent[actionEvents.size()]));
                        }
                    });
                }
            }
        };
        ConfigurationDescriptorProvider.recordActionMetrics(command, pd);
        MakeActionProvider.runActionWorker(activeConf.getDevelopmentHost().getExecutionEnvironment(), actionWorker);
    }

    private static void runActionWorker(ExecutionEnvironment exeEnv, CancellableTask actionWorker) {
        ServerRecord record = ServerList.get((ExecutionEnvironment)exeEnv);
        assert (record != null);
        MakeActionProvider.invokeLongAction(record, actionWorker);
    }

    public void invokeCustomAction(final MakeConfigurationDescriptor pd, final MakeConfiguration conf, final ProjectActionHandler customProjectActionHandler) {
        CancellableTask actionWorker = new CancellableTask(){

            @Override
            protected void runImpl() {
                ArrayList actionEvents = new ArrayList();
                MakeActionProvider.this.addAction(actionEvents, pd, conf, MakeActionProvider.COMMAND_CUSTOM_ACTION, null, this.cancelled);
                ProjectActionSupport.getInstance().fireActionPerformed(actionEvents.toArray(new ProjectActionEvent[actionEvents.size()]), customProjectActionHandler);
            }
        };
        MakeActionProvider.runActionWorker(conf.getDevelopmentHost().getExecutionEnvironment(), actionWorker);
    }

    private static void invokeLongAction(final ServerRecord record, final CancellableTask actionWorker) {
        CancellableTask wrapper;
        if (!record.isDeleted() && record.isOnline()) {
            wrapper = actionWorker;
        } else {
            if (record.isDeleted()) {
                String message = MessageFormat.format(MakeActionProvider.getString("ERR_RequestingDeletedConnection"), record.getDisplayName());
                int res = JOptionPane.showConfirmDialog(WindowManager.getDefault().getMainWindow(), message, MakeActionProvider.getString("DLG_TITLE_DeletedConnection"), 0);
                if (res == 0) {
                    ServerList.addServer((ExecutionEnvironment)record.getExecutionEnvironment(), (String)record.getDisplayName(), (RemoteSyncFactory)record.getSyncFactory(), (boolean)false, (boolean)true);
                } else {
                    return;
                }
            }
            wrapper = new CancellableTask(){

                @Override
                public boolean cancel() {
                    return actionWorker.cancel();
                }

                @Override
                public void runImpl() {
                    try {
                        if (!ConnectionManager.getInstance().isConnectedTo(record.getExecutionEnvironment())) {
                            ConnectionManager.getInstance().connectTo(record.getExecutionEnvironment());
                        }
                        record.validate(true);
                        CompilerSetManager csm = CompilerSetManager.get((ExecutionEnvironment)record.getExecutionEnvironment());
                        csm.initialize(true, true, null);
                    }
                    catch (CancellationException ex) {
                        this.cancel();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        final String message = MessageFormat.format(MakeActionProvider.getString("ERR_Cant_Connect"), record.getDisplayName());
                        final String title = MakeActionProvider.getString("DLG_TITLE_Cant_Connect");
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                JOptionPane.showMessageDialog(WindowManager.getDefault().getMainWindow(), message, title, 0);
                            }
                        });
                    }
                    if (record.isOnline()) {
                        actionWorker.run();
                    }
                }
            };
        }
        Frame mainWindow = WindowManager.getDefault().getMainWindow();
        String msg = NbBundle.getMessage(MakeActionProvider.class, (String)"MSG_Validate_Host", (Object)record.getDisplayName());
        String title = NbBundle.getMessage(MakeActionProvider.class, (String)"DLG_TITLE_Validate_Host");
        ModalMessageDlg.runLongTask((Frame)mainWindow, (Runnable)wrapper, null, (Cancellable)wrapper, (String)title, (String)msg);
    }

    private void addAction(ArrayList<ProjectActionEvent> actionEvents, MakeConfigurationDescriptor pd, MakeConfiguration conf, String command, Lookup context, AtomicBoolean cancelled) throws IllegalArgumentException {
        if (cancelled.get()) {
            return;
        }
        AtomicBoolean validated = new AtomicBoolean(false);
        this.lastValidation = false;
        String[] targetNames = this.getTargetNames(command);
        if (targetNames == null || targetNames.length == 0) {
            return;
        }
        for (int i = 0; i < targetNames.length; ++i) {
            String targetName = targetNames[i];
            ArrayList<String> tail = new ArrayList<String>();
            for (int j = i + 1; j < targetNames.length; ++j) {
                tail.add(targetNames[j]);
            }
            List<String> delegate = this.validateStep(targetName, tail);
            if (delegate != null) {
                for (String target : delegate) {
                    if (!this.addTarget(target, actionEvents, pd, conf, context, cancelled, validated)) break;
                }
                continue;
            }
            if (!this.addTarget(targetName, actionEvents, pd, conf, context, cancelled, validated)) break;
        }
    }

    private boolean addTarget(String targetName, ArrayList<ProjectActionEvent> actionEvents, MakeConfigurationDescriptor pd, MakeConfiguration conf, Lookup context, AtomicBoolean cancelled, AtomicBoolean validated) throws IllegalArgumentException {
        if (cancelled.get()) {
            return false;
        }
        if (targetName.equals(SAVE_STEP)) {
            return this.onSaveStep();
        }
        if (targetName.equals(VALIDATE_TOOLCHAIN)) {
            return this.onValidateToolchainStep(pd, conf, cancelled, validated);
        }
        if (targetName.equals(BUILD_STEP)) {
            return this.onBuildStep(actionEvents, pd, conf, ProjectActionEvent.PredefinedType.BUILD);
        }
        if (targetName.equals(BUILD_TESTS_STEP)) {
            return this.onBuildStep(actionEvents, pd, conf, ProjectActionEvent.PredefinedType.BUILD_TESTS);
        }
        if (targetName.equals(BUILD_PACKAGE_STEP)) {
            return this.onBuildPackageStep(actionEvents, conf, ProjectActionEvent.PredefinedType.BUILD);
        }
        if (targetName.equals(CLEAN_STEP)) {
            return this.onCleanStep(actionEvents, pd, conf, ProjectActionEvent.PredefinedType.CLEAN);
        }
        if (targetName.equals(COMPILE_SINGLE_STEP)) {
            return this.onCompileSingleStep(actionEvents, pd, conf, context, ProjectActionEvent.PredefinedType.BUILD);
        }
        if (targetName.equals(RUN_STEP)) {
            return this.onRunStep(actionEvents, pd, conf, cancelled, validated, context, ProjectActionEvent.PredefinedType.RUN);
        }
        if (targetName.equals(TEST_STEP)) {
            return this.onRunStep(actionEvents, pd, conf, cancelled, validated, context, ProjectActionEvent.PredefinedType.TEST);
        }
        if (targetName.equals(TEST_SINGLE_STEP)) {
            return this.onTestSingleStep(actionEvents, pd, conf, context, ProjectActionEvent.PredefinedType.TEST);
        }
        if (targetName.equals(RUN_SINGLE_STEP) || targetName.equals(DEBUG_SINGLE_STEP)) {
            return this.onRunSingleStep(conf, actionEvents, context, ProjectActionEvent.PredefinedType.RUN);
        }
        if (targetName.equals(DEBUG_STEP)) {
            return this.onRunStep(actionEvents, pd, conf, cancelled, validated, context, ProjectActionEvent.PredefinedType.DEBUG);
        }
        if (targetName.equals(DEBUG_STEPINTO_STEP)) {
            return this.onRunStep(actionEvents, pd, conf, cancelled, validated, context, ProjectActionEvent.PredefinedType.DEBUG_STEPINTO);
        }
        if (targetName.equals(DEBUG_LOAD_ONLY_STEP)) {
            return this.onRunStep(actionEvents, pd, conf, cancelled, validated, context, ProjectActionEvent.PredefinedType.DEBUG_LOAD_ONLY);
        }
        if (targetName.equals(CUSTOM_ACTION_STEP)) {
            return this.onCustomActionStep(actionEvents, conf, context, ProjectActionEvent.PredefinedType.CUSTOM_ACTION);
        }
        return this.onExtendedStep(actionEvents, conf, context, targetName);
    }

    private boolean onSaveStep() {
        if (MakeOptions.getInstance().getSave()) {
            LifecycleManager.getDefault().saveAll();
        }
        return ProjectSupport.saveAllProjects(MakeActionProvider.getString("NeedToSaveAllText"));
    }

    private boolean onRunStep(ArrayList<ProjectActionEvent> actionEvents, MakeConfigurationDescriptor pd, MakeConfiguration conf, AtomicBoolean cancelled, AtomicBoolean validated, Lookup context, ProjectActionEvent.Type actionEvent) {
        String path;
        Node node;
        PlatformInfo pi = conf.getPlatformInfo();
        validated.set(true);
        Folder targetFolder = (Folder)context.lookup(Folder.class);
        if (targetFolder == null && (node = (Node)context.lookup(Node.class)) != null) {
            targetFolder = (Folder)node.getValue("Folder");
        }
        if (targetFolder != null) {
            RunProfile runProfile;
            CompilerSet compilerSet;
            path = "";
            if (targetFolder.isTest() && (compilerSet = conf.getCompilerSet().getCompilerSet()) != null) {
                path = targetFolder.getFolderConfiguration(conf).getLinkerConfiguration().getOutputValue();
                path = conf.expandMacros(path);
                path = CndPathUtilitities.toAbsolutePath((String)conf.getBaseDir(), (String)path);
            }
            if ((runProfile = MakeActionProvider.createRunProfile(conf, cancelled)) == null && cancelled.get()) {
                return false;
            }
            ProjectActionEvent projectActionEvent = new ProjectActionEvent(this.project, actionEvent, path, conf, runProfile, false);
            actionEvents.add(projectActionEvent);
            RunDialogPanel.addElementToExecutablePicklist(path);
        } else if (actionEvent == ProjectActionEvent.PredefinedType.TEST) {
            if (conf.isCompileConfiguration() && !this.validateProject(conf)) {
                return true;
            }
            MakeArtifact makeArtifact = new MakeArtifact(pd, conf);
            String buildCommand = makeArtifact.getBuildCommand(MakeActionProvider.getMakeCommand(pd, conf), TEST_STEP);
            String args = "";
            int index = this.getArgsIndex(buildCommand);
            if (index > 0) {
                args = buildCommand.substring(index + 1);
                buildCommand = this.removeQuotes(buildCommand.substring(0, index));
            }
            RunProfile profile = new RunProfile(makeArtifact.getWorkingDirectory(), conf.getDevelopmentHost().getBuildPlatform());
            profile.setArgs(args);
            ProjectActionEvent projectActionEvent = new ProjectActionEvent(this.project, actionEvent, buildCommand, conf, profile, true);
            actionEvents.add(projectActionEvent);
        } else if (conf.isMakefileConfiguration()) {
            if (actionEvent == ProjectActionEvent.PredefinedType.RUN) {
                path = conf.getMakefileConfiguration().getOutput().getValue();
                if (path.length() > 0 && !CndPathUtilitities.isPathAbsolute((String)path)) {
                    path = conf.getMakefileConfiguration().getAbsOutput();
                    path = CndPathUtilitities.toRelativePath((String)conf.getProfile().getRunDirectory(), (String)path);
                }
            } else {
                path = conf.getMakefileConfiguration().getAbsOutput();
                path = CndPathUtilitities.normalize((String)path);
            }
            ProjectActionEvent projectActionEvent = new ProjectActionEvent(this.project, actionEvent, path, conf, null, false);
            actionEvents.add(projectActionEvent);
            RunDialogPanel.addElementToExecutablePicklist(path);
        } else {
            if (conf.isLibraryConfiguration()) {
                assert (false);
                return false;
            }
            if (conf.isApplicationConfiguration()) {
                String path2;
                RunProfile runProfile = MakeActionProvider.createRunProfile(conf, cancelled);
                if (runProfile == null && cancelled.get()) {
                    return false;
                }
                MakeArtifact makeArtifact = new MakeArtifact(pd, conf);
                if (actionEvent == ProjectActionEvent.PredefinedType.RUN) {
                    path2 = makeArtifact.getOutput();
                    if (!CndPathUtilitities.isPathAbsolute((String)path2)) {
                        path2 = makeArtifact.getWorkingDirectory() + "/" + path2;
                        path2 = CndPathUtilitities.naturalize((String)path2);
                        path2 = CndPathUtilitities.toRelativePath((String)conf.getProfile().getRunDirectory(), (String)path2);
                        path2 = CndPathUtilitities.naturalize((String)path2);
                    }
                } else {
                    path2 = CndPathUtilitities.toAbsolutePath((String)conf.getBaseDir(), (String)makeArtifact.getOutput());
                }
                ProjectActionEvent projectActionEvent = new ProjectActionEvent(this.project, actionEvent, path2, conf, runProfile, false);
                actionEvents.add(projectActionEvent);
                RunDialogPanel.addElementToExecutablePicklist(path2);
            } else assert (false);
        }
        return true;
    }

    private static RunProfile createRunProfile(MakeConfiguration conf, AtomicBoolean cancelled) {
        RunProfile runProfile = null;
        PlatformInfo pi = conf.getPlatformInfo();
        int platform = conf.getDevelopmentHost().getBuildPlatform();
        if (platform == 3) {
            runProfile = conf.getProfile().clone(conf);
            Set<String> subProjectOutputLocations = conf.getSubProjectOutputLocations();
            String path = "";
            Iterator<String> iter = subProjectOutputLocations.iterator();
            while (iter.hasNext()) {
                String location = CndPathUtilitities.naturalize((String)iter.next());
                path = location + ";" + path;
            }
            List<String> list = conf.getLinkerConfiguration().getAdditionalLibs().getValue();
            iter = list.iterator();
            while (iter.hasNext()) {
                String location = CndPathUtilitities.naturalize((String)iter.next());
                path = location + ";" + path;
            }
            String userPath = runProfile.getEnvironment().getenv(pi.getPathName());
            if (userPath == null) {
                if (cancelled.get()) {
                    return null;
                }
                userPath = (String)HostInfoProvider.getEnv((ExecutionEnvironment)conf.getDevelopmentHost().getExecutionEnvironment()).get(pi.getPathName());
            }
            path = path + ";" + userPath;
            runProfile.getEnvironment().putenv(pi.getPathName(), path);
        } else if (platform == 4) {
            StringBuilder path = new StringBuilder();
            Set<String> subProjectOutputLocations = conf.getSubProjectOutputLocations();
            Iterator<String> iter = subProjectOutputLocations.iterator();
            while (iter.hasNext()) {
                String location = CndPathUtilitities.naturalize((String)iter.next());
                if (path.length() > 0) {
                    path.append(":");
                }
                path.append(location);
            }
            List<String> list = conf.getLinkerConfiguration().getAdditionalLibs().getValue();
            iter = list.iterator();
            while (iter.hasNext()) {
                String location = CndPathUtilitities.naturalize((String)iter.next());
                if (path.length() > 0) {
                    path.append(":");
                }
                path.append(location);
            }
            if (path.length() > 0) {
                runProfile = conf.getProfile().clone(conf);
                String extPath = runProfile.getEnvironment().getenv("DYLD_LIBRARY_PATH");
                if (extPath == null) {
                    if (cancelled.get()) {
                        return null;
                    }
                    extPath = (String)HostInfoProvider.getEnv((ExecutionEnvironment)conf.getDevelopmentHost().getExecutionEnvironment()).get("DYLD_LIBRARY_PATH");
                }
                if (extPath != null) {
                    path.append(":").append(extPath);
                }
                runProfile.getEnvironment().putenv("DYLD_LIBRARY_PATH", path.toString());
            }
        } else if (platform == 1 || platform == 0 || platform == 2) {
            String ont;
            StringBuilder path = new StringBuilder();
            List<String> list = conf.getLinkerConfiguration().getAdditionalLibs().getValue();
            Iterator<String> iter = list.iterator();
            while (iter.hasNext()) {
                String location = CndPathUtilitities.naturalize((String)iter.next());
                if (path.length() > 0) {
                    path.append(":");
                }
                path.append(location);
            }
            if (path.length() > 0) {
                runProfile = conf.getProfile().clone(conf);
                String extPath = runProfile.getEnvironment().getenv("LD_LIBRARY_PATH");
                if (extPath == null) {
                    if (cancelled.get()) {
                        return null;
                    }
                    extPath = (String)HostInfoProvider.getEnv((ExecutionEnvironment)conf.getDevelopmentHost().getExecutionEnvironment()).get("LD_LIBRARY_PATH");
                }
                if (extPath != null) {
                    path.append(":").append(extPath);
                }
                runProfile.getEnvironment().putenv("LD_LIBRARY_PATH", path.toString());
            }
            if ((ont = (String)HostInfoProvider.getEnv((ExecutionEnvironment)conf.getDevelopmentHost().getExecutionEnvironment()).get("OMP_NUM_THREADS")) == null) {
                ont = conf.getProfile().getEnvironment().getenv("OMP_NUM_THREADS");
            }
            if (ont == null) {
                if (runProfile == null) {
                    runProfile = conf.getProfile().clone(conf);
                }
                runProfile.getEnvironment().putenv("OMP_NUM_THREADS", "2");
            }
        }
        if (platform == 4 || platform == 1 || platform == 0 || platform == 2) {
            if (cancelled.get()) {
                return null;
            }
            if (conf.getDevelopmentHost().getExecutionEnvironment().isLocal() && HostInfoProvider.getEnv((ExecutionEnvironment)conf.getDevelopmentHost().getExecutionEnvironment()).get("DISPLAY") == null && conf.getProfile().getEnvironment().getenv("DISPLAY") == null) {
                if (runProfile == null) {
                    runProfile = conf.getProfile().clone(conf);
                }
                runProfile.getEnvironment().putenv("DISPLAY", ":0.0");
            }
        }
        return runProfile;
    }

    private boolean onRunSingleStep(MakeConfiguration conf, ArrayList<ProjectActionEvent> actionEvents, Lookup context, ProjectActionEvent.Type actionEvent) {
        if (conf.isMakefileConfiguration()) {
            DataObject d = (DataObject)context.lookup(DataObject.class);
            String path = FileUtil.toFile((FileObject)d.getPrimaryFile()).getPath();
            ProjectActionEvent projectActionEvent = new ProjectActionEvent(this.project, actionEvent, path, conf, null, false);
            actionEvents.add(projectActionEvent);
            RunDialogPanel.addElementToExecutablePicklist(path);
        } else assert (false);
        return true;
    }

    private boolean onBuildStep(ArrayList<ProjectActionEvent> actionEvents, MakeConfigurationDescriptor pd, MakeConfiguration conf, ProjectActionEvent.Type actionEvent) {
        if (conf.isCompileConfiguration() && !this.validateProject(conf)) {
            return true;
        }
        MakeArtifact makeArtifact = new MakeArtifact(pd, conf);
        String makeCommand = MakeActionProvider.getMakeCommand(pd, conf);
        String buildCommand = actionEvent == ProjectActionEvent.PredefinedType.BUILD_TESTS ? makeArtifact.getBuildCommand(makeCommand, BUILD_TESTS_STEP) : makeArtifact.getBuildCommand(makeCommand, "");
        String args = "";
        int index = this.getArgsIndex(buildCommand);
        if (index > 0) {
            args = buildCommand.substring(index + 1);
            buildCommand = this.removeQuotes(buildCommand.substring(0, index));
        }
        RunProfile profile = new RunProfile(makeArtifact.getWorkingDirectory(), conf.getDevelopmentHost().getBuildPlatform());
        profile.setArgs(args);
        ProjectActionEvent projectActionEvent = new ProjectActionEvent(this.project, actionEvent, buildCommand, conf, profile, true);
        actionEvents.add(projectActionEvent);
        return true;
    }

    private boolean onBuildPackageStep(ArrayList<ProjectActionEvent> actionEvents, MakeConfiguration conf, ProjectActionEvent.Type actionEvent) {
        if (!this.validatePackaging(conf)) {
            actionEvents.clear();
            return true;
        }
        String script = "nbproject/Package-" + conf.getName() + ".bash";
        RunProfile profile = new RunProfile(conf.getBaseDir(), conf.getDevelopmentHost().getBuildPlatform());
        String buildCommand = null;
        if (conf.getDevelopmentHost().getBuildPlatform() == 3) {
            HostInfo hostInfo = null;
            try {
                hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)conf.getDevelopmentHost().getExecutionEnvironment());
                buildCommand = hostInfo.getShell();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (CancellationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            if (buildCommand == null) {
                buildCommand = "sh.exe";
            }
        } else {
            buildCommand = "bash";
        }
        if (conf.getPackagingConfiguration().getVerbose().getValue()) {
            profile.setArgs(new String[]{"-x", script});
        } else {
            profile.setArgs(new String[]{script});
        }
        ProjectActionEvent projectActionEvent = new ProjectActionEvent(this.project, actionEvent, buildCommand, conf, profile, true);
        actionEvents.add(projectActionEvent);
        return true;
    }

    private boolean onCleanStep(ArrayList<ProjectActionEvent> actionEvents, MakeConfigurationDescriptor pd, MakeConfiguration conf, ProjectActionEvent.Type actionEvent) {
        MakeArtifact makeArtifact = new MakeArtifact(pd, conf);
        String buildCommand = makeArtifact.getCleanCommand(MakeActionProvider.getMakeCommand(pd, conf), "");
        String args = "";
        int index = this.getArgsIndex(buildCommand);
        if (index > 0) {
            args = buildCommand.substring(index + 1);
            buildCommand = this.removeQuotes(buildCommand.substring(0, index));
        }
        RunProfile profile = new RunProfile(makeArtifact.getWorkingDirectory(), conf.getDevelopmentHost().getBuildPlatform());
        profile.setArgs(args);
        ProjectActionEvent projectActionEvent = new ProjectActionEvent(this.project, actionEvent, buildCommand, conf, profile, true);
        actionEvents.add(projectActionEvent);
        return true;
    }

    private boolean onExtendedStep(ArrayList<ProjectActionEvent> actionEvents, MakeConfiguration conf, Lookup context, String extendedStep) {
        MyType actionEvent = new MyType(extendedStep);
        ProjectActionEvent projectActionEvent = new ProjectActionEvent(this.project, actionEvent, null, conf, null, true, context);
        actionEvents.add(projectActionEvent);
        return true;
    }

    private boolean onCompileSingleStep(ArrayList<ProjectActionEvent> actionEvents, MakeConfigurationDescriptor pd, MakeConfiguration conf, Lookup context, ProjectActionEvent.Type actionEvent) {
        for (Node node : context.lookupAll(Node.class)) {
            String args;
            String commandLine;
            Item item = this.getNoteItem(node);
            if (item == null) {
                return false;
            }
            ItemConfiguration itemConfiguration = item.getItemConfiguration(conf);
            if (itemConfiguration == null) {
                return false;
            }
            if (itemConfiguration.getExcluded().getValue()) {
                return false;
            }
            if (itemConfiguration.getTool() == PredefinedToolKind.CustomTool && !itemConfiguration.getCustomToolConfiguration().getModified()) {
                return false;
            }
            MakeArtifact makeArtifact = new MakeArtifact(pd, conf);
            String outputFile = null;
            if (itemConfiguration.getTool() == PredefinedToolKind.CCompiler) {
                CCompilerConfiguration cCompilerConfiguration = itemConfiguration.getCCompilerConfiguration();
                outputFile = cCompilerConfiguration.getOutputFile(item, conf, true);
            } else if (itemConfiguration.getTool() == PredefinedToolKind.CCCompiler) {
                CCCompilerConfiguration ccCompilerConfiguration = itemConfiguration.getCCCompilerConfiguration();
                outputFile = ccCompilerConfiguration.getOutputFile(item, conf, true);
            } else if (itemConfiguration.getTool() == PredefinedToolKind.FortranCompiler) {
                FortranCompilerConfiguration fortranCompilerConfiguration = itemConfiguration.getFortranCompilerConfiguration();
                outputFile = fortranCompilerConfiguration.getOutputFile(item, conf, true);
            } else if (itemConfiguration.getTool() == PredefinedToolKind.Assembler) {
                AssemblerConfiguration assemblerConfiguration = itemConfiguration.getAssemblerConfiguration();
                outputFile = assemblerConfiguration.getOutputFile(item, conf, true);
            } else if (itemConfiguration.getTool() == PredefinedToolKind.CustomTool) {
                CustomToolConfiguration customToolConfiguration = itemConfiguration.getCustomToolConfiguration();
                outputFile = customToolConfiguration.getOutputs().getValue();
            }
            outputFile = conf.expandMacros(outputFile);
            if (conf.getDevelopmentHost().getBuildPlatform() == 3) {
                commandLine = "cmd.exe";
                args = "/c rm -rf " + outputFile;
            } else {
                commandLine = "rm";
                args = "-rf " + outputFile;
            }
            RunProfile profile = new RunProfile(makeArtifact.getWorkingDirectory(), conf.getDevelopmentHost().getBuildPlatform());
            profile.setArgs(args);
            ProjectActionEvent projectActionEvent = new ProjectActionEvent(this.project, ProjectActionEvent.PredefinedType.CLEAN, commandLine, conf, profile, true);
            actionEvents.add(projectActionEvent);
            commandLine = MakeActionProvider.getMakeCommand(pd, conf) + " -f nbproject" + '/' + "Makefile-" + conf.getName() + ".mk " + outputFile;
            args = "";
            int index = commandLine.indexOf(32);
            if (index > 0) {
                args = commandLine.substring(index + 1);
                commandLine = commandLine.substring(0, index);
            }
            profile = new RunProfile(makeArtifact.getWorkingDirectory(), conf.getDevelopmentHost().getBuildPlatform());
            profile.setArgs(args);
            projectActionEvent = new ProjectActionEvent(this.project, actionEvent, commandLine, conf, profile, true);
            actionEvents.add(projectActionEvent);
        }
        return true;
    }

    private boolean onTestSingleStep(ArrayList<ProjectActionEvent> actionEvents, MakeConfigurationDescriptor pd, MakeConfiguration conf, Lookup context, ProjectActionEvent.Type actionEvent) {
        if (actionEvent == ProjectActionEvent.PredefinedType.TEST) {
            if (conf.isCompileConfiguration() && !this.validateProject(conf)) {
                return true;
            }
            Folder targetFolder = (Folder)context.lookup(Folder.class);
            if (targetFolder == null) {
                Node node = (Node)context.lookup(Node.class);
                if (node == null) {
                    return true;
                }
                targetFolder = (Folder)node.getValue("Folder");
            }
            if (targetFolder == null) {
                return true;
            }
            List<Folder> list = targetFolder.getAllTests();
            if (targetFolder.isTest()) {
                list.add(targetFolder);
            }
            for (Folder folder : list) {
                CompilerSet compilerSet = conf.getCompilerSet().getCompilerSet();
                if (compilerSet == null) continue;
                String target = folder.getFolderConfiguration(conf).getLinkerConfiguration().getOutputValue();
                target = conf.expandMacros(target);
                MakeArtifact makeArtifact = new MakeArtifact(pd, conf);
                String buildCommand = makeArtifact.getBuildCommand(MakeActionProvider.getMakeCommand(pd, conf), "test TEST=" + target);
                String args = "";
                int index = this.getArgsIndex(buildCommand);
                if (index > 0) {
                    args = buildCommand.substring(index + 1);
                    buildCommand = this.removeQuotes(buildCommand.substring(0, index));
                }
                RunProfile profile = new RunProfile(makeArtifact.getWorkingDirectory(), conf.getDevelopmentHost().getBuildPlatform());
                profile.setArgs(args);
                ProjectActionEvent projectActionEvent = new ProjectActionEvent(this.project, actionEvent, buildCommand, conf, profile, true);
                actionEvents.add(projectActionEvent);
                break;
            }
        }
        return true;
    }

    private boolean onCustomActionStep(ArrayList<ProjectActionEvent> actionEvents, MakeConfiguration conf, Lookup context, ProjectActionEvent.Type actionEvent) {
        String exe = conf.getAbsoluteOutputValue();
        ProjectActionEvent projectActionEvent = new ProjectActionEvent(this.project, actionEvent, exe, conf, null, true, context);
        actionEvents.add(projectActionEvent);
        return true;
    }

    private boolean onValidateToolchainStep(MakeConfigurationDescriptor pd, MakeConfiguration conf, AtomicBoolean cancelled, AtomicBoolean validated) {
        if (!this.validateBuildSystem(pd, conf, validated.get(), cancelled)) {
            return false;
        }
        validated.set(true);
        return true;
    }

    private boolean validateProject(MakeConfiguration conf) {
        boolean ret = false;
        if (this.getProjectDescriptor().getProjectItems().length == 0) {
            ret = false;
        } else {
            for (int i = 0; i < this.getProjectDescriptor().getProjectItems().length; ++i) {
                Item item = this.getProjectDescriptor().getProjectItems()[i];
                ItemConfiguration itemConfiguration = item.getItemConfiguration(conf);
                if (itemConfiguration == null || itemConfiguration.getExcluded().getValue() || itemConfiguration.getTool() == PredefinedToolKind.CustomTool && itemConfiguration.getCustomToolConfiguration().getCommandLine().getValue().length() <= 0) continue;
                ret = true;
                break;
            }
        }
        if (!ret) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)MakeActionProvider.getString("ERR_EMPTY_PROJECT"), 0));
        }
        return ret;
    }

    private String[] getTargetNames(String command) throws IllegalArgumentException {
        String[] targetNames = new String[]{};
        if (command.equals("compile.single")) {
            targetNames = this.commands.get(command);
        } else if (command.equals(RUN_STEP) || command.equals(DEBUG_STEP) || command.equals("debug.stepinto") || command.equals(COMMAND_DEBUG_LOAD_ONLY) || command.equals(COMMAND_CUSTOM_ACTION)) {
            MakeConfigurationDescriptor pd = this.getProjectDescriptor();
            MakeConfiguration conf = pd.getActiveConfiguration();
            if (conf == null) {
                return null;
            }
            RunProfile profile = (RunProfile)conf.getAuxObject("runprofile");
            if (profile == null) {
                return null;
            }
            targetNames = profile.getBuildFirst() ? this.commands.get(command) : this.commandsNoBuild.get(command);
            if (targetNames == null) {
                throw new IllegalArgumentException(command);
            }
        } else if (command.equals("run.single") || command.equals("debug.single") ? (targetNames = this.commands.get(command)) == null : (targetNames = this.commands.get(command)) == null) {
            throw new IllegalArgumentException(command);
        }
        return targetNames;
    }

    public boolean isActionEnabled(String command, Lookup context) {
        if (!this.isProjectDescriptorLoaded()) {
            return false;
        }
        MakeConfiguration conf = this.getProjectDescriptor().getActiveConfiguration();
        if (conf == null) {
            return false;
        }
        if (command.equals(CLEAN_STEP)) {
            return true;
        }
        if (command.equals(BUILD_STEP)) {
            return true;
        }
        if (command.equals(COMMAND_BUILD_PACKAGE)) {
            return true;
        }
        if (command.equals(COMMAND_BATCH_BUILD)) {
            return true;
        }
        if (command.equals("rebuild")) {
            return true;
        }
        if (command.equals(RUN_STEP)) {
            return !conf.isLibraryConfiguration();
        }
        if (command.equals(DEBUG_STEP)) {
            return conf.hasDebugger() && !conf.isLibraryConfiguration();
        }
        if (command.equals("debug.stepinto")) {
            return conf.hasDebugger() && !conf.isLibraryConfiguration();
        }
        if (command.equals(COMMAND_DEBUG_LOAD_ONLY)) {
            return conf.hasDebugger() && !conf.isLibraryConfiguration();
        }
        if (command.equals("compile.single")) {
            boolean enabled = true;
            for (Node node : context.lookupAll(Node.class)) {
                Item item = this.getNoteItem(node);
                if (item == null) {
                    return false;
                }
                ItemConfiguration itemConfiguration = item.getItemConfiguration(conf);
                if (itemConfiguration == null) {
                    return false;
                }
                if (itemConfiguration.getExcluded().getValue()) {
                    return false;
                }
                if (itemConfiguration.getTool() == PredefinedToolKind.CustomTool && !itemConfiguration.getCustomToolConfiguration().getModified()) {
                    return false;
                }
                if (!conf.isMakefileConfiguration()) continue;
                return false;
            }
            return enabled;
        }
        if (command.equals("delete") || command.equals("copy") || command.equals("move") || command.equals("rename")) {
            return true;
        }
        if (command.equals("run.single")) {
            Node node = (Node)context.lookup(Node.class);
            return node != null && node.getCookie(ShellExecSupport.class) != null;
        }
        if (command.equals(TEST_STEP)) {
            Folder root = this.projectDescriptor.getLogicalFolders();
            Folder testRootFolder = null;
            for (Folder folder : root.getFolders()) {
                if (!folder.isTestRootFolder()) continue;
                testRootFolder = folder;
                break;
            }
            return testRootFolder != null;
        }
        return false;
    }

    private Item getNoteItem(Node node) {
        Item item = (Item)node.getValue("Item");
        if (item == null) {
            try {
                DataObject dao = (DataObject)node.getCookie(DataObject.class);
                if (dao != null) {
                    File file = FileUtil.toFile((FileObject)dao.getPrimaryFile());
                    item = this.getProjectDescriptor().findItemByFile(file);
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return item;
    }

    private static String getMakeCommand(MakeConfigurationDescriptor pd, MakeConfiguration conf) {
        String cmd = null;
        CompilerSet cs = conf.getCompilerSet().getCompilerSet();
        if (cs != null) {
            cmd = cs.getTool((ToolKind)PredefinedToolKind.MakeTool).getPath();
        } else {
            CndUtils.assertFalse((boolean)true, (String)"Null compiler collection");
            cmd = "make";
        }
        return cmd;
    }

    private List<String> validateStep(String id, List<String> tailSteps) {
        StepControllerProvider.StepController validator = StepControllerProvider.getController(id);
        if (validator == null) {
            return null;
        }
        return validator.validate(this.project, id, tailSteps);
    }

    private boolean validateBuildSystem(MakeConfigurationDescriptor pd, MakeConfiguration conf, boolean validated, AtomicBoolean cancelled) {
        CompilerSet cs;
        String csname;
        ExecutionEnvironment execEnv;
        int hostPlatformId;
        int buildPlatformId;
        CompilerSet2Configuration csconf = conf.getCompilerSet();
        ExecutionEnvironment env = ExecutionEnvironmentFactory.fromUniqueID((String)conf.getDevelopmentHost().getHostKey());
        ArrayList<String> errs = new ArrayList<String>();
        boolean cRequired = conf.hasCFiles(pd);
        boolean cppRequired = conf.hasCPPFiles(pd);
        boolean fRequired = conf.hasFortranFiles(pd);
        boolean asRequired = conf.hasAssemblerFiles(pd);
        boolean runBTA = false;
        if (validated) {
            return this.lastValidation;
        }
        if (!conf.getDevelopmentHost().isLocalhost()) {
            ServerRecord record = ServerList.get((ExecutionEnvironment)env);
            assert (record != null);
            record.validate(false);
            if (cancelled.get()) {
                return false;
            }
            if (!record.isOnline()) {
                this.lastValidation = false;
                runBTA = true;
            }
        }
        if ((buildPlatformId = conf.getDevelopmentHost().getBuildPlatform()) != (hostPlatformId = CompilerSetManager.get((ExecutionEnvironment)(execEnv = conf.getDevelopmentHost().getExecutionEnvironment())).getPlatform())) {
            if (!conf.isMakefileConfiguration()) {
                Platform buildPlatform = Platforms.getPlatform(buildPlatformId);
                Platform hostPlatform = Platforms.getPlatform(hostPlatformId);
                String errormsg = MakeActionProvider.getString("WRONG_PLATFORM", hostPlatform.getDisplayName(), buildPlatform.getDisplayName());
                if (DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)errormsg, 2)) != NotifyDescriptor.OK_OPTION) {
                    return false;
                }
            }
            conf.getDevelopmentHost().setBuildPlatform(hostPlatformId);
        }
        if (csconf.getFlavor() != null && csconf.getFlavor().equals("Unknown")) {
            csname = csconf.getOption();
            cs = CompilerSetManager.get((ExecutionEnvironment)env).getCompilerSet(csname);
            if (cs == null) {
                cs = CompilerSetManager.get((ExecutionEnvironment)env).getDefaultCompilerSet();
            }
            String errMsg = NbBundle.getMessage(MakeActionProvider.class, (String)"ERR_UnknownCompiler", (Object)csname);
            errs.add(errMsg);
            runBTA = true;
        } else if (csconf.isValid()) {
            csname = csconf.getOption();
            cs = CompilerSetManager.get((ExecutionEnvironment)env).getCompilerSet(csname);
        } else {
            csname = csconf.getOldName();
            CompilerFlavor flavor = null;
            if (csconf.getFlavor() != null) {
                flavor = CompilerFlavor.toFlavor((String)csconf.getFlavor(), (int)conf.getPlatformInfo().getPlatform());
            }
            if (flavor == null) {
                flavor = CompilerFlavor.getUnknown((int)conf.getPlatformInfo().getPlatform());
            }
            cs = CompilerSetFactory.getCompilerSet((ExecutionEnvironment)env, flavor, (String)csname);
            String errMsg = NbBundle.getMessage(MakeActionProvider.class, (String)"ERR_INVALID_LOCAL_COMPILER_SET", (Object)csname);
            errs.add(errMsg);
            runBTA = true;
        }
        if (cancelled.get()) {
            return false;
        }
        if (!runBTA) {
            Tool cTool = cs.getTool((ToolKind)PredefinedToolKind.CCompiler);
            Tool cppTool = cs.getTool((ToolKind)PredefinedToolKind.CCCompiler);
            Tool fTool = cs.getTool((ToolKind)PredefinedToolKind.FortranCompiler);
            Tool asTool = cs.getTool((ToolKind)PredefinedToolKind.Assembler);
            Tool makeTool = cs.getTool((ToolKind)PredefinedToolKind.MakeTool);
            Tool qmakeTool = cs.getTool((ToolKind)PredefinedToolKind.QMakeTool);
            PlatformInfo pi = conf.getPlatformInfo();
            if (conf.getDevelopmentHost().isLocalhost()) {
                File file = new File(makeTool.getPath());
                if (!MakeActionProvider.exists(makeTool.getPath(), pi) && Path.findCommand((String)makeTool.getPath()) == null || ToolsPanelSupport.isUnsupportedMake((String)file.getPath())) {
                    runBTA = true;
                }
            } else if (!MakeActionProvider.isValidExecutable(makeTool.getPath(), pi)) {
                runBTA = true;
            }
            ArrayList<Tool> tools2check = new ArrayList<Tool>();
            if (cRequired) {
                tools2check.add(cTool);
            }
            if (cppRequired) {
                tools2check.add(cppTool);
            }
            if (fRequired) {
                tools2check.add(fTool);
            }
            if (asRequired) {
                tools2check.add(asTool);
            }
            if (conf.isQmakeConfiguration()) {
                tools2check.add(qmakeTool);
            }
            for (Tool tool : tools2check) {
                if (cancelled.get()) {
                    return false;
                }
                if (MakeActionProvider.exists(tool.getPath(), pi)) continue;
                runBTA = true;
            }
        }
        if (cancelled.get()) {
            return false;
        }
        if (cs.getCompilerFlavor().isSunStudioCompiler() && !CndUtils.isUnitTestMode()) {
            SunStudioUserCounter.countIDE((String)cs.getDirectory(), (ExecutionEnvironment)execEnv);
        }
        if (runBTA) {
            if (CndUtils.isUnitTestMode()) {
                this.lastValidation = false;
            } else if (conf.getDevelopmentHost().isLocalhost()) {
                BuildToolsAction bt = (BuildToolsAction)SystemAction.get(BuildToolsAction.class);
                bt.setTitle(NbBundle.getMessage(BuildToolsAction.class, (String)"LBL_ResolveMissingTools_Title"));
                LocalToolsPanelModel model = new LocalToolsPanelModel();
                model.setSelectedDevelopmentHost(env);
                model.setEnableDevelopmentHostChange(false);
                model.setCompilerSetName(null);
                model.setSelectedCompilerSetName(csname);
                model.setMakeRequired(true);
                model.setDebuggerRequired(false);
                model.setCRequired(cRequired);
                model.setCppRequired(cppRequired);
                model.setFortranRequired(fRequired);
                model.setQMakeRequired(conf.isQmakeConfiguration());
                model.setAsRequired(asRequired);
                model.setShowRequiredBuildTools(true);
                model.setShowRequiredDebugTools(false);
                model.setEnableRequiredCompilerCB(conf.isMakefileConfiguration());
                if (bt.initBuildTools((ToolsPanelModel)model, errs, cs) && pd.okToChange()) {
                    String name = model.getSelectedCompilerSetName();
                    ToolsPanelModel.resetCompilerSetName((String)name);
                    conf.getCRequired().setValue(model.isCRequired());
                    conf.getCppRequired().setValue(model.isCppRequired());
                    conf.getFortranRequired().setValue(model.isFortranRequired());
                    conf.getAssemblerRequired().setValue(model.isAsRequired());
                    conf.getCompilerSet().setValue(name);
                    pd.setModified();
                    pd.save();
                    this.lastValidation = true;
                } else {
                    this.lastValidation = false;
                }
            }
        } else {
            this.lastValidation = true;
        }
        if (this.lastValidation && cs.getCompilerFlavor().isCygwinCompiler()) {
            boolean isOK;
            Shell activeShell = WindowsSupport.getInstance().getActiveShell();
            ShellValidationSupport.ShellValidationStatus shellValidationStatus = ShellValidationSupport.getValidationStatus((Shell)activeShell);
            boolean bl = isOK = shellValidationStatus.isValid() && !shellValidationStatus.hasWarnings();
            if (!isOK) {
                String binDir = cs.getDirectory();
                if (activeShell == null || !binDir.equals(activeShell.bindir.getAbsolutePath())) {
                    WindowsSupport.getInstance().init(binDir);
                    activeShell = WindowsSupport.getInstance().getActiveShell();
                    shellValidationStatus = ShellValidationSupport.getValidationStatus((Shell)activeShell);
                    boolean bl2 = isOK = shellValidationStatus.isValid() && !shellValidationStatus.hasWarnings();
                }
            }
            if (!isOK) {
                this.lastValidation = ShellValidationSupport.confirm((ShellValidationSupport.ShellValidationStatus)shellValidationStatus);
            }
        }
        return this.lastValidation;
    }

    private boolean validatePackaging(MakeConfiguration conf) {
        String errormsg = null;
        if (conf.getPackagingConfiguration().getFiles().getValue().isEmpty()) {
            errormsg = MakeActionProvider.getString("ERR_EMPTY_PACKAGE");
        }
        if (PackagerManager.getDefault().getPackager(conf.getPackagingConfiguration().getType().getValue()) == null) {
            errormsg = NbBundle.getMessage(MakeActionProvider.class, (String)"ERR_MISSING_TOOL4", (Object)conf.getPackagingConfiguration().getType().getValue());
        }
        if (errormsg != null) {
            MakeCustomizerProvider makeCustomizerProvider;
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)errormsg, 0));
            if (conf.getPackagingConfiguration().getFiles().getValue().isEmpty() && (makeCustomizerProvider = (MakeCustomizerProvider)this.project.getLookup().lookup(MakeCustomizerProvider.class)) != null) {
                makeCustomizerProvider.showCustomizer("Packaging");
            }
            return false;
        }
        return true;
    }

    private static boolean isValidExecutable(String path, PlatformInfo pi) {
        return MakeActionProvider.existsImpl(path, pi, true);
    }

    private static boolean exists(String path, PlatformInfo pi) {
        return MakeActionProvider.existsImpl(path, pi, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean existsImpl(String path, PlatformInfo pi, boolean checkExecutable) {
        boolean result;
        Map<String, Boolean> map;
        ExecutionEnvironment execEnv = pi.getExecutionEnvironment();
        String key = path + ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)execEnv);
        Map<String, Boolean> map2 = map = checkExecutable ? validExecutablesCache : fileExistenceCache;
        synchronized (map2) {
            Boolean cached = map.get(key);
            if (cached != null && cached.booleanValue()) {
                return true;
            }
        }
        if (checkExecutable) {
            result = ServerList.isValidExecutable((ExecutionEnvironment)execEnv, (String)path);
        } else {
            boolean bl = result = pi.fileExists(path) || pi.isWindows() && pi.fileExists(path + ".lnk") || pi.findCommand(path) != null;
        }
        if (result) {
            Map<String, Boolean> map3 = map;
            synchronized (map3) {
                map.put(key, Boolean.TRUE);
            }
        }
        return result;
    }

    private String removeQuotes(String command) {
        if (command.startsWith("\"") && command.endsWith("\"")) {
            return command.substring(1, command.length() - 1);
        }
        if (command.startsWith("'") && command.endsWith("'")) {
            return command.substring(1, command.length() - 1);
        }
        return command;
    }

    private int getArgsIndex(String command) {
        boolean inQuote = false;
        char quote = '\u0000';
        block4: for (int i = 0; i < command.length(); ++i) {
            char c = command.charAt(i);
            switch (c) {
                case ' ': {
                    if (inQuote) continue block4;
                    return i;
                }
                case '\"': 
                case '\'': {
                    if (inQuote) {
                        if (quote != c) continue block4;
                        quote = '\u0000';
                        inQuote = false;
                        continue block4;
                    }
                    quote = c;
                    inQuote = true;
                }
            }
        }
        return -1;
    }

    private static String getString(String s) {
        return NbBundle.getMessage(MakeActionProvider.class, (String)s);
    }

    private static String getString(String s, String arg1, String arg2) {
        return NbBundle.getMessage(MakeActionProvider.class, (String)s, (Object)arg1, (Object)arg2);
    }

    private static final class MyType
    implements ProjectActionEvent.Type {
        private final String extendedStep;
        private String locName;

        private MyType(String extendedStep) {
            this.extendedStep = extendedStep;
            this.locName = extendedStep;
        }

        @Override
        public int ordinal() {
            return this.extendedStep.hashCode();
        }

        @Override
        public String name() {
            return this.extendedStep;
        }

        @Override
        public String getLocalizedName() {
            return this.locName;
        }

        @Override
        public void setLocalizedName(String name) {
            this.locName = name;
        }
    }

    private static class BatchConfigurationSelector
    implements ActionListener {
        private JButton buildButton = new JButton(MakeActionProvider.access$300("BuildButton"));
        private JButton rebuildButton = new JButton(MakeActionProvider.access$300("CleanBuildButton"));
        private JButton cleanButton = new JButton(MakeActionProvider.access$300("CleanButton"));
        private JButton closeButton = new JButton(MakeActionProvider.access$300("CloseButton"));
        private ConfSelectorPanel confSelectorPanel;
        private String command = null;
        private Dialog dialog = null;

        BatchConfigurationSelector(MakeProject project, Configuration[] confs) {
            this.confSelectorPanel = new ConfSelectorPanel(MakeActionProvider.getString("CheckLabel"), MakeActionProvider.getString("CheckLabelMn").charAt(0), confs, new JButton[]{this.buildButton, this.rebuildButton, this.cleanButton});
            String dialogTitle = MessageFormat.format(MakeActionProvider.getString("BatchBuildTitle"), ProjectUtils.getInformation((Project)project).getDisplayName());
            this.buildButton.setMnemonic(MakeActionProvider.getString("BuildButtonMn").charAt(0));
            this.buildButton.getAccessibleContext().setAccessibleDescription(MakeActionProvider.getString("BuildButtonAD"));
            this.buildButton.addActionListener(this);
            this.rebuildButton.setMnemonic(MakeActionProvider.getString("CleanBuildButtonMn").charAt(0));
            this.rebuildButton.addActionListener(this);
            this.rebuildButton.getAccessibleContext().setAccessibleDescription(MakeActionProvider.getString("CleanBuildButtonAD"));
            this.cleanButton.setMnemonic(MakeActionProvider.getString("CleanButtonMn").charAt(0));
            this.cleanButton.addActionListener(this);
            this.cleanButton.getAccessibleContext().setAccessibleDescription(MakeActionProvider.getString("CleanButtonAD"));
            this.closeButton.getAccessibleContext().setAccessibleDescription(MakeActionProvider.getString("CloseButtonAD"));
            DialogDescriptor dd = new DialogDescriptor((Object)this.confSelectorPanel, dialogTitle, true, new Object[]{this.closeButton}, (Object)this.closeButton, 0, null, null);
            this.dialog = DialogDisplayer.getDefault().createDialog(dd);
            this.dialog.getAccessibleContext().setAccessibleDescription(MakeActionProvider.getString("BatchBuildDialogAD"));
            this.dialog.setVisible(true);
        }

        public Configuration[] getSelectedConfs() {
            return this.confSelectorPanel.getSelectedConfs();
        }

        public String getCommand() {
            return this.command;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == this.buildButton) {
                this.command = MakeActionProvider.BUILD_STEP;
            } else if (evt.getSource() == this.rebuildButton) {
                this.command = "rebuild";
            } else if (evt.getSource() == this.cleanButton) {
                this.command = MakeActionProvider.CLEAN_STEP;
            } else assert (false);
            this.dialog.dispose();
        }
    }

    private static abstract class CancellableTask
    implements Runnable,
    Cancellable {
        private volatile Thread thread;
        protected final AtomicBoolean cancelled = new AtomicBoolean(false);

        private CancellableTask() {
        }

        protected abstract void runImpl();

        @Override
        public final void run() {
            this.thread = Thread.currentThread();
            if (!this.cancelled.get()) {
                this.runImpl();
            }
        }

        public boolean cancel() {
            this.cancelled.set(true);
            if (this.thread != null) {
                this.thread.interrupt();
            }
            return true;
        }
    }
}

