/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.toolchain.ui.options;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.netbeans.modules.cnd.api.toolchain.Tool;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.LinkSupport;

final class VersionCommand {
    private final Tool tool;
    private String path;
    private boolean alreadyRun;
    private String version;

    public VersionCommand(Tool tool, String path) {
        this.tool = tool;
        this.path = path;
    }

    public String getVersion() {
        if (!this.alreadyRun) {
            this.run();
        }
        return this.version;
    }

    private void run() {
        if (this.tool.getExecutionEnvironment().isLocal()) {
            this.path = LinkSupport.resolveWindowsLink((String)this.path);
            File file = new File(this.path);
            if (!file.exists()) {
                this.alreadyRun = true;
                return;
            }
        }
        NativeProcessBuilder npb = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)this.tool.getExecutionEnvironment());
        npb.setExecutable(this.path);
        npb.setArguments(new String[]{this.getVersionFlags()});
        npb.redirectError();
        try {
            NativeProcess process = npb.call();
            this.version = this.extractVersion(process.getInputStream());
            process.destroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.alreadyRun = true;
    }

    private String getVersionFlags() {
        String flags = null;
        if (this.tool.getDescriptor() != null) {
            flags = this.tool.getDescriptor().getVersionFlags();
        }
        if (flags == null) {
            return "--version";
        }
        return flags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String extractVersion(InputStream is) {
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader(is));
            String string = br.readLine();
            return string;
        }
        catch (IOException ioe) {
            String string = null;
            return string;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException ex) {}
            }
        }
    }
}

