/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.dataobject;

import java.util.Map;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.text.Document;
import javax.swing.text.TextAction;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.languages.LanguageDefinitionNotFoundException;
import org.netbeans.modules.editor.NbEditorDocument;
import org.netbeans.modules.editor.NbEditorKit;
import org.netbeans.modules.editor.settings.storage.spi.StorageFilter;
import org.netbeans.modules.editor.settings.storage.spi.TypedValue;
import org.netbeans.modules.languages.Feature;
import org.netbeans.modules.languages.Language;
import org.netbeans.modules.languages.LanguagesManager;
import org.netbeans.modules.languages.features.AnnotationManager;
import org.netbeans.modules.languages.features.BraceCompletionDeleteAction;
import org.netbeans.modules.languages.features.BraceCompletionInsertAction;
import org.netbeans.modules.languages.features.CodeCommentAction;
import org.netbeans.modules.languages.features.CodeUncommentAction;
import org.netbeans.modules.languages.features.CollapseFoldTypeAction;
import org.netbeans.modules.languages.features.DatabaseManager;
import org.netbeans.modules.languages.features.ExpandFoldTypeAction;
import org.netbeans.modules.languages.features.HyperlinkListener;
import org.netbeans.modules.languages.features.InstantRenameAction;
import org.netbeans.modules.languages.features.LanguagesGenerateFoldPopupAction;
import org.netbeans.modules.languages.features.MarkOccurrencesSupport;
import org.netbeans.modules.languages.features.SyntaxErrorHighlighter;
import org.netbeans.modules.languages.features.ToggleCommentAction;
import org.netbeans.modules.languages.parser.Pattern;

public class LanguagesEditorKit
extends NbEditorKit {
    private final String mimeType;

    public LanguagesEditorKit(String mimeType) {
        this.mimeType = mimeType;
        if (mimeType == null) {
            throw new NullPointerException();
        }
    }

    protected Action[] createActions() {
        Action[] myActions = new Action[]{new BraceCompletionInsertAction(), new BraceCompletionDeleteAction(), new InstantRenameAction(), new LanguagesGenerateFoldPopupAction(), new ToggleCommentAction(), new CodeCommentAction(), new CodeUncommentAction()};
        return TextAction.augmentList(super.createActions(), myActions);
    }

    public Action getActionByName(String name) {
        if (name == null) {
            return super.getActionByName(name);
        }
        if (name.startsWith("Expand:")) {
            name = name.substring("Expand:".length(), name.length());
            return new ExpandFoldTypeAction(name);
        }
        if (name.startsWith("Collapse:")) {
            name = name.substring("Collapse:".length(), name.length());
            return new CollapseFoldTypeAction(name);
        }
        return super.getActionByName(name);
    }

    public Document createDefaultDocument() {
        LanguagesDocument doc = new LanguagesDocument(this.mimeType);
        this.initDocument((Document)((Object)doc));
        return doc;
    }

    protected void initDocument(Document doc) {
        new AnnotationManager(doc);
        new SyntaxErrorHighlighter(doc);
        new DatabaseManager(doc);
    }

    public void install(JEditorPane c) {
        super.install(c);
        HyperlinkListener hl = new HyperlinkListener();
        c.addMouseMotionListener(hl);
        c.addMouseListener(hl);
        c.addKeyListener(hl);
        c.addCaretListener(new MarkOccurrencesSupport(c));
    }

    public String getContentType() {
        return this.mimeType;
    }

    public Object clone() {
        return new LanguagesEditorKit(this.mimeType);
    }

    public static final class EditorSettings
    extends StorageFilter<String, TypedValue> {
        public EditorSettings() {
            super("Preferences");
        }

        public void afterLoad(Map<String, TypedValue> map, MimePath mimePath, String profile, boolean defaults) {
            if (mimePath.size() == 1 && LanguagesManager.getDefault().isSupported(mimePath.getPath()) && !map.containsKey("code-folding-enable")) {
                map.put("code-folding-enable", new TypedValue("true", Boolean.class.getName()));
            }
        }

        public void beforeSave(Map<String, TypedValue> map, MimePath mimePath, String profile, boolean defaults) {
        }
    }

    private static final class LanguagesDocument
    extends NbEditorDocument {
        public LanguagesDocument(String mimeType) {
            super(mimeType);
        }

        public boolean isIdentifierPart(char ch) {
            try {
                Pattern pat;
                String mimeType = (String)this.getProperty("mimeType");
                Language language = LanguagesManager.getDefault().getLanguage(mimeType);
                Feature f = language.getFeatureList().getFeature("SELECTION");
                if (f != null && (pat = f.getPattern()) != null) {
                    StringBuffer buf = new StringBuffer();
                    buf.append(ch);
                    return pat.matches(buf.toString());
                }
            }
            catch (LanguageDefinitionNotFoundException languageDefinitionNotFoundException) {
                // empty catch block
            }
            return super.isIdentifierPart(ch);
        }
    }
}

