/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.ast;

import java.util.List;
import org.jruby.nb.Ruby;
import org.jruby.nb.ast.Node;
import org.jruby.nb.ast.NodeType;
import org.jruby.nb.ast.visitor.NodeVisitor;
import org.jruby.nb.evaluator.Instruction;
import org.jruby.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;

public class BlockPassNode
extends Node {
    private final Node bodyNode;
    private Node argsNode;

    public BlockPassNode(ISourcePosition position, Node bodyNode) {
        super(position, NodeType.BLOCKPASSNODE);
        this.bodyNode = bodyNode;
    }

    @Override
    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitBlockPassNode(this);
    }

    public Node getBodyNode() {
        return this.bodyNode;
    }

    public Node getArgsNode() {
        return this.argsNode;
    }

    public void setArgsNode(Node argsNode) {
        this.argsNode = argsNode;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.argsNode, this.bodyNode);
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self, Block block) {
        return this.bodyNode == null ? runtime.getNil() : this.bodyNode.interpret(runtime, context, self, block);
    }
}

