/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.ast;

import java.util.List;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyClass;
import org.jruby.nb.RubyFixnum;
import org.jruby.nb.RubySymbol;
import org.jruby.nb.ast.ArgsNode;
import org.jruby.nb.ast.ArgumentNode;
import org.jruby.nb.ast.MethodDefNode;
import org.jruby.nb.ast.NilNode;
import org.jruby.nb.ast.Node;
import org.jruby.nb.ast.NodeType;
import org.jruby.nb.ast.types.INameNode;
import org.jruby.nb.ast.visitor.NodeVisitor;
import org.jruby.nb.evaluator.Instruction;
import org.jruby.nb.internal.runtime.methods.DefaultMethod;
import org.jruby.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.parser.StaticScope;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.Visibility;
import org.jruby.nb.runtime.builtin.IRubyObject;

public class DefsNode
extends MethodDefNode
implements INameNode {
    private final Node receiverNode;

    public DefsNode(ISourcePosition position, Node receiverNode, ArgumentNode nameNode, ArgsNode argsNode, StaticScope scope, Node bodyNode) {
        super(position, nameNode, argsNode, scope, bodyNode, NodeType.DEFSNODE);
        assert (receiverNode != null) : "receiverNode is not null";
        this.receiverNode = receiverNode;
    }

    @Override
    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitDefsNode(this);
    }

    public Node getReceiverNode() {
        return this.receiverNode;
    }

    @Override
    public String getName() {
        return this.nameNode.getName();
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.receiverNode, this.nameNode, this.argsNode, this.bodyNode);
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        IRubyObject receiver = this.receiverNode.interpret(runtime, context, self, aBlock);
        String name = this.getName();
        if (runtime.getSafeLevel() >= 4 && !receiver.isTaint()) {
            throw runtime.newSecurityError("Insecure; can't define singleton method.");
        }
        if (receiver instanceof RubyFixnum || receiver instanceof RubySymbol) {
            throw runtime.newTypeError("can't define singleton method \"" + name + "\" for " + receiver.getMetaClass().getBaseName());
        }
        if (receiver.isFrozen()) {
            throw runtime.newFrozenError("object");
        }
        RubyClass rubyClass = receiver.getSingletonClass();
        if (runtime.getSafeLevel() >= 4 && rubyClass.getMethods().get(name) != null) {
            throw runtime.newSecurityError("redefining method prohibited.");
        }
        this.scope.determineModule();
        Node body = this.bodyNode == null ? new NilNode(this.getPosition()) : this.bodyNode;
        DefaultMethod newMethod = new DefaultMethod(rubyClass, this.scope, body, this.argsNode, Visibility.PUBLIC, this.getPosition());
        rubyClass.addMethod(name, newMethod);
        receiver.callMethod(context, "singleton_method_added", runtime.fastNewSymbol(name));
        return runtime.getNil();
    }
}

