/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.compiler.impl;

import org.jruby.nb.compiler.CompilerCallback;
import org.jruby.nb.compiler.NotCompilableException;
import org.jruby.nb.compiler.impl.AbstractVariableCompiler;
import org.jruby.nb.compiler.impl.SkinnyMethodAdapter;
import org.jruby.nb.compiler.impl.StandardASMCompiler;
import org.jruby.nb.parser.StaticScope;
import org.jruby.nb.runtime.DynamicScope;
import org.jruby.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.util.CodegenUtils;
import org.objectweb.asm.Label;

public class StackBasedVariableCompiler
extends AbstractVariableCompiler {
    private int baseVariableIndex;

    public StackBasedVariableCompiler(StandardASMCompiler.AbstractMethodCompiler methodCompiler, SkinnyMethodAdapter method, StaticScope scope, boolean specificArity, int argsIndex, int firstTempIndex) {
        super(methodCompiler, method, scope, specificArity, argsIndex, firstTempIndex);
        this.baseVariableIndex = firstTempIndex;
    }

    @Override
    public void beginMethod(CompilerCallback argsCallback, StaticScope scope) {
        if (scope.getNumberOfVariables() > 0) {
            this.methodCompiler.loadNil();
            for (int i = 0; i < scope.getNumberOfVariables(); ++i) {
                this.assignLocalVariable(i);
            }
            this.method.pop();
            this.tempVariableIndex += scope.getNumberOfVariables();
        }
        if (argsCallback != null) {
            argsCallback.call(this.methodCompiler);
        }
    }

    @Override
    public void declareLocals(StaticScope scope, Label start, Label end) {
        String[] variables = scope.getVariables();
        for (int i = 0; i < variables.length; ++i) {
            this.method.visitLocalVariable(variables[i], CodegenUtils.ci(IRubyObject.class), null, start, end, this.baseVariableIndex + i);
        }
    }

    @Override
    public void beginClass(CompilerCallback bodyPrep, StaticScope scope) {
        throw new NotCompilableException("ERROR: stack-based variables should not be compiling class bodies");
    }

    @Override
    public void beginClosure(CompilerCallback argsCallback, StaticScope scope) {
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.invokeThreadContext("getCurrentScope", CodegenUtils.sig(DynamicScope.class, new Class[0]));
        this.method.astore(this.methodCompiler.getDynamicScopeIndex());
        if (scope != null) {
            this.methodCompiler.loadNil();
            for (int i = 0; i < scope.getNumberOfVariables(); ++i) {
                this.assignLocalVariable(i);
            }
            this.method.pop();
            this.tempVariableIndex += scope.getNumberOfVariables();
        }
        if (argsCallback != null) {
            this.method.aload(this.argsIndex);
            argsCallback.call(this.methodCompiler);
            this.method.pop();
        }
    }

    @Override
    public void assignLocalVariable(int index) {
        this.method.dup();
        this.method.astore(this.baseVariableIndex + index);
    }

    public void assignLocalVariable(int index, CompilerCallback value) {
        value.call(this.methodCompiler);
        this.assignLocalVariable(index);
    }

    @Override
    public void assignLocalVariable(int index, int depth) {
        if (depth == 0) {
            this.assignLocalVariable(index);
        } else {
            this.assignHeapLocal(depth, index);
        }
    }

    @Override
    public void assignLocalVariable(int index, int depth, CompilerCallback value) {
        if (depth == 0) {
            this.assignLocalVariable(index, value);
        } else {
            this.assignHeapLocal(value, depth, index);
        }
    }

    @Override
    public void retrieveLocalVariable(int index) {
        this.method.aload(this.baseVariableIndex + index);
    }

    @Override
    public void retrieveLocalVariable(int index, int depth) {
        if (depth == 0) {
            this.retrieveLocalVariable(index);
        } else {
            this.retrieveHeapLocal(depth, index);
        }
    }
}

