/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.ext.ffi;

import java.io.IOException;
import java.nio.channels.ByteChannel;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyModule;
import org.jruby.nb.ext.ffi.AbstractBuffer;
import org.jruby.nb.ext.ffi.AbstractMemory;
import org.jruby.nb.ext.ffi.AbstractMemoryPointer;
import org.jruby.nb.ext.ffi.FFIProvider;
import org.jruby.nb.ext.ffi.Invoker;
import org.jruby.nb.ext.ffi.NativeType;
import org.jruby.nb.ext.ffi.Platform;
import org.jruby.nb.ext.ffi.StructLayout;
import org.jruby.nb.ext.ffi.StructLayoutBuilder;
import org.jruby.nb.ext.ffi.io.FileDescriptorIO;
import org.jruby.nb.runtime.load.Library;

public abstract class Factory {
    protected Factory() {
    }

    public static final Factory getInstance() {
        return SingletonHolder.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(Ruby runtime, RubyModule module) {
        RubyModule rubyModule = module;
        synchronized (rubyModule) {
            if (module.fastGetClass("Provider") == null) {
                FFIProvider.createProviderClass(runtime);
            }
            if (module.fastGetClass("Invoker") == null) {
                Invoker.createInvokerClass(runtime);
            }
            if (module.fastGetClass("AbstractMemory") == null) {
                AbstractMemory.createAbstractMemoryClass(runtime);
            }
            if (module.fastGetClass("AbstractMemoryPointer") == null) {
                AbstractMemoryPointer.createMemoryPointerClass(runtime);
            }
            if (module.fastGetClass("AbstractBuffer") == null) {
                AbstractBuffer.createBufferClass(runtime);
            }
            if (module.fastGetClass("StructLayout") == null) {
                StructLayout.createStructLayoutClass(runtime);
            }
            if (module.fastGetClass("StructLayoutBuilder") == null) {
                StructLayoutBuilder.createStructLayoutBuilderClass(runtime);
            }
            if (module.fastGetClass("FileDescriptorIO") == null) {
                FileDescriptorIO.createFileDescriptorIOClass(runtime);
            }
            FFIProvider provider = this.newProvider(runtime);
            module.defineConstant("InvokerFactory", provider);
            module.defineConstant("LastError", provider);
            RubyModule nativeType = module.defineModuleUnder("NativeType");
            for (NativeType type : NativeType.values()) {
                nativeType.defineConstant(type.name(), runtime.newFixnum(type.ordinal()));
            }
            Platform.getPlatform().init(runtime, module);
        }
    }

    protected abstract FFIProvider newProvider(Ruby var1);

    public abstract <T> T loadLibrary(String var1, Class<T> var2);

    public abstract Platform getPlatform();

    public abstract ByteChannel newByteChannel(int var1);

    public static class Service
    implements Library {
        @Override
        public void load(Ruby runtime, boolean wrap) throws IOException {
            RubyModule ffi = runtime.defineModuleUnder("FFI", runtime.defineModule("JRuby"));
            Factory factory = Factory.getInstance();
            factory.init(runtime, ffi);
        }
    }

    private static final class SingletonHolder {
        private static final Factory INSTANCE = SingletonHolder.getInstance();

        private SingletonHolder() {
        }

        private static final Factory getInstance() {
            boolean useJNA = Boolean.getBoolean("ffi.usejna");
            String prefix = FFIProvider.class.getPackage().getName();
            Factory factory = null;
            if (!useJNA) {
                try {
                    factory = (Factory)Class.forName(prefix + ".jffi.JFFIFactory", true, Ruby.getClassLoader()).newInstance();
                }
                catch (Throwable ex) {
                    // empty catch block
                }
            }
            if (factory == null) {
                try {
                    factory = (Factory)Class.forName(prefix + ".jna.JNAFactory", true, Ruby.getClassLoader()).newInstance();
                }
                catch (Throwable ex) {
                    throw new RuntimeException("Could not load FFI provider", ex);
                }
            }
            return factory;
        }
    }
}

