/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.javasupport;

import java.lang.reflect.Array;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyClass;
import org.jruby.nb.RubyFixnum;
import org.jruby.nb.RubyInteger;
import org.jruby.nb.RubyModule;
import org.jruby.nb.anno.JRubyClass;
import org.jruby.nb.javasupport.JavaObject;
import org.jruby.nb.javasupport.JavaUtil;
import org.jruby.nb.runtime.ObjectAllocator;
import org.jruby.nb.runtime.builtin.IRubyObject;

@JRubyClass(name={"Java::JavaArray"}, parent="Java::JavaObject")
public class JavaArray
extends JavaObject {
    private JavaUtil.RubyConverter rubyConverter;

    public JavaArray(Ruby runtime, Object array) {
        super(runtime, runtime.getJavaSupport().getJavaArrayClass(), array);
        assert (array.getClass().isArray());
        this.rubyConverter = JavaUtil.getArrayConverter(array.getClass().getComponentType());
    }

    public static RubyClass createJavaArrayClass(Ruby runtime, RubyModule javaModule) {
        return javaModule.defineClassUnder("JavaArray", javaModule.fastGetClass("JavaObject"), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
    }

    public Class getComponentType() {
        return this.getValue().getClass().getComponentType();
    }

    public JavaUtil.RubyConverter getRubyConverter() {
        return this.rubyConverter;
    }

    @Override
    public RubyFixnum length() {
        return this.getRuntime().newFixnum(this.getLength());
    }

    private int getLength() {
        return Array.getLength(this.getValue());
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof JavaArray && this.getValue() == ((JavaArray)other).getValue();
    }

    @Override
    public IRubyObject aref(IRubyObject index) {
        if (!(index instanceof RubyInteger)) {
            throw this.getRuntime().newTypeError(index, this.getRuntime().getInteger());
        }
        int intIndex = (int)((RubyInteger)index).getLongValue();
        if (intIndex < 0 || intIndex >= this.getLength()) {
            throw this.getRuntime().newArgumentError("index out of bounds for java array (" + intIndex + " for length " + this.getLength() + ")");
        }
        Object result = Array.get(this.getValue(), intIndex);
        if (result == null) {
            return this.getRuntime().getNil();
        }
        return JavaObject.wrap(this.getRuntime(), result);
    }

    public IRubyObject at(int index) {
        Object result = Array.get(this.getValue(), index);
        if (result == null) {
            return this.getRuntime().getNil();
        }
        return JavaObject.wrap(this.getRuntime(), result);
    }

    @Override
    public IRubyObject aset(IRubyObject index, IRubyObject value) {
        if (!(index instanceof RubyInteger)) {
            throw this.getRuntime().newTypeError(index, this.getRuntime().getInteger());
        }
        int intIndex = (int)((RubyInteger)index).getLongValue();
        if (!(value instanceof JavaObject)) {
            throw this.getRuntime().newTypeError("not a java object:" + value);
        }
        Object javaObject = ((JavaObject)value).getValue();
        this.setWithExceptionHandling(intIndex, javaObject);
        return value;
    }

    public void setWithExceptionHandling(int intIndex, Object javaObject) {
        try {
            Array.set(this.getValue(), intIndex, javaObject);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.getRuntime().newArgumentError("index out of bounds for java array (" + intIndex + " for length " + this.getLength() + ")");
        }
        catch (ArrayStoreException e) {
            throw this.getRuntime().newArgumentError("wrong element type " + javaObject.getClass() + "(array is " + this.getValue().getClass() + ")");
        }
    }

    @Override
    public IRubyObject afill(IRubyObject beginIndex, IRubyObject endIndex, IRubyObject value) {
        if (!(beginIndex instanceof RubyInteger)) {
            throw this.getRuntime().newTypeError(beginIndex, this.getRuntime().getInteger());
        }
        int intIndex = (int)((RubyInteger)beginIndex).getLongValue();
        if (!(endIndex instanceof RubyInteger)) {
            throw this.getRuntime().newTypeError(endIndex, this.getRuntime().getInteger());
        }
        int intEndIndex = (int)((RubyInteger)endIndex).getLongValue();
        if (!(value instanceof JavaObject)) {
            throw this.getRuntime().newTypeError("not a java object:" + value);
        }
        Object javaObject = ((JavaObject)value).getValue();
        this.fillWithExceptionHandling(intIndex, intEndIndex, javaObject);
        return value;
    }

    public void fillWithExceptionHandling(int intIndex, int intEndIndex, Object javaObject) {
        try {
            while (intIndex < intEndIndex) {
                Array.set(this.getValue(), intIndex, javaObject);
                ++intIndex;
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw this.getRuntime().newArgumentError("index out of bounds for java array (" + intIndex + " for length " + this.getLength() + ")");
        }
        catch (ArrayStoreException e) {
            throw this.getRuntime().newArgumentError("wrong element type " + javaObject.getClass() + "(array is " + this.getValue().getClass() + ")");
        }
    }
}

