/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects.database;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverManager;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.ruby.railsprojects.RailsProject;
import org.netbeans.modules.ruby.railsprojects.database.JdbcInfo;
import org.netbeans.modules.ruby.railsprojects.database.RailsAdapters;
import org.netbeans.modules.ruby.railsprojects.database.RailsDatabaseConfiguration;
import org.netbeans.modules.ruby.railsprojects.ui.customizer.RailsProjectProperties;
import org.netbeans.modules.ruby.rubyproject.ProjectPropertyExtender;
import org.openide.LifecycleManager;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.EditableProperties;
import org.openide.util.Exceptions;

public class RailsJdbcConnection
extends RailsDatabaseConfiguration {
    private final DatabaseConnection development;
    private final DatabaseConnection test;
    private final DatabaseConnection production;

    public RailsJdbcConnection(DatabaseConnection development, DatabaseConnection test, DatabaseConnection production) {
        this.development = development;
        this.test = test;
        this.production = production;
    }

    @Override
    public String railsGenerationParam() {
        return null;
    }

    @Override
    public void editConfig(RailsProject project) {
        RailsJdbcConnection.insertActiveJdbcHook(project.getProjectDirectory());
        this.editDatabaseYml(project.getProjectDirectory());
        RailsJdbcConnection.bundleDrivers(project, this.getDriverClass(this.development), this.getDriverClass(this.test), this.getDriverClass(this.production));
    }

    @Override
    public String getDisplayName() {
        return null;
    }

    private String getDriverClass(DatabaseConnection connection) {
        return connection != null ? connection.getDriverClass() : null;
    }

    private static void insertActiveJdbcHook(FileObject dir) {
        FileObject fo = dir.getFileObject("config/environment.rb");
        if (fo != null) {
            try {
                DataObject dobj = DataObject.find((FileObject)fo);
                EditorCookie ec = (EditorCookie)dobj.getCookie(EditorCookie.class);
                if (ec != null) {
                    StyledDocument doc = ec.openDocument();
                    String text = doc.getText(0, doc.getLength());
                    int offset = text.indexOf("jdbc");
                    if (offset != -1) {
                        return;
                    }
                    offset = text.indexOf("Rails::Initializer.run do |config|");
                    if (offset != -1) {
                        String insert = "# Inserted by NetBeans Ruby support to support JRuby\nif defined?(JRUBY_VERSION)\n  require 'rubygems'\n  gem 'activerecord-jdbc-adapter'\n  require 'jdbc_adapter'\nend\n\n";
                        doc.insertString(offset, insert, null);
                        SaveCookie sc = (SaveCookie)dobj.getCookie(SaveCookie.class);
                        if (sc != null) {
                            sc.save();
                        } else {
                            LifecycleManager.getDefault().saveAll();
                        }
                    }
                }
            }
            catch (BadLocationException ble) {
                Exceptions.printStackTrace((Throwable)ble);
            }
            catch (DataObjectNotFoundException dnfe) {
                Exceptions.printStackTrace((Throwable)dnfe);
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void editDatabaseYml(FileObject projectDir) {
        FileObject fo = projectDir.getFileObject("config/database.yml");
        if (fo != null) {
            BaseDocument bdoc = null;
            try {
                DataObject dobj = DataObject.find((FileObject)fo);
                EditorCookie ec = (EditorCookie)dobj.getCookie(EditorCookie.class);
                if (ec != null) {
                    StyledDocument doc = ec.openDocument();
                    if (doc instanceof BaseDocument) {
                        bdoc = (BaseDocument)doc;
                        bdoc.atomicLock();
                    }
                    doc.remove(0, doc.getLength());
                    String insert = null;
                    insert = "# JDBC Setup\n# Adjust JDBC driver URLs as necessary.\ndevelopment:\n" + this.buildConnectionConf(this.development) + "\n" + "# Warning: The database defined as 'test' will be erased and\n" + "# re-generated from your development database when you run 'rake'.\n" + "# Do not set this db to the same as development or production.\n" + "test:\n" + this.buildConnectionConf(this.test) + "\n" + "production:\n" + this.buildConnectionConf(this.production);
                    doc.insertString(0, insert, null);
                    SaveCookie sc = (SaveCookie)dobj.getCookie(SaveCookie.class);
                    if (sc != null) {
                        sc.save();
                    } else {
                        LifecycleManager.getDefault().saveAll();
                    }
                }
            }
            catch (BadLocationException ble) {
                Exceptions.printStackTrace((Throwable)ble);
            }
            catch (DataObjectNotFoundException dnfe) {
                Exceptions.printStackTrace((Throwable)dnfe);
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
            }
            finally {
                if (bdoc != null) {
                    bdoc.atomicUnlock();
                }
            }
        }
    }

    private String buildConnectionConf(DatabaseConnection connection) {
        if (connection == null) {
            return "      host: localhost\n      adapter: jdbc\n";
        }
        String password = connection.getPassword() == null ? "" : connection.getPassword();
        return "      host: localhost\n      adapter: jdbc\n      driver: " + connection.getDriverClass() + "\n" + "      url: " + connection.getDatabaseURL() + "\n" + "      username: " + connection.getUser() + "\n" + "      password: " + password + "\n";
    }

    static void bundleDrivers(RailsProject project, String ... driverClasses) {
        ProjectPropertyExtender ppe = new ProjectPropertyExtender(project.evaluator(), project.getReferenceHelper(), project.getRakeProjectHelper(), RailsProjectProperties.WELL_KNOWN_PATHS, "${libs.", ".classpath}", "${reference.");
        HashSet<ProjectPropertyExtender.Item> items = new HashSet<ProjectPropertyExtender.Item>();
        for (String driverClass : driverClasses) {
            if (driverClass == null) continue;
            items.addAll(RailsJdbcConnection.getDriverItems(driverClass));
        }
        String[] fileRefs = ppe.encodeToStrings(items.iterator());
        EditableProperties projectProperties = project.getRakeProjectHelper().getProperties("nbproject/project.properties");
        projectProperties.setProperty("javac.classpath", fileRefs);
        project.getRakeProjectHelper().putProperties("nbproject/project.properties", projectProperties);
    }

    private static Set<ProjectPropertyExtender.Item> getDriverItems(String driverClass) {
        HashSet<ProjectPropertyExtender.Item> result = new HashSet<ProjectPropertyExtender.Item>();
        for (URL url : RailsJdbcConnection.getDriverURLs(driverClass)) {
            FileObject fo = URLMapper.findFileObject((URL)url);
            result.add(ProjectPropertyExtender.Item.create((File)FileUtil.toFile((FileObject)fo), null));
        }
        return result;
    }

    private static List<URL> getDriverURLs(String driverClass) {
        JDBCDriver[] drivers = JDBCDriverManager.getDefault().getDrivers(driverClass);
        ArrayList<URL> result = new ArrayList<URL>();
        for (JDBCDriver driver : drivers) {
            for (URL url : driver.getURLs()) {
                result.add(url);
            }
        }
        return result;
    }

    @Override
    public JdbcInfo getJdbcInfo() {
        return null;
    }

    @Override
    public String getDatabaseName(String projectName) {
        return projectName + "_development";
    }

    @Override
    public String getTestDatabaseName(String developmentDbName) {
        return RailsAdapters.getTestDatabaseName(developmentDbName);
    }

    @Override
    public String getProductionDatabaseName(String developmentDbName) {
        return RailsAdapters.getProductionDatabaseName(developmentDbName);
    }
}

