/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects.ui.customizer;

import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.nio.charset.Charset;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.api.ruby.platform.RubyPlatformManager;
import org.netbeans.modules.ruby.platform.PlatformComponentFactory;
import org.netbeans.modules.ruby.platform.RubyPlatformCustomizer;
import org.netbeans.modules.ruby.railsprojects.RailsProject;
import org.netbeans.modules.ruby.railsprojects.server.RailsServerUiUtils;
import org.netbeans.modules.ruby.railsprojects.server.ServerRegistry;
import org.netbeans.modules.ruby.railsprojects.server.spi.RubyInstance;
import org.netbeans.modules.ruby.railsprojects.ui.customizer.RailsProjectProperties;
import org.netbeans.modules.ruby.rubyproject.ui.customizer.CustomizerSupport;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class CustomizerRun
extends JPanel
implements HelpCtx.Provider {
    private final RailsProject project;
    private String originalEncoding;
    private boolean notified;
    private final JTextField[] configFields;
    private final String[] configPropsKeys;
    private final Map<String, Map<String, String>> configs;
    private final RailsProjectProperties uiProperties;
    private PlatformComponentFactory.PlatformChangeListener platformListener;
    private JComboBox configCombo;
    private JButton configDel;
    private JLabel configLabel;
    private JButton configNew;
    private JSeparator configSep;
    private JComboBox encoding;
    private JLabel encodingLabel;
    private JPanel mainPanel;
    private JButton manageButton;
    private JComboBox platforms;
    private JTextField portField;
    private JLabel portLabel;
    private JComboBox railsEnvCombo;
    private JLabel railsEnvLabel;
    private JLabel rakeHelpLabel;
    private JLabel rakeLabel;
    private JTextField rakeTextField;
    private JLabel rubyPlatformLabel;
    private JTextField serverArgsField;
    private JLabel serverArgsLabel;
    private JComboBox serverComboBox;
    private JLabel serverLabel;
    private JLabel urlHelpLabel;
    private JLabel urlLabel;
    private JTextField urlTextField;

    public CustomizerRun(RailsProjectProperties uiProperties) {
        this.uiProperties = uiProperties;
        this.initComponents();
        this.project = uiProperties.getRailsProject();
        this.configs = uiProperties.getRunConfigs();
        this.configFields = new JTextField[]{this.portField, this.urlTextField, this.rakeTextField, this.serverArgsField};
        JLabel[] configLabels = new JLabel[]{this.portLabel, this.urlLabel, this.rakeLabel, this.serverLabel};
        this.configPropsKeys = new String[]{"rails.port", "rails.url", "rake.args", "rails.serverargs"};
        assert (this.configFields.length == this.configPropsKeys.length);
        this.configChanged(uiProperties.getActiveConfig());
        this.configCombo.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                String label;
                String config = (String)value;
                if (config == null) {
                    label = null;
                } else if (config.length() > 0) {
                    Map m = (Map)CustomizerRun.this.configs.get(config);
                    String string = label = m != null ? (String)m.get("$label") : null;
                    if (label == null) {
                        label = config;
                    }
                } else {
                    label = NbBundle.getMessage(CustomizerRun.class, (String)"CustomizerRun.default");
                }
                return super.getListCellRendererComponent((JList<?>)list, label, index, isSelected, cellHasFocus);
            }
        });
        for (int i = 0; i < this.configFields.length; ++i) {
            final JTextField field = this.configFields[i];
            final String prop = this.configPropsKeys[i];
            final JLabel label = configLabels[i];
            field.getDocument().addDocumentListener(new DocumentListener(){
                Font basefont;
                Font boldfont;
                {
                    this.basefont = label.getFont();
                    this.boldfont = this.basefont.deriveFont(1);
                    this.updateFont();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.changed();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.changed();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                }

                void changed() {
                    String config = CustomizerRun.this.getSelectedConfig();
                    String v = field.getText();
                    if (v != null && config != null && v.equals(((Map)CustomizerRun.this.configs.get(null)).get(prop))) {
                        v = null;
                    }
                    ((Map)CustomizerRun.this.configs.get(config)).put(prop, v);
                    this.updateFont();
                }

                void updateFont() {
                    String v = field.getText();
                    String config = CustomizerRun.this.getSelectedConfig();
                    String def = (String)((Map)CustomizerRun.this.configs.get(null)).get(prop);
                    label.setFont(config != null && !Utilities.compareObjects((Object)(v != null ? v : ""), (Object)(def != null ? def : "")) ? this.boldfont : this.basefont);
                }
            });
        }
        this.originalEncoding = this.project.evaluator().getProperty("source.encoding");
        if (this.originalEncoding == null) {
            this.originalEncoding = Charset.defaultCharset().name();
        }
        this.encoding.setModel(ProjectCustomizer.encodingModel((String)this.originalEncoding));
        this.encoding.setRenderer(ProjectCustomizer.encodingRenderer());
        String lafid = UIManager.getLookAndFeel().getID();
        if (!"Aqua".equals(lafid)) {
            this.encoding.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
            this.encoding.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    JComboBox combo = (JComboBox)e.getSource();
                    combo.setPopupVisible(false);
                }
            });
        }
        this.encoding.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                CustomizerRun.this.handleEncodingChange();
            }
        });
        this.platforms.setSelectedItem(uiProperties.getPlatform());
        String serverId = this.project.evaluator().getProperty("rails.servertype");
        this.selectServer(serverId);
        this.serverComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomizerRun.this.handleServerChanged();
            }
        });
        this.initRailsEnvCombo();
    }

    private void handleRailsEnvChanged() {
        String env = (String)this.railsEnvCombo.getSelectedItem();
        this.uiProperties.setRailsEnvironment(env, this.getSelectedConfig());
    }

    private void handleServerChanged() {
        RubyInstance server = (RubyInstance)this.serverComboBox.getSelectedItem();
        if (server != null) {
            this.uiProperties.setServer(server, this.getSelectedConfig());
        }
    }

    private void initRailsEnvCombo() {
        ArrayList<String> environments = new ArrayList<String>();
        FileObject envFolder = this.project.getProjectDirectory().getFileObject("config/environments");
        if (envFolder != null) {
            for (FileObject each : envFolder.getChildren()) {
                if (each.isFolder() || !"rb".equals(each.getExt())) continue;
                environments.add(each.getName());
            }
        }
        Collections.sort(environments);
        this.railsEnvCombo.setModel(new DefaultComboBoxModel<String>(environments.toArray(new String[environments.size()])));
        String definedEnv = this.project.evaluator().getProperty("rails.env");
        this.selectRailsEnv(definedEnv);
        this.railsEnvCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomizerRun.this.handleRailsEnvChanged();
            }
        });
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.platformListener = new PlatformComponentFactory.PlatformChangeListener(){

            public void platformChanged() {
                RubyPlatform platform = (RubyPlatform)CustomizerRun.this.platforms.getSelectedItem();
                if (platform != null) {
                    CustomizerRun.this.uiProperties.setPlatform(platform);
                    ((Map)CustomizerRun.this.configs.get(CustomizerRun.this.getSelectedConfig())).put("platform.active", platform.getID());
                }
            }
        };
        PlatformComponentFactory.addPlatformChangeListener((JComboBox)this.platforms, (PlatformComponentFactory.PlatformChangeListener)this.platformListener);
    }

    @Override
    public void removeNotify() {
        PlatformComponentFactory.removePlatformChangeListener((JComboBox)this.platforms, (PlatformComponentFactory.PlatformChangeListener)this.platformListener);
        super.removeNotify();
    }

    private void handleEncodingChange() {
        Charset enc = (Charset)this.encoding.getSelectedItem();
        String encName = enc != null ? enc.name() : this.originalEncoding;
        if (!this.notified && encName != null && !encName.equals(this.originalEncoding)) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(CustomizerRun.class, (String)"MSG_EncodingWarning"), 2));
            this.notified = true;
        }
        this.uiProperties.putAdditionalProperty("source.encoding", encName);
    }

    private String getSelectedConfig() {
        String config = (String)this.configCombo.getSelectedItem();
        if (config.length() == 0) {
            config = null;
        }
        return config;
    }

    private void selectServer(String serverId) {
        RubyPlatform platform = this.uiProperties.getPlatform();
        if (platform == null) {
            return;
        }
        RubyInstance server = ServerRegistry.getDefault().getServer(serverId, platform);
        if (server != null) {
            this.serverComboBox.setSelectedItem(server);
        }
    }

    private void selectRailsEnv(String definedEnv) {
        if (definedEnv != null && !"".equals(definedEnv.trim())) {
            this.railsEnvCombo.setSelectedItem(definedEnv);
        } else {
            this.railsEnvCombo.setSelectedIndex(-1);
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(CustomizerRun.class);
    }

    private void initComponents() {
        this.configSep = new JSeparator();
        this.configLabel = new JLabel();
        this.configCombo = new JComboBox();
        this.configNew = new JButton();
        this.configDel = new JButton();
        this.rubyPlatformLabel = new JLabel();
        this.platforms = PlatformComponentFactory.getRubyPlatformsComboxBox();
        this.manageButton = new JButton();
        this.mainPanel = new JPanel();
        this.portLabel = new JLabel();
        this.portField = new JTextField();
        this.serverComboBox = RailsServerUiUtils.getServerComboBox(this.getPlatform());
        this.serverLabel = new JLabel();
        this.railsEnvCombo = new JComboBox();
        this.railsEnvLabel = new JLabel();
        this.urlLabel = new JLabel();
        this.urlTextField = new JTextField();
        this.urlHelpLabel = new JLabel();
        this.serverArgsLabel = new JLabel();
        this.serverArgsField = new JTextField();
        this.encoding = new JComboBox();
        this.encodingLabel = new JLabel();
        this.rakeLabel = new JLabel();
        this.rakeTextField = new JTextField();
        this.rakeHelpLabel = new JLabel();
        this.configLabel.setLabelFor(this.configCombo);
        Mnemonics.setLocalizedText((JLabel)this.configLabel, (String)NbBundle.getMessage(CustomizerRun.class, (String)"CustomizerRun.configLabel"));
        this.configCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"<default>"}));
        this.configCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerRun.this.configComboActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.configNew, (String)NbBundle.getMessage(CustomizerRun.class, (String)"CustomizerRun.configNew"));
        this.configNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerRun.this.configNewActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.configDel, (String)NbBundle.getMessage(CustomizerRun.class, (String)"CustomizerRun.configDelete"));
        this.configDel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerRun.this.configDelActionPerformed(evt);
            }
        });
        this.rubyPlatformLabel.setLabelFor(this.platforms);
        Mnemonics.setLocalizedText((JLabel)this.rubyPlatformLabel, (String)NbBundle.getMessage(CustomizerRun.class, (String)"RubyPlatformLabel"));
        this.platforms.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerRun.this.platformsActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.manageButton, (String)NbBundle.getMessage(CustomizerRun.class, (String)"RubyHomeBrowse"));
        this.manageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerRun.this.manageButtonActionPerformed(evt);
            }
        });
        this.portLabel.setLabelFor(this.portField);
        Mnemonics.setLocalizedText((JLabel)this.portLabel, (String)NbBundle.getMessage(CustomizerRun.class, (String)"LBL_CustomizeRun_Run_Args_JLabel"));
        this.portField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerRun.this.portFieldActionPerformed(evt);
            }
        });
        this.serverLabel.setLabelFor(this.serverComboBox);
        Mnemonics.setLocalizedText((JLabel)this.serverLabel, (String)NbBundle.getMessage(CustomizerRun.class, (String)"ServerLabel"));
        this.railsEnvCombo.setEditable(true);
        Mnemonics.setLocalizedText((JLabel)this.railsEnvLabel, (String)NbBundle.getMessage(CustomizerRun.class, (String)"RailsEnv"));
        Mnemonics.setLocalizedText((JLabel)this.urlLabel, (String)"UR&L:");
        this.urlTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerRun.this.urlTextFieldActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.urlHelpLabel, (String)NbBundle.getMessage(CustomizerRun.class, (String)"LBL_CustomizeRun_URL_Help"));
        this.serverArgsLabel.setLabelFor(this.serverArgsField);
        Mnemonics.setLocalizedText((JLabel)this.serverArgsLabel, (String)NbBundle.getMessage(CustomizerRun.class, (String)"ServerArguments"));
        this.encodingLabel.setLabelFor(this.encoding);
        Mnemonics.setLocalizedText((JLabel)this.encodingLabel, (String)NbBundle.getMessage(CustomizerRun.class, (String)"TXT_Encoding"));
        this.rakeLabel.setLabelFor(this.rakeTextField);
        Mnemonics.setLocalizedText((JLabel)this.rakeLabel, (String)NbBundle.getMessage(CustomizerRun.class, (String)"RakeArgs"));
        Mnemonics.setLocalizedText((JLabel)this.rakeHelpLabel, (String)NbBundle.getMessage(CustomizerRun.class, (String)"RakeArgsEx"));
        GroupLayout mainPanelLayout = new GroupLayout((Container)this.mainPanel);
        this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
        mainPanelLayout.setHorizontalGroup((GroupLayout.Group)mainPanelLayout.createParallelGroup(1).add((GroupLayout.Group)mainPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)mainPanelLayout.createParallelGroup(1).add((GroupLayout.Group)mainPanelLayout.createSequentialGroup().add((GroupLayout.Group)mainPanelLayout.createParallelGroup(1).add((GroupLayout.Group)mainPanelLayout.createParallelGroup(1, false).add((Component)this.serverLabel, -1, -1, Short.MAX_VALUE).add((Component)this.portLabel)).add((Component)this.railsEnvLabel).add((Component)this.urlLabel).add((Component)this.serverArgsLabel)).addPreferredGap(0)).add((GroupLayout.Group)mainPanelLayout.createSequentialGroup().add((Component)this.rakeLabel).addPreferredGap(0)).add((GroupLayout.Group)mainPanelLayout.createSequentialGroup().add((Component)this.encodingLabel, -1, 152, Short.MAX_VALUE).addPreferredGap(0))).add((GroupLayout.Group)mainPanelLayout.createParallelGroup(1).add((GroupLayout.Group)mainPanelLayout.createSequentialGroup().add((Component)this.rakeHelpLabel).addPreferredGap(0, 408, Short.MAX_VALUE)).add((Component)this.rakeTextField, -1, 512, Short.MAX_VALUE).add(2, (Component)this.encoding, 0, 512, Short.MAX_VALUE).add((Component)this.urlHelpLabel).add((Component)this.railsEnvCombo, 0, 512, Short.MAX_VALUE).add((Component)this.portField, -1, 512, Short.MAX_VALUE).add((Component)this.urlTextField, -1, 512, Short.MAX_VALUE).add((Component)this.serverComboBox, 0, 512, Short.MAX_VALUE).add(2, (Component)this.serverArgsField, -1, 512, Short.MAX_VALUE)).addContainerGap()));
        mainPanelLayout.setVerticalGroup((GroupLayout.Group)mainPanelLayout.createParallelGroup(1).add((GroupLayout.Group)mainPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add((GroupLayout.Group)mainPanelLayout.createParallelGroup(3).add((Component)this.serverLabel).add((Component)this.serverComboBox, -2, 22, -2)).addPreferredGap(0).add((GroupLayout.Group)mainPanelLayout.createParallelGroup(3).add((Component)this.portLabel).add((Component)this.portField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)mainPanelLayout.createParallelGroup(3).add((Component)this.railsEnvCombo, -2, -1, -2).add((Component)this.railsEnvLabel)).addPreferredGap(0).add((GroupLayout.Group)mainPanelLayout.createParallelGroup(1).add((Component)this.urlLabel).add((Component)this.urlTextField, -2, -1, -2)).addPreferredGap(0).add((Component)this.urlHelpLabel).addPreferredGap(0).add((GroupLayout.Group)mainPanelLayout.createParallelGroup(3).add((Component)this.serverArgsLabel).add((Component)this.serverArgsField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)mainPanelLayout.createParallelGroup(3).add((Component)this.encoding, -2, -1, -2).add((Component)this.encodingLabel)).addPreferredGap(0).add((GroupLayout.Group)mainPanelLayout.createParallelGroup(3).add((Component)this.rakeTextField, -2, -1, -2).add((Component)this.rakeLabel)).addPreferredGap(0).add((Component)this.rakeHelpLabel)));
        this.portLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerRun.class, (String)"AD_ServerPort"));
        this.portField.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(CustomizerRun.class).getString("AD_ServerPort"));
        this.serverComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerRun.class, (String)"AD_ServerEnvironment"));
        this.railsEnvCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerRun.class, (String)"AD_RailsEnv"));
        this.railsEnvLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerRun.class, (String)"AD_RailsEnv"));
        this.serverArgsLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerRun.class, (String)"AD_ServerArguments"));
        this.serverArgsLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerRun.class, (String)"AD_ServerArguments"));
        this.encoding.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerRun.class, (String)"AD_Encoding"));
        this.rakeTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerRun.class, (String)"AD_RakeArguments"));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.configSep, -1, 700, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.mainPanel, -1, -1, Short.MAX_VALUE).addContainerGap()).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.configLabel).add((Component)this.rubyPlatformLabel)).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)this.configCombo, 0, -1, Short.MAX_VALUE).add((Component)this.platforms, -2, 374, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.configNew).addPreferredGap(0).add((Component)this.configDel)).add((Component)this.manageButton)).addContainerGap(19, Short.MAX_VALUE)));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.platforms, -2, -1, -2).add((Component)this.manageButton).add((Component)this.rubyPlatformLabel)).add(7, 7, 7).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.configCombo, -2, -1, -2).add((Component)this.configNew).add((Component)this.configDel).add((Component)this.configLabel)).add(14, 14, 14).add((Component)this.configSep, -2, -1, -2).addPreferredGap(0).add((Component)this.mainPanel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.configCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerRun.class, (String)"AD_Configuration"));
        this.configNew.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerRun.class, (String)"AD_NewConfiguration"));
        this.platforms.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerRun.class, (String)"AD_RubyPlatformLabel"));
        this.manageButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerRun.class, (String)"AD_RubyHomeBrowse"));
    }

    private void portFieldActionPerformed(ActionEvent evt) {
    }

    private void configDelActionPerformed(ActionEvent evt) {
        String config = this.getSelectedConfig();
        assert (config != null);
        this.configs.put(config, null);
        this.configChanged(null);
        this.uiProperties.setActiveConfig(null);
    }

    private void configNewActionPerformed(ActionEvent evt) {
        String config = CustomizerSupport.askForNewConfiguration(this.configs);
        this.configChanged(config);
        this.uiProperties.setActiveConfig(config);
    }

    private void configComboActionPerformed(ActionEvent evt) {
        String config = this.getSelectedConfig();
        this.configChanged(config);
        this.uiProperties.setActiveConfig(config);
    }

    private void manageButtonActionPerformed(ActionEvent evt) {
        RubyPlatformCustomizer.manage((JComboBox)this.platforms);
    }

    private void platformsActionPerformed(ActionEvent evt) {
        this.initServerComboBox();
    }

    private void urlTextFieldActionPerformed(ActionEvent evt) {
    }

    private void initServerComboBox() {
        if (this.getPlatform() == null) {
            this.serverComboBox.setModel(new DefaultComboBoxModel());
        } else {
            this.serverComboBox.setModel(new RailsServerUiUtils.ServerListModel(this.getPlatform()));
            String serverID = this.configs.get(this.getSelectedConfig()).get("rails.servertype");
            if (serverID != null) {
                this.selectServer(serverID);
            }
        }
    }

    private RubyPlatform getPlatform() {
        return PlatformComponentFactory.getPlatform((JComboBox)this.platforms);
    }

    private void configChanged(String activeConfig) {
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        model.addElement("");
        TreeSet<String> alphaConfigs = new TreeSet<String>(new Comparator<String>(){
            Collator coll = Collator.getInstance();

            @Override
            public int compare(String s1, String s2) {
                return this.coll.compare(this.label(s1), this.label(s2));
            }

            private String label(String c) {
                Map m = (Map)CustomizerRun.this.configs.get(c);
                String label = (String)m.get("$label");
                return label != null ? label : c;
            }
        });
        for (Map.Entry<String, Map<String, String>> entry : this.configs.entrySet()) {
            String config = entry.getKey();
            if (config == null || entry.getValue() == null) continue;
            alphaConfigs.add(config);
        }
        for (String c : alphaConfigs) {
            model.addElement(c);
        }
        this.configCombo.setModel(model);
        this.configCombo.setSelectedItem(activeConfig != null ? activeConfig : "");
        Map<String, String> active = this.configs.get(activeConfig);
        Map<String, String> def = this.configs.get(null);
        if (active != null) {
            for (int i = 0; i < this.configFields.length; ++i) {
                String v = active.get(this.configPropsKeys[i]);
                if (v == null) {
                    v = def.get(this.configPropsKeys[i]);
                }
                this.configFields[i].setText(v);
            }
            String activePlatformID = active.get("platform.active");
            if (activePlatformID == null) {
                activePlatformID = def.get("platform.active");
            }
            this.platforms.setSelectedItem(RubyPlatformManager.getPlatformByID((String)activePlatformID));
            String serverID = active.get("rails.servertype");
            if (serverID == null) {
                serverID = def.get("rails.servertype");
            }
            this.selectServer(serverID);
            String environment = active.get("rails.env");
            if (environment == null) {
                environment = def.get("rails.env");
            }
            this.selectRailsEnv(environment);
        }
        this.configDel.setEnabled(activeConfig != null);
    }
}

