/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects.ui.wizards;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.railsprojects.RailsProjectCreateData;
import org.netbeans.modules.ruby.railsprojects.RailsProjectGenerator;
import org.netbeans.modules.ruby.railsprojects.database.RailsAdapterFactory;
import org.netbeans.modules.ruby.railsprojects.database.RailsDatabaseConfiguration;
import org.netbeans.modules.ruby.railsprojects.server.spi.RubyInstance;
import org.netbeans.modules.ruby.railsprojects.ui.wizards.DatabaseConfigPanel;
import org.netbeans.modules.ruby.railsprojects.ui.wizards.PanelConfigureProject;
import org.netbeans.modules.ruby.railsprojects.ui.wizards.RailsInstallationPanel;
import org.netbeans.modules.ruby.rubyproject.rake.RakeSupport;
import org.netbeans.modules.ruby.spi.project.support.rake.RakeProjectHelper;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;

public class NewRailsProjectWizardIterator
implements WizardDescriptor.ProgressInstantiatingIterator {
    static final String JDBC_WN = "useJdbc";
    static final String RAILS_DB_WN = "railsDatabase";
    static final String RAILS_DEVELOPMENT_DB = "railsDatabase.development";
    static final String RAILS_PRODUCTION_DB = "railsDatabase.production";
    static final String RAILS_TEST_DB = "railsDatabase.test";
    static final String WAR_SUPPORT = "warSupport";
    public static final String SERVER_INSTANCE = "serverInstance";
    public static final String PLATFORM = "platform";
    static final String RAILS_VERSION = "rails.version";
    static final String RAILS_OPTIONS = "rails.options";
    static final int TYPE_APP = 0;
    static final int TYPE_EXT = 2;
    static final String PROP_NAME_INDEX = "nameIndex";
    private static final long serialVersionUID = 1L;
    private int type;
    private transient int index;
    private transient WizardDescriptor.Panel[] panels;
    private transient WizardDescriptor wiz;

    public NewRailsProjectWizardIterator() {
        this(0);
    }

    public NewRailsProjectWizardIterator(int type) {
        this.type = type;
    }

    public static NewRailsProjectWizardIterator existing() {
        return new NewRailsProjectWizardIterator(2);
    }

    private WizardDescriptor.Panel[] createPanels() {
        if (this.type == 0) {
            return new WizardDescriptor.Panel[]{new PanelConfigureProject(this.type), new DatabaseConfigPanel(), new RailsInstallationPanel.Panel()};
        }
        return new WizardDescriptor.Panel[]{new PanelConfigureProject(this.type)};
    }

    private String[] createSteps() {
        String config = NbBundle.getMessage(NewRailsProjectWizardIterator.class, (String)"LAB_ConfigureProject");
        String database = NbBundle.getMessage(NewRailsProjectWizardIterator.class, (String)"LAB_ConfigureDatabase");
        String rails = NbBundle.getMessage(NewRailsProjectWizardIterator.class, (String)"LAB_InstallRails");
        if (this.type == 0) {
            return new String[]{config, database, rails};
        }
        return new String[]{config};
    }

    public Set instantiate() throws IOException {
        assert (false) : "Cannot call this method if implements WizardDescriptor.ProgressInstantiatingIterator.";
        return null;
    }

    public Set instantiate(ProgressHandle handle) throws IOException {
        FileObject fo;
        handle.start(4);
        HashSet<FileObject> resultSet = new HashSet<FileObject>();
        File dirF = (File)this.wiz.getProperty("projdir");
        if (dirF != null) {
            dirF = FileUtil.normalizeFile((File)dirF);
        }
        String name = (String)this.wiz.getProperty("name");
        handle.progress(NbBundle.getMessage(NewRailsProjectWizardIterator.class, (String)"LBL_NewRailsProjectWizardIterator_WizardProgress_CreatingProject"), 1);
        RakeProjectHelper h = null;
        Boolean deploy = (Boolean)this.wiz.getProperty(WAR_SUPPORT);
        RubyInstance server = (RubyInstance)this.wiz.getProperty(SERVER_INSTANCE);
        RubyPlatform platform = (RubyPlatform)this.wiz.getProperty(PLATFORM);
        RailsDatabaseConfiguration databaseConf = (RailsDatabaseConfiguration)this.wiz.getProperty(RAILS_DEVELOPMENT_DB);
        if (databaseConf == null) {
            databaseConf = RailsAdapterFactory.getDefaultAdapter(platform);
        }
        String railsVersion = (String)this.wiz.getProperty(RAILS_VERSION);
        String railsOptions = (String)this.wiz.getProperty(RAILS_OPTIONS);
        RailsProjectCreateData data = new RailsProjectCreateData(platform, dirF, name, this.type == 0, databaseConf, deploy, server.getServerUri(), railsVersion, railsOptions);
        h = RailsProjectGenerator.createProject(data);
        handle.progress(2);
        FileObject dir = FileUtil.toFileObject((File)dirF);
        handle.progress(3);
        resultSet.add(dir);
        handle.progress(NbBundle.getMessage(NewRailsProjectWizardIterator.class, (String)"LBL_NewRailsProjectWizardIterator_WizardProgress_PreparingToOpen"), 4);
        File file = dirF = dirF != null ? dirF.getParentFile() : null;
        if (dirF != null && dirF.exists()) {
            ProjectChooser.setProjectsFolder((File)dirF);
            if (deploy.booleanValue()) {
                RakeSupport.refreshTasks((Project)FileOwnerQuery.getOwner((FileObject)dir));
            }
        }
        if (this.type == 0 && (fo = dir.getFileObject("config/database.yml")) != null) {
            try {
                DataObject dobj = DataObject.find((FileObject)fo);
                EditorCookie cookie = (EditorCookie)dobj.getCookie(EditorCookie.class);
                if (cookie != null) {
                    cookie.open();
                }
            }
            catch (DataObjectNotFoundException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
        }
        return resultSet;
    }

    public void initialize(WizardDescriptor wiz) {
        this.wiz = wiz;
        this.index = 0;
        this.panels = this.createPanels();
        String[] steps = this.createSteps();
        for (int i = 0; i < this.panels.length; ++i) {
            Component c = this.panels[i].getComponent();
            if (steps[i] == null) {
                steps[i] = c.getName();
            }
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
            jc.putClientProperty("WizardPanel_contentData", steps);
        }
        this.wiz.putProperty("sourceRoot", (Object)new File[0]);
        this.wiz.putProperty("testRoot", (Object)new File[0]);
    }

    public void uninitialize(WizardDescriptor wiz) {
        if (this.wiz != null) {
            this.wiz.putProperty("projdir", null);
            this.wiz.putProperty("name", null);
            this.wiz.putProperty("mainClass", null);
            this.wiz.putProperty(PLATFORM, null);
            this.wiz = null;
            this.panels = null;
        }
    }

    public String name() {
        return MessageFormat.format(NbBundle.getMessage(NewRailsProjectWizardIterator.class, (String)"LAB_IteratorName"), new Integer(this.index + 1), new Integer(this.panels.length));
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public final void addChangeListener(ChangeListener l) {
    }

    public final void removeChangeListener(ChangeListener l) {
    }

    static String getPackageName(String displayName) {
        StringBuffer builder = new StringBuffer();
        boolean firstLetter = true;
        for (int i = 0; i < displayName.length(); ++i) {
            char c = displayName.charAt(i);
            if ((firstLetter || !Character.isJavaIdentifierPart(c)) && (!firstLetter || !Character.isJavaIdentifierStart(c))) continue;
            firstLetter = false;
            if (Character.isUpperCase(c)) {
                c = Character.toLowerCase(c);
            }
            builder.append(c);
        }
        return builder.length() == 0 ? NbBundle.getMessage(NewRailsProjectWizardIterator.class, (String)"TXT_DefaultPackageName") : builder.toString();
    }
}

