/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui;

import java.awt.EventQueue;
import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.project.Project;
import org.netbeans.modules.mobility.project.J2MEProject;
import org.netbeans.modules.mobility.project.ProjectConfigurationsHelper;
import org.netbeans.modules.mobility.project.ui.ConfigurationsChildren;
import org.netbeans.modules.mobility.project.ui.DecoratedNode;
import org.netbeans.modules.mobility.project.ui.OneConfigurationNode;
import org.netbeans.modules.mobility.project.ui.actions.AddConfigurationAction;
import org.netbeans.modules.mobility.project.ui.actions.SelectConfigurationAction;
import org.netbeans.modules.mobility.project.ui.customizer.CloneConfigurationPanel;
import org.netbeans.modules.mobility.project.ui.customizer.J2MEProjectProperties;
import org.netbeans.modules.mobility.project.ui.customizer.VisualConfigSupport;
import org.netbeans.spi.project.ProjectConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.actions.PasteAction;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeTransfer;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.lookup.Lookups;

final class ConfigurationsNode
extends DecoratedNode
implements PropertyChangeListener,
AntProjectListener {
    private final ConfigurationsChildren kids;
    private final Map<J2MEProject, HashSet<Node>> map = new HashMap<J2MEProject, HashSet<Node>>();
    private PasteType pType;

    ConfigurationsNode(J2MEProject project) {
        this(project, new ConfigurationsChildren(project));
    }

    private ConfigurationsNode(J2MEProject project, ConfigurationsChildren kids) {
        super(Children.create((ChildFactory)kids, (boolean)true), Lookups.singleton((Object)project));
        this.kids = kids;
        this.setDisplayName(NbBundle.getMessage(ConfigurationsNode.class, (String)"LBL_ProjectConfigurations"));
        this.setIconBaseWithExtension("org/netbeans/modules/mobility/project/ui/resources/configs.gif");
        ProjectConfigurationsHelper configHelper = project.getConfigurationHelper();
        configHelper.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)configHelper));
        AntProjectHelper helper = (AntProjectHelper)project.getLookup().lookup(AntProjectHelper.class);
        helper.addAntProjectListener((AntProjectListener)WeakListeners.create(AntProjectListener.class, (EventListener)this, (Object)helper));
        JavaPlatformManager platformMgr = JavaPlatformManager.getDefault();
        platformMgr.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)platformMgr));
        this.checkBroken();
    }

    public Action[] getActions(boolean ignored) {
        if (((Project)this.getLookup().lookup(Project.class)).getProjectDirectory().isValid()) {
            return new Action[]{AddConfigurationAction.getStaticInstance(), null, SelectConfigurationAction.getStaticInstance(), null, SystemAction.get(PasteAction.class)};
        }
        return new Action[0];
    }

    public void configurationXmlChanged(AntProjectEvent ev) {
        this.checkBroken();
    }

    public void propertiesChanged(AntProjectEvent ev) {
        this.checkBroken();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof ProjectConfigurationsHelper && "configurations".equals(evt.getPropertyName()) && this.isAlive()) {
            this.kids.update();
        }
        this.checkBroken();
    }

    @Override
    protected boolean isBroken() {
        J2MEProject project = (J2MEProject)this.getLookup().lookup(J2MEProject.class);
        return project.hasBrokenLinks();
    }

    @Override
    public Image getOpenedIcon(int type) {
        return this.getIcon(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PasteType getPasteType(Transferable tr, DataFlavor[] flavors) {
        String PRIMARY_TYPE = "application";
        String DND_TYPE = "x-java-openide-nodednd";
        String MULTI_TYPE = "x-java-openide-multinode";
        ConfigurationsNode configurationsNode = this;
        synchronized (configurationsNode) {
            if (this.pType == null) {
                class CfgPasteType
                extends PasteType {
                    CfgPasteType() {
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Transferable paste() throws IOException {
                        final J2MEProject targetProject = (J2MEProject)ConfigurationsNode.this.getLookup().lookup(J2MEProject.class);
                        if (targetProject == null) {
                            return null;
                        }
                        final J2MEProjectProperties targetProperties = new J2MEProjectProperties(targetProject, (AntProjectHelper)targetProject.getLookup().lookup(AntProjectHelper.class), (ReferenceHelper)targetProject.getLookup().lookup(ReferenceHelper.class), targetProject.getConfigurationHelper());
                        ArrayList<ProjectConfiguration> allNames = new ArrayList<ProjectConfiguration>(Arrays.asList(targetProperties.getConfigurations()));
                        int size = allNames.size();
                        ProjectConfiguration oldCfg = null;
                        ProjectConfiguration newCfg = null;
                        for (J2MEProject srcProject : ConfigurationsNode.this.map.keySet()) {
                            HashSet set = (HashSet)ConfigurationsNode.this.map.get(srcProject);
                            ArrayList<String> allStrNames = new ArrayList<String>(allNames.size() + set.size());
                            J2MEProjectProperties j2meProperties = new J2MEProjectProperties(srcProject, (AntProjectHelper)srcProject.getLookup().lookup(AntProjectHelper.class), (ReferenceHelper)srcProject.getLookup().lookup(ReferenceHelper.class), srcProject.getConfigurationHelper());
                            for (ProjectConfiguration name : allNames) {
                                allStrNames.add(name.getDisplayName());
                            }
                            for (Node node : set) {
                                newCfg = oldCfg = (ProjectConfiguration)node.getLookup().lookup(ProjectConfiguration.class);
                                boolean usingDefaultLibs = srcProject.isUsingDefaultLibs(newCfg);
                                ProjectConfiguration exst = targetProject.getConfigurationHelper().getConfigurationByName(oldCfg.getDisplayName());
                                if (exst != null) {
                                    CloneConfigurationPanel ccp = new CloneConfigurationPanel(allStrNames);
                                    DialogDescriptor dd = new DialogDescriptor((Object)ccp, NbBundle.getMessage(VisualConfigSupport.class, (String)"LBL_VCS_DuplConfiguration", (Object)oldCfg.getDisplayName()), true, 2, NotifyDescriptor.OK_OPTION, null);
                                    ccp.setDialogDescriptor(dd);
                                    String newName = NotifyDescriptor.OK_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)dd)) ? ccp.getName() : null;
                                    if (newName == null) continue;
                                    newCfg = new PrototypeConfiguration(newName);
                                    allStrNames.add(newName);
                                }
                                String[] keys = j2meProperties.keySet().toArray(new String[j2meProperties.size()]);
                                String prefix = "configs." + oldCfg.getDisplayName();
                                for (int i = 0; i < keys.length; ++i) {
                                    if (!keys[i].startsWith(prefix)) continue;
                                    targetProperties.put("configs." + newCfg.getDisplayName() + keys[i].substring(prefix.length()), j2meProperties.get(keys[i]));
                                }
                                if (usingDefaultLibs) {
                                    targetProperties.put("configs." + newCfg.getDisplayName() + ".libs.classpath", j2meProperties.get("libs.classpath"));
                                    targetProperties.put("configs." + newCfg.getDisplayName() + ".extra.classpath", j2meProperties.get("extra.classpath"));
                                }
                                allNames.add(newCfg);
                            }
                        }
                        ConfigurationsNode.this.map.clear();
                        Object i$ = this;
                        synchronized (i$) {
                            ConfigurationsNode.this.pType = null;
                        }
                        if (allNames.size() == size) {
                            return null;
                        }
                        targetProperties.setConfigurations(allNames.toArray(new ProjectConfiguration[allNames.size()]));
                        final ProjectConfiguration lcfg = newCfg;
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                assert (lcfg != null);
                                try {
                                    Children.MUTEX.writeAccess(new Runnable(){

                                        @Override
                                        public void run() {
                                            targetProperties.store();
                                        }
                                    });
                                    targetProject.getConfigurationHelper().setActiveConfiguration(lcfg);
                                }
                                catch (IllegalArgumentException ex) {
                                    Exceptions.printStackTrace((Throwable)ex);
                                }
                                catch (IOException ex) {
                                    Exceptions.printStackTrace((Throwable)ex);
                                }
                            }
                        });
                        return null;
                    }
                }
                this.pType = new CfgPasteType();
            }
        }
        for (DataFlavor flavor : flavors) {
            J2MEProject project;
            if (!"application".equals(flavor.getPrimaryType())) continue;
            if ("x-java-openide-multinode".equals(flavor.getSubType())) {
                Node[] nodes = NodeTransfer.nodes((Transferable)tr, (int)3);
                if (nodes == null) {
                    return null;
                }
                for (Node node : nodes) {
                    J2MEProject project2;
                    if (!(node instanceof OneConfigurationNode) || (project2 = (J2MEProject)node.getLookup().lookup(J2MEProject.class)) == null) continue;
                    HashSet<Object> set = this.map.get(project2);
                    if (set == null) {
                        set = new HashSet();
                        this.map.put(project2, set);
                    }
                    set.add(node);
                }
                if (this.map.size() != 0) {
                    return this.pType;
                }
            }
            if (!"x-java-openide-nodednd".equals(flavor.getSubType())) continue;
            Node node = NodeTransfer.node((Transferable)tr, (int)3);
            if (node instanceof OneConfigurationNode && (project = (J2MEProject)node.getLookup().lookup(J2MEProject.class)) != null) {
                HashSet<Object> set = this.map.get(project);
                if (set == null) {
                    set = new HashSet();
                    this.map.put(project, set);
                }
                set.add(node);
            }
            if (this.map.size() == 0) continue;
            return this.pType;
        }
        return null;
    }

    public PasteType getDropType(Transferable tr, int action, int index) {
        DataFlavor[] fr = tr.getTransferDataFlavors();
        PasteType type = this.getPasteType(tr, fr);
        return type;
    }

    protected void createPasteTypes(Transferable t, List<PasteType> s) {
        PasteType pt = this.getDropType(t, 0, 0);
        if (pt != null) {
            s.add(pt);
        }
    }

    private static class PrototypeConfiguration
    implements ProjectConfiguration {
        private final String name;

        PrototypeConfiguration(String name) {
            this.name = name;
        }

        public String getDisplayName() {
            return this.name;
        }
    }
}

