/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.apduio;

import com.sun.javacard.apduio.Apdu;
import com.sun.javacard.apduio.CadT0Client;
import com.sun.javacard.apduio.ClientProtocol;
import com.sun.javacard.apduio.TLP224Exception;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class ClientT0Protocol
extends ClientProtocol {
    private Apdu getResponseApdu;
    private static final int MAX_APDU_SIZE = 224;
    private static final int maxOutputExt = Short.MAX_VALUE;
    private static final int maxOutput = 256;
    private static final byte ENVELOPE_INS = -62;
    private byte[] dataOut = new byte[Short.MAX_VALUE];
    protected boolean auto61xx;

    public ClientT0Protocol(CadT0Client cadT0Client) {
        this.cad = cadT0Client;
        this.getResponseApdu = new Apdu();
        this.auto61xx = true;
    }

    public void setAuto61xx(boolean bl) {
        this.auto61xx = bl;
    }

    public boolean getAuto61xx() {
        return this.auto61xx;
    }

    @Override
    public void exchangeApdu(Apdu apdu) throws IOException, TLP224Exception {
        int[] nArray = new int[2];
        CadT0Client cadT0Client = (CadT0Client)this.cad;
        byte by = apdu.getChannelInfo();
        if (apdu.Le > Short.MAX_VALUE || apdu.Lc > Short.MAX_VALUE || apdu.Le < 0 || apdu.Lc < 0) {
            throw new IllegalArgumentException();
        }
        int n = apdu.getCase();
        if (n == 7 && apdu.Lc <= 255 && apdu.Lc > 0) {
            n = 4;
        }
        block0 : switch (n) {
            case 1: 
            case 2: {
                apdu.dataOut = new byte[Short.MAX_VALUE];
                nArray[0] = apdu.Le;
                int n2 = cadT0Client.isoOut(apdu.command, apdu.dataOut, nArray, apdu.sw1sw2);
                if (n2 != 0 && n2 != 231 && n2 != 229) {
                    throw new TLP224Exception(n2);
                }
                apdu.Le = nArray[1];
                while (this.auto61xx && apdu.sw1sw2[0] == 97 && apdu.Le + (apdu.sw1sw2[1] & 0xFF) <= Short.MAX_VALUE) {
                    this.getResponseApdu.command[0] = apdu.makeISOInterIndustryCLA(by);
                    this.getResponseApdu.command[1] = -64;
                    this.getResponseApdu.command[2] = 0;
                    this.getResponseApdu.command[3] = 0;
                    this.getResponseApdu.command[4] = apdu.sw1sw2[1];
                    int n3 = apdu.sw1sw2[1] & 0xFF;
                    if (n3 == 0) {
                        n3 = 256;
                    }
                    nArray[0] = n3;
                    n2 = cadT0Client.isoOut(this.getResponseApdu.command, this.dataOut, nArray, apdu.sw1sw2);
                    if (n2 != 0 && n2 != 231 && n2 != 229) {
                        throw new TLP224Exception(n2);
                    }
                    if (nArray[1] == 0) break block0;
                    System.arraycopy(this.dataOut, 0, apdu.dataOut, apdu.Le, nArray[1]);
                    apdu.Le += nArray[1];
                }
                break;
            }
            case 3: {
                int n4 = cadT0Client.isoIn(apdu.command, apdu.dataIn, apdu.Lc, apdu.sw1sw2);
                if (n4 == 0 || n4 == 231 || n4 == 229) break;
                throw new TLP224Exception(n4);
            }
            case 4: {
                int n5 = cadT0Client.isoIn(apdu.command, apdu.dataIn, apdu.Lc, apdu.sw1sw2);
                if (n5 != 0 && n5 != 231 && n5 != 229) {
                    throw new TLP224Exception(n5);
                }
                apdu.dataOut = new byte[Short.MAX_VALUE];
                apdu.Le = 0;
                while (this.auto61xx && apdu.sw1sw2[0] == 97 && apdu.Le + (apdu.sw1sw2[1] & 0xFF) <= Short.MAX_VALUE) {
                    this.getResponseApdu.command[0] = apdu.makeISOInterIndustryCLA(by);
                    this.getResponseApdu.command[1] = -64;
                    this.getResponseApdu.command[2] = 0;
                    this.getResponseApdu.command[3] = 0;
                    this.getResponseApdu.command[4] = apdu.sw1sw2[1];
                    int n6 = apdu.sw1sw2[1] & 0xFF;
                    if (n6 == 0) {
                        n6 = 256;
                    }
                    nArray[0] = n6;
                    n5 = cadT0Client.isoOut(this.getResponseApdu.command, this.dataOut, nArray, apdu.sw1sw2);
                    if (n5 != 0 && n5 != 231 && n5 != 229) {
                        throw new TLP224Exception(n5);
                    }
                    if (nArray[1] == 0) break block0;
                    System.arraycopy(this.dataOut, 0, apdu.dataOut, apdu.Le, nArray[1]);
                    apdu.Le += nArray[1];
                }
                break;
            }
            case 5: {
                apdu.dataOut = new byte[Short.MAX_VALUE];
                nArray[0] = 0;
                int n7 = cadT0Client.isoOut(apdu.command, apdu.dataOut, nArray, apdu.sw1sw2);
                if (n7 != 0 && n7 != 231 && n7 != 229) {
                    throw new TLP224Exception(n7);
                }
                apdu.Le = nArray[1];
                while (this.auto61xx && apdu.sw1sw2[0] == 97 && apdu.Le + (apdu.sw1sw2[1] & 0xFF) <= Short.MAX_VALUE) {
                    this.getResponseApdu.command[0] = apdu.makeISOInterIndustryCLA(by);
                    this.getResponseApdu.command[1] = -64;
                    this.getResponseApdu.command[2] = 0;
                    this.getResponseApdu.command[3] = 0;
                    this.getResponseApdu.command[4] = apdu.sw1sw2[1];
                    int n8 = apdu.sw1sw2[1] & 0xFF;
                    if (n8 == 0) {
                        n8 = 256;
                    }
                    nArray[0] = n8;
                    n7 = cadT0Client.isoOut(this.getResponseApdu.command, this.dataOut, nArray, apdu.sw1sw2);
                    if (n7 != 0 && n7 != 231 && n7 != 229) {
                        throw new TLP224Exception(n7);
                    }
                    if (nArray[1] == 0) break block0;
                    System.arraycopy(this.dataOut, 0, apdu.dataOut, apdu.Le, nArray[1]);
                    apdu.Le += nArray[1];
                }
                break;
            }
            case 6: {
                Vector<Apdu> vector = this.envelopeAPDU(apdu);
                Enumeration<Apdu> enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    int n9;
                    Apdu apdu2 = enumeration.nextElement();
                    boolean bl = false;
                    if (!enumeration.hasMoreElements()) {
                        bl = true;
                    }
                    if ((n9 = cadT0Client.isoIn(apdu2.command, apdu2.dataIn, apdu2.Lc, apdu2.sw1sw2)) != 0 && n9 != 231 && n9 != 229) {
                        throw new TLP224Exception(n9);
                    }
                    if (bl) {
                        apdu.sw1sw2[0] = apdu2.sw1sw2[0];
                        apdu.sw1sw2[1] = apdu2.sw1sw2[1];
                        continue;
                    }
                    if (apdu2.sw1sw2[0] == -112 && apdu2.sw1sw2[1] == 0) continue;
                    apdu.sw1sw2[0] = apdu2.sw1sw2[0];
                    apdu.sw1sw2[1] = apdu2.sw1sw2[1];
                    break block0;
                }
                break;
            }
            case 7: {
                int n10;
                apdu.dataOut = new byte[Short.MAX_VALUE];
                Vector<Apdu> vector = this.envelopeAPDU(apdu);
                Enumeration<Apdu> enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    Apdu apdu3 = enumeration.nextElement();
                    boolean bl = false;
                    if (!enumeration.hasMoreElements()) {
                        bl = true;
                    }
                    if ((n10 = cadT0Client.isoIn(apdu3.command, apdu3.dataIn, apdu3.Lc, apdu3.sw1sw2)) != 0 && n10 != 231 && n10 != 229) {
                        throw new TLP224Exception(n10);
                    }
                    if (bl) {
                        apdu.sw1sw2[0] = apdu3.sw1sw2[0];
                        apdu.sw1sw2[1] = apdu3.sw1sw2[1];
                        continue;
                    }
                    if (apdu3.sw1sw2[0] == -112 && apdu3.sw1sw2[1] == 0) continue;
                    apdu.sw1sw2[0] = apdu3.sw1sw2[0];
                    apdu.sw1sw2[1] = apdu3.sw1sw2[1];
                    break;
                }
                apdu.Le = nArray[1];
                while (this.auto61xx && apdu.sw1sw2[0] == 97 && apdu.Le + (apdu.sw1sw2[1] & 0xFF) <= Short.MAX_VALUE) {
                    this.getResponseApdu.command[0] = apdu.makeISOInterIndustryCLA(by);
                    this.getResponseApdu.command[1] = -64;
                    this.getResponseApdu.command[2] = 0;
                    this.getResponseApdu.command[3] = 0;
                    this.getResponseApdu.command[4] = apdu.sw1sw2[1];
                    int n11 = apdu.sw1sw2[1] & 0xFF;
                    if (n11 == 0) {
                        n11 = 256;
                    }
                    nArray[0] = n11;
                    n10 = cadT0Client.isoOut(this.getResponseApdu.command, this.dataOut, nArray, apdu.sw1sw2);
                    if (n10 != 0 && n10 != 231 && n10 != 229) {
                        throw new TLP224Exception(n10);
                    }
                    if (nArray[1] == 0) break block0;
                    System.arraycopy(this.dataOut, 0, apdu.dataOut, apdu.Le, nArray[1]);
                    apdu.Le += nArray[1];
                }
                break;
            }
            default: {
                throw new TLP224Exception(23);
            }
        }
    }

    private Vector<Apdu> envelopeAPDU(Apdu apdu) {
        byte by = apdu.getChannelInfo();
        Vector<Apdu> vector = new Vector<Apdu>();
        int n = 9;
        int n2 = apdu.Lc + n;
        int n3 = n2 / 219;
        if (n3 * 224 < n2) {
            ++n3;
        }
        boolean bl = true;
        int n4 = n2;
        while (n4 > 0) {
            int n5;
            int n6;
            int n7;
            int n8 = 0;
            boolean bl2 = false;
            if (n4 > 219) {
                n7 = 219;
            } else {
                n7 = n4;
                bl2 = true;
            }
            Apdu apdu2 = new Apdu();
            apdu2.command[0] = apdu.makeISOInterIndustryCLA(by);
            apdu2.command[1] = -62;
            apdu2.command[2] = 0;
            apdu2.command[3] = 0;
            apdu2.command[4] = (byte)n7;
            apdu2.Lc = n7;
            apdu2.Le = 0;
            apdu2.dataIn = new byte[n7];
            if (bl) {
                bl = false;
                System.arraycopy(apdu.command, 0, apdu2.dataIn, 0, 4);
                apdu2.dataIn[4] = 0;
                n6 = apdu.Lc >> 8 & 0xFF;
                n5 = apdu.Lc & 0xFF;
                apdu2.dataIn[5] = (byte)n6;
                apdu2.dataIn[6] = (byte)n5;
                n4 -= 7;
                n8 = 7;
            }
            n6 = n2 - 7 - n4;
            n5 = bl2 ? n7 - 2 - n8 : n7 - n8;
            if (n5 < 0) {
                n5 = 0;
            }
            if (apdu.Lc - n6 < n5) {
                n5 = apdu.Lc - n6;
            }
            System.arraycopy(apdu.dataIn, n6, apdu2.dataIn, n8, n5);
            n6 += n5;
            n4 -= n5;
            if ((n8 += n5) != 219) {
                if (n4 == 1 && bl2) {
                    apdu2.dataIn[n8++] = (byte)(apdu.Le & 0xFF);
                    --n4;
                } else if (n4 == 2 && !bl2) {
                    apdu2.dataIn[n8++] = (byte)(apdu.Le >> 8 & 0xFF);
                    --n4;
                } else if (bl2) {
                    apdu2.dataIn[n8++] = (byte)(apdu.Le >> 8 & 0xFF);
                    apdu2.dataIn[n8++] = (byte)(apdu.Le & 0xFF);
                    n4 -= 2;
                }
            }
            vector.add(apdu2);
        }
        return vector;
    }
}

