/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.classfile;

import com.sun.javacard.basicstructure.ClassDefinition;
import com.sun.javacard.classfile.JField;
import com.sun.javacard.classfile.JMethod;
import com.sun.javacard.classfile.attributes.JAttribute;
import com.sun.javacard.classfile.attributes.JSourceFileAttr;
import com.sun.javacard.classfile.constants.JConstant;
import com.sun.javacard.classfile.constants.JConstantClass;
import com.sun.javacard.classfile.constants.JConstantPool;
import com.sun.javacard.converter.PrecheckException;
import com.sun.javacard.converter.util.Notifier;
import java.io.DataInputStream;
import java.io.IOException;

public class JClassFile
extends ClassDefinition {
    private static final int ACC_ENUM = 16384;
    private int magic;
    private int major_version;
    private int minor_version;
    private int this_class_index;
    private int super_class_index;
    private JConstantPool constant_pool;
    private int[] interface_indexes;
    private JField[] fields;
    private JMethod[] methods;
    private JAttribute[] attributes;
    private String[] interface_names;

    public int getMagic() {
        return this.magic;
    }

    public int getMajorVersion() {
        return this.major_version;
    }

    public int getMinorVersion() {
        return this.minor_version;
    }

    public String[] getInterfaceNames() {
        return this.interface_names;
    }

    public JField[] getFields() {
        return this.fields;
    }

    public JMethod[] getMethods() {
        return this.methods;
    }

    public JConstantPool getConstantPool() {
        return this.constant_pool;
    }

    public JAttribute[] getAttributes() {
        return this.attributes;
    }

    public void resolve() throws PrecheckException {
        this.constant_pool.resolve();
        this.class_name = this.constant_pool.getConstantClass(this.this_class_index).getClassName();
        this.checkJDK50Features();
        this.super_class_name = this.super_class_index != 0 ? this.constant_pool.getConstantClass(this.super_class_index).getClassName() : null;
        this.interface_names = new String[this.interface_indexes.length];
        for (int i = 0; i < this.interface_names.length; ++i) {
            this.interface_names[i] = this.constant_pool.getConstantClass(this.interface_indexes[i]).getClassName();
        }
        for (JAttribute object : this.attributes) {
            object.resolve();
            if (!(object instanceof JSourceFileAttr)) continue;
            this.source_file_name = ((JSourceFileAttr)object).getFileName();
        }
        for (JField jField : this.fields) {
            jField.resolve();
        }
        for (JMethod jMethod : this.methods) {
            jMethod.resolve();
        }
    }

    private void checkJDK50Features() throws PrecheckException {
        Object[] objectArray;
        for (int i = 0; i < this.constant_pool.getConstants().length; ++i) {
            JConstant jConstant = this.constant_pool.getAt(i);
            if (!(jConstant instanceof JConstantClass) || !"java/lang/AssertionError".equals(objectArray = ((JConstantClass)jConstant).getClassName())) continue;
            Object[] objectArray2 = new Object[]{this.class_name.replace('/', '.')};
            Notifier.error("subset.64", objectArray2);
            throw new PrecheckException();
        }
        if ((this.access_flags & 0x4000) != 0) {
            String string = this.class_name.replace('/', '.');
            int n = string.lastIndexOf(36);
            if (n > 0) {
                string = string.substring(0, n);
            }
            objectArray = new Object[]{string};
            Notifier.error("subset.65", objectArray);
            throw new PrecheckException();
        }
    }

    public void parse(DataInputStream dataInputStream) throws IOException {
        int n;
        this.magic = dataInputStream.readInt();
        this.minor_version = dataInputStream.readUnsignedShort();
        this.major_version = dataInputStream.readUnsignedShort();
        this.constant_pool = new JConstantPool(dataInputStream.readUnsignedShort());
        this.constant_pool.parse(dataInputStream);
        this.access_flags = dataInputStream.readUnsignedShort();
        this.this_class_index = dataInputStream.readUnsignedShort();
        this.super_class_index = dataInputStream.readUnsignedShort();
        this.interface_indexes = new int[dataInputStream.readUnsignedShort()];
        for (n = 0; n < this.interface_indexes.length; ++n) {
            this.interface_indexes[n] = dataInputStream.readUnsignedShort();
        }
        this.fields = new JField[dataInputStream.readUnsignedShort()];
        for (n = 0; n < this.fields.length; ++n) {
            this.fields[n] = new JField(this.constant_pool);
            this.fields[n].parse(dataInputStream);
        }
        this.methods = new JMethod[dataInputStream.readUnsignedShort()];
        for (n = 0; n < this.methods.length; ++n) {
            this.methods[n] = new JMethod(this.constant_pool);
            this.methods[n].parse(dataInputStream);
        }
        this.attributes = new JAttribute[dataInputStream.readUnsignedShort()];
        for (n = 0; n < this.attributes.length; ++n) {
            int n2 = dataInputStream.readUnsignedShort();
            this.attributes[n] = JAttribute.create(this.constant_pool, n2);
            this.attributes[n].parse(dataInputStream);
        }
    }

    public JField getField(String string, String string2) {
        for (JField jField : this.fields) {
            if (!jField.getFieldName().equals(string) || !jField.getFieldDescriptor().equals(string2)) continue;
            return jField;
        }
        return null;
    }

    public JMethod getMethod(String string, String string2) {
        for (JMethod jMethod : this.methods) {
            if (!jMethod.getMethodName().equals(string) || !jMethod.getMethodDescriptor().equals(string2)) continue;
            return jMethod;
        }
        return null;
    }

    public void addMethod(JMethod jMethod) {
        JMethod[] jMethodArray = new JMethod[this.methods.length + 1];
        System.arraycopy(this.methods, 0, jMethodArray, 0, this.methods.length);
        jMethodArray[this.methods.length] = jMethod;
        this.methods = jMethodArray;
    }
}

