/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.converter.converters;

import com.sun.javacard.converter.ConversionException;
import com.sun.javacard.converter.ConverterInternalError;
import com.sun.javacard.converter.converters.InstrContainer;
import com.sun.javacard.converter.converters.InstructionConverter;
import com.sun.javacard.converter.converters.MethodConverter;
import com.sun.javacard.converter.converters.OperandStackEntry;
import com.sun.javacard.converter.util.Notifier;
import com.sun.javacard.jcfile.instructions.JcInstrNoOperands;
import com.sun.javacard.jcfile.instructions.JcInstruction;

class InstrArithmeticConverter
extends InstructionConverter {
    private static final int SHORT_FLAVOR_BC = 1;
    private static final int INT_FLAVOR_BC = 2;
    private int[][] conversion_table = new int[][]{{96, 65, 66}, {100, 67, 68}, {104, 69, 70}, {108, 71, 72}, {112, 73, 74}, {116, 75, 76}, {120, 77, 78}, {122, 79, 80}, {124, 81, 82}, {126, 83, 84}, {128, 85, 86}, {130, 87, 88}};
    private boolean operands_overflow = false;
    private boolean result_overflow = false;
    private int result_type;

    public InstrArithmeticConverter(InstrContainer instrContainer, MethodConverter methodConverter) {
        super(instrContainer, methodConverter);
    }

    private int getJcOpcode(int n, int n2) {
        for (int[] nArray : this.conversion_table) {
            if (nArray[0] != n) continue;
            return nArray[n2];
        }
        throw new ConverterInternalError();
    }

    @Override
    public JcInstruction convert() throws Exception {
        int n = this.java_instr.getOpcode();
        OperandStackEntry operandStackEntry = this.operand_stack.peek(1);
        OperandStackEntry operandStackEntry2 = null;
        if (n != 116) {
            operandStackEntry2 = this.operand_stack.peek(2);
        }
        this.operands_overflow = this.checkOperandsAndOperator(n, operandStackEntry2, operandStackEntry);
        this.result_type = this.determineResultType(n, operandStackEntry2, operandStackEntry);
        if (this.result_type == 3) {
            if (n == 116) {
                if (operandStackEntry.getType() != 3) {
                    operandStackEntry.rollBack();
                }
            } else {
                if (operandStackEntry.getType() != 3) {
                    operandStackEntry.rollBack();
                }
                if (operandStackEntry2.getType() != 3) {
                    operandStackEntry2.rollBack();
                }
            }
            this.jc_instr = new JcInstrNoOperands(this.getJcOpcode(n, 2));
        } else {
            this.jc_instr = new JcInstrNoOperands(this.getJcOpcode(n, 1));
        }
        this.determineResultOverflow(operandStackEntry, operandStackEntry2);
        if (n == 116) {
            this.operand_stack.pop();
        } else {
            this.operand_stack.pop();
            this.operand_stack.pop();
        }
        OperandStackEntry operandStackEntry3 = new OperandStackEntry(this.result_type, this.instr_container);
        operandStackEntry3.setOverflow(this.result_overflow);
        if (!this.result_overflow && operandStackEntry.isTypeKnown() && (operandStackEntry2 == null || operandStackEntry2.isTypeKnown())) {
            operandStackEntry3.setTypeKnown(true);
        }
        this.determineRollBackPoint(operandStackEntry2, operandStackEntry, operandStackEntry3);
        this.operand_stack.push(operandStackEntry3);
        return this.jc_instr;
    }

    private boolean checkOperandsAndOperator(int n, OperandStackEntry operandStackEntry, OperandStackEntry operandStackEntry2) throws Exception {
        switch (n) {
            case 108: 
            case 112: {
                if (operandStackEntry.hasOverflowPotential()) {
                    if (this.method_converter.isIntSupported()) {
                        operandStackEntry.rollBack();
                    } else {
                        this.reportError();
                    }
                }
                if (operandStackEntry2.hasOverflowPotential()) {
                    if (this.method_converter.isIntSupported()) {
                        operandStackEntry2.rollBack();
                    } else {
                        this.reportError();
                    }
                }
                return false;
            }
            case 122: 
            case 124: {
                if (operandStackEntry.hasOverflowPotential()) {
                    if (this.method_converter.isIntSupported()) {
                        operandStackEntry.rollBack();
                    } else {
                        this.reportError();
                    }
                }
                return false;
            }
            case 116: {
                if (operandStackEntry2.hasOverflowPotential()) {
                    if (this.method_converter.isIntSupported()) {
                        operandStackEntry2.rollBack();
                    } else {
                        this.reportError();
                    }
                }
                return false;
            }
        }
        if (operandStackEntry.hasOverflowPotential()) {
            return true;
        }
        return operandStackEntry2.hasOverflowPotential();
    }

    private void reportError() throws Exception {
        Notifier.error(this.java_instr.getSourceLineNumber(), "int.21", this.method_converter.getClassName().replace('/', '.'));
        throw new ConversionException();
    }

    private int determineResultType(int n, OperandStackEntry operandStackEntry, OperandStackEntry operandStackEntry2) {
        this.result_overflow = false;
        switch (n) {
            case 96: 
            case 100: 
            case 104: {
                if (operandStackEntry.getType() == 1 && operandStackEntry2.getType() == 1) {
                    return 2;
                }
                if (operandStackEntry.getType() == 3 || operandStackEntry2.getType() == 3) {
                    return 3;
                }
                this.result_overflow = true;
                return 2;
            }
            case 108: {
                if (operandStackEntry.getType() == 1 && operandStackEntry2.getType() == 1) {
                    return 2;
                }
                if (operandStackEntry.getType() == 1 && operandStackEntry2.getType() == 2) {
                    return 2;
                }
                if (operandStackEntry.getType() == 3 || operandStackEntry2.getType() == 3) {
                    return 3;
                }
                this.result_overflow = true;
                return 2;
            }
            case 120: {
                if (operandStackEntry.getType() == 3) {
                    return 3;
                }
                if (operandStackEntry2.getType() == 3) {
                    return 3;
                }
                this.result_overflow = true;
                return 2;
            }
            case 112: {
                if (operandStackEntry.getType() == 1 && operandStackEntry2.getType() == 1) {
                    return 1;
                }
                if (operandStackEntry.getType() == 2 && operandStackEntry2.getType() == 1) {
                    return 1;
                }
                if (operandStackEntry.getType() == 1 && operandStackEntry2.getType() == 2) {
                    return 1;
                }
                if (operandStackEntry.getType() == 2 && operandStackEntry2.getType() == 2) {
                    return 2;
                }
                return 3;
            }
            case 116: {
                if (operandStackEntry2.getType() == 1) {
                    return 2;
                }
                if (operandStackEntry2.getType() == 2) {
                    this.result_overflow = true;
                    return 2;
                }
                return 3;
            }
            case 122: {
                if (operandStackEntry.getType() == 3) {
                    return 3;
                }
                if (operandStackEntry2.getType() == 3) {
                    return 3;
                }
                return operandStackEntry.getType();
            }
            case 124: {
                if (operandStackEntry.getType() == 3) {
                    return 3;
                }
                if (operandStackEntry2.getType() == 3) {
                    return 3;
                }
                this.result_overflow = true;
                return 2;
            }
            case 126: 
            case 128: 
            case 130: {
                if (operandStackEntry.getType() == 1 && operandStackEntry2.getType() == 1) {
                    return 1;
                }
                if (operandStackEntry.getType() == 2 && operandStackEntry2.getType() == 1) {
                    return 2;
                }
                if (operandStackEntry.getType() == 1 && operandStackEntry2.getType() == 2) {
                    return 2;
                }
                if (operandStackEntry.getType() == 2 && operandStackEntry2.getType() == 2) {
                    return 2;
                }
                return 3;
            }
        }
        throw new ConverterInternalError();
    }

    private void determineResultOverflow(OperandStackEntry operandStackEntry, OperandStackEntry operandStackEntry2) {
        if (operandStackEntry.hasOverflowPotential() || operandStackEntry.hasOverflowPotential()) {
            this.result_overflow = true;
        }
    }

    private void determineRollBackPoint(OperandStackEntry operandStackEntry, OperandStackEntry operandStackEntry2, OperandStackEntry operandStackEntry3) {
        this.result_overflow = false;
        if (false) {
            return;
        }
        if (this.java_instr.getOpcode() == 116) {
            if (operandStackEntry2.getRollBackPoint() != null) {
                operandStackEntry3.setRollBackPoint(operandStackEntry2.getRollBackPoint());
            } else {
                operandStackEntry3.setRollBackPoint(operandStackEntry2.getInstrContainer());
            }
        } else if (operandStackEntry.getRollBackPoint() != null) {
            operandStackEntry3.setRollBackPoint(operandStackEntry.getRollBackPoint());
        } else if (operandStackEntry2.getRollBackPoint() != null) {
            operandStackEntry3.setRollBackPoint(operandStackEntry2.getRollBackPoint());
        } else {
            operandStackEntry3.setRollBackPoint(operandStackEntry.getInstrContainer());
        }
    }
}

