/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.collector.procfs.impl;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.dlight.api.datafilter.DataFilter;
import org.netbeans.modules.dlight.api.execution.AttachableTarget;
import org.netbeans.modules.dlight.api.execution.DLightTarget;
import org.netbeans.modules.dlight.api.execution.DLightTargetChangeEvent;
import org.netbeans.modules.dlight.api.execution.Validateable;
import org.netbeans.modules.dlight.api.execution.ValidationListener;
import org.netbeans.modules.dlight.api.execution.ValidationStatus;
import org.netbeans.modules.dlight.api.impl.DLightTargetAccessor;
import org.netbeans.modules.dlight.api.storage.DataRow;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.collector.procfs.ProcFSDCConfiguration;
import org.netbeans.modules.dlight.collector.procfs.impl.ProcFSDCConfigurationAccessor;
import org.netbeans.modules.dlight.collector.procfs.impl.ProcFSDataCollectorValidator;
import org.netbeans.modules.dlight.impl.SQLDataStorage;
import org.netbeans.modules.dlight.msa.support.MSASQLTables;
import org.netbeans.modules.dlight.procfs.api.LWPUsage;
import org.netbeans.modules.dlight.procfs.api.PStatus;
import org.netbeans.modules.dlight.procfs.api.PUsage;
import org.netbeans.modules.dlight.procfs.api.SamplingData;
import org.netbeans.modules.dlight.procfs.reader.api.ProcReader;
import org.netbeans.modules.dlight.procfs.reader.api.ProcReaderFactory;
import org.netbeans.modules.dlight.spi.collector.DataCollector;
import org.netbeans.modules.dlight.spi.collector.DataCollectorListener;
import org.netbeans.modules.dlight.spi.indicator.IndicatorDataProvider;
import org.netbeans.modules.dlight.spi.storage.DataStorage;
import org.netbeans.modules.dlight.spi.storage.DataStorageType;
import org.netbeans.modules.dlight.spi.support.DataStorageTypeFactory;
import org.netbeans.modules.dlight.util.Computable;
import org.netbeans.modules.dlight.util.DLightExecutorService;
import org.netbeans.modules.dlight.util.DLightLogger;
import org.netbeans.modules.dlight.util.TasksCachedProcessor;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;

public class ProcFSDataCollector
extends IndicatorDataProvider<ProcFSDCConfiguration>
implements DataCollector<ProcFSDCConfiguration> {
    private static final Logger log = DLightLogger.getLogger(ProcFSDataCollector.class);
    private final List<ValidationListener> validationListeners = new CopyOnWriteArrayList<ValidationListener>();
    private final ProcFSDCConfiguration configuration;
    private TasksCachedProcessor<DLightTarget, ValidationStatus> validator = new TasksCachedProcessor((Computable)new ProcFSDataCollectorValidator(), false);
    private DLightTarget target;
    private volatile Future<?> mainLoop;
    private final boolean msaEnabled;
    private final boolean prstatEnabled;
    private final List<DataTableMetadata> providedDataTables;
    private SQLDataStorage sqlStorage;
    private PreparedStatement insertMSAStatement = null;
    private final List<DataCollectorListener> listeners = new ArrayList<DataCollectorListener>();

    public ProcFSDataCollector(ProcFSDCConfiguration configuration) {
        this.configuration = configuration;
        ProcFSDCConfigurationAccessor access = ProcFSDCConfigurationAccessor.getDefault();
        this.msaEnabled = access.msaSampling(configuration) > 0;
        this.prstatEnabled = access.procInfoSampling(configuration) > 0;
        ArrayList<DataTableMetadata> tables = new ArrayList<DataTableMetadata>();
        if (this.prstatEnabled) {
            tables.add(MSASQLTables.prstat.tableMetadata);
        }
        if (this.msaEnabled) {
            tables.add(MSASQLTables.msa.tableMetadata);
            tables.add(MSASQLTables.lwps.tableMetadata);
        }
        this.providedDataTables = Collections.unmodifiableList(tables);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addDataCollectorListener(DataCollectorListener listener) {
        if (listener == null) {
            return;
        }
        ProcFSDataCollector procFSDataCollector = this;
        synchronized (procFSDataCollector) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeDataCollectorListener(DataCollectorListener listener) {
        ProcFSDataCollector procFSDataCollector = this;
        synchronized (procFSDataCollector) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void notifyListeners(final DataCollector.CollectorState state) {
        DataCollectorListener[] ll;
        ProcFSDataCollector procFSDataCollector = this;
        synchronized (procFSDataCollector) {
            ll = this.listeners.toArray(new DataCollectorListener[0]);
        }
        final CountDownLatch doneFlag = new CountDownLatch(ll.length);
        for (final DataCollectorListener l : ll) {
            DLightExecutorService.submit((Runnable)new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        l.collectorStateChanged((DataCollector)ProcFSDataCollector.this, state);
                    }
                    finally {
                        doneFlag.countDown();
                    }
                }
            }, (String)("Notifying " + l));
        }
        try {
            doneFlag.await();
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
    }

    public String getName() {
        return "ProcFSReader";
    }

    public void targetStateChanged(DLightTargetChangeEvent event) {
        switch (event.state) {
            case RUNNING: {
                this.targetStarted(event.target);
                break;
            }
            case FAILED: {
                this.targetFinished(event.target);
                break;
            }
            case TERMINATED: {
                this.targetFinished(event.target);
                break;
            }
            case DONE: {
                this.targetFinished(event.target);
                break;
            }
            case STOPPED: {
                this.targetFinished(event.target);
                return;
            }
        }
    }

    public ValidationStatus validate(DLightTarget target) {
        this.target = target;
        ValidationStatus result = ValidationStatus.initialStatus();
        try {
            result = (ValidationStatus)this.validator.compute((Object)target);
        }
        catch (InterruptedException ex) {
            result = ValidationStatus.invalidStatus((String)ex.getMessage());
        }
        this.notifyStatusChanged(null, result);
        return result;
    }

    public synchronized void invalidate() {
        this.validator.remove((Object)this.target);
        this.target = null;
        this.notifyStatusChanged(null, ValidationStatus.initialStatus());
    }

    public ValidationStatus getValidationStatus() {
        if (this.target == null) {
            return ValidationStatus.initialStatus();
        }
        return this.validate(this.target);
    }

    public void addValidationListener(ValidationListener listener) {
        if (!this.validationListeners.contains(listener)) {
            this.validationListeners.add(listener);
        }
    }

    public void removeValidationListener(ValidationListener listener) {
        this.validationListeners.remove(listener);
    }

    private final void notifyStatusChanged(ValidationStatus oldStatus, ValidationStatus newStatus) {
        if (oldStatus != null && oldStatus.equals((Object)newStatus)) {
            return;
        }
        for (ValidationListener validationListener : this.validationListeners) {
            validationListener.validationStateChanged((Validateable)this, oldStatus, newStatus);
        }
    }

    public void dataFiltersChanged(List<DataFilter> newSet, boolean isAdjusting) {
    }

    public Collection<DataStorageType> getRequiredDataStorageTypes() {
        DataStorageTypeFactory dstf = DataStorageTypeFactory.getInstance();
        return Arrays.asList(dstf.getDataStorageType("db:sql"));
    }

    public List<DataTableMetadata> getDataTablesMetadata() {
        return this.providedDataTables;
    }

    public void init(Map<DataStorageType, DataStorage> storages, DLightTarget target) {
        for (DataStorage ds : storages.values()) {
            SQLDataStorage storage;
            if (!(ds instanceof SQLDataStorage) || !this.prepareStatements(storage = (SQLDataStorage)ds)) continue;
            this.sqlStorage = storage;
            break;
        }
    }

    public boolean isAttachable() {
        return true;
    }

    public String getCmd() {
        throw new UnsupportedOperationException("Not supported operation.");
    }

    public String[] getArgs() {
        throw new UnsupportedOperationException("Not supported operation.");
    }

    private void targetStarted(DLightTarget target) {
        if (this.target != target) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(String.format("Got UNEXPECTED targetStarted() notification. Validation was performed against %s, but notified about %s", this.target.toString(), target.toString()));
            }
            return;
        }
        if (!this.prstatEnabled && !this.msaEnabled) {
            return;
        }
        int pid = ((AttachableTarget)target).getPID();
        ProcReader reader = ProcReaderFactory.getReader((ExecutionEnvironment)target.getExecEnv(), (int)pid);
        DLightTargetAccessor targetAccess = DLightTargetAccessor.getDefault();
        DLightTarget.Info targetInfo = targetAccess.getDLightTargetInfo(target);
        String attachTimeString = (String)targetInfo.getInfo().get("AttachTimeNano");
        long attachTime = 0L;
        if (attachTimeString != null) {
            try {
                attachTime = Long.parseLong(attachTimeString);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        this.mainLoop = DLightExecutorService.scheduleAtFixedRate((Runnable)new FetchAndUpdateTask(reader, attachTime), (long)1L, (TimeUnit)TimeUnit.SECONDS, (String)"ProcFSDataCollector data fetching loop");
    }

    private void targetFinished(DLightTarget target) {
        if (this.target == target && this.mainLoop != null) {
            this.mainLoop.cancel(true);
        }
    }

    private boolean prepareStatements(SQLDataStorage storage) {
        boolean result = false;
        try {
            this.insertMSAStatement = storage.prepareStatement(String.format("insert into %s (%s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", MSASQLTables.msa.tableMetadata.getName(), MSASQLTables.msa.TIMESTAMP.getColumnName(), MSASQLTables.msa.SAMPLE.getColumnName(), MSASQLTables.msa.LWP_ID.getColumnName(), MSASQLTables.msa.LWP_MSA_USR.getColumnName(), MSASQLTables.msa.LWP_MSA_SYS.getColumnName(), MSASQLTables.msa.LWP_MSA_TRP.getColumnName(), MSASQLTables.msa.LWP_MSA_TFL.getColumnName(), MSASQLTables.msa.LWP_MSA_DFL.getColumnName(), MSASQLTables.msa.LWP_MSA_KFL.getColumnName(), MSASQLTables.msa.LWP_MSA_LCK.getColumnName(), MSASQLTables.msa.LWP_MSA_SLP.getColumnName(), MSASQLTables.msa.LWP_MSA_LAT.getColumnName(), MSASQLTables.msa.LWP_MSA_STP.getColumnName()));
            result = true;
        }
        catch (SQLException ex) {
            log.warning(String.format("Exception while preparing insert statement (%s)", ex.getMessage()));
        }
        return result;
    }

    private class FetchAndUpdateTask
    implements Runnable {
        private final ProcReader reader;
        private final LWPsTracker lwpsTracker = new LWPsTracker();
        private final AtomicLong processStartTime = new AtomicLong(0L);
        private final long attachTimeNano;

        public FetchAndUpdateTask(ProcReader reader, long attachTimeNano) {
            this.reader = reader;
            this.attachTimeNano = attachTimeNano;
        }

        private final long toNanoOffset(long timenano) {
            return timenano - (this.attachTimeNano > 0L ? this.attachTimeNano : this.processStartTime.get());
        }

        @Override
        public void run() {
            block8: {
                try {
                    List lwpUsageData;
                    if (ProcFSDataCollector.this.prstatEnabled) {
                        PStatus processStatus = this.reader.getProcessStatus();
                        PUsage processUsage = this.reader.getProcessUsage();
                        if (processStatus == null || processUsage == null) {
                            return;
                        }
                        this.processStartTime.compareAndSet(0L, processUsage.getUsageInfo().pr_create);
                        PStatus.ThreadsInfo tinfo = processStatus.getThreadInfo();
                        SamplingData p_samplingInfo = processUsage.getSamplingData();
                        PUsage.MSAInfo p_msaInfo = processUsage.getMSAInfo();
                        float normCoef = (float)tinfo.pr_nlwp / (float)p_msaInfo.sum_states;
                        ProcFSDataCollector.this.notifyIndicators(Arrays.asList(new DataRow(MSASQLTables.prstat.tableMetadata.getColumnNames(), Arrays.asList(this.toNanoOffset(p_samplingInfo.timestamp), p_samplingInfo.sample, tinfo.pr_nlwp, tinfo.pr_nzomb, Float.valueOf(normCoef * (float)(p_msaInfo.pr_utime + p_msaInfo.pr_stime + p_msaInfo.pr_ttime)), Float.valueOf(normCoef * (float)p_msaInfo.pr_ltime), Float.valueOf(normCoef * (float)(p_msaInfo.pr_tftime + p_msaInfo.pr_dftime + p_msaInfo.pr_kftime + p_msaInfo.pr_wtime + p_msaInfo.pr_stoptime)), Float.valueOf(normCoef * (float)p_msaInfo.pr_slptime)))));
                    }
                    if (ProcFSDataCollector.this.sqlStorage != null && ProcFSDataCollector.this.msaEnabled && (lwpUsageData = this.reader.getThreadsInfo()) != null) {
                        for (LWPUsage lwpUsage : lwpUsageData) {
                            try {
                                SamplingData lwp_samplingInfo = lwpUsage.getSamplingData();
                                PUsage.UsageInfo lwp_usageInfo = lwpUsage.getUsageInfo();
                                PUsage.MSAInfo lwp_msaInfo = lwpUsage.getMSAInfo();
                                this.lwpsTracker.update(lwpUsage);
                                ProcFSDataCollector.this.insertMSAStatement.setLong(1, this.toNanoOffset(lwp_samplingInfo.timestamp));
                                ProcFSDataCollector.this.insertMSAStatement.setLong(2, lwp_samplingInfo.sample);
                                ProcFSDataCollector.this.insertMSAStatement.setInt(3, lwp_usageInfo.pr_lwpid);
                                ProcFSDataCollector.this.insertMSAStatement.setLong(4, lwp_msaInfo.pr_utime);
                                ProcFSDataCollector.this.insertMSAStatement.setLong(5, lwp_msaInfo.pr_stime);
                                ProcFSDataCollector.this.insertMSAStatement.setLong(6, lwp_msaInfo.pr_ttime);
                                ProcFSDataCollector.this.insertMSAStatement.setLong(7, lwp_msaInfo.pr_tftime);
                                ProcFSDataCollector.this.insertMSAStatement.setLong(8, lwp_msaInfo.pr_dftime);
                                ProcFSDataCollector.this.insertMSAStatement.setLong(9, lwp_msaInfo.pr_kftime);
                                ProcFSDataCollector.this.insertMSAStatement.setLong(10, lwp_msaInfo.pr_ltime);
                                ProcFSDataCollector.this.insertMSAStatement.setLong(11, lwp_msaInfo.pr_slptime);
                                ProcFSDataCollector.this.insertMSAStatement.setLong(12, lwp_msaInfo.pr_wtime);
                                ProcFSDataCollector.this.insertMSAStatement.setLong(13, lwp_msaInfo.pr_stoptime);
                                ProcFSDataCollector.this.insertMSAStatement.executeUpdate();
                            }
                            catch (SQLException ex) {
                                if (!log.isLoggable(Level.FINE)) continue;
                                log.log(Level.FINE, "SQL exception", ex);
                            }
                        }
                        this.lwpsTracker.endOfUpdate();
                    }
                }
                catch (Throwable th) {
                    if (!log.isLoggable(Level.FINE)) break block8;
                    log.log(Level.FINE, "Unhandled exception!", th);
                }
            }
        }

        private final class LWPsTracker {
            private final Object lock;
            private final HashMap<Integer, LWPUsage> lastReportedLWPs;
            private final HashMap<Integer, LWPUsage> newReportedLWPs;
            private PreparedStatement insertStatement;
            private PreparedStatement updateStatement;

            public LWPsTracker() {
                block2: {
                    this.lock = LWPsTracker.class.getName() + "_lock";
                    this.lastReportedLWPs = new HashMap();
                    this.newReportedLWPs = new HashMap();
                    this.insertStatement = null;
                    this.updateStatement = null;
                    try {
                        this.insertStatement = ProcFSDataCollector.this.sqlStorage.prepareStatement(String.format("insert into %s (%s, %s, %s) values (?, ?, null)", MSASQLTables.lwps.tableMetadata.getName(), MSASQLTables.lwps.LWP_ID.getColumnName(), MSASQLTables.lwps.LWP_START.getColumnName(), MSASQLTables.lwps.LWP_END.getColumnName()));
                        this.updateStatement = ProcFSDataCollector.this.sqlStorage.prepareStatement(String.format("update %s set %s = ? where %s = ?", MSASQLTables.lwps.tableMetadata.getName(), MSASQLTables.lwps.LWP_END.getColumnName(), MSASQLTables.lwps.LWP_ID.getColumnName()));
                    }
                    catch (Throwable th) {
                        if (!log.isLoggable(Level.FINE)) break block2;
                        log.log(Level.FINE, "will not provide data...", th);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void update(LWPUsage lwp_usageInfo) {
                block8: {
                    if (this.insertStatement == null || this.updateStatement == null) {
                        return;
                    }
                    boolean thread_started = false;
                    int id = lwp_usageInfo.getUsageInfo().pr_lwpid;
                    Object object = this.lock;
                    synchronized (object) {
                        this.newReportedLWPs.put(id, lwp_usageInfo);
                        if (!this.lastReportedLWPs.containsKey(id)) {
                            thread_started = true;
                        }
                    }
                    if (thread_started) {
                        try {
                            this.insertStatement.setInt(1, id);
                            this.insertStatement.setLong(2, FetchAndUpdateTask.this.toNanoOffset(FetchAndUpdateTask.this.attachTimeNano > 0L ? FetchAndUpdateTask.this.attachTimeNano : lwp_usageInfo.getUsageInfo().pr_create));
                            this.insertStatement.executeUpdate();
                        }
                        catch (SQLException ex) {
                            if (!log.isLoggable(Level.FINE)) break block8;
                            log.log(Level.FINE, "", ex);
                        }
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void endOfUpdate() {
                HashSet<LWPUsage> deadThreads = new HashSet<LWPUsage>();
                Object object = this.lock;
                synchronized (object) {
                    for (Integer id : this.lastReportedLWPs.keySet()) {
                        if (this.newReportedLWPs.containsKey(id)) continue;
                        deadThreads.add(this.lastReportedLWPs.get(id));
                    }
                    this.lastReportedLWPs.clear();
                    this.lastReportedLWPs.putAll(this.newReportedLWPs);
                    this.newReportedLWPs.clear();
                }
                for (LWPUsage deadThreadUsage : deadThreads) {
                    try {
                        this.updateStatement.setLong(1, FetchAndUpdateTask.this.toNanoOffset(deadThreadUsage.getSamplingData().timestamp));
                        this.updateStatement.setInt(2, deadThreadUsage.getUsageInfo().pr_lwpid);
                        this.updateStatement.executeUpdate();
                    }
                    catch (SQLException ex) {
                        if (!log.isLoggable(Level.FINE)) continue;
                        log.log(Level.FINE, "", ex);
                    }
                }
            }
        }
    }
}

