/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.refactoring;

import java.io.IOException;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.hibernate.refactoring.RenameMappingFilePanel;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUIBypass;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

final class RenameMappingFileRefactoringUI
implements RefactoringUI,
RefactoringUIBypass {
    private RenameRefactoring refactoring;
    private String originalName;
    private String oldName;
    private String dispOldName;
    private String newName;
    private RenameMappingFilePanel panel;
    private boolean newNameSpecified;
    private FileObject byPassFolder;

    RenameMappingFileRefactoringUI(FileObject fileObject, String string) {
        this.refactoring = new RenameRefactoring(Lookups.singleton((Object)fileObject));
        this.originalName = fileObject.getName();
        if (string == null) {
            this.dispOldName = this.oldName = fileObject.getName();
        } else {
            this.dispOldName = this.oldName = string;
            this.newNameSpecified = true;
        }
    }

    public String getName() {
        return NbBundle.getMessage(RenameMappingFilePanel.class, (String)"LBL_Rename");
    }

    public String getDescription() {
        return NbBundle.getMessage(RenameMappingFilePanel.class, (String)"DSC_RenameMappingFile", (Object)this.dispOldName, (Object)this.newName);
    }

    public boolean isQuery() {
        return false;
    }

    public CustomRefactoringPanel getPanel(ChangeListener changeListener) {
        if (this.panel == null) {
            this.panel = new RenameMappingFilePanel(changeListener, this.oldName, NbBundle.getMessage(RenameMappingFilePanel.class, (String)"DSC_RenameMappingFile", (Object)this.originalName), !this.newNameSpecified);
        }
        return this.panel;
    }

    public boolean hasParameters() {
        return true;
    }

    public Problem setParameters() {
        this.newName = this.panel.getNameValue();
        this.refactoring.setNewName(this.newName);
        return this.refactoring.checkParameters();
    }

    public Problem checkParameters() {
        this.newName = this.panel.getNameValue();
        this.refactoring.setNewName(this.newName);
        return this.refactoring.fastCheckParameters();
    }

    public AbstractRefactoring getRefactoring() {
        return this.refactoring;
    }

    public boolean isRefactoringBypassRequired() {
        return !this.panel.isUpdateReferences();
    }

    public void doRefactoringBypass() throws IOException {
        Object object = null;
        object = this.byPassFolder != null ? DataFolder.findFolder((FileObject)this.byPassFolder) : DataObject.find((FileObject)((FileObject)this.refactoring.getRefactoringSource().lookup(FileObject.class)));
        object.rename(this.panel.getNameValue());
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }
}

