/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject.classpath;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.netbeans.api.ruby.platform.RubyInstallation;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.api.ruby.platform.RubyPlatformProvider;
import org.netbeans.modules.ruby.platform.gems.GemManager;
import org.netbeans.modules.ruby.spi.project.support.rake.PropertyEvaluator;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.util.Exceptions;
import org.openide.util.WeakListeners;

final class BootClassPathImplementation
implements ClassPathImplementation,
PropertyChangeListener {
    private static final Logger LOGGER = Logger.getLogger(BootClassPathImplementation.class.getName());
    private static final Pattern GEM_EXCLUDE_FILTER;
    private static final Pattern GEM_INCLUDE_FILTER;
    private final PropertyEvaluator evaluator;
    private String activePlatformName;
    private boolean isActivePlatformValid;
    private List<PathResourceImplementation> resourcesCache;
    private PropertyChangeSupport support = new PropertyChangeSupport(this);

    public BootClassPathImplementation(PropertyEvaluator evaluator) {
        if (evaluator != null) {
            assert (evaluator != null);
            this.evaluator = evaluator;
            evaluator.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)evaluator));
        } else {
            this.evaluator = null;
        }
    }

    public synchronized List<PathResourceImplementation> getResources() {
        if (this.resourcesCache == null) {
            ArrayList<PathResourceImplementation> result = new ArrayList<PathResourceImplementation>();
            try {
                result.add(ClassPathSupport.createResource((URL)RubyPlatform.getRubyStubs().getURL()));
            }
            catch (FileStateInvalidException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            RubyPlatform platform = new RubyPlatformProvider(this.evaluator).getPlatform();
            if (platform == null) {
                LOGGER.severe("Cannot resolve platform for project");
                return Collections.emptyList();
            }
            if (!platform.hasRubyGemsInstalled()) {
                LOGGER.fine("Not RubyGems installed, returning empty result");
                return Collections.emptyList();
            }
            GemManager gemManager = this.getGemManager();
            assert (gemManager != null) : "not null when RubyGems are installed";
            for (URL url : gemManager.getNonGemLoadPath()) {
                result.add(ClassPathSupport.createResource((URL)url));
            }
            Map gemUrls = gemManager.getGemUrls();
            Pattern includeFilter = GEM_INCLUDE_FILTER;
            Pattern excludeFilter = GEM_EXCLUDE_FILTER;
            String include = this.evaluator.getProperty("ruby.includegems");
            String exclude = this.evaluator.getProperty("ruby.excludegems");
            try {
                if (include != null && include.length() > 0) {
                    includeFilter = Pattern.compile(include);
                }
                if (exclude != null && exclude.length() > 0) {
                    excludeFilter = Pattern.compile(exclude);
                }
            }
            catch (PatternSyntaxException pse) {
                Exceptions.printStackTrace((Throwable)pse);
            }
            for (URL url : gemUrls.values()) {
                String gem;
                if (includeFilter != null && includeFilter.matcher(gem = BootClassPathImplementation.getGemName(url)).find()) {
                    result.add(ClassPathSupport.createResource((URL)url));
                    continue;
                }
                if (excludeFilter != null && excludeFilter.matcher(gem = BootClassPathImplementation.getGemName(url)).find()) continue;
                result.add(ClassPathSupport.createResource((URL)url));
            }
            this.resourcesCache = Collections.unmodifiableList(result);
        }
        return this.resourcesCache;
    }

    private static String getGemName(URL gemUrl) {
        String urlString = gemUrl.getFile();
        if (urlString.endsWith("/lib/")) {
            urlString = urlString.substring(urlString.lastIndexOf(47, urlString.length() - 6) + 1, urlString.length() - 5);
        }
        return urlString;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == RubyInstallation.getInstance() && evt.getPropertyName().equals("roots")) {
            this.resetCache();
        }
    }

    private GemManager getGemManager() {
        return new RubyPlatformProvider(this.evaluator).getPlatform().getGemManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetCache() {
        BootClassPathImplementation bootClassPathImplementation = this;
        synchronized (bootClassPathImplementation) {
            this.resourcesCache = null;
        }
        this.support.firePropertyChange("resources", null, null);
    }

    static {
        String userExcludes = System.getProperty("ruby.prj.excludegems");
        if (userExcludes == null) {
            String deflt = "^(rails|action[a-z]+|activesupport)-\\d+\\.\\d+\\.\\d+(-\\S+)?$";
            GEM_EXCLUDE_FILTER = Pattern.compile(deflt);
        } else if ("none".equals(userExcludes)) {
            GEM_EXCLUDE_FILTER = null;
        } else {
            Pattern p;
            try {
                p = Pattern.compile(userExcludes);
            }
            catch (PatternSyntaxException pse) {
                Logger.getAnonymousLogger().log(Level.WARNING, "Invalid regular expression: " + userExcludes);
                Logger.getAnonymousLogger().log(Level.WARNING, pse.toString());
                p = null;
            }
            GEM_EXCLUDE_FILTER = p;
        }
        String userIncludes = System.getProperty("ruby.prj.includegems");
        if (userIncludes == null || "all".equals(userIncludes)) {
            GEM_INCLUDE_FILTER = null;
        } else {
            Pattern p;
            try {
                p = Pattern.compile(userIncludes);
            }
            catch (PatternSyntaxException pse) {
                Logger.getAnonymousLogger().log(Level.WARNING, "Invalid regular expression: " + userIncludes);
                Logger.getAnonymousLogger().log(Level.WARNING, pse.toString());
                p = null;
            }
            GEM_INCLUDE_FILTER = p;
        }
    }
}

