/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.debugger.jpda;

import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.ListeningConnector;
import java.beans.PropertyChangeListener;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerInfo;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.jpda.AttachingDICookie;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.DebuggerStartException;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.JPDAClassType;
import org.netbeans.api.debugger.jpda.JPDAStep;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.LaunchingDICookie;
import org.netbeans.api.debugger.jpda.ListeningDICookie;
import org.netbeans.api.debugger.jpda.SmartSteppingFilter;
import org.netbeans.api.debugger.jpda.ThreadsCollector;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointEvent;
import org.netbeans.spi.debugger.ContextAwareService;
import org.netbeans.spi.debugger.ContextAwareSupport;
import org.netbeans.spi.debugger.ContextProvider;
import org.openide.util.NbBundle;

public abstract class JPDADebugger {
    public static final String PROP_STATE = "state";
    public static final String PROP_CURRENT_THREAD = "currentThread";
    public static final String PROP_CURRENT_CALL_STACK_FRAME = "currentCallStackFrame";
    public static final String PROP_SUSPEND = "suspend";
    public static final String PROP_THREAD_STARTED = "threadStarted";
    public static final String PROP_THREAD_DIED = "threadDied";
    public static final String PROP_THREAD_GROUP_ADDED = "threadGroupAdded";
    public static final String PROP_CLASSES_FIXED = "classesFixed";
    public static final int SUSPEND_ALL = 2;
    public static final int SUSPEND_EVENT_THREAD = 1;
    public static final int STATE_STARTING = 1;
    public static final int STATE_RUNNING = 2;
    public static final int STATE_STOPPED = 3;
    public static final int STATE_DISCONNECTED = 4;
    public static final String ENGINE_ID = "netbeans-JPDASession/Java";
    public static final String SESSION_ID = "netbeans-JPDASession";

    public static void launch(String string, String[] stringArray, String string2, boolean bl) {
        DebuggerEngine[] debuggerEngineArray = DebuggerManager.getDebuggerManager().startDebugging(DebuggerInfo.create((String)"netbeans-jpda-LaunchingDICookie", (Object[])new Object[]{LaunchingDICookie.create(string, stringArray, string2, bl)}));
        if (debuggerEngineArray.length == 0) {
            throw new RuntimeException(NbBundle.getMessage(JPDADebugger.class, (String)"MSG_NO_DEBUGGER"));
        }
    }

    public static JPDADebugger listen(ListeningConnector listeningConnector, Map<String, ? extends Connector.Argument> map, Object[] objectArray) throws DebuggerStartException {
        Object[] objectArray2 = new Object[objectArray.length + 1];
        System.arraycopy(objectArray, 0, objectArray2, 1, objectArray.length);
        objectArray2[0] = ListeningDICookie.create(listeningConnector, map);
        DebuggerEngine[] debuggerEngineArray = DebuggerManager.getDebuggerManager().startDebugging(DebuggerInfo.create((String)"netbeans-jpda-ListeningDICookie", (Object[])objectArray2));
        int n = debuggerEngineArray.length;
        for (int i = 0; i < n; ++i) {
            JPDADebugger jPDADebugger = (JPDADebugger)debuggerEngineArray[i].lookupFirst(null, JPDADebugger.class);
            if (jPDADebugger == null) continue;
            jPDADebugger.waitRunning();
            return jPDADebugger;
        }
        throw new DebuggerStartException(NbBundle.getMessage(JPDADebugger.class, (String)"MSG_NO_DEBUGGER"));
    }

    public static void startListening(ListeningConnector listeningConnector, Map<String, ? extends Connector.Argument> map, Object[] objectArray) throws DebuggerStartException {
        JPDADebugger.startListeningAndGetEngines(listeningConnector, map, objectArray);
    }

    public static DebuggerEngine[] startListeningAndGetEngines(ListeningConnector listeningConnector, Map<String, ? extends Connector.Argument> map, Object[] objectArray) throws DebuggerStartException {
        Object[] objectArray2 = new Object[objectArray.length + 1];
        System.arraycopy(objectArray, 0, objectArray2, 1, objectArray.length);
        objectArray2[0] = ListeningDICookie.create(listeningConnector, map);
        DebuggerEngine[] debuggerEngineArray = DebuggerManager.getDebuggerManager().startDebugging(DebuggerInfo.create((String)"netbeans-jpda-ListeningDICookie", (Object[])objectArray2));
        if (debuggerEngineArray.length == 0) {
            throw new DebuggerStartException(NbBundle.getMessage(JPDADebugger.class, (String)"MSG_NO_DEBUGGER"));
        }
        return debuggerEngineArray;
    }

    public static JPDADebugger attach(String string, int n, Object[] objectArray) throws DebuggerStartException {
        Object[] objectArray2 = new Object[objectArray.length + 1];
        System.arraycopy(objectArray, 0, objectArray2, 1, objectArray.length);
        objectArray2[0] = AttachingDICookie.create(string, n);
        DebuggerEngine[] debuggerEngineArray = DebuggerManager.getDebuggerManager().startDebugging(DebuggerInfo.create((String)"netbeans-jpda-AttachingDICookie", (Object[])objectArray2));
        int n2 = debuggerEngineArray.length;
        for (int i = 0; i < n2; ++i) {
            JPDADebugger jPDADebugger = (JPDADebugger)debuggerEngineArray[i].lookupFirst(null, JPDADebugger.class);
            if (jPDADebugger == null) continue;
            jPDADebugger.waitRunning();
            return jPDADebugger;
        }
        throw new DebuggerStartException(NbBundle.getMessage(JPDADebugger.class, (String)"MSG_NO_DEBUGGER"));
    }

    public static JPDADebugger attach(String string, Object[] objectArray) throws DebuggerStartException {
        Object[] objectArray2 = new Object[objectArray.length + 1];
        System.arraycopy(objectArray, 0, objectArray2, 1, objectArray.length);
        objectArray2[0] = AttachingDICookie.create(string);
        DebuggerEngine[] debuggerEngineArray = DebuggerManager.getDebuggerManager().startDebugging(DebuggerInfo.create((String)"netbeans-jpda-AttachingDICookie", (Object[])objectArray2));
        int n = debuggerEngineArray.length;
        for (int i = 0; i < n; ++i) {
            JPDADebugger jPDADebugger = (JPDADebugger)debuggerEngineArray[i].lookupFirst(null, JPDADebugger.class);
            if (jPDADebugger == null) continue;
            jPDADebugger.waitRunning();
            return jPDADebugger;
        }
        throw new DebuggerStartException(NbBundle.getMessage(JPDADebugger.class, (String)"MSG_NO_DEBUGGER"));
    }

    public abstract int getState();

    public abstract int getSuspend();

    public abstract void setSuspend(int var1);

    public abstract JPDAThread getCurrentThread();

    public abstract CallStackFrame getCurrentCallStackFrame();

    public abstract Variable evaluate(String var1) throws InvalidExpressionException;

    public abstract void waitRunning() throws DebuggerStartException;

    public abstract boolean canFixClasses();

    public abstract boolean canPopFrames();

    public boolean canBeModified() {
        return true;
    }

    public abstract void fixClasses(Map<String, byte[]> var1);

    public abstract SmartSteppingFilter getSmartSteppingFilter();

    protected void fireBreakpointEvent(JPDABreakpoint jPDABreakpoint, JPDABreakpointEvent jPDABreakpointEvent) {
        jPDABreakpoint.fireJPDABreakpointChange(jPDABreakpointEvent);
    }

    public abstract void addPropertyChangeListener(PropertyChangeListener var1);

    public abstract void removePropertyChangeListener(PropertyChangeListener var1);

    public abstract void addPropertyChangeListener(String var1, PropertyChangeListener var2);

    public abstract void removePropertyChangeListener(String var1, PropertyChangeListener var2);

    public JPDAStep createJPDAStep(int n, int n2) {
        throw new UnsupportedOperationException("This method must be overridden.");
    }

    public boolean canGetInstanceInfo() {
        return false;
    }

    public List<JPDAClassType> getAllClasses() {
        return Collections.emptyList();
    }

    public List<JPDAClassType> getClassesByName(String string) {
        return Collections.emptyList();
    }

    public long[] getInstanceCounts(List<JPDAClassType> list) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported.");
    }

    public ThreadsCollector getThreadsCollector() {
        return null;
    }

    static class ContextAware
    extends JPDADebugger
    implements ContextAwareService<JPDADebugger> {
        private String serviceName;

        private ContextAware(String string) {
            this.serviceName = string;
        }

        public JPDADebugger forContext(ContextProvider contextProvider) {
            return (JPDADebugger)ContextAwareSupport.createInstance((String)this.serviceName, (ContextProvider)contextProvider);
        }

        @Override
        public int getState() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public int getSuspend() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void setSuspend(int n) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public JPDAThread getCurrentThread() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public CallStackFrame getCurrentCallStackFrame() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Variable evaluate(String string) throws InvalidExpressionException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void waitRunning() throws DebuggerStartException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public boolean canFixClasses() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public boolean canPopFrames() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void fixClasses(Map<String, byte[]> map) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public SmartSteppingFilter getSmartSteppingFilter() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        static ContextAwareService createService(Map map) throws ClassNotFoundException {
            String string = (String)map.get("serviceName");
            return new ContextAware(string);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE})
    public static @interface Registration {
        public String path() default "";
    }
}

