/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.export;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.MissingResourceException;
import javax.imageio.IIOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.microedition.m2g.SVGImage;
import javax.microedition.m2g.ScalableGraphics;
import javax.microedition.m2g.ScalableImage;
import javax.swing.text.BadLocationException;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.mobility.project.J2MEProject;
import org.netbeans.modules.mobility.project.ProjectConfigurationsHelper;
import org.netbeans.modules.mobility.svgcore.SVGDataObject;
import org.netbeans.modules.mobility.svgcore.export.Quantizer;
import org.netbeans.modules.mobility.svgcore.export.ScreenSizeHelper;
import org.netbeans.modules.mobility.svgcore.export.ShrinkPalette;
import org.netbeans.spi.project.ProjectConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.w3c.dom.svg.SVGSVGElement;

public class AnimationRasterizer {
    private static final int PATTERN_SIZE = 10;
    private static final Color PATTERN_COLOR1 = new Color(192, 192, 192);
    private static final Color PATTERN_COLOR2 = new Color(220, 220, 220);
    private static final Color BACKGROUND_COLOR = Color.WHITE;

    public static String createFileNameRoot(SVGDataObject dObj, Params params, ProjectConfiguration projectCfg, boolean fullPath) {
        String filenameRoot;
        FileObject fo = dObj.getPrimaryFile();
        if (fullPath) {
            filenameRoot = fo.getPath();
            String ext = fo.getExt();
            if (ext != null && ext.length() > 0) {
                filenameRoot = filenameRoot.substring(0, filenameRoot.length() - ext.length() - 1);
            }
        } else {
            filenameRoot = fo.getName();
        }
        if (params.isForAllConfigurations()) {
            if (projectCfg != null) {
                if (projectCfg != params.getProject().getConfigurationHelper().getDefaultConfiguration()) {
                    filenameRoot = filenameRoot + "_" + projectCfg.getDisplayName();
                }
            } else {
                filenameRoot = filenameRoot + "_{configuration-name-here}";
            }
        } else {
            filenameRoot = filenameRoot + AnimationRasterizer.getActiveConfigurationName(fo);
        }
        if (params.getElementId() != null) {
            filenameRoot = filenameRoot + "_" + params.getElementId();
        }
        return filenameRoot;
    }

    public static String createFileName(String filenameRoot, Params params, int frameIndex, int frameNum) {
        if (!params.isInSingleImage()) {
            assert (frameIndex >= 0);
            assert (frameNum >= 0);
            filenameRoot = filenameRoot + "_" + frameIndex + "_" + frameNum;
        }
        filenameRoot = params.getImageType().getFileName(filenameRoot);
        return filenameRoot;
    }

    public static void export(SVGDataObject dObj, Params params) throws MissingResourceException, IOException, BadLocationException {
        FileObject fo = dObj.getPrimaryFile();
        AnimationRasterizer.export(dObj, params, fo.getParent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileObject export(SVGDataObject dObj, Params params, FileObject directory) throws MissingResourceException, IOException, BadLocationException {
        ProgressHandle handle = ProgressHandleFactory.createHandle((String)AnimationRasterizer.getMessage("TITLE_AnimationExportProgress"));
        FileObject file = null;
        try {
            if (!params.isForAllConfigurations()) {
                handle.start(1);
                String filenameRoot = AnimationRasterizer.createFileNameRoot(dObj, params, null, false);
                file = AnimationRasterizer.rasterizeImage(params.getSVGImage(), directory, filenameRoot, params);
                handle.progress(1);
            } else {
                FileObject fo = dObj.getPrimaryFile();
                Collection configurations = params.getProject().getConfigurationHelper().getConfigurations();
                handle.start(configurations.size());
                int stepsDone = 0;
                int imageWidth = params.getImageWidth();
                int imageHeigth = params.getImageHeight();
                for (ProjectConfiguration configuration : configurations) {
                    Dimension activeDimenson = ScreenSizeHelper.getCurrentDeviceScreenSize(fo, null);
                    double ratioWidth = (double)imageWidth / activeDimenson.getWidth();
                    double ratioHeight = (double)imageHeigth / activeDimenson.getHeight();
                    assert (configuration != null);
                    String filenameRoot = AnimationRasterizer.createFileNameRoot(dObj, params, configuration, false);
                    Dimension dim = ScreenSizeHelper.getCurrentDeviceScreenSize(fo, configuration.getDisplayName());
                    params.setImageWidth((int)(dim.getWidth() * ratioWidth));
                    params.setImageHeight((int)(dim.getHeight() * ratioHeight));
                    AnimationRasterizer.rasterizeImage(params.getSVGImage(), directory, filenameRoot, params);
                    handle.progress(++stepsDone);
                }
            }
            directory.refresh(false);
        }
        finally {
            handle.finish();
        }
        return file;
    }

    private static BufferedImage adjustImage(BufferedImage img, Params params) {
        if (params.getImageType().needsColorReduction()) {
            img = params.getColorReductionMethod().reduceColors(img, params);
        }
        return img;
    }

    public static PreviewInfo previewFrame(SVGImage svgImage, Params params, int frameIndex, float time) throws IOException {
        BufferedImage img;
        if (frameIndex != -1 && ImageType.PNG8.equals((Object)params.getImageType()) && params.isInSingleImage()) {
            img = AnimationRasterizer.rasterizeFramesInSingleImage(svgImage, params);
            int w = params.getImageWidth();
            int h = params.getImageHeight();
            BufferedImage temp = AnimationRasterizer.createBuffer(w, h, params.isTransparent());
            Graphics2D g = temp.createGraphics();
            int x = frameIndex * w;
            g.drawImage(img, 0, 0, w - 1, h - 1, x, 0, x + w - 1, h - 1, null);
            g.dispose();
            img = temp;
        } else {
            img = AnimationRasterizer.rasterizeFrame(null, 0, svgImage, params, time);
            img = AnimationRasterizer.adjustImage(img, params);
        }
        ByteArrayOutputStream buff = new ByteArrayOutputStream();
        AnimationRasterizer.encodeImage(img, buff, params);
        if (ImageType.JPEG.equals((Object)params.getImageType())) {
            ByteArrayInputStream in = new ByteArrayInputStream(buff.toByteArray());
            img = AnimationRasterizer.decodeImage(in, params);
        } else if (params.isTransparent()) {
            int w = img.getWidth();
            int h = img.getHeight();
            BufferedImage background = AnimationRasterizer.createBuffer(w, h, false);
            Graphics2D g = background.createGraphics();
            g.setColor(PATTERN_COLOR1);
            g.fillRect(0, 0, w, h);
            g.setColor(PATTERN_COLOR2);
            int start = 0;
            for (int y = 0; y < h; y += 10) {
                for (int x = start; x < w; x += 20) {
                    g.fillRect(x, y, 10, 10);
                }
                start ^= 0xA;
            }
            g.drawImage((Image)img, 0, 0, null);
            g.dispose();
            img = background;
        }
        return new PreviewInfo(img, params.getImageType().toString(), buff.size());
    }

    private static BufferedImage createBuffer(int w, int h, boolean isTransparent) throws IIOException {
        try {
            return new BufferedImage(w, h, isTransparent ? 2 : 1);
        }
        catch (Throwable e) {
            System.err.println("Not enough memory");
            throw new IIOException("Not enough memory", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage rasterizeFrame(BufferedImage buffer, int xOffset, SVGImage svgImage, Params params, float time) throws IIOException {
        int w = params.getImageWidth();
        int h = params.getImageHeight();
        if (buffer == null) {
            buffer = AnimationRasterizer.createBuffer(w, h, params.isTransparent());
            xOffset = 0;
        }
        Graphics2D g = buffer.createGraphics();
        if (!params.isTransparent()) {
            g.setColor(BACKGROUND_COLOR);
            g.fillRect(xOffset, 0, w, h);
        }
        SVGImage sVGImage = svgImage;
        synchronized (sVGImage) {
            float ratio = (float)w / (float)svgImage.getViewportWidth();
            if ((float)svgImage.getViewportHeight() * ratio > (float)h) {
                ratio = (float)h / (float)svgImage.getViewportHeight();
            }
            int _w = Math.round((float)svgImage.getViewportWidth() * ratio);
            int _h = Math.round((float)svgImage.getViewportHeight() * ratio);
            svgImage.setViewportWidth(_w);
            svgImage.setViewportHeight(_h);
            assert (_w <= w);
            assert (_h <= h);
            ScalableGraphics sg = ScalableGraphics.createInstance();
            SVGSVGElement element = (SVGSVGElement)svgImage.getDocument().getDocumentElement();
            element.setCurrentTime(time);
            sg.bindTarget((Object)g);
            sg.render(xOffset + (w - _w) / 2, (h - _h) / 2, (ScalableImage)svgImage);
            sg.releaseTarget();
        }
        return buffer;
    }

    private static BufferedImage rasterizeFramesInSingleImage(SVGImage svgImage, Params params) throws IIOException {
        int frameNum = params.getNumberFrames();
        int w = params.getImageWidth();
        int h = params.getImageHeight();
        BufferedImage img = AnimationRasterizer.createBuffer(w * frameNum, h, params.isTransparent());
        for (int i = 0; i < frameNum; ++i) {
            AnimationRasterizer.rasterizeFrame(img, i * w, svgImage, params, params.getStartTime() + (float)i / params.getFramesPerSecond());
        }
        img = AnimationRasterizer.adjustImage(img, params);
        return img;
    }

    public static FileObject rasterizeImage(SVGImage svgImage, FileObject dir, String filenameRoot, Params params) throws IOException {
        FileObject file = null;
        int frameNum = params.getNumberFrames();
        if (params.isInSingleImage()) {
            BufferedImage img = AnimationRasterizer.rasterizeFramesInSingleImage(svgImage, params);
            String name = AnimationRasterizer.createFileName(filenameRoot, params, -1, -1);
            FileObject fo = dir.getFileObject(name);
            if (fo != null) {
                fo.delete();
            }
            fo = dir.createData(name);
            AnimationRasterizer.writeImageToFile(img, fo, params);
            file = fo;
        } else {
            for (int i = 0; i < frameNum; ++i) {
                BufferedImage img = AnimationRasterizer.rasterizeFrame(null, 0, svgImage, params, params.getStartTime() + (float)i / params.getFramesPerSecond());
                img = AnimationRasterizer.adjustImage(img, params);
                FileObject fo = dir.createData(AnimationRasterizer.createFileName(filenameRoot, params, i, frameNum));
                AnimationRasterizer.writeImageToFile(img, fo, params);
            }
        }
        return file;
    }

    static final String getMessage(String stringID) {
        return NbBundle.getMessage(AnimationRasterizer.class, (String)stringID);
    }

    private static int getEncodedSize(BufferedImage img, Params params) throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        AnimationRasterizer.encodeImage(img, bOut, params);
        return bOut.size();
    }

    private static void checkInterrupted() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }

    static int calculateAnimationSize(SVGImage svgImage, Params params, ProgressUpdater updater) throws IOException, InterruptedException {
        int size;
        int frameNum = params.getNumberFrames();
        if (params.isInSingleImage()) {
            int w = params.getImageWidth();
            int h = params.getImageHeight();
            BufferedImage img = AnimationRasterizer.createBuffer(w * frameNum, h, params.isTransparent());
            for (int i = 0; i < frameNum; ++i) {
                if (updater != null) {
                    updater.updateProgress(NbBundle.getMessage(AnimationRasterizer.class, (String)"LBL_PreviewRasterizing", (Object)String.valueOf(i), (Object)String.valueOf(frameNum)));
                }
                AnimationRasterizer.rasterizeFrame(img, i * w, svgImage, params, params.getStartTime() + (float)i / params.getFramesPerSecond());
            }
            AnimationRasterizer.checkInterrupted();
            if (updater != null) {
                updater.updateProgress(AnimationRasterizer.getMessage("LBL_PreviewEncoding"));
            }
            img = AnimationRasterizer.adjustImage(img, params);
            AnimationRasterizer.checkInterrupted();
            size = AnimationRasterizer.getEncodedSize(img, params);
            if (updater != null) {
                updater.updateProgress(AnimationRasterizer.getSizeText(size));
            }
        } else {
            size = 0;
            for (int i = 0; i < frameNum; ++i) {
                BufferedImage img = AnimationRasterizer.rasterizeFrame(null, 0, svgImage, params, params.getStartTime() + (float)i / params.getFramesPerSecond());
                AnimationRasterizer.checkInterrupted();
                img = AnimationRasterizer.adjustImage(img, params);
                AnimationRasterizer.checkInterrupted();
                size += AnimationRasterizer.getEncodedSize(img, params);
                AnimationRasterizer.checkInterrupted();
            }
        }
        return size;
    }

    public static String getSizeText(int size) {
        if (size < 1024) {
            return size + " Bytes";
        }
        if (size < 0x100000) {
            return (double)Math.round((double)size / 102.4) / 10.0 + " KBytes";
        }
        return (double)Math.round((double)size / 104857.6) / 10.0 + " MBytes";
    }

    private static BufferedImage reduceColorsMedianCut(BufferedImage image, Params params) {
        int w = image.getWidth();
        int h = image.getHeight();
        int[] pixels = new int[w * h];
        int i = 0;
        for (int x = 0; x < w; ++x) {
            for (int y = 0; y < h; ++y) {
                int rgb = image.getRGB(x, y);
                pixels[i++] = rgb >>> 24 > 127 ? rgb : pixels[0];
            }
        }
        Quantizer quantizer = new Quantizer(pixels, w, h);
        return quantizer.toImage();
    }

    private static BufferedImage reduceColorsQuantize(BufferedImage image, Params params) {
        int w = image.getWidth();
        int h = image.getHeight();
        int[][] pixels = new int[w][h];
        for (int x = 0; x < w; ++x) {
            for (int y = 0; y < h; ++y) {
                int rgb = image.getRGB(x, y);
                pixels[x][y] = rgb >>> 24 > 127 ? rgb : pixels[0][0];
            }
        }
        boolean isTransparent = params.isTransparent();
        int[] palette = ShrinkPalette.quantizeImage(pixels, isTransparent ? 255 : 256);
        byte[] red = new byte[256];
        byte[] green = new byte[265];
        byte[] blue = new byte[256];
        for (int i = 0; i < palette.length; ++i) {
            int rgb = palette[i];
            red[i] = (byte)((rgb & 0xFF0000) >> 16);
            green[i] = (byte)((rgb & 0xFF00) >> 8);
            blue[i] = (byte)(rgb & 0xFF);
        }
        int transparentColor = isTransparent ? 255 : -1;
        IndexColorModel colorModel = new IndexColorModel(8, 256, red, green, blue, transparentColor);
        BufferedImage bufferedImage = new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(w, h), false, null);
        WritableRaster raster = bufferedImage.getRaster();
        int[] pixelArray = new int[1];
        for (int x = 0; x < w; ++x) {
            for (int y = 0; y < h; ++y) {
                int pixel = image.getRGB(x, y);
                pixel = pixel >>> 24 > 127 ? pixels[x][y] : transparentColor;
                pixelArray[0] = pixel;
                raster.setPixel(x, y, pixelArray);
            }
        }
        return bufferedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeImageToFile(BufferedImage image, FileObject file, Params params) throws IOException {
        OutputStream fout = file.getOutputStream();
        try {
            AnimationRasterizer.encodeImage(image, fout, params);
            fout.flush();
        }
        finally {
            fout.close();
        }
    }

    private static void encodeImage(BufferedImage image, OutputStream out, Params params) throws IOException {
        Iterator<ImageWriter> writers = ImageIO.getImageWritersByFormatName(params.getImageType().getName());
        ImageWriter writer = writers.hasNext() ? writers.next() : null;
        ImageWriteParam imageWriteParam = writer.getDefaultWriteParam();
        if (imageWriteParam.canWriteProgressive()) {
            imageWriteParam.setProgressiveMode(params.isProgressive() ? 1 : 0);
        }
        if (imageWriteParam.canWriteCompressed()) {
            imageWriteParam.setCompressionMode(2);
            imageWriteParam.setCompressionQuality(params.getCompressionQuality());
        }
        ImageOutputStream ios = ImageIO.createImageOutputStream(out);
        writer.setOutput(ios);
        writer.write(null, new IIOImage(image, null, null), imageWriteParam);
        writer.dispose();
        ios.close();
    }

    private static BufferedImage decodeImage(InputStream in, Params params) throws IOException {
        Iterator<ImageReader> readers = ImageIO.getImageReadersByFormatName(params.getImageType().getName());
        ImageReader reader = readers.hasNext() ? readers.next() : null;
        ImageInputStream iis = ImageIO.createImageInputStream(in);
        reader.setInput(iis);
        BufferedImage img = reader.read(0);
        reader.dispose();
        iis.close();
        return img;
    }

    private static String getActiveConfigurationName(FileObject primaryFile) {
        Project p = FileOwnerQuery.getOwner((FileObject)primaryFile);
        if (p == null || !(p instanceof J2MEProject)) {
            return "";
        }
        return AnimationRasterizer.getDefaultName((J2MEProject)p);
    }

    private static String getDefaultName(J2MEProject project) {
        AntProjectHelper helper = (AntProjectHelper)project.getLookup().lookup(AntProjectHelper.class);
        EditableProperties ep = helper.getProperties("nbproject/project.properties");
        ProjectConfigurationsHelper confs = project.getConfigurationHelper();
        return confs.getActiveConfiguration() != confs.getDefaultConfiguration() ? "_" + confs.getActiveConfiguration().getDisplayName() : "";
    }

    static interface ProgressUpdater {
        public void updateProgress(String var1);
    }

    public static class PreviewInfo {
        final BufferedImage m_image;
        final String m_imageFormat;
        final int m_imageSize;

        private PreviewInfo(BufferedImage image, String format, int size) {
            this.m_image = image;
            this.m_imageFormat = format;
            this.m_imageSize = size;
        }
    }

    public static interface Params {
        public SVGImage getSVGImage() throws IOException, BadLocationException;

        public int getImageWidth();

        public int getImageHeight();

        public float getStartTime();

        public float getEndTime();

        public float getFramesPerSecond();

        public boolean isForAllConfigurations();

        public double getRatio();

        public float getCompressionQuality();

        public boolean isProgressive();

        public boolean isInSingleImage();

        public boolean isTransparent();

        public ImageType getImageType();

        public void setImageWidth(int var1);

        public void setImageHeight(int var1);

        public int getNumberFrames();

        public J2MEProject getProject();

        public String getElementId();

        public ColorReductionMethod getColorReductionMethod();
    }

    public static enum ImageType {
        JPEG("JPG", "JPEG", true, false, false, ".jpg"),
        PNG8("PNG", "PNG-8", false, true, true, ".png"),
        PNG24("PNG", "PNG-24", false, true, false, ".png");

        private final String m_name;
        private final String m_displayName;
        private final boolean m_supportsCompression;
        private final boolean m_supportsTransparency;
        private final String m_extension;
        private final boolean m_colorReduction;

        private ImageType(String name, String displayName, boolean supportsCompression, boolean supportsTransparency, boolean colorReduction, String extension) {
            this.m_name = name;
            this.m_displayName = displayName;
            this.m_supportsCompression = supportsCompression;
            this.m_supportsTransparency = supportsTransparency;
            this.m_colorReduction = colorReduction;
            this.m_extension = extension;
        }

        public boolean supportsCompression() {
            return this.m_supportsCompression;
        }

        public boolean supportsTransparency() {
            return this.m_supportsTransparency;
        }

        public boolean needsColorReduction() {
            return this.m_colorReduction;
        }

        public String getName() {
            return this.m_name;
        }

        public String toString() {
            return this.m_displayName;
        }

        public String getFileName(String filename) {
            String ext;
            String str = filename.toLowerCase();
            if (!str.endsWith(ext = ".svg") && !str.endsWith(ext = ".svgz")) {
                ext = "";
            }
            filename = filename.substring(0, filename.length() - ext.length()) + this.m_extension;
            return filename;
        }
    }

    public static enum ColorReductionMethod implements ColorReducer
    {
        QUANTIZE(AnimationRasterizer.getMessage("LBL_ColorReductionColorQuantization")){

            @Override
            public BufferedImage reduceColors(BufferedImage image, Params params) {
                return AnimationRasterizer.reduceColorsQuantize(image, params);
            }
        }
        ,
        MEDIAN_CUT(AnimationRasterizer.getMessage("LBL_ColorReductionMedianCut")){

            @Override
            public BufferedImage reduceColors(BufferedImage image, Params params) {
                return AnimationRasterizer.reduceColorsMedianCut(image, params);
            }
        };

        private final String m_displayName;

        private ColorReductionMethod(String displayName) {
            this.m_displayName = displayName;
        }

        public String toString() {
            return this.m_displayName;
        }
    }

    private static interface ColorReducer {
        public BufferedImage reduceColors(BufferedImage var1, Params var2);
    }

    public static final class CompressionLevel
    extends Enum<CompressionLevel> {
        public static final /* enum */ CompressionLevel MAXIMUM = new CompressionLevel(AnimationRasterizer.getMessage("LBL_CompressionMaximum"), 10);
        public static final /* enum */ CompressionLevel VERY_HIGH = new CompressionLevel(AnimationRasterizer.getMessage("LBL_CompressionVeryHigh"), 30);
        public static final /* enum */ CompressionLevel HIGH = new CompressionLevel(AnimationRasterizer.getMessage("LBL_CompressionHigh"), 40);
        public static final /* enum */ CompressionLevel MEDIUM = new CompressionLevel(AnimationRasterizer.getMessage("LBL_CompressionMedium"), 60);
        public static final /* enum */ CompressionLevel LOW = new CompressionLevel(AnimationRasterizer.getMessage("LBL_CompressionLow"), 80);
        public static final /* enum */ CompressionLevel MINIMUM = new CompressionLevel(AnimationRasterizer.getMessage("LBL_CompressionMinimum"), 99);
        private final String m_name;
        private final int m_rate;
        private static final /* synthetic */ CompressionLevel[] $VALUES;

        public static CompressionLevel[] values() {
            return (CompressionLevel[])$VALUES.clone();
        }

        public static CompressionLevel valueOf(String name) {
            return Enum.valueOf(CompressionLevel.class, name);
        }

        private CompressionLevel(String name, int rate) {
            this.m_name = name;
            this.m_rate = rate;
        }

        public String toString() {
            return this.m_name;
        }

        public int getRate() {
            return this.m_rate;
        }

        public static CompressionLevel getLevel(int rate) {
            assert (rate >= 0 && rate <= 99);
            for (CompressionLevel level : CompressionLevel.values()) {
                if (rate > level.getRate()) continue;
                return level;
            }
            assert (false) : "Could not find compression level for rate: " + rate;
            return MINIMUM;
        }

        static {
            $VALUES = new CompressionLevel[]{MAXIMUM, VERY_HIGH, HIGH, MEDIUM, LOW, MINIMUM};
        }
    }
}

