/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Column;
import org.hsqldb.Function;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Index;
import org.hsqldb.Library;
import org.hsqldb.Like;
import org.hsqldb.NumberSequence;
import org.hsqldb.Result;
import org.hsqldb.Row;
import org.hsqldb.Select;
import org.hsqldb.Session;
import org.hsqldb.SetFunction;
import org.hsqldb.SubQuery;
import org.hsqldb.Table;
import org.hsqldb.TableFilter;
import org.hsqldb.Trace;
import org.hsqldb.Types;
import org.hsqldb.index.RowIterator;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.store.ValuePool;

public class Expression {
    static final int VALUE = 1;
    static final int COLUMN = 2;
    static final int QUERY = 3;
    static final int TRUE = 4;
    static final int FALSE = -4;
    static final int VALUELIST = 5;
    static final int ASTERISK = 6;
    static final int FUNCTION = 7;
    static final int LIMIT = 8;
    static final int ROW = 9;
    static final int PARAM = 9;
    static final int NEGATE = 10;
    static final int ADD = 11;
    static final int SUBTRACT = 12;
    static final int MULTIPLY = 13;
    static final int DIVIDE = 14;
    static final int CONCAT = 15;
    static final int NOT = 20;
    static final int EQUAL = 21;
    static final int BIGGER_EQUAL = 22;
    static final int BIGGER = 23;
    static final int SMALLER = 24;
    static final int SMALLER_EQUAL = 25;
    static final int NOT_EQUAL = 26;
    static final int LIKE = 27;
    static final int AND = 28;
    static final int OR = 29;
    static final int IN = 30;
    static final int EXISTS = 31;
    static final int ALL = 32;
    static final int ANY = 33;
    static final int IS_NULL = 34;
    static final int COUNT = 40;
    static final int SUM = 41;
    static final int MIN = 42;
    static final int MAX = 43;
    static final int AVG = 44;
    static final int EVERY = 45;
    static final int SOME = 46;
    static final int STDDEV_POP = 47;
    static final int STDDEV_SAMP = 48;
    static final int VAR_POP = 49;
    static final int VAR_SAMP = 50;
    static final int IFNULL = 60;
    static final int CONVERT = 61;
    static final int CASEWHEN = 62;
    static final int EXTRACT = 63;
    static final int POSITION = 64;
    static final int TRIM = 65;
    static final int SUBSTRING = 66;
    static final int NULLIF = 67;
    static final int CASE = 68;
    static final int COALESCE = 69;
    static final int ALTERNATIVE = 70;
    static final int SEQUENCE = 71;
    static final int PLUS = 100;
    static final int OPEN = 101;
    static final int CLOSE = 102;
    static final int SELECT = 103;
    static final int COMMA = 104;
    static final int BETWEEN = 106;
    static final int CAST = 107;
    static final int END = 108;
    static final int IS = 109;
    static final int WHEN = 110;
    static final int THEN = 111;
    static final int ELSE = 112;
    static final int ENDWHEN = 113;
    static final int DISTINCT = 114;
    static final int VIEW = 115;
    static final int AS = 122;
    static final int FOR = 123;
    static final int FROM = 124;
    static final int BOTH = 125;
    static final int LEADING = 126;
    static final int TRAILING = 127;
    static final int YEAR = 128;
    static final int MONTH = 129;
    static final int DAY = 130;
    static final int HOUR = 131;
    static final int MINUTE = 132;
    static final int SECOND = 133;
    static final int TIMEZONE_HOUR = 134;
    static final int T_TIMEZONE_MINUTE = 135;
    static final int DOW = 136;
    static final HashSet SQL_EXTRACT_FIELD_NAMES = new HashSet();
    static final HashSet SQL_TRIM_SPECIFICATION = new HashSet();
    private static final int AGGREGATE_SELF = -1;
    private static final int AGGREGATE_NONE = 0;
    private static final int AGGREGATE_LEFT = 1;
    private static final int AGGREGATE_RIGHT = 2;
    private static final int AGGREGATE_BOTH = 3;
    private static final int AGGREGATE_FUNCTION = 4;
    int exprType;
    private int aggregateSpec = 0;
    Expression eArg;
    Expression eArg2;
    Object valueData;
    private int dataType;
    HashSet hList;
    Expression[] valueList;
    private boolean isFixedConstantValueList;
    SubQuery subQuery;
    boolean isQueryCorrelated;
    Function function;
    private Like likeObject;
    private String catalog;
    private String schema;
    private String tableName;
    private String columnName;
    private TableFilter tableFilter;
    TableFilter outerFilter;
    private int columnIndex;
    private boolean columnQuoted;
    private int precision;
    private int scale;
    private String columnAlias;
    private boolean aliasQuoted;
    private boolean isDescending;
    int joinedTableColumnIndex = -1;
    boolean isDistinctAggregate;
    private boolean isParam;
    boolean isInJoin;
    static final Integer INTEGER_0;
    static final Integer INTEGER_1;
    int oldIType = -1;
    static final int PARAM_UNKNOWN = 0;
    public static final int PARAM_IN = 1;
    public static final int PARAM_IN_OUT = 2;
    public static final int PARAM_OUT = 4;
    static final int NO_NULLS = 0;
    static final int NULLABLE = 1;
    static final int NULLABLE_UNKNOWN = 2;
    boolean isIdentity;
    int nullability = 2;
    boolean isWritable;
    int paramMode = 0;
    String valueClassName;

    Expression(boolean bl) {
        this.exprType = bl ? 4 : -4;
    }

    Expression(Function function) {
        this.exprType = 7;
        this.function = function;
        if (function.hasAggregate) {
            this.aggregateSpec = 4;
        }
    }

    Expression(NumberSequence numberSequence) {
        this.exprType = 71;
        this.valueData = numberSequence;
        this.dataType = numberSequence.getType();
    }

    Expression(Expression expression) {
        this.exprType = expression.exprType;
        this.dataType = expression.dataType;
        this.eArg = expression.eArg;
        this.eArg2 = expression.eArg2;
        this.isInJoin = expression.isInJoin;
        this.likeObject = expression.likeObject;
        this.subQuery = expression.subQuery;
        this.function = expression.function;
        this.checkAggregate();
    }

    Expression(SubQuery subQuery) {
        this.exprType = 3;
        this.subQuery = subQuery;
    }

    Expression(Expression[] expressionArray) {
        this.exprType = 5;
        this.valueList = expressionArray;
    }

    Expression(int n, Expression expression, Expression expression2) {
        this.exprType = n;
        this.eArg = expression;
        this.eArg2 = expression2;
        this.checkAggregate();
    }

    Expression(Expression expression, int n, int n2, int n3) {
        this.exprType = 61;
        this.eArg = expression;
        this.dataType = n;
        this.precision = n2;
        this.scale = n3;
        this.columnAlias = expression.columnAlias;
        this.aliasQuoted = expression.aliasQuoted;
        this.checkAggregate();
    }

    Expression(Expression expression, Expression expression2, Character c, boolean bl) {
        this.exprType = 27;
        this.eArg = expression;
        this.eArg2 = expression2;
        this.likeObject = new Like(c, bl);
        this.checkAggregate();
    }

    Expression(String string, String string2, String string3) {
        this.schema = string;
        this.tableName = string2;
        if (string3 == null) {
            this.exprType = 6;
        } else {
            this.exprType = 2;
            this.columnName = string3;
        }
    }

    Expression(String string, String string2, boolean bl) {
        this.tableName = string;
        if (string2 == null) {
            this.exprType = 6;
        } else {
            this.exprType = 2;
            this.columnName = string2;
            this.columnQuoted = bl;
        }
    }

    Expression(TableFilter tableFilter, Column column) {
        this.schema = tableFilter.filterTable.tableName.schema.name;
        this.tableName = tableFilter.getName();
        if (column == null) {
            this.exprType = 6;
        } else {
            this.exprType = 2;
            this.columnName = column.columnName.name;
            this.columnQuoted = column.columnName.isNameQuoted;
            this.dataType = column.getType();
        }
    }

    Expression(int n, Object object) {
        this.exprType = 1;
        this.dataType = n;
        this.valueData = object;
    }

    Expression(int n, Object object, boolean bl) {
        this(n, object);
        this.isParam = bl;
        if (bl) {
            this.paramMode = 1;
        }
    }

    boolean isTypeEqual(Expression expression) {
        return this.dataType == expression.dataType && this.precision == expression.precision && this.scale == expression.scale;
    }

    private void checkAggregate() {
        if (Expression.isAggregate(this.exprType)) {
            this.aggregateSpec = -1;
        } else {
            this.aggregateSpec = 0;
            if (this.eArg != null && this.eArg.isAggregate()) {
                ++this.aggregateSpec;
            }
            if (this.eArg2 != null && this.eArg2.isAggregate()) {
                this.aggregateSpec += 2;
            }
        }
    }

    public String describe(Session session) {
        return this.describe(session, 0);
    }

    static String getContextDDL(Expression expression) throws HsqlException {
        String string = expression.getDDL();
        if (expression.exprType != 1 && expression.exprType != 2 && expression.exprType != 7 && expression.exprType != 70 && expression.exprType != 62 && expression.exprType != 61) {
            StringBuffer stringBuffer = new StringBuffer();
            string = stringBuffer.append('(').append(string).append(')').toString();
        }
        return string;
    }

    String getDDL() throws HsqlException {
        StringBuffer stringBuffer = new StringBuffer(64);
        String string = null;
        String string2 = null;
        if (this.eArg != null) {
            string = Expression.getContextDDL(this.eArg);
        }
        if (this.eArg2 != null) {
            string2 = Expression.getContextDDL(this.eArg2);
        }
        switch (this.exprType) {
            case 7: {
                return this.function.getDLL();
            }
            case 1: {
                try {
                    return this.isParam ? "?" : Column.createSQLString(this.valueData, this.dataType);
                }
                catch (HsqlException hsqlException) {
                    return stringBuffer.toString();
                }
            }
            case 2: {
                Table table = this.tableFilter.getTable();
                if (this.tableName != null) {
                    stringBuffer.append(table.tableName.statementName);
                    stringBuffer.append('.');
                }
                stringBuffer.append(table.getColumn((int)this.columnIndex).columnName.statementName);
                return stringBuffer.toString();
            }
            case 4: {
                return "TRUE";
            }
            case -4: {
                return "FALSE";
            }
            case 5: {
                for (int i = 0; i < this.valueList.length; ++i) {
                    stringBuffer.append(this.valueList[i].getDDL());
                    if (i >= this.valueList.length - 1) continue;
                    stringBuffer.append(',');
                }
                return stringBuffer.toString();
            }
            case 6: {
                stringBuffer.append('*');
                return stringBuffer.toString();
            }
            case 10: {
                stringBuffer.append('-').append(string);
                return stringBuffer.toString();
            }
            case 11: {
                stringBuffer.append(string).append('+').append(string2);
                return stringBuffer.toString();
            }
            case 12: {
                stringBuffer.append(string).append('-').append(string2);
                return stringBuffer.toString();
            }
            case 13: {
                stringBuffer.append(string).append('*').append(string2);
                return stringBuffer.toString();
            }
            case 14: {
                stringBuffer.append(string).append('/').append(string2);
                return stringBuffer.toString();
            }
            case 15: {
                stringBuffer.append(string).append("||").append(string2);
                return stringBuffer.toString();
            }
            case 20: {
                if (this.eArg.exprType == 34) {
                    stringBuffer.append(Expression.getContextDDL(this.eArg.eArg)).append(' ').append("IS").append(' ').append("NOT").append(' ').append("NULL");
                    return stringBuffer.toString();
                }
                stringBuffer.append("NOT").append(' ').append(string);
                return stringBuffer.toString();
            }
            case 21: {
                stringBuffer.append(string).append('=').append(string2);
                return stringBuffer.toString();
            }
            case 22: {
                stringBuffer.append(string).append(">=").append(string2);
                return stringBuffer.toString();
            }
            case 23: {
                stringBuffer.append(string).append('>').append(string2);
                return stringBuffer.toString();
            }
            case 24: {
                stringBuffer.append(string).append('<').append(string2);
                return stringBuffer.toString();
            }
            case 25: {
                stringBuffer.append(string).append("<=").append(string2);
                return stringBuffer.toString();
            }
            case 26: {
                if ("NULL".equals(string2)) {
                    stringBuffer.append(string).append(" IS NOT ").append(string2);
                } else {
                    stringBuffer.append(string).append("!=").append(string2);
                }
                return stringBuffer.toString();
            }
            case 27: {
                stringBuffer.append(string).append(' ').append("LIKE").append(' ');
                stringBuffer.append(string2);
                if (this.likeObject.escapeChar != null) {
                    stringBuffer.append(' ').append("ESCAPE").append(' ').append('\'');
                    stringBuffer.append(this.likeObject.escapeChar.toString()).append('\'');
                    stringBuffer.append(' ');
                }
                return stringBuffer.toString();
            }
            case 28: {
                stringBuffer.append(string).append(' ').append("AND").append(' ').append(string2);
                return stringBuffer.toString();
            }
            case 29: {
                stringBuffer.append(string).append(' ').append("OR").append(' ').append(string2);
                return stringBuffer.toString();
            }
            case 32: {
                stringBuffer.append(string).append(' ').append("ALL").append(' ').append(string2);
                return stringBuffer.toString();
            }
            case 33: {
                stringBuffer.append(string).append(' ').append("ANY").append(' ').append(string2);
                return stringBuffer.toString();
            }
            case 30: {
                stringBuffer.append(string).append(' ').append("IN").append(' ').append(string2);
                return stringBuffer.toString();
            }
            case 61: {
                stringBuffer.append(' ').append("CONVERT").append('(');
                stringBuffer.append(string).append(',');
                stringBuffer.append(Types.getTypeString(this.dataType, this.precision, this.scale));
                stringBuffer.append(')');
                return stringBuffer.toString();
            }
            case 62: {
                stringBuffer.append(' ').append("CASEWHEN").append('(');
                stringBuffer.append(string).append(',').append(string2).append(')');
                return stringBuffer.toString();
            }
            case 34: {
                stringBuffer.append(string).append(' ').append("IS").append(' ').append("NULL");
                return stringBuffer.toString();
            }
            case 70: {
                stringBuffer.append(string).append(',').append(string2);
                return stringBuffer.toString();
            }
            case 3: {
                break;
            }
            case 31: {
                stringBuffer.append(' ').append("EXISTS").append(' ');
                break;
            }
            case 40: {
                stringBuffer.append(' ').append("COUNT").append('(');
                break;
            }
            case 41: {
                stringBuffer.append(' ').append("SUM").append('(');
                stringBuffer.append(string).append(')');
                break;
            }
            case 42: {
                stringBuffer.append(' ').append("MIN").append('(');
                stringBuffer.append(string).append(')');
                break;
            }
            case 43: {
                stringBuffer.append(' ').append("MAX").append('(');
                stringBuffer.append(string).append(')');
                break;
            }
            case 44: {
                stringBuffer.append(' ').append("AVG").append('(');
                stringBuffer.append(string).append(')');
                break;
            }
            case 45: {
                stringBuffer.append(' ').append("EVERY").append('(');
                stringBuffer.append(string).append(')');
                break;
            }
            case 46: {
                stringBuffer.append(' ').append("SOME").append('(');
                stringBuffer.append(string).append(')');
                break;
            }
            case 47: {
                stringBuffer.append(' ').append("STDDEV_POP").append('(');
                stringBuffer.append(string).append(')');
                break;
            }
            case 48: {
                stringBuffer.append(' ').append("STDDEV_SAMP").append('(');
                stringBuffer.append(string).append(')');
                break;
            }
            case 49: {
                stringBuffer.append(' ').append("VAR_POP").append('(');
                stringBuffer.append(string).append(')');
                break;
            }
            case 50: {
                stringBuffer.append(' ').append("VAR_SAMP").append('(');
                stringBuffer.append(string).append(')');
            }
        }
        throw Trace.error(99);
    }

    private String describe(Session session, int n) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append('\n');
        for (n2 = 0; n2 < n; ++n2) {
            stringBuffer.append(' ');
        }
        if (this.oldIType != -1) {
            stringBuffer.append("SET TRUE, WAS: ");
        }
        int n3 = this.oldIType == -1 ? this.exprType : this.oldIType;
        switch (n3) {
            case 7: {
                stringBuffer.append("FUNCTION ");
                stringBuffer.append(this.function.describe(session));
                return stringBuffer.toString();
            }
            case 1: {
                if (this.isParam) {
                    stringBuffer.append("PARAM ");
                }
                stringBuffer.append("VALUE = ").append(this.valueData);
                stringBuffer.append(", TYPE = ").append(Types.getTypeString(this.dataType));
                return stringBuffer.toString();
            }
            case 2: {
                stringBuffer.append("COLUMN ");
                if (this.tableName != null) {
                    stringBuffer.append(this.tableName);
                    stringBuffer.append('.');
                }
                stringBuffer.append(this.columnName);
                return stringBuffer.toString();
            }
            case 3: {
                stringBuffer.append("QUERY ");
                stringBuffer.append(this.subQuery.select.describe(session));
                return stringBuffer.toString();
            }
            case 4: {
                stringBuffer.append("TRUE ");
                break;
            }
            case -4: {
                stringBuffer.append("FALSE ");
                break;
            }
            case 5: {
                stringBuffer.append("VALUELIST ");
                stringBuffer.append(" TYPE = ").append(Types.getTypeString(this.dataType));
                if (this.valueList == null) break;
                for (n2 = 0; n2 < this.valueList.length; ++n2) {
                    stringBuffer.append(this.valueList[n2].describe(session, n + n));
                    stringBuffer.append(' ');
                }
                break;
            }
            case 6: {
                stringBuffer.append("* ");
                break;
            }
            case 10: {
                stringBuffer.append("NEGATE ");
                break;
            }
            case 11: {
                stringBuffer.append("ADD ");
                break;
            }
            case 12: {
                stringBuffer.append("SUBTRACT ");
                break;
            }
            case 13: {
                stringBuffer.append("MULTIPLY ");
                break;
            }
            case 14: {
                stringBuffer.append("DIVIDE ");
                break;
            }
            case 15: {
                stringBuffer.append("CONCAT ");
                break;
            }
            case 20: {
                stringBuffer.append("NOT ");
                break;
            }
            case 21: {
                stringBuffer.append("EQUAL ");
                break;
            }
            case 22: {
                stringBuffer.append("BIGGER_EQUAL ");
                break;
            }
            case 23: {
                stringBuffer.append("BIGGER ");
                break;
            }
            case 24: {
                stringBuffer.append("SMALLER ");
                break;
            }
            case 25: {
                stringBuffer.append("SMALLER_EQUAL ");
                break;
            }
            case 26: {
                stringBuffer.append("NOT_EQUAL ");
                break;
            }
            case 27: {
                stringBuffer.append("LIKE ");
                stringBuffer.append(this.likeObject.describe(session));
                break;
            }
            case 28: {
                stringBuffer.append("AND ");
                break;
            }
            case 29: {
                stringBuffer.append("OR ");
                break;
            }
            case 32: {
                stringBuffer.append("ALL ");
                break;
            }
            case 33: {
                stringBuffer.append("ANY ");
                break;
            }
            case 30: {
                stringBuffer.append("IN ");
                break;
            }
            case 34: {
                stringBuffer.append("IS_NULL ");
                break;
            }
            case 31: {
                stringBuffer.append("EXISTS ");
                break;
            }
            case 40: {
                stringBuffer.append("COUNT ");
                break;
            }
            case 41: {
                stringBuffer.append("SUM ");
                break;
            }
            case 42: {
                stringBuffer.append("MIN ");
                break;
            }
            case 43: {
                stringBuffer.append("MAX ");
                break;
            }
            case 44: {
                stringBuffer.append("AVG ");
                break;
            }
            case 45: {
                stringBuffer.append("EVERY").append(' ');
                break;
            }
            case 46: {
                stringBuffer.append("SOME").append(' ');
                break;
            }
            case 47: {
                stringBuffer.append("STDDEV_POP").append(' ');
                break;
            }
            case 48: {
                stringBuffer.append("STDDEV_SAMP").append(' ');
                break;
            }
            case 49: {
                stringBuffer.append("VAR_POP").append(' ');
                break;
            }
            case 50: {
                stringBuffer.append("VAR_SAMP").append(' ');
                break;
            }
            case 61: {
                stringBuffer.append("CONVERT ");
                stringBuffer.append(Types.getTypeString(this.dataType, this.precision, this.scale));
                stringBuffer.append(' ');
                break;
            }
            case 62: {
                stringBuffer.append("CASEWHEN ");
            }
        }
        if (this.isInJoin) {
            stringBuffer.append(" join");
        }
        if (this.eArg != null) {
            stringBuffer.append(" arg1=[");
            stringBuffer.append(this.eArg.describe(session, n + 1));
            stringBuffer.append(']');
        }
        if (this.eArg2 != null) {
            stringBuffer.append(" arg2=[");
            stringBuffer.append(this.eArg2.describe(session, n + 1));
            stringBuffer.append(']');
        }
        return stringBuffer.toString();
    }

    void setDataType(int n) {
        this.dataType = n;
    }

    void setTrue() {
        if (this.oldIType == -1) {
            this.oldIType = this.exprType;
        }
        this.exprType = 4;
    }

    void setNull() {
        this.isParam = false;
        this.exprType = 1;
        this.dataType = 0;
        this.valueData = null;
        this.eArg = null;
        this.eArg2 = null;
    }

    public boolean similarTo(Expression expression) {
        if (expression == null) {
            return false;
        }
        if (expression == this) {
            return true;
        }
        return this.exprType == expression.exprType && this.dataType == expression.dataType && Expression.equals(this.valueData, expression.valueData) && Expression.equals(this.valueList, expression.valueList) && Expression.equals(this.subQuery, expression.subQuery) && Expression.equals(this.function, expression.function) && Expression.equals(this.tableName, expression.tableName) && Expression.equals(this.columnName, expression.columnName) && Expression.similarTo(this.eArg, expression.eArg) && Expression.similarTo(this.eArg2, expression.eArg2);
    }

    static boolean equals(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    static boolean equals(Expression[] expressionArray, Expression[] expressionArray2) {
        if (expressionArray == expressionArray2) {
            return true;
        }
        if (expressionArray.length != expressionArray2.length) {
            return false;
        }
        int n = expressionArray.length;
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            Expression expression = expressionArray[i];
            Expression expression2 = expressionArray2[i];
            bl = expression == null ? expression2 == null : expression.equals(expression2);
        }
        return bl;
    }

    static boolean similarTo(Expression expression, Expression expression2) {
        return expression == null ? expression2 == null : expression.similarTo(expression2);
    }

    boolean canBeInGroupBy() {
        if (this.exprType == 7) {
            return true;
        }
        return this.isColumn() && !this.isAggregate();
    }

    boolean canBeInOrderBy() {
        return this.exprType == 7 || this.joinedTableColumnIndex != -1 || this.isColumn() || this.isAggregate();
    }

    private boolean isColumn() {
        switch (this.exprType) {
            case 2: {
                return true;
            }
            case 10: {
                return this.eArg.isColumn();
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                return this.eArg.isColumn() || this.eArg2.isColumn();
            }
        }
        return false;
    }

    boolean collectColumnName(HashSet hashSet) {
        boolean bl;
        boolean bl2 = bl = this.exprType == 2;
        if (bl) {
            hashSet.add(this.columnName);
        }
        return bl;
    }

    void collectAllColumnNames(HashSet hashSet) {
        if (!this.collectColumnName(hashSet)) {
            if (this.eArg != null) {
                this.eArg.collectAllColumnNames(hashSet);
            }
            if (this.eArg2 != null) {
                this.eArg2.collectAllColumnNames(hashSet);
            }
        }
    }

    boolean isConstant() {
        switch (this.exprType) {
            case 1: {
                return true;
            }
            case 10: {
                return this.eArg.isConstant();
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                return this.eArg.isConstant() && this.eArg2.isConstant();
            }
        }
        return false;
    }

    boolean canBeInAggregate() {
        return this.isAggregate() || this.isConstant();
    }

    boolean isAggregate() {
        return this.aggregateSpec != 0;
    }

    boolean isSelfAggregate() {
        return this.aggregateSpec == -1;
    }

    static boolean isAggregate(int n) {
        switch (n) {
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                return true;
            }
        }
        return false;
    }

    boolean isConditional() {
        switch (this.exprType) {
            case -4: 
            case 4: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 34: {
                return true;
            }
            case 20: {
                return this.eArg.isConditional();
            }
            case 28: 
            case 29: {
                return this.eArg.isConditional() && this.eArg2.isConditional();
            }
        }
        return false;
    }

    void collectInGroupByExpressions(HsqlArrayList hsqlArrayList) {
        if (!this.isConstant() && !this.isSelfAggregate()) {
            if (this.isColumn()) {
                hsqlArrayList.add(this);
            } else if (this.exprType != 7) {
                if (this.exprType == 62) {
                    this.eArg2.collectInGroupByExpressions(hsqlArrayList);
                } else {
                    if (this.eArg != null) {
                        this.eArg.collectInGroupByExpressions(hsqlArrayList);
                    }
                    if (this.eArg2 != null) {
                        this.eArg2.collectInGroupByExpressions(hsqlArrayList);
                    }
                }
            }
        }
    }

    void setDescending() {
        this.isDescending = true;
    }

    boolean isDescending() {
        return this.isDescending;
    }

    void setAlias(String string, boolean bl) {
        this.columnAlias = string;
        this.aliasQuoted = bl;
    }

    void setColumnName(String string, boolean bl) {
        this.columnName = string;
        this.columnQuoted = bl;
    }

    void setTableName(String string) {
        this.tableName = string;
    }

    String getDefinedAlias() {
        return this.columnAlias;
    }

    String getAlias() {
        if (this.columnAlias != null) {
            return this.columnAlias;
        }
        if (this.exprType == 2) {
            return this.columnName;
        }
        return "";
    }

    boolean isAliasQuoted() {
        if (this.columnAlias != null) {
            return this.aliasQuoted;
        }
        if (this.exprType == 2) {
            return this.columnQuoted;
        }
        return false;
    }

    int getType() {
        return this.exprType;
    }

    Expression getArg() {
        return this.eArg;
    }

    Expression getArg2() {
        return this.eArg2;
    }

    TableFilter getFilter() {
        return this.tableFilter;
    }

    boolean checkResolved(boolean bl) throws HsqlException {
        boolean bl2 = true;
        if (this.eArg != null) {
            boolean bl3 = bl2 = bl2 && this.eArg.checkResolved(bl);
        }
        if (this.eArg2 != null) {
            boolean bl4 = bl2 = bl2 && this.eArg2.checkResolved(bl);
        }
        if (this.subQuery != null && this.subQuery.select != null) {
            boolean bl5 = bl2 = bl2 && this.subQuery.select.checkResolved(bl);
        }
        if (this.function != null) {
            boolean bl6 = bl2 = bl2 && this.function.checkResolved(bl);
        }
        if (this.valueList != null) {
            for (int i = 0; i < this.valueList.length; ++i) {
                bl2 = bl2 && this.valueList[i].checkResolved(bl);
            }
        }
        if (this.exprType == 2) {
            if (this.tableFilter == null) {
                boolean bl7 = bl2 = this.joinedTableColumnIndex != -1;
                if (!bl2 && bl) {
                    String string = this.tableName == null ? this.columnName : this.tableName + "." + this.columnName;
                    throw Trace.error(28, string);
                }
            } else {
                this.tableFilter.usedColumns[this.columnIndex] = true;
            }
        }
        return bl2;
    }

    void checkTables(HsqlArrayList hsqlArrayList) throws HsqlException {
        if (hsqlArrayList == null || this.exprType == 1) {
            return;
        }
        if (this.eArg != null) {
            this.eArg.checkTables(hsqlArrayList);
        }
        if (this.eArg2 != null) {
            this.eArg2.checkTables(hsqlArrayList);
        }
        switch (this.exprType) {
            case 2: {
                boolean bl = false;
                int n = hsqlArrayList.size();
                for (int i = 0; i < n; ++i) {
                    Table table;
                    int n2;
                    TableFilter tableFilter = (TableFilter)hsqlArrayList.get(i);
                    String string = tableFilter.getName();
                    if (this.tableName != null && !string.equals(this.tableName) || (n2 = (table = tableFilter.getTable()).findColumn(this.columnName)) == -1) continue;
                    if (this.tableName == null) {
                        if (bl) {
                            throw Trace.error(156, this.columnName);
                        }
                        bl = true;
                        continue;
                    }
                    return;
                }
                if (bl) {
                    return;
                }
                throw Trace.error(28, this.columnName);
            }
            case 3: {
                break;
            }
            case 7: {
                if (this.function == null) break;
                this.function.checkTables(hsqlArrayList);
                break;
            }
            case 32: 
            case 33: {
                break;
            }
            case 30: {
                if (this.eArg2.exprType == 3) break;
                Expression[] expressionArray = this.eArg2.valueList;
                for (int i = 0; i < expressionArray.length; ++i) {
                    expressionArray[i].checkTables(hsqlArrayList);
                }
                break;
            }
        }
    }

    Expression getExpressionForAlias(Expression[] expressionArray, int n) {
        for (int i = 0; i < n; ++i) {
            if (!this.columnName.equals(expressionArray[i].columnAlias) || this.tableName != null && !this.tableName.equals(expressionArray[i].tableName)) continue;
            return expressionArray[i];
        }
        return this;
    }

    void replaceAliases(Expression[] expressionArray, int n) throws HsqlException {
        if (this.eArg != null) {
            if (this.eArg.exprType == 2) {
                this.eArg = this.eArg.getExpressionForAlias(expressionArray, n);
            } else {
                this.eArg.replaceAliases(expressionArray, n);
            }
        }
        if (this.eArg2 != null) {
            if (this.eArg2.exprType == 2) {
                this.eArg2 = this.eArg2.getExpressionForAlias(expressionArray, n);
            } else {
                this.eArg2.replaceAliases(expressionArray, n);
            }
        }
        switch (this.exprType) {
            case 3: {
                break;
            }
            case 7: {
                if (this.function == null) break;
                this.function.replaceAliases(expressionArray, n);
                break;
            }
            case 32: 
            case 33: {
                break;
            }
            case 30: {
                if (this.eArg2.exprType == 3) break;
                Expression[] expressionArray2 = this.eArg2.valueList;
                for (int i = 0; i < expressionArray2.length; ++i) {
                    if (expressionArray2[i].exprType == 2) {
                        expressionArray2[i] = expressionArray2[i].getExpressionForAlias(expressionArray, n);
                        continue;
                    }
                    expressionArray2[i].replaceAliases(expressionArray, n);
                }
                break;
            }
        }
    }

    void setLikeOptimised() throws HsqlException {
        if (this.eArg != null) {
            this.eArg.setLikeOptimised();
        }
        if (this.eArg2 != null) {
            this.eArg2.setLikeOptimised();
        }
        if (this.exprType == 27) {
            this.likeObject.optimised = true;
        }
    }

    void getEquiJoinColumns(TableFilter tableFilter, boolean[] blArray, Expression[] expressionArray) {
        if (this.eArg != null) {
            this.eArg.getEquiJoinColumns(tableFilter, blArray, expressionArray);
        }
        if (this.eArg2 != null) {
            this.eArg2.getEquiJoinColumns(tableFilter, blArray, expressionArray);
        }
        if (this.exprType == 21) {
            if (this.eArg.tableFilter == this.eArg2.tableFilter) {
                return;
            }
            if (this.eArg.tableFilter == tableFilter) {
                if (this.eArg2.exprType == 2 || this.eArg2.exprType == 1) {
                    blArray[this.eArg.columnIndex] = true;
                    expressionArray[this.eArg.columnIndex] = this.eArg2;
                }
                return;
            }
            if (this.eArg2.tableFilter == tableFilter && (this.eArg.exprType == 2 || this.eArg.exprType == 1)) {
                blArray[this.eArg2.columnIndex] = true;
                expressionArray[this.eArg2.columnIndex] = this.eArg;
            }
        }
    }

    TableFilter findTableFilter(TableFilter[] tableFilterArray) {
        for (int i = 0; i < tableFilterArray.length; ++i) {
            TableFilter tableFilter = tableFilterArray[i];
            if (this.schema != null && !tableFilter.filterTable.getSchemaName().equals(this.schema) || !tableFilter.getName().equals(this.tableName)) continue;
            return tableFilter;
        }
        return null;
    }

    void resolveTables(TableFilter tableFilter) throws HsqlException {
        if (this.isParam || tableFilter == null || this.exprType == 1) {
            return;
        }
        if (this.eArg != null) {
            this.eArg.resolveTables(tableFilter);
        }
        if (this.eArg2 != null) {
            this.eArg2.resolveTables(tableFilter);
        }
        switch (this.exprType) {
            case 2: {
                Table table;
                int n;
                if (this.tableFilter != null) break;
                String string = tableFilter.getName();
                if (this.tableName != null && !this.tableName.equals(string) || (n = (table = tableFilter.getTable()).findColumn(this.columnName)) == -1) break;
                this.tableFilter = tableFilter;
                this.columnIndex = n;
                this.tableName = string;
                this.setTableColumnAttributes(table, n);
                return;
            }
            case 3: {
                if (this.subQuery == null) break;
                this.subQuery.select.resolveTablesUnion(tableFilter);
                break;
            }
            case 7: {
                if (this.function == null) break;
                this.function.resolveTables(tableFilter);
                break;
            }
            case 32: 
            case 33: {
                break;
            }
            case 30: {
                if (this.eArg2.exprType == 3) break;
                Expression[] expressionArray = this.eArg2.valueList;
                for (int i = 0; i < expressionArray.length; ++i) {
                    expressionArray[i].resolveTables(tableFilter);
                }
                break;
            }
        }
    }

    int getCaseWhenType(Session session) throws HsqlException {
        return this.eArg2.dataType;
    }

    void resolveTypes(Session session) throws HsqlException {
        if (this.isParam) {
            return;
        }
        if (this.eArg != null) {
            this.eArg.resolveTypes(session);
        }
        if (this.eArg2 != null) {
            this.eArg2.resolveTypes(session);
        }
        switch (this.exprType) {
            case 1: {
                if (this.dataType != 16 || this.valueData == null) break;
                this.dataType = 0;
                this.exprType = (Boolean)this.valueData != false ? 4 : -4;
                break;
            }
            case 2: {
                break;
            }
            case 7: {
                this.function.resolveType(session);
                this.dataType = this.function.getReturnType();
                break;
            }
            case 3: {
                this.subQuery.select.resolveTypes(session);
                this.dataType = this.subQuery.select.exprColumns[0].dataType;
                break;
            }
            case 10: {
                if (this.eArg.isParam) {
                    throw Trace.error(216, 212);
                }
                this.dataType = this.eArg.dataType;
                if (!this.isFixedConstant()) break;
                this.valueData = this.getValue(session, this.dataType);
                this.eArg = null;
                this.exprType = 1;
                break;
            }
            case 11: {
                if (Types.isCharacterType(this.eArg.dataType) || Types.isCharacterType(this.eArg2.dataType)) {
                    this.exprType = 15;
                    this.dataType = 12;
                    if (this.isFixedConstant()) {
                        this.valueData = this.getValue(session, this.dataType);
                        this.eArg = null;
                        this.eArg2 = null;
                        this.exprType = 1;
                        break;
                    }
                    if (this.eArg.isParam) {
                        this.eArg.dataType = 12;
                    }
                    if (!this.eArg2.isParam) break;
                    this.eArg2.dataType = 12;
                    break;
                }
            }
            case 12: 
            case 13: 
            case 14: {
                if (this.eArg.isParam && this.eArg2.isParam) {
                    throw Trace.error(216, 213);
                }
                if (this.isFixedConstant()) {
                    this.dataType = Column.getCombinedNumberType(this.eArg.dataType, this.eArg2.dataType, this.exprType);
                    this.valueData = this.getValue(session, this.dataType);
                    this.eArg = null;
                    this.eArg2 = null;
                    this.exprType = 1;
                    break;
                }
                if (this.eArg.isParam) {
                    this.eArg.dataType = this.eArg2.dataType;
                } else if (this.eArg2.isParam) {
                    this.eArg2.dataType = this.eArg.dataType;
                }
                this.dataType = Column.getCombinedNumberType(this.eArg.dataType, this.eArg2.dataType, this.exprType);
                break;
            }
            case 15: {
                this.dataType = 12;
                if (this.isFixedConstant()) {
                    this.valueData = this.getValue(session, this.dataType);
                    this.eArg = null;
                    this.eArg2 = null;
                    this.exprType = 1;
                    break;
                }
                if (this.eArg.isParam) {
                    this.eArg.dataType = 12;
                }
                if (!this.eArg2.isParam) break;
                this.eArg2.dataType = 12;
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                if (this.eArg.isParam && this.eArg2.isParam) {
                    throw Trace.error(216, 214);
                }
                if (this.isFixedConditional()) {
                    Boolean bl = this.test(session);
                    if (bl == null) {
                        this.setNull();
                    } else {
                        this.exprType = bl != false ? 4 : -4;
                    }
                    this.eArg = null;
                    this.eArg2 = null;
                } else if (this.eArg.isParam) {
                    int n = this.eArg.dataType = this.eArg2.dataType == 0 ? 12 : this.eArg2.dataType;
                    if (this.eArg2.exprType == 2) {
                        this.eArg.setTableColumnAttributes(this.eArg2);
                    }
                } else if (this.eArg2.isParam) {
                    int n = this.eArg2.dataType = this.eArg.dataType == 0 ? 12 : this.eArg.dataType;
                    if (this.eArg.exprType == 2) {
                        this.eArg2.setTableColumnAttributes(this.eArg);
                    }
                }
                this.dataType = 16;
                break;
            }
            case 27: {
                this.resolveTypeForLike(session);
                this.dataType = 16;
                break;
            }
            case 28: {
                Boolean bl;
                boolean bl2 = this.eArg.isFixedConditional();
                boolean bl3 = this.eArg2.isFixedConditional();
                Boolean bl4 = bl2 ? this.eArg.test(session) : null;
                Boolean bl5 = bl = bl3 ? this.eArg2.test(session) : null;
                if (bl2 && bl3) {
                    if (bl4 == null || bl == null) {
                        this.setNull();
                    } else {
                        this.exprType = bl4 != false && bl != false ? 4 : -4;
                        this.eArg = null;
                        this.eArg2 = null;
                    }
                } else if (bl2 && !Boolean.TRUE.equals(bl4) || bl3 && !Boolean.TRUE.equals(bl)) {
                    this.exprType = -4;
                    this.eArg = null;
                    this.eArg2 = null;
                } else {
                    if (this.eArg.isParam) {
                        this.eArg.dataType = 16;
                    }
                    if (this.eArg2.isParam) {
                        this.eArg2.dataType = 16;
                    }
                }
                this.dataType = 16;
                break;
            }
            case 29: {
                Boolean bl;
                boolean bl6 = this.eArg.isFixedConditional();
                boolean bl7 = this.eArg2.isFixedConditional();
                Boolean bl8 = bl6 ? this.eArg.test(session) : null;
                Boolean bl9 = bl = bl7 ? this.eArg2.test(session) : null;
                if (bl6 && bl7) {
                    if (bl8 == null || bl == null) {
                        this.setNull();
                    } else {
                        this.exprType = bl8 != false || bl != false ? 4 : -4;
                        this.eArg = null;
                        this.eArg2 = null;
                    }
                } else if (bl6 && Boolean.TRUE.equals(bl8) || bl7 && Boolean.TRUE.equals(bl)) {
                    this.exprType = 4;
                    this.eArg = null;
                    this.eArg2 = null;
                } else {
                    if (this.eArg.isParam) {
                        this.eArg.dataType = 16;
                    }
                    if (this.eArg2.isParam) {
                        this.eArg2.dataType = 16;
                    }
                }
                this.dataType = 16;
                break;
            }
            case 34: {
                if (this.isFixedConditional()) {
                    this.exprType = Boolean.TRUE.equals(this.test(session)) ? 4 : -4;
                    this.eArg = null;
                } else if (this.eArg.dataType == 0) {
                    this.eArg.dataType = 12;
                }
                this.dataType = 16;
                break;
            }
            case 20: {
                if (this.isFixedConditional()) {
                    Boolean bl = this.test(session);
                    if (bl == null) {
                        this.setNull();
                    } else {
                        this.exprType = bl != false ? 4 : -4;
                        this.eArg = null;
                    }
                } else if (this.eArg.isParam) {
                    this.eArg.dataType = 16;
                }
                this.dataType = 16;
                break;
            }
            case 32: 
            case 33: {
                this.dataType = this.eArg.dataType;
                break;
            }
            case 30: {
                this.resolveTypeForIn(session);
                this.dataType = 16;
                break;
            }
            case 31: {
                this.dataType = 16;
                break;
            }
            case 40: {
                if (this.eArg.isParam) {
                    throw Trace.error(216, 215);
                }
                this.dataType = 4;
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                if (this.eArg.isParam) {
                    throw Trace.error(216, 215);
                }
                this.dataType = SetFunction.getType(this.exprType, this.eArg.dataType);
                break;
            }
            case 61: {
                if (!this.eArg.isFixedConstant() && !this.eArg.isFixedConditional()) break;
                this.valueData = this.getValue(session);
                this.exprType = 1;
                this.eArg = null;
                break;
            }
            case 62: {
                if (this.eArg.isParam) {
                    this.eArg.dataType = 16;
                }
                this.dataType = this.getCaseWhenType(session);
                break;
            }
            case 70: {
                Expression expression = this.eArg;
                Expression expression2 = this.eArg2;
                if (expression.isParam && expression2.isParam) {
                    throw Trace.error(216, 217);
                }
                if (expression.isParam || expression.dataType == 0) {
                    expression.dataType = expression2.dataType;
                } else if (expression2.isParam || expression2.dataType == 0) {
                    expression2.dataType = expression.dataType;
                }
                if (expression.dataType == 0 && expression2.dataType == 0) {
                    this.dataType = 0;
                }
                if (Types.isNumberType(expression.dataType) && Types.isNumberType(expression2.dataType)) {
                    this.dataType = Column.getCombinedNumberType(expression.dataType, expression2.dataType, 70);
                    break;
                }
                if (Types.isCharacterType(expression.dataType) && Types.isCharacterType(expression2.dataType)) {
                    this.dataType = -1;
                    break;
                }
                if (expression.dataType != expression2.dataType) {
                    if (expression2.exprType == 1) {
                        this.dataType = expression2.dataType = expression.dataType;
                        expression2.valueData = Column.convertObject(expression2.valueData, this.dataType);
                        break;
                    }
                    if (expression.exprType == 1) {
                        this.dataType = expression.dataType = expression2.dataType;
                        expression.valueData = Column.convertObject(expression.valueData, this.dataType);
                        break;
                    }
                    throw Trace.error(216, 218, new String[]{Types.getTypeString(expression.dataType), Types.getTypeString(expression2.dataType)});
                }
                this.dataType = expression.dataType;
            }
        }
    }

    void resolveTypeForLike(Session session) throws HsqlException {
        if (this.eArg.isParam && this.eArg2.isParam) {
            throw Trace.error(216, 219);
        }
        if (this.isFixedConditional()) {
            Boolean bl = this.test(session);
            if (bl == null) {
                this.setNull();
            } else {
                this.exprType = bl != false ? 4 : -4;
                this.eArg = null;
                this.eArg2 = null;
            }
        } else if (this.eArg.isParam) {
            this.eArg.dataType = 12;
        } else if (this.eArg2.isParam) {
            this.eArg2.dataType = 12;
        }
        if (this.likeObject.optimised) {
            return;
        }
        boolean bl = this.eArg2.isFixedConstant();
        String string = bl ? (String)this.eArg2.getValue(session, 12) : null;
        boolean bl2 = this.eArg.dataType == 100 || this.eArg2.dataType == 100;
        this.likeObject.setParams(session, string, bl2);
        if (!bl) {
            return;
        }
        if (this.likeObject.isEquivalentToFalsePredicate()) {
            this.exprType = -4;
            this.eArg = null;
            this.eArg2 = null;
            this.likeObject = null;
        } else if (this.likeObject.isEquivalentToEqualsPredicate()) {
            this.exprType = 21;
            this.eArg2 = new Expression(12, this.likeObject.getRangeLow());
            this.likeObject = null;
        } else if (!this.likeObject.isEquivalentToNotNullPredicate()) {
            if (this.eArg.exprType != 2) {
                return;
            }
            if (!Types.isCharacterType(this.eArg.dataType)) {
                return;
            }
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            if (this.likeObject.isEquivalentToBetweenPredicate()) {
                bl5 = this.likeObject.hasCollation;
                bl3 = !bl5;
                bl4 = bl5;
            } else if (this.likeObject.isEquivalentToBetweenPredicateAugmentedWithLike()) {
                bl5 = this.likeObject.hasCollation;
                bl3 = !bl5;
                bl4 = true;
            }
            if (!bl3 && !bl5) {
                return;
            }
            Expression expression = new Expression(12, this.likeObject.getRangeLow());
            Expression expression2 = new Expression(12, this.likeObject.getRangeHigh());
            if (bl3 && !bl4) {
                Expression expression3 = this.eArg;
                this.eArg = new Expression(22, expression3, expression);
                this.eArg2 = new Expression(25, expression3, expression2);
                this.exprType = 28;
                this.likeObject = null;
            } else if (bl3 && bl4) {
                Expression expression4 = new Expression(22, this.eArg, expression);
                Expression expression5 = new Expression(25, this.eArg, expression2);
                this.eArg2 = new Expression(this.eArg, this.eArg2, this.likeObject.escapeChar, this.likeObject.hasCollation);
                this.eArg2.likeObject = this.likeObject;
                this.eArg = new Expression(28, expression4, expression5);
                this.exprType = 28;
                this.likeObject = null;
            } else if (bl5) {
                Expression expression6 = new Expression(22, this.eArg, expression);
                this.eArg2 = new Expression(this.eArg, this.eArg2, this.likeObject.escapeChar, this.likeObject.hasCollation);
                this.eArg2.likeObject = this.likeObject;
                this.eArg = expression6;
                this.exprType = 28;
                this.likeObject = null;
            }
        }
    }

    void resolveTypeForIn(Session session) throws HsqlException {
        if (this.eArg2.exprType == 3) {
            if (this.eArg.isParam) {
                this.eArg.dataType = this.eArg2.dataType;
            }
            this.isQueryCorrelated = !this.eArg2.subQuery.isResolved;
        } else {
            int n;
            int n2;
            Expression[] expressionArray = this.eArg2.valueList;
            int n3 = expressionArray.length;
            if (this.eArg.isParam) {
                if (expressionArray[0].isParam) {
                    throw Trace.error(216, 221);
                }
                Expression expression = expressionArray[0];
                n2 = expression.dataType;
                if (n2 != 0) {
                    if (this.eArg.dataType == 0) {
                        this.eArg.dataType = n2;
                    }
                    if (this.eArg2.dataType == 0) {
                        this.eArg2.dataType = n2;
                    }
                }
                for (int i = 1; i < n3; ++i) {
                    expression = expressionArray[i];
                    if (expression.isParam) {
                        if (expression.dataType != 0 || n2 == 0) continue;
                        expression.dataType = n2;
                        continue;
                    }
                    expression.resolveTypes(session);
                }
            } else {
                int n4 = this.eArg.dataType;
                if (this.eArg2.dataType == 0 && n4 != 0) {
                    this.eArg2.dataType = n4;
                }
                for (n2 = 0; n2 < n3; ++n2) {
                    Expression expression = expressionArray[n2];
                    if (expression.isParam) {
                        if (expression.dataType != 0 || n4 == 0) continue;
                        expression.dataType = n4;
                        continue;
                    }
                    expression.resolveTypes(session);
                }
            }
            this.eArg2.isFixedConstantValueList = this.eArg2.dataType != 100;
            for (n = 0; n < n3; ++n) {
                if (expressionArray[n].isFixedConstant()) continue;
                this.eArg2.isFixedConstantValueList = false;
                this.isQueryCorrelated = true;
                break;
            }
            if (this.eArg2.isFixedConstantValueList) {
                this.eArg2.hList = new HashSet();
                for (n = 0; n < n3; ++n) {
                    try {
                        Object object = this.eArg2.valueList[n].getValue(session);
                        object = Column.convertObject(object, this.eArg2.dataType);
                        if (this.eArg2.dataType == 1 && object != null) {
                            object = Library.rtrim((String)object);
                        }
                        this.eArg2.hList.add(object);
                        continue;
                    }
                    catch (HsqlException hsqlException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    boolean isResolved() {
        switch (this.exprType) {
            case 1: 
            case 10: {
                return true;
            }
            case 2: {
                return this.tableFilter != null && this.tableFilter.isAssigned;
            }
            case 3: {
                return this.subQuery.isResolved;
            }
        }
        return false;
    }

    static boolean isCompare(int n) {
        switch (n) {
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                return true;
            }
        }
        return false;
    }

    String getTableName() {
        if (this.exprType == 6) {
            return this.tableName;
        }
        if (this.exprType == 2) {
            if (this.tableFilter == null) {
                return this.tableName;
            }
            return this.tableFilter.getTable().getName().name;
        }
        return "";
    }

    String getFilterTableName() {
        if (this.tableFilter == null) {
            return "";
        }
        return this.tableFilter.getTable().getName().name;
    }

    HsqlNameManager.HsqlName getTableHsqlName() {
        if (this.tableFilter == null) {
            return null;
        }
        return this.tableFilter.getTable().getName();
    }

    String getTableSchemaName() {
        if (this.tableFilter == null) {
            return null;
        }
        return this.tableFilter.getTable().getName().schema.name;
    }

    String getColumnName() {
        if (this.exprType == 2) {
            if (this.tableFilter == null) {
                return this.columnName;
            }
            return this.tableFilter.getTable().getColumn((int)this.columnIndex).columnName.name;
        }
        return this.getAlias();
    }

    String getBaseColumnName() {
        if (this.exprType == 2 && this.tableFilter != null) {
            return this.tableFilter.getTable().getColumn((int)this.columnIndex).columnName.name;
        }
        return null;
    }

    int getColumnNr() {
        return this.columnIndex;
    }

    int getColumnSize() {
        return this.precision;
    }

    int getColumnScale() {
        return this.scale;
    }

    void setDistinctAggregate(boolean bl) {
        boolean bl2 = this.isDistinctAggregate = bl && this.eArg.exprType != 6;
        if (this.exprType == 40) {
            this.dataType = bl ? this.dataType : 4;
        }
    }

    void swapCondition() throws HsqlException {
        int n = 21;
        switch (this.exprType) {
            case 22: {
                n = 25;
                break;
            }
            case 25: {
                n = 22;
                break;
            }
            case 24: {
                n = 23;
                break;
            }
            case 23: {
                n = 24;
                break;
            }
            case 21: {
                break;
            }
            default: {
                Trace.doAssert(false, "Expression.swapCondition");
            }
        }
        this.exprType = n;
        Expression expression = this.eArg;
        this.eArg = this.eArg2;
        this.eArg2 = expression;
    }

    int getDataType() {
        return this.dataType;
    }

    Object getValue(Session session, int n) throws HsqlException {
        Object object = this.getValue(session);
        if (object == null || this.dataType == n) {
            return object;
        }
        return Column.convertObject(object, n);
    }

    Object getAggregatedValue(Session session, Object objectArray) throws HsqlException {
        if (!this.isAggregate()) {
            return objectArray;
        }
        Object object = null;
        Object object2 = null;
        switch (this.aggregateSpec) {
            case -1: {
                switch (this.exprType) {
                    case 40: {
                        if (objectArray == null) {
                            return INTEGER_0;
                        }
                        return ((SetFunction)objectArray).getValue();
                    }
                    case 41: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 47: 
                    case 48: 
                    case 49: 
                    case 50: {
                        if (objectArray == null) {
                            return null;
                        }
                        return ((SetFunction)objectArray).getValue();
                    }
                }
            }
            case 1: {
                object = this.eArg.getAggregatedValue(session, objectArray == null ? null : objectArray[0]);
                if (objectArray == null) {
                    object2 = this.eArg2 == null ? null : this.eArg2.getValue(session);
                    break;
                }
                object2 = objectArray[1];
                break;
            }
            case 2: {
                object = objectArray == null ? (this.eArg == null ? null : this.eArg.getValue(session)) : ((Object[])objectArray)[0];
                object2 = objectArray == null ? null : this.eArg2.getAggregatedValue(session, objectArray[1]);
                break;
            }
            case 3: {
                if (objectArray == null) {
                    objectArray = new Object[2];
                }
                object = this.eArg.getAggregatedValue(session, objectArray[0]);
                object2 = this.eArg2.getAggregatedValue(session, objectArray[1]);
            }
        }
        switch (this.exprType) {
            case 10: {
                return Column.negate(object, this.dataType);
            }
            case 61: {
                return Column.convertObject(session, object, this.dataType, this.precision, this.scale);
            }
            case 4: {
                return Boolean.TRUE;
            }
            case -4: {
                return Boolean.FALSE;
            }
            case 20: {
                if (object == null) {
                    return null;
                }
                return (Boolean)object != false ? Boolean.FALSE : Boolean.TRUE;
            }
            case 28: {
                if (object == null || object2 == null) {
                    return null;
                }
                return (Boolean)object != false && (Boolean)object2 != false ? Boolean.TRUE : Boolean.FALSE;
            }
            case 29: {
                if (Boolean.TRUE.equals(object)) {
                    return Boolean.TRUE;
                }
                return Boolean.TRUE.equals(object2) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 34: {
                return object == null ? Boolean.TRUE : Boolean.FALSE;
            }
            case 27: {
                String string = (String)Column.convertObject(object2, 12);
                if (this.eArg2.isParam || this.eArg2.exprType != 1) {
                    this.likeObject.resetPattern(session, string);
                }
                String string2 = (String)Column.convertObject(object, 12);
                return this.likeObject.compare(session, string2);
            }
            case 32: 
            case 33: {
                return null;
            }
            case 30: {
                return this.eArg2.testInCondition(session, object);
            }
            case 31: {
                if (!this.eArg.subQuery.isResolved) {
                    Result result = this.eArg.subQuery.select.getResult(session, 1);
                    return result.rRoot == null ? Boolean.FALSE : Boolean.TRUE;
                }
                return this.subQuery.table.isEmpty(session) ? Boolean.FALSE : Boolean.TRUE;
            }
            case 62: {
                object = Column.convertObject(object, 16);
                boolean bl = (Boolean)object;
                Object object3 = bl ? ((Object[])object2)[0] : ((Object[])object2)[1];
                return Column.convertObject(object3, this.dataType);
            }
            case 70: {
                object = Column.convertObject(object, this.dataType);
                object2 = Column.convertObject(object2, this.dataType);
                Object[] objectArray2 = new Object[]{object, object2};
                return objectArray2;
            }
            case 7: {
                return this.function.getAggregatedValue(session, objectArray);
            }
        }
        if (Expression.isCompare(this.exprType)) {
            if (this.eArg2.exprType == 33 || this.eArg2.exprType == 32) {
                return this.testAnyAllCondition(session, object);
            }
            return this.compareValues(session, object, object2);
        }
        if (object != null) {
            object = Column.convertObject(object, this.dataType);
        }
        if (object2 != null) {
            object2 = Column.convertObject(object2, this.dataType);
        }
        switch (this.exprType) {
            case 11: {
                return Column.add(object, object2, this.dataType);
            }
            case 12: {
                return Column.subtract(object, object2, this.dataType);
            }
            case 13: {
                return Column.multiply(object, object2, this.dataType);
            }
            case 14: {
                return Column.divide(object, object2, this.dataType);
            }
            case 15: {
                return Column.concat(object, object2);
            }
        }
        throw Trace.error(14, this.describe(session));
    }

    Object updateAggregatingValue(Session session, Object object) throws HsqlException {
        switch (this.aggregateSpec) {
            case -1: {
                if (object == null) {
                    object = new SetFunction(this.exprType, this.eArg.dataType, this.isDistinctAggregate);
                }
                Integer n = this.eArg.exprType == 6 ? INTEGER_1 : this.eArg.getValue(session);
                ((SetFunction)object).add(session, n);
                return object;
            }
            case 3: {
                Object[] objectArray = (Object[])object;
                if (objectArray == null) {
                    objectArray = new Object[]{this.eArg.updateAggregatingValue(session, objectArray[0]), this.eArg2.updateAggregatingValue(session, objectArray[1])};
                }
                return objectArray;
            }
            case 1: {
                Object[] objectArray = (Object[])object;
                if (objectArray == null) {
                    objectArray = new Object[2];
                }
                objectArray[0] = this.eArg.updateAggregatingValue(session, objectArray[0]);
                if (this.eArg2 != null) {
                    objectArray[1] = this.eArg2.getValue(session);
                }
                return objectArray;
            }
            case 2: {
                Object[] objectArray = (Object[])object;
                if (objectArray == null) {
                    objectArray = new Object[2];
                }
                if (this.eArg != null) {
                    objectArray[0] = this.eArg.getValue(session);
                }
                objectArray[1] = this.eArg2.updateAggregatingValue(session, objectArray[1]);
                return objectArray;
            }
            case 4: {
                return this.function.updateAggregatingValue(session, object);
            }
        }
        return object;
    }

    Object getValue(Session session) throws HsqlException {
        switch (this.exprType) {
            case 1: {
                return this.valueData;
            }
            case 2: {
                try {
                    return this.tableFilter.currentData[this.columnIndex];
                }
                catch (NullPointerException nullPointerException) {
                    String string = this.tableName == null ? this.columnName : this.tableName + '.' + this.columnName;
                    throw Trace.error(28, string);
                }
            }
            case 7: {
                return this.function.getValue(session);
            }
            case 3: {
                return this.subQuery.select.getValue(session, this.dataType);
            }
            case 10: {
                return Column.negate(this.eArg.getValue(session, this.dataType), this.dataType);
            }
            case 32: 
            case 33: {
                return null;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                return this.test(session);
            }
            case 61: {
                return Column.convertObject(session, this.eArg.getValue(session), this.dataType, this.precision, this.scale);
            }
            case 62: {
                Boolean bl = this.eArg.test(session);
                if (Boolean.TRUE.equals(bl)) {
                    return this.eArg2.eArg.getValue(session, this.dataType);
                }
                return this.eArg2.eArg2.getValue(session, this.dataType);
            }
            case 70: {
                return new Object[]{this.eArg.getValue(session, this.dataType), this.eArg2.getValue(session, this.dataType)};
            }
        }
        Object object = null;
        Object object2 = null;
        if (this.eArg != null) {
            object = this.eArg.getValue(session, this.dataType);
        }
        if (this.eArg2 != null) {
            object2 = this.eArg2.getValue(session, this.dataType);
        }
        switch (this.exprType) {
            case 11: {
                return Column.add(object, object2, this.dataType);
            }
            case 12: {
                return Column.subtract(object, object2, this.dataType);
            }
            case 13: {
                return Column.multiply(object, object2, this.dataType);
            }
            case 14: {
                return Column.divide(object, object2, this.dataType);
            }
            case 15: {
                return Column.concat(object, object2);
            }
            case 71: {
                return ((NumberSequence)this.valueData).getValueObject();
            }
        }
        return this.test(session);
    }

    boolean testCondition(Session session) throws HsqlException {
        return Boolean.TRUE.equals(this.test(session));
    }

    Boolean test(Session session) throws HsqlException {
        switch (this.exprType) {
            case 4: {
                return Boolean.TRUE;
            }
            case -4: {
                return Boolean.FALSE;
            }
            case 20: {
                Boolean bl;
                if (this.eArg2 != null) {
                    Trace.doAssert(false, "Expression.test");
                }
                return (bl = this.eArg.test(session)) == null ? null : (bl != false ? Boolean.FALSE : Boolean.TRUE);
            }
            case 28: {
                Boolean bl = this.eArg.test(session);
                if (bl == null) {
                    return null;
                }
                Boolean bl2 = this.eArg2.test(session);
                if (bl2 == null) {
                    return null;
                }
                return bl != false && bl2 != false ? Boolean.TRUE : Boolean.FALSE;
            }
            case 29: {
                boolean bl = Boolean.TRUE.equals(this.eArg.test(session));
                if (bl) {
                    return Boolean.TRUE;
                }
                return Boolean.TRUE.equals(this.eArg2.test(session)) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 34: {
                return this.eArg.getValue(session) == null ? Boolean.TRUE : Boolean.FALSE;
            }
            case 27: {
                String string = (String)this.eArg2.getValue(session, 12);
                if (this.eArg2.isParam || this.eArg2.exprType != 1) {
                    this.likeObject.resetPattern(session, string);
                }
                String string2 = (String)this.eArg.getValue(session, 12);
                return this.likeObject.compare(session, string2);
            }
            case 30: {
                return this.eArg2.testInCondition(session, this.eArg.getValue(session));
            }
            case 31: {
                return this.eArg.testExistsCondition(session);
            }
            case 7: {
                Object object = Column.convertObject(this.function.getValue(session), 16);
                return (Boolean)object;
            }
        }
        if (this.eArg == null || this.eArg2 == null) {
            if (this.exprType == 2 && (this.dataType == 16 || Types.isNumberType(this.dataType))) {
                Object object = Column.convertObject(this.getValue(session), 16);
                return (Boolean)object;
            }
            throw Trace.error(106);
        }
        if (this.eArg2.exprType == 33 || this.eArg2.exprType == 32) {
            return this.testAnyAllCondition(session, this.eArg.getValue(session));
        }
        Object object = this.eArg.getValue(session);
        Object object2 = this.eArg2.getValue(session);
        if (object == null || object2 == null) {
            if (this.eArg.tableFilter != null && this.eArg.tableFilter.isOuterJoin) {
                if (this.isInJoin) {
                    if (this.eArg.tableFilter.isCurrentOuter && object == null) {
                        return Boolean.TRUE;
                    }
                } else {
                    this.eArg.tableFilter.nonJoinIsNull = object2 == null;
                }
            }
            return null;
        }
        return this.compareValues(session, object, object2);
    }

    private Boolean compareValues(Session session, Object object, Object object2) throws HsqlException {
        int n = this.eArg.dataType;
        if (this.eArg.dataType != this.eArg2.dataType) {
            if (Types.isNumberType(this.eArg.dataType) && Types.isNumberType(this.eArg2.dataType)) {
                n = Column.getCombinedNumberType(this.eArg.dataType, this.eArg2.dataType, this.exprType);
            }
            object = Column.convertObject(object, n);
            object2 = Column.convertObject(object2, n);
        }
        int n2 = Column.compare(session.database.collation, object, object2, n);
        switch (this.exprType) {
            case 21: {
                return n2 == 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 23: {
                return n2 > 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 22: {
                return n2 >= 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 25: {
                return n2 <= 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 24: {
                return n2 < 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 26: {
                return n2 != 0 ? Boolean.TRUE : Boolean.FALSE;
            }
        }
        throw Trace.error(40, 167);
    }

    private Boolean testInCondition(Session session, Object object) throws HsqlException {
        if (object == null) {
            return null;
        }
        if (this.exprType == 5) {
            try {
                object = Column.convertObject(object, this.dataType);
            }
            catch (HsqlException hsqlException) {
                return Boolean.FALSE;
            }
            if (this.isFixedConstantValueList) {
                if (this.dataType == 1) {
                    object = Library.rtrim((String)object);
                }
                return this.hList.contains(object) ? Boolean.TRUE : Boolean.FALSE;
            }
            int n = this.valueList.length;
            for (int i = 0; i < n; ++i) {
                Object object2 = this.valueList[i].getValue(session, this.dataType);
                if (Column.compare(session.database.collation, object, object2, this.dataType) != 0) continue;
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (this.exprType == 3) {
            Boolean bl;
            try {
                object = Column.convertObject(object, this.subQuery.table.getColumnTypes()[0]);
            }
            catch (HsqlException hsqlException) {
                return Boolean.FALSE;
            }
            if (!this.subQuery.isResolved) {
                this.subQuery.populateTable(session);
            }
            Boolean bl2 = bl = this.subQuery.table.getPrimaryIndex().findFirstRow(session, object, 21).hasNext() ? Boolean.TRUE : Boolean.FALSE;
            if (!this.subQuery.isResolved) {
                this.subQuery.table.clearAllRows(session);
            }
            return bl;
        }
        throw Trace.error(16);
    }

    private Boolean testExistsCondition(Session session) throws HsqlException {
        if (this.subQuery.isResolved) {
            return this.subQuery.table.isEmpty(session) ? Boolean.FALSE : Boolean.TRUE;
        }
        Result result = this.subQuery.select.getResult(session, 1);
        return result.rRoot == null ? Boolean.FALSE : Boolean.TRUE;
    }

    private Boolean testAnyAllCondition(Session session, Object object) throws HsqlException {
        boolean bl;
        if (object == null) {
            return null;
        }
        SubQuery subQuery = this.eArg2.eArg.subQuery;
        boolean bl2 = bl = !subQuery.isResolved;
        if (bl) {
            subQuery.populateTable(session);
        }
        Boolean bl3 = this.getAnyAllValue(session, object, subQuery);
        if (bl) {
            subQuery.table.clearAllRows(session);
        }
        return bl3;
    }

    private Boolean getAnyAllValue(Session session, Object object, SubQuery subQuery) throws HsqlException {
        boolean bl = subQuery.table.isEmpty(session);
        Index index = subQuery.table.getPrimaryIndex();
        RowIterator rowIterator = index.findFirstRowNotNull(session);
        Row row = rowIterator.next();
        switch (this.eArg2.exprType) {
            case 33: {
                if (bl) {
                    return Boolean.FALSE;
                }
                if (row == null) {
                    return null;
                }
                int n = Column.compareToTypeRange(object, this.eArg2.eArg.getDataType());
                if (n != 0) {
                    switch (this.exprType) {
                        case 21: {
                            return Boolean.FALSE;
                        }
                        case 26: {
                            return Boolean.TRUE;
                        }
                        case 22: 
                        case 23: {
                            return n > 0 ? Boolean.TRUE : Boolean.FALSE;
                        }
                        case 24: 
                        case 25: {
                            return n < 0 ? Boolean.TRUE : Boolean.FALSE;
                        }
                    }
                }
                object = Column.convertObject(object, this.eArg2.eArg.getDataType());
                if (this.exprType == 21) {
                    rowIterator = index.findFirstRow(session, object, 21);
                    return rowIterator.hasNext() ? Boolean.TRUE : Boolean.FALSE;
                }
                Row row2 = index.lastRow(session);
                Object object2 = row.getData()[0];
                Object object3 = row2.getData()[0];
                int n2 = Column.compare(session.database.collation, object, object2, this.eArg.getDataType());
                int n3 = Column.compare(session.database.collation, object, object3, this.eArg.getDataType());
                switch (this.exprType) {
                    case 26: {
                        return n2 == 0 && n3 == 0 ? Boolean.FALSE : Boolean.TRUE;
                    }
                    case 23: {
                        return n2 > 0 ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 22: {
                        return n2 >= 0 ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 24: {
                        return n3 < 0 ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 25: {
                        return n3 <= 0 ? Boolean.TRUE : Boolean.FALSE;
                    }
                }
                break;
            }
            case 32: {
                if (bl) {
                    return Boolean.TRUE;
                }
                if (row == null) {
                    return null;
                }
                int n = Column.compareToTypeRange(object, this.eArg2.eArg.getDataType());
                if (n != 0) {
                    switch (this.exprType) {
                        case 21: {
                            return Boolean.FALSE;
                        }
                        case 26: {
                            return Boolean.TRUE;
                        }
                        case 22: 
                        case 23: {
                            return n > 0 ? Boolean.TRUE : Boolean.FALSE;
                        }
                        case 24: 
                        case 25: {
                            return n < 0 ? Boolean.TRUE : Boolean.FALSE;
                        }
                    }
                }
                object = Column.convertObject(object, this.eArg2.eArg.getDataType());
                if (this.exprType == 21 || this.exprType == 26) {
                    rowIterator = index.findFirstRow(session, object, 21);
                    if (this.exprType == 21) {
                        return rowIterator.hasNext() && subQuery.table.getRowCount(session) == 1 ? Boolean.TRUE : Boolean.FALSE;
                    }
                    return rowIterator.hasNext() ? Boolean.FALSE : Boolean.TRUE;
                }
                Row row3 = index.lastRow(session);
                Object object4 = row.getData()[0];
                Object object5 = row3.getData()[0];
                object = Column.convertObject(object, this.eArg2.eArg.getDataType());
                int n4 = Column.compare(session.database.collation, object, object4, this.eArg.getDataType());
                int n5 = Column.compare(session.database.collation, object, object5, this.eArg.getDataType());
                switch (this.exprType) {
                    case 26: {
                        return n4 == 0 || n5 == 0 ? Boolean.FALSE : Boolean.TRUE;
                    }
                    case 23: {
                        return n5 > 0 ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 22: {
                        return n5 >= 0 ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 24: {
                        return n4 < 0 ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 25: {
                        return n4 <= 0 ? Boolean.TRUE : Boolean.FALSE;
                    }
                }
            }
        }
        return null;
    }

    boolean setForJoin(TableFilter tableFilter, boolean bl) {
        this.isInJoin = bl;
        if (bl) {
            this.outerFilter = tableFilter;
        }
        if (this.eArg != null && !this.eArg.setForJoin(tableFilter, bl)) {
            return false;
        }
        if (this.eArg2 != null && !this.eArg2.setForJoin(tableFilter, bl)) {
            return false;
        }
        return !bl || this.exprType == 28 || this.exprType == 29 || this.exprType == 2 || this.exprType == 1 || this.exprType == 21 || this.exprType == 26 || this.exprType == 23 || this.exprType == 22 || this.exprType == 24 || this.exprType == 25 || this.exprType == 34;
    }

    static Select getCheckSelect(Session session, Table table, Expression expression) throws HsqlException {
        Expression expression2;
        Select select = new Select();
        select.exprColumns = new Expression[1];
        select.exprColumns[0] = new Expression(1, Boolean.TRUE);
        select.tFilter = new TableFilter[1];
        select.tFilter[0] = new TableFilter(table, null, null, false);
        select.queryCondition = expression2 = new Expression(20, expression, null);
        select.resolveAll(session, true);
        return select;
    }

    void setLeftExpression(Expression expression) {
        this.eArg = expression;
    }

    void setRightExpression(Expression expression) {
        this.eArg2 = expression;
    }

    Expression getRightExpression() {
        return this.eArg2;
    }

    void bind(Object object) {
        this.valueData = object;
    }

    boolean isParam() {
        return this.isParam;
    }

    boolean isFixedConstant() {
        switch (this.exprType) {
            case 1: {
                return !this.isParam;
            }
            case 10: {
                return this.eArg.isFixedConstant();
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                return this.eArg.isFixedConstant() && this.eArg2.isFixedConstant();
            }
        }
        return false;
    }

    boolean isFixedConditional() {
        switch (this.exprType) {
            case -4: 
            case 4: {
                return true;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                return this.eArg.isFixedConstant() && this.eArg2.isFixedConstant();
            }
            case 34: {
                return this.eArg.isFixedConstant();
            }
            case 20: {
                return this.eArg.isFixedConditional();
            }
            case 28: 
            case 29: {
                return this.eArg.isFixedConditional() && this.eArg2.isFixedConditional();
            }
        }
        return false;
    }

    void setTableColumnAttributes(Expression expression) {
        this.precision = expression.precision;
        this.scale = expression.scale;
        this.isIdentity = expression.isIdentity;
        this.nullability = expression.nullability;
        this.isWritable = expression.isWritable;
        this.catalog = expression.catalog;
        this.schema = expression.schema;
    }

    void setTableColumnAttributes(Table table, int n) {
        Column column = table.getColumn(n);
        this.dataType = column.getType();
        this.precision = column.getSize();
        this.scale = column.getScale();
        this.isIdentity = column.isIdentity();
        this.nullability = column.isNullable() && !this.isIdentity ? 1 : 0;
        this.isWritable = table.isWritable();
        this.catalog = table.getCatalogName();
        this.schema = table.getSchemaName();
    }

    String getValueClassName() {
        if (this.valueClassName == null) {
            this.valueClassName = this.function == null ? Types.getColStClsName(this.dataType == 100 ? 12 : this.dataType) : this.function.getReturnClass().getName();
        }
        return this.valueClassName;
    }

    static {
        SQL_EXTRACT_FIELD_NAMES.addAll(new Object[]{"YEAR", "MONTH", "DAY", "HOUR", "MINUTE", "SECOND", "TIMEZONE_HOUR", "TIMEZONE_MINUTE", "DAYOFWEEK"});
        SQL_TRIM_SPECIFICATION.addAll(new Object[]{"LEADING", "TRAILING", "BOTH"});
        INTEGER_0 = ValuePool.getInt(0);
        INTEGER_1 = ValuePool.getInt(1);
    }

    static class Collector
    extends HashSet {
        Collector() {
        }

        void addAll(Expression expression, int n) {
            int n2;
            Expression[] expressionArray;
            Function function;
            if (expression == null) {
                return;
            }
            this.addAll(expression.getArg(), n);
            this.addAll(expression.getArg2(), n);
            if (expression.exprType == n) {
                this.add(expression);
            }
            if (expression.subQuery != null) {
                this.addAll(expression.subQuery.select, n);
            }
            if ((function = expression.function) != null && (expressionArray = function.eArg) != null) {
                for (n2 = 0; n2 < expressionArray.length; ++n2) {
                    this.addAll(expressionArray[n2], n);
                }
            }
            if ((expressionArray = expression.valueList) != null) {
                for (n2 = 0; n2 < expressionArray.length; ++n2) {
                    this.addAll(expressionArray[n2], n);
                }
            }
        }

        void addAll(Select select, int n) {
            while (select != null) {
                Expression[] expressionArray = select.exprColumns;
                for (int i = 0; i < expressionArray.length; ++i) {
                    this.addAll(expressionArray[i], n);
                }
                this.addAll(select.queryCondition, n);
                this.addAll(select.havingCondition, n);
                select = select.unionSelect;
            }
        }
    }
}

