/*
 * Decompiled with CFR 0.152.
 */
package sbaz;

import java.io.File;
import java.io.FileWriter;
import java.io.StringWriter;
import sbaz.AvailableList;
import sbaz.AvailablePackage;
import sbaz.Message;
import sbaz.PackageSpec;
import sbaz.ServletRequestHandler$;
import sbaz.SimpleUniverse;
import sbaz.Universe;
import sbaz.keys.Key;
import sbaz.keys.KeyRing;
import sbaz.keys.KeyUtil$;
import sbaz.keys.MessagePattern;
import sbaz.messages.AddPackage;
import sbaz.messages.KeyCreate;
import sbaz.messages.KeyCreated;
import sbaz.messages.KeyList;
import sbaz.messages.KeyRevoke;
import sbaz.messages.LatestPackages;
import sbaz.messages.NotOK;
import sbaz.messages.OK;
import sbaz.messages.RemovePackage;
import sbaz.messages.SendKeyList$;
import sbaz.messages.SendPackageList;
import scala.Function0;
import scala.Function1;
import scala.ScalaObject;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.StringBuilder;
import scala.xml.Elem;
import scala.xml.Node;
import scala.xml.XML$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletRequestHandler
implements ScalaObject {
    private final File directory;
    private final SimpleUniverse universe;
    private AvailableList packages;
    private final KeyRing keyring;
    private final List<MessagePattern> keylessRequests;

    public static final ServletRequestHandler handlerFor(String string) {
        return ServletRequestHandler$.MODULE$.handlerFor(string);
    }

    public static final ServletRequestHandler handlerFor(File file) {
        return ServletRequestHandler$.MODULE$.handlerFor(file);
    }

    public <A> A loadXML(String baseName, Function1<Node, A> loader, Function0<A> ifmissing) {
        A a;
        File file = new File(this.directory, baseName);
        if (file.exists()) {
            Elem xml = (Elem)XML$.MODULE$.load(file.getAbsolutePath());
            a = loader.apply(xml);
        } else {
            a = ifmissing.apply();
        }
        return a;
    }

    private boolean renameFile(File from, File to) {
        to.delete();
        return from.renameTo(to);
    }

    private boolean saveXML(Node xml, String filename) {
        File tmpFile = new File(this.directory, new StringBuilder().append((Object)filename).append((Object)".tmp").toString());
        FileWriter str = new FileWriter(tmpFile);
        str.write(xml.toString());
        str.close();
        return this.renameFile(tmpFile, new File(this.directory, filename));
    }

    public SimpleUniverse universe() {
        return this.universe;
    }

    public AvailableList packages() {
        return this.packages;
    }

    public void packages_$eq(AvailableList availableList) {
        this.packages = availableList;
    }

    public boolean savePackages() {
        return this.saveXML(this.packages().toXML(), "packages");
    }

    public KeyRing keyring() {
        return this.keyring;
    }

    public boolean saveKeyring() {
        return this.saveXML(this.keyring().toXML(), "keyring");
    }

    public List<MessagePattern> keylessRequests() {
        return this.keylessRequests;
    }

    public String responseForGET() {
        ServletRequestHandler servletRequestHandler = this;
        synchronized (servletRequestHandler) {
            StringWriter out$1 = new StringWriter();
            out$1.write("This is a Scala Bazaar.  The bazaar descriptor is:\n");
            out$1.write(this.universe().toXML().toString());
            out$1.write("\n\n");
            out$1.write("The packages included are:\n");
            this.packages().sortedSpecs().foreach(new $anonfun$responseForGET$1(this, out$1));
            String string = out$1.toString();
            return string;
        }
    }

    public Message handleRequest(Message message) {
        ServletRequestHandler servletRequestHandler = this;
        synchronized (servletRequestHandler) {
            Message message2;
            Message message3 = message.sansKeys();
            List list = (List)message.authKeys().filter(new $anonfun$9(this));
            if (this.keylessRequests().exists(new $anonfun$handleRequest$1(this, message3)) || list.exists(new $anonfun$handleRequest$2(this, message3))) {
                Message message4 = message3;
                if (message4 instanceof SendPackageList) {
                    message2 = new LatestPackages(this.packages());
                } else if (message4 instanceof AddPackage) {
                    AvailablePackage availablePackage;
                    AddPackage addPackage = (AddPackage)message4;
                    AvailablePackage availablePackage2 = availablePackage = addPackage.pack();
                    List list2 = (List)this.packages().available().filter(new $anonfun$10(this, availablePackage2));
                    AvailablePackage availablePackage3 = availablePackage2;
                    List<AvailablePackage> list3 = list2.$colon$colon(availablePackage3);
                    this.packages_$eq(new AvailableList(list3));
                    this.savePackages();
                    message2 = new OK();
                } else if (message4 instanceof RemovePackage) {
                    PackageSpec packageSpec;
                    RemovePackage removePackage = (RemovePackage)message4;
                    PackageSpec packageSpec2 = packageSpec = removePackage.spec();
                    List list4 = (List)this.packages().available().filter(new $anonfun$11(this, packageSpec2));
                    this.packages_$eq(new AvailableList(list4));
                    this.savePackages();
                    message2 = new OK();
                } else if (message4 instanceof KeyCreate) {
                    KeyCreate keyCreate = (KeyCreate)message4;
                    MessagePattern messagePattern = keyCreate.messages();
                    String string = keyCreate.description();
                    MessagePattern messagePattern2 = messagePattern;
                    String string2 = string;
                    String string3 = KeyUtil$.MODULE$.genKeyData();
                    Key key = new Key(messagePattern2, string2, string3);
                    this.keyring().addKey(key);
                    this.saveKeyring();
                    message2 = new KeyCreated(key);
                } else if (message4 instanceof KeyRevoke) {
                    this.keyring().removeKey(((KeyRevoke)message4).key());
                    this.saveKeyring();
                    message2 = new OK();
                } else {
                    SendKeyList$ sendKeyList$ = SendKeyList$.MODULE$;
                    Message message5 = message4;
                    message2 = !(sendKeyList$ != null ? !sendKeyList$.equals(message5) : message5 != null) ? new KeyList(this.keyring().keys()) : new NotOK(new StringBuilder().append((Object)"unhandled message type.  full message: ").append(message3).toString());
                }
            } else {
                message2 = new NotOK("Permission denied");
            }
            Message message6 = message2;
            return message6;
        }
    }

    public final List fromXML$1(Node xml) {
        return xml.child().toList().withFilter(new $anonfun$fromXML$1$1(this)).map(new $anonfun$fromXML$1$2(this), List$.MODULE$.canBuildFrom());
    }

    public ServletRequestHandler(File file) {
        this.directory = file;
        Universe universe = (Universe)this.loadXML("universe", new $anonfun$2(this), new $anonfun$1(this));
        if (universe instanceof SimpleUniverse) {
            this.universe = (SimpleUniverse)universe;
            this.packages = (AvailableList)this.loadXML("packages", new $anonfun$4(this), new $anonfun$3(this));
            this.keyring = (KeyRing)this.loadXML("keyring", new $anonfun$6(this), new $anonfun$5(this));
            this.keylessRequests = (List)this.loadXML("keylessRequests", new $anonfun$8(this), new $anonfun$7(this));
            return;
        }
        throw new Error("this universe is not a simple universe");
    }
}

