/*
 * Decompiled with CFR 0.152.
 */
package scala.actors;

import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.actors.MQueueElement;
import scala.actors.OutputChannel;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MQueue<Msg>
implements ScalaObject {
    private final String label;
    private MQueueElement<Msg> first;
    private MQueueElement<Msg> last;
    private int _size;

    public MQueueElement<Msg> first() {
        return this.first;
    }

    public void first_$eq(MQueueElement<Msg> mQueueElement) {
        this.first = mQueueElement;
    }

    public MQueueElement<Msg> last() {
        return this.last;
    }

    public void last_$eq(MQueueElement<Msg> mQueueElement) {
        this.last = mQueueElement;
    }

    private int _size() {
        return this._size;
    }

    private void _size_$eq(int n) {
        this._size = n;
    }

    public final boolean isEmpty() {
        return this.last() == null;
    }

    public void changeSize(int diff) {
        this._size_$eq(this._size() + diff);
    }

    public void append(Msg msg, OutputChannel<Object> session) {
        this.changeSize(1);
        MQueueElement<Msg> el = new MQueueElement<Msg>(msg, session);
        if (this.isEmpty()) {
            this.first_$eq(el);
        } else {
            this.last().next_$eq(el);
        }
        this.last_$eq(el);
    }

    public void append(MQueueElement<Msg> el) {
        this.changeSize(1);
        if (this.isEmpty()) {
            this.first_$eq(el);
        } else {
            this.last().next_$eq(el);
        }
        this.last_$eq(el);
    }

    public void foreach(Function2<Msg, OutputChannel<Object>, Object> f) {
        MQueueElement<Msg> curr = this.first();
        while (curr != null) {
            f.apply(curr.msg(), curr.session());
            curr = curr.next();
        }
        return;
    }

    public void foreachDequeue(MQueue<Msg> target) {
        MQueueElement<Msg> curr = this.first();
        while (true) {
            if (curr == null) {
                this.first_$eq(null);
                this.last_$eq(null);
                this._size_$eq(0);
                return;
            }
            target.append(curr);
            curr = curr.next();
        }
    }

    public MQueueElement<Msg> extractFirst(Function2<Msg, OutputChannel<Object>, Boolean> p) {
        return (MQueueElement)this.removeInternal(0, p).orNull(Predef$.MODULE$.conforms());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Option<MQueueElement<Msg>> removeInternal(int n$2, Function2<Msg, OutputChannel<Object>, Boolean> p$2) {
        Option option;
        IntRef pos$2 = new IntRef(0);
        if (this.isEmpty()) {
            return None$.MODULE$;
        }
        if (this.test$2(this.first().msg(), this.first().session(), n$2, p$2, pos$2)) {
            MQueueElement<Msg> res = this.first();
            this.first_$eq(this.first().next());
            if (res == this.last()) {
                this.last_$eq(null);
            }
            option = this.foundMsg$1(res);
            return option;
        }
        MQueueElement<Msg> curr = this.first().next();
        MQueueElement<Msg> prev = this.first();
        while (true) {
            if (curr == null) {
                option = None$.MODULE$;
                return option;
            }
            if (this.test$2(curr.msg(), curr.session(), n$2, p$2, pos$2)) {
                prev.next_$eq(curr.next());
                if (curr != this.last()) return this.foundMsg$1(curr);
                this.last_$eq(prev);
                return this.foundMsg$1(curr);
            }
            prev = curr;
            curr = curr.next();
        }
    }

    private final Some foundMsg$1(MQueueElement x) {
        this.changeSize(-1);
        return new Some<MQueueElement>(x);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean test$2(Object msg, OutputChannel session, int n, Function2 function2, IntRef intRef) {
        if (!BoxesRunTime.unboxToBoolean(function2.apply(msg, session))) return false;
        if (intRef.elem == n) return true;
        ++intRef.elem;
        if (!false) return false;
        return true;
    }

    public MQueue(String label) {
        this.label = label;
        this.first = null;
        this.last = null;
        this._size = 0;
    }
}

