/*
 * Decompiled with CFR 0.152.
 */
package scala.concurrent.forkjoin;

import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantLock;
import scala.concurrent.forkjoin.ForkJoinTask;
import scala.concurrent.forkjoin.ForkJoinWorkerThread;
import scala.concurrent.forkjoin.LinkedTransferQueue;
import sun.misc.Unsafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForkJoinPool {
    public static final ForkJoinWorkerThreadFactory defaultForkJoinWorkerThreadFactory = new DefaultForkJoinWorkerThreadFactory();
    private static final RuntimePermission modifyThreadPermission = new RuntimePermission("modifyThread");
    private static final AtomicInteger poolNumberGenerator = new AtomicInteger();
    public volatile ForkJoinWorkerThread[] workers;
    private final ReentrantLock workerLock;
    private final Condition termination;
    private Thread.UncaughtExceptionHandler ueh;
    private final ForkJoinWorkerThreadFactory factory;
    private volatile WaitQueueNode spareStack;
    private final AtomicLong stealCount;
    private final LinkedTransferQueue<ForkJoinTask<?>> submissionQueue;
    private volatile WaitQueueNode syncStack;
    private volatile long eventCount;
    private final int poolNumber;
    private volatile int maxPoolSize;
    private volatile int parallelism;
    private volatile boolean locallyFifo;
    private volatile int workerCounts;
    private volatile int runControl;
    private volatile boolean maintainsParallelism;
    static final Unsafe _unsafe;
    static final long eventCountOffset;
    static final long workerCountsOffset;
    static final long runControlOffset;
    static final long syncStackOffset;
    static final long spareStackOffset;

    private static void checkPermission() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(modifyThreadPermission);
        }
    }

    private static int totalCountOf(int s) {
        return s >>> 16;
    }

    private static int runningCountOf(int s) {
        return s & 0xFFFF;
    }

    private static int workerCountsFor(int t, int r) {
        return (t << 16) + r;
    }

    final void updateRunningCount(int delta) {
        int s;
        while (!this.casWorkerCounts(s = this.workerCounts, s + delta)) {
        }
    }

    private void updateWorkerCount(int delta) {
        int s;
        int d = delta + (delta << 16);
        while (!this.casWorkerCounts(s = this.workerCounts, s + d)) {
        }
    }

    private static int runStateOf(int c) {
        return c >>> 16;
    }

    private static int activeCountOf(int c) {
        return c & 0xFFFF;
    }

    private static int runControlFor(int r, int a) {
        return (r << 16) + a;
    }

    final boolean tryIncrementActiveCount() {
        int c = this.runControl;
        return this.casRunControl(c, c + 1);
    }

    final boolean tryDecrementActiveCount() {
        int c = this.runControl;
        int nextc = c - 1;
        if (!this.casRunControl(c, nextc)) {
            return false;
        }
        if (ForkJoinPool.canTerminateOnShutdown(nextc)) {
            this.terminateOnShutdown();
        }
        return true;
    }

    private static boolean canTerminateOnShutdown(int c) {
        return (c & -c) >>> 16 != 0;
    }

    private boolean transitionRunStateTo(int state) {
        int c;
        do {
            if (ForkJoinPool.runStateOf(c = this.runControl) < state) continue;
            return false;
        } while (!this.casRunControl(c, ForkJoinPool.runControlFor(state, ForkJoinPool.activeCountOf(c))));
        return true;
    }

    public ForkJoinPool() {
        this(Runtime.getRuntime().availableProcessors(), defaultForkJoinWorkerThreadFactory);
    }

    public ForkJoinPool(int parallelism, ForkJoinWorkerThreadFactory factory) {
        if (parallelism <= 0 || parallelism > Short.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        if (factory == null) {
            throw new NullPointerException();
        }
        ForkJoinPool.checkPermission();
        this.factory = factory;
        this.parallelism = parallelism;
        this.maxPoolSize = Short.MAX_VALUE;
        this.maintainsParallelism = true;
        this.poolNumber = poolNumberGenerator.incrementAndGet();
        this.workerLock = new ReentrantLock();
        this.termination = this.workerLock.newCondition();
        this.stealCount = new AtomicLong();
        this.submissionQueue = new LinkedTransferQueue();
    }

    private ForkJoinWorkerThread createWorker(int index2) {
        Thread.UncaughtExceptionHandler h = this.ueh;
        ForkJoinWorkerThread w = this.factory.newThread(this);
        if (w != null) {
            w.poolIndex = index2;
            w.setDaemon(true);
            w.setAsyncMode(this.locallyFifo);
            w.setName("ForkJoinPool-" + this.poolNumber + "-worker-" + index2);
            if (h != null) {
                w.setUncaughtExceptionHandler(h);
            }
        }
        return w;
    }

    private static int arraySizeFor(int ps) {
        return ps <= 1 ? 1 : 1 << 32 - Integer.numberOfLeadingZeros(ps - 1);
    }

    public static ForkJoinWorkerThread[] copyOfWorkers(ForkJoinWorkerThread[] original, int newLength) {
        ForkJoinWorkerThread[] copy = new ForkJoinWorkerThread[newLength];
        System.arraycopy(original, 0, copy, 0, Math.min(newLength, original.length));
        return copy;
    }

    private ForkJoinWorkerThread[] ensureWorkerArrayCapacity(int newLength) {
        ForkJoinWorkerThread[] ws = this.workers;
        if (ws == null) {
            this.workers = new ForkJoinWorkerThread[ForkJoinPool.arraySizeFor(newLength)];
            return this.workers;
        }
        if (newLength > ws.length) {
            this.workers = ForkJoinPool.copyOfWorkers(ws, ForkJoinPool.arraySizeFor(newLength));
            return this.workers;
        }
        return ws;
    }

    private void tryShrinkWorkerArray() {
        ForkJoinWorkerThread[] ws = this.workers;
        if (ws != null) {
            int last2;
            int len = ws.length;
            for (last2 = len - 1; last2 >= 0 && ws[last2] == null; --last2) {
            }
            int newLength = ForkJoinPool.arraySizeFor(last2 + 1);
            if (newLength < len) {
                this.workers = ForkJoinPool.copyOfWorkers(ws, newLength);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void ensureWorkerInitialization() {
        ForkJoinWorkerThread[] ws = this.workers;
        if (ws == null) {
            ReentrantLock lock = this.workerLock;
            lock.lock();
            try {
                ws = this.workers;
                if (ws == null) {
                    int ps = this.parallelism;
                    ws = this.ensureWorkerArrayCapacity(ps);
                    for (int i = 0; i < ps; ++i) {
                        ForkJoinWorkerThread w = this.createWorker(i);
                        if (w == null) continue;
                        ws[i] = w;
                        w.start();
                        this.updateWorkerCount(1);
                    }
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    private void createAndStartAddedWorkers() {
        this.resumeAllSpares();
        int ps = this.parallelism;
        ForkJoinWorkerThread[] ws = this.ensureWorkerArrayCapacity(ps);
        int len = ws.length;
        int k = 0;
        while (k < len) {
            if (ws[k] != null) {
                ++k;
                continue;
            }
            int s = this.workerCounts;
            int tc = ForkJoinPool.totalCountOf(s);
            int rc = ForkJoinPool.runningCountOf(s);
            if (rc >= ps || tc >= ps) break;
            if (!this.casWorkerCounts(s, ForkJoinPool.workerCountsFor(tc + 1, rc + 1))) continue;
            ForkJoinWorkerThread w = this.createWorker(k);
            if (w != null) {
                ws[k++] = w;
                w.start();
                continue;
            }
            this.updateWorkerCount(-1);
            break;
        }
    }

    private <T> void doSubmit(ForkJoinTask<T> task) {
        if (this.isShutdown()) {
            throw new RejectedExecutionException();
        }
        if (this.workers == null) {
            this.ensureWorkerInitialization();
        }
        this.submissionQueue.offer(task);
        this.signalIdleWorkers();
    }

    public void execute(Runnable task) {
        this.doSubmit(new AdaptedRunnable<Object>(task, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParallelism(int parallelism) {
        ForkJoinPool.checkPermission();
        if (parallelism <= 0 || parallelism > this.maxPoolSize) {
            throw new IllegalArgumentException();
        }
        ReentrantLock lock = this.workerLock;
        lock.lock();
        try {
            if (!this.isTerminating()) {
                int p = this.parallelism;
                this.parallelism = parallelism;
                if (parallelism > p) {
                    this.createAndStartAddedWorkers();
                } else {
                    this.trimSpares();
                }
            }
        }
        finally {
            lock.unlock();
        }
        this.signalIdleWorkers();
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public int getMaximumPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaximumPoolSize(int newMax) {
        if (newMax < 0 || newMax > Short.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        this.maxPoolSize = newMax;
    }

    public boolean setAsyncMode(boolean async) {
        boolean oldMode = this.locallyFifo;
        this.locallyFifo = async;
        ForkJoinWorkerThread[] ws = this.workers;
        if (ws != null) {
            for (int i = 0; i < ws.length; ++i) {
                ForkJoinWorkerThread t = ws[i];
                if (t == null) continue;
                t.setAsyncMode(async);
            }
        }
        return oldMode;
    }

    public boolean isQuiescent() {
        return ForkJoinPool.activeCountOf(this.runControl) == 0;
    }

    public long getStealCount() {
        return this.stealCount.get();
    }

    private void updateStealCount(ForkJoinWorkerThread w) {
        int sc = w.getAndClearStealCount();
        if (sc != 0) {
            this.stealCount.addAndGet(sc);
        }
    }

    public long getQueuedTaskCount() {
        long count2 = 0L;
        ForkJoinWorkerThread[] ws = this.workers;
        if (ws != null) {
            for (int i = 0; i < ws.length; ++i) {
                ForkJoinWorkerThread t = ws[i];
                if (t == null) continue;
                count2 += (long)t.getQueueSize();
            }
        }
        return count2;
    }

    public int getQueuedSubmissionCount() {
        return this.submissionQueue.size();
    }

    public boolean hasQueuedSubmissions() {
        return !this.submissionQueue.isEmpty();
    }

    protected ForkJoinTask<?> pollSubmission() {
        return this.submissionQueue.poll();
    }

    protected int drainTasksTo(Collection<ForkJoinTask<?>> c) {
        int n = this.submissionQueue.drainTo(c);
        ForkJoinWorkerThread[] ws = this.workers;
        if (ws != null) {
            for (int i = 0; i < ws.length; ++i) {
                ForkJoinWorkerThread w = ws[i];
                if (w == null) continue;
                n += w.drainTasksTo(c);
            }
        }
        return n;
    }

    public String toString() {
        int ps = this.parallelism;
        int wc = this.workerCounts;
        int rc = this.runControl;
        long st = this.getStealCount();
        long qt = this.getQueuedTaskCount();
        long qs = this.getQueuedSubmissionCount();
        return super.toString() + "[" + ForkJoinPool.runStateToString(ForkJoinPool.runStateOf(rc)) + ", parallelism = " + ps + ", size = " + ForkJoinPool.totalCountOf(wc) + ", active = " + ForkJoinPool.activeCountOf(rc) + ", running = " + ForkJoinPool.runningCountOf(wc) + ", steals = " + st + ", tasks = " + qt + ", submissions = " + qs + "]";
    }

    private static String runStateToString(int rs) {
        switch (rs) {
            case 0: {
                return "Running";
            }
            case 1: {
                return "Shutting down";
            }
            case 2: {
                return "Terminating";
            }
            case 3: {
                return "Terminated";
            }
        }
        throw new Error("Unknown run state");
    }

    public void shutdown() {
        ForkJoinPool.checkPermission();
        this.transitionRunStateTo(1);
        if (ForkJoinPool.canTerminateOnShutdown(this.runControl)) {
            this.terminateOnShutdown();
        }
    }

    public boolean isTerminating() {
        return ForkJoinPool.runStateOf(this.runControl) >= 2;
    }

    public boolean isShutdown() {
        return ForkJoinPool.runStateOf(this.runControl) >= 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void workerTerminated(ForkJoinWorkerThread w) {
        this.updateStealCount(w);
        this.updateWorkerCount(-1);
        ReentrantLock lock = this.workerLock;
        lock.lock();
        try {
            ForkJoinWorkerThread[] ws = this.workers;
            if (ws != null) {
                int idx = w.poolIndex;
                if (idx >= 0 && idx < ws.length && ws[idx] == w) {
                    ws[idx] = null;
                }
                if (ForkJoinPool.totalCountOf(this.workerCounts) == 0) {
                    this.terminate();
                    this.transitionRunStateTo(3);
                    this.termination.signalAll();
                } else if (!this.isTerminating()) {
                    this.tryShrinkWorkerArray();
                    this.tryResumeSpare(true);
                }
            }
        }
        finally {
            lock.unlock();
        }
        this.signalIdleWorkers();
    }

    private void terminate() {
        if (this.transitionRunStateTo(2)) {
            this.stopAllWorkers();
            this.resumeAllSpares();
            this.signalIdleWorkers();
            this.cancelQueuedSubmissions();
            this.cancelQueuedWorkerTasks();
            this.interruptUnterminatedWorkers();
            this.signalIdleWorkers();
        }
    }

    private void terminateOnShutdown() {
        if (!this.hasQueuedSubmissions() && ForkJoinPool.canTerminateOnShutdown(this.runControl)) {
            this.terminate();
        }
    }

    private void cancelQueuedSubmissions() {
        ForkJoinTask<?> task;
        while ((task = this.pollSubmission()) != null) {
            task.cancel(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelQueuedWorkerTasks() {
        ReentrantLock lock = this.workerLock;
        lock.lock();
        try {
            ForkJoinWorkerThread[] ws = this.workers;
            if (ws != null) {
                for (int i = 0; i < ws.length; ++i) {
                    ForkJoinWorkerThread t = ws[i];
                    if (t == null) continue;
                    t.cancelTasks();
                }
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopAllWorkers() {
        ReentrantLock lock = this.workerLock;
        lock.lock();
        try {
            ForkJoinWorkerThread[] ws = this.workers;
            if (ws != null) {
                for (int i = 0; i < ws.length; ++i) {
                    ForkJoinWorkerThread t = ws[i];
                    if (t == null) continue;
                    t.shutdownNow();
                }
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void interruptUnterminatedWorkers() {
        ReentrantLock lock = this.workerLock;
        lock.lock();
        try {
            ForkJoinWorkerThread[] ws = this.workers;
            if (ws != null) {
                for (int i = 0; i < ws.length; ++i) {
                    ForkJoinWorkerThread t = ws[i];
                    if (t == null || t.isTerminated()) continue;
                    try {
                        t.interrupt();
                        continue;
                    }
                    catch (SecurityException ignore) {
                        // empty catch block
                    }
                }
            }
        }
        finally {
            lock.unlock();
        }
    }

    final long ensureSync() {
        WaitQueueNode q;
        long c = this.eventCount;
        while ((q = this.syncStack) != null && q.count < c) {
            if (!this.casBarrierStack(q, null)) continue;
            do {
                q.signal();
            } while ((q = q.next) != null);
            break;
        }
        return c;
    }

    private void signalIdleWorkers() {
        long c;
        while (!this.casEventCount(c = this.eventCount, c + 1L)) {
        }
        this.ensureSync();
    }

    final void signalWork() {
        WaitQueueNode q;
        long c;
        if (!(this.syncStack == null || !this.casEventCount(c = this.eventCount, c + 1L) || (q = this.syncStack) == null || q.count > c || this.casBarrierStack(q, q.next) && q.signal())) {
            this.ensureSync();
        }
    }

    final void sync(ForkJoinWorkerThread w) {
        this.updateStealCount(w);
        while (!(w.isShutdown() || this.isTerminating() || this.suspendIfSpare(w))) {
            long ec;
            WaitQueueNode h;
            long prev = w.lastEventCount;
            WaitQueueNode node = null;
            while (this.eventCount == prev && ((h = this.syncStack) == null || h.count == prev)) {
                if (node == null) {
                    node = new WaitQueueNode(prev, w);
                }
                if (!this.casBarrierStack(node.next = h, node)) continue;
                node.awaitSyncRelease(this);
                break;
            }
            if ((ec = this.ensureSync()) == prev) continue;
            w.lastEventCount = ec;
            break;
        }
    }

    final boolean syncIsReleasable(WaitQueueNode node) {
        long prev = node.count;
        if (!(Thread.interrupted() || node.thread == null || node.next == null && ForkJoinWorkerThread.hasQueuedTasks(this.workers) || this.eventCount != prev)) {
            return false;
        }
        if (node.thread != null) {
            node.thread = null;
            long ec = this.eventCount;
            if (prev <= ec) {
                this.casEventCount(ec, ec + 1L);
            }
        }
        return true;
    }

    final boolean hasNewSyncEvent(ForkJoinWorkerThread w) {
        long lc = w.lastEventCount;
        long ec = this.ensureSync();
        if (ec == lc) {
            return false;
        }
        w.lastEventCount = ec;
        return true;
    }

    final boolean preJoin(ForkJoinTask<?> joinMe, boolean maintainParallelism) {
        maintainParallelism &= this.maintainsParallelism;
        boolean dec = false;
        while (this.spareStack == null || !this.tryResumeSpare(dec)) {
            int counts = this.workerCounts;
            if (!dec && !(dec = this.casWorkerCounts(counts--, counts))) continue;
            if (!this.needSpare(counts, maintainParallelism)) break;
            if (joinMe.status < 0) {
                return true;
            }
            if (!this.tryAddSpare(counts)) continue;
            break;
        }
        return false;
    }

    final boolean preBlock(ManagedBlocker blocker, boolean maintainParallelism) {
        maintainParallelism &= this.maintainsParallelism;
        boolean dec = false;
        while (this.spareStack == null || !this.tryResumeSpare(dec)) {
            int counts = this.workerCounts;
            if (!dec && !(dec = this.casWorkerCounts(counts--, counts))) continue;
            if (!this.needSpare(counts, maintainParallelism)) break;
            if (blocker.isReleasable()) {
                return true;
            }
            if (!this.tryAddSpare(counts)) continue;
            break;
        }
        return false;
    }

    private boolean needSpare(int counts, boolean maintainParallelism) {
        int ps = this.parallelism;
        int rc = ForkJoinPool.runningCountOf(counts);
        int tc = ForkJoinPool.totalCountOf(counts);
        int runningDeficit = ps - rc;
        int totalSurplus = tc - ps;
        return tc < this.maxPoolSize && (rc == 0 || totalSurplus < 0 || maintainParallelism && runningDeficit > totalSurplus && ForkJoinWorkerThread.hasQueuedTasks(this.workers));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryAddSpare(int expectedCounts) {
        boolean success;
        block7: {
            ReentrantLock lock = this.workerLock;
            int expectedRunning = ForkJoinPool.runningCountOf(expectedCounts);
            int expectedTotal = ForkJoinPool.totalCountOf(expectedCounts);
            success = false;
            boolean locked = false;
            try {
                int rc;
                int tc;
                int s;
                do {
                    s = this.workerCounts;
                    tc = ForkJoinPool.totalCountOf(s);
                    rc = ForkJoinPool.runningCountOf(s);
                    if (rc > expectedRunning) break block7;
                    if (tc > expectedTotal) {
                    } else if (locked || (locked = lock.tryLock())) continue;
                    break block7;
                } while (!this.casWorkerCounts(s, ForkJoinPool.workerCountsFor(tc + 1, rc + 1)));
                this.createAndStartSpare(tc);
                success = true;
            }
            finally {
                if (locked) {
                    lock.unlock();
                }
            }
        }
        return success;
    }

    private void createAndStartSpare(int k) {
        ForkJoinWorkerThread w = null;
        ForkJoinWorkerThread[] ws = this.ensureWorkerArrayCapacity(k + 1);
        int len = ws.length;
        if (k < len && ws[k] != null) {
            for (k = 0; k < len && ws[k] != null; ++k) {
            }
        }
        if (k < len && !this.isTerminating() && (w = this.createWorker(k)) != null) {
            ws[k] = w;
            w.start();
        } else {
            this.updateWorkerCount(-1);
        }
        this.signalIdleWorkers();
    }

    private boolean suspendIfSpare(ForkJoinWorkerThread w) {
        int s;
        WaitQueueNode node = null;
        while (this.parallelism < ForkJoinPool.runningCountOf(s = this.workerCounts)) {
            if (node == null) {
                node = new WaitQueueNode(0L, w);
            }
            if (!this.casWorkerCounts(s, s - 1)) continue;
            while (!this.casSpareStack(node.next = this.spareStack, node)) {
            }
            node.awaitSpareRelease();
            return true;
        }
        return false;
    }

    private boolean tryResumeSpare(boolean updateCount) {
        WaitQueueNode q;
        while ((q = this.spareStack) != null) {
            if (!this.casSpareStack(q, q.next)) continue;
            if (updateCount) {
                this.updateRunningCount(1);
            }
            q.signal();
            return true;
        }
        return false;
    }

    private boolean resumeAllSpares() {
        WaitQueueNode q;
        while ((q = this.spareStack) != null) {
            if (!this.casSpareStack(q, null)) continue;
            do {
                this.updateRunningCount(1);
                q.signal();
            } while ((q = q.next) != null);
            return true;
        }
        return false;
    }

    private void trimSpares() {
        WaitQueueNode q;
        int surplus = ForkJoinPool.totalCountOf(this.workerCounts) - this.parallelism;
        while (surplus > 0 && (q = this.spareStack) != null) {
            if (!this.casSpareStack(q, null)) continue;
            do {
                this.updateRunningCount(1);
                ForkJoinWorkerThread w = q.thread;
                if (w != null && surplus > 0 && ForkJoinPool.runningCountOf(this.workerCounts) > 0 && w.shutdown()) {
                    --surplus;
                }
                q.signal();
            } while ((q = q.next) != null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void managedBlock(ManagedBlocker blocker, boolean maintainParallelism) throws InterruptedException {
        ForkJoinPool pool;
        Thread t = Thread.currentThread();
        ForkJoinPool forkJoinPool = pool = t instanceof ForkJoinWorkerThread ? ((ForkJoinWorkerThread)t).pool : null;
        if (!blocker.isReleasable()) {
            try {
                if (pool == null || !pool.preBlock(blocker, maintainParallelism)) {
                    ForkJoinPool.awaitBlocker(blocker);
                }
            }
            finally {
                if (pool != null) {
                    pool.updateRunningCount(1);
                }
            }
        }
    }

    private static void awaitBlocker(ManagedBlocker blocker) throws InterruptedException {
        while (!blocker.isReleasable() && !blocker.block()) {
        }
    }

    private static Unsafe getUnsafe() throws Throwable {
        try {
            return Unsafe.getUnsafe();
        }
        catch (SecurityException se) {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<Unsafe>(){

                    @Override
                    public Unsafe run() throws Exception {
                        return ForkJoinPool.getUnsafePrivileged();
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw e.getCause();
            }
        }
    }

    private static Unsafe getUnsafePrivileged() throws NoSuchFieldException, IllegalAccessException {
        Field field = Unsafe.class.getDeclaredField("theUnsafe");
        field.setAccessible(true);
        return (Unsafe)field.get(null);
    }

    private static long fieldOffset(String string) throws NoSuchFieldException {
        return _unsafe.objectFieldOffset(ForkJoinPool.class.getDeclaredField(string));
    }

    private boolean casEventCount(long cmp, long val) {
        return _unsafe.compareAndSwapLong(this, eventCountOffset, cmp, val);
    }

    private boolean casWorkerCounts(int cmp, int val) {
        return _unsafe.compareAndSwapInt(this, workerCountsOffset, cmp, val);
    }

    private boolean casRunControl(int cmp, int val) {
        return _unsafe.compareAndSwapInt(this, runControlOffset, cmp, val);
    }

    private boolean casSpareStack(WaitQueueNode cmp, WaitQueueNode val) {
        return _unsafe.compareAndSwapObject(this, spareStackOffset, cmp, val);
    }

    private boolean casBarrierStack(WaitQueueNode cmp, WaitQueueNode val) {
        return _unsafe.compareAndSwapObject(this, syncStackOffset, cmp, val);
    }

    static {
        try {
            _unsafe = ForkJoinPool.getUnsafe();
            eventCountOffset = ForkJoinPool.fieldOffset("eventCount");
            workerCountsOffset = ForkJoinPool.fieldOffset("workerCounts");
            runControlOffset = ForkJoinPool.fieldOffset("runControl");
            syncStackOffset = ForkJoinPool.fieldOffset("syncStack");
            spareStackOffset = ForkJoinPool.fieldOffset("spareStack");
        }
        catch (Throwable e) {
            throw new RuntimeException("Could not initialize intrinsics", e);
        }
    }

    public static interface ManagedBlocker {
        public boolean block() throws InterruptedException;

        public boolean isReleasable();
    }

    static final class WaitQueueNode {
        WaitQueueNode next;
        volatile ForkJoinWorkerThread thread;
        final long count;

        WaitQueueNode(long c, ForkJoinWorkerThread w) {
            this.count = c;
            this.thread = w;
        }

        boolean signal() {
            ForkJoinWorkerThread t = this.thread;
            if (t == null) {
                return false;
            }
            this.thread = null;
            LockSupport.unpark(t);
            return true;
        }

        void awaitSyncRelease(ForkJoinPool p) {
            while (this.thread != null && !p.syncIsReleasable(this)) {
                LockSupport.park(this);
            }
        }

        void awaitSpareRelease() {
            while (this.thread != null) {
                if (Thread.interrupted()) continue;
                LockSupport.park(this);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class AdaptedRunnable<T>
    extends ForkJoinTask<T>
    implements RunnableFuture<T> {
        final Runnable runnable;
        final T resultOnCompletion;
        T result;

        AdaptedRunnable(Runnable runnable, T result2) {
            if (runnable == null) {
                throw new NullPointerException();
            }
            this.runnable = runnable;
            this.resultOnCompletion = result2;
        }

        @Override
        public T getRawResult() {
            return this.result;
        }

        @Override
        public boolean exec() {
            this.runnable.run();
            this.result = this.resultOnCompletion;
            return true;
        }

        @Override
        public void run() {
            this.invoke();
        }
    }

    static class DefaultForkJoinWorkerThreadFactory
    implements ForkJoinWorkerThreadFactory {
        DefaultForkJoinWorkerThreadFactory() {
        }

        public ForkJoinWorkerThread newThread(ForkJoinPool pool) {
            try {
                return new ForkJoinWorkerThread(pool);
            }
            catch (OutOfMemoryError oom) {
                return null;
            }
        }
    }

    public static interface ForkJoinWorkerThreadFactory {
        public ForkJoinWorkerThread newThread(ForkJoinPool var1);
    }

    static interface RunnableFuture
    extends Runnable {
    }
}

