<?php // -*- coding:utf-8 -*-
// Parameters:

// lang=xx    : only translates language 'xx',
//              if not given all languages are translated

// comments   : generate all comments (equal to close&module)

// close      : look for similar strings that are already translated and
//              generate a comment if a 'match' is made

// module     : generate comments that describe in which .php and/or .tpl
//              module(s) a certain string was found (useful for checking
//              translations in context)

// patch      : looks for the file 'language.patch' in the same directory
//              as the corresponding language.php and overrides any strings
//              in language.php - good if a user does not agree with
//              some translations or if only changes are sent to the maintainer

// spelling   : generates a file 'spellcheck_me.txt' that contains the
//              words used in the translation. It is then easy to check this
//              file for spelling errors (corrections must be done in
//              'language.php, however)

// groupwrite : Sets the generated files permissions to allow the generated
//              language.php also be group writable. This is good for
//              translators if they do not have root access to tiki but
//              are in the same group as the webserver. Please remember
//              to have write access removed when translation is finished
//              for security reasons. (Run script again without this
//              parameter)

// Examples:
// http://www.neonchart.com/get_strings.php?lang=sv
// Will translate language 'sv' and (almost) avoiding comment generation

// http://www.neonchart.com/get_strings.php?lang=sv&comments
// Will translate language 'sv' and generate all possible comments.
// This is the most usefull mode when working on a translation.

// http://www.neonchart.com/get_strings.php?lang=sv&nohelp&nosections
// These options will only provide the minimal amout of comments.
// Usefull mode when preparing a translation for distribution.

// http://www.neonchart.com/get_strings.php?nohelp&nosections
// Prepare all languages for release


// ### Note for translators about translation of text ending with punctuation
// ###
// ### The current list of concerned punctuation can be found in 'lib/init/tra.php'
// ### On 2009-03-02, it is: (':', '!', ';', '.', ',', '?')
// ### For clarity, we explain here only for colons: ':' but it is the same for the rest
// ###
// ### Short version: it is not a problem that string "Login:" has no translation. Only "Login" needs to be translated.
// ###
// ### Technical justification:
// ### If a string ending with colon needs translating (like "{tr}Login:{/tr}")
// ### then TikiWiki tries to translate 'Login' and ':' separately.
// ### This allows to have only one translation for "{tr}Login{/tr}" and "{tr}Login:{/tr}"
// ### and it still allows to translate ":" as "&nbsp;:" for languages that
// ### need it (like french)

$lang=Array(
// ### Start of unused words
// ### Please remove manually!
// ### N.B. Legitimate strings may be marked// ### as unused!
// ### Please see http://tikiwiki.org/tiki-index.php?page=UnusedWords for further info
" at " => " v ",
" modified" => " zmenené",
" new topic:" => " nová téma:",
"+1d" => "+1d",
"+1m" => "+1m",
"+7d" => "+7d",
">Remove Zones (you lose entered info for the banner)" => ">Odstrániť zóny (stratíte vložené info o banneri)",
"A new password has been sent " => "Nové heslo bolo odoslané ",
"Add New Group" => "Pridať novú skupinu",
"Add all your site users to this newsletter (broadcast)" => "Prihlásiť všetkých užívateľov webu k odberu tohoto newsletteru (broadcast)",
"Add or edit a task" => "Pridať alebo upraviť úlohu",
"Add scaled images size X x Y" => "Pridať obrázky s upravenýmy rozmermi X &times; Y",
"Add users" => "Pridať užívateľov",
"Admin (click!)" => "Admin&nbsp;(klikni&nbsp;sem!)",
"Admin HTML page dynamic zones" => "Administrácia dynamických súčastí HTML stránok",
"Admin structures" => "Administrácia štruktúr",
"All tasks" => "Všetky úlohy",
"Anonymous users cannot edit pages" => "Anonymní užívatelia nemôžu upravovať stránky",
"Apr" => "Apr",
"Archived page:" => "Archív stránky:",
"Articles listing configuration" => "Nastavenie prehľadu článkov",
"Assign permissions to this page" => "Priradiť práva tejto stránke",
"Aug" => "Aug",
"Average posts pero weblog" => "Priemerne záznamov na blog",
"Bye bye from " => "Pozdravy od ",
"CMS settings" => "Nastavenia CMS",
"Cache wiki pages" => "Cache wiki stránky",
"Calendars Panel" => "Panel kalendárov",
"Change your email" => "Zmente svoj email",
"Click here to create a new backup" => "Klepnite sem pre vytvorenie novej zálohy",
"Click to enlarge" => "Klepnite pre zväčšenie",
"Cms" => "Cms",
"Comm" => "Príkaz",
"Configure this page" => "Konfigurovať túto stránku",
"Control by Object" => "Riadiť podľa objektov",
"Control by category" => "Riadiť podľa kategórie",
"Create New Survey:" => "Vytvoriť nový prieskum:",
"Create structure from tree" => "Vytvoriť štruktúru zo stromu",
"Create/edit extwiki" => "Vytvoriť/upraviť extwiki",
"Current page:" => "Súčasná stránka:",
"Dec" => "Dec",
"Diff of %s." => "Rozdiel %s",
"Diff:" => "Rozdiely:",
"Directory (include trailing slash)" => "Adresár (aj s posledným /)",
"Displays a snippet of code.\nSet optional paramater -+ln+- to 1 if you need line numbering feature." => "Zobrazí zdrojový text.\nSet optional paramater -+ln+- to 1 if you need line numbering feature",
"Edit drawings" => "Upraviť kresby",
"Edit this group:" => "Upraviť túto skupinu:",
"ExtWikis" => "Ext.&nbsp;wiki",
"FAQ Answers" => "Časté otázky - Odpovede",
"FAQ Questions" => "Časté otázky - Otázky",
"Feb" => "Feb",
"File gals" => "Kolekcie súborov",
"Forward messages to this forum to this email" => "Preposlať správy z tohoto fóra na tento e-mail",
"Hide Panels" => "Skryť panely",
"Hide Post Form" => "Skrýť formulár",
"Hide suggested questions" => "Skryť odporučené otázky",
"If you change the calendar selection, please refresh to get the appropriated list in Category, Location and people (if applicable to the calendar you choose)." => "Pokud you change the calendar selection, please refresh to get the appropriated list in Category, Location and people (if applicable to the calendar you choose)",
"Image gals" => "Galérie obrázkov",
"Import pages from a PHPWiki Dump" => "Importovať stránky z PHPWiki Dumpu",
"In blog listing show user as" => "V blogoch ukazuj userov ako",
"In parent page" => "Na rodičovskej stránke",
"Jan" => "Jan",
"Mailin accounts" => "Mailin accounts",
"Mar" => "Mar",
"Mark as Flagged" => "Označiť vlajočkou",
"More info about" => "Viac informácií o",
"Mus enter a name to add a site" => "Aby ste mohli pridať web, musíte zadať jeho názov",
"MyTiki (click!)" => "Moje Tiki",
"Navigation Panel" => "Navigačný panel",
"New article submitted at " => "Nový článok zaslaný dňa ",
"New message arrived from " => "Přišla nová správa od ",
"Newss from" => "News from",
"No image uploaded" => "žiadny obrázok nebol nahratý",
"Nov" => "Nov",
"Oct" => "Okt",
"Options (separated by commas used in dropdowns only)" => "Možnosti (oddelené čiarkami, použiteľné iba v dropdownoch)",
"PHPOpenTracker" => "PHPOpenTracker",
"Path to where the dumped files are (relative to tiki basedir with trailing slash ex: dump/)" => "Path to where the dumped files are (relative to tiki basedir s trailing slash ex: dump/)",
"Permission denied you cannot browse this gallery" => "Nemáte dostatočné oprávnenia na prezeranie tejto galérie",
"Posted comments" => "Zaslané komentáre",
"Prevent users from voting same item more than one time" => "Prevent users from voting same item more than one time",
"Prevents parsing data" => "Zabraňuje parsingu dat",
"Ranking" => "Hodnotenie",
"Renders a graph" => "Generuje graf",
"Return to messages" => "Späť na správy",
"Reuse question" => "Znovu použiť otázku",
"Sep" => "Sep",
"Server time zone" => "Časové pásmo na serveri",
"Set feeds" => "Nastaviť feeds",
"Set home forum" => "Nastaviť hlavné fórum",
"Set prefs" => "Nastaviť preference",
"Show Post Form" => "Zobraziť formulář",
"Show chart for the last " => "Zobraziť graf za posledné ",
"Show status when listing tracker items?" => "Zobraziť status v zozname tracker items?",
"Show suggested questions/suggest a question" => "Zobraziť navrhované otázky/Navrhnite otázku",
"The new page content is:" => "Novým obsahom stránky je:",
"There is an error in the plugin data" => "There is an error in the plugin data",
"Threads can be voted" => "Threads can be voted",
"Tiki Calendars" => "Tiki kalendáre",
"Tiki forums" => "Diskusné fóra",
"Time Zone Map" => "Mapa časových pásiem",
"Time Zone" => "Časové pásmo",
"Top Files" => "Top súbory",
"URL cannot be accessed wrong URL or site is offline and cannot be added to the directory" => "URL sa nedá overiť; nesprávne URL alebo je server offline a preto nemôže byť pridaný do katalógu",
"Unflagg" => "Odznačiť",
"Upload was not successful (maybe a duplicate file)" => "Prenos nebol úspešne dokončený (pravdepodobne duplikovaný súbor)",
"Use (:name:) for smileys" => "Použite (:name:) pre vytvorenie smajlíka",
"Use dbl click to edit pages" => "Používať dvojité klepnutie pre úpravy stránky",
"User can Configure Modules" => "Užívateľ môže konfigurovať moduly",
"User watches" => "Užívateľské nastavené sledovania",
"Users can subscribe any email addresss" => "Užívatelia môžu přihlásit jakoukoliv e-mailovou adresu",
"Users can vote only one item from this chart per period" => "Užívatelia môžu voliť iba jednu položku z tohoto grafu v rozmedzí",
"Warn on edit" => "Varovať pri úprave",
"Welcome to " => "Vitajte v ",
"Wiki Import dump" => "Wiki import výpisu",
"Wiki Page Names" => "mená Wiki stránok",
"Wiki page" => "Wiki stránka",
"You can edit the page following this link:" => "Môžete upraviť the page following this link:",
"You can include the image in an HTML or Tiki page using" => "Obrázok môžete vložit do HTML alebo Tiki stránky použitím",
"You can include the image in an HTML/Tiki page using" => "Môžete vložiť obrázok do HTML/Tiki stránky použitím",
"You should first ask that a calendar is created, so you can create events attached to it." => "You should first ask that a calendar is created, so you can create events attached to it",
"Your Tiki account information for" => "Your Tiki account information for",
"\n for rows" => "\n pre riadky",
"act status" => "akt. status",
"assgn" => "priraď.",
"assign group" => "priradiť skupinu",
"assign_perms" => "priradiť práva",
"blog_ranking_last_posts" => "blog_ranking_last_posts",
"blog_ranking_top_active_blogs" => "blog_ranking_top_active_blogs",
"blog_ranking_top_blogs" => "blog_ranking_top_blogs",
"browse by" => "prezerať podľa",
"by %s" => ", %s",
"categorize" => "kategorizovať",
"center" => "vycentrovať",
"checked" => "zaškrtnuté",
"choose" => "vybrať",
"create new empty structure" => "vytvoriť novú prázdnu štruktúru",
"created from phpwiki import" => "created from phpwiki import",
"creation date" => "dátum vytvorenia",
"days (0=all)" => "dni (0=všetky)",
"forum topic" => "fórum: téma",
"from the list" => "zo zoznamu",
"half a second" => "pol sekundy",
"heading" => "hlavička",
"hide from display" => "skryť",
"horizontal ruler" => "horizontálna čiara",
"idle" => "Zdržanie",
"img nc" => "[img nc]",
"last modification time" => "posledný čas modifikácie",
"last modified on %s" => "posledná úprava %s",
"last_login" => "posledné prihlásenie",
"link_description" => "popiska odkazu",
"mark as done" => "označiť ako hotové",
"mot" => "mot",
"op" => "op",
"open tasks" => "otvorené úlohy",
"parent" => "nadradená",
"remove bookmark" => "remove bookmark",
"reply to this" => "odpovedať na toto",
"report this post" => "nahlásiť tento záznam",
"running" => "spustené",
"save a custom copy" => "save a custom copy",
"smileys" => "smajlíci",
"someone from" => "niekto z",
"stat" => "stat",
"strict" => "striktný",
"this post was reported" => "tento záznam bol nahlásený",
"today" => "dnes",
"topic:" => "téma:",
"unchecked" => "unchecked",
"updated by the phpwiki import process" => "updated by the phpwiki import process",
"use filename" => "použiť názov súboru",
"use square brackets for an" => "použite hranaté zátvorky na",
"ver" => "ver",
"version %s" => "verzia %s",
"view info" => "zobraziť info",
"wiki link" => "wiki link",
"with role" => "with role",
"tbheight" => "tbheight",
"Ins" => "Ins",
"Quicklinks" => "Quicklinks",
"perm" => "perm",
"You do not have permission to use this feature." => "Nemáte dostatočné oprávnenia pre použitie tejto funkcie",
"no description" => "bez popisky",
"requested a reminder of the password for the" => "požiadal o pripomenutie hesla pre",
"since this is your registered email address we inform that the" => "keďže toto je your registered email address we inform that the",
"password for this account is" => "heslo pre tento account je",
"Information:" => "Informácie:",
"New blog post: {\$mail_title} by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "Nový záznam blogu: {\$mail_title} od {\$mail_user} dňa {\$mail_date|tiki_short_datetime}",
"Blog settings" => "Nastavenia blogu",
"FAQs settings" => "Nastavenia pre časté otázky",
"FAQ comments" => "Komentáre k častým otázkam",
"Remind passwords by email" => "Pripomínať heslá emailom",
"Poll settings" => "Nastavenia pre ankety",
"Create a tag for the current wiki" => "Vytvoriť značku pre súčasné wiki",
"Restore the wiki" => "Obnoviť wiki",
"Wiki comments settings" => "Nastavenia Wiki komentárov",
"Wiki page list configuration" => "Konfigurácia prehľadu Wiki stránok",
"Like pages" => "Podobné stránky",
"Use {literal}{{/literal}ed id=name} or {literal}{{/literal}ted id=name} to insert dynamic zones" => "Použite {literal}{{/literal}ed id=name} alebo {literal}{{/literal}ted id=name} pre vloženie dynamických zón",
"Added users" => "Pridaní užívatelia",
"Note: if you want to use images please save the post first and you\nwill be able to edit/post images. Use the &lt;img&gt; snippet to include uploaded images in the textarea editor\nor use the image URL to include images using the WYSIWYG editor" => "Poznámka: Ak chcete použiť obrázky, uložte prosím najprv tento príspevok a dostanete\nmožnosť editovať obrázky. Použite &lt;img&gt; element na umiestnenie uploadnutého obrázku to textu v editore",
"search category" => "prehľadať kategóriu",
"deep" => "do hĺbky",
"Textheight" => "Výška textu",
"Height of top Heading" => "Výška hornej hlavičky",
"Height of mid Heading" => "Výška prostrednej hlavičky",
"Height of inner Heading" => "Výška vnútornej hlavičky",
"Emphasis" => "Zvýraznenie",
"italics" => "sklonené",
"both" => "obe dohromady",
"use ...page... to separate pages" => "použite ...page... pre oddelenie stránok",
"make_headings" => "vytvoriť hlavičky",
"underlines text" => "podčiarkne text",
"Simple box" => "Jednoduchý box",
"Will display using the indicated HTML color" => "Bude zobrazené zvolenou HTML farbou",
"Will display the text centered" => "Zobrazí text vycentrovaný",
"Activs" => "Aktivity",
"time" => "čas",
"Comparing versions" => "Porovnávánie verzií",
"Actual_version" => "Aktuálna verzia",
"Diff to version" => "Rozdiely oproti verzii",
"Editing tracker item" => "Upravovanie položky prehľadu",
"The passwords dont match" => "Heslá sa nezhodujú",
"You do not have permission to write the template" => "Nemáte dostatočné oprávnenia. Nemôžete uložiť šablónu",
"You have to provide a name to the image" => "Musíte zadať názov obrázku",
"standard" => "standard",
"cache" => "cache",
"export" => "export",
"discuss" => "discuss",
"switch" => "switch",
"wiki help" => "wiki help",
"flag" => "flag",
"Require HTTP Basic authentication" => "Require HTTP Basic authentication",
"HTTP URL prefix" => "HTTP URL prefix",
"HTTPS URL prefix" => "HTTPS URL prefix",
"prio" => "prio",
"update" => "update",
"dsn" => "dsn",
"extwiki" => "extwiki",
"ppd" => "ppd",
"editions" => "editions",
"event" => "event",
"survey stats" => "survey stats",
"Restoring a backup" => "Restoring a backup",
"stop" => "stop",
"imagescale" => "imagescale",
"with roles" => "with roles",
"display" => "display",
"quiz stats" => "quiz stats",
"source" => "source",
"Edit a file using this form" => "Edit a file using this form",
"adm" => "adm",
"wiki create" => "wiki create",
"wiki overwrite" => "wiki overwrite",
"searched" => "searched",
"remove folder" => "remove folder",
"refresh cache" => "refresh cache",
"uploaded by" => "uploadol",
"not specified" => "nešpecifikované",
"delete" => "zmazať",
"post" => "odoslať",
"stop monitoring this blog" => "ukončiť sledovanie tohoto blogu",
"posts" => "záznamov",
"visits" => "návštev",
"show categories" => "zobraziť kategórie",
"author" => "autor",
"user level" => "užívateľ level",
"send email to user" => "poslať email užívateľovi",
"score" => "skóre",
"delete selected" => "zmazať vybrané",
"move" => "presunúť",
"set" => "nastaviť",
"replies" => "odpovede",
"cancel" => "zrušiť",
"up" => "nahor",
"down" => "nadol",
"add" => "pridať",
"create" => "vytvoriť",
"save" => "uložiť",
"send" => "odoslať",
"register" => "registrácia",
"secure" => "bezpečný",
"stay in ssl mode" => "zostať v ssl móde",
"go" => "OK",
"use" => "použiť",
"refresh" => "obnoviť",
"print" => "tlač",
"create pdf" => "vytvoriť pdf",
"monitor this page" => "sledovať túto stránku",
"stop monitoring this page" => "ukončiť sledovanie tejto stránky",
"backlinks" => "spätné odkazy",
"rename" => "premenovať",
"unlock" => "odomknúť",
"lock" => "uzamknúť",
"perms" => "práva",
"history" => "história",
"similar" => "podobné",
"undo" => "vrátiť",
"slides" => "slideshow",
"add comment" => "pridať komentár",
"attach file" => "priložiť súbor",
"last modification" => "posledná modifikácia",
"stats" => "štatistiky",
"last changes" => "posledné zmeny",
"list pages" => "prehľad stránok",
"cancel edit" => "zrušit editáciu",
"view blog" => "zobraziť blog",
"list blogs" => "vypísať blogy",
"save and exit" => "uložiť a ukončiť",
"reads" => "&times; prečítané",
"view comments" => "zobraziť komentáre",
"HomePage" => "Úvodná stránka",
"ok" => "OK",
"images" => "obrázky",
"Server name (for absolute URIs)" => "Názov serveru (pre absolútne URI)",
"Wiki_Tiki_Title" => "Titulek Wiki Tiki",
"path" => "cesta",
"HTTP server name" => "Názov HTTP servera",
"HTTPS server name" => "Názov HTTPS servera",
"Only for users" => "Len pre používateľov",
"Users and admins" => "Užívatelia a administrátori",
"Full Text Search" => "Fulltextové vyhľadávanie",
"full" => "plné",
"Enable Feature" => "Zapnúť funkčnosť",
"loc" => "lok",
"cat" => "kat",
"lang" => "jazyk",
"permissions" => "práva",
"create new" => "vytvoriť nový",
"edit chart" => "upraviť graf",
"use in cms" => "použiť v cms",
"use in wiki" => "použiť vo wiki",
"use in newsletters" => "použiť v newsletters",
"use in HTML pages" => "použiť na HTML stránkách",
"last modif" => "posledná úprava",
"sections" => "sekcie",
"upload" => "uploadnuť",
"online" => "on-line",
"topics" => "témy",
"coms" => "kom.",
"age" => "vek",
"last post" => "posledný záznam",
"position" => "pozícia",
"section" => "sekcia",
"options" => "možnosti",
"assign module" => "priradiť modul",
"left modules" => "moduly vľavo",
"right modules" => "moduly vpravo",
"edit/create" => "upraviť/vytvoriť",
"clear cache" => "vyčistiť cache",
"\n<b>Note 1</b>: if you allow your users to configure modules then assigned\nmodules won't be reflected in the screen until you configure them\nfrom MyTiki->modules.<br />\n<b>Note 2</b>: If you assign modules to groups make sure that you\nhave turned off the option 'display modules to all groups always'\nfrom Admin->General\n" => "\n<b>Note 1</b>: if you allow your users to configure modules then assigned\nmodules won't be reflected in the screen until you configure them\nfrom MyTiki->modules.<br />\n<b>Note 2</b>: If you assign modules to groups make sure that you\nhave turned off the option 'Vždy zobrazovat moduly pre všetky skupiny'\nz administrácia->Obecné\n",
"assign" => "priradiť",
"left" => "ľavý",
"right" => "pravý",
"order" => "poradie",
"create/edit" => "vytvoriť/upraviť",
"use poll" => "použiť anketu",
"use gallery" => "použiť galériu",
"use dynamic  content" => "použiť dynamický obsah",
"use rss module" => "použiť RSS modul",
"use menu" => "použiť menu",
"use banner zone" => "použiť banner zone",
"list newsletters" => "vypísať newslettery",
"admin newsletters" => "administrácia newsletterov",
"send newsletters" => "poslať newsletters",
"last sent" => "posledný poslaný",
"use admin email" => "použiť admin email",
"export pages" => "export stránky",
"dump tree" => "vypísať strom do súboru",
"tree" => "strom",
"edit this survey" => "upraviť tento prieskum",
"admin surveys" => "administrácia prieskumov",
"list surveys" => "vypísať prieskumy",
"questions" => "otázky",
"files" => "súbory",
"items" => "položky",
"version" => "verzia",
"admin" => "spravovať",
"all" => "všetko",
"Assign user" => "Priradiť užívateľa",
"List of available backups" => "Zoznam dostupných záloh",
"Warning!" => "Upozornenie!",
"Restoring a backup destoys all the data in your Tiki database. All your tables will be replaced with the information in the backup." => "Restoring a backup destoys all the data in your Tiki database. All your tables will be replaced s the information in the backup",
"Click here to confirm restoring" => "Klepnite sem pre potvrdenie obnovenia",
"Create new backup" => "Vytvoriť novú zálohu",
"Creating backups may take a long time. If the process is not completed you will see a blank screen. If so you need to increment the maximum script execution time from your php.ini file" => "Vytváranie záloh môže trvat dosť dlho. Ak sa tento proces nestihne ukončiť, zobrazí sa prázdna stránka. Ak k tomu dôjde, bude zrejme potrebné zvýšiť maximálnu dobu pre spúšťanie skriptov vo Vašom php.ini súbore.",
"Upload a backup" => "Upload zálohu",
"Upload backup" => "Upload zálohu",
"edit gallery" => "upraviť kolekciu",
"rebuild thumbnails" => "pregenerovať náhľady obrázkov",
"upload image" => "uploadnuť obrázok",
"list gallery" => "vypísať galérie",
"original size" => "pôvodná veľkosť",
"return to gallery" => "späť do galérie",
"edit image" => "upraviť obrázok",
"smaller" => "menší",
"bigger" => "väčší",
"prev image" => "predošlý obrázok",
"popup window" => "pop-up okno",
"next image" => "další obrázok",
"or create a new category" => "alebo vytvorte novú kategóriu",
"or create a new location" => "alebo vytvorte nové umiestnenie",
"comma separated usernames" => "dvojtečkou oddělená uživ. jména",
"comma separated username:role" => "dvojtečkou oddělené uživ.jméno:role",
"Chair" => "Kreslo",
"Optional" => "Voliteľné",
"permission" => "práva",
"remove page" => "odstrániť stránku",
"browse" => "prezerať",
"related" => "príbuzné",
"validate" => "validovat",
"add a site" => "pridať odkaz",
"search" => "hľadať",
"list articles" => "vypísať články",
"view articles" => "zobraziť články",
"create zone" => "vytvoriť zónu",
"save the banner" => "uložiť banner",
"try" => "skús",
"create new block" => "vytvoriť nový blok",
"list quizzes" => "vypísať kvízy",
"edit this quiz" => "upraviť tento kvíz",
"admin quizzes" => "administrácia kvízov",
"results" => "výsledky",
"create page" => "vytvoriť stránku",
"list submissions" => "vypísať uživ. príspevky",
"Admin ephemerides" => "Administrácia efemeríd",
"All ephemerides" => "Všetky efemeridy",
"new question" => "nová otázka",
"approve" => "schváliť",
"configure listing" => "upraviť prehľad",
"topic" => "téma",
"save and approve" => "uložiť a schváliť",
"new topic" => "nová téma",
"reject" => "neprijať",
"accept" => "prijať",
"add new" => "pridať novú",
"add role" => "pridať rolu",
"new minor" => "nová malá verzia",
"new major" => "nová hlavná verzia",
"admin processes" => "administrácia procesov",
"admin activities" => "administrácia aktivít",
"admin roles" => "administrácia rolí",
"edit this process" => "upraviť tento process",
"monitor" => "sledovať",
"send instance" => "poslať inštanciu",
"create new gallery" => "vytvoriť novú kolekciu",
"result" => "výsledok",
"edit new article" => "upraviť nový článok",
"create new blog" => "vytvoriť nový blog",
"upload file" => "uploadnuť súbor",
"delete selected files" => "zmazať vybrané súbory",
"browse gallery" => "prezerať kolekciu",
"Flash binary (.sqf or .dcr)" => "Flash binary (.sqf alebo .dcr)",
"edit blog" => "upraviť blog",
"edit new submission" => "upraviť nový zaslaný príspevok",
"set as operator" => "nastaviť ako operátor",
"add topic" => "pridať tému",
"back" => "späť",
"Assign permissions to page" => "Priradiť práva stránke",
"Current permissions for this page" => "Súčasné práva pre túto stránku",
"Send email notifications when this page changes to" => "Posielať upozornenia na e-mail, ak sa táto stránka zmení na",
"add email" => "pridať e-mail",
"Notifications" => "Upozorňovanie",
"clear stats" => "vyčistiť štatistiky",
"Edit received page" => "Upraviť prijatú stránku",
"last" => "posledný",
"send me my password" => "pošli mi moje heslo",
"galleries" => "galérie",
"blog posts" => "záznamy blogu",
"site" => "názov odkazu",
"clear" => "vyčistiť",
"add article" => "pridať článok",
"send answers" => "poslať odpovede",
"move to right column" => "presunúť do pravého stĺpca",
"unassign" => "zrušiť priradenie",
"move to left column" => "presunúť do ľavého stĺpca",
"edit items" => "upraviť položky",
"list charts" => "vypísať charts",
"last chart" => "posledný graf",
"item" => "položka",
"monitor this forum" => "sledovať toto forum",
"stop monitoring this forum" => "ukončiť sledovanie tohoto fóra",
"delete selected topics" => "zmazať vybrané témy",
"stop monitoring this topic" => "ukončiť sledovanie tejto témy",
"Comments below your current threshold" => "Komentárov pod Vami zvolenou úrovňou",
"add contacts" => "pridať kontakty",
"DATE-of" => "",
"You cannot edit this page because it is a user personal page" => "Táto stránka sa nedá měnit, pretože je to užívateľská osobná stránka",
"Permission denied you cannot assign permissions for this page" => "Nemáte dostatočné oprávnenia na priradzovanie práv pre túto stránku",
"You do not have permission to edit messages" => "Nemáte dostatočné oprávnenia. Nemôžete upravovať správy",
"Cannot read file" => "Nie je možné čítať súbor",
"Permission denied you cannot upload files" => "Nemáte dostatočné oprávnenia. Nemôžete nahrávať súbory",
"cannot process upload" => "nedá sa spracovať upload",
"Your email address has been removed from the list of addresses monitoring this tracker" => "Your email address has been removed from the list of addresses monitoring tento prehľad",
"Your email address has been added to the list of addresses monitoring this tracker" => "Your email address has been added to the list of addresses monitoring tento prehľad",
"Cancel monitoring" => "Zrušit sledovanie",
"Your email address has been removed from the list of addresses monitoring this item" => "Your email address has been removed from the list of addresses monitoring this položku",
"Your email address has been added to the list of addresses monitoring this item" => "Your email address has been added to the list of addresses monitoring this položku",
"with checked" => "with checked",
"del" => "del",
"pdf" => "pdf",
"please read" => "please read",
"yes" => "yes",
"UTC" => "UTC",
"subscriptions" => "subscriptions",
"fields" => "fields",
"Ratio" => "Ratio",
"start" => "start",
"end" => "end",
"invalid" => "invalid",
"invalid process" => "invalid process",
"proc" => "proc",
"exceptions" => "exceptions",
"pos" => "pos",
"pre" => "pre",
"unlock selected topics" => "unlock selected topics",
"pop" => "pop",
"Event without Name" => "Event without name",
"new image uploaded by" => "nový obrázok nahral(a)",
"new subscriptions" => "nové prihlásenia k&#160;odberu",
"new item in tracker" => "nová položka v trackeri",
"message" => "správa",
"filter" => "filtrovať",
"no such file" => "žiadny taký súbor",
"downloads" => "stiahnutí",
"attach" => "priložiť",
"monitor this blog" => "sledovať tento blog",
"hide categories" => "skryť kategórie",
"Admin categories" => "Administrácia kategórií",
"reply" => "odpovedať",
"monitor this topic" => "sledovať tento topic",
"Dls" => "Downloadov",
"move selected files" => "presunúť vybraté súbory",
"Thank you for you registration. You may log in now." => "Dakujeme Vám za Vašu registráciu. Teraz sa môžete prihlásiť.",
"compare" => "porovnať",
"diff" => "rozdiely",
"Create pdf" => "Vytvoriť pdf",
"1 file attached" => "priložený 1 súbor",
"categories" => "kategórie",
"at tracker" => "v prehľade",
"check / uncheck all" => "zaškrtnúť všetko / zrušiť zaškrtnutie všetkého",
"Tiki sections and features" => "Funkcie a Sekcie Tiki",
"private" => "Súkromné",
"<b>Feed</b>" => "<b>Základ</b>",
"<b>enable/disable</b>" => "<b>zapnúť/vypnúť</b>",
"<b>Max number of items</b>" => "<b>Maximum položiek</b>",
"Feed for Articles" => "Základ pre články",
"Feed for Weblogs" => "Základ pre Weblogs",
"Feed for Image Galleries" => "Základ pre galérie obrázkov",
"Feed for File Galleries" => "Základ pre Kolekcie súborov",
"Feed for the Wiki" => "Základ pre Wiki",
"Feed for individual Image Galleries" => "Základ pre jednotlivé galérie",
"Feed for individual File Galleries" => "Základ pre jednotlivé kolekcie súborov",
"Feed for individual weblogs" => "Základ pre jednotlivé weblogy",
"Feed for individual forums" => "Základ pre jednotlivé diskusné fóra",
"PDF generation" => "Generovať PDF",
"Use in CMS" => "Použiť v cms",
"Use in Wiki" => "Použiť vo wiki",
"Use in newsletters" => "Použiť v newsletters",
"Use in HTML pages" => "Použiť na HTML stránkách",
"Refresh rate (if dynamic) [secs]" => "Frekvencia obnovovania (ak je stránka dynamická) [sek]",
"Create/edit newsletters" => "Vytvoriť/upraviť newslettery",
"Use Admin Email" => "Použiť admin email",
"Edit or add poll options" => "Upraviť alebo pridať anketu",
"Create/edit Polls" => "Vytvoriť/upraviť ankety",
"Rss channels" => "RSS kanály",
"activate" => "aktivovať",
"Admin tracker" => "Administrácia prehľadu",
"Edit this tracker" => "Upraviť tento prehľad",
"View this tracker items" => "Zobraziť položky tohoto prehľade",
"Edit tracker fields" => "Upraviť prehľadové polia",
"Create/edit trackers" => "Vytvoriť/upraviť prehľady",
"Edit item" => "Upraviť položku",
"Add a new user" => "Pridať nového uživateľa",
"Popup Window" => "Pop-up okno",
"details" => "detaily",
"No individual permissions global permissions apply" => "Žiadne individuálne práva; budú aplikované práva globálne",
"Welcome to the Tiki Chat Rooms" => "Vitajte v konverzačných miestnostiach Tiki",
"Please select a chat channel" => "Vyberte si miestnosť pre pokec, prosím",
"enter chat room" => "vstúpte do miestnosti",
"Chatroom" => "Pokecová miestnosť",
"Active Channels" => "Aktívne kanály",
"Users in this channel" => "Užívatelia na tomto kanáli",
"Channel Information" => "Informácie o kanáli",
"Channel" => "Miestnosť",
"Use :nickname:message for private messages" => "použite :nickname:message pre súkromné správy",
"Use [URL|description] or [URL] for links" => "Použite [URL|popis] alebo [URL] pre linky",
"Create PDF" => "Vytvoriť PDF",
"PDF Settings" => "PDF nastavenia",
"Select Wiki Pages" => "Vybrať Wiki stránky",
"Remove Page" => "Odstrániť stránku",
"Add or edit a site" => "Pridať alebo upraviť web",
"sites" => "odkazy",
"cool sites" => "skvelé odkazy",
"Use ...page... to separate pages in a multi-page article" => "použite ...page... pre oddelenie stránok vo viacstránkových článkoch",
"Create Zone" => "Vytvoriť zónu",
"translate" => "preložiť",
"Create or edit content" => "Vytvoriť alebo upraviť obsah",
"this quiz stats" => "štatistiky",
"answer" => "odpoveď",
"graph" => "graf",
"Edit FAQ questions" => "Upraviť FAQ questions",
"Edit this file gallery:" => "Upraviť túto kolekciu súborov:",
"icon" => "ikona",
"Other users can upload files to this gallery" => "Ostatní užívatelia môžu uploadovať súbory do tejto kolekce",
"Available File Galleries" => "Kolekcie súborov k dispozícii",
"roles" => "role",
"Add role" => "Pridať rolu",
"active process" => "aktívny proces",
"valid process" => "platný proces",
"activities" => "aktivity",
"aborted" => "prerušené",
"value" => "hodnota",
"rollback" => "vrátiť späť",
"Create or edit content block" => "Vytvoriť alebo upraviť blok obsahu",
"Listing Gallery" => "Zoznam galérií",
"Gallery Files" => "Prehľad súborov",
"Last ver" => "Predošlá verzia",
"Com" => "Komentár",
"Vers" => "Verzia",
"Subscribe to newsletter" => "Prihlásiť sa k odberu newsletteru",
"Add or edit a news server" => "Pridať alebo upraviť news server",
"Print Wiki Pages" => "Tlač Wiki stránky",
"add page" => "pridať stránku",
"Total threads" => "Celkovo vlákien",
"Average threads per topic" => "Priemerne vlákien na tému",
"You can include the file in an HTML/Tiki page using" => "Môžete vložit súbor do HTML/Tiki stránky použitím",
"Now enter the file URL" => "Vložte URL súboru",
" or upload a local file from your disk" => " alebo nahrajte súbor z Vášho disku",
"Add or edit folder" => "Pridať alebo upraviť zložku",
"Add or edit a URL" => "Pridať alebo upraviť URL",
"priority" => "priorita",
"previous chart" => "predošlý graf",
"next chart" => "další graf",
"avg" => "priem.",
"post new comment" => "poslať nový komentár",
"Post New Comment" => "Poslať nový komentár",
"HTML tags are not allowed inside comments" => "HTML značky nie sú v komentároch povolené",
"moderator actions" => "moderátorské akcie",
"move selected topics" => "presunúť vybraté topics",
"lock selected topics" => "uzamknúť vybrané témy",
"merge" => "zlúčiť",
"merge selected topics" => "zlúčiť zvolené témy",
"reported messages:" => "nahlásené záznamy:",
"queued messages:" => "správy vo fronte:",
"View item" => "Zobraziť položku",
"Add a comment" => "Pridať komentár",
"account" => "účet",
"Group doesnt exist" => "Neexistujúca skupina",
"User doesnt exist" => "Neexistujúci užívateľ",
"Invalid old password" => "Nesprávne pôvodné heslo",
"No channel indicated" => "Žiadny kanál nebol zadaný",
"No nickname indicated" => "Žiadna prezývka nebola zadaná",
"Permision denied" => "Prístup nebol umožnený",
"posted by" => "posted by",
"mailbox" => "mailbox",
"cc" => "cc",
"sender" => "odosielateľ",
"subject" => "predmet",
"date" => "dátum",
"mark" => "označiť",
"email this post" => "pošli tento záznam emailom",
"Use page description" => "Použiť popisku stránky",
"Show page title" => "Zobraziť meno stránky",
"Users can lock pages (if perm)" => "Užívatelia môžu uzamykať stránky (ak majú práva)",
"Use WikiWords" => "Použiť WikiWords",
"Maximum number of versions for history" => "Maximum verzií v histórii",
"Never delete versions younger than days" => "Nikdy nemazat verze mladšie ako dní",
"Old vers" => "Stará verzia",
"Add or edit event" => "Pridať alebo upraviť udalosť",
"merge selected notes into" => "zlúčiť zvolené poznámky do",
"Faq Stats" => "Časté otázky - štatistiky",
"Your message has been queued for approval, the message will be posted after\na moderator approves it." => "Your message has been queued for approval, the message will be posted after\na moderator approves it",
"settings" => "nastavenia",
"compose" => "písať",
"contacts" => "kontakty",
"back to mailbox" => "späť do mailboxu",
"full headers" => "celé hlavičky",
"normal headers" => "normálne hlavičky",
"reply all" => "odpovedať všetkým",
"forward" => "preposlať",
"select from address book" => "vybrať z address book",
"Minor" => "Minor",
"subscribed" => "subscribed",
"hist" => "hist",
"new sites" => "nové odkazy",
"{\$atts_cnt} files attached" => "pripojených {\$atts_cnt} súborov",
"pass" => "heslo",
"Page generated in" => "Stránka vygenerovaná za",
"sent" => "odoslané",
"Favorites" => "Obľúbené",
"Content Features" => "Súčasti obsahu",
"Prevent automatic/robot registration" => "Zabránit registraci automaticky/robotem",
"Create/edit Calendars" => "Vytvoriť/upraviť kalendár",
"charts" => "grafy",
"Chat Administration" => "Správa konverzací",
"Create/edit channel" => "Vytvoriť/upraviť kanály",
"second" => "sekunda",
"Chat channels" => "Pokecové kanály",
"Assign Module" => "Priradiť modul",
"Edit survey questions" => "Upraviť otázky prieskumu",
"Admin Tracker" => "Administrácia prehľadu",
"Again" => "Znovu",
"Assign permissions to group" => "Priradiť práva skupine",
"Browsing Gallery" => "Prezeranie galérie",
"Show Plugins Help" => "Zobraziť help k plug-inom",
"Show Text Formatting Rules" => "Zobraziť pravidlá pre formátovanie textu",
"Program dynamic content for block" => "Naprogramovať dynamický obsah pre blok",
"Admin quizzes" => "Administrácia kvízov",
"Message queue for" => "Fronta správ pre",
"back to forum" => "späť do fóra",
"Reported messages for" => "Ohlásené správy pre",
"back to admin" => "späť do administrácie",
"Subscribe to This Newsletter" => "Přihlásiť sa k odberu",
"Stats for quiz" => "Štatistiky pre kvíz",
"Received Articles" => "Prijaté články",
"Rename page" => "Premenovať stránku",
"to_version" => "na verziu",
"Stats for survey" => "Štatistiky pre prieskum",
"Theme Control Center: categories" => "Ovládacie centrum vzhľadu: Kategórie",
"Theme Control Center: sections" => "Ovládacie centrum vzhľadu: Sekcie",
"File Title" => "Názov súboru",
"Add new mail account" => "Pridať nový emailový účet",
"User accounts" => "Užívateľské účty",
"View All" => "Zobraziť všetko",
"Msg" => "Spr.",
"Permission denied you cannot remove pages" => "Nemáte dostatočné oprávnenia. Nemôžete odstraňovať stránky",
"Newsletter subscription information at " => "Newsletter subscription information at ",
"OS" => "OS",
"Just use Tiki auth for admin?" => "Just use Tiki auth for admin?",
"LDAP Host" => "LDAP Host",
"LDAP Port" => "LDAP Port",
"LDAP Scope" => "LDAP Scope",
"LDAP Base DN" => "LDAP Base DN",
"LDAP User DN" => "LDAP User DN",
"LDAP User Attribute" => "LDAP User Attribute",
"LDAP User OC" => "LDAP User OC",
"LDAP Group DN" => "LDAP Group DN",
"LDAP Group Attribute" => "LDAP Group Attribute",
"LDAP Group OC" => "LDAP Group OC",
"LDAP Member Attribute" => "LDAP Member Attribute",
"LDAP Member Is DN" => "LDAP Member Is DN",
"LDAP Admin User" => "LDAP Admin User",
"LDAP Admin Pwd" => "LDAP Admin Pwd",
"Support tickets" => "Support tickets",
"Cannot write to this file" => "Nie je možné zapisovať do tohoto súboru",
"Missing title or body when trying to post a comment" => "Komentár musí mať nadpis, aj telo. Ak neviete vymyslieť nadpis, napíšte Oné alebo Jářku ;o)",
"categorize this object" => "kategorizovať tento objekt",
"Syntax highlighting" => "Zýraznenie syntaxe",
"My Files" => "Moje súbory",
"Dump" => "Výpis do súboru",
"Received pages" => "Prijaté stránky",
"Admin Posts" => "Administrácia záznamov",
"Submit a New Link" => "Poslať novú linku",
"Admin Directory" => "Administrácia katalógu odkazov",
"List trackers" => "Vypísať trackers",
"I forgot my pass" => "Zabudnuté heslo",
"Send trackback pings to:" => "Poslať trackback pings na:",
"(comma separated list of URIs)" => "(zoznam URI oddelený čiarkami)",
"This is" => "Toto je",
"by the" => "&ndash;",
"Use URI as Home Page" => "Použiť URI ako úvodnú stránku",
"Use cache for external images" => "Použiť cache pre externé obrázky",
"Use gzipped output" => "Použiť gzip-ovný výstup",
"Sender Email" => "E-mail odosielateľa",
"contact feature disabled" => "možnosť kontaktu vypnutá",
"User registration and login" => "Registrácia užívateľov a prihlásenie",
"Use WebServer authentication for Tiki" => "Použiť WebServer autentifikáciu pre Tiki",
"Request passcode to register" => "Požiadajte o tajný kód pre registráciu",
"Validate users by email" => "Overiť užívateľov e-mailem",
"Store plaintext passwords" => "Ukladať nekryptované heslá",
"Reg users can change language" => "Reg. užívatelia môžu meniť jazyk",
"Force to use chars and nums in passwords" => "Vynútené používanie znakov a čísiel v heslách",
"Minimum password length" => "Minimálna dĺžka hesla",
"Password invalid after days" => "Heslo expiruje po dňoch",
"Remember me feature" => "'Zapamätaj si ma' funkcia",
"Create user if not in Tiki?" => "Vytvoriť užívateľa ak nie je v Tiki?",
"Create user if not in Auth?" => "Vytvoriť užívateľa ak nie je v Auth?",
"Allow Smileys" => "Povoliť smajlíky",
"Hotwords in New Windows" => "Kľúčové slová otvárať v novom okne",
"restore" => "obnoviť",
"Wiki Home Page" => "Wiki úvodná stránka",
"Wiki Discussion" => "Wiki Diskusia",
"Wiki Features" => "Možnosti Wiki",
"Wiki History" => "História Wiki",
"Admin Charts" => "Administrácia grafov",
"Edit this RSS module:" => "Upraviť tento RSS modul:",
"Create new RSS module" => "Vytvoriť nový RSS modul",
"Create/edit questions for survey" => "Vytvoriť/upraviť otázky pre prieskum",
"Active?" => "Aktívne?",
"Create/Edit Trackers" => "Vytvoriť/upraviť prehľady",
"Browse gallery" => "Prezerať galériu",
"Upload from disk" => "Nahrať z disku",
"Browsing Image" => "Prezeranie obrázku",
"Again please" => "Potvrdenie hesla",
"Admin category relationships" => "Administrácia vsťahov mezi kategóriami",
"Validate links" => "Overiť platnosť odkazov",
"File with names appended by -{\$user} are modifiable, others are only duplicable and be used as model." => "Súbory s názvami, za ktorými nasleduje -{\$user} sú modifikovateľné, ostatné je možno použiť ako model",
"Im- Export Languages" => "Import/Export jazykov",
"Create a file gallery" => "Vytvoriť kolekciu súborov",
"Return to HomePage" => "Späť na úvodnú stránku",
"Stats for this survey Questions " => "Štatistiky pre otázky tohto prieskumu ",
"Batch upload" => "Hromadný prenos",
"Minor Edit" => "Minor",
"You can not download files" => "Nemôžete sťahovať súbory",
"Please wait 2 minutes between posts" => "Prsím počkajte 2 minúty medzi príspevkami",
"Spellchecking" => "Spellchecking",
"Submit Notice" => "Submit Notice",
"Uploaded filenames cannot match regex" => "Uploaded filenames cannot match regex",
"underline" => "underline",
"hr" => "hr",
"Show Categories" => "Zobraziť kategórie",
"Hide Categories" => "Skryť kategórie",
"Blog features" => "Možnosti blogu",
"Blog level comments" => "Blog level komentáre",
"Post level comments" => "Post level komentára",
"Default ordering for blog listing" => "Poradie pre výpis blogov",
"Blog listing configuration (when listing available blogs)" => "Nastavenia zoznamu blogov(pri vypisovaní zoznamu blogov)",
"Blog comments settings" => "Nastavenia komentárov blogu",
"Show Category Path" => "Zobraziť cestu kategórie",
"Show Category Objects" => "Zobraziť objekty v kategórii",
"CMS features" => "CMS funkcie",
"Use templates" => "Použiť šablóny",
"Maximum number of articles in home" => "Max. počet článkov na úvodnej stránke",
"Article comments settings" => "Článok: nastavenie komentárov",
"Copyright Management" => "Správa autorských práv",
"License Page" => "Licenčné ujednanie",
"File galleries comments settings" => "Kolekcie súborov: nastavenie komentárov",
"Forum quick jumps" => "Fórum: rýchle prejsť na...",
"Ordering for forums in the forum listing" => "Zoradenie fór vo výpise",
"Forum listing configuration" => "Fórum: nastavenia výpisu",
"Users can Configure Modules" => "Užívatelia môžu konfigurovat moduly",
"SearchStats" => "Štatistiky vyhľadávania",
"this survey stats" => "štatistiky",
"bold" => "tučné",
"italic" => "sklonené",
"unread private messages" => "neprečítaných súkromných správ",
"Your Tiki information registration" => "Your Tiki information registration",
"Your registration" => "Your Tiki information registration",
"you or someone registered this email address at" => "vy alebo niekto iny zaregistroval tuto email adresu na",
"home" => "úvod",
"chat" => "pokec",
"contact us" => "kontaktujte nás",
"debugger console" => "debug konzola",
"User menu" => "Užívateľské menu",
"dump" => "vypísať do súboru",
"rankings" => "rebríčky",
"orphan pages" => "samostatné stránky",
"sandbox" => "pieskovisko",
"received pages" => "prijaté stránky",
"structures" => "štruktúry",
"Articles Home" => "Úvodná stránka článkov",
"Send articles" => "Poslať články",
"Create/Edit Blog" => "Vytvoriť/upraviť blog",
"Browse Directory" => "Prezerať katalóg",
"Admin FAQs" => "Administrácia častých otázok",
"Admin quiz" => "Administrácia kvízu",
"Admin trackers" => "Administrácia prehľadov",
"Send newsletters" => "Zasielať novinky na e-mail",
"Ephemerides" => "Efemeridy",
"Backups" => "Zálohy",
"Edit languages" => "Upraviť jazyky",
"External wikis" => "Externé Wiki",
"Click here to manage your personal menu" => "Klepnite sem pre úpravu Vášho osobného menu",
"Quick edit a Wiki page" => "Rýchla úprava Wiki stránky",
"Sort posts by:" => "Zoradiť príspevky podľa:",
"read more" => "čítať ďalej",
"Pass" => "Heslo",
"some text" => "nejaký text",
"Creates a box with the data" => "Vytvorí rámik s dátami",
"creates a title bar" => "vytvorí pruh titulku",
"creates a table" => "vytvorí tabulku",
"makes a horizontal rule" => "vytvorí horizontálnu čiaru",
"page|desc" => "stránka|popis",
"displays an image" => "zobrazí obrázok",
"Non cacheable images" => "Necacheovatelné obrázky",
"height width desc link and align are optional" => "height, width, desc, link a align sú voliteľné",
"displays rss feed with id=n maximum=m items" => "zobrazí rss feed s id=n maximum=m položkami",
"Will be replaced by the actual value of the dynamic content block with id=n" => "Bude zamenené za aktuálnu hodnotu bloku s dynamickým obsahom s id=n",
"Misc" => "Rôzne",
"Menu" => "Menu",
"Workflow" => "Workflow",
"Workflow engine" => "Workflow engine",
"Unix" => "Unix",
"Windows" => "Windows",
"Long date format" => "Long date format",
"Short date format" => "Short date format",
"Long time format" => "Long time format",
"Short time format" => "Short time format",
"PEAR::Auth" => "PEAR::Auth",
"HTTP port" => "HTTP port",
"HTTPS port" => "HTTPS port",
"Ranking shows" => "Ranking shows",
"Ranks" => "Ranks",
"Ver" => "Ver",
"Dynamic content blocks" => "Dynamic content blocks",
"box" => "box",
"rss feed" => "rss feed",
"tagline" => "tagline",
"special chars" => "special chars",
"split" => "split",
"standalone" => "standalone",
"interactive" => "interactive",
"Process activities" => "Process activities",
"Int" => "Int",
"Routing" => "Routing",
"Manual" => "Manual",
"inter" => "inter",
"Process Transitions" => "Process Transitions",
"val" => "val",
"exception" => "exception",
"ver:" => "ver:",
"is active?" => "is active?",
"Process roles" => "Process roles",
"Process form" => "Process form",
"If:SetNextact" => "If:SetNextact",
"Proc" => "Proc",
"int" => "int",
"run activity" => "run activity",
"processes" => "processes",
"Exceptions" => "Exceptions",
"instance" => "instance",
"exception instance" => "exception instance",
"exceptions instance" => "exceptions instance",
"process" => "process",
"visit the site for more games and fun" => "visit the site for more games and fun",
"Played" => "Played",
"Newsgroup" => "Newsgroup",
"server" => "server",
"News server" => "News server",
"Tiki Shoutbox" => "Tiki Shoutbox",
"chg" => "chg",
"info/vote" => "info/vote",
"indicates if the process is active. Invalid processes cant be active" => "indicates if the process is active. Invalid processes cant be active",
"Process already exists" => "Process already exists",
"You cant execute this activity" => "You cant execute this activity",
"Missing information to read news (server,port,username,password,group) required" => "Missing information to read news (server,port,username,password,group) required",
"Role" => "Rola",
"<return> for rows" => "\n pre riadky",
"1 day" => "1 deň",
"1 week" => "1 týždeň",
"1 month" => "1 mesiac",
"Just Tiki" => "Len Tiki",
"Tiki and PEAR::Auth" => "Tiki a PEAR::Auth",
"Charts" => "Grafy",
"Forums last topics" => "Fóra: posledé témy",
"games" => "hry",
"drawing not found" => "kresba nebola nájdená",
"Listing configuration" => "Konfigurácia výpisu",
"Tiki email notification" => "Tiki email upozornenia",
"Recently visited pages" => "Nedávno navštívené stránky",
"Last Sites" => "Posledné weby",
"Directory Stats" => "Štatistiky katalógu",
"Sites to validate" => "Odkazy k overeniu",
"Visited links" => "Navštívené odkazy",
"Top Sites" => "Top weby",
"Last galleries" => "Posledná galéria",
"New Messages" => "Nových správ",
"New Message" => "Novú správu",
"Top games" => "Top hry",
"Number of columns per page when listing categories" => "Počet stĺpcov na stránku v zozname kategórií",
"Featured Help" => "Odporučený help",
"Drawings" => "Kreslenie",
"Games" => "Hry",
"Administration Features" => "Administračné funkcie",
"Banning System" => "Systém zamedzenia prístupu",
"User Features" => "Užívateľské možnosti",
"Newsreader" => "Čítanie news",
"Unknown/Other" => "Neznámy/Iný",
"Tikiwiki.org help" => "Help Tikiwiki.org",
"New password" => "Nové heslo",
"Reg users can change theme" => "Reg. užívatelia môžu meniť výzor",
"Slideshows theme" => "Štýl vzhľadu prezentácií",
"hits" => "prístupy",
"image gal" => "obr. galérie",
"file gal" => "súb. kolekcie",
"Admin chart items" => "Administrácia položiek grafu",
"Edit Chart" => "Upraviť graf",
"Chart items" => "Položky grafu",
"No items defined yet" => "Žiadne items zatiaľ nebyly definovány",
"Add or edit a chart" => "Pridať alebo upraviť graf",
"Users can suggest new items" => "Užívatelia môžu odporúčať nové položky",
"Auto validate user suggestions" => "Automaticky overiť doporučenia od užívateľov",
"All items" => "Všetky položky",
"Top 10 items" => "Top 10 položiek",
"Top 20 items" => "Top 20 položiek",
"Top 40 items" => "Top 40 položiek",
"Top 50 items" => "Top 50 položiek",
"Top 100 items" => "Top 100 položiek",
"Top 250 items" => "Top 250 položiek",
"Voting system" => "Hlasovací systém",
"Vote items" => "Volte položky",
"Rank 1..5" => "Hodnotenie 1..5",
"Rank 1..10" => "Hodnotenie 1..10",
"Ranking frequency" => "Frekvencia hodnotenia",
"Realtime" => "Reálny čas",
"Each 5 minutes" => "Každých 5 minút",
"Show Average" => "Zobraziť Priemer",
"Show Votes" => "Zobraziť hlasovanie",
"Use Cookies for unregistered users" => "použiť cookies pre neregistrovaných užívateľov",
"Users can vote again after" => "Užívatelia môžu znovu hlasovať po",
"Anytime" => "Kedykoľvek",
"No charts defined yet" => "Žiadne grafy neboli zatiaľ definované",
"Admin drawings" => "Administrácia kresieb",
"Available drawings" => "Kresby k dispozícii",
"Available polls" => "Ankety k dispozícii",
"Random image from" => "Náhodný obrázok z",
"Banner zones" => "Zóny banneru",
"Admin RSS Modules" => "Administrácia RSS modulov",
"Rejected users" => "Odmietnutí užívatelia",
"Old password" => "Pôvodné heslo",
"Parent category" => "Nadradená kategória",
"Most visited sub-categories" => "Najnavštevovanejšie podkategórie",
"Category description" => "Popis kategórie",
"Random sub-categories" => "Náhodné podkategórie",
"Allow sites in this category" => "Povoliť weby v tejto kategórii",
"Show number of sites in this category" => "Zobraziť množstvo webov v tejto kategórii",
"Subcategories" => "Podkategórie",
"Admin related categories" => "Administrácia súvisiacich kategorií",
"Add a related category" => "Pridať súvisiacu kategóriu",
"Related categories" => "Príbuzné kategórie",
"in current category" => "v súčasnej kategórii",
"Total categories" => "Celkovo kategórií",
"creates the editable drawing foo" => "vytvorí editovateľnú kresbičku foo",
"table" => "tabuľka",
"external link" => "externý odkaz",
"heading1" => "hlavička1",
"title bar" => "titulková lišta",
"dynamic content" => "dynamický obsah",
"center text" => "vycentrovať text",
"colored text" => "farebný text",
"special characters" => "špeciálne znaky",
"Questions per page" => "Otázok na stránku",
"Activity completed" => "Aktivita ukončená",
"Admin process activities" => "Administrácia aktivít procesov",
"Add or edit an activity" => "Pridať alebo upraviť aktivitu",
"activity" => "aktivita",
"join" => "pripojit",
"auto routed" => "automaticky smerované",
"Add transitions" => "Pridať prenosy",
"Add transition from:" => "Pridať prenos z:",
"Add transition to:" => "Pridať prenos do:",
"No roles associated to this activity" => "žiadne role associated k tejto activity",
"Add Role" => "Pridať rolu",
"Add New" => "Pridať novú",
"Interactive" => "Interaktívny",
"Automatic" => "Automaticky",
"Auto routed" => "Automaticky smerované",
"route" => "smer",
"(no roles)" => "(žiadne role)",
"No activities defined yet" => "Zatiaľ neboli definované žiadne aktivity",
"List of transitions" => "Zoznam of transitions",
"Origin" => "Pôvod",
"No transitions defined yet" => "žiadne transitions zatím nebyly definovány",
"Add a transition" => "Pridať prenos",
"This process is invalid" => "Tento proces je neplatný",
"List of processes" => "Zoznam processov",
"Inactive" => "Neaktívne",
"Active Process" => "Aktívny proces",
"Invalid Process" => "Invalid process",
"Valid Process" => "Platný proces",
"Activities" => "Aktivity",
"New Minor" => "Nová malá verzia",
"New Major" => "Nová hlavná verzia",
"No processes defined yet" => "Žiadne procesy zatiaľ neboli definované",
"Admin instance" => "Administrácia instance",
"Process:" => "Proces:",
"Instance" => "Inštancia",
"Workitems" => "Položky úloh",
"completed" => "hotovo",
"Send all to" => "Poslať všetko na",
"Don't move" => "Nepresúvať",
"Act status" => "Akt. stav",
"Property" => "Vlastnosť",
"Add property" => "Pridať vlastnost",
"run instance" => "spustiť instance",
"Admin processes" => "Administrácia procesov",
"Add or edit a process" => "Pridať alebo upraviť proces",
"Process Name" => "Meno procesu",
"Or upload a process using this form" => "OAlebo uploadni proces použitím tohto formlára",
"Admin process roles" => "Administrácia rolí procesov",
"Add or edit a role" => "Pridať alebo upraviť rolu",
"No roles defined yet" => "Zatiaľ neboli definované žiadne role",
"Map users to roles" => "Mapovat users to roles",
"map" => "mapa",
"Map groups to roles" => "Mapovat groups to roles",
"Operation" => "Operácia",
"No roles are defined yet so no roles can be mapped" => "Žiadne role zatial neboli zadefinované,čiže sa nedajú ani namapovať",
"List of mappings" => "Zoznam mappingov",
"No mappings defined yet" => "Žiadne mappings zatiaľ neboli definované",
"Admin process sources" => "Administrácia zdrojov procesov",
"select source" => "vybrať source",
"Shared code" => "Zdieľaný code",
"Set next user" => "Nastaviť daľšieho užívateľa",
"Get property" => "Získať property",
"Set property" => "Nastaviť vlastnosť",
"Set Next act" => "Nastaviť Next act",
"Switch construct" => "Vymeniť konštrukciu",
"Map process roles" => "Mapovat process roles",
"Admin Processes" => "Administrácia procesov",
"Admin Activities" => "Administrácia aktivít",
"Admin Roles" => "Administrácia rolí",
"Edit this Process" => "Upraviť tento process",
"Monitor Activities" => "Sledovať aktivity",
"List of activities" => "Zoznam aktivít",
"auto" => "automaticky",
"routing" => "smerovanie",
"Instances" => "Inštancie",
"run" => "spustiť",
"monitor processes" => "sledovať processes",
"monitor activities" => "sledovať activities",
"monitor instances" => "sledovať instances",
"monitor workitems" => "sledovať workitems",
"Monitor Instances" => "Sledovať inštancie",
"List of instances" => "Zoznam inštancií",
"No instances created yet" => "žiadne instances created yet",
"Monitor Processes" => "Sledovať procesy",
"being run" => "bežiaci",
"Monitor workitems" => "Sledovať workitems",
"List of workitems" => "Zoznam of workitems",
"Send Instance" => "Poslať inštanciu",
"abort instance" => "prerušiť inštanciu",
"grab instance" => "podržať instance",
"release instance" => "pustit instance",
"User Activities" => "Aktivity užívateľa",
"user processes" => "užívateľské procesy",
"user activities" => "užívateľské aktivity",
"user instances" => "užívateľské instances",
"User Instances" => "Inštancie uživatele",
"Inst Status" => "Stav inštancie",
"No instances defined yet" => "žiadne instances zatím nebyly definovány",
"User Processes" => "Procesy užívateľa",
"Browsing Workitem" => "Prezeranie položky",
"Workitem information" => "Informácie o položke",
"Use cache for external pages" => "Použiť cache pre externé stránky",
"All games are from" => "Všetky hry sú z",
"Upload a game" => "Upload hru",
"Upload a new game" => "Upload novú hru",
"Thumbnail (if the game is foo.swf the thumbnail must be named foo.swf.gif or foo.swf.png or foo.swf.jpg)" => "Thumbnail (if the game is foo.swf the thumbnail must be named foo.swf.gif alebo foo.swf.png alebo foo.swf.jpg)",
"Edit game" => "Upraviť hru",
"If you can't see the game then you need a flash plugin for your browser" => "Ak nevidéte hru, potrebujete plugin pre svoj browser",
"Accepted requests" => "Prijaté žiadosti",
"since" => "od",
"Assigned items" => "Priradené položky",
"Select news group" => "Vybrať news group",
"Back to servers" => "Späť na servery",
"Msgs" => "Správ",
"Back to groups" => "Späť na skupiny",
"Save position" => "Uložiť pozíciu",
"Reading article from" => "Čítať článok z",
"Back to list of articles" => "Späť na výpis článkov",
"Configure news servers" => "Konfigurácia news serverov",
"Select a news server to browse" => "Vybrať news server pre prehliadanie",
"Current permissions for this object" => "Súčasné práva pre tento objekt",
"Current folder" => "Súčasná zložka",
"Your personal Wiki Page" => "Osobná Wiki stránka",
"Edit Items" => "Upraviť položky",
"List Charts" => "Vypísať charts",
"Last Chart" => "Posledný graf",
"Previous Chart" => "Predošlý graf",
"Chart created" => "Graf vytvorený",
"Next Chart" => "Další graf",
"Permanency" => "Permanencia",
"Avg" => "Priem.",
"Next chart will be generated on" => "Nasledujúci graf bude vygenerovaný dňa",
"View or vote items not listed in the chart" => "zobraziť alebo hlasovat pre položky, ktoré niesú súčasťou rebríčka",
"Select something to vote on" => "Vaša volba?",
"Item information" => "Informácie o položke",
"Dif" => "Rozdiely",
"Best Position" => "Najlepšia pozícia",
"Vote this item" => "Hlasovať pre túto položku",
"Highest" => "Najvyššia",
"No chart indicated" => "Žiadny graf nebol zadaný",
"No process indicated" => "Žiadny process nebol zadaný",
"Activity name already exists" => "Tento názov aktivity už existuje",
"No instance indicated" => "Žiadna inštancia nebola zadaná",
"No activity indicated" => "Žiadna aktivita nebola nádená",
"The process name already exists" => "Názov procesu už existuje",
"The thumbnail name must be" => "Názov miniatúry musí byť",
"No server indicated" => "Nebol zadaný žiadny server",
"Cannot connect to" => "Nie je možné sa pripojiť na",
"Cannot get messages" => "Nie je možné získat správy",
"Tiki Logo" => "Tiki Logo",
"Admin Menu" => "Administrácia menu",
"RSS Modules" => "RSS moduly",
"Chat" => "Pokec",
"Email This Post" => "pošli tento záznam emailom",
"RSS feeds" => "RSS feedy",
"Use titles in blog posts" => "Použiť titulky pre záznamy blogu",
"Send blog post" => "Poslať blog záznam",
"A link to this post was sent to the following addresses:" => "Odkaz na tento záznam bol poslaný na nasledujúce adresy:",
"Send post to this addresses" => "Poslať záznamy na tieto adresy",
"List of email addresses separated by commas" => "Zoznam emailových adries oddelených čiarkami",
"Post recommendation at" => "Pridať odporúčanie na",
"POP3 server" => "POP3 server",
"Max attachment size (bytes)" => "Max attachment size (bytes)",
"Prevent flooding" => "Zabránit floodingu",
"Minimum time between posts" => "Minimum času mezi príspevkami",
"Moderator user" => "Moderátor",
"Moderator group" => "Moderátorská skupina",
"Send this forums posts to this email" => "Posielať príspevky tohoto fóra na tento e-mail",
"Prune unreplied messages after" => "Vyradiť správy, na ktoré nebolo odpovedané, po",
"Prune old messages after" => "Vyradiť staré správy po",
"Default ordering for topics" => "Poradie témat",
"Topics per page" => "Tém na stránku",
"Default ordering for threads" => "Poradie vláken",
"Includes" => "Zahŕňa",
"to group" => "pre skupinu",
"Your registration code:" => "Váš registračný kód:",
"Registration code" => "Registračný kód",
// ### end of unused words

// ### start of untranslated words
// ### uncomment value pairs as you translate
// "For you to vote, cookies must be allowed" => "For you to vote, cookies must be allowed",
// "This forum is flat and doesn't allow replies to other replies" => "This forum is flat and doesn't allow replies to other replies",
// "This script cannot be called directly" => "This script cannot be called directly",
// "Copyright management" => "Copyright management",
// "Tiki was unable to retrieve login data from the database " => "Tiki was unable to retrieve login data from the database ",
// "The following error message was returned" => "The following error message was returned",
// "Things to check" => "Things to check",
// "Are your database login credentials correct" => "Are your database login credentials correct",
// "Did you complete the <a href='tiki-install.php' >Tiki Installer" => "Did you complete the <a href='tiki-install.php' >Tiki Installer",
// "Please see <a href=\"http://doc.tikiwiki.org/\">the documentation</a> for more information" => "Please see <a href=\"http://doc.tikiwiki.org/\">the documentation</a> for more information",
// "This feature is for admins only" => "This feature is for admins only",
// "Uploaded" => "Uploaded",
// "Last editor" => "Last editor",
// "Explorer" => "Explorer",
// "Slideshow" => "Slideshow",
// "Default View" => "Default View",
// "Afghanistan" => "Afghanistan",
// "Aland Islands" => "Aland Islands",
// "Albania" => "Albania",
// "Algeria" => "Algeria",
// "American Samoa" => "American Samoa",
// "Andorra" => "Andorra",
// "Angola" => "Angola",
// "Anguilla" => "Anguilla",
// "Antigua" => "Antigua",
// "Argentina" => "Argentina",
// "Armenia" => "Armenia",
// "Aruba" => "Aruba",
// "Australia" => "Australia",
// "Austria" => "Austria",
// "Azerbaijan" => "Azerbaijan",
// "Bahamas" => "Bahamas",
// "Bahrain" => "Bahrain",
// "Bangladesh" => "Bangladesh",
// "Barbados" => "Barbados",
// "Belarus" => "Belarus",
// "Belgium" => "Belgium",
// "Belize" => "Belize",
// "Benin" => "Benin",
// "Bermuda" => "Bermuda",
// "Bhutan" => "Bhutan",
// "Bolivia" => "Bolivia",
// "Bosnia and Herzegovina" => "Bosnia and Herzegovina",
// "Botswana" => "Botswana",
// "Bouvet Island" => "Bouvet Island",
// "Brazil" => "Brazil",
// "British Indian Ocean Territory" => "British Indian Ocean Territory",
// "British Virgin Islands" => "British Virgin Islands",
// "Brunei" => "Brunei",
// "Bulgaria" => "Bulgaria",
// "Burkina Faso" => "Burkina Faso",
// "Burundi" => "Burundi",
// "Cambodia" => "Cambodia",
// "Cameroon" => "Cameroon",
// "Canada" => "Canada",
// "Cape Verde" => "Cape Verde",
// "Catalan Countries" => "Catalan Countries",
// "Cayman Islands" => "Cayman Islands",
// "Central African Republic" => "Central African Republic",
// "Chad" => "Chad",
// "Chile" => "Chile",
// "China" => "China",
// "Christmas Island" => "Christmas Island",
// "Cocos Islands" => "Cocos Islands",
// "Colombia" => "Colombia",
// "Comoros" => "Comoros",
// "Congo" => "Congo",
// "Congo Democratic" => "Congo Democratic",
// "Cook Islands" => "Cook Islands",
// "Costa Rica" => "Costa Rica",
// "Croatia" => "Croatia",
// "Cuba" => "Cuba",
// "Cyprus" => "Cyprus",
// "Czech Republic" => "Czech Republic",
// "Denmark" => "Denmark",
// "Djibouti" => "Djibouti",
// "Dominica" => "Dominica",
// "Dominican Republic" => "Dominican Republic",
// "Ecuador" => "Ecuador",
// "Egypt" => "Egypt",
// "El Salvador" => "El Salvador",
// "Equatorial Guinea" => "Equatorial Guinea",
// "Eritrea" => "Eritrea",
// "Estonia" => "Estonia",
// "Ethiopia" => "Ethiopia",
// "Europe" => "Europe",
// "Falkland Islands" => "Falkland Islands",
// "Faroe Islands" => "Faroe Islands",
// "Federated States of Micronesia" => "Federated States of Micronesia",
// "Fiji" => "Fiji",
// "Finland" => "Finland",
// "France" => "France",
// "French Guiana" => "French Guiana",
// "French Polynesia" => "French Polynesia",
// "French Southern Territories" => "French Southern Territories",
// "Gabon" => "Gabon",
// "Gambia" => "Gambia",
// "Georgia" => "Georgia",
// "Germany" => "Germany",
// "Ghana" => "Ghana",
// "Gibraltar" => "Gibraltar",
// "Greece" => "Greece",
// "Greenland" => "Greenland",
// "Grenada" => "Grenada",
// "Guadeloupe" => "Guadeloupe",
// "Guam" => "Guam",
// "Guatemala" => "Guatemala",
// "Guernsey" => "Guernsey",
// "Guinea" => "Guinea",
// "Guinea Bissau" => "Guinea Bissau",
// "Guyana" => "Guyana",
// "Haiti" => "Haiti",
// "Heard Island and McDonald Islands" => "Heard Island and McDonald Islands",
// "Honduras" => "Honduras",
// "Hong Kong" => "Hong Kong",
// "Hungary" => "Hungary",
// "Iceland" => "Iceland",
// "India" => "India",
// "Indonesia" => "Indonesia",
// "Iran" => "Iran",
// "Iraq" => "Iraq",
// "Ireland" => "Ireland",
// "Isle of Man" => "Isle of Man",
// "Israel" => "Israel",
// "Italy" => "Italy",
// "Ivory Coast" => "Ivory Coast",
// "Jamaica" => "Jamaica",
// "Japan" => "Japan",
// "Jersey" => "Jersey",
// "Jordan" => "Jordan",
// "Kazakstan" => "Kazakstan",
// "Kenya" => "Kenya",
// "Kiribati" => "Kiribati",
// "Kuwait" => "Kuwait",
// "Kyrgyzstan" => "Kyrgyzstan",
// "Laos" => "Laos",
// "Latvia" => "Latvia",
// "Lebanon" => "Lebanon",
// "Lesotho" => "Lesotho",
// "Liberia" => "Liberia",
// "Libya" => "Libya",
// "Liechtenstein" => "Liechtenstein",
// "Lithuania" => "Lithuania",
// "Luxemburg" => "Luxemburg",
// "Macao" => "Macao",
// "Macedonia" => "Macedonia",
// "Madagascar" => "Madagascar",
// "Malawi" => "Malawi",
// "Malaysia" => "Malaysia",
// "Maldives" => "Maldives",
// "Mali" => "Mali",
// "Malta" => "Malta",
// "Marshall Islands" => "Marshall Islands",
// "Martinique" => "Martinique",
// "Mauritania" => "Mauritania",
// "Mauritius" => "Mauritius",
// "Mayotte" => "Mayotte",
// "Mexico" => "Mexico",
// "Moldova" => "Moldova",
// "Monaco" => "Monaco",
// "Mongolia" => "Mongolia",
// "Montenegro" => "Montenegro",
// "Montserrat" => "Montserrat",
// "Morocco" => "Morocco",
// "Mozambique" => "Mozambique",
// "Myanmar" => "Myanmar",
// "Namibia" => "Namibia",
// "Nauru" => "Nauru",
// "Nepal" => "Nepal",
// "Netherlands" => "Netherlands",
// "Netherlands Antilles" => "Netherlands Antilles",
// "New Caledonia" => "New Caledonia",
// "New Zealand" => "New Zealand",
// "Nicaragua" => "Nicaragua",
// "Niger" => "Niger",
// "Nigeria" => "Nigeria",
// "Niue" => "Niue",
// "Norfolk Island" => "Norfolk Island",
// "Northern Mariana Islands" => "Northern Mariana Islands",
// "North Korea" => "North Korea",
// "Norway" => "Norway",
// "Oman" => "Oman",
// "Other" => "Other",
// "Pakistan" => "Pakistan",
// "Palau" => "Palau",
// "Palestine" => "Palestine",
// "Panama" => "Panama",
// "Papua New Guinea" => "Papua New Guinea",
// "Paraguay" => "Paraguay",
// "Peru" => "Peru",
// "Philippines" => "Philippines",
// "Pitcairn" => "Pitcairn",
// "Poland" => "Poland",
// "Portugal" => "Portugal",
// "Puerto Rico" => "Puerto Rico",
// "Quatar" => "Quatar",
// "Republic of Macedonia" => "Republic of Macedonia",
// "Reunion" => "Reunion",
// "Romania" => "Romania",
// "Russia" => "Russia",
// "Rwanda" => "Rwanda",
// "Saint Helena" => "Saint Helena",
// "Saint Kitts and Nevis" => "Saint Kitts and Nevis",
// "Saint Lucia" => "Saint Lucia",
// "Saint Pierre and Miquelon" => "Saint Pierre and Miquelon",
// "Samoa" => "Samoa",
// "San Marino" => "San Marino",
// "Sao Tome and Principe" => "Sao Tome and Principe",
// "Saudi Arabia" => "Saudi Arabia",
// "Senegal" => "Senegal",
// "Serbia" => "Serbia",
// "Seychelles" => "Seychelles",
// "Sierra Leone" => "Sierra Leone",
// "Singapore" => "Singapore",
// "Slovakia" => "Slovakia",
// "Slovenia" => "Slovenia",
// "Solomon Islands" => "Solomon Islands",
// "Somalia" => "Somalia",
// "South Africa" => "South Africa",
// "South Georgia and South Sandwich Islands" => "South Georgia and South Sandwich Islands",
// "South Korea" => "South Korea",
// "Spain" => "Spain",
// "Sri Lanka" => "Sri Lanka",
// "St Vincent Grenadines" => "St Vincent Grenadines",
// "Sudan" => "Sudan",
// "Surinam" => "Surinam",
// "Svalbard and Jan Mayen" => "Svalbard and Jan Mayen",
// "Swaziland" => "Swaziland",
// "Sweden" => "Sweden",
// "Switzerland" => "Switzerland",
// "Syria" => "Syria",
// "Taiwan" => "Taiwan",
// "Tajikistan" => "Tajikistan",
// "Tanzania" => "Tanzania",
// "Thailand" => "Thailand",
// "Timor-Leste" => "Timor-Leste",
// "Togo" => "Togo",
// "Tokelau" => "Tokelau",
// "Tonga" => "Tonga",
// "Trinidad Tobago" => "Trinidad Tobago",
// "Tunisia" => "Tunisia",
// "Turkey" => "Turkey",
// "Turkmenistan" => "Turkmenistan",
// "Turks and Caicos Islands" => "Turks and Caicos Islands",
// "Tuvalu" => "Tuvalu",
// "Uganda" => "Uganda",
// "Ukraine" => "Ukraine",
// "United Arab Emirates" => "United Arab Emirates",
// "United Kingdom" => "United Kingdom",
// "United Nations Organization" => "United Nations Organization",
// "United States" => "United States",
// "United States Minor Outlying Islands" => "United States Minor Outlying Islands",
// "Uruguay" => "Uruguay",
// "US Virgin Islands" => "US Virgin Islands",
// "Uzbekistan" => "Uzbekistan",
// "Vanuatu" => "Vanuatu",
// "Vatican" => "Vatican",
// "Venezuela" => "Venezuela",
// "Viet Nam" => "Viet Nam",
// "Wales" => "Wales",
// "Wallis and Futuna" => "Wallis and Futuna",
// "Western Sahara" => "Western Sahara",
// "World" => "World",
// "Yemen" => "Yemen",
// "Yugoslavia" => "Yugoslavia",
// "Zambia" => "Zambia",
// "Zimbabwe" => "Zimbabwe",
// "MySQL Improved (mysqli). Requires MySQL 4.1+" => "MySQL Improved (mysqli). Requires MySQL 4.1+",
// "MySQL classic (mysql)" => "MySQL classic (mysql)",
// "PostgreSQL" => "PostgreSQL",
// "Email address not valid, test mail not sent" => "Email address not valid, test mail not sent",
// "Email address empty and \"copy\" checkbox not set, test mail not sent" => "Email address empty and \"copy\" checkbox not set, test mail not sent",
// "Test mail from Tiki installer " => "Test mail from Tiki installer ",
// "Tiki version" => "Tiki version",
// "PHP version" => "PHP version",
// "Server" => "Server",
// "Sent" => "Sent",
// "Congratulations!\n\nYour server can send emails.\n\n" => "Congratulations!\n\nYour server can send emails.\n\n",
// "Slovene" => "Slovene",
// "Arabic" => "Arabic",
// "Catalan" => "Catalan",
// "Simplified Chinese" => "Simplified Chinese",
// "Chinese" => "Chinese",
// "Czech" => "Czech",
// "Danish" => "Danish",
// "German" => "German",
// "English" => "English",
// "English British" => "English British",
// "Spanish" => "Spanish",
// "Greek" => "Greek",
// "Farsi" => "Farsi",
// "Finnish" => "Finnish",
// "Fijian" => "Fijian",
// "French" => "French",
// "Galician" => "Galician",
// "Hebrew" => "Hebrew",
// "Croatian" => "Croatian",
// "Italian" => "Italian",
// "Japanese" => "Japanese",
// "Korean" => "Korean",
// "Hungarian" => "Hungarian",
// "Dutch" => "Dutch",
// "Norwegian" => "Norwegian",
// "Polish" => "Polish",
// "Português" => "Português",
// "Brazilian Portuguese" => "Brazilian Portuguese",
// "Russian" => "Russian",
// "Pijin Solomon" => "Pijin Solomon",
// "Slovak" => "Slovak",
// "Serbian" => "Serbian",
// "Serbian Latin" => "Serbian Latin",
// "Swedish" => "Swedish",
// "Tuvaluan" => "Tuvaluan",
// "Traditional Chinese" => "Traditional Chinese",
// "Ukrainian" => "Ukrainian",
// "Template %s not registered" => "Template %s not registered",
// "Error line: %d" => "Error line: %d",
// "All Day" => "All Day",
// "tracker" => "tracker",
// "file gallery" => "file gallery",
// "image gallery" => "image gallery",
// "newsletter" => "newsletter",
// "survey" => "survey",
// "wiki page" => "wiki page",
// "(not registered)" => "(not registered)",
// "You have mistyped the anti-bot verification code; please try again" => "You have mistyped the anti-bot verification code; please try again",
// "Please wait %d seconds between posts" => "Please wait %d seconds between posts",
// "A contribution is mandatory" => "A contribution is mandatory",
// "Invalid Email" => "Invalid Email",
// "Your message has been queued for approval and will be posted after a moderator approves it" => "Your message has been queued for approval and will be posted after a moderator approves it",
// "This forum is locked" => "This forum is locked",
// "This thread is locked" => "This thread is locked",
// "Those comments are locked" => "Those comments are locked",
// "Line" => "Line",
// "Lines" => "Lines",
// "Newsletter subscription information at" => "Newsletter subscription information at",
// "Tiki Link - Insert internal link" => "Tiki Link - Insert internal link",
// "Select a Wiki page to link to" => "Select a Wiki page to link to",
// "Link" => "Link",
// "Cannot open this file" => "Cannot open this file",
// "The global quota has been reached" => "The global quota has been reached",
// "The quota has been reached in" => "The quota has been reached in",
// "File gallery quota exceeded" => "File gallery quota exceeded",
// "Number of files transfered to the database" => "Number of files transfered to the database",
// "Number of files transfered to the file system" => "Number of files transfered to the file system",
// "Cannot read to this file" => "Cannot read to this file",
// "This is an approximation based on your server memory limit" => "This is an approximation based on your server memory limit",
// "This is the value of your server's PHP '%s' setting" => "This is the value of your server's PHP '%s' setting",
// "You are alerted by the server " => "You are alerted by the server ",
// "You can check the modifications at : " => "You can check the modifications at : ",
// "You are alerted of a change on " => "You are alerted of a change on ",
// "Continue" => "Continue",
// "unknown destination directory. Please set it up in <a href='tiki-admin.php?page=galleries'>tiki-admin.php?page=galleries</a>" => "unknown destination directory. Please set it up in <a href='tiki-admin.php?page=galleries'>tiki-admin.php?page=galleries</a>",
// "unlink failed" => "unlink failed",
// "The uploaded file exceeds the upload_max_filesize directive in php.ini" => "The uploaded file exceeds the upload_max_filesize directive in php.ini",
// "The uploaded file exceeds the MAX_FILE_SIZE directive that was specified in the HTML form" => "The uploaded file exceeds the MAX_FILE_SIZE directive that was specified in the HTML form",
// "The uploaded file was only partially uploaded. Please try again" => "The uploaded file was only partially uploaded. Please try again",
// "No file was uploaded" => "No file was uploaded",
// "Missing a temporary folder" => "Missing a temporary folder",
// "Failed to write file to disk" => "Failed to write file to disk",
// "File upload stopped by extension" => "File upload stopped by extension",
// "Invalid file mime type" => "Invalid file mime type",
// "XML file does not validate against the Mediawiki XML schema" => "XML file does not validate against the Mediawiki XML schema",
// "Contributions" => "Contributions",
// "Query point" => "Query point",
// "layer" => "layer",
// "Record" => "Record",
// "No valid ogr2ogr executable" => "No valid ogr2ogr executable",
// "Could not create \$tdo.mif in data directory" => "Could not create \$tdo.mif in data directory",
// "Could not create \$tdo.mid in data directory" => "Could not create \$tdo.mid in data directory",
// "unknown" => "unknown",
// "User Map Generated in" => "User Map Generated in",
// "Image Map Generated in" => "Image Map Generated in",
// "You can only use optionId = 0 to create a new option or optionId equal an id that already belongs to the menu to update it" => "You can only use optionId = 0 to create a new option or optionId equal an id that already belongs to the menu to update it",
// "menu" => "menu",
// "File %s not found" => "File %s not found",
// "File %s is not a valid archive" => "File %s is not a valid archive",
// "Impossible to open %s : %s" => "Impossible to open %s : %s",
// "The content retrieved at %s is not a list of mods" => "The content retrieved at %s is not a list of mods",
// "Can't chdir to '%s'" => "Can't chdir to '%s'",
// "%s impossible to remove" => "%s impossible to remove",
// "Description not available" => "Description not available",
// "Module Title" => "Module Title",
// "Title to display at the top of the box" => "Title to display at the top of the box",
// "No box" => "No box",
// "Show only the content" => "Show only the content",
// "Decorations" => "Decorations",
// "Show module decorations" => "Show module decorations",
// "No title" => "No title",
// "Show module title" => "Show module title",
// "Perspective" => "Perspective",
// "Only display the module if in one of the listed perspectives. Semi-colon separated" => "Only display the module if in one of the listed perspectives. Semi-colon separated",
// "Module only applicable for the specified languages. Languages are defined as two character language codes. Multiple values can be separated by semi-colons" => "Module only applicable for the specified languages. Languages are defined as two character language codes. Multiple values can be separated by semi-colons",
// "Module only applicable for the specified sections. Multiple values can be separated by semi-colons" => "Module only applicable for the specified sections. Multiple values can be separated by semi-colons",
// "Page filter" => "Page filter",
// "Module only applicable on the specified page names. Multiple values can be separated by semi-colons" => "Module only applicable on the specified page names. Multiple values can be separated by semi-colons",
// "No Page" => "No Page",
// "Module not applicable on the specified page names. Multiple values can be separated by semi-colons" => "Module not applicable on the specified page names. Multiple values can be separated by semi-colons",
// "Module enabled or disabled depending on the theme. Specified themes can be either included or excluded. Theme names prefixed by \\\"!\\\" are in the exclusion list. Multiple values can be separated by semi-colons" => "Module enabled or disabled depending on the theme. Specified themes can be either included or excluded. Theme names prefixed by \\\"!\\\" are in the exclusion list. Multiple values can be separated by semi-colons",
// "Module only available based on the relationship of the user with the wiki page. Either only creators (y) or only non-creators (n) will see the module" => "Module only available based on the relationship of the user with the wiki page. Either only creators (y) or only non-creators (n) will see the module",
// "Contributor" => "Contributor",
// "Module only available based on the relationship of the user with the wiki page. Either only contributors (y) or only non-contributors (n) will see the module" => "Module only available based on the relationship of the user with the wiki page. Either only contributors (y) or only non-contributors (n) will see the module",
// "Flip" => "Flip",
// "Users can shade module" => "Users can shade module",
// "No numbers" => "No numbers",
// "If set to \"y\", the module will not number list items" => "If set to \"y\", the module will not number list items",
// "Number of rows, or items, to display" => "Number of rows, or items, to display",
// "Default: 10" => "Default: 10",
// "section edit" => "section edit",
// "This poll is closed" => "This poll is closed",
// "Users accept internal messages by default" => "Users accept internal messages by default",
// "Users can opt-out internal messages" => "Users can opt-out internal messages",
// "Title length" => "Title length",
// "Publication date" => "Publication date",
// "Expiration date" => "Expiration date",
// "Visible" => "Visible",
// "Default number per page" => "Default number per page",
// "Default Ordering" => "Default Ordering",
// "Newest first" => "Newest first",
// "Oldest first" => "Oldest first",
// "Default article image width" => "Default article image width",
// "0 for original image size" => "0 for original image size",
// "Default article image height" => "Default article image height",
// "Multiple authentication backends are supported by Tikiwiki. The default value is to use the internal user database" => "Multiple authentication backends are supported by Tikiwiki. The default value is to use the internal user database",
// "Tiki" => "Tiki",
// "Tiki and OpenID" => "Tiki and OpenID",
// "Tiki and PAM" => "Tiki and PAM",
// "Tiki and LDAP" => "Tiki and LDAP",
// "CAS (Central Authentication Service)" => "CAS (Central Authentication Service)",
// "Shibboleth" => "Shibboleth",
// "Available languages" => "Available languages",
// "By default, all languages supported by tikiwiki are available on multilingual sites. This option allows to limit the languages to a subset" => "By default, all languages supported by tikiwiki are available on multilingual sites. This option allows to limit the languages to a subset",
// "Blogues" => "Blogues",
// "Categories used in templates (TPL)" => "Categories used in templates (TPL)",
// "Exclude these categories" => "Exclude these categories",
// "Users can change site language" => "Users can change site language",
// "Allow users to change the language of the menus and labels" => "Allow users to change the language of the menus and labels",
// "Spell checking" => "Spell checking",
// "Allow anonymous visitors to use the \"Contact Us\" feature" => "Allow anonymous visitors to use the \"Contact Us\" feature",
// "Default charset for sending mail" => "Default charset for sending mail",
// "utf-8" => "utf-8",
// "iso-8859-1" => "iso-8859-1",
// "default mapfile" => "default mapfile",
// "Article RSS Description" => "Article RSS Description",
// "Description to be published as part of the RSS feed for articles" => "Description to be published as part of the RSS feed for articles",
// "Show Country Flag" => "Show Country Flag",
// "Show the country flag" => "Show the country flag",
// "Enable cool sites" => "Enable cool sites",
// "'),\n\t\t\t'type' => 'flag" => "'),\n\t\t\t'type' => 'flag",
// "Number of columns per page when listing directory categories" => "Number of columns per page when listing directory categories",
// "6" => "6",
// "'),\n\t\t\t'type' => 'text" => "'),\n\t\t\t'type' => 'text",
// "Method to Open Directory Links" => "Method to Open Directory Links",
// "PHP errors visible to admin only" => "PHP errors visible to admin only",
// "For development purposes, it\\'s better to display errors for all users. However, in production settings, they should only be displayed to administrators" => "For development purposes, it\\'s better to display errors for all users. However, in production settings, they should only be displayed to administrators",
// "PHP Error reporting level" => "PHP Error reporting level",
// "Level from which errors should be reported" => "Level from which errors should be reported",
// "No error reporting" => "No error reporting",
// "Report all PHP errors except strict" => "Report all PHP errors except strict",
// "Report all PHP errors" => "Report all PHP errors",
// "Report all PHP errors except notices" => "Report all PHP errors except notices",
// "Question and Answer prefix on Answers" => "Question and Answer prefix on Answers",
// "Q and A" => "Q and A",
// "Question ID" => "Question ID",
// "Faqs" => "Faqs",
// "Collaboratively authored documents with history of changes" => "Collaboratively authored documents with history of changes",
// "Online diaries or journals" => "Online diaries or journals",
// "Collections of graphic images for viewing or downloading (photo album)" => "Collections of graphic images for viewing or downloading (photo album)",
// "Machine Translation (by Google Translate)" => "Machine Translation (by Google Translate)",
// "Uses Google Translate to translate the content of wiki pages to other languages" => "Uses Google Translate to translate the content of wiki pages to other languages",
// "Experimental. This feature is still under development" => "Experimental. This feature is still under development",
// "Database & form generator" => "Database & form generator",
// "Online discussions on a variety of topics. Threaded or flat" => "Online discussions on a variety of topics. Threaded or flat",
// "Computer files, videos or software for downloading. With check-in & check-out (lock)" => "Computer files, videos or software for downloading. With check-in & check-out (lock)",
// "Articles can be used for date-specific news and announcements. You can configure articles to automatically publish and expire at specific times or to require that submissions be approved before becoming \"live.\"" => "Articles can be used for date-specific news and announcements. You can configure articles to automatically publish and expire at specific times or to require that submissions be approved before becoming \"live.\"",
// "Brief list of votable options; appears in module (left or right column)" => "Brief list of votable options; appears in module (left or right column)",
// "Content mailed to registered users" => "Content mailed to registered users",
// "Events calendar with public, private and group channels" => "Events calendar with public, private and group channels",
// "Insert, track, and manage advertising banners" => "Insert, track, and manage advertising banners",
// "Global category system. Items of different types (wiki pages, articles, tracker items, etc) can be added to one or many categories. Categories can have permissions" => "Global category system. Items of different types (wiki pages, articles, tracker items, etc) can be added to one or many categories. Categories can have permissions",
// "Score is a game to motivate participants to increase their contribution by comparing to other users" => "Score is a game to motivate participants to increase their contribution by comparing to other users",
// "Enables searching for content on the website" => "Enables searching for content on the website",
// "Freetags" => "Freetags",
// "Allows to set tags on pages and various objects within the website and generate tag cloud navigation patterns" => "Allows to set tags on pages and various objects within the website and generate tag cloud navigation patterns",
// "Action Log" => "Action Log",
// "Allows to keep track of what users are doing and produce reports on a per-user or per-category basis" => "Allows to keep track of what users are doing and produce reports on a per-user or per-category basis",
// "Contribution" => "Contribution",
// "Allows users to specify the type of contribution they are making while editing objects. The contributions are then displayed as color-coded in history and other reports" => "Allows users to specify the type of contribution they are making while editing objects. The contributions are then displayed as color-coded in history and other reports",
// "Multilingual" => "Multilingual",
// "Enables internationalization features and multilingual support for then entire site" => "Enables internationalization features and multilingual support for then entire site",
// "Frequently asked questions and answers" => "Frequently asked questions and answers",
// "Questionnaire with multiple choice or open ended question" => "Questionnaire with multiple choice or open ended question",
// "User-submitted Web links" => "User-submitted Web links",
// "Quizzes " => "Quizzes ",
// "Timed questionnaire with recorded scores" => "Timed questionnaire with recorded scores",
// "Simple menu system which can optionally add an external web page in an iframe" => "Simple menu system which can optionally add an external web page in an iframe",
// "The Copyright Management System (or ©MS) is a way of licensing your content" => "The Copyright Management System (or ©MS) is a way of licensing your content",
// "Multimedia" => "Multimedia",
// "The applet is designed to read MP3 or FLV file" => "The applet is designed to read MP3 or FLV file",
// "Experimental. This feature is not actively maintained" => "Experimental. This feature is not actively maintained",
// "Quick comment (graffiti) box. Like a group chat, but not in real time" => "Quick comment (graffiti) box. Like a group chat, but not in real time",
// "Maps" => "Maps",
// "Navigable, interactive maps with user-selectable layers" => "Navigable, interactive maps with user-selectable layers",
// "Requires mapserver" => "Requires mapserver",
// "Google Maps" => "Google Maps",
// "Interactive use of Google Maps" => "Interactive use of Google Maps",
// "One-on-one chatting with customer" => "One-on-one chatting with customer",
// "Tell a Friend" => "Tell a Friend",
// "Add a link \"Email this page\" in all the pages" => "Add a link \"Email this page\" in all the pages",
// "HTML pages" => "HTML pages",
// "Static and dynamic HTML content" => "Static and dynamic HTML content",
// "HTML can be used in wiki pages. This is a separate feature" => "HTML can be used in wiki pages. This is a separate feature",
// "Basic form from visitor to admin" => "Basic form from visitor to admin",
// "Minichat" => "Minichat",
// "Real-time group text chatting" => "Real-time group text chatting",
// "Comments Moderation " => "Comments Moderation ",
// "An admin must validate a comment before it is visible" => "An admin must validate a comment before it is visible",
// "Comments Locking" => "Comments Locking",
// "Comments can be closed (no new comments)" => "Comments can be closed (no new comments)",
// "Allow posting of comments as Anonymous" => "Allow posting of comments as Anonymous",
// "Permit anonymous visitors to add a comment without needing to create an account" => "Permit anonymous visitors to add a comment without needing to create an account",
// "Display page description" => "Display page description",
// "Display the page description below the heading when viewing the page" => "Display the page description below the heading when viewing the page",
// "Display page title" => "Display page title",
// "Display the page name at the top of each page. If not enabled, the content must be structured to contain a header" => "Display the page name at the top of each page. If not enabled, the content must be structured to contain a header",
// "Display page ID" => "Display page ID",
// "Display the internal page ID when viewing the page" => "Display the internal page ID when viewing the page",
// "Individual wiki cache" => "Individual wiki cache",
// "Allow users to change the duration of the cache on a per-page basis" => "Allow users to change the duration of the cache on a per-page basis",
// "JS Calendar" => "JS Calendar",
// "JavaScript popup date selector" => "JavaScript popup date selector",
// "PHPLayers" => "PHPLayers",
// "PhpLayers Dynamic menus" => "PhpLayers Dynamic menus",
// "Output should be HTMLPurified" => "Output should be HTMLPurified",
// "This enable HTPMPurifier on outputs to filter remaining security problems like XSS" => "This enable HTPMPurifier on outputs to filter remaining security problems like XSS",
// "Full Screen" => "Full Screen",
// "Allow users to activate fullscreen mode" => "Allow users to activate fullscreen mode",
// "Css Menus" => "Css Menus",
// "Css Menus (suckerfish)" => "Css Menus (suckerfish)",
// "Shadowbox" => "Shadowbox",
// "Quick Permission Assignment" => "Quick Permission Assignment",
// "Quickperms allow to define classes of privileges and grant them to roles on objects" => "Quickperms allow to define classes of privileges and grant them to roles on objects",
// "HTML Purifier" => "HTML Purifier",
// "Ajax" => "Ajax",
// "Mobile" => "Mobile",
// "Morcego 3D browser" => "Morcego 3D browser",
// "Intertiki" => "Intertiki",
// "Mindmap" => "Mindmap",
// "Print Indexed" => "Print Indexed",
// "Search engine friendly url" => "Search engine friendly url",
// "SpreadSheet" => "SpreadSheet",
// "Wysiwyg editor" => "Wysiwyg editor",
// "Ajax auto-save" => "Ajax auto-save",
// "Save draft" => "Save draft",
// "Requires AJAX (experimental)" => "Requires AJAX (experimental)",
// "Kaltura" => "Kaltura",
// "Friendship Network" => "Friendship Network",
// "Users can identify other users as their friends" => "Users can identify other users as their friends",
// "Neglected feature" => "Neglected feature",
// "Action calendar" => "Action calendar",
// "Redirect On Error" => "Redirect On Error",
// "Redirect to a similar wiki page if an exact match is not found" => "Redirect to a similar wiki page if an exact match is not found",
// "User Contacts" => "User Contacts",
// "Group Watches" => "Group Watches",
// "Daily Reports for User Watches" => "Daily Reports for User Watches",
// "User Watches Translations" => "User Watches Translations",
// "User Levels" => "User Levels",
// "Group Alert" => "Group Alert",
// "Integrator" => "Integrator",
// "TikiTests" => "TikiTests",
// "Use Minified Scripts" => "Use Minified Scripts",
// "These JavaScript files have been previously minified and are stable. They make pages quicker to load than their non-minified versions" => "These JavaScript files have been previously minified and are stable. They make pages quicker to load than their non-minified versions",
// "Check for updates automatically" => "Check for updates automatically",
// "TikiWiki will check for updates when you access the main Administration page" => "TikiWiki will check for updates when you access the main Administration page",
// "Use PEAR::Date library" => "Use PEAR::Date library",
// "Require confirmation if possible CSRF detected" => "Require confirmation if possible CSRF detected",
// "Protect against CSRF with a ticket" => "Protect against CSRF with a ticket",
// "Detect browser language" => "Detect browser language",
// "Lookup the user\\'s preferred language through browser preferences" => "Lookup the user\\'s preferred language through browser preferences",
// "Show pages in user\\'s preferred language" => "Show pages in user\\'s preferred language",
// "When accessing a page which has an equivalent in the user\\'s preferred language, favor the translated page" => "When accessing a page which has an equivalent in the user\\'s preferred language, favor the translated page",
// "Changing the page language also changes the site language" => "Changing the page language also changes the site language",
// "Translation assistant" => "Translation assistant",
// "Track translation operations between pages" => "Track translation operations between pages",
// "Urgent translation notifications" => "Urgent translation notifications",
// "Allow to flag changes as urgent, leading translations to be marked with a notice visible to all users" => "Allow to flag changes as urgent, leading translations to be marked with a notice visible to all users",
// "Incomplete translation notice" => "Incomplete translation notice",
// "When a page is translated to a new language, a notice will be automatically be inserted into the page to indicate that the translation is not yet complete" => "When a page is translated to a new language, a notice will be automatically be inserted into the page to indicate that the translation is not yet complete",
// "Multilingual structures" => "Multilingual structures",
// "Structures to lookup equivalent pages in other languages. May cause performance problems on larger structures" => "Structures to lookup equivalent pages in other languages. May cause performance problems on larger structures",
// "Display all languages in a single page" => "Display all languages in a single page",
// "List all languages as a language option in the page language drop list to see all languages at once" => "List all languages as a language option in the page language drop list to see all languages at once",
// "GZip output" => "GZip output",
// "Help System" => "Help System",
// "Translation URLs" => "Translation URLs",
// "Show clickable URLs to translate the page to another language using Babel Fish website" => "Show clickable URLs to translate the page to another language using Babel Fish website",
// "Translation icons" => "Translation icons",
// "Show clickable icons to translate the page to another language using Babelfish website" => "Show clickable icons to translate the page to another language using Babelfish website",
// "Also known as emoticons" => "Also known as emoticons",
// "Bloc of content which can be reused and programmed (timed)" => "Bloc of content which can be reused and programmed (timed)",
// "Use File Galleries to store pictures" => "Use File Galleries to store pictures",
// "External link icon" => "External link icon",
// "Semantic links" => "Semantic links",
// "Going beyond Backlinks, allows to define some semantic relationships between wiki pages" => "Going beyond Backlinks, allows to define some semantic relationships between wiki pages",
// "Web Services" => "Web Services",
// "Can consume webservices in JSON or YAML" => "Can consume webservices in JSON or YAML",
// "Breadcrumbs" => "Breadcrumbs",
// "Anonymous editors must enter anti-bot code (CAPTCHA)" => "Anonymous editors must enter anti-bot code (CAPTCHA)",
// "Protect email against spam" => "Protect email against spam",
// "Anonymous voting" => "Anonymous voting",
// "Allow re-voting" => "Allow re-voting",
// "Search engine friendly url Postfilter" => "Search engine friendly url Postfilter",
// "Display article title in the sefurl" => "Display article title in the sefurl",
// "Display blog title in the sefurl" => "Display blog title in the sefurl",
// "Show module controls" => "Show module controls",
// "Perspectives" => "Perspectives",
// "Permits to override preferences" => "Permits to override preferences",
// "Search and replace" => "Search and replace",
// "Permits find and replace of content in the edit box" => "Permits find and replace of content in the edit box",
// "Specify notification emails when creating articles" => "Specify notification emails when creating articles",
// "Category path" => "Category path",
// "Show category objects" => "Show category objects",
// "Use PHPLayers for category browser" => "Use PHPLayers for category browser",
// "Ignore category viewing restrictions" => "Ignore category viewing restrictions",
// "Screencasts" => "Screencasts",
// "Allow to upload screencasts from wiki edit. Screencasts can be uploaded locally or on a WebDAV share" => "Allow to upload screencasts from wiki edit. Screencasts can be uploaded locally or on a WebDAV share",
// "Screencasts upload location" => "Screencasts upload location",
// "Local path or webdav path to the file upload location" => "Local path or webdav path to the file upload location",
// "Trailing slash required" => "Trailing slash required",
// "Screencasts HTTP prefix" => "Screencasts HTTP prefix",
// "Prefix to use for the files when generating a link to it" => "Prefix to use for the files when generating a link to it",
// "Screencast upload type" => "Screencast upload type",
// "Mode used to upload files. WebDav is used to upload to remote servers" => "Mode used to upload files. WebDav is used to upload to remote servers",
// "Webdav" => "Webdav",
// "Screencasts authentication user" => "Screencasts authentication user",
// "When using webdav to upload files, used as the username of the authentication credentials" => "When using webdav to upload files, used as the username of the authentication credentials",
// "Screencasts authentication password" => "Screencasts authentication password",
// "When using webdav to upload files, used as the password of the authentication credentials" => "When using webdav to upload files, used as the password of the authentication credentials",
// "Screencasts max file size" => "Screencasts max file size",
// "Maximum file size used for screencasts" => "Maximum file size used for screencasts",
// "Value provided in bytes" => "Value provided in bytes",
// "Page List" => "Page List",
// "The pagelist feature allows to maintain lists of pages and their associated score and priority" => "The pagelist feature allows to maintain lists of pages and their associated score and priority",
// "Database search" => "Database search",
// "Referer Search Highlighting" => "Referer Search Highlighting",
// "Ignore individual object permissions" => "Ignore individual object permissions",
// "Object filter" => "Object filter",
// "Search box" => "Search box",
// "Pertinence" => "Pertinence",
// "Object type" => "Object type",
// "Last modified date" => "Last modified date",
// "Blog-level" => "Blog-level",
// "Batch uploading" => "Batch uploading",
// "Topic archiving" => "Topic archiving",
// "Quick jumps" => "Quick jumps",
// "Replies are empty" => "Replies are empty",
// "First post of a thread can have an empty body" => "First post of a thread can have an empty body",
// "Forum name search" => "Forum name search",
// "Forum content search" => "Forum content search",
// "Topic content search" => "Topic content search",
// "Use Tiki (database-independent) search" => "Use Tiki (database-independent) search",
// "Use database (full-text) search" => "Use database (full-text) search",
// "Store password as plain text" => "Store password as plain text",
// "Admins can search for features in the admin panels" => "Admins can search for features in the admin panels",
// "Encryption method" => "Encryption method",
// "tikihash (old)" => "tikihash (old)",
// "Display 'MyTiki' in the application menu" => "Display 'MyTiki' in the application menu",
// "Show user's contribution on the user information page" => "Show user's contribution on the user information page",
// "Permission to all (not just any) of an object's categories is required for access" => "Permission to all (not just any) of an object's categories is required for access",
// "Require file author's name for anonymous uploads" => "Require file author's name for anonymous uploads",
// "Add a Powered by Tiki link on your site's footer" => "Add a Powered by Tiki link on your site's footer",
// "Podcast directory" => "Podcast directory",
// "The server must be able to read/write the directory" => "The server must be able to read/write the directory",
// "Required for podcasts" => "Required for podcasts",
// "If you enable Directory Batch Loading, you need to setup a web-readable directory (outside of your web space is better). Then setup a way to upload files in that dir, either by scp, ftp, or other protocols" => "If you enable Directory Batch Loading, you need to setup a web-readable directory (outside of your web space is better). Then setup a way to upload files in that dir, either by scp, ftp, or other protocols",
// "The server must be able to read the directory" => "The server must be able to read the directory",
// "The directory can be outside the web space" => "The directory can be outside the web space",
// "Prevent download if score becomes negative" => "Prevent download if score becomes negative",
// "Allow download limit per file" => "Allow download limit per file",
// "Allow same file to be uploaded more than once" => "Allow same file to be uploaded more than once",
// "Never" => "Never",
// "Yes, even in the same gallery" => "Yes, even in the same gallery",
// "Only in different galleries" => "Only in different galleries",
// "Must match" => "Must match",
// "Cannot match" => "Cannot match",
// "Quota for all the files and archives" => "Quota for all the files and archives",
// "(0 for illimitted)" => "(0 for illimitted)",
// "Quota can be defined for each file gallery" => "Quota can be defined for each file gallery",
// "Default quota for each new gallery" => "Default quota for each new gallery",
// "Show quota bar in the list page" => "Show quota bar in the list page",
// "Manage thread defaults per-forum" => "Manage thread defaults per-forum",
// "Display thread configuration bar" => "Display thread configuration bar",
// "Display thread configuration bar only when number of posts exceed" => "Display thread configuration bar only when number of posts exceed",
// "Keep settings for all forums during the user session" => "Keep settings for all forums during the user session",
// "Default style" => "Default style",
// "Plain" => "Plain",
// "Threaded" => "Threaded",
// "Headers Only" => "Headers Only",
// "Default sort mode" => "Default sort mode",
// "Description length" => "Description length",
// "Do not prefix messages titles by 'Re: '" => "Do not prefix messages titles by 'Re: '",
// "Default ordering" => "Default ordering",
// "Creation Date (asc)" => "Creation Date (asc)",
// "Multilingual tags" => "Multilingual tags",
// "Permits translation management of tags" => "Permits translation management of tags",
// "Label visible in the browser\\'s title bar on all pages. Also appears in search engines" => "Label visible in the browser\\'s title bar on all pages. Also appears in search engines",
// "Validate new user registrations by email" => "Validate new user registrations by email",
// "Upon registration, the new user will receive an email containing a link to confirm validity" => "Upon registration, the new user will receive an email containing a link to confirm validity",
// "Landing page used for the wiki when no page is specified. The page will be created if it does not exist" => "Landing page used for the wiki when no page is specified. The page will be created if it does not exist",
// "Use group homepages" => "Use group homepages",
// "Go to group homepage only if login from default homepage" => "Go to group homepage only if login from default homepage",
// "Default language" => "Default language",
// "Site language used when no other language is specified by the user" => "Site language used when no other language is specified by the user",
// "Cache external pages" => "Cache external pages",
// "Cache external images" => "Cache external images",
// "Help URL" => "Help URL",
// "The default help system may not be complete. You can help with the TikiWiki documentation" => "The default help system may not be complete. You can help with the TikiWiki documentation",
// "License page" => "License page",
// "Submit notice" => "Submit notice",
// "Full path to gdaltindex" => "Full path to gdaltindex",
// "Full path to ogr2ogr" => "Full path to ogr2ogr",
// "Map Zone" => "Map Zone",
// "[-180 180]" => "[-180 180]",
// "[0 360]" => "[0 360]",
// "Hide anonymous-only modules from registered users" => "Hide anonymous-only modules from registered users",
// "Maximum number of articles on articles home page" => "Maximum number of articles on articles home page",
// "Url to go when clicking on a username" => "Url to go when clicking on a username",
// "Default: " => "Default: ",
// "Remind/forgot password" => "Remind/forgot password",
// "If passwords <em>are not</em> plain text, reset instructions will be emailed to the user" => "If passwords <em>are not</em> plain text, reset instructions will be emailed to the user",
// "If passwords <em>are stored</em> as plain text, the password will be emailed to the user" => "If passwords <em>are stored</em> as plain text, the password will be emailed to the user",
// "Verify for available translations in the database" => "Verify for available translations in the database",
// "Language inclusion threshold" => "Language inclusion threshold",
// "When the number of languages is restricted on the site, and is below this number, all languages will be added to the preferred language list, even if unspecified by the user. However, priority will be given to the specified languages" => "When the number of languages is restricted on the site, and is below this number, all languages will be added to the preferred language list, even if unspecified by the user. However, priority will be given to the specified languages",
// "Maximum average server load threshold in the last minute" => "Maximum average server load threshold in the last minute",
// "Log mail in Tiki logs" => "Log mail in Tiki logs",
// "Add HTML comment at start and end of each Smarty template (TPL)" => "Add HTML comment at start and end of each Smarty template (TPL)",
// "Log SQL" => "Log SQL",
// "Log queries using more than (seconds)" => "Log queries using more than (seconds)",
// "This may impact performance" => "This may impact performance",
// "Mail end of line" => "Mail end of line",
// "CRLF (standard)" => "CRLF (standard)",
// "LF (some Unix MTA)" => "LF (some Unix MTA)",
// "full path to mapfiles" => "full path to mapfiles",
// "Wiki Page for Help" => "Wiki Page for Help",
// "Wiki Page for Comments" => "Wiki Page for Comments",
// "Memcache" => "Memcache",
// "Enable connection to memcached servers to store temporary information" => "Enable connection to memcached servers to store temporary information",
// "Requires the PHP memcache extension" => "Requires the PHP memcache extension",
// "Memcache flags" => "Memcache flags",
// "Configuration switches for memcache connection" => "Configuration switches for memcache connection",
// "Memcache servers" => "Memcache servers",
// "Server list which may be accessed. For each server, the address, port and weight must be specified" => "Server list which may be accessed. For each server, the address, port and weight must be specified",
// "One per line. address:port (weight)" => "One per line. address:port (weight)",
// "Memcache key prefix" => "Memcache key prefix",
// "When the memcache cluster is used by multiple applications, using unique prefixes for each of them helps avoiding conflicts" => "When the memcache cluster is used by multiple applications, using unique prefixes for each of them helps avoiding conflicts",
// "Memcache expiration" => "Memcache expiration",
// "Duration for which the data will be kept" => "Duration for which the data will be kept",
// "Cache wiki data in memcache" => "Cache wiki data in memcache",
// "Cache wiki output in memcache" => "Cache wiki output in memcache",
// "Cache forum output in memcache" => "Cache forum output in memcache",
// "Allow users to define icons for menus entries" => "Allow users to define icons for menus entries",
// "Default path for the icons" => "Default path for the icons",
// "Maximum mailbox size (messages, 0=unlimited)" => "Maximum mailbox size (messages, 0=unlimited)",
// "Maximum mail archive size (messages, 0=unlimited)" => "Maximum mail archive size (messages, 0=unlimited)",
// "Maximum sent box size (messages, 0=unlimited)" => "Maximum sent box size (messages, 0=unlimited)",
// "Keywords" => "Keywords",
// "Include freetags" => "Include freetags",
// "Use thread title instead" => "Use thread title instead",
// "Use image title instead" => "Use image title instead",
// "Use individual page description for Wiki pages instead" => "Use individual page description for Wiki pages instead",
// "geo.position" => "geo.position",
// "geo.region" => "geo.region",
// "geo.placename" => "geo.placename",
// "Meta robots" => "Meta robots",
// "Revisit after" => "Revisit after",
// "Multi-domain" => "Multi-domain",
// "Allows to map domain names to perspectives and simulate multiple domains hosted on the same instance" => "Allows to map domain names to perspectives and simulate multiple domains hosted on the same instance",
// "Multi-domain Configuration" => "Multi-domain Configuration",
// "Comma-separated values mapping the domain name to the perspective ID" => "Comma-separated values mapping the domain name to the perspective ID",
// "One domain per line. Comma separated with perspective ID" => "One domain per line. Comma separated with perspective ID",
// "Wiki buttons" => "Wiki buttons",
// "Page description, icons, backlinks, .." => "Page description, icons, backlinks, ..",
// "Top " => "Top ",
// "Bottom" => "Bottom",
// "Neither" => "Neither",
// "Show categories" => "Show categories",
// "Show objects" => "Show objects",
// "Host" => "Host",
// "Proxy host" => "Proxy host",
// "Proxy port" => "Proxy port",
// "Quantify change size" => "Quantify change size",
// "In addition to tracking the changes, track the change size and display the approximate up-to-date-ness of the page" => "In addition to tracking the changes, track the change size and display the approximate up-to-date-ness of the page",
// "Keep track of the unsuccessful attemps to translate strings" => "Keep track of the unsuccessful attemps to translate strings",
// "Restrict supported languages" => "Restrict supported languages",
// "Limit the languages made available on the site" => "Limit the languages made available on the site",
// "Refresh mode" => "Refresh mode",
// "Random" => "Random",
// "Minimum length of search word" => "Minimum length of search word",
// "Max. number of words containing a syllable" => "Max. number of words containing a syllable",
// "Max. age in hours of syllable search cache" => "Max. age in hours of syllable search cache",
// "LRU list purging rate" => "LRU list purging rate",
// "LRU list length" => "LRU list length",
// "Parse the results" => "Parse the results",
// "Sender email" => "Sender email",
// "Email address that will be used as the sender for outgoing emails" => "Email address that will be used as the sender for outgoing emails",
// "Session storage location" => "Session storage location",
// "Select where the session information should be stored. Memcache sessions require memcache to be configured" => "Select where the session information should be stored. Memcache sessions require memcache to be configured",
// "Default (from php.ini)" => "Default (from php.ini)",
// "Session lifetime" => "Session lifetime",
// "Value provided in minutes" => "Value provided in minutes",
// "Silent session" => "Silent session",
// "Do not automatically start sessions" => "Do not automatically start sessions",
// "Session cookie name" => "Session cookie name",
// "Session cookie name used instead of the PHP default configuration" => "Session cookie name used instead of the PHP default configuration",
// "Display available translations" => "Display available translations",
// "Close site (except for those with permission)" => "Close site (except for those with permission)",
// "Message to display" => "Message to display",
// "Locations (breadcrumbs)" => "Locations (breadcrumbs)",
// "Choices" => "Choices",
// "Site title location" => "Site title location",
// "Location of the site title in the browser title bar relative to the current page\\'s descriptor" => "Location of the site title in the browser title bar relative to the current page\\'s descriptor",
// "After" => "After",
// "Before" => "Before",
// "Browser title display mode" => "Browser title display mode",
// "When breadcrumbs are used, method in which the browser title should be displayed" => "When breadcrumbs are used, method in which the browser title should be displayed",
// "Most specific first" => "Most specific first",
// "Least specific first (site)" => "Least specific first (site)",
// "Current only" => "Current only",
// "Include smarty notices in PHP error report" => "Include smarty notices in PHP error report",
// "In most cases, smarty notices can be safely ignored. However, they may be useful in the development process when strange issues occur" => "In most cases, smarty notices can be safely ignored. However, they may be useful in the development process when strange issues occur",
// "Smarty Security" => "Smarty Security",
// "Do not allow php code in smarty templates" => "Do not allow php code in smarty templates",
// "Check frequency" => "Check frequency",
// "Each day" => "Each day",
// "Each week" => "Each week",
// "Each month" => "Each month",
// "Minify javascript" => "Minify javascript",
// "Compress javascript files used in the page into a single file to be distributed statically. Changes to javascript files will require cache to be cleared" => "Compress javascript files used in the page into a single file to be distributed statically. Changes to javascript files will require cache to be cleared",
// "Use Jquery autocomplete user selector for better performance when number of users exceed" => "Use Jquery autocomplete user selector for better performance when number of users exceed",
// "Close site when server load is above the threshold  (except for those with permission)" => "Close site when server load is above the threshold  (except for those with permission)",
// "Use proxy" => "Use proxy",
// "Show user\\'s real name instead of login (when possible)" => "Show user\\'s real name instead of login (when possible)",
// "Display UserTracker information on the user information page" => "Display UserTracker information on the user information page",
// "Users can configure modules" => "Users can configure modules",
// "Users can shade modules" => "Users can shade modules",
// "Always" => "Always",
// "Module decides" => "Module decides",
// "500Kb" => "500Kb",
// "1Mb" => "1Mb",
// "1.5Mb" => "1.5Mb",
// "2Mb" => "2Mb",
// "2.5Mb" => "2.5Mb",
// "3Mb" => "3Mb",
// "Unlimited" => "Unlimited",
// "Include a flag by each e-mail to quickly flag/un-flag them" => "Include a flag by each e-mail to quickly flag/un-flag them",
// "Wiki link format" => "Wiki link format",
// "Character set used when detecting wiki links within pages" => "Character set used when detecting wiki links within pages",
// "Latin" => "Latin",
// "Display by default only pages in current language" => "Display by default only pages in current language",
// "In Wiki page lists, display by default only pages in current language" => "In Wiki page lists, display by default only pages in current language",
// "Display page version" => "Display page version",
// "Display the page version information when viewing the page" => "Display the page version information when viewing the page",
// "Page name display stripper" => "Page name display stripper",
// "Character to use as a delimiter in the page name. The portion of the name after this character will not be displayed" => "Character to use as a delimiter in the page name. The portion of the name after this character will not be displayed",
// "Wiki author list style" => "Wiki author list style",
// "Changes the list format used to display the authors of the page" => "Changes the list format used to display the authors of the page",
// "Creator & Author" => "Creator & Author",
// "Business style" => "Business style",
// "Collaborative style" => "Collaborative style",
// "Page last modified on" => "Page last modified on",
// "none (disabled)" => "none (disabled)",
// "Specify wiki author list style per page" => "Specify wiki author list style per page",
// "Allows to modify the style in which the author list is displayed on a per-page basis" => "Allows to modify the style in which the author list is displayed on a per-page basis",
// "Wiki action bar location" => "Wiki action bar location",
// "Buttons: Save, Preview, Cancel, .." => "Buttons: Save, Preview, Cancel, ..",
// "Both" => "Both",
// "Wiki navigation bar location" => "Wiki navigation bar location",
// "When using the ...page... page break wiki syntax" => "When using the ...page... page break wiki syntax",
// "Wiki top line location" => "Wiki top line location",
// "Cache wiki pages (global)" => "Cache wiki pages (global)",
// "Enable page cache globally for wiki pages" => "Enable page cache globally for wiki pages",
// "Allow comments per page" => "Allow comments per page",
// "Enable control for comments on wiki pages individually" => "Enable control for comments on wiki pages individually",
// "Disable" => "Disable",
// "Enable (default On)" => "Enable (default On)",
// "Enable (default Off)" => "Enable (default Off)",
// "Enable edit plugin icons" => "Enable edit plugin icons",
// "Permits editing of a plugin, via a popup form, without needing to edit the whole page" => "Permits editing of a plugin, via a popup form, without needing to edit the whole page",
// "Enable wiki 3D browser" => "Enable wiki 3D browser",
// "Load page on navigation" => "Load page on navigation",
// "Browser height" => "Browser height",
// "Navigation depth" => "Navigation depth",
// "Node size" => "Node size",
// "Text size" => "Text size",
// "Spring (connection) size" => "Spring (connection) size",
// "Existing page node color" => "Existing page node color",
// "Missing page node color" => "Missing page node color",
// "Camera distance adjusted relative to nearest node" => "Camera distance adjusted relative to nearest node",
// "Camera distance" => "Camera distance",
// "Field of view" => "Field of view",
// "Feed animation interval (milisecs)" => "Feed animation interval (milisecs)",
// "Friction constant" => "Friction constant",
// "Elastic constant" => "Elastic constant",
// "Eletrostatic constant" => "Eletrostatic constant",
// "Node mass" => "Node mass",
// "Node charge" => "Node charge",
// "Enable plugin %0" => "Enable plugin %0",
// "Inline plugin %0 (hide plugin edit icon)" => "Inline plugin %0 (hide plugin edit icon)",
// "When inlined, the plugin edit icon will not appear" => "When inlined, the plugin edit icon will not appear",
// "Wysiwyg Editor is optional" => "Wysiwyg Editor is optional",
// "... and is displayed by default" => "... and is displayed by default",
// "Reopen with the same editor" => "Reopen with the same editor",
// "Content is parsed like wiki page" => "Content is parsed like wiki page",
// "Content is partially parsed" => "Content is partially parsed",
// "Toolbar skin" => "Toolbar skin",
// "Default" => "Default",
// "Office 2003" => "Office 2003",
// "Silver" => "Silver",
// "Nothing was changed, please check profile for errors" => "Nothing was changed, please check profile for errors",
// "An error occurred: " => "An error occurred: ",
// "Applying profile" => "Applying profile",
// "Added (or modified)" => "Added (or modified)",
// "Preference set" => "Preference set",
// "Group changed (or modified)" => "Group changed (or modified)",
// "User %0 was added to %1" => "User %0 was added to %1",
// "Created by profile installer" => "Created by profile installer",
// "Page updated by profile installer" => "Page updated by profile installer",
// "No name" => "No name",
// "Bad object" => "Bad object",
// "Forums last posts" => "Forums last posts",
// "The passwords do not match" => "The passwords do not match",
// "The registration mail can't be sent. Contact the administrator" => "The registration mail can't be sent. Contact the administrator",
// "uploaded the file" => "uploaded the file",
// "changes" => "changes",
// "No changes" => "No changes",
// "Yesterday" => "Yesterday",
// "and" => "and",
// "more changes of the same type.." => "more changes of the same type..",
// "changed the picture gallery" => "changed the picture gallery",
// "uploaded the picture" => "uploaded the picture",
// "onto" => "onto",
// "removed the picture" => "removed the picture",
// "edited the wikipage" => "edited the wikipage",
// "this history" => "this history",
// "all history" => "all history",
// "edited the file gallery" => "edited the file gallery",
// "removed the file" => "removed the file",
// "added the \".\$change['data']['objectType']).\" <a href=\"\$tikiUrl/\".\$change['data']['objectUrl'].\"\">\".\$change['data']['objectName'].\"</a> \".tra(\"to the category" => "added the \".\$change['data']['objectType']).\" <a href=\"\$tikiUrl/\".\$change['data']['objectUrl'].\"\">\".\$change['data']['objectName'].\"</a> \".tra(\"to the category",
// "removed the \".\$change['data']['objectType']).\" <a href=\"\$tikiUrl/\".\$change['data']['objectUrl'].\"\">\".\$change['data']['objectName'].\"</a> \".tra(\"from the category" => "removed the \".\$change['data']['objectType']).\" <a href=\"\$tikiUrl/\".\$change['data']['objectUrl'].\"\">\".\$change['data']['objectName'].\"</a> \".tra(\"from the category",
// "created the subcategory" => "created the subcategory",
// "removed the subcategory" => "removed the subcategory",
// "edited the category" => "edited the category",
// "removed the article" => "removed the article",
// "created the article" => "created the article",
// "edited the article" => "edited the article",
// "replied to the blog" => "replied to the blog",
// "created the topic" => "created the topic",
// "at forum" => "at forum",
// "replied" => "replied",
// "to the topic" => "to the topic",
// "Nothing has happened" => "Nothing has happened",
// "Feed provided by %s. Click to visit" => "Feed provided by %s. Click to visit",
// "See other users' profiles" => "See other users' profiles",
// "Have your profile seen" => "Have your profile seen",
// "Make friends" => "Make friends",
// "Receive message" => "Receive message",
// "Read an article" => "Read an article",
// "Publish an article" => "Publish an article",
// "Have your article read" => "Have your article read",
// "Create new file gallery" => "Create new file gallery",
// "Upload new file to gallery" => "Upload new file to gallery",
// "Download other user's file" => "Download other user's file",
// "Have your file downloaded" => "Have your file downloaded",
// "Create a new image gallery" => "Create a new image gallery",
// "Upload new image to gallery" => "Upload new image to gallery",
// "See other users' galleries" => "See other users' galleries",
// "See other users' images" => "See other users' images",
// "Have your gallery seen by other users" => "Have your gallery seen by other users",
// "Have your image seen" => "Have your image seen",
// "Create new blog" => "Create new blog",
// "Post in a blog" => "Post in a blog",
// "Read other users' blogs" => "Read other users' blogs",
// "Have your blog read" => "Have your blog read",
// "Create a new wiki page" => "Create a new wiki page",
// "Edit an existing page" => "Edit an existing page",
// "Wiki Comment" => "Wiki Comment",
// "Calendar item" => "Calendar item",
// "Tracker item" => "Tracker item",
// "Unknown" => "Unknown",
// "Trackeritem" => "Trackeritem",
// "Directory category" => "Directory category",
// "Simple" => "Simple",
// "Advanced" => "Advanced",
// "_HOMEPAGE_CONTENT_" => "_HOMEPAGE_CONTENT_",
// "You are not in group of friends to have the content of this block displayed for you" => "You are not in group of friends to have the content of this block displayed for you",
// "Smarty block.display.php: Missing error param" => "Smarty block.display.php: Missing error param",
// "<!-- jq smarty plugin inactive: feature_jquery off -->" => "<!-- jq smarty plugin inactive: feature_jquery off -->",
// "Fast Next" => "Fast Next",
// "Fast Prev" => "Fast Prev",
// "First {\$params['itemname']}" => "First {\$params['itemname']}",
// "Last {\$params['itemname']}" => "Last {\$params['itemname']}",
// "Next {\$params['itemname']}" => "Next {\$params['itemname']}",
// "Prev {\$params['itemname']}" => "Prev {\$params['itemname']}",
// "tip" => "tip",
// "warning" => "warning",
// "note" => "note",
// "errors" => "errors",
// "information" => "information",
// "Tab View" => "Tab View",
// "No Tabs" => "No Tabs",
// "If you want the saved version instead of this autosaved one" => "If you want the saved version instead of this autosaved one",
// "AutoSave" => "AutoSave",
// "Your edit session will expire in" => "Your edit session will expire in",
// "You must PREVIEW or SAVE your work now, to avoid losing your edits" => "You must PREVIEW or SAVE your work now, to avoid losing your edits",
// "Your edit session has expired" => "Your edit session has expired",
// "You are about to leave this page. Changes since your last save will be lost. Are you sure you want to exit this page" => "You are about to leave this page. Changes since your last save will be lost. Are you sure you want to exit this page",
// "Help page" => "Help page",
// "View tpl" => "View tpl",
// "Edit Template" => "Edit Template",
// "Admin Feature" => "Admin Feature",
// "Hide" => "Hide",
// "The text is" => "The text is",
// "character(s) too long - please edit it" => "character(s) too long - please edit it",
// "Date Selector" => "Date Selector",
// "phplayers are not available on this site" => "phplayers are not available on this site",
// "Preference name not specified" => "Preference name not specified",
// "Preference %0 is not defined" => "Preference %0 is not defined",
// "Select All" => "Select All",
// "Invert Sort" => "Invert Sort",
// "No rows found" => "No rows found",
// "{treetable}: Number of items in _checkboxColumnIndex doesn not match items in _checkbox" => "{treetable}: Number of items in _checkboxColumnIndex doesn not match items in _checkbox",
// "{treetable}: Number of items in _checkboxTitles doesn not match items in _checkbox" => "{treetable}: Number of items in _checkboxTitles doesn not match items in _checkbox",
// "Toggle sections" => "Toggle sections",
// "sec" => "sec",
// "Text cut here" => "Text cut here",
// "Task" => "Task",
// "End date" => "End date",
// "Friend" => "Friend",
// "Gender" => "Gender",
// "km" => "km",
// "Last seen on" => "Last seen on",
// "(idle for %s seconds)" => "(idle for %s seconds)",
// "User information - Click for more info" => "User information - Click for more info",
// "More info about \$other_user" => "More info about \$other_user",
// "(idle for \$idletime seconds)" => "(idle for \$idletime seconds)",
// "Permission denied: the specified wiki page cannot be used as Smarty template resource" => "Permission denied: the specified wiki page cannot be used as Smarty template resource",
// "First day of week: Sunday (its ID is 0) - translators you need to localize this string" => "First day of week: Sunday (its ID is 0) - translators you need to localize this string",
// "Use this tree to copy the structure" => "Use this tree to copy the structure",
// "created from structure" => "created from structure",
// "Table of contents" => "Table of contents",
// "You have to make %d choice(s) for the question" => "You have to make %d choice(s) for the question",
// "You have to make at least %d choice(s) for the question" => "You have to make at least %d choice(s) for the question",
// "You have to make less than %d choice(s) for the question" => "You have to make less than %d choice(s) for the question",
// "You have to choose at least %d choice(s) for the question" => "You have to choose at least %d choice(s) for the question",
// "Foo" => "Foo",
// "Sample plugin" => "Sample plugin",
// "Face" => "Face",
// "Font family to use" => "Font family to use",
// "As defined by CSS" => "As defined by CSS",
// "unknown error" => "unknown error",
// "Page '%0' cannot be found" => "Page '%0' cannot be found",
// "For the security of your password direct access to the feed is only available via https" => "For the security of your password direct access to the feed is only available via https",
// "Help link" => "Help link",
// "Help" => "Help",
// "img-g" => "img-g",
// "file-g" => "file-g",
// "arts" => "arts",
// "Edit Plugin" => "Edit Plugin",
// "Click to edit dynamic variable" => "Click to edit dynamic variable",
// "Update variables" => "Update variables",
// "Edit Section" => "Edit Section",
// "index" => "index",
// "Show" => "Show",
// "smiling" => "smiling",
// "grinning" => "grinning",
// "confused" => "confused",
// "crying" => "crying",
// "frightened" => "frightened",
// "evil stuff" => "evil stuff",
// "exclamation mark " => "exclamation mark ",
// "frowning" => "frowning",
// "light bulb" => "light bulb",
// "idea " => "idea ",
// "LOL" => "LOL",
// "laughing out loud " => "laughing out loud ",
// "mr. green laughing" => "mr. green laughing",
// "The file was uploaded with success" => "The file was uploaded with success",
// "The file you are trying upload was only partially uploaded" => "The file you are trying upload was only partially uploaded",
// "No file was uploaded. Was a file selected " => "No file was uploaded. Was a file selected ",
// "A temporary folder is missing" => "A temporary folder is missing",
// "Unknown error" => "Unknown error",
// "Flash player not available" => "Flash player not available",
// "%d points" => "%d points",
// "Removed" => "Removed",
// "__WARNING__: Plugin disabled \$plugin" => "__WARNING__: Plugin disabled \$plugin",
// "__WARNING__: No such module \$plugin" => "__WARNING__: No such module \$plugin",
// "Create page" => "Create page",
// "Unknown language" => "Unknown language",
// "Click here to confirm your action" => "Click here to confirm your action",
// "Sea Surfing (CSRF) detected. Operation blocked" => "Sea Surfing (CSRF) detected. Operation blocked",
// "Bold" => "Bold",
// "pics/icons/text_bold.png" => "pics/icons/text_bold.png",
// "Italic" => "Italic",
// "pics/icons/text_italic.png" => "pics/icons/text_italic.png",
// "Strikethrough" => "Strikethrough",
// "pics/icons/text_strikethrough.png" => "pics/icons/text_strikethrough.png",
// "Non-parsed" => "Non-parsed",
// "pics/icons/noparse.png" => "pics/icons/noparse.png",
// "Align Center" => "Align Center",
// "pics/icons/text_align_center.png" => "pics/icons/text_align_center.png",
// "Horizontal Bar" => "Horizontal Bar",
// "pics/icons/page.png" => "pics/icons/page.png",
// "Page Break" => "Page Break",
// "lib/fckeditor_tiki/fckeditor-icons/Pagebreak.gif" => "lib/fckeditor_tiki/fckeditor-icons/Pagebreak.gif",
// "Block Quote" => "Block Quote",
// "pics/icons/box.png" => "pics/icons/box.png",
// "pics/icons/book.png" => "pics/icons/book.png",
// "Unordered List" => "Unordered List",
// "pics/icons/text_list_bullets.png" => "pics/icons/text_list_bullets.png",
// "Ordered List" => "Ordered List",
// "pics/icons/text_list_numbers.png" => "pics/icons/text_list_numbers.png",
// "Special Characters" => "Special Characters",
// "lib/fckeditor_tiki/fckeditor-icons/Specialchar.gif" => "lib/fckeditor_tiki/fckeditor-icons/Specialchar.gif",
// "img/smiles/icon_smile.gif" => "img/smiles/icon_smile.gif",
// "Foreground color" => "Foreground color",
// "pics/icons/palette.png" => "pics/icons/palette.png",
// "Background Color" => "Background Color",
// "pics/icons/palette_bg.png" => "pics/icons/palette_bg.png",
// "Wiki Link" => "Wiki Link",
// "pics/icons/page_link.png" => "pics/icons/page_link.png",
// "External Link" => "External Link",
// "pics/icons/world_link.png" => "pics/icons/world_link.png",
// "pics/icons/table.png" => "pics/icons/table.png",
// "Table Builder" => "Table Builder",
// "pics/icons/find.png" => "pics/icons/find.png",
// "Find Text" => "Find Text",
// "pics/icons/text_replace.png" => "pics/icons/text_replace.png",
// "Text Replace" => "Text Replace",
// "Full Screen Edit" => "Full Screen Edit",
// "Reduce area height" => "Reduce area height",
// "pics/icons/arrow_in.png" => "pics/icons/arrow_in.png",
// "Enlarge area height" => "Enlarge area height",
// "pics/icons/arrow_out.png" => "pics/icons/arrow_out.png",
// "Choose or upload images" => "Choose or upload images",
// "pics/icons/pictures.png" => "pics/icons/pictures.png",
// "Switch Editor (wiki or WYSIWYG)" => "Switch Editor (wiki or WYSIWYG)",
// "pics/icons/pencil_go.png" => "pics/icons/pencil_go.png",
// "Admin Toolbars" => "Admin Toolbars",
// "Upload was not successful. Duplicate file content " => "Upload was not successful. Duplicate file content ",
// "Item Modification" => "Item Modification",
// "Item creation" => "Item creation",
// "View the tracker item at" => "View the tracker item at",
// "Field is not numeric" => "Field is not numeric",
// "Field is not a link to mp3 in the gallery" => "Field is not a link to mp3 in the gallery",
// "Field is not a link to FLV in the gallery" => "Field is not a link to FLV in the gallery",
// "Field is not a link to FLV or MP3 in the gallery" => "Field is not a link to FLV or MP3 in the gallery",
// "half column" => "half column",
// "prepend" => "prepend",
// "append" => "append",
// "max" => "max",
// "<dl>\n\t\t\t\t<dt>Function: Allows alphanumeric text input in a one-line field of arbitrary size.\n\t\t\t\t<dt>Usage: <strong>samerow,size,prepend,append,max,autocomplete</strong>\n\t\t\t\t<dt>Example: 0,80,\$,,80\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[samerow]</strong> will display the next field or checkbox in the same row if a 1 is specified;\n\t\t\t\t<dd><strong>[size]</strong> is the visible length of the field in characters;\n\t\t\t\t<dd><strong>[prepend]</strong> is text that will be displayed before the field;\n\t\t\t\t<dd><strong>[append]</strong> is text that will be displayed just after the field;\n\t\t\t\t<dd><strong>[max]</strong> is the maximum number of characters that can be saved;\n\t\t\t\t<dd><strong>[autocomplete]</strong> if y autocomplete while typing;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows alphanumeric text input in a one-line field of arbitrary size.\n\t\t\t\t<dt>Usage: <strong>samerow,size,prepend,append,max,autocomplete</strong>\n\t\t\t\t<dt>Example: 0,80,\$,,80\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[samerow]</strong> will display the next field or checkbox in the same row if a 1 is specified;\n\t\t\t\t<dd><strong>[size]</strong> is the visible length of the field in characters;\n\t\t\t\t<dd><strong>[prepend]</strong> is text that will be displayed before the field;\n\t\t\t\t<dd><strong>[append]</strong> is text that will be displayed just after the field;\n\t\t\t\t<dd><strong>[max]</strong> is the maximum number of characters that can be saved;\n\t\t\t\t<dd><strong>[autocomplete]</strong> if y autocomplete while typing;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows alphanumeric text input in a multi-line field of arbitrary size.\n\t\t\t\t<dt>Usage: <strong>toolbars,width,height,max,listmax,wordmax</strong>\n\t\t\t\t<dt>Example: 0,80,5,30,200\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[toolbars]</strong> enables toolbars if a 1 is specified;\n\t\t\t\t<dd><strong>[width]</strong> is the width of the box, in chars;\n\t\t\t\t<dd><strong>[height]</strong> is the number of visible lines in the box;\n\t\t\t\t<dd><strong>[max]</strong> is the maximum number of characters that can be saved;\n\t\t\t\t<dd><strong>[listmax]</strong> is the maximum number of characters that are displayed in list mode;\n\t\t\t\t<dd><strong>[wordmax]</strong> will alert if word count exceeded with a positive number (1+) or display a word count with a negative number (-1);\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows alphanumeric text input in a multi-line field of arbitrary size.\n\t\t\t\t<dt>Usage: <strong>toolbars,width,height,max,listmax,wordmax</strong>\n\t\t\t\t<dt>Example: 0,80,5,30,200\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[toolbars]</strong> enables toolbars if a 1 is specified;\n\t\t\t\t<dd><strong>[width]</strong> is the width of the box, in chars;\n\t\t\t\t<dd><strong>[height]</strong> is the number of visible lines in the box;\n\t\t\t\t<dd><strong>[max]</strong> is the maximum number of characters that can be saved;\n\t\t\t\t<dd><strong>[listmax]</strong> is the maximum number of characters that are displayed in list mode;\n\t\t\t\t<dd><strong>[wordmax]</strong> will alert if word count exceeded with a positive number (1+) or display a word count with a negative number (-1);\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Provides a checkbox field for yes/no, on/off input.\n\t\t\t\t<dt>Usage: <strong>samerow</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[samerow]</strong> will display the next field on the same row if a 1 is specified.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a checkbox field for yes/no, on/off input.\n\t\t\t\t<dt>Usage: <strong>samerow</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[samerow]</strong> will display the next field on the same row if a 1 is specified.\n\t\t\t\t</dl>",
// "numeric field" => "numeric field",
// "<dl>\n\t\t\t\t<dt>Function: Provides a one-line field for numeric input only.  Prepend or append values may be alphanumeric.\n\t\t\t\t<dt>Usage: <strong>samerow,size,prepend,append</strong>\n\t\t\t\t<dt>Example: 0,60,,hours\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[samerow]</strong> will display the next field or checkbox in the same row if a 1 is specified;\n\t\t\t\t<dd><strong>[size]</strong> is the visible size of the field in characters;\n\t\t\t\t<dd><strong>[prepend]</strong> is text that will be displayed before the field;\n\t\t\t\t<dd><strong>[append]</strong> is text that will be displayed just after the field;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a one-line field for numeric input only.  Prepend or append values may be alphanumeric.\n\t\t\t\t<dt>Usage: <strong>samerow,size,prepend,append</strong>\n\t\t\t\t<dt>Example: 0,60,,hours\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[samerow]</strong> will display the next field or checkbox in the same row if a 1 is specified;\n\t\t\t\t<dd><strong>[size]</strong> is the visible size of the field in characters;\n\t\t\t\t<dd><strong>[prepend]</strong> is text that will be displayed before the field;\n\t\t\t\t<dd><strong>[append]</strong> is text that will be displayed just after the field;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows users to select only from a specified set of options in a drop-down bar.\n\t\t\t\t<dt>Usage: <strong>list_of_items</strong>\n\t\t\t\t<dt>Example: yes,no\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[list_of_items]</strong> is the list of all values you want in the drop-down, separated by commas;\n\t\t\t\t<dd>if you wish to specify a default value other than the first item, enter the value twice, consecutively, and it will appear once in the list as the default selection.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows users to select only from a specified set of options in a drop-down bar.\n\t\t\t\t<dt>Usage: <strong>list_of_items</strong>\n\t\t\t\t<dt>Example: yes,no\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[list_of_items]</strong> is the list of all values you want in the drop-down, separated by commas;\n\t\t\t\t<dd>if you wish to specify a default value other than the first item, enter the value twice, consecutively, and it will appear once in the list as the default selection.\n\t\t\t\t</dl>",
// "drop down with other textfield" => "drop down with other textfield",
// "<dl>\n\t\t\t\t<dt>Function: Allows users to select from a specified set of options in a drop-down bar, or provide an alternate selection in a one-line text field.\n\t\t\t\t<dt>Usage: <strong>list_of_items</strong>\n\t\t\t\t<dt>Example: yes,no\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[list_of_items]</strong> is the list of all values you want in the drop-down, separated by commas;\n\t\t\t\t<dd>if you wish to specify a default value other than the first item, enter the value twice, consecutively, and it will appear once in the list as the default selection.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows users to select from a specified set of options in a drop-down bar, or provide an alternate selection in a one-line text field.\n\t\t\t\t<dt>Usage: <strong>list_of_items</strong>\n\t\t\t\t<dt>Example: yes,no\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[list_of_items]</strong> is the list of all values you want in the drop-down, separated by commas;\n\t\t\t\t<dd>if you wish to specify a default value other than the first item, enter the value twice, consecutively, and it will appear once in the list as the default selection.\n\t\t\t\t</dl>",
// "radio buttons" => "radio buttons",
// "<dl>\n\t\t\t\t<dt>Function: Provides a multiple-choice-style set of options from which a user may only choose one.\n\t\t\t\t<dt>Usage: <strong>list_of_items</strong>\n\t\t\t\t<dt>Example: yes,no\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[list of items]</strong> is the list of all values you want in the set, separated by commas;\n\t\t\t\t<dd>if you wish to specify a default value other than the first item, enter the value twice, consecutively, and it will appear as the one selected.\n\t\t\t\t<dd>If first option is &lt;br&gt;, options will be separated with a carriaage return\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a multiple-choice-style set of options from which a user may only choose one.\n\t\t\t\t<dt>Usage: <strong>list_of_items</strong>\n\t\t\t\t<dt>Example: yes,no\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[list of items]</strong> is the list of all values you want in the set, separated by commas;\n\t\t\t\t<dd>if you wish to specify a default value other than the first item, enter the value twice, consecutively, and it will appear as the one selected.\n\t\t\t\t<dd>If first option is &lt;br&gt;, options will be separated with a carriaage return\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows a selection from a specified list of usernames.\n\t\t\t\t<dt>Usage: <strong>auto-assign,email_notify</strong>\n\t\t\t\t<dt>Example: 1,1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-assign the creator of the item if set to 1, or will set the selection to the user who last modified the item if set to 2, or will give the choice between all the users for other values;\n\t\t\t\t<dd><strong>[email_notify]</strong> will send an email to the assigned user when the item is saved;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows a selection from a specified list of usernames.\n\t\t\t\t<dt>Usage: <strong>auto-assign,email_notify</strong>\n\t\t\t\t<dt>Example: 1,1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-assign the creator of the item if set to 1, or will set the selection to the user who last modified the item if set to 2, or will give the choice between all the users for other values;\n\t\t\t\t<dd><strong>[email_notify]</strong> will send an email to the assigned user when the item is saved;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows a selection from a specified list of usergroups.\n\t\t\t\t<dt>Usage: <strong>auto-assign</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-assign the field to the usergroup of the creator if set to 1, or will set the selection to the group of the user who last modified the item if set to 2, or will give the choice between all the groups for other values;\n\t\t\t\t<dd>if the user does not have a default group set, the first group the user belongs to will be chosen, otherwise Registered group will be used.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows a selection from a specified list of usergroups.\n\t\t\t\t<dt>Usage: <strong>auto-assign</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-assign the field to the usergroup of the creator if set to 1, or will set the selection to the group of the user who last modified the item if set to 2, or will give the choice between all the groups for other values;\n\t\t\t\t<dd>if the user does not have a default group set, the first group the user belongs to will be chosen, otherwise Registered group will be used.\n\t\t\t\t</dl>",
// "IP selector" => "IP selector",
// "<dl>\n\t\t\t\t<dt>Function: Provides a field for entering an IP address.\n\t\t\t\t<dt>Usage: <strong>auto-assign</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-populate the field with the IP address of the user who created the item if set to 1, or will set the field to the IP of the user who last modified the item if set to 2, or will be a free IP for other values.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a field for entering an IP address.\n\t\t\t\t<dt>Usage: <strong>auto-assign</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-populate the field with the IP address of the user who created the item if set to 1, or will set the field to the IP of the user who last modified the item if set to 2, or will be a free IP for other values.\n\t\t\t\t</dl>",
// "page selector" => "page selector",
// "<dl>\n\t\t\t\t<dt>Function: Allows a selection from the list of pages.\n\t\t\t\t<dt>Usage: <strong>auto-assign, size, create</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-assign the creator of the item if set to 1\n\t\t\t\t<dd><strong>[size]</strong> is the visible input length of the field in characters (<=0 not limited);\n\t\t\t\t<dd><strong>[create]</strong>: will create the page if not exits copy of the page with name value of this param.which pagename is the value of this param\n\t\t\t\t<dd>\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows a selection from the list of pages.\n\t\t\t\t<dt>Usage: <strong>auto-assign, size, create</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-assign the creator of the item if set to 1\n\t\t\t\t<dd><strong>[size]</strong> is the visible input length of the field in characters (<=0 not limited);\n\t\t\t\t<dd><strong>[create]</strong>: will create the page if not exits copy of the page with name value of this param.which pagename is the value of this param\n\t\t\t\t<dd>\n\t\t\t\t</dl>",
// "country selector" => "country selector",
// "<dl>\n\t\t\t\t<dt>Function: Allows a selection from a specified list of countries.\n\t\t\t\t<dt>Usage: <strong>name_flag,sort</strong>\n\t\t\t\t<dt>Example: 1,0\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[name_flag]</strong> default is 0 and will display both the country name and its flag, 1 will display only the country name, while 2 will show only the country flag;\n\t\t\t\t<dd><strong>[sortorder]</strong> specifies the order the country list should be displayed in, where 0 is the default and sorts according to the translated name, and 1 sorts according to the english name;\n\t\t\t\t<dd>if the country names are translated and option 1 is selected for the sort order, the countries will still appear translated, but will merely be in english order.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows a selection from a specified list of countries.\n\t\t\t\t<dt>Usage: <strong>name_flag,sort</strong>\n\t\t\t\t<dt>Example: 1,0\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[name_flag]</strong> default is 0 and will display both the country name and its flag, 1 will display only the country name, while 2 will show only the country flag;\n\t\t\t\t<dd><strong>[sortorder]</strong> specifies the order the country list should be displayed in, where 0 is the default and sorts according to the translated name, and 1 sorts according to the english name;\n\t\t\t\t<dd>if the country names are translated and option 1 is selected for the sort order, the countries will still appear translated, but will merely be in english order.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Provides drop-down options to accurately select a date and/or time.\n\t\t\t\t<dt>Usage: <strong>datetime,startyear,endyear,blankdate</strong>\n\t\t\t\t<dt>Example: d,2000,,blank\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[datetime]</strong> will only allow a date to be selected if set to \"d\", and allows a full date and time selection if set to \"dt\", defaulting to \"dt\";\n\t\t\t\t<dd><strong>[startyear]</strong> allows you to specify a custom first year in the date range (eg. 1987), default is current year;\n\t\t\t\t<dd><strong>[endyear]</strong> allows you to specify a custom end year in the date range (eg. 2020), default is 4 years from now;\n\t\t\t\t<dd><strong>[blankdate]</strong> when set to \"blank\" will default the initial date field to an empty date, and allow selection of empty dates;\n\t\t\t\t<dd>blankdate is overridden if the field isMandatory;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t<dt>Example: \"d,2000,2009,blank\"\n\t\t\t\t<dd>sets a date only field from 2000 through 2009, allowing blank dates.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides drop-down options to accurately select a date and/or time.\n\t\t\t\t<dt>Usage: <strong>datetime,startyear,endyear,blankdate</strong>\n\t\t\t\t<dt>Example: d,2000,,blank\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[datetime]</strong> will only allow a date to be selected if set to \"d\", and allows a full date and time selection if set to \"dt\", defaulting to \"dt\";\n\t\t\t\t<dd><strong>[startyear]</strong> allows you to specify a custom first year in the date range (eg. 1987), default is current year;\n\t\t\t\t<dd><strong>[endyear]</strong> allows you to specify a custom end year in the date range (eg. 2020), default is 4 years from now;\n\t\t\t\t<dd><strong>[blankdate]</strong> when set to \"blank\" will default the initial date field to an empty date, and allow selection of empty dates;\n\t\t\t\t<dd>blankdate is overridden if the field isMandatory;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t<dt>Example: \"d,2000,2009,blank\"\n\t\t\t\t<dd>sets a date only field from 2000 through 2009, allowing blank dates.\n\t\t\t\t</dl>",
// "jscalendar" => "jscalendar",
// "<dl>\n\t\t\t\t<dt>Function: Provides a javascript graphical date selector to select a date and/or time.\n\t\t\t\t<dt>Usage: <strong>datetime</strong>\n\t\t\t\t<dt>Example: dt\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[datetime]</strong> will only allow a date to be selected if set to \"d\", and allows a full date and time selection if set to \"dt\", defaulting to \"dt\".\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a javascript graphical date selector to select a date and/or time.\n\t\t\t\t<dt>Usage: <strong>datetime</strong>\n\t\t\t\t<dt>Example: dt\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[datetime]</strong> will only allow a date to be selected if set to \"d\", and allows a full date and time selection if set to \"dt\", defaulting to \"dt\".\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows user to upload an image into the tracker item.\n\t\t\t\t<dt>Usage: <strong>xListSize,yListSize,xDetailsSize,yDetailsSize,uploadLimitScale,shadowBox</strong>\n\t\t\t\t<dt>Example: 30,30,100,100,1000,item\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[xListSize]</strong> sets the pixel width of the image in the list view;\n\t\t\t\t<dd><strong>[yListSize]</strong> sets the pixel height of the image in the list view;\n\t\t\t\t<dd><strong>[xDetailSize]</strong> sets the pixel width of the image in the item view;\n\t\t\t\t<dd><strong>[yDetailSize]</strong> sets the pixel height of the image in the item view;\n\t\t\t\t<dd><strong>[uploadLimitScale]</strong> sets the maximum total size of the image, in pixels (width or height);\n\t\t\t\t<dd><strong>[shadowbox]</strong> actives a shadowbox(if feature on) = \\'item\\': to use the same shadowbox for an item, =\\'individual\\': to use a shadowbox only for this image, other value= to set the group of images of the shadowbox ;\n\t\t\t\t<dd>images are stored in img/trackers;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows user to upload an image into the tracker item.\n\t\t\t\t<dt>Usage: <strong>xListSize,yListSize,xDetailsSize,yDetailsSize,uploadLimitScale,shadowBox</strong>\n\t\t\t\t<dt>Example: 30,30,100,100,1000,item\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[xListSize]</strong> sets the pixel width of the image in the list view;\n\t\t\t\t<dd><strong>[yListSize]</strong> sets the pixel height of the image in the list view;\n\t\t\t\t<dd><strong>[xDetailSize]</strong> sets the pixel width of the image in the item view;\n\t\t\t\t<dd><strong>[yDetailSize]</strong> sets the pixel height of the image in the item view;\n\t\t\t\t<dd><strong>[uploadLimitScale]</strong> sets the maximum total size of the image, in pixels (width or height);\n\t\t\t\t<dd><strong>[shadowbox]</strong> actives a shadowbox(if feature on) = \\'item\\': to use the same shadowbox for an item, =\\'individual\\': to use a shadowbox only for this image, other value= to set the group of images of the shadowbox ;\n\t\t\t\t<dd>images are stored in img/trackers;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: ?\n\t\t\t\t<dt>Usage: <strong>label,post,tiki-index.php,page:fieldname,highlight=test</strong>\n\t\t\t\t<dt>Example:\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[label]</strong> needs explanation;\n\t\t\t\t<dd><strong>[post]</strong> needs explanation;\n\t\t\t\t<dd><strong>[tiki-index.php]</strong> needs explanation;\n\t\t\t\t<dd><strong>[page:fieldname]</strong> needs explanation;\n\t\t\t\t<dd><strong>[highlight=test]</strong> needs explanation;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: ?\n\t\t\t\t<dt>Usage: <strong>label,post,tiki-index.php,page:fieldname,highlight=test</strong>\n\t\t\t\t<dt>Example:\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[label]</strong> needs explanation;\n\t\t\t\t<dd><strong>[post]</strong> needs explanation;\n\t\t\t\t<dd><strong>[tiki-index.php]</strong> needs explanation;\n\t\t\t\t<dd><strong>[page:fieldname]</strong> needs explanation;\n\t\t\t\t<dd><strong>[highlight=test]</strong> needs explanation;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "header" => "header",
// "<dl>\n\t\t\t\t<dt>Function: will display trhe field name as a html header h2;\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: will display trhe field name as a html header h2;\n\t\t\t\t</dl>",
// "static text" => "static text",
// "<dl>\n\t\t\t\t<dt>Function: Allows insertion of a static block of text into a tracker to augment input fields. (non-editable)\n\t\t\t\t<dt>Usage: <strong>wikiparse,max</strong>\n\t\t\t\t<dt>Example: 1,20\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[wikiparse]</strong> will allow wiki syntax to be parsed if set to 1, otherwise default is 0 to only support line-breaks;\n\t\t\t\t<dd><strong>[max]</strong> is the maximum number of characters that are displayed in list mode;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows insertion of a static block of text into a tracker to augment input fields. (non-editable)\n\t\t\t\t<dt>Usage: <strong>wikiparse,max</strong>\n\t\t\t\t<dt>Example: 1,20\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[wikiparse]</strong> will allow wiki syntax to be parsed if set to 1, otherwise default is 0 to only support line-breaks;\n\t\t\t\t<dd><strong>[max]</strong> is the maximum number of characters that are displayed in list mode;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows one or more categories under a main category to be assigned to the tracker item.\n\t\t\t\t<dt>Usage: <strong>parentId,inputtype,selectall</strong>\n\t\t\t\t<dt>Example: 12,radio,1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[parentId]</strong> is the ID of the main category, categories in the list will be children of this;\n\t\t\t\t<dd><strong>[inputtype]</strong> is one of [d|m|radio|checkbox], where d is a drop-down list, m is a multiple-selection drop-down list, radio and checkbox are self-explanatory;\n\t\t\t\t<dd><strong>[selectall]</strong> will provide a checkbox to automatically select all categories in the list if set to 1, default is 0;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows one or more categories under a main category to be assigned to the tracker item.\n\t\t\t\t<dt>Usage: <strong>parentId,inputtype,selectall</strong>\n\t\t\t\t<dt>Example: 12,radio,1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[parentId]</strong> is the ID of the main category, categories in the list will be children of this;\n\t\t\t\t<dd><strong>[inputtype]</strong> is one of [d|m|radio|checkbox], where d is a drop-down list, m is a multiple-selection drop-down list, radio and checkbox are self-explanatory;\n\t\t\t\t<dd><strong>[selectall]</strong> will provide a checkbox to automatically select all categories in the list if set to 1, default is 0;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "item link" => "item link",
// "<dl>\n\t\t\t\t<dt>Function: Provides a way to choose a value from another tracker (eventually with a link).\n\t\t\t\t<dt>Usage: <strong>trackerId,fieldId,linkToItem,displayedFieldsList</strong>\n\t\t\t\t<dt>Example: 3,5,1,6|8\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[trackerId]</strong> is the tracker ID of the fields you want to display;\n\t\t\t\t<dd><strong>[fieldId]</strong> is the field in [trackerId] from which you can select a value among all the field values of the items of [trackerId];\n\t\t\t\t<dd><strong>[linkToItem]</strong> if set to 0 will simply display the value, but if set to 1 will provide a link directly to the item in the other tracker;\n\t\t\t\t<dd><strong>[displayedFieldsList]</strong> is a list of fields in [trackerId] to display instead of [fieldId], multiple fields can be separated with a |;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a way to choose a value from another tracker (eventually with a link).\n\t\t\t\t<dt>Usage: <strong>trackerId,fieldId,linkToItem,displayedFieldsList</strong>\n\t\t\t\t<dt>Example: 3,5,1,6|8\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[trackerId]</strong> is the tracker ID of the fields you want to display;\n\t\t\t\t<dd><strong>[fieldId]</strong> is the field in [trackerId] from which you can select a value among all the field values of the items of [trackerId];\n\t\t\t\t<dd><strong>[linkToItem]</strong> if set to 0 will simply display the value, but if set to 1 will provide a link directly to the item in the other tracker;\n\t\t\t\t<dd><strong>[displayedFieldsList]</strong> is a list of fields in [trackerId] to display instead of [fieldId], multiple fields can be separated with a |;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "items list" => "items list",
// "<dl>\n\t\t\t\t<dt>Function: Displays a list of field values from another tracker that has a relation with this tracker(eventually with a link).\n\t\t\t\t<dt>Usage: <strong>trackerId,fieldIdThere,fieldIdHere,displayFieldIdThere,linkToItems</strong>\n\t\t\t\t<dt>Example: 5,3,4,10|11\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[trackerId]</strong> is the tracker ID of the fields you want to display;\n\t\t\t\t<dd><strong>[fieldIdThere]</strong> is the field (multiple fields can be separated with a \":\") you want to link with;\n\t\t\t\t<dd><strong>[fieldIdHere]</strong> is the field in this tracker you want to link with;\n\t\t\t\t<dd><strong>[displayFieldIdThere]</strong> the field(s) in [trackerId] you want to display, multiple fields can be separated by \"|\";\n\t\t\t\t<dd><strong>[linkToItems]</strong> if set to 0 will simply display the value, but if set to 1 will provide a link directly to that values item in the other tracker;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Displays a list of field values from another tracker that has a relation with this tracker(eventually with a link).\n\t\t\t\t<dt>Usage: <strong>trackerId,fieldIdThere,fieldIdHere,displayFieldIdThere,linkToItems</strong>\n\t\t\t\t<dt>Example: 5,3,4,10|11\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[trackerId]</strong> is the tracker ID of the fields you want to display;\n\t\t\t\t<dd><strong>[fieldIdThere]</strong> is the field (multiple fields can be separated with a \":\") you want to link with;\n\t\t\t\t<dd><strong>[fieldIdHere]</strong> is the field in this tracker you want to link with;\n\t\t\t\t<dd><strong>[displayFieldIdThere]</strong> the field(s) in [trackerId] you want to display, multiple fields can be separated by \"|\";\n\t\t\t\t<dd><strong>[linkToItems]</strong> if set to 0 will simply display the value, but if set to 1 will provide a link directly to that values item in the other tracker;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "dynamic items list" => "dynamic items list",
// "<dl>\n\t\t\t\t<dt>Function: Dynamically updates a selection list based on linked data from another tracker.\n\t\t\t\t<dt>Usage: <strong>trackerId,filterFieldIdThere,filterFieldIdHere,listFieldIdThere,statusThere</strong>\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[trackerId]</strong> is the ID of the tracker to link with;\n\t\t\t\t<dd><strong>[filterFieldIdThere]</strong> is the field you want to link with in that tracker;\n\t\t\t\t<dd><strong>[filterFieldIdHere]</strong> is the field you want to link with in the current tracker;\n\t\t\t\t<dd><strong>[listFieldIdThere]</strong> is the field ID you wish to pull the selection list from, based on the value selected in fiterFieldIdHere matching field(s) in filterFieldIdThere;\n\t\t\t\t<dd><strong>[statusThere]</strong> restricts values appearing in the list to those coming from records in the other tracker that meet specified statuses of [o|p|c] or in combination (op, opc);\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Dynamically updates a selection list based on linked data from another tracker.\n\t\t\t\t<dt>Usage: <strong>trackerId,filterFieldIdThere,filterFieldIdHere,listFieldIdThere,statusThere</strong>\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[trackerId]</strong> is the ID of the tracker to link with;\n\t\t\t\t<dd><strong>[filterFieldIdThere]</strong> is the field you want to link with in that tracker;\n\t\t\t\t<dd><strong>[filterFieldIdHere]</strong> is the field you want to link with in the current tracker;\n\t\t\t\t<dd><strong>[listFieldIdThere]</strong> is the field ID you wish to pull the selection list from, based on the value selected in fiterFieldIdHere matching field(s) in filterFieldIdThere;\n\t\t\t\t<dd><strong>[statusThere]</strong> restricts values appearing in the list to those coming from records in the other tracker that meet specified statuses of [o|p|c] or in combination (op, opc);\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows users to enter an email address with option of making it active.\n\t\t\t\t<dt>Usage: <strong>link,watchopen,watchpending,watchclosed</strong>\n\t\t\t\t<dt>Example: 0,o\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[link]</strong> may be one of [0|1|2] and specifies how to display the email address, defaulting to 0 as plain text, 1 as an encoded hex mailto link, or 2 as a standard mailto link;\n\t\t\t\t<dd><strong>[watchopen]</strong> if set to \"o\" will email the address every time the status of the item changes to open;\n\t\t\t\t<dd><strong>[watchpending]</strong> if set to \"p\" will email the address every time the status of the item changes to pending;\n\t\t\t\t<dd><strong>[watchclosed]</strong> if set to \"c\" will email the address every time the status of the item changes to closed;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows users to enter an email address with option of making it active.\n\t\t\t\t<dt>Usage: <strong>link,watchopen,watchpending,watchclosed</strong>\n\t\t\t\t<dt>Example: 0,o\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[link]</strong> may be one of [0|1|2] and specifies how to display the email address, defaulting to 0 as plain text, 1 as an encoded hex mailto link, or 2 as a standard mailto link;\n\t\t\t\t<dd><strong>[watchopen]</strong> if set to \"o\" will email the address every time the status of the item changes to open;\n\t\t\t\t<dd><strong>[watchpending]</strong> if set to \"p\" will email the address every time the status of the item changes to pending;\n\t\t\t\t<dd><strong>[watchclosed]</strong> if set to \"c\" will email the address every time the status of the item changes to closed;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows users to enter an url in a wiki syntax.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows users to enter an url in a wiki syntax.\n\t\t\t\t</dl>",
// "multimedia" => "multimedia",
// "<dl>\n\t\t\t\t<dt>Function: Will play MP3 or FLV files, as specified, in a player.\n\t\t\t\t<dt>Usage: <strong>source,xSize,ySize</strong>\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[source]</strong> is one of [0|1|2|3|4|5] where 0 is default and will support a URL in the file gallery for MP3, 1 for URL in file gallery for FLV, 2 for URL in file gallery of either MP3 or FLV, 3 to upload an MP3 file to be played, 4 to upload an FLV file to be played, 5 to upload either an MP3 or FLV file;\n\t\t\t\t<dd><strong>[xSize]</strong> is the width in pixels of the player applet (default 200);\n\t\t\t\t<dd><strong>[ySize]</strong> is the height in pixels of the player applet (default 100);\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t<dd>this is best-used as a tracker item that is not generally editable and you want a specific file played;\n\t\t\t\t\tedit the tracker item and provide the URL for the file you wish to play.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Will play MP3 or FLV files, as specified, in a player.\n\t\t\t\t<dt>Usage: <strong>source,xSize,ySize</strong>\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[source]</strong> is one of [0|1|2|3|4|5] where 0 is default and will support a URL in the file gallery for MP3, 1 for URL in file gallery for FLV, 2 for URL in file gallery of either MP3 or FLV, 3 to upload an MP3 file to be played, 4 to upload an FLV file to be played, 5 to upload either an MP3 or FLV file;\n\t\t\t\t<dd><strong>[xSize]</strong> is the width in pixels of the player applet (default 200);\n\t\t\t\t<dd><strong>[ySize]</strong> is the height in pixels of the player applet (default 100);\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t<dd>this is best-used as a tracker item that is not generally editable and you want a specific file played;\n\t\t\t\t\tedit the tracker item and provide the URL for the file you wish to play.\n\t\t\t\t</dl>",
// "auto-increment" => "auto-increment",
// "<dl>\n\t\t\t\t<dt>Function: Allows an incrementing value field, or itemId field. (non-editable)\n\t\t\t\t<dt>Usage: <strong>start,prepend,append,itemId</strong>\n\t\t\t\t<dt>Example: 1,,,itemId\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[start]</strong> is the starting value for the field, defaults to 1;\n\t\t\t\t<dd><strong>[prepend]</strong> is text that will be displayed before the field;\n\t\t\t\t<dd><strong>[append]</strong> is text that will be displayed after the field;\n\t\t\t\t<dd><strong>[itemId]</strong> if set to \"itemId\" will set this field to match the value of the actual database itemId field value;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows an incrementing value field, or itemId field. (non-editable)\n\t\t\t\t<dt>Usage: <strong>start,prepend,append,itemId</strong>\n\t\t\t\t<dt>Example: 1,,,itemId\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[start]</strong> is the starting value for the field, defaults to 1;\n\t\t\t\t<dd><strong>[prepend]</strong> is text that will be displayed before the field;\n\t\t\t\t<dd><strong>[append]</strong> is text that will be displayed after the field;\n\t\t\t\t<dd><strong>[itemId]</strong> if set to \"itemId\" will set this field to match the value of the actual database itemId field value;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "user subscription" => "user subscription",
// "<dl>\n\t\t\t\t<dt>Function: Allow registered users to subscribe themselves to a tracker item (think Evite.com).\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd>Use this field as you would to have people sign up for an event. It is best if the tracker is only editable by its creator or the admin.  To set the max number of subscribers, edit the tracker item and put the number at the beginning of the field.\n\t\t\t\t<dt>Example:\n\t\t\t\t<dd>Old field may have \"#\" or \"#2[0]\" in it.  Making it \"20#2[0]\" will set the max number to 20.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allow registered users to subscribe themselves to a tracker item (think Evite.com).\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd>Use this field as you would to have people sign up for an event. It is best if the tracker is only editable by its creator or the admin.  To set the max number of subscribers, edit the tracker item and put the number at the beginning of the field.\n\t\t\t\t<dt>Example:\n\t\t\t\t<dd>Old field may have \"#\" or \"#2[0]\" in it.  Making it \"20#2[0]\" will set the max number to 20.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Use Google Maps.\n\t\t\t\t<dt>Will display a Google Maps around a point.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Use Google Maps.\n\t\t\t\t<dt>Will display a Google Maps around a point.\n\t\t\t\t</dl>",
// "system" => "system",
// "<dl>\n\t\t\t\t<dt>Function: System only.\n\t\t\t\t<dt>Usage: None\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd>Needs a description.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: System only.\n\t\t\t\t<dt>Usage: None\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd>Needs a description.\n\t\t\t\t</dl>",
// "computed field" => "computed field",
// "<dl>\n\t\t\t\t<dt>Function: Provides a computed value based on numeric field values.\n\t\t\t\t<dt>Usage: <strong>formula</strong>\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[formula]</strong> is the formula you wish to compute, using numeric values, operators \"+ - * / ( )\", and tracker fields identified with a leading #;\n\t\t\t\t<dt>Example: \"#3*(#4+5)\"\n\t\t\t\t<dd>adds the numeric value in item 4 by 5, and multiplies it by the numeric value in item 3.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a computed value based on numeric field values.\n\t\t\t\t<dt>Usage: <strong>formula</strong>\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[formula]</strong> is the formula you wish to compute, using numeric values, operators \"+ - * / ( )\", and tracker fields identified with a leading #;\n\t\t\t\t<dt>Example: \"#3*(#4+5)\"\n\t\t\t\t<dd>adds the numeric value in item 4 by 5, and multiplies it by the numeric value in item 3.\n\t\t\t\t</dl>",
// "user preference" => "user preference",
// "<dl>\n\t\t\t\t<dt>Function: Allows user preference changes from a tracker.\n\t\t\t\t<dt>Usage: <strong>type</strong>\n\t\t\t\t<dt>Example: password\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[type]</strong> if value is password, will allow to change the user password, if value is email, will display/allow to change the user email;\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows user preference changes from a tracker.\n\t\t\t\t<dt>Usage: <strong>type</strong>\n\t\t\t\t<dt>Example: password\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[type]</strong> if value is password, will allow to change the user password, if value is email, will display/allow to change the user email;\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows a file to be attached to the tracker item.\n\t\t\t\t<dt>Usage: <strong>listview</strong>\n\t\t\t\t<dt>Example: nu\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[listview]</strong> may be one of [n|t|s|u|m] on their own or in any combination (n, t, ns, nts), allowing you to see the attachment in the item list view as its name (n), its type (t), its size (n), the username of the uploader (u), or the mediaplayer plugin(m);\n\t\t\t\tnote that this option will cost an extra query to the database for each attachment and can severely impact performance with several attachments.\n\t\t\t\t<dd>\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows a file to be attached to the tracker item.\n\t\t\t\t<dt>Usage: <strong>listview</strong>\n\t\t\t\t<dt>Example: nu\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[listview]</strong> may be one of [n|t|s|u|m] on their own or in any combination (n, t, ns, nts), allowing you to see the attachment in the item list view as its name (n), its type (t), its size (n), the username of the uploader (u), or the mediaplayer plugin(m);\n\t\t\t\tnote that this option will cost an extra query to the database for each attachment and can severely impact performance with several attachments.\n\t\t\t\t<dd>\n\t\t\t\t</dl>",
// "in group" => "in group",
// "<dl>\n\t\t\t\t<dt>Function: Allows to display if a item user is in a group and when he was assigned to the group (needs a user selector field)\n\t\t\t\t<dt>Usage: <strong>groupName,date</strong>\n\t\t\t\t<dt>Example: Members,date\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>GroupName</strong> Group to test. <strong>date</strong> displays the date the user was assigned in the group (if known), otherwise will display yes/no.\n\t\t\t\t<dd>\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows to display if a item user is in a group and when he was assigned to the group (needs a user selector field)\n\t\t\t\t<dt>Usage: <strong>groupName,date</strong>\n\t\t\t\t<dt>Example: Members,date\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>GroupName</strong> Group to test. <strong>date</strong> displays the date the user was assigned in the group (if known), otherwise will display yes/no.\n\t\t\t\t<dd>\n\t\t\t\t</dl>",
// "pending" => "pending",
// "No extra information for that attached file. " => "No extra information for that attached file. ",
// "The administrator has not yet validated your account. Please wait" => "The administrator has not yet validated your account. Please wait",
// "You must validate your account first. An email has been sent to you" => "You must validate your account first. An email has been sent to you",
// "The registration mail can't be sent because there is no server email address set, and this feature is disabled" => "The registration mail can't be sent because there is no server email address set, and this feature is disabled",
// "The user email confirmation can't be sent. Contact the administrator" => "The user email confirmation can't be sent. Contact the administrator",
// "Personal Phone" => "Personal Phone",
// "Personal Mobile" => "Personal Mobile",
// "Personal Fax" => "Personal Fax",
// "Work Phone" => "Work Phone",
// "Work Mobile" => "Work Mobile",
// "Work Fax" => "Work Fax",
// "Company" => "Company",
// "Organization" => "Organization",
// "Department" => "Department",
// "Division" => "Division",
// "Job Title" => "Job Title",
// "Street Address" => "Street Address",
// "City" => "City",
// "State" => "State",
// "Zip Code" => "Zip Code",
// "Mailbox uninitialised??" => "Mailbox uninitialised??",
// "No mail body found" => "No mail body found",
// "User-Agent Info" => "User-Agent Info",
// "Displays various information about the client" => "Displays various information about the client",
// "Info" => "Info",
// "Info required - IP|SVRSW|BROWSER" => "Info required - IP|SVRSW|BROWSER",
// "Displays browser client info" => "Displays browser client info",
// "Anchor Link" => "Anchor Link",
// "Creates a link to an anchor within a page. Anchors can be created using the ANAME plugin" => "Creates a link to an anchor within a page. Anchors can be created using the ANAME plugin",
// "Anchor link label" => "Anchor link label",
// "The anchor name as defined in the ANAME plugin" => "The anchor name as defined in the ANAME plugin",
// "The name of the wiki page containing the anchor" => "The name of the wiki page containing the anchor",
// "Creates a link to an anchor in a wiki page. Use in conjunction with the ANAME plugin, which specifies the location and name of the anchor" => "Creates a link to an anchor in a wiki page. Use in conjunction with the ANAME plugin, which specifies the location and name of the anchor",
// "linktext" => "linktext",
// "Anchor Name" => "Anchor Name",
// "Inserts an anchor in the wiki page. Anchors can be linked to using the ALINK plugin" => "Inserts an anchor in the wiki page. Anchors can be linked to using the ALINK plugin",
// "The name of the anchor" => "The name of the anchor",
// "Creates an anchor in a wiki page. Use in conjunction with the ALINK plugin, which specifies a link to the anchor" => "Creates an anchor in a wiki page. Use in conjunction with the ALINK plugin, which specifies a link to the anchor",
// "Image Annotation" => "Image Annotation",
// "Autogenerated content. Leave blank initially" => "Autogenerated content. Leave blank initially",
// "Absolute URL to the image or relative path from tikiwiki root" => "Absolute URL to the image or relative path from tikiwiki root",
// "Width" => "Width",
// "Image width" => "Image width",
// "Height" => "Height",
// "Image height" => "Image height",
// "Alignment" => "Alignment",
// "Image alignment. Possible values: left, right, center" => "Image alignment. Possible values: left, right, center",
// "Save changes to annotations" => "Save changes to annotations",
// "Image annotations changed" => "Image annotations changed",
// "Creates an annotation block for an image" => "Creates an annotation block for an image",
// "Displays an image and enables users to define zones to highlight information on the image" => "Displays an image and enables users to define zones to highlight information on the image",
// "Includes an article\\'s content within the page" => "Includes an article\\'s content within the page",
// "Field" => "Field",
// "The article field to display. Default field is Heading" => "The article field to display. Default field is Heading",
// "Article ID" => "Article ID",
// "The article to display. If no value is provided, most recent article will be used" => "The article to display. If no value is provided, most recent article will be used",
// "Includes an article" => "Includes an article",
// "~np~{ARTICLE(Field=>[,Id=>])}{ARTICLE}~/np~" => "~np~{ARTICLE(Field=>[,Id=>])}{ARTICLE}~/np~",
// "Id is optional. If not given, last article is used. Default field is heading" => "Id is optional. If not given, last article is used. Default field is heading",
// "Article List" => "Article List",
// "Inserts a list of articles in the page" => "Inserts a list of articles in the page",
// "Articles displayed" => "Articles displayed",
// "The number of articles to display in the list" => "The number of articles to display in the list",
// "Topics expression" => "Topics expression",
// "Topic ID expression" => "Topic ID expression",
// "Type expression" => "Type expression",
// "Category ID" => "Category ID",
// "The ID of the category to list from" => "The ID of the category to list from",
// "The article language to list" => "The article language to list",
// "Sort order" => "Sort order",
// "The column and order of the sort in columnName_asc or columnName_desc format. Defaults to \"publishDate_desc\" (other column examples are \"title\", \"lang\", \"authorName\" & \"topicName\")" => "The column and order of the sort in columnName_asc or columnName_desc format. Defaults to \"publishDate_desc\" (other column examples are \"title\", \"lang\", \"authorName\" & \"topicName\")",
// "Quiet" => "Quiet",
// "Whether to not report when there are no articles" => "Whether to not report when there are no articles",
// "Title only" => "Title only",
// "Whether to only show the title of the articles" => "Whether to only show the title of the articles",
// "Show body" => "Show body",
// "Whether to only show the body of the articles or just the heading" => "Whether to only show the body of the articles or just the heading",
// "Starting article" => "Starting article",
// "The article number that the list should start with" => "The article number that the list should start with",
// "Earliest date to select articles from" => "Earliest date to select articles from",
// "Latest date to select articles from" => "Latest date to select articles from",
// "Override Dates" => "Override Dates",
// "Whether obey article type\\'s \"show before publish\" and \"show after expiry\" settings" => "Whether obey article type\\'s \"show before publish\" and \"show after expiry\" settings",
// "Container class" => "Container class",
// "CSS Class to add to the container DIV.article. (Default=\"wikiplugin_articles\")" => "CSS Class to add to the container DIV.article. (Default=\"wikiplugin_articles\")",
// "Includes articles listing into a wiki page" => "Includes articles listing into a wiki page",
// "~np~{ARTICLES(max=>3, topic=>topicName, topicId=>id, type=>type, categId=>Category parent ID, lang=>en, sort=>columnName_asc|columnName_desc), quiet=>y|n, titleonly=>y|n}{ARTICLES}~/np~" => "~np~{ARTICLES(max=>3, topic=>topicName, topicId=>id, type=>type, categId=>Category parent ID, lang=>en, sort=>columnName_asc|columnName_desc), quiet=>y|n, titleonly=>y|n}{ARTICLES}~/np~",
// "Bullets" => "Bullets",
// "Inline" => "Inline",
// "Number" => "Number",
// "Show icon" => "Show icon",
// "No such attachment on this page" => "No such attachment on this page",
// "Displays an attachment or a list of them" => "Displays an attachment or a list of them",
// "Gives the name of the attached file to link to" => "Gives the name of the attached file to link to",
// "Same as name" => "Same as name",
// "Gives the name of another page the attached file is on. The file on that page is linked to instead. Only works with wiki pages" => "Gives the name of another page the attached file is on. The file on that page is linked to instead. Only works with wiki pages",
// "Shows the description as the link text instead of the file name" => "Shows the description as the link text instead of the file name",
// "Makes the list of attachments a bulleted list" => "Makes the list of attachments a bulleted list",
// "Says that this file is an image, and should be displayed inline using the img tag" => "Says that this file is an image, and should be displayed inline using the img tag",
// "Makes the text between the {ATTACH} tags the link text instead of the file name or description" => "Makes the text between the {ATTACH} tags the link text instead of the file name or description",
// "Shows all attachments from the whole wiki" => "Shows all attachments from the whole wiki",
// "Gives the number, in the list of attachments, of the attachment to link to" => "Gives the number, in the list of attachments, of the attachment to link to",
// "Gives the actual id of the attachment to link in. You probably should never use this" => "Gives the actual id of the attachment to link in. You probably should never use this",
// "Puts the number of downloads in the alt comment" => "Puts the number of downloads in the alt comment",
// "Shows a file icon" => "Shows a file icon",
// "The wiki page the avatar will link to" => "The wiki page the avatar will link to",
// "Float" => "Float",
// "left|right" => "left|right",
// "Displays a link that allows to go back in the browser history" => "Displays a link that allows to go back in the browser history",
// "Insert back link on wiki page" => "Insert back link on wiki page",
// "List all pages linking to the specified page" => "List all pages linking to the specified page",
// "The page links will point to. Default value is the current page" => "The page links will point to. Default value is the current page",
// "Displayed information" => "Displayed information",
// "Pipe separated list of fields to display. ex: hits|user" => "Pipe separated list of fields to display. ex: hits|user",
// "Excluded pages" => "Excluded pages",
// "Pipe separated list of pages to be excluded from the listing. ex: HomePage|Sandbox" => "Pipe separated list of pages to be excluded from the listing. ex: HomePage|Sandbox",
// "Include Self" => "Include Self",
// "1|0" => "1|0",
// "No Header" => "No Header",
// "List all pages that link to specific pages" => "List all pages that link to specific pages",
// "No pages links to" => "No pages links to",
// "One page links to" => "One page links to",
// "pages link to" => "pages link to",
// "Banner" => "Banner",
// "Insert a banner" => "Insert a banner",
// "Target" => "Target",
// "missing parameter" => "missing parameter",
// "Blog List" => "Blog List",
// "Use BLOGLIST to include posts from a blog" => "Use BLOGLIST to include posts from a blog",
// "Blog ID" => "Blog ID",
// "Numeric value" => "Numeric value",
// "Maximum number of entries to list" => "Maximum number of entries to list",
// "Simple list" => "Simple list",
// "Show simple list of date, title and author (default=y) or formatted list of blog posts (n)" => "Show simple list of date, title and author (default=y) or formatted list of blog posts (n)",
// "Earliest date to select posts from" => "Earliest date to select posts from",
// "Latest date to select posts from" => "Latest date to select posts from",
// "CSS Class to add to the container DIV.article. (Default=\"wikiplugin_bloglist\")" => "CSS Class to add to the container DIV.article. (Default=\"wikiplugin_bloglist\")",
// "Use BLOGLIST to include posts from a blog. Syntax is" => "Use BLOGLIST to include posts from a blog. Syntax is",
// "where Id is the blog Id and Items is the max number of posts to display" => "where Id is the blog Id and Items is the max number of posts to display",
// "Ex: ~np~{BLOGLIST(Id=2, Items=15)}{BLOGLIST}~/np~" => "Ex: ~np~{BLOGLIST(Id=2, Items=15)}{BLOGLIST}~/np~",
// "Box" => "Box",
// "Box title" => "Box title",
// "Displayed above the content" => "Displayed above the content",
// "Background color" => "Background color",
// "As defined by CSS, name or Hex code" => "As defined by CSS, name or Hex code",
// "Box width" => "Box width",
// "In pixels or percentage. Default value is 100%" => "In pixels or percentage. Default value is 100%",
// "Text Alignment" => "Text Alignment",
// "Float Position" => "Float Position",
// "for box with width less than 100%, make text wrap around the box" => "for box with width less than 100%, make text wrap around the box",
// "CSS Class" => "CSS Class",
// "Apply custom CSS class to the box" => "Apply custom CSS class to the box",
// "Includes a calendar and/or a list of calendar events" => "Includes a calendar and/or a list of calendar events",
// "Calendar filter" => "Calendar filter",
// "If set to a calendar identifier, restricts the events displayed to those in the specified calendar" => "If set to a calendar identifier, restricts the events displayed to those in the specified calendar",
// "View type" => "View type",
// "Determines how to show events" => "Determines how to show events",
// "Possible values" => "Possible values",
// "\"table\" shows events in a calendar" => "\"table\" shows events in a calendar",
// "Default value" => "Default value",
// "Calendar view type time span" => "Calendar view type time span",
// "If in calendar (or \"table\") view type, determines the time span displayed by the calendar" => "If in calendar (or \"table\") view type, determines the time span displayed by the calendar",
// "View the navigation bar" => "View the navigation bar",
// "Decide or not to show the navigation bar" => "Decide or not to show the navigation bar",
// "Includes a calendar" => "Includes a calendar",
// "~np~{CALENDAR(calendarId=>1)}{CALENDAR}" => "~np~{CALENDAR(calendarId=>1)}{CALENDAR}",
// "Id is optional. If not given, all calendars viewable by default are used" => "Id is optional. If not given, all calendars viewable by default are used",
// "Category IDs" => "Category IDs",
// "List of category IDs separated by + signs. ex: 1+2+3. Default will use category of the current page" => "List of category IDs separated by + signs. ex: 1+2+3. Default will use category of the current page",
// "Types" => "Types",
// "List of object types to include in the list separated by plus signs. ex: article+blog+faq+fgal+forum+igal+newsletter+event+poll+quiz+survey+tracker+wiki+img" => "List of object types to include in the list separated by plus signs. ex: article+blog+faq+fgal+forum+igal+newsletter+event+poll+quiz+survey+tracker+wiki+img",
// "Sort Order" => "Sort Order",
// "fieldName_asc|fieldName_desc, valid fields: type, created, name, hits, shuffle" => "fieldName_asc|fieldName_desc, valid fields: type, created, name, hits, shuffle",
// "Split" => "Split",
// "And" => "And",
// "With sub-categories" => "With sub-categories",
// "Show object name" => "Show object name",
// "Show type" => "Show type",
// "Incorrect param" => "Incorrect param",
// "Category Orphans" => "Category Orphans",
// "Display Tiki objects that have not been categorized" => "Display Tiki objects that have not been categorized",
// "wiki|article|blog|faq|fgal|forum|igal|newsletter|poll|quizz|survey|tracker" => "wiki|article|blog|faq|fgal|forum|igal|newsletter|poll|quizz|survey|tracker",
// "Category Path" => "Category Path",
// "Separator" => "Separator",
// "String used to separate the categories in the path. Default character is >" => "String used to separate the categories in the path. Default character is >",
// "Display top category" => "Display top category",
// "yes|no, default to no" => "yes|no, default to no",
// "Displays a chart from TikiSheet. This plugin can be generated by the TikiSheet chart tool" => "Displays a chart from TikiSheet. This plugin can be generated by the TikiSheet chart tool",
// "Chart caption" => "Chart caption",
// "Sheet ID" => "Sheet ID",
// "Data sheet ID" => "Data sheet ID",
// "Chart Type" => "Chart Type",
// "BarStackGraphic|MultibarGraphic|MultilineGraphic|PieChartGraphic" => "BarStackGraphic|MultibarGraphic|MultilineGraphic|PieChartGraphic",
// "Chart Width" => "Chart Width",
// "Width in pixels" => "Width in pixels",
// "Chart Height" => "Chart Height",
// "Height in pixels" => "Height in pixels",
// "Value series" => "Value series",
// "Required for pie charts" => "Required for pie charts",
// "Independant series" => "Independant series",
// "Required for types other than pie chart" => "Required for types other than pie chart",
// "Dependant series" => "Dependant series",
// "'),\n\t\t\t),\n\t\t\t'y2' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Dependant series" => "'),\n\t\t\t),\n\t\t\t'y2' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Dependant series",
// "'),\n\t\t\t),\n\t\t\t'y3' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Dependant series" => "'),\n\t\t\t),\n\t\t\t'y3' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Dependant series",
// "'),\n\t\t\t),\n\t\t\t'y4' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Dependant series" => "'),\n\t\t\t),\n\t\t\t'y4' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Dependant series",
// "'),\n\t\t\t),\n\t\t\t'color' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Colors" => "'),\n\t\t\t),\n\t\t\t'color' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Colors",
// "List of colors to use" => "List of colors to use",
// "Styles" => "Styles",
// "List of styles to use" => "List of styles to use",
// "Labels" => "Labels",
// "Labels for the series or values in the legend" => "Labels for the series or values in the legend",
// "Chart as PDF" => "Chart as PDF",
// "Chart as PostScript" => "Chart as PostScript",
// "Displays a snippet of code" => "Displays a snippet of code",
// "Caption" => "Caption",
// "Code snippet label" => "Code snippet label",
// "Word Wrap" => "Word Wrap",
// "0|1, Enable word wrapping on the code to avoid breaking the layout" => "0|1, Enable word wrapping on the code to avoid breaking the layout",
// "Colors" => "Colors",
// "Syntax highlighting to use. May not be used with line numbers. Available: php, html, sql, javascript, css, java, c, doxygen, delphi, .." => "Syntax highlighting to use. May not be used with line numbers. Available: php, html, sql, javascript, css, java, c, doxygen, delphi, ..",
// "Line numbers" => "Line numbers",
// "0|1, may not be used with colors" => "0|1, may not be used with colors",
// "Wiki syntax" => "Wiki syntax",
// "0|1, parse wiki syntax within the code snippet" => "0|1, parse wiki syntax within the code snippet",
// "Right to left" => "Right to left",
// "0|1, switch the text display from left to right to right to left" => "0|1, switch the text display from left to right to right to left",
// "Content is HTML" => "Content is HTML",
// "0|1, display the content as is instead of escaping HTML special chars" => "0|1, display the content as is instead of escaping HTML special chars",
// "note: colors and ln are exclusive" => "note: colors and ln are exclusive",
// "Includes content from the dynamic content system" => "Includes content from the dynamic content system",
// "Content ID" => "Content ID",
// "Also known as fortune cookies or taglines" => "Also known as fortune cookies or taglines",
// "Pattern to display the copyright in. May contain ~title~, ~year~ and ~authors~" => "Pattern to display the copyright in. May contain ~title~, ~year~ and ~authors~",
// "Countdown" => "Countdown",
// "Displays a countdown from now until the specified date" => "Displays a countdown from now until the specified date",
// "Text to append to the countdown" => "Text to append to the countdown",
// "Target date. Multiple formats accepted" => "Target date. Multiple formats accepted",
// "Locate Time" => "Locate Time",
// "on|off" => "on|off",
// "Items to show" => "Items to show",
// "Select: d=days, h=hours, m=minuts, s=seconds. Enter multiple values as: dhms. If blank, all items are shown" => "Select: d=days, h=hours, m=minuts, s=seconds. Enter multiple values as: dhms. If blank, all items are shown",
// "Show time since event" => "Show time since event",
// "If y, will display amount of time since the event (default). If n will simply display that the event is over" => "If y, will display amount of time since the event (default). If n will simply display that the event is over",
// "since " => "since ",
// "until " => "until ",
// " is over" => " is over",
// "Data Channel" => "Data Channel",
// "Displays a form to trigger data channels" => "Displays a form to trigger data channels",
// "List of fields to display. One field per line. Comma delimited: fieldname,label" => "List of fields to display. One field per line. Comma delimited: fieldname,label",
// "Channel Name" => "Channel Name",
// "Name of the channel as registered by the administrator" => "Name of the channel as registered by the administrator",
// "DBReport" => "DBReport",
// "Run a database report" => "Run a database report",
// "report definition" => "report definition",
// "Full DSN" => "Full DSN",
// "A full DSN (Data Source Name) connection string. eg: mysql://user:pass@server/database" => "A full DSN (Data Source Name) connection string. eg: mysql://user:pass@server/database",
// "Wiki DSN name" => "Wiki DSN name",
// "The name of a DSN connection defined by the Wiki administrator" => "The name of a DSN connection defined by the Wiki administrator",
// "0|1, parse wiki syntax within the report" => "0|1, parse wiki syntax within the report",
// "Debug" => "Debug",
// "0|1, display the parsed report definition" => "0|1, display the parsed report definition",
// "Missing db or dsn parameter" => "Missing db or dsn parameter",
// "You do not have permission to use this DSN" => "You do not have permission to use this DSN",
// "No DSN connection string found" => "No DSN connection string found",
// "Div" => "Div",
// "div|span|pre|b|i|tt|p|blockquote" => "div|span|pre|b|i|tt|p|blockquote",
// "Span" => "Span",
// "Teletype" => "Teletype",
// "Paragraph" => "Paragraph",
// "Block quote" => "Block quote",
// "left|right|center|justify" => "left|right|center|justify",
// "Right" => "Right",
// "Justify" => "Justify",
// "Float position" => "Float position",
// "left|right, for box with width less than 100%, make text wrap around the box" => "left|right, for box with width less than 100%, make text wrap around the box",
// "Left" => "Left",
// "Determine how other elements can wrap around the element" => "Determine how other elements can wrap around the element",
// "Apply custom CSS class to the div" => "Apply custom CSS class to the div",
// "HTML id" => "HTML id",
// "Sets the div\\'s id attribute, as defined by HTML" => "Sets the div\\'s id attribute, as defined by HTML",
// "Insert a division block, span, blockquote or other text formatting on wiki page" => "Insert a division block, span, blockquote or other text formatting on wiki page",
// "Definition List" => "Definition List",
// "One entry per line. Each line is in \"Term: Definition\" format" => "One entry per line. Each line is in \"Term: Definition\" format",
// "Creates a definition list" => "Creates a definition list",
// "one definition per line" => "one definition per line",
// "Equation" => "Equation",
// "Renders an equation written in LaTeX syntax as an image" => "Renders an equation written in LaTeX syntax as an image",
// "equation" => "equation",
// "Percentage of increase from normal size. 100 produces the default size. 200 produces an image twice as large" => "Percentage of increase from normal size. 100 produces the default size. 200 produces an image twice as large",
// "Renders an equation written in LaTeX syntax as a png.  Optional parameter size defaults to 100 and is the percentage of the normal size, i.e., size=200 indicates an equation 2x the normal size" => "Renders an equation written in LaTeX syntax as a png.  Optional parameter size defaults to 100 and is the percentage of the normal size, i.e., size=200 indicates an equation 2x the normal size",
// "Events" => "Events",
// "Includes the list of events from a calendar in the page" => "Includes the list of events from a calendar in the page",
// "Calendar ID" => "Calendar ID",
// "Numeric" => "Numeric",
// "Maximum days" => "Maximum days",
// "Maximum Rows" => "Maximum Rows",
// "Datetime" => "Datetime",
// "0|1" => "0|1",
// "~np~{~/np~EVENTS(calendarid=1|2,maxdays=365,max=-1,datetime=1,desc=1)}{EVENTS} Insert rss feed output into a wikipage" => "~np~{~/np~EVENTS(calendarid=1|2,maxdays=365,max=-1,datetime=1,desc=1)}{EVENTS} Insert rss feed output into a wikipage",
// "Fade" => "Fade",
// "Displays a label. On click, the block of content will fade in and fade out" => "Displays a label. On click, the block of content will fade in and fade out",
// "Wiki syntax containing the text to display" => "Wiki syntax containing the text to display",
// "Label" => "Label",
// "Label to display on first display" => "Label to display on first display",
// "Unspecified label" => "Unspecified label",
// "Fancy List" => "Fancy List",
// "One item per line starting with anything followed by \")\"" => "One item per line starting with anything followed by \")\"",
// "Use div" => "Use div",
// "Use div instead of ol" => "Use div instead of ol",
// "Class" => "Class",
// "CSS class for the fancylist" => "CSS class for the fancylist",
// "Creates a fancy-looking list" => "Creates a fancy-looking list",
// "num" => "num",
// "item text" => "item text",
// "one item per line" => "one item per line",
// "Fancy Table" => "Fancy Table",
// "Rows separated by >> in the header; for the table body, one row per line. Cells separated by | in both cases" => "Rows separated by >> in the header; for the table body, one row per line. Cells separated by | in both cases",
// "Heading row" => "Heading row",
// "Header rows of the table. Use >> to separate multiple rows" => "Header rows of the table. Use >> to separate multiple rows",
// "Heading CSS class" => "Heading CSS class",
// "CSS class to apply to the heading row" => "CSS class to apply to the heading row",
// "Header horizontal align" => "Header horizontal align",
// "Horizonatal alignments for header cells separated by |. Choices: left, right, center, justify" => "Horizonatal alignments for header cells separated by |. Choices: left, right, center, justify",
// "Header vertical align" => "Header vertical align",
// "Vertical alignments for header cells separated by |. Choices: top, middle, bottom, baseline" => "Vertical alignments for header cells separated by |. Choices: top, middle, bottom, baseline",
// "Column sort" => "Column sort",
// "Pre-sorted columns" => "Pre-sorted columns",
// "Bracketed numbers for column number and sort direction (0 = ascending, 1 = descending), for example: [0,0],[1,0]" => "Bracketed numbers for column number and sort direction (0 = ascending, 1 = descending), for example: [0,0],[1,0]",
// "Column widths" => "Column widths",
// "Column widths followed by px for pixels or % for percentages. Each column separated by |" => "Column widths followed by px for pixels or % for percentages. Each column separated by |",
// "Cell horizontal align" => "Cell horizontal align",
// "Table body column horizonatal alignments separated by |. Choices: left, right, center, justify" => "Table body column horizonatal alignments separated by |. Choices: left, right, center, justify",
// "Cell vertical align" => "Cell vertical align",
// "Table body column vertical alignments separated by |. Choices: top, middle, bottom, baseline" => "Table body column vertical alignments separated by |. Choices: top, middle, bottom, baseline",
// "The feature must be activated" => "The feature must be activated",
// "cells" => "cells",
// "heads and cells separated by |" => "heads and cells separated by |",
// "Displays a link to an attachment to a wiki page and can display an image attachment. " => "Displays a link to an attachment to a wiki page and can display an image attachment. ",
// "Gallery ID" => "Gallery ID",
// "name_asc" => "name_asc",
// "Shows ID" => "Shows ID",
// "Shows Icon" => "Shows Icon",
// "Shows Name" => "Shows Name",
// "Shows Filename" => "Shows Filename",
// "Shows Size" => "Shows Size",
// "Shows Description" => "Shows Description",
// "Shows Creation Date" => "Shows Creation Date",
// "Shows Hits" => "Shows Hits",
// "Shows Locked by" => "Shows Locked by",
// "Shows Modification Date" => "Shows Modification Date",
// "Shows Author" => "Shows Author",
// "Shows Creator" => "Shows Creator",
// "Shows Parent Gallery Name" => "Shows Parent Gallery Name",
// "Shows Number of Files" => "Shows Number of Files",
// "Shows the slideshow of a gallery" => "Shows the slideshow of a gallery",
// "List files in a file gallery (with a category) or in a category or a file gallery od this category" => "List files in a file gallery (with a category) or in a category or a file gallery od this category",
// "Displays a list of files from the File Gallery" => "Displays a list of files from the File Gallery",
// "Flash video" => "Flash video",
// "Displays a Flash (.swf) file in the wiki page" => "Displays a Flash (.swf) file in the wiki page",
// "Movie URL" => "Movie URL",
// "Complete URL to the movie to include. e.g. files/test.swf" => "Complete URL to the movie to include. e.g. files/test.swf",
// "Default width: 425" => "Default width: 425",
// "Default height: 350" => "Default height: 350",
// "Quality" => "Quality",
// "Flash video quality. Default value: high" => "Flash video quality. Default value: high",
// "Missing parameter movie to the plugin flash" => "Missing parameter movie to the plugin flash",
// "Footnote" => "Footnote",
// "Inserts a superscripted footnote number next to text and takes in footnote as parameter" => "Inserts a superscripted footnote number next to text and takes in footnote as parameter",
// "The footnote" => "The footnote",
// "Footnotearea" => "Footnotearea",
// "Inserts a section for collected footnotes in the wiki page" => "Inserts a section for collected footnotes in the wiki page",
// "Download box for a file on ftp server" => "Download box for a file on ftp server",
// "ftp" => "ftp",
// "file name" => "file name",
// "Ftp Server Name" => "Ftp Server Name",
// "Ftp User name" => "Ftp User name",
// "Ftp password" => "Ftp password",
// "Download button label" => "Download button label",
// "missing parameters" => "missing parameters",
// "Connection failed" => "Connection failed",
// "failed" => "failed",
// "Gauge" => "Gauge",
// "Displays a graphical gauge" => "Displays a graphical gauge",
// "current value (REQUIRED)" => "current value (REQUIRED)",
// "Maximum Value" => "Maximum Value",
// "Maximum possible value. Default: 100" => "Maximum possible value. Default: 100",
// "Label displayed on the left side of the gauge" => "Label displayed on the left side of the gauge",
// "Color" => "Color",
// "Bar width in pixels" => "Bar width in pixels",
// "Label Width" => "Label Width",
// "Width in pixels allocated to the label" => "Width in pixels allocated to the label",
// "Display Percentage" => "Display Percentage",
// "true|false, if true then a percentage of the maximum is displayed" => "true|false, if true then a percentage of the maximum is displayed",
// "Display Value" => "Display Value",
// "true|false, if the numeric value is displayed" => "true|false, if the numeric value is displayed",
// "Bar height in pixels" => "Bar height in pixels",
// "Google Analytics" => "Google Analytics",
// "Add the tracking code for Google Analytics" => "Add the tracking code for Google Analytics",
// "Account number" => "Account number",
// "The account number for the site" => "The account number for the site",
// "Missing parameter" => "Missing parameter",
// "googledoc" => "googledoc",
// "Leave this empty" => "Leave this empty",
// "Type of Google document" => "Type of Google document",
// "key" => "key",
// "Google doc key - for example: pXsHENf1bGGY92X1iEeJJI" => "Google doc key - for example: pXsHENf1bGGY92X1iEeJJI",
// "Name of iframe" => "Name of iframe",
// "Size of frame, use instead of width and height, they will fit the Google presentations sizes exactly. It can be small|medium|large" => "Size of frame, use instead of width and height, they will fit the Google presentations sizes exactly. It can be small|medium|large",
// "Pixels or %" => "Pixels or %",
// "Margin Height" => "Margin Height",
// "Pixels" => "Pixels",
// "Margin Width" => "Margin Width",
// "Scrolling" => "Scrolling",
// "editLink" => "editLink",
// "Required parameter \"type\" missing" => "Required parameter \"type\" missing",
// "Required parameter \"key\" missing" => "Required parameter \"key\" missing",
// "Displays a Google document" => "Displays a Google document",
// "Wiki text to display if conditions are met. The body may contain {ELSE}. Text after the marker will be displayed to users not matching the condition" => "Wiki text to display if conditions are met. The body may contain {ELSE}. Text after the marker will be displayed to users not matching the condition",
// "Allowed User Friends" => "Allowed User Friends",
// "Pipe separated list of users whose friends are allowed to view the block. ex: admin|johndoe|foo" => "Pipe separated list of users whose friends are allowed to view the block. ex: admin|johndoe|foo",
// "Allowed Groups" => "Allowed Groups",
// "Pipe separated list of groups allowed to view the block. ex: Admins|Developers" => "Pipe separated list of groups allowed to view the block. ex: Admins|Developers",
// "Denied Groups" => "Denied Groups",
// "Pipe separated list of groups denied from viewing the block. ex: Anonymous|Managers" => "Pipe separated list of groups denied from viewing the block. ex: Anonymous|Managers",
// "Display wiki text if user is in one of listed groups or group of friends" => "Display wiki text if user is in one of listed groups or group of friends",
// "Display wiki text if user is in one of listed groups" => "Display wiki text if user is in one of listed groups",
// "GroupMailCore" => "GroupMailCore",
// "Displays GroupMail functions on a wiki page. Usually set up using a plugin alias created by the GroupMail profile" => "Displays GroupMail functions on a wiki page. Usually set up using a plugin alias created by the GroupMail profile",
// "From Email" => "From Email",
// "Email address to report" => "Email address to report",
// "Tracker Id" => "Tracker Id",
// "Id of GroupMail Logs tracker (set up in alias by profile)" => "Id of GroupMail Logs tracker (set up in alias by profile)",
// "From Field Id" => "From Field Id",
// "Id of GroupMail Logs tracker field (usually set up in alias by profile)" => "Id of GroupMail Logs tracker field (usually set up in alias by profile)",
// "operator Field Id" => "operator Field Id",
// "subject Field Id" => "subject Field Id",
// "message Field Id" => "message Field Id",
// "content Field Id" => "content Field Id",
// "account Field Id" => "account Field Id",
// "datetime Field Id" => "datetime Field Id",
// "Displays GroupMail functions on a wiki page" => "Displays GroupMail functions on a wiki page",
// "Group Stats" => "Group Stats",
// "Groups separated by " => "Groups separated by ",
// "Show Percentage" => "Show Percentage",
// "Show Bar" => "Show Bar",
// "Displays some stat about group belonging" => "Displays some stat about group belonging",
// "HTML" => "HTML",
// "Include literal HTML in a Wiki page" => "Include literal HTML in a Wiki page",
// "0|1, parse wiki syntax within the html code" => "0|1, parse wiki syntax within the html code",
// "Include literal HTML" => "Include literal HTML",
// "Iframe" => "Iframe",
// "Frame title" => "Frame title",
// "iframe" => "iframe",
// "Displays an iframe" => "Displays an iframe",
// " (experimental - possible successor to img in 5.0)" => " (experimental - possible successor to img in 5.0)",
// "File ID" => "File ID",
// "Numeric ID of an image in a File Gallery (or comma-separated list). \"fileId\", \"id\" or \"src\" required" => "Numeric ID of an image in a File Gallery (or comma-separated list). \"fileId\", \"id\" or \"src\" required",
// "Image ID" => "Image ID",
// "Numeric ID of an image in an Image Gallery (or comma-separated list). \"fileId\", \"id\" or \"src\" required" => "Numeric ID of an image in an Image Gallery (or comma-separated list). \"fileId\", \"id\" or \"src\" required",
// "Image Source" => "Image Source",
// "Full URL to the image to display. \"fileId\", \"id\" or \"src\" required" => "Full URL to the image to display. \"fileId\", \"id\" or \"src\" required",
// "Maximum height or width in pixels (largest dimension is scaled).\tIf no scalesize is given one will be attempted from default or given height or width.  If scale does not match a defined scale for the gallery the full sized image is downloaded" => "Maximum height or width in pixels (largest dimension is scaled).\tIf no scalesize is given one will be attempted from default or given height or width.  If scale does not match a defined scale for the gallery the full sized image is downloaded",
// "Alias: lnk. Location the image should point to" => "Alias: lnk. Location the image should point to",
// "Link Relation" => "Link Relation",
// "\"rel\" attribute to add to the link" => "\"rel\" attribute to add to the link",
// "Link title" => "Link title",
// "Title text" => "Title text",
// "Image alt text" => "Image alt text",
// "Alternate text to display if impossible to load the image" => "Alternate text to display if impossible to load the image",
// "Alias:imalign. Image alignment in the page. (left, right)" => "Alias:imalign. Image alignment in the page. (left, right)",
// "Whether to block items from flowing next to image from the top or bottom. (top,bottom,both,none)" => "Whether to block items from flowing next to image from the top or bottom. (top,bottom,both,none)",
// "Image description to display on the page" => "Image description to display on the page",
// "Image Map" => "Image Map",
// "Name of the image map to use for the image" => "Name of the image map to use for the image",
// "CSS class to apply to the image'.\"'\".'s img tag. (Usually used in configuration rather than on individual images.)" => "CSS class to apply to the image'.\"'\".'s img tag. (Usually used in configuration rather than on individual images.)",
// "CSS Style" => "CSS Style",
// "CSS styling to apply to the plugin (usually used in configuration rather than on individual images)" => "CSS styling to apply to the plugin (usually used in configuration rather than on individual images)",
// "Border options" => "Border options",
// "Border configuration.  Values \"on\" and \"off\" control visibility, or else specify CSS styling options" => "Border configuration.  Values \"on\" and \"off\" control visibility, or else specify CSS styling options",
// "Description options" => "Description options",
// "Description configuration.\tValues \"on\" and \"off\" control visibility, or else specify CSS styling options. (Usually used in configuration rather than on individual images.)" => "Description configuration.\tValues \"on\" and \"off\" control visibility, or else specify CSS styling options. (Usually used in configuration rather than on individual images.)",
// "Default configuration" => "Default configuration",
// "Default configuration definitions. (Usually used in configuration rather than on individual images.)" => "Default configuration definitions. (Usually used in configuration rather than on individual images.)",
// "Mandatory configuration" => "Mandatory configuration",
// "Mandatory configuration definitions. (Usually used in configuration rather than on individual images.)" => "Mandatory configuration definitions. (Usually used in configuration rather than on individual images.)",
// "Display an image using configured format. Allows presentation of all images to be changed without having to alter existing content" => "Display an image using configured format. Allows presentation of all images to be changed without having to alter existing content",
// "Display an image" => "Display an image",
// "Display images" => "Display images",
// "Image source" => "Image source",
// "Full URL to the image to display. \"id\", \"fileId\", \"attId\" or \"src\" required" => "Full URL to the image to display. \"id\", \"fileId\", \"attId\" or \"src\" required",
// "Numeric ID of an image in an Image Gallery (or comma-separated list). \"id\", \"fileId\", \"attId\" or \"src\" required" => "Numeric ID of an image in an Image Gallery (or comma-separated list). \"id\", \"fileId\", \"attId\" or \"src\" required",
// "Numeric ID of an image in a File Gallery (or comma-separated list). \"id\", \"fileId\", \"attId\" or \"src\" required" => "Numeric ID of an image in a File Gallery (or comma-separated list). \"id\", \"fileId\", \"attId\" or \"src\" required",
// "Attachment ID" => "Attachment ID",
// "Numeric ID of an image attached to a wiki page (or comma-separated list). \"id\", \"fileId\", \"attId\" or \"src\" required" => "Numeric ID of an image attached to a wiki page (or comma-separated list). \"id\", \"fileId\", \"attId\" or \"src\" required",
// "Makes the image a thumbnail that enlarges to full size when clicked or moused over (unless \"link\" is set to another target). \"browse\" and \"browsepopup\" only work with image gallery and \"download\" only works with file gallery" => "Makes the image a thumbnail that enlarges to full size when clicked or moused over (unless \"link\" is set to another target). \"browse\" and \"browsepopup\" only work with image gallery and \"download\" only works with file gallery",
// "Full size image appears when thumbnail is clicked" => "Full size image appears when thumbnail is clicked",
// "Mouseover" => "Mouseover",
// "Full size image will pop up while cursor is over the thumbnail (and disappear when not)" => "Full size image will pop up while cursor is over the thumbnail (and disappear when not)",
// "Mouseover (Sticky)" => "Mouseover (Sticky)",
// "Full size image will pop up once cursor passes over thumbnail and will remain up unless cursor passes over full size popup" => "Full size image will pop up once cursor passes over thumbnail and will remain up unless cursor passes over full size popup",
// "Popup" => "Popup",
// "Full size image will open in a separate winow or tab (depending on browser settings) when thumbnail is clicked" => "Full size image will open in a separate winow or tab (depending on browser settings) when thumbnail is clicked",
// "Image gallery browse window for the image will open when the thumbnail is clicked if the image is in a Tiki image gallery" => "Image gallery browse window for the image will open when the thumbnail is clicked if the image is in a Tiki image gallery",
// "Browse Popup" => "Browse Popup",
// "Same as \"browse\" except that the page opens in a new window or tab" => "Same as \"browse\" except that the page opens in a new window or tab",
// "Download" => "Download",
// "Download dialog box will appear for file gallery images when thumbnail is clicked" => "Download dialog box will appear for file gallery images when thumbnail is clicked",
// "Enlarge button" => "Enlarge button",
// "Button for enlarging image" => "Button for enlarging image",
// "Enter a url to the address the image should link to. Not needed if thumb parameter is set; overrides thumb setting" => "Enter a url to the address the image should link to. Not needed if thumb parameter is set; overrides thumb setting",
// "Link relation" => "Link relation",
// "Enter \"box\" for colorbox effect (like shadowbox and lightbox) or appropriate syntax for link relation" => "Enter \"box\" for colorbox effect (like shadowbox and lightbox) or appropriate syntax for link relation",
// "Image map" => "Image map",
// "Maximum image size" => "Maximum image size",
// "Maximum height or width in pixels (largest dimension is scaled). Overrides height and width settings" => "Maximum height or width in pixels (largest dimension is scaled). Overrides height and width settings",
// "Align image" => "Align image",
// "Aligns the image itself. If the image is inside a box (because of other settings), use the align parameter to align the box" => "Aligns the image itself. If the image is inside a box (because of other settings), use the align parameter to align the box",
// "Image style" => "Image style",
// "Enter \"border\" to place a dark gray border around the image. Otherwise enter CSS styling syntax for other style effects" => "Enter \"border\" to place a dark gray border around the image. Otherwise enter CSS styling syntax for other style effects",
// "Align image block" => "Align image block",
// "Aligns the box containing the image" => "Aligns the box containing the image",
// "Image block style" => "Image block style",
// "Enter \"border\" to place a dark gray border frame around the image. Otherwise enter CSS styling syntax for other style effects" => "Enter \"border\" to place a dark gray border frame around the image. Otherwise enter CSS styling syntax for other style effects",
// "Description style" => "Description style",
// "Enter \"right\" or \"left\" to align text accordingly. Otherwise enter CSS styling syntax for other style effects" => "Enter \"right\" or \"left\" to align text accordingly. Otherwise enter CSS styling syntax for other style effects",
// "Wrapping control" => "Wrapping control",
// "Control how other items wrap around the image" => "Control how other items wrap around the image",
// "CSS class" => "CSS class",
// "CSS class to apply to the image" => "CSS class to apply to the image",
// "Image caption. \"desc\" or \"name\" for tiki images, \"idesc\" or \"ititle\" for iptc data, otherwise enter your own description" => "Image caption. \"desc\" or \"name\" for tiki images, \"idesc\" or \"ititle\" for iptc data, otherwise enter your own description",
// "Alternate text" => "Alternate text",
// "Alternate text that displays when image does not load" => "Alternate text that displays when image does not load",
// "Default config settings" => "Default config settings",
// "Default configuration settings (usually set by admin)" => "Default configuration settings (usually set by admin)",
// "Mandatory admin setting" => "Mandatory admin setting",
// "Mandatory configuration settings (usually set by admin)" => "Mandatory configuration settings (usually set by admin)",
// "File not found" => "File not found",
// "File is not an image" => "File is not an image",
// "Server does not support image manipulation" => "Server does not support image manipulation",
// "''No image specified. Either the fileId, attId, id, or src parameter must be specified.''" => "''No image specified. Either the fileId, attId, id, or src parameter must be specified.''",
// "''Use one and only one of the following parameters: fileId, attId, id, or src.''" => "''Use one and only one of the following parameters: fileId, attId, id, or src.''",
// "Include a page\\'s content" => "Include a page\\'s content",
// "Page Name" => "Page Name",
// "Wiki page name to include" => "Wiki page name to include",
// "When only a portion of the page should be included, specify the marker from which inclusion should start" => "When only a portion of the page should be included, specify the marker from which inclusion should start",
// "When only a portion of the page should be included, specify the marker at which inclusion should end" => "When only a portion of the page should be included, specify the marker at which inclusion should end",
// "Include a page" => "Include a page",
// "Invite" => "Invite",
// "Invite an email in groups" => "Invite an email in groups",
// "Confirmation message after posting form" => "Confirmation message after posting form",
// "Including group" => "Including group",
// "Default group" => "Default group",
// "Group from the item group selector / creator field" => "Group from the item group selector / creator field",
// "Following mandatory fields are missing" => "Following mandatory fields are missing",
// "Email address" => "Email address",
// "Jabber" => "Jabber",
// "Runs a Java applet to access a local Jabber service" => "Runs a Java applet to access a local Jabber service",
// "Applet height in pixels" => "Applet height in pixels",
// "'),\n\t\t\t\t'description' => tra('Applet width in pixels" => "'),\n\t\t\t\t'description' => tra('Applet width in pixels",
// "'),\n\t\t\t\t'description' => tra('jabber.org" => "'),\n\t\t\t\t'description' => tra('jabber.org",
// "Default Color" => "Default Color",
// "255,255,255" => "255,255,255",
// "JQuery" => "JQuery",
// "Insert JQuery javascript code. Requires feature_jquery" => "Insert JQuery javascript code. Requires feature_jquery",
// " (experimental - may change in future versions)" => " (experimental - may change in future versions)",
// "JQuery Code" => "JQuery Code",
// "NotOnReady" => "NotOnReady",
// "NoJQuery" => "NoJQuery",
// "Optional markup for when feature_jquery is off" => "Optional markup for when feature_jquery is off",
// "Insert JQuery javascript code" => "Insert JQuery javascript code",
// "jquery code e.g. \$jq(\"img\\" => "jquery code e.g. \$jq(\"img\\",
// "Do not execute on document ready (execute inline)" => "Do not execute on document ready (execute inline)",
// "Javascript" => "Javascript",
// "Insert a javascript file or/and some javascript code" => "Insert a javascript file or/and some javascript code",
// "javascript code" => "javascript code",
// "Javascript filename" => "Javascript filename",
// "Kaltura video" => "Kaltura video",
// "Displays a KALTURA video on the wiki page" => "Displays a KALTURA video on the wiki page",
// "Kaltura Entry Id" => "Kaltura Entry Id",
// "List of languages for which the block is displayed. Languages use the two letter language codes (ex: en, fr, es, ...). Multiple languages can be specified by separating codes by + signs" => "List of languages for which the block is displayed. Languages use the two letter language codes (ex: en, fr, es, ...). Multiple languages can be specified by separating codes by + signs",
// "Not Language" => "Not Language",
// "List of languages for which the block is not displayed. Languages use the two letter language codes (ex: en, fr, es, ...). Multiple languages can be specified by separating codes by + signs" => "List of languages for which the block is not displayed. Languages use the two letter language codes (ex: en, fr, es, ...). Multiple languages can be specified by separating codes by + signs",
// "Displays the text only if the language matchs" => "Displays the text only if the language matchs",
// "Page name to display information of. Default value is current page" => "Page name to display information of. Default value is current page",
// "The last_mod plugin replaces itself with last modification time of the named wiki page, or the current page if no name given" => "The last_mod plugin replaces itself with last modification time of the named wiki page, or the current page if no name given",
// "List wiki pages" => "List wiki pages",
// "Result Offset" => "Result Offset",
// "Result number at which the listing should start" => "Result number at which the listing should start",
// "Result Count" => "Result Count",
// "Number of results displayed in the list" => "Number of results displayed in the list",
// "Initial" => "Initial",
// "txt" => "txt",
// "Show Name Only" => "Show Name Only",
// "Structure Head" => "Structure Head",
// "Show Page Alias" => "Show Page Alias",
// "Two letter language code to filter pages listed" => "Two letter language code to filter pages listed",
// "Orphan Language" => "Orphan Language",
// "Two letter language code to filter pages listed. Only pages not available in the provided language will be listed" => "Two letter language code to filter pages listed. Only pages not available in the provided language will be listed",
// "Load Translations" => "Load Translations",
// "user or pipe separated list of two letter language codes for additional languages to display. If the language parameter is not defined, the first element of this list will be used as the primary filter" => "user or pipe separated list of two letter language codes for additional languages to display. If the language parameter is not defined, the first element of this list will be used as the primary filter",
// "Exact Match" => "Exact Match",
// "Related to Find" => "Related to Find",
// "Only Orphan Pages" => "Only Orphan Pages",
// "For List Pages" => "For List Pages",
// "List Progress" => "List Progress",
// "Indicates the internationalization progress of the page list" => "Indicates the internationalization progress of the page list",
// "List Name" => "List Name",
// "Name of the list as configured in the page list admin panel" => "Name of the list as configured in the page list admin panel",
// "Limit" => "Limit",
// "Maximum amount of results to display" => "Maximum amount of results to display",
// "Filter to apply to the page list" => "Filter to apply to the page list",
// "Score Limit" => "Score Limit",
// "Value used as the denominator for the score" => "Value used as the denominator for the score",
// "complete" => "complete",
// "List Directory" => "List Directory",
// "Lists files in a directory" => "Lists files in a directory",
// "Full path to the server-local directory" => "Full path to the server-local directory",
// "URL Prefix" => "URL Prefix",
// ".ext" => ".ext",
// "Maximum amount of files to display" => "Maximum amount of files to display",
// "could not be opened because it doesn't exist or permission was denied" => "could not be opened because it doesn't exist or permission was denied",
// "Displays a map" => "Displays a map",
// "Map File" => "Map File",
// "Extents" => "Extents",
// "Mayan Calendars Info" => "Mayan Calendars Info",
// "Convert date from Gregorian to Mayan Calendars: Tzolkin, Haab, Long Count" => "Convert date from Gregorian to Mayan Calendars: Tzolkin, Haab, Long Count",
// "You must use the variable substitution.<br/>'.\n                             'LongCount: %baktun%, %katun%, %tun%, %winal%, %kin%;<br/>'.\n                             'Tzolkin: %tzolkin13%, %tzolkin20%, %tzolkin20name%;<br/>'.\n                             'Haab: %haabkin%, %haabwinal%, %haabwinalname%;<br/>'.\n                             'Misc: %longkin%, %julianday%.<br/><br/>'.\n                             'Example: template \"%baktun%.%katun%.%tun%.%winal%.%kin%, %tzolkin13% %tzolkin20name%, %haabkin% %haabwinalname%\" for 22.05.2009 will return 12.19.16.6.11, 8 CHUEN, 9 SIP.<br/>'.\n                             'Default template: %baktun%.%katun%.%tun%.%winal%.%kin% %tzolkin13% %tzolkin20name% %haabkin% %haabwinalname%" => "You must use the variable substitution.<br/>'.\n                             'LongCount: %baktun%, %katun%, %tun%, %winal%, %kin%;<br/>'.\n                             'Tzolkin: %tzolkin13%, %tzolkin20%, %tzolkin20name%;<br/>'.\n                             'Haab: %haabkin%, %haabwinal%, %haabwinalname%;<br/>'.\n                             'Misc: %longkin%, %julianday%.<br/><br/>'.\n                             'Example: template \"%baktun%.%katun%.%tun%.%winal%.%kin%, %tzolkin13% %tzolkin20name%, %haabkin% %haabwinalname%\" for 22.05.2009 will return 12.19.16.6.11, 8 CHUEN, 9 SIP.<br/>'.\n                             'Default template: %baktun%.%katun%.%tun%.%winal%.%kin% %tzolkin13% %tzolkin20name% %haabkin% %haabwinalname%",
// "Gregorian date" => "Gregorian date",
// "Gregorian date for convert. Format: DD.MM.YYYY. Default: Today date" => "Gregorian date for convert. Format: DD.MM.YYYY. Default: Today date",
// "Mayan Calendars" => "Mayan Calendars",
// " is not a valid date format. should be dd.mm.yyyy" => " is not a valid date format. should be dd.mm.yyyy",
// "Inline Flash mp3 and flv Player" => "Inline Flash mp3 and flv Player",
// "Mediaplayer" => "Mediaplayer",
// "MP3 URL" => "MP3 URL",
// "Complete URL to the mp3 to include" => "Complete URL to the mp3 to include",
// "FLV URL" => "FLV URL",
// "Complete URL to the flv to include" => "Complete URL to the flv to include",
// "Style" => "Style",
// "One of" => "One of",
// "Member List" => "Member List",
// "Lists the members of selected groups and allows to add or remove members if permissions are granted" => "Lists the members of selected groups and allows to add or remove members if permissions are granted",
// "List of groups to handle through the interface. Colon separated" => "List of groups to handle through the interface. Colon separated",
// "Mini Quiz" => "Mini Quiz",
// "Displays a miniquiz" => "Displays a miniquiz",
// "Instructions::Feedback" => "Instructions::Feedback",
// "Tracker ID" => "Tracker ID",
// "Insert Module" => "Insert Module",
// "Module name as known in Tikiwiki" => "Module name as known in Tikiwiki",
// "Decoration" => "Decoration",
// "Max" => "Max",
// "np" => "np",
// "notitle" => "notitle",
// "Displays a module inline in a wiki page. More parameters can be added, not supported by UI" => "Displays a module inline in a wiki page. More parameters can be added, not supported by UI",
// "Monospace" => "Monospace",
// "Font name as known in browsers" => "Font name as known in browsers",
// "Create a mouseover feature on some text" => "Create a mouseover feature on some text",
// "Mouseover text if param label exists. Page text if text param exists" => "Mouseover text if param label exists. Page text if text param exists",
// "Text displayed on the page. The body is the mouseover content" => "Text displayed on the page. The body is the mouseover content",
// "Destination link when mouseover text is clicked. Use http:// for external links" => "Destination link when mouseover text is clicked. Use http:// for external links",
// "DEPRECATED" => "DEPRECATED",
// "Text displayed on the mouseover. The body contains the text of the page" => "Text displayed on the mouseover. The body contains the text of the page",
// "Mouseover box width. Default: 400px" => "Mouseover box width. Default: 400px",
// "Mouseover box height. Default: 200px" => "Mouseover box height. Default: 200px",
// "Offset X" => "Offset X",
// "Shifts the overlay to the right by the specified number of pixels relative to the cursor. Default: 5px" => "Shifts the overlay to the right by the specified number of pixels relative to the cursor. Default: 5px",
// "Offset Y" => "Offset Y",
// "Shifts the overlay lower by the specified number of pixels relative to the cursor. Default: 0px" => "Shifts the overlay lower by the specified number of pixels relative to the cursor. Default: 0px",
// "Parse Body" => "Parse Body",
// "y|n, parse the body of the plugin as wiki content. (Default to y)" => "y|n, parse the body of the plugin as wiki content. (Default to y)",
// "Background color of the popup" => "Background color of the popup",
// "'),\n\t\t\t\t'filter' => 'striptags" => "'),\n\t\t\t\t'filter' => 'striptags",
// "Text color in the popup" => "Text color in the popup",
// "Padding" => "Padding",
// "Effect" => "Effect",
// "Effect speed" => "Effect speed",
// "No label specified" => "No label specified",
// "MWTable" => "MWTable",
// "fancy" => "fancy",
// "true|false" => "true|false",
// "wiki_classes" => "wiki_classes",
// "Displays the data using (sort of) MediaWiki syntax" => "Displays the data using (sort of) MediaWiki syntax",
// "Displays a table using MediaWiki syntax" => "Displays a table using MediaWiki syntax",
// "MySpace" => "MySpace",
// "MySpace Page" => "MySpace Page",
// "Displays a MySpace Flash mp3 playlist in the wiki page" => "Displays a MySpace Flash mp3 playlist in the wiki page",
// "Object Hits" => "Object Hits",
// "Object ID" => "Object ID",
// "Object Type" => "Object Type",
// "Displays object hit info by object and days" => "Displays object hit info by object and days",
// "List pages part of a named list" => "List pages part of a named list",
// "Offset" => "Offset",
// "Pagination start element" => "Pagination start element",
// "list parameter missing or doesn\\'t exist" => "list parameter missing or doesn\\'t exist",
// "%" => "%",
// "% of page hits" => "% of page hits",
// "Page Hits" => "Page Hits",
// "Picture" => "Picture",
// "Search for images uploaded by users" => "Search for images uploaded by users",
// " (deprecated - scheduled to be removed or changed significantly)" => " (deprecated - scheduled to be removed or changed significantly)",
// "Filename or full path to file" => "Filename or full path to file",
// "Plugin Manager" => "Plugin Manager",
// "Information" => "Information",
// "Multiple values separated with | can be used" => "Multiple values separated with | can be used",
// "Displays a list of plugins available in this wiki" => "Displays a list of plugins available in this wiki",
// "No arguments indicated" => "No arguments indicated",
// "Poll ID" => "Poll ID",
// "Displays the output of a poll, fields are indicated with numeric ids" => "Displays the output of a poll, fields are indicated with numeric ids",
// "missing poll ID for plugin POLL" => "missing poll ID for plugin POLL",
// "Profile Installer" => "Profile Installer",
// "Adds controls required to install a profile" => "Adds controls required to install a profile",
// "Domain" => "Domain",
// "Profile repository domain. Default value is profiles.tikiwiki.org" => "Profile repository domain. Default value is profiles.tikiwiki.org",
// "Profile Name" => "Profile Name",
// "Name of the profile" => "Name of the profile",
// "Profile plugin only available to administrators" => "Profile plugin only available to administrators",
// "Profile %0/%1 not found" => "Profile %0/%1 not found",
// "Proposal" => "Proposal",
// "Provides a widget for users to vote on a proposal and view the current decision" => "Provides a widget for users to vote on a proposal and view the current decision",
// "The list of votes cast. One vote per line. Either 0, +1 or -1 followed by a username" => "The list of votes cast. One vote per line. Either 0, +1 or -1 followed by a username",
// "Accept proposal" => "Accept proposal",
// "Still undecided" => "Still undecided",
// "Reject proposal" => "Reject proposal",
// "Displays a proposal acceptance widget" => "Displays a proposal acceptance widget",
// "Short description of the proposal to vote on. Will be displayed above the result table" => "Short description of the proposal to vote on. Will be displayed above the result table",
// "Quote" => "Quote",
// "Quoted text" => "Quoted text",
// "Reply to" => "Reply to",
// "Name of the quoted person" => "Name of the quoted person",
// "wrote" => "wrote",
// "Quote text by surrounding the text with a box, like the [QUOTE] BBCode" => "Quote text by surrounding the text with a box, like the [QUOTE] BBCode",
// "Random Dynamic Content" => "Random Dynamic Content",
// "Includes random content from the dynamic content system" => "Includes random content from the dynamic content system",
// "User List (showing Real Name)" => "User List (showing Real Name)",
// " (experimental, should be merged with UserList in Tiki5)" => " (experimental, should be merged with UserList in Tiki5)",
// "Login Filter" => "Login Filter",
// "String to use between elements of the list" => "String to use between elements of the list",
// "Maximum" => "Maximum",
// "Result limit" => "Result limit",
// "Layout" => "Layout",
// "Exclude" => "Exclude",
// "Displays a list of users showing their real name" => "Displays a list of users showing their real name",
// "Displays a list of registered users showing their Real Names" => "Displays a list of registered users showing their Real Names",
// "Redirect" => "Redirect",
// "Redirect the user to a wiki page or generic URL" => "Redirect the user to a wiki page or generic URL",
// "Wiki page name to redirect to" => "Wiki page name to redirect to",
// "Complete URL, internal or external" => "Complete URL, internal or external",
// "Redirects you to another wiki page" => "Redirects you to another wiki page",
// "Regular Expression" => "Regular Expression",
// "Takes regex expressions and parses the content between REGEX tags and replaces the text" => "Takes regex expressions and parses the content between REGEX tags and replaces the text",
// "one data per line" => "one data per line",
// "Page name containing the regular expression" => "Page name containing the regular expression",
// "Takes regex expressions and parses the content between the REGEX tags and replaces the text" => "Takes regex expressions and parses the content between the REGEX tags and replaces the text",
// "Displays a comment, tip, note or warning box" => "Displays a comment, tip, note or warning box",
// "remarks text" => "remarks text",
// "Remarks Box" => "Remarks Box",
// "Label displayed above the remark" => "Label displayed above the remark",
// "Highlight" => "Highlight",
// "Icon" => "Icon",
// "Icon ID" => "Icon ID",
// "y|n Show close button (default y)" => "y|n Show close button (default y)",
// "Width (e.g. 100% or 250px - default \"\")" => "Width (e.g. 100% or 250px - default \"\")",
// "RSS Feed" => "RSS Feed",
// "Inserts an RSS feed output" => "Inserts an RSS feed output",
// "IDs" => "IDs",
// "List of feed IDs separated by colons. ex: feedId:feedId2" => "List of feed IDs separated by colons. ex: feedId:feedId2",
// "Number of results displayed" => "Number of results displayed",
// "You need to specify a RSS Id" => "You need to specify a RSS Id",
// "RSS Id incorrect" => "RSS Id incorrect",
// "~np~{~/np~RSS(id=>feedId:feedId2,max=>3,date=>1,desc=>1,author=>1)}{RSS} Insert rss feed output into a wikipage" => "~np~{~/np~RSS(id=>feedId:feedId2,max=>3,date=>1,desc=>1,author=>1)}{RSS} Insert rss feed output into a wikipage",
// "Screencast" => "Screencast",
// "Display a screencast uploaded on the page" => "Display a screencast uploaded on the page",
// "Label to use as a replacement to the default text" => "Label to use as a replacement to the default text",
// "ID as provided automatically during the upload" => "ID as provided automatically during the upload",
// "Insert Screencast" => "Insert Screencast",
// "Screencast ID wasn't specified or doesn't exist" => "Screencast ID wasn't specified or doesn't exist",
// "Watch a video of these instructions" => "Watch a video of these instructions",
// "SourceForge" => "SourceForge",
// "aid?" => "aid?",
// "adit?" => "adit?",
// "groupid?" => "groupid?",
// "Automatically creates a link to the appropriate SourceForge object" => "Automatically creates a link to the appropriate SourceForge object",
// "Insert a ShareThis button from www.sharethis.com" => "Insert a ShareThis button from www.sharethis.com",
// "sharethis" => "sharethis",
// "Display a social networking tool" => "Display a social networking tool",
// "Send services" => "Send services",
// "By default, email, aim and sms are available. Input one or two of the services separated by a | to limit the choice of send services" => "By default, email, aim and sms are available. Input one or two of the services separated by a | to limit the choice of send services",
// "First post services shown" => "First post services shown",
// "Input a list of post services (like facebook, myspace, digg, etc.) separated by a | to customize the services that are shown in the opening panel of the widget" => "Input a list of post services (like facebook, myspace, digg, etc.) separated by a | to customize the services that are shown in the opening panel of the widget",
// "Rotate image" => "Rotate image",
// "A value of y will cause the button icon to rotate every 3 seconds between a few icons, cycling through twice before stopping" => "A value of y will cause the button icon to rotate every 3 seconds between a few icons, cycling through twice before stopping",
// "Button text" => "Button text",
// "Custom link text for the button" => "Custom link text for the button",
// "Header title" => "Header title",
// "Optional header title text for the widget" => "Optional header title text for the widget",
// "Header background" => "Header background",
// "HTML color code (not color name) for the background color for the header if an optional header title is used" => "HTML color code (not color name) for the background color for the header if an optional header title is used",
// "Header text color" => "Header text color",
// "HTML color code (not color name) for the header text if an optional header title is used" => "HTML color code (not color name) for the header text if an optional header title is used",
// "Link text color for services" => "Link text color for services",
// "HTML color code (not color name) for the link text for all send and post services shown in the widget" => "HTML color code (not color name) for the link text for all send and post services shown in the widget",
// "Pop-up" => "Pop-up",
// "A value of true will cause the widget to show in a pop-up window" => "A value of true will cause the widget to show in a pop-up window",
// "Embedded elements" => "Embedded elements",
// "A value of true will allow embedded elements (like flash) to be seen while iframe is loading" => "A value of true will allow embedded elements (like flash) to be seen while iframe is loading",
// "Sheet" => "Sheet",
// "Displays the content of a spreadsheet in the page" => "Displays the content of a spreadsheet in the page",
// "Sheet Heading" => "Sheet Heading",
// "Internal ID of the TikiSheet" => "Internal ID of the TikiSheet",
// "New sheet in page: " => "New sheet in page: ",
// "Incomplete call to plugin: No target sheet" => "Incomplete call to plugin: No target sheet",
// "Create new sheet" => "Create new sheet",
// "TikiSheet" => "TikiSheet",
// "Edit Sheet" => "Edit Sheet",
// "Show Pages" => "Show Pages",
// "Search criteria" => "Search criteria",
// "Maximum amount of results displayed" => "Maximum amount of results displayed",
// "Display" => "Display",
// "name|desc" => "name|desc",
// "Last modified by" => "Last modified by",
// "Skype" => "Skype",
// "Clickable Skype link" => "Clickable Skype link",
// "Name or number to call or chat with" => "Name or number to call or chat with",
// "Snarf" => "Snarf",
// "Include the content of a remote HTTP page. Regular expression selecting the content portion to include must be specified" => "Include the content of a remote HTTP page. Regular expression selecting the content portion to include must be specified",
// "Full URL to the page to include" => "Full URL to the page to include",
// "PCRE compliant regular expression" => "PCRE compliant regular expression",
// "Regular Expression Part" => "Regular Expression Part",
// "ex: \$1" => "ex: \$1",
// "The SNARF plugin replaces itself with the HTML body of a URL.  Arbitrary regex replacement can be done on this content using regex and regexres, the latter being used as the second argument to preg_replace" => "The SNARF plugin replaces itself with the HTML body of a URL.  Arbitrary regex replacement can be done on this content using regex and regexres, the latter being used as the second argument to preg_replace",
// "This data is put in a CODE caption" => "This data is put in a CODE caption",
// "Missing url parameter for SNARF plugin" => "Missing url parameter for SNARF plugin",
// "Data to sort, one entry per line" => "Data to sort, one entry per line",
// "asc|desc|shuffle" => "asc|desc|shuffle",
// "Split a page into rows and columns" => "Split a page into rows and columns",
// "Join Columns" => "Join Columns",
// "Generate the colspan attribute if columns are missing" => "Generate the colspan attribute if columns are missing",
// "Fixed Size" => "Fixed Size",
// "Generate the width attribute on the columns" => "Generate the width attribute on the columns",
// "Column Size" => "Column Size",
// "Editable" => "Editable",
// "Display edit icon for each section" => "Display edit icon for each section",
// "Custom class" => "Custom class",
// "add a class to customize the design" => "add a class to customize the design",
// "row1col1" => "row1col1",
// "row1col2" => "row1col2",
// "row2col1" => "row2col1",
// "row2col2" => "row2col2",
// "SQL" => "SQL",
// "Run a sql query" => "Run a sql query",
// "sql query" => "sql query",
// "DNS Name" => "DNS Name",
// "ADODB DNS" => "ADODB DNS",
// "Stat" => "Stat",
// "Displays some stats" => "Displays some stats",
// "separated by " => "separated by ",
// "Parent Id" => "Parent Id",
// "Added last hour" => "Added last hour",
// "Added last 24 hours" => "Added last 24 hours",
// "Added since the beginning of the day" => "Added since the beginning of the day",
// "Added(a) or viewed(v) since the beginning of the day" => "Added(a) or viewed(v) since the beginning of the day",
// "Added last 7 days" => "Added last 7 days",
// "Added(a) or viewed(v) last 7 days" => "Added(a) or viewed(v) last 7 days",
// "Added since the beginning of the week" => "Added since the beginning of the week",
// "Added(a) or viewed(v) since the beginning of the week" => "Added(a) or viewed(v) since the beginning of the week",
// "Added last month" => "Added last month",
// "Added(a) or viewed(v) last month" => "Added(a) or viewed(v) last month",
// "Added since the beginning of the month" => "Added since the beginning of the month",
// "Added(a) or viewed(v) since the beginning of the month" => "Added(a) or viewed(v) since the beginning of the month",
// "Added last year" => "Added last year",
// "Added(a) or viewed(v) last year" => "Added(a) or viewed(v) last year",
// "Added since the beginning of the year" => "Added since the beginning of the year",
// "Added(a) or viewed(v) since the beginning of the year" => "Added(a) or viewed(v) since the beginning of the year",
// "Subscript" => "Subscript",
// "Displays text in subscript" => "Displays text in subscript",
// "Subscribe or unsubscribe to a group" => "Subscribe or unsubscribe to a group",
// "Subscribe Group" => "Subscribe Group",
// "Group Name" => "Group Name",
// "As known in Tikiwiki" => "As known in Tikiwiki",
// "Subscribe Text" => "Subscribe Text",
// "Subscribe text, containing %s as the placeholder for the group name" => "Subscribe text, containing %s as the placeholder for the group name",
// "Unsubscribe Text" => "Unsubscribe Text",
// "Unsubscribe text, containing %s as the placeholder for the group name" => "Unsubscribe text, containing %s as the placeholder for the group name",
// "Subscribe Action" => "Subscribe Action",
// "Subscribe button label, containing %s as the placeholder for the group name" => "Subscribe button label, containing %s as the placeholder for the group name",
// "Unsubscribe Action" => "Unsubscribe Action",
// "Unsubscribe button label, containing %s as the placeholder for the group name" => "Unsubscribe button label, containing %s as the placeholder for the group name",
// "Subscribe Groups" => "Subscribe Groups",
// "Show subscribe box" => "Show subscribe box",
// "Show default setting and buttons" => "Show default setting and buttons",
// "Show group description" => "Show group description",
// "Colon separated list of groups" => "Colon separated list of groups",
// "After changing default" => "After changing default",
// "Superscript" => "Superscript",
// "Displays text in superscript (exponent)" => "Displays text in superscript (exponent)",
// "Displays text in superscript" => "Displays text in superscript",
// "Wiki Page to redirect the user after his vote" => "Wiki Page to redirect the user after his vote",
// "Displays a survey" => "Displays a survey",
// "Tabs" => "Tabs",
// "Provides tabs built using the smarty tabset block" => "Provides tabs built using the smarty tabset block",
// "Tabs content separated by /////" => "Tabs content separated by /////",
// "Tabset name" => "Tabset name",
// "Unique tabset name (if you want it to remember its last state). Ex: user_profile_tabs" => "Unique tabset name (if you want it to remember its last state). Ex: user_profile_tabs",
// "Tab titles" => "Tab titles",
// "Pipe separated list of tab titles. Ex: tab 1|tab 2|tab 3" => "Pipe separated list of tab titles. Ex: tab 1|tab 2|tab 3",
// "Displays a set of tabs" => "Displays a set of tabs",
// "No tab title specified. At least one has to be set to make the tabs appear" => "No tab title specified. At least one has to be set to make the tabs appear",
// "Tag" => "Tag",
// "Displays the text between an html tag" => "Displays the text between an html tag",
// "Any valid HTML tag, span by default" => "Any valid HTML tag, span by default",
// "Equivalent to the style attribute of an HTML tag" => "Equivalent to the style attribute of an HTML tag",
// "Displays text between HTML tags" => "Displays text between HTML tags",
// "Displays the thumbnail for an image" => "Displays the thumbnail for an image",
// "File ID from the file gallery" => "File ID from the file gallery",
// "Image ID from the image gallery" => "Image ID from the image gallery",
// "URL to the image" => "URL to the image",
// "Maximum Size" => "Maximum Size",
// "Maximum width or height for the image" => "Maximum width or height for the image",
// "Floating" => "Floating",
// "Link target of the image" => "Link target of the image",
// "No image specified" => "No image specified",
// "Title Search" => "Title Search",
// "Search wiki page titles" => "Search wiki page titles",
// "Search Criteria" => "Search Criteria",
// "Portion of a page name" => "Portion of a page name",
// "hits|user" => "hits|user",
// "Pipe-separated list of page names to exclude from results" => "Pipe-separated list of page names to exclude from results",
// "Search the titles of all pages in this wiki" => "Search the titles of all pages in this wiki",
// "No pages found for title search" => "No pages found for title search",
// "One page found for title search" => "One page found for title search",
// "pages found for title search" => "pages found for title search",
// "Table of Contents (Structure)" => "Table of Contents (Structure)",
// "Displays the table of contents for the current structure\\'s subtree as part of the page content" => "Displays the table of contents for the current structure\\'s subtree as part of the page content",
// "Maximum Depth" => "Maximum Depth",
// "Maximum number of levels to display. On very large structures, this should be limited" => "Maximum number of levels to display. On very large structures, this should be limited",
// "Structure ID" => "Structure ID",
// "By default, structure for the current page will be displayed. Alternate structure may be provided" => "By default, structure for the current page will be displayed. Alternate structure may be provided",
// "asc|desc" => "asc|desc",
// "Show Description" => "Show Description",
// "0|1, show the page description instead of the page name" => "0|1, show the page description instead of the page name",
// "Show Numbering" => "Show Numbering",
// "0|1, display the section numbers or not" => "0|1, display the section numbers or not",
// "plain|fancy" => "plain|fancy",
// "Top Friends" => "Top Friends",
// "List top-scoring users" => "List top-scoring users",
// "Maximum result count" => "Maximum result count",
// "Public" => "Public",
// "Translate a string using Tikiwiki translation table" => "Translate a string using Tikiwiki translation table",
// "string" => "string",
// "Translate a string" => "Translate a string",
// "Colon-separated list of field IDs to be displayed. Example: 2:4:5" => "Colon-separated list of field IDs to be displayed. Example: 2:4:5",
// "Label on the submit button" => "Label on the submit button",
// "Show Title" => "Show Title",
// "Show Mandatory" => "Show Mandatory",
// "Embedded" => "Embedded",
// "URL used for the field links" => "URL used for the field links",
// "Url target" => "Url target",
// "Values" => "Values",
// "Colon-separated list of values" => "Colon-separated list of values",
// "Note that plugin arguments can be enclosed with double quotes \"; this allows them to contain , or " => "Note that plugin arguments can be enclosed with double quotes \"; this allows them to contain , or ",
// "Reset" => "Reset",
// "Label for the reset button, to return all fields to their default values" => "Label for the reset button, to return all fields to their default values",
// "View" => "View",
// "user|page" => "user|page",
// "itemId" => "itemId",
// "itemId if you want to edit an item" => "itemId if you want to edit an item",
// "Template File" => "Template File",
// "Name of the template used to display the tracker items" => "Name of the template used to display the tracker items",
// "Name of the wiki page containing the template to display the tracker items" => "Name of the wiki page containing the template to display the tracker items",
// "New Status" => "New Status",
// "Default status applied to newly created items" => "Default status applied to newly created items",
// "Width of first column " => "Width of first column ",
// "Specify the width in pixels or percentage of the first column in the tracker form" => "Specify the width in pixels or percentage of the first column in the tracker form",
// "Incorrect fieldId" => "Incorrect fieldId",
// "Following fields are incorrect" => "Following fields are incorrect",
// "Displays an input form for tracker submit" => "Displays an input form for tracker submit",
// "You do not have permission to insert an item" => "You do not have permission to insert an item",
// "You do not have permission to modify an item" => "You do not have permission to modify an item",
// "Fields marked with a * are mandatory" => "Fields marked with a * are mandatory",
// "Display List" => "Display List",
// "Tracker Filter" => "Tracker Filter",
// "notice" => "notice",
// "tracker field type not processed yet" => "tracker field type not processed yet",
// "Filters the items of a tracker, fields are indicated with numeric ids" => "Filters the items of a tracker, fields are indicated with numeric ids",
// "Wiki text" => "Wiki text",
// "Tracker Item Field" => "Tracker Item Field",
// "Wiki text containing an {ELSE} marker" => "Wiki text containing an {ELSE} marker",
// "Item ID" => "Item ID",
// "Field ID" => "Field ID",
// "Colon separated list of field IDs" => "Colon separated list of field IDs",
// "o|p|c|op|oc|pc|opc" => "o|p|c|op|oc|pc|opc",
// "Test" => "Test",
// "Value to compare against" => "Value to compare against",
// "Displays the value of a tracker item field or the wiki text if the value of the field is set or has a value(if itemId not specified, use the itemId of the url or the user tracker)" => "Displays the value of a tracker item field or the wiki text if the value of the field is set or has a value(if itemId not specified, use the itemId of the url or the user tracker)",
// "Tracker List" => "Tracker List",
// "Displays the output of a tracker content, fields are indicated with numeric ids" => "Displays the output of a tracker content, fields are indicated with numeric ids",
// "Notice" => "Notice",
// "Colon-separated list of fields to display on click. Example: 6:7" => "Colon-separated list of fields to display on click. Example: 6:7",
// "Sticky Popup" => "Sticky Popup",
// "Show Links" => "Show Links",
// "shownbitems" => "shownbitems",
// "Show Initials" => "Show Initials",
// "Show Status" => "Show Status",
// "Show Creation Date" => "Show Creation Date",
// "Show Last Modification" => "Show Last Modification",
// "Show Field Name" => "Show Field Name",
// "Show Item Rank" => "Show Item Rank",
// "Status Filter" => "Status Filter",
// "Which item status to list. o = open, p = pending, c = closed" => "Which item status to list. o = open, p = pending, c = closed",
// "Sort Mode" => "Sort Mode",
// "Maximum number of items" => "Maximum number of items",
// "Show pagination" => "Show pagination",
// "Filter Field" => "Filter Field",
// "Colon separated list of fields to allow filtering on" => "Colon separated list of fields to allow filtering on",
// "Filter Value" => "Filter Value",
// "Exact Value" => "Exact Value",
// "Checkbox" => "Checkbox",
// "goIfOne" => "goIfOne",
// "More" => "More",
// "More URL" => "More URL",
// "More Url" => "More Url",
// "Select automatically the item of the current user or the page" => "Select automatically the item of the current user or the page",
// "View User" => "View User",
// "Item ID separated with " => "Item ID separated with ",
// "List of items Ids" => "List of items Ids",
// "link url" => "link url",
// "Left Deliminator" => "Left Deliminator",
// "Right Deliminator" => "Right Deliminator",
// "If y, value will be truncated" => "If y, value will be truncated",
// "Export Button" => "Export Button",
// "Compute" => "Compute",
// "Sum or average all the values of a field  and displays it at the bottom of the table" => "Sum or average all the values of a field  and displays it at the bottom of the table",
// "fieldId" => "fieldId",
// "Show nothing if no items" => "Show nothing if no items",
// "Delete" => "Delete",
// "incorrect filterfield" => "incorrect filterfield",
// "Error in tracker ID" => "Error in tracker ID",
// "No field indicated" => "No field indicated",
// "Displays a button to link to a page with a tracker plugin with prefilled tracker fields" => "Displays a button to link to a page with a tracker plugin with prefilled tracker fields",
// "Tracker Prefill" => "Tracker Prefill",
// "Tracker page name" => "Tracker page name",
// "Button label" => "Button label",
// "Field 1" => "Field 1",
// "Value 1" => "Value 1",
// "Content of the field" => "Content of the field",
// "Field 2" => "Field 2",
// "Value 2" => "Value 2",
// "Field 3" => "Field 3",
// "Value 3" => "Value 3",
// "Field 4" => "Field 4",
// "Value 4" => "Value 4",
// "Field 5" => "Field 5",
// "Value 5" => "Value 5",
// "Tracker Stats" => "Tracker Stats",
// "Show link to tiki-view_tracker" => "Show link to tiki-view_tracker",
// "Displays some stat of a tracker content, fields are indicated with numeric ids" => "Displays some stat of a tracker content, fields are indicated with numeric ids",
// "incorrect fieldId" => "incorrect fieldId",
// "Tracker Timeline" => "Tracker Timeline",
// "Timeline view of a tracker, can be used to display event schedules or gantt charts" => "Timeline view of a tracker, can be used to display event schedules or gantt charts",
// "Title Field" => "Title Field",
// "Tracker Field ID containing the item title" => "Tracker Field ID containing the item title",
// "Summary Field" => "Summary Field",
// "Tracker Field ID containing the summary of the item. The summary will be displayed on the timeline when the item is focused" => "Tracker Field ID containing the summary of the item. The summary will be displayed on the timeline when the item is focused",
// "Start Date" => "Start Date",
// "Tracker Field ID containing the element start date. The field must be a datetime/jscalendar field" => "Tracker Field ID containing the element start date. The field must be a datetime/jscalendar field",
// "End Date" => "End Date",
// "Tracker Field ID containing the element end date. The field must be a datetime/jscalendar field" => "Tracker Field ID containing the element end date. The field must be a datetime/jscalendar field",
// "Element Group" => "Element Group",
// "Tracker Field ID containing the element\\'s group. Elements of a same group are displayed on the same row" => "Tracker Field ID containing the element\\'s group. Elements of a same group are displayed on the same row",
// "Lower Bound" => "Lower Bound",
// "Date from which element should be displayed. Date must be provided in YYYY-MM-DD HH:mm:ss format" => "Date from which element should be displayed. Date must be provided in YYYY-MM-DD HH:mm:ss format",
// "Upper Bound" => "Upper Bound",
// "Date until which element should be displayed. Date must be provided in YYYY-MM-DD HH:mm:ss format" => "Date until which element should be displayed. Date must be provided in YYYY-MM-DD HH:mm:ss format",
// "Primary Scale Unit" => "Primary Scale Unit",
// "hour, day, week, month or year (default to hour)" => "hour, day, week, month or year (default to hour)",
// "Secondary Scale Unit" => "Secondary Scale Unit",
// "hour, day, week, month, year or empty (default to empty)" => "hour, day, week, month, year or empty (default to empty)",
// "Link Group Name" => "Link Group Name",
// "Convert the group name to a link. (y|n)" => "Convert the group name to a link. (y|n)",
// "Page Link Field" => "Page Link Field",
// "Tracker Field ID containing the page name for item details" => "Tracker Field ID containing the page name for item details",
// "Missing parameter: %0" => "Missing parameter: %0",
// "Start date after end date" => "Start date after end date",
// "Translated" => "Translated",
// "Links to a translated content" => "Links to a translated content",
// "[url] or ((wikiname)) or ((inter:interwiki)) (use wiki syntax)" => "[url] or ((wikiname)) or ((inter:interwiki)) (use wiki syntax)",
// "Two letter language code of the language, ex: fr" => "Two letter language code of the language, ex: fr",
// "Country name, ex: France" => "Country name, ex: France",
// "User Count" => "User Count",
// "Displays the number of registered users" => "Displays the number of registered users",
// "Group name" => "Group name",
// "User List" => "User List",
// "Displays a list of registered users" => "Displays a list of registered users",
// "Display the user\\'s real name instead of login name" => "Display the user\\'s real name instead of login name",
// "Userpref" => "Userpref",
// "Display wiki text if user has a pref set to a value" => "Display wiki text if user has a pref set to a value",
// "Split the text in parts visible only under some conditions" => "Split the text in parts visible only under some conditions",
// "Block of text separated by ---(version x)--- markers. Text before the first marker is used by default" => "Block of text separated by ---(version x)--- markers. Text before the first marker is used by default",
// "Navigation" => "Navigation",
// "Displays a navigation box that allows users to select a specific version to display" => "Displays a navigation box that allows users to select a specific version to display",
// "Display the current version name as the title. Note: Do not work when nav=>y" => "Display the current version name as the title. Note: Do not work when nav=>y",
// "Specifies version label to show when displaying the page for the first time. e.g. \\'Default\\'" => "Specifies version label to show when displaying the page for the first time. e.g. \\'Default\\'",
// "This is the default text" => "This is the default text",
// "(version 3)" => "(version 3)",
// "This is version 3 info" => "This is version 3 info",
// "(version 2)" => "(version 2)",
// "This is version 2 info" => "This is version 2 info",
// "(version 1)" => "(version 1)",
// "This is version 1 info" => "This is version 1 info",
// "Show Stats" => "Show Stats",
// "Show Stats After" => "Show Stats After",
// "Show Creator" => "Show Creator",
// "Wanted Pages" => "Wanted Pages",
// "Custom level regex. A custom filter for wanted pages to be listed (only used when level=>custom).\n\t\tpossible values: a valid regex-expression (PCRE)" => "Custom level regex. A custom filter for wanted pages to be listed (only used when level=>custom).\n\t\tpossible values: a valid regex-expression (PCRE)",
// "Ignore" => "Ignore",
// "Split By" => "Split By",
// "Skip Extension" => "Skip Extension",
// "Collect" => "Collect",
// "Table" => "Table",
// "Level" => "Level",
// "Lists ''wanted'' Wiki pages: " => "Lists ''wanted'' Wiki pages: ",
// "Page-Pattern" => "Page-Pattern",
// "Custom-Level-Regex" => "Custom-Level-Regex",
// "^Parameters: key=>value,...\n" => "^Parameters: key=>value,...\n",
// "__key__ | __default__ | __comments__\n" => "__key__ | __default__ | __comments__\n",
// "empty string" => "empty string",
// "A wildcard pattern of originating pages to be ignored" => "A wildcard pattern of originating pages to be ignored",
// "(refer to PHP function fnmatch() for details)\n" => "(refer to PHP function fnmatch() for details)\n",
// "The character, by which ignored patterns are separated" => "The character, by which ignored patterns are separated",
// "possible values: characters\n" => "possible values: characters\n",
// "Whether to include external wikis in the list" => "Whether to include external wikis in the list",
// "possible values: " => "possible values: ",
// "Collect either originating or wanted pages in a cell and display them in the second column" => "Collect either originating or wanted pages in a cell and display them in the second column",
// "Switch-on debug output with details about the items" => "Switch-on debug output with details about the items",
// "Multiple collected items are separated in distinct table rows, or by comma or line break in one cell" => "Multiple collected items are separated in distinct table rows, or by comma or line break in one cell",
// "Filter the list of wanted pages according to page_regex or custom filter. The default value is the site's __current__ page_regex" => "Filter the list of wanted pages according to page_regex or custom filter. The default value is the site's __current__ page_regex",
// "A custom filter for wanted pages to be listed (only used when level=>custom)" => "A custom filter for wanted pages to be listed (only used when level=>custom)",
// "a valid regex-expression (PCRE)" => "a valid regex-expression (PCRE)",
// "Lists ''wanted'' wiki pages" => "Lists ''wanted'' wiki pages",
// "A wildcard pattern of originating pages to be ignored. (refer to PHP fuction fnmatch() for details)" => "A wildcard pattern of originating pages to be ignored. (refer to PHP fuction fnmatch() for details)",
// "The character, by which ignored patterns are separated. possible values: characters" => "The character, by which ignored patterns are separated. possible values: characters",
// "Whether to include external wikis in the list. possible values" => "Whether to include external wikis in the list. possible values",
// "Collect either originating or wanted pages in a cell and display them in the second column. possible values" => "Collect either originating or wanted pages in a cell and display them in the second column. possible values",
// "Switch-on debug output with details about the items. possible values" => "Switch-on debug output with details about the items. possible values",
// "Multiple collected items are separated in distinct table rows, or by comma or line break in one cell. possible values" => "Multiple collected items are separated in distinct table rows, or by comma or line break in one cell. possible values",
// "non-valid custom regex" => "non-valid custom regex",
// ", " => ", ",
// "ignored" => "ignored",
// "External Wiki" => "External Wiki",
// "dash-WikiWord" => "dash-WikiWord",
// "WikiWord" => "WikiWord",
// "not in level" => "not in level",
// "End of debug output" => "End of debug output",
// "Wanted Page" => "Wanted Page",
// "Referenced By Page" => "Referenced By Page",
// "Web Service" => "Web Service",
// "Obtains and display remote information exposed in JSON or YAML. The plugin can be used to display registered or unregistered services. Registered services may use more parameters not defined in this interface" => "Obtains and display remote information exposed in JSON or YAML. The plugin can be used to display registered or unregistered services. Registered services may use more parameters not defined in this interface",
// "Template to apply to the data provided. Template format uses smarty templating engine using double brackets as delimiter. Output must provide wiki syntax. Body can be sent to a parameter instead by using the bodyname parameter" => "Template to apply to the data provided. Template format uses smarty templating engine using double brackets as delimiter. Output must provide wiki syntax. Body can be sent to a parameter instead by using the bodyname parameter",
// "Complete service URL" => "Complete service URL",
// "Service Name" => "Service Name",
// "Registered service name" => "Registered service name",
// "Template Name" => "Template Name",
// "For use with registered services, name of the template to be used to display the service output. This parameter will be ignored if a body is provided" => "For use with registered services, name of the template to be used to display the service output. This parameter will be ignored if a body is provided",
// "Body as Parameter" => "Body as Parameter",
// "Name of the argument to send the body as for services with complex input. Named service required for this to be useful" => "Name of the argument to send the body as for services with complex input. Named service required for this to be useful",
// "Unknown Template" => "Unknown Template",
// "Unknown Service" => "Unknown Service",
// "Missing parameters" => "Missing parameters",
// "Youtube" => "Youtube",
// "Display youtube video in a wiki page" => "Display youtube video in a wiki page",
// "URL to the Youtube video" => "URL to the Youtube video",
// "width" => "width",
// "height" => "height",
// "quality" => "quality",
// "Missing parameter movie to the youtube plugin" => "Missing parameter movie to the youtube plugin",
// "Cannot create aliased page" => "Cannot create aliased page",
// "You attempted to create the following page" => "You attempted to create the following page",
// "That page is an alias for the following pages" => "That page is an alias for the following pages",
// "If you want to create the page, you must first edit each the pages above, and remove the alias link it may contain. This link should look something like this" => "If you want to create the page, you must first edit each the pages above, and remove the alias link it may contain. This link should look something like this",
// "Can't parse HTML data - no grammar file" => "Can't parse HTML data - no grammar file",
// "Removed version \$version" => "Removed version \$version",
// "rollback version " => "rollback version ",
// "Changed actual version to \$version" => "Changed actual version to \$version",
// "Plugin " => "Plugin ",
// "Semantic token already exists" => "Semantic token already exists",
// "Invalid semantic token name" => "Invalid semantic token name",
// "Semantic token not found" => "Semantic token not found",
// "Page locked" => "Page locked",
// "Page unlocked" => "Page unlocked",
// "Removed last version" => "Removed last version",
// "User %s does not have the permission" => "User %s does not have the permission",
// "The message has been sent to" => "The message has been sent to",
// "The message will be sent to" => "The message will be sent to",
// "User %s does not want to receive messages" => "User %s does not want to receive messages",
// "Sent box is full. Archive or delete some sent messages first if you want to send more messages" => "Sent box is full. Archive or delete some sent messages first if you want to send more messages",
// "You have to be able to receive messages in order to send them. Goto your user preferences and enable 'Allow messages from other users'" => "You have to be able to receive messages in order to send them. Goto your user preferences and enable 'Allow messages from other users'",
// "User %s can not receive messages, mailbox is full" => "User %s can not receive messages, mailbox is full",
// "User %s can not receive messages" => "User %s can not receive messages",
// "Invalid user: %s" => "Invalid user: %s",
// "Archive is full. Delete some messages from archive first" => "Archive is full. Delete some messages from archive first",
// "Displays a calendar of system events, such as wiki page modifications, forum posts and article publications. Days with events show links to the action calendar page" => "Displays a calendar of system events, such as wiki page modifications, forum posts and article publications. Days with events show links to the action calendar page",
// "Item types filter" => "Item types filter",
// "If set to a list of item types, restricts the items displayed to those of one of these types. Each set is a comma-separated list of item type codes" => "If set to a list of item types, restricts the items displayed to those of one of these types. Each set is a comma-separated list of item type codes",
// "Possible item type values" => "Possible item type values",
// "Google AdSense" => "Google AdSense",
// "Displays a text/image Google AdSense advertisement. This module should be updated to support new Google code" => "Displays a text/image Google AdSense advertisement. This module should be updated to support new Google code",
// "Advertisement channel, as optionally provided by Google" => "Advertisement channel, as optionally provided by Google",
// "As provided by Google. Format: \"pub-xxxxxxxxxxxxxxxx\"" => "As provided by Google. Format: \"pub-xxxxxxxxxxxxxxxx\"",
// "Global banner format as provided by Google. For example: \"display=468*60_as\"" => "Global banner format as provided by Google. For example: \"display=468*60_as\"",
// "Background color, as optionally provided by Google" => "Background color, as optionally provided by Google",
// "Border color, as optionally provided by Google" => "Border color, as optionally provided by Google",
// "Link color, as optionally provided by Google" => "Link color, as optionally provided by Google",
// "Text color, as optionally provided by Google" => "Text color, as optionally provided by Google",
// "URL color, as optionally provided by Google" => "URL color, as optionally provided by Google",
// "Article archives" => "Article archives",
// "Shows links to the published articles for each month" => "Shows links to the published articles for each month",
// "If set to \"y\", displays a button labelled \"More...\" that links to a paginated view of the selected articles" => "If set to \"y\", displays a button labelled \"More...\" that links to a paginated view of the selected articles",
// "Default: \"n\"" => "Default: \"n\"",
// "Category filter" => "Category filter",
// "If set to a category identifier, only consider the articles in the specified category" => "If set to a category identifier, only consider the articles in the specified category",
// "Example value: 13" => "Example value: 13",
// "Not set by default" => "Not set by default",
// "Topic filter (by names)" => "Topic filter (by names)",
// "If set to a list of article topic names separated by plus signs, only consider the articles in the specified article topics. If the string is preceded by an exclamation mark (\"!\"), the effect is reversed, i.e. articles in the specified article topics are not considered" => "If set to a list of article topic names separated by plus signs, only consider the articles in the specified article topics. If the string is preceded by an exclamation mark (\"!\"), the effect is reversed, i.e. articles in the specified article topics are not considered",
// "Example values" => "Example values",
// "Topic filter (by identifiers)" => "Topic filter (by identifiers)",
// "If set to a list of article topic identifiers separated by plus signs, only consider the articles in the specified article topics. If the string is preceded by an exclamation mark (\"!\"), the effect is reversed, i.e. articles in the specified article topics are not considered" => "If set to a list of article topic identifiers separated by plus signs, only consider the articles in the specified article topics. If the string is preceded by an exclamation mark (\"!\"), the effect is reversed, i.e. articles in the specified article topics are not considered",
// "Example values: 13, !13, 1+3, !1+5+7" => "Example values: 13, !13, 1+3, !1+5+7",
// "Types filter" => "Types filter",
// "If set to a list of article type names separated by plus signs, only consider the articles of the specified types. If the string is preceded by an exclamation mark (\"!\"), the effect is reversed, i.e. articles of the specified article types are not considered" => "If set to a list of article type names separated by plus signs, only consider the articles of the specified types. If the string is preceded by an exclamation mark (\"!\"), the effect is reversed, i.e. articles of the specified article types are not considered",
// "Example values: Event, !Event, Event+Review, !Event+Classified+Article" => "Example values: Event, !Event, Event+Review, !Event+Classified+Article",
// "Language filter" => "Language filter",
// "If set to a language code, only consider the articles in the specified language" => "If set to a language code, only consider the articles in the specified language",
// "Article Topics" => "Article Topics",
// "Lists all article topics with links to their articles" => "Lists all article topics with links to their articles",
// "Lists the specified number of published articles in the specified order" => "Lists the specified number of published articles in the specified order",
// "Show publication time" => "Show publication time",
// "If set to \"y\", article publication times are shown" => "If set to \"y\", article publication times are shown",
// "Show creation time" => "Show creation time",
// "If set to \"y\", article creation times are shown" => "If set to \"y\", article creation times are shown",
// "Show rating selector" => "Show rating selector",
// "If set to \"y\", offers the user to filter articles based on a minimum and a maximum rating" => "If set to \"y\", offers the user to filter articles based on a minimum and a maximum rating",
// "If set, displays an image for each article if one applies, with the given width (in pixels). The article\\'s own image is used, with a fallback to the article\\'s topic image" => "If set, displays an image for each article if one applies, with the given width (in pixels). The article\\'s own image is used, with a fallback to the article\\'s topic image",
// "If set to a category identifier, only lists the articles in the specified category" => "If set to a category identifier, only lists the articles in the specified category",
// "If set to a list of article topic names separated by plus signs, only lists the articles in the specified article topics. If the string is preceded by an exclamation mark (\"!\"), the effect is reversed, i.e. articles in the specified article topics are not listed" => "If set to a list of article topic names separated by plus signs, only lists the articles in the specified article topics. If the string is preceded by an exclamation mark (\"!\"), the effect is reversed, i.e. articles in the specified article topics are not listed",
// "If set to a list of article topic identifiers separated by plus signs, only lists the articles in the specified article topics. If the string is preceded by an exclamation mark (\"!\"), the effect is reversed, i.e. articles in the specified article topics are not listed" => "If set to a list of article topic identifiers separated by plus signs, only lists the articles in the specified article topics. If the string is preceded by an exclamation mark (\"!\"), the effect is reversed, i.e. articles in the specified article topics are not listed",
// "If set to a list of article type names separated by plus signs, only lists the articles of the specified types. If the string is preceded by an exclamation mark (\"!\"), the effect is reversed, i.e. articles of the specified article types are not listed" => "If set to a list of article type names separated by plus signs, only lists the articles of the specified types. If the string is preceded by an exclamation mark (\"!\"), the effect is reversed, i.e. articles of the specified article types are not listed",
// "If set to a language code, only lists the articles in the specified language" => "If set to a language code, only lists the articles in the specified language",
// "Specifies how the articles should be sorted" => "Specifies how the articles should be sorted",
// "Possible values include created and created_asc (equivalent), created_desc, author, rating, topicId, lang and title. Unless \"_desc\" is specified, the sort is ascending. \"created\" sorts on article creation date" => "Possible values include created and created_asc (equivalent), created_desc, author, rating, topicId, lang and title. Unless \"_desc\" is specified, the sort is ascending. \"created\" sorts on article creation date",
// "If set to an integer, offsets the articles list by the given number. For example, if the module was otherwise set to list the 10 articles most recently published, setting the offset to 10 would make the module list the 11th to 20th articles in descending order of publication time instead" => "If set to an integer, offsets the articles list by the given number. For example, if the module was otherwise set to list the 10 articles most recently published, setting the offset to 10 would make the module list the 11th to 20th articles in descending order of publication time instead",
// "If set to \"y\", displays a button labelled \"More\" that links to a paginated view of the selected articles" => "If set to \"y\", displays a button labelled \"More\" that links to a paginated view of the selected articles",
// "Absolute URL" => "Absolute URL",
// "If set to \"y\", some of the links use an absolute URL instead of a relative one. This can avoid broken links if the module is to be sent in a newsletter, for example" => "If set to \"y\", some of the links use an absolute URL instead of a relative one. This can avoid broken links if the module is to be sent in a newsletter, for example",
// "TikiWiki assistant" => "TikiWiki assistant",
// "Displays an assistant to guide new Tiki admins" => "Displays an assistant to guide new Tiki admins",
// "Last blog post comments" => "Last blog post comments",
// "Displays the specified number of the blog post comments most recently added" => "Displays the specified number of the blog post comments most recently added",
// "More in tooltips" => "More in tooltips",
// "If set to \"y\", the post on which a comment is made is not displayed in the module box, but instead moved in the item\\'s tooltip" => "If set to \"y\", the post on which a comment is made is not displayed in the module box, but instead moved in the item\\'s tooltip",
// "No date" => "No date",
// "If set to \"y\", the date at which comments were posted is not displayed in the module box" => "If set to \"y\", the date at which comments were posted is not displayed in the module box",
// "Last visited pages" => "Last visited pages",
// "Displays the last Wiki pages visited by the user" => "Displays the last Wiki pages visited by the user",
// "Maximum length" => "Maximum length",
// "Maximum number of characters in page names allowed before truncating" => "Maximum number of characters in page names allowed before truncating",
// "Includes a calendar or a list of calendar events" => "Includes a calendar or a list of calendar events",
// "Displayed month (relative)" => "Displayed month (relative)",
// "Distance in month to the month to display. A distance of -1 would display the previous month. Setting this option implies a calendar view type with a month time span" => "Distance in month to the month to display. A distance of -1 would display the previous month. Setting this option implies a calendar view type with a month time span",
// "Displays links to categories as a tree" => "Displays links to categories as a tree",
// "Object type filter" => "Object type filter",
// "Object type filter to apply when accessing a linked category. Example values" => "Object type filter to apply when accessing a linked category. Example values",
// "Deep" => "Deep",
// "Show subcategories objects when accessing a linked category. Possible values: on (default), off" => "Show subcategories objects when accessing a linked category. Possible values: on (default), off",
// "PHP Layers menu style" => "PHP Layers menu style",
// "Sets the menu style if PHP Layers is enabled. Possible values: tree (default), vert, horiz, plain, phptree" => "Sets the menu style if PHP Layers is enabled. Possible values: tree (default), vert, horiz, plain, phptree",
// "Limits displayed categories to a subtree of categories starting with the category with the given ID. Example value: 11. Default: 0 (don\\'t limit display)" => "Limits displayed categories to a subtree of categories starting with the category with the given ID. Example value: 11. Default: 0 (don\\'t limit display)",
// "Category Transitions" => "Category Transitions",
// "Displays controls to trigger category transitions and change the page\\'s state according to predefined rules" => "Displays controls to trigger category transitions and change the page\\'s state according to predefined rules",
// "Change Category" => "Change Category",
// "Enables to categorize an object" => "Enables to categorize an object",
// "Category identifier" => "Category identifier",
// "Changes the root of the displayed categories from default \"TOP\" to the category with the given identifier" => "Changes the root of the displayed categories from default \"TOP\" to the category with the given identifier",
// "Note that the root category is not displayed" => "Note that the root category is not displayed",
// "Defaults to 0 (root)" => "Defaults to 0 (root)",
// "No top" => "No top",
// "In non-detailed view, disallow uncategorizing. Example value: 1" => "In non-detailed view, disallow uncategorizing. Example value: 1",
// "Display path" => "Display path",
// "Instead of category names, diplay their path in the category tree starting from the category root defined" => "Instead of category names, diplay their path in the category tree starting from the category root defined",
// "Example value: 1" => "Example value: 1",
// "Multiple categories" => "Multiple categories",
// "If set to \"n\", only allows categorizing in one category (from those displayed)" => "If set to \"n\", only allows categorizing in one category (from those displayed)",
// "Categorize" => "Categorize",
// "String to display on the button to submit new categories, when multiple categories is enabled. Default value: Categorize" => "String to display on the button to submit new categories, when multiple categories is enabled. Default value: Categorize",
// "Shy" => "Shy",
// "If set to \"y\", the module is not shown on pages which are not already categorized.' . \" \" . tra('Not set by default" => "If set to \"y\", the module is not shown on pages which are not already categorized.' . \" \" . tra('Not set by default",
// "Detailed" => "Detailed",
// "If set to \"y\", shows a list of categories in which the object is. If deletion is not disabled, it is done with the list" => "If set to \"y\", shows a list of categories in which the object is. If deletion is not disabled, it is done with the list",
// "If set to \"n\", the detailed list of categories will not offer to unassign a category" => "If set to \"n\", the detailed list of categories will not offer to unassign a category",
// "If set to \"y\", allow to assign new categories" => "If set to \"y\", allow to assign new categories",
// "Example values: y, n" => "Example values: y, n",
// "Default value: y" => "Default value: y",
// "Default value: n" => "Default value: n",
// "Image URL not in category" => "Image URL not in category",
// "Very particular parameter. If both this and \"Image URL in the category\" are set and the root category contains a single child category, the module only displays an image with this URL if the object is not in the category" => "Very particular parameter. If both this and \"Image URL in the category\" are set and the root category contains a single child category, the module only displays an image with this URL if the object is not in the category",
// "Example value" => "Example value",
// "Image URL in category" => "Image URL in category",
// "Very particular parameter. If both this and \"Image URL not in the category\" are set and the root category contains a single child category, the module only displays an image with this URL if the object is in the category" => "Very particular parameter. If both this and \"Image URL not in the category\" are set and the root category contains a single child category, the module only displays an image with this URL if the object is in the category",
// "Categorize %s" => "Categorize %s",
// "Categorize %s in %s" => "Categorize %s in %s",
// "Displays the number of pages received (via Communications)" => "Displays the number of pages received (via Communications)",
// "Last directory sites" => "Last directory sites",
// "Displays the specified number of the directory sites most recently added" => "Displays the specified number of the directory sites most recently added",
// "Directory category identifier" => "Directory category identifier",
// "If set to a directory category identifier, only displays the sites in the specified directory category" => "If set to a directory category identifier, only displays the sites in the specified directory category",
// "If set to \"y\", displays a button labelled \"More\" that links to the directory" => "If set to \"y\", displays a button labelled \"More\" that links to the directory",
// "Directory statistics" => "Directory statistics",
// "Displays statistics about the directory, including the number of sites validated and to validate, the number of categories, of searches and of visited links" => "Displays statistics about the directory, including the number of sites validated and to validate, the number of categories, of searches and of visited links",
// "Top directory sites" => "Top directory sites",
// "Displays the specified number of the directory sites from most visited to least visited" => "Displays the specified number of the directory sites from most visited to least visited",
// "Displays the site\\'s first featured links" => "Displays the site\\'s first featured links",
// "Displays links to file galleries" => "Displays links to file galleries",
// "Best rated topics" => "Best rated topics",
// "Displays the specified number of the forum topics with the best ratings" => "Displays the specified number of the forum topics with the best ratings",
// "Last forum posts" => "Last forum posts",
// "Displays the latest forum posts" => "Displays the latest forum posts",
// "If set to \"y\", only displays topics" => "If set to \"y\", only displays topics",
// "Displays the specified number of the forums with the most comments" => "Displays the specified number of the forums with the most comments",
// "Displays the specified number of the forum topics with the most reads" => "Displays the specified number of the forum topics with the most reads",
// "Displays the specified number of the forums with the most visits" => "Displays the specified number of the forums with the most visits",
// "Freetags editor" => "Freetags editor",
// "Shows current freetags and enables to add and remove some if permissions allow" => "Shows current freetags and enables to add and remove some if permissions allow",
// "Freetags Wiki" => "Freetags Wiki",
// "Displays current freetags on wiki pages and enables to add tags if permissions allow" => "Displays current freetags on wiki pages and enables to add tags if permissions allow",
// "Similar freetags" => "Similar freetags",
// "Shows wiki pages with similar freetags" => "Shows wiki pages with similar freetags",
// "Similar pages" => "Similar pages",
// "Most popular tags" => "Most popular tags",
// "Shows the most popular freetags. More popularity is indicated by a larger font" => "Shows the most popular freetags. More popularity is indicated by a larger font",
// "Display type" => "Display type",
// "If set to \"cloud\", links are displayed as a cloud" => "If set to \"cloud\", links are displayed as a cloud",
// "Default: \"list\"" => "Default: \"list\"",
// "Maximum elements" => "Maximum elements",
// "If set to a number, limits the number of tags displayed" => "If set to a number, limits the number of tags displayed",
// "User preferred tags" => "User preferred tags",
// "Displays to registered users the freetags they prefer, based on the number of objects they added the tag to. More preference is indicated by a larger font" => "Displays to registered users the freetags they prefer, based on the number of objects they added the tag to. More preference is indicated by a larger font",
// "My preferred tags" => "My preferred tags",
// "Displays a simple form to search on Google. By default, search results are limited to those on the Tiki site" => "Displays a simple form to search on Google. By default, search results are limited to those on the Tiki site",
// "Groups emulation" => "Groups emulation",
// "Enables temporarily changing one\\'s group memberships to see how users in fewer groups experience the site" => "Enables temporarily changing one\\'s group memberships to see how users in fewer groups experience the site",
// "Emulate Groups" => "Emulate Groups",
// "Last actions" => "Last actions",
// "Displays the specified number of last actions" => "Displays the specified number of last actions",
// "Show user" => "Show user",
// "If set to \"y\", user names are displayed in the module box" => "If set to \"y\", user names are displayed in the module box",
// "Show date" => "Show date",
// "If set to \"y\", action dates are displayed in the module box" => "If set to \"y\", action dates are displayed in the module box",
// "Maximum number of characters in action descriptions before truncating" => "Maximum number of characters in action descriptions before truncating",
// "Lists the specified number of blogs posts from newest to oldest" => "Lists the specified number of blogs posts from newest to oldest",
// "If set to \"y\", the date of posts is not displayed in the module box" => "If set to \"y\", the date of posts is not displayed in the module box",
// "Blog identifier" => "Blog identifier",
// "If set to a blog identifier, restricts the blog posts to those in the identified blog" => "If set to a blog identifier, restricts the blog posts to those in the identified blog",
// "Last category objects" => "Last category objects",
// "Lists the specified number of objects of the given type in the given category, starting from the most recently created" => "Lists the specified number of objects of the given type in the given category, starting from the most recently created",
// "Identifier of the category from which objects are listed. Objects merely in child categories will not be displayed" => "Identifier of the category from which objects are listed. Objects merely in child categories will not be displayed",
// "Maximum number of characters in object names allowed before truncating" => "Maximum number of characters in object names allowed before truncating",
// "Type of the objects to list. Example values" => "Type of the objects to list. Example values",
// "no object here yet" => "no object here yet",
// "Displays the specified number of blogs from newest to oldest" => "Displays the specified number of blogs from newest to oldest",
// "Displays the specified number of FAQs from newest to oldest" => "Displays the specified number of FAQs from newest to oldest",
// "Displays the specified number of quizzes from newest to oldest" => "Displays the specified number of quizzes from newest to oldest",
// "Displays the specified number of file galleries, starting from the most recently modified" => "Displays the specified number of file galleries, starting from the most recently modified",
// "List the specified number of files, starting from the most recently added" => "List the specified number of files, starting from the most recently added",
// "Gallery identifiers" => "Gallery identifiers",
// "If set to a set of file gallery identifiers, restricts the files to those in the identified galleries. The value is a colon-separated sequence of integers" => "If set to a set of file gallery identifiers, restricts the files to those in the identified galleries. The value is a colon-separated sequence of integers",
// "Example value: 13, 2:13, 1:2:3:5:6" => "Example value: 13, 2:13, 1:2:3:5:6",
// "Last modified image galleries" => "Last modified image galleries",
// "Displays the specified number of image galleries, starting from the most recently modified" => "Displays the specified number of image galleries, starting from the most recently modified",
// "Last Images" => "Last Images",
// "List the specified number of images, starting from the most recently added" => "List the specified number of images, starting from the most recently added",
// "Gallery identifier" => "Gallery identifier",
// "If set to an image gallery identifier, restricts the images to those in the identified gallery" => "If set to an image gallery identifier, restricts the images to those in the identified gallery",
// "Link content" => "Link content",
// "Display the links as image names or thumbnails" => "Display the links as image names or thumbnails",
// "Possible values: \"names\" or \"thumbnails\". Default value: \"names\"" => "Possible values: \"names\" or \"thumbnails\". Default value: \"names\"",
// "Last modified events" => "Last modified events",
// "Displays the specified number of calendar events, starting from the most recently modified" => "Displays the specified number of calendar events, starting from the most recently modified",
// "Calendar identifier" => "Calendar identifier",
// "If set to a calendar identifier, restricts the events to those in the identified calendar" => "If set to a calendar identifier, restricts the events to those in the identified calendar",
// "Maximum number of characters in event names allowed before truncating" => "Maximum number of characters in event names allowed before truncating",
// "Lists the specified number of pages, starting from the most recently modified" => "Lists the specified number of pages, starting from the most recently modified",
// "Link target" => "Link target",
// "Target URL of the \"...more\" link at the bottom of the module" => "Target URL of the \"...more\" link at the bottom of the module",
// "Displays the specified number of blogs, starting from the most recently modified" => "Displays the specified number of blogs, starting from the most recently modified",
// "Lists the specified number of article submissions from newest to oldest" => "Lists the specified number of article submissions from newest to oldest",
// "Last tracker comments" => "Last tracker comments",
// "Lists the specified number of tracker comments (optionally restricting to those in a specific tracker or tracker item) starting from the most recently posted" => "Lists the specified number of tracker comments (optionally restricting to those in a specific tracker or tracker item) starting from the most recently posted",
// "Tracker identifier" => "Tracker identifier",
// "If set to a tracker identifier, only displays the comments on the given tracker" => "If set to a tracker identifier, only displays the comments on the given tracker",
// "Item identifier" => "Item identifier",
// "If set to an item identifier, only displays the comments on the given item" => "If set to an item identifier, only displays the comments on the given item",
// "Last tracker items" => "Last tracker items",
// "Displays the value of a field of the specified number of tracker items. If the specified tracker has no main field, either Field name or Field identifier is required" => "Displays the value of a field of the specified number of tracker items. If the specified tracker has no main field, either Field name or Field identifier is required",
// "Identifier of the tracker from which items are listed" => "Identifier of the tracker from which items are listed",
// "Field identifier" => "Field identifier",
// "Identifier of the field from which values are listed. If Field name is set, this parameter is ignored" => "Identifier of the field from which values are listed. If Field name is set, this parameter is ignored",
// "Field name" => "Field name",
// "Name of the field from which values are listed" => "Name of the field from which values are listed",
// "Example value: age" => "Example value: age",
// "Specifies how the items should be sorted" => "Specifies how the items should be sorted",
// "Possible values include created and created_asc (equivalent), created_desc, status, lastModif, createdBy and lastModifBy. Unless \"_desc\" is specified, the sort is ascending. \"created\" sorts on item creation date. \"lastModif\" sorts on the last modification date of items. \"lastModif_desc\" sorts in descending order of last modification date" => "Possible values include created and created_asc (equivalent), created_desc, status, lastModif, createdBy and lastModifBy. Unless \"_desc\" is specified, the sort is ascending. \"created\" sorts on item creation date. \"lastModif\" sorts on the last modification date of items. \"lastModif_desc\" sorts in descending order of last modification date",
// "Status filter" => "Status filter",
// "If set, limits the listed items to those with the given statuses. Values are combinations of \"o\" (open), \"p\" (pending) and \"c\" (closed). Possible values" => "If set, limits the listed items to those with the given statuses. Values are combinations of \"o\" (open), \"p\" (pending) and \"c\" (closed). Possible values",
// "Unable to determine which field to show. Tracker identifier may be invalid, or the tracker has no main field and neither Field identifier nor Field name were set" => "Unable to determine which field to show. Tracker identifier may be invalid, or the tracker has no main field and neither Field identifier nor Field name were set",
// "You do not have permission to view this tracker" => "You do not have permission to view this tracker",
// "Last Validated FAQs Questions" => "Last Validated FAQs Questions",
// "Displays the specified number of validated questions FAQs from newest to oldest" => "Displays the specified number of validated questions FAQs from newest to oldest",
// "Faq identifier" => "Faq identifier",
// "If set to a faq identifier, restricts the chosen questions to those in the identified faq" => "If set to a faq identifier, restricts the chosen questions to those in the identified faq",
// "Number of characters to display" => "Number of characters to display",
// "Last Visitors" => "Last Visitors",
// "Displays information about the specified number of users in decreasing order of last login time" => "Displays information about the specified number of users in decreasing order of last login time",
// "Show avatars" => "Show avatars",
// "If set to \"y\", show user avatars" => "If set to \"y\", show user avatars",
// "Maximum number of characters in user names allowed before truncating" => "Maximum number of characters in user names allowed before truncating",
// "Tells users whether a live support operator is present and allows them to request support if possible. If the user is an operator, links to the operator console" => "Tells users whether a live support operator is present and allows them to request support if possible. If the user is an operator, links to the operator console",
// "Login box" => "Login box",
// "Input size" => "Input size",
// "Number of characters for username and password input fields" => "Number of characters for username and password input fields",
// "Logo" => "Logo",
// "Site logo, title and subtitle" => "Site logo, title and subtitle",
// "Menu page" => "Menu page",
// "Displays a Wiki page" => "Displays a Wiki page",
// "Page to display in the menu. Example value: HomePage" => "Page to display in the menu. Example value: HomePage",
// "Unread inter-user messages" => "Unread inter-user messages",
// "Displays to users their number of new inter-user messages and a link to their message box" => "Displays to users their number of new inter-user messages and a link to their message box",
// "Small live chat box" => "Small live chat box",
// "Channels" => "Channels",
// "List of chat channels. Channel names are separated by a comma (\",\")" => "List of chat channels. Channel names are separated by a comma (\",\")",
// "By default, a single channel named \"default\" exists" => "By default, a single channel named \"default\" exists",
// "Months links" => "Months links",
// "Links to the objects of a given type for the current month and those preceding it" => "Links to the objects of a given type for the current month and those preceding it",
// "Type of objects to link to" => "Type of objects to link to",
// "\"blogs\" for blog posts, \"cms\" for published articles" => "\"blogs\" for blog posts, \"cms\" for published articles",
// "Object identifier" => "Object identifier",
// "Identifier of an object with children to link to" => "Identifier of an object with children to link to",
// "This is required for the blog Object type" => "This is required for the blog Object type",
// "For example, an identifier of 3 and a blogs Object type will show links to the blog posts in the blog with identifier 3" => "For example, an identifier of 3 and a blogs Object type will show links to the blog posts in the blog with identifier 3",
// "List by month" => "List by month",
// "Displays the number of article submissions waiting examination and a link to the list" => "Displays the number of article submissions waiting examination and a link to the list",
// "Displays the specified number of old articles (which do not show on articles home page anymore)" => "Displays the specified number of old articles (which do not show on articles home page anymore)",
// "Enables to change current perspective" => "Enables to change current perspective",
// "Quick Edit" => "Quick Edit",
// "Enables to quickly create or edit Wiki pages" => "Enables to quickly create or edit Wiki pages",
// "Template identifier" => "Template identifier",
// "If set to a template identifier, the specified template is used for creating new Wiki pages" => "If set to a template identifier, the specified template is used for creating new Wiki pages",
// "If set, send the form to the given location (relative to Tiki\\'s root) for processing" => "If set, send the form to the given location (relative to Tiki\\'s root) for processing",
// "SUBMIT label" => "SUBMIT label",
// "The label on the button to submit the form" => "The label on the button to submit the form",
// "Size attribute (horizontal, in characters) of the text input field for page names" => "Size attribute (horizontal, in characters) of the text input field for page names",
// "Optional heading to display at the top of the module\\'s content" => "Optional heading to display at the top of the module\\'s content",
// "If set to a category identifier, pages created through the module are automatically categorized in the specified category" => "If set to a category identifier, pages created through the module are automatically categorized in the specified category",
// "Random image" => "Random image",
// "Displays a random image" => "Displays a random image",
// "If set to an image gallery identifier, restricts the chosen images to those in the identified gallery" => "If set to an image gallery identifier, restricts the chosen images to those in the identified gallery",
// "Show link" => "Show link",
// "If set to \"n\", the image thumbnail does not link to the image" => "If set to \"n\", the image thumbnail does not link to the image",
// "Default: \"y\"" => "Default: \"y\"",
// "Show name" => "Show name",
// "If set to \"y\", the name of the image is displayed" => "If set to \"y\", the name of the image is displayed",
// "If set to \"y\", the description of the image is displayed" => "If set to \"y\", the description of the image is displayed",
// "Displays the specified number of random wiki pages" => "Displays the specified number of random wiki pages",
// "New user registrationmore tiki-re" => "New user registrationmore tiki-re",
// "Feeds List" => "Feeds List",
// "List of feeds available on this site" => "List of feeds available on this site",
// "Search Box" => "Search Box",
// "Advanced search (for wiki, articles, blogs etc)" => "Advanced search (for wiki, articles, blogs etc)",
// "Search Box (new)" => "Search Box (new)",
// "Search Wiki Page" => "Search Wiki Page",
// "Search for a wiki page by name" => "Search for a wiki page by name",
// "Search Wiki Page (new)" => "Search Wiki Page (new)",
// "Lists the relationships known for the Wiki page displayed. For each relation type contained in the page, it lists all the pages it links to or gets linked from" => "Lists the relationships known for the Wiki page displayed. For each relation type contained in the page, it lists all the pages it links to or gets linked from",
// "The shoutbox is a quick messaging tool. Messages reload each time the page changes. Anyone with the right permission can see all messages. Another permission allows to send messages" => "The shoutbox is a quick messaging tool. Messages reload each time the page changes. Anyone with the right permission can see all messages. Another permission allows to send messages",
// "Tooltip" => "Tooltip",
// "If set to \"1\", displays message post dates and times as tooltips instead of showing directly in the module content" => "If set to \"1\", displays message post dates and times as tooltips instead of showing directly in the module content",
// "Label on the button to post a message" => "Label on the button to post a message",
// "Wait label" => "Wait label",
// "Label on the button to post a message when the message is being posted if AJAX is enabled" => "Label on the button to post a message when the message is being posted if AJAX is enabled",
// "Maximum messages shown" => "Maximum messages shown",
// "Number of messages to display" => "Number of messages to display",
// "Please wait.." => "Please wait..",
// "Since last visit (simple)" => "Since last visit (simple)",
// "Displays to logged in users the number of new or updated objects since their last login date and time" => "Displays to logged in users the number of new or updated objects since their last login date and time",
// "Since last visit" => "Since last visit",
// "Displays to logged in users new or updated objects since a point in time, by default their last login date and time" => "Displays to logged in users new or updated objects since a point in time, by default their last login date and time",
// "Show users" => "Show users",
// "If set to \"n\", do not show new users" => "If set to \"n\", do not show new users",
// "Show trackers" => "Show trackers",
// "If set to \"n\", do not show tracker changes" => "If set to \"n\", do not show tracker changes",
// "Calendar focus" => "Calendar focus",
// "Unless set to \"ignore\", the module changes the reference point in time from the user\\'s last login date and time to a day where users browse to using the calendar" => "Unless set to \"ignore\", the module changes the reference point in time from the user\\'s last login date and time to a day where users browse to using the calendar",
// "Changes since" => "Changes since",
// "Since your last visit.." => "Since your last visit..",
// "new posts" => "new posts",
// "new articles" => "new articles",
// "new FAQs" => "new FAQs",
// "new blogs" => "new blogs",
// "new blog posts" => "new blog posts",
// "new image galleries" => "new image galleries",
// "new file galleries" => "new file galleries",
// "new polls" => "new polls",
// "new tracker items" => "new tracker items",
// "updated tracker items" => "updated tracker items",
// "Switch Language" => "Switch Language",
// "Displays a language picker to change the language of the site" => "Displays a language picker to change the language of the site",
// "Display mode" => "Display mode",
// "Changes how the list of languages is displayed. Possible values are droplist, flags and words. Defaults to droplist" => "Changes how the list of languages is displayed. Possible values are droplist, flags and words. Defaults to droplist",
// "Prefix" => "Prefix",
// "Changes the default displayed prefix from \\\"Site Language:\\\"" => "Changes the default displayed prefix from \\\"Site Language:\\\"",
// "Switch theme" => "Switch theme",
// "Enables to quickly change the theme" => "Enables to quickly change the theme",
// "Terminology" => "Terminology",
// "Support for multilingual terminology" => "Support for multilingual terminology",
// "Tiki Tests" => "Tiki Tests",
// "Tiki test suite helper" => "Tiki test suite helper",
// "Displays the specified number of blogs with links to them, from the most active one to the least" => "Displays the specified number of blogs with links to them, from the most active one to the least",
// "Blog activity measurement can be more or less accurate" => "Blog activity measurement can be more or less accurate",
// "Lists the specified number of articles with links to them, from the most visited one to the least" => "Lists the specified number of articles with links to them, from the most visited one to the least",
// "Displays the specified number of file galleries with links to them, starting with the one with most hits" => "Displays the specified number of file galleries with links to them, starting with the one with most hits",
// "Top files" => "Top files",
// "Displays the specified number of files with links to them, starting with the one with most hits" => "Displays the specified number of files with links to them, starting with the one with most hits",
// "Top Forum Posters" => "Top Forum Posters",
// "Displays the specified number of users who posted to forums, starting with the one having most posts" => "Displays the specified number of users who posted to forums, starting with the one having most posts",
// "Top image galleries" => "Top image galleries",
// "Displays the specified number of image galleries with links to them, starting with the one with most hits" => "Displays the specified number of image galleries with links to them, starting with the one with most hits",
// "Displays the specified number of images with links to them, from the most visited one to the least" => "Displays the specified number of images with links to them, from the most visited one to the least",
// "Top Objects" => "Top Objects",
// "Displays the specified number of objects, starting with the one having the most hits" => "Displays the specified number of objects, starting with the one having the most hits",
// "Displays the specified number of wiki pages with links to them, starting with the one having the most hits" => "Displays the specified number of wiki pages with links to them, starting with the one having the most hits",
// "Displays the specified number of quizzes with links to them, starting with the one having the most hits" => "Displays the specified number of quizzes with links to them, starting with the one having the most hits",
// "Displays the specified number of blogs with links to them, from the most visited one to the least" => "Displays the specified number of blogs with links to them, from the most visited one to the least",
// "Displays the specified number of FAQs with links to them, from the most visited one to the least" => "Displays the specified number of FAQs with links to them, from the most visited one to the least",
// "Page translation" => "Page translation",
// "Links to versions of the wiki page being viewed in other languages, distinguishing between better, equivalent or worse translations. Optionally displays the up-to-dateness of the translation being viewed" => "Links to versions of the wiki page being viewed in other languages, distinguishing between better, equivalent or worse translations. Optionally displays the up-to-dateness of the translation being viewed",
// "Reference language" => "Reference language",
// "If set to a language code, restricts the localized pages shown to the reference page, unless that page is being displayed" => "If set to a language code, restricts the localized pages shown to the reference page, unless that page is being displayed",
// "Lists the specified number of calendar events, ordered by their start date" => "Lists the specified number of calendar events, ordered by their start date",
// "Calendars filter" => "Calendars filter",
// "If set to a list of calendar identifiers, restricts the events to those in the identified calendars. Identifiers are separated by vertical bars (\"|\"), commas (\",\") or colons (\":\")" => "If set to a list of calendar identifiers, restricts the events to those in the identified calendars. Identifiers are separated by vertical bars (\"|\"), commas (\",\") or colons (\":\")",
// "Maximum days in the future" => "Maximum days in the future",
// "Maximum distance to event start dates in days (looking forward)" => "Maximum distance to event start dates in days (looking forward)",
// "Maximum days in the past" => "Maximum days in the past",
// "Maximum distance to event end dates in days (looking backward)" => "Maximum distance to event end dates in days (looking backward)",
// "cellpadding" => "cellpadding",
// "cellspacing" => "cellspacing",
// "If set to \"y\", event descriptions are displayed" => "If set to \"y\", event descriptions are displayed",
// "Show end date and time" => "Show end date and time",
// "If set to \"y\", event end dates and times are displayed, when appropriate" => "If set to \"y\", event end dates and times are displayed, when appropriate",
// "Use custom calendar background colors" => "Use custom calendar background colors",
// "If set to \"y\", events are displayed with their calendar\\'s custom background color (if one is set)" => "If set to \"y\", events are displayed with their calendar\\'s custom background color (if one is set)",
// "Show information in tooltips" => "Show information in tooltips",
// "If set to \"n\", event tooltips will not display event information" => "If set to \"n\", event tooltips will not display event information",
// "Date format" => "Date format",
// "Format to use for most dates. See <a href=\"http://www.php.net/manual/en/function.strftime.php\">strftime() documentation</a>" => "Format to use for most dates. See <a href=\"http://www.php.net/manual/en/function.strftime.php\">strftime() documentation</a>",
// "site preference for short date format followed by site preference for short time format" => "site preference for short date format followed by site preference for short time format",
// "If set to an integer, event names are allowed that number of characters as a maximum before being truncated" => "If set to an integer, event names are allowed that number of characters as a maximum before being truncated",
// "Displays to registered users their blogs" => "Displays to registered users their blogs",
// "Lightweight interface to user bookmarks, enabling to view them concisely, do some manipulations and bookmark the page being viewed" => "Lightweight interface to user bookmarks, enabling to view them concisely, do some manipulations and bookmark the page being viewed",
// "User image galleries" => "User image galleries",
// "Displays to registered users their image galleries" => "Displays to registered users their image galleries",
// "Displays to registered users the specified number of wiki pages which they were the last to edit" => "Displays to registered users the specified number of wiki pages which they were the last to edit",
// "Lightweight interface to user tasks, enabling to view them concisely and do some manipulations" => "Lightweight interface to user tasks, enabling to view them concisely and do some manipulations",
// "The task title must have at least 3 characters" => "The task title must have at least 3 characters",
// "Public tasks" => "Public tasks",
// "Lists the public user tasks of a chosen group, with links to tasks" => "Lists the public user tasks of a chosen group, with links to tasks",
// "User-Group Tracker" => "User-Group Tracker",
// "User and Group tracker links" => "User and Group tracker links",
// "Top users" => "Top users",
// "Displays the specified number of users and their score, starting from the one with the highest score" => "Displays the specified number of users and their score, starting from the one with the highest score",
// "Webmail Inbox" => "Webmail Inbox",
// "Displays Webmail Inbox" => "Displays Webmail Inbox",
// "Account Id" => "Account Id",
// "Webmail account identifier (if not set uses user\\'s current account)" => "Webmail account identifier (if not set uses user\\'s current account)",
// "GroupMail: Group (e.g. \"Help Team\")" => "GroupMail: Group (e.g. \"Help Team\")",
// "GroupMail: Tracker Id (to store GroupMail activity)" => "GroupMail: Tracker Id (to store GroupMail activity)",
// "GroupMail: From Field (Id of field in tracker to store email From header)" => "GroupMail: From Field (Id of field in tracker to store email From header)",
// "Subject Field Id" => "Subject Field Id",
// "GroupMail: Subject Field (Id of field in tracker to store email Subject header)" => "GroupMail: Subject Field (Id of field in tracker to store email Subject header)",
// "Message Field Id" => "Message Field Id",
// "GroupMail: Message Field (Id of field in tracker to store email message identifier)" => "GroupMail: Message Field (Id of field in tracker to store email message identifier)",
// "Content Field Id" => "Content Field Id",
// "GroupMail: Content Field (Id of field in tracker to store email message body content)" => "GroupMail: Content Field (Id of field in tracker to store email message body content)",
// "Account Field Id" => "Account Field Id",
// "GroupMail: Account Field (Id of field in tracker to store Webmail account name)" => "GroupMail: Account Field (Id of field in tracker to store Webmail account name)",
// "DateTime Field Id" => "DateTime Field Id",
// "GroupMail: Date Time Field (Id of field in tracker to store email sent timestamp)" => "GroupMail: Date Time Field (Id of field in tracker to store email sent timestamp)",
// "Operator Field Id" => "Operator Field Id",
// "GroupMail: Operator Field (Id of field in tracker to store operator name (username))" => "GroupMail: Operator Field (Id of field in tracker to store operator name (username))",
// "Maximum number of characters in subjects allowed before truncating" => "Maximum number of characters in subjects allowed before truncating",
// "Webmail error" => "Webmail error",
// "No accounts set up (or no current account set)" => "No accounts set up (or no current account set)",
// "Wiki Page" => "Wiki Page",
// "What is related" => "What is related",
// "Lists objects which share a category with the viewed object" => "Lists objects which share a category with the viewed object",
// "Displays information about users currently logged in" => "Displays information about users currently logged in",
// "Content to display" => "Content to display",
// "Display the number of users logged in, the list of users logged in, or both" => "Display the number of users logged in, the list of users logged in, or both",
// "Possible values: \"count\", \"list\" or \"both\". Default value: \"both\"" => "Possible values: \"count\", \"list\" or \"both\". Default value: \"both\"",
// "Cluster mode" => "Cluster mode",
// "If set to \"1\", separate users based on which host/server they logged on" => "If set to \"1\", separate users based on which host/server they logged on",
// "Last comments" => "Last comments",
// "Lists the specified number of comments starting from the most recently posted" => "Lists the specified number of comments starting from the most recently posted",
// "If set to \"y\", the name of the object on which a comment is made is not displayed in the module box, but instead moved in the item\\'s tooltip" => "If set to \"y\", the name of the object on which a comment is made is not displayed in the module box, but instead moved in the item\\'s tooltip",
// "Type of the objects from which comments will be listed. Possible values" => "Type of the objects from which comments will be listed. Possible values",
// "Last article comments" => "Last article comments",
// "Last wiki comments" => "Last wiki comments",
// "YouTube" => "YouTube",
// "Displays YouTube videos and/or a link to a YouTube user\\'s page" => "Displays YouTube videos and/or a link to a YouTube user\\'s page",
// "Video identifiers" => "Video identifiers",
// "List of YouTube videos identifiers to display. Identifiers are separated by a comma (\",\")" => "List of YouTube videos identifiers to display. Identifiers are separated by a comma (\",\")",
// "YouTube user identifier" => "YouTube user identifier",
// "If set to a YouTube user identifier, display a link to the videos of this user" => "If set to a YouTube user identifier, display a link to the videos of this user",
// "Width of each video in pixels" => "Width of each video in pixels",
// "Height of each video in pixels" => "Height of each video in pixels",
// "Videos on YouTube" => "Videos on YouTube",
// "Invalid server key" => "Invalid server key",
// "Cookie not found" => "Cookie not found",
// "Can create/admin calendars" => "Can create/admin calendars",
// "Can add events in the calendar" => "Can add events in the calendar",
// "Can change events in the calendar" => "Can change events in the calendar",
// "Can browse the calendar" => "Can browse the calendar",
// "Can view events details" => "Can view events details",
// "Can view Tikiwiki tools calendar" => "Can view Tikiwiki tools calendar",
// "Administrator, can create channels remove channels etc" => "Administrator, can create channels remove channels etc",
// "Can use the chat system" => "Can use the chat system",
// "Can admin the cms" => "Can admin the cms",
// "Can approve submissions" => "Can approve submissions",
// "Can admin article topics" => "Can admin article topics",
// "Can admin article types" => "Can admin article types",
// "Can read article headings" => "Can read article headings",
// "Submited articles automatically approved" => "Submited articles automatically approved",
// "Can edit articles" => "Can edit articles",
// "Can edit submissions" => "Can edit submissions",
// "Can read articles" => "Can read articles",
// "Can remove articles" => "Can remove articles",
// "Can remove submissions" => "Can remove submissions",
// "Can submit articles" => "Can submit articles",
// "Can read a topic (Applies only to individual topic perms)" => "Can read a topic (Applies only to individual topic perms)",
// "Can admin contributions" => "Can admin contributions",
// "Can admin the directory" => "Can admin the directory",
// "Can admin directory categories" => "Can admin directory categories",
// "Can admin directory sites" => "Can admin directory sites",
// "Submited links are valid" => "Submited links are valid",
// "Can submit sites to the directory" => "Can submit sites to the directory",
// "Can validate submited links" => "Can validate submited links",
// "Can use the directory" => "Can use the directory",
// "Can admin faqs" => "Can admin faqs",
// "Can suggest faq questions" => "Can suggest faq questions",
// "Can view faqs" => "Can view faqs",
// "Administrator, can manage users groups and permissions, Hotwords and all the weblog features" => "Administrator, can manage users groups and permissions, Hotwords and all the weblog features",
// "Can admin users" => "Can admin users",
// "Can access site when closed" => "Can access site when closed",
// "Administrator, can admin banners" => "Administrator, can admin banners",
// "Can ban users or ips" => "Can ban users or ips",
// "Can admin the dynamic content system" => "Can admin the dynamic content system",
// "Can admin integrator repositories and rules" => "Can admin integrator repositories and rules",
// "Can admin mail-in accounts" => "Can admin mail-in accounts",
// "Can edit object permissions" => "Can edit object permissions",
// "Can admin external feeds" => "Can admin external feeds",
// "Can clean cache" => "Can clean cache",
// "Can create new css suffixed with -user" => "Can create new css suffixed with -user",
// "Can remove association between two pages in a translation set" => "Can remove association between two pages in a translation set",
// "Can admin cookies" => "Can admin cookies",
// "Can edit translations and create new languages" => "Can edit translations and create new languages",
// "Can edit menu" => "Can edit menu",
// "Can edit menu option" => "Can edit menu option",
// "Can edit site templates" => "Can edit site templates",
// "Can search" => "Can search",
// "Can report a link to the webmaster" => "Can report a link to the webmaster",
// "Can subscribe to groups" => "Can subscribe to groups",
// "Can send a link to a friend" => "Can send a link to a friend",
// "Can use HTML in pages" => "Can use HTML in pages",
// "Can view action log" => "Can view action log",
// "Can view action log for users of his own groups" => "Can view action log for users of his own groups",
// "Can view integrated repositories" => "Can view integrated repositories",
// "Can view referer stats" => "Can view referer stats",
// "Can view site stats" => "Can view site stats",
// "Can view site templates" => "Can view site templates",
// "Can admin blogs" => "Can admin blogs",
// "Can assign perms to blog" => "Can assign perms to blog",
// "Can post to a blog" => "Can post to a blog",
// "Can create a blog" => "Can create a blog",
// "Can read blogs" => "Can read blogs",
// "Can admin file galleries" => "Can admin file galleries",
// "Can assign perms to file gallery" => "Can assign perms to file gallery",
// "Can use Directory Batch Load" => "Can use Directory Batch Load",
// "Can upload zip files with files" => "Can upload zip files with files",
// "Can create file galleries" => "Can create file galleries",
// "Can download files" => "Can download files",
// "Can edit a gallery file" => "Can edit a gallery file",
// "Can list file galleries" => "Can list file galleries",
// "Can upload files" => "Can upload files",
// "Can view file galleries explorer" => "Can view file galleries explorer",
// "Can view file galleries path" => "Can view file galleries path",
// "Can view file galleries" => "Can view file galleries",
// "Can admin forums" => "Can admin forums",
// "Can attach to forum posts" => "Can attach to forum posts",
// "Auto approve forum posts" => "Auto approve forum posts",
// "Can edit own forum posts" => "Can edit own forum posts",
// "Can post in forums" => "Can post in forums",
// "Can start threads in forums" => "Can start threads in forums",
// "Can read forums" => "Can read forums",
// "Can report msgs to moderator" => "Can report msgs to moderator",
// "Can vote comments in forums" => "Can vote comments in forums",
// "Can admin freetags" => "Can admin freetags",
// "Can admin Image Galleries" => "Can admin Image Galleries",
// "Can assign perms to image gallery" => "Can assign perms to image gallery",
// "Can upload zip files with images" => "Can upload zip files with images",
// "Can create image galleries" => "Can create image galleries",
// "Can tag objects" => "Can tag objects",
// "Can list image galleries" => "Can list image galleries",
// "Can unassign tags from an object" => "Can unassign tags from an object",
// "Can upload images" => "Can upload images",
// "Can browse freetags" => "Can browse freetags",
// "Can view image galleries" => "Can view image galleries",
// "Can admin newsletters" => "Can admin newsletters",
// "Can subscribe many e-mails at once (requires tiki_p_subscribe email)" => "Can subscribe many e-mails at once (requires tiki_p_subscribe email)",
// "Can send newsletters" => "Can send newsletters",
// "Can subscribe any email to newsletters" => "Can subscribe any email to newsletters",
// "Can subscribe to newsletters" => "Can subscribe to newsletters",
// "Can list newsletters" => "Can list newsletters",
// "Can admin polls" => "Can admin polls",
// "Can view poll results" => "Can view poll results",
// "Can vote polls" => "Can vote polls",
// "Can view poll voters" => "Can view poll voters",
// "Can admin toolbars" => "Can admin toolbars",
// "Can admin quizzes" => "Can admin quizzes",
// "Can take quizzes" => "Can take quizzes",
// "Can view quiz stats" => "Can view quiz stats",
// "Can view user quiz results" => "Can view user quiz results",
// "Can admin sheet" => "Can admin sheet",
// "Can create and edit sheets" => "Can create and edit sheets",
// "Can view sheet" => "Can view sheet",
// "Can view sheet history" => "Can view sheet history",
// "Can admin shoutbox (Edit/remove msgs)" => "Can admin shoutbox (Edit/remove msgs)",
// "Can post messages in shoutbox" => "Can post messages in shoutbox",
// "Can view shoutbox" => "Can view shoutbox",
// "Can admin surveys" => "Can admin surveys",
// "Can take surveys" => "Can take surveys",
// "Can view survey stats" => "Can view survey stats",
// "Can admin trackers" => "Can admin trackers",
// "Can attach files to tracker items" => "Can attach files to tracker items",
// "Can insert comments for tracker items" => "Can insert comments for tracker items",
// "Can view tracker items comments" => "Can view tracker items comments",
// "Can create new items for trackers" => "Can create new items for trackers",
// "Can list trackers" => "Can list trackers",
// "Can change tracker items" => "Can change tracker items",
// "Can change tracker pending items" => "Can change tracker pending items",
// "Can change tracker closed items" => "Can change tracker closed items",
// "Can view rating result for tracker items" => "Can view rating result for tracker items",
// "Can vote a rating for tracker items" => "Can vote a rating for tracker items",
// "Can view trackers" => "Can view trackers",
// "Can view trackers closed items" => "Can view trackers closed items",
// "Can view trackers pending items" => "Can view trackers pending items",
// "Can watch tracker" => "Can watch tracker",
// "Can export tracker items" => "Can export tracker items",
// "Can admin the wiki" => "Can admin the wiki",
// "Can assign perms to wiki pages" => "Can assign perms to wiki pages",
// "Can edit pages" => "Can edit pages",
// "Can edit copyright notices" => "Can edit copyright notices",
// "Can edit dynamic variables" => "Can edit dynamic variables",
// "Can create and edit structures" => "Can create and edit structures",
// "Can export wiki pages using the export feature" => "Can export wiki pages using the export feature",
// "Can lock pages" => "Can lock pages",
// "Can save as minor edit" => "Can save as minor edit",
// "Can remove" => "Can remove",
// "Can rename pages" => "Can rename pages",
// "Can rollback pages" => "Can rollback pages",
// "Can upload pictures to wiki pages" => "Can upload pictures to wiki pages",
// "Can use the page as a tracker template" => "Can use the page as a tracker template",
// "Can view page/pages" => "Can view page/pages",
// "Can watch structure" => "Can watch structure",
// "Can admin attachments to wiki pages" => "Can admin attachments to wiki pages",
// "Can add and change ratings on wiki pages" => "Can add and change ratings on wiki pages",
// "Can attach files to wiki pages" => "Can attach files to wiki pages",
// "Can view wiki attachments and download" => "Can view wiki attachments and download",
// "Can view wiki comments" => "Can view wiki comments",
// "Can view wiki history" => "Can view wiki history",
// "Can view rating of wiki pages" => "Can view rating of wiki pages",
// "Can view source of wiki pages" => "Can view source of wiki pages",
// "Can participate to rating of wiki pages" => "Can participate to rating of wiki pages",
// "Can view similar wiki pages" => "Can view similar wiki pages",
// "Can admin received articles" => "Can admin received articles",
// "Can admin received pages" => "Can admin received pages",
// "Can send articles to other sites" => "Can send articles to other sites",
// "Can send articles to this site" => "Can send articles to this site",
// "Can send pages to this site" => "Can send pages to this site",
// "Can send pages to other sites" => "Can send pages to other sites",
// "Can admin the TikiTests" => "Can admin the TikiTests",
// "Can edit TikiTests" => "Can edit TikiTests",
// "Can replay the TikiTests" => "Can replay the TikiTests",
// "Can cache user bookmarks" => "Can cache user bookmarks",
// "Can configure modules" => "Can configure modules",
// "Can create user bookmarks" => "Can create user bookmarks",
// "Can use the mini event calendar" => "Can use the mini event calendar",
// "Can use the notepad" => "Can use the notepad",
// "Can admin public tasks" => "Can admin public tasks",
// "Can use tasks" => "Can use tasks",
// "Can receive tasks from other users" => "Can receive tasks from other users",
// "Can send tasks to other users" => "Can send tasks to other users",
// "Can upload personal files" => "Can upload personal files",
// "Can create items in personal menu" => "Can create items in personal menu",
// "Can broadcast messages to all user" => "Can broadcast messages to all user",
// "Can broadcast messages to groups" => "Can broadcast messages to groups",
// "Can use the messaging system" => "Can use the messaging system",
// "Can admin comments" => "Can admin comments",
// "Can edit all comments" => "Can edit all comments",
// "Can post new comments" => "Can post new comments",
// "Can read comments" => "Can read comments",
// "Can delete comments" => "Can delete comments",
// "Can vote comments" => "Can vote comments",
// "Can admin content templates" => "Can admin content templates",
// "Can edit content templates" => "Can edit content templates",
// "Can use content templates" => "Can use content templates",
// "Can edit HTML pages" => "Can edit HTML pages",
// "Can view HTML pages" => "Can view HTML pages",
// "Can list registered users" => "Can list registered users",
// "Admin live support system" => "Admin live support system",
// "Can use live support system" => "Can use live support system",
// "Can create new mapfile" => "Can create new mapfile",
// "Can delete mapfiles" => "Can delete mapfiles",
// "Can edit mapfiles" => "Can edit mapfiles",
// "Can view mapfiles" => "Can view mapfiles",
// "Can view contents of mapfiles" => "Can view contents of mapfiles",
// "Can use webmail" => "Can use webmail",
// "Can use group webmail" => "Can use group webmail",
// "Can administrate group webmail accounts" => "Can administrate group webmail accounts",
// "Can use personal webmail accounts" => "Can use personal webmail accounts",
// "Can administrate personal webmail accounts" => "Can administrate personal webmail accounts",
// "Can view unapproved plugin details" => "Can view unapproved plugin details",
// "Can execute unapproved plugin" => "Can execute unapproved plugin",
// "Can approve plugin execution" => "Can approve plugin execution",
// "Trust all user inputs (no security checks)" => "Trust all user inputs (no security checks)",
// "View page backlinks" => "View page backlinks",
// "Can admin mail notifications" => "Can admin mail notifications",
// "Can invite user in groups" => "Can invite user in groups",
// "Can delete his own account" => "Can delete his own account",
// "Can use the Tiki Importer" => "Can use the Tiki Importer",
// "Can admin categories" => "Can admin categories",
// "Can see the category in a listing" => "Can see the category in a listing",
// "Can change the categories on the object" => "Can change the categories on the object",
// "Can add objects in the category" => "Can add objects in the category",
// "Can remove objects from the category" => "Can remove objects from the category",
// "Can create new categories" => "Can create new categories",
// "Can view the perspective" => "Can view the perspective",
// "Can view the group" => "Can view the group",
// "Can view the group members" => "Can view the group members",
// "Can add group members" => "Can add group members",
// "Can remove group members" => "Can remove group members",
// "Can join or leave the group" => "Can join or leave the group",
// "Can trigger the transition between two states" => "Can trigger the transition between two states",
// "Can admin kaltura feature" => "Can admin kaltura feature",
// "Can upload video on kaltura server" => "Can upload video on kaltura server",
// "Can edit information of kaltura entry" => "Can edit information of kaltura entry",
// "Can create kaltura remix video" => "Can create kaltura remix video",
// "Can delete kaltura entry" => "Can delete kaltura entry",
// "Can download kaltura entry" => "Can download kaltura entry",
// "Can list kaltura entries" => "Can list kaltura entries",
// "Can view kaltura entry" => "Can view kaltura entry",
// "Can upload screencasts to wiki pages" => "Can upload screencasts to wiki pages",
// "tiki release" => "tiki release",
// "feature version checks" => "feature version checks",
// "tiki needs upgrade" => "tiki needs upgrade",
// "tiki version last check" => "tiki version last check",
// "tiki version check frequency" => "tiki version check frequency",
// "lastUpdatePrefs" => "lastUpdatePrefs",
// "feature print indexed" => "feature print indexed",
// "groups are emulated" => "groups are emulated",
// "feature wiki" => "feature wiki",
// "default wiki diff style" => "default wiki diff style",
// "feature backlinks" => "feature backlinks",
// "feature dump" => "feature dump",
// "feature history" => "feature history",
// "feature lastChanges" => "feature lastChanges",
// "feature likePages" => "feature likePages",
// "feature listPages" => "feature listPages",
// "feature listorphanPages" => "feature listorphanPages",
// "feature listorphanStructure" => "feature listorphanStructure",
// "feature page title" => "feature page title",
// "feature sandbox" => "feature sandbox",
// "feature warn on edit" => "feature warn on edit",
// "feature wiki 1like redirection" => "feature wiki 1like redirection",
// "feature wiki allowhtml" => "feature wiki allowhtml",
// "feature wiki argvariable" => "feature wiki argvariable",
// "feature wiki attachments" => "feature wiki attachments",
// "feature wiki comments" => "feature wiki comments",
// "feature wiki description" => "feature wiki description",
// "feature wiki discuss" => "feature wiki discuss",
// "feature wiki export" => "feature wiki export",
// "feature wiki structure" => "feature wiki structure",
// "feature wiki import page" => "feature wiki import page",
// "feature wiki footnotes" => "feature wiki footnotes",
// "feature wiki icache" => "feature wiki icache",
// "feature wiki import html" => "feature wiki import html",
// "feature wiki mindmap" => "feature wiki mindmap",
// "feature wiki monosp" => "feature wiki monosp",
// "feature wiki multiprint" => "feature wiki multiprint",
// "feature wiki notepad" => "feature wiki notepad",
// "feature wiki make structure" => "feature wiki make structure",
// "feature wiki open as structure" => "feature wiki open as structure",
// "feature wiki pageid" => "feature wiki pageid",
// "feature wiki paragraph formatting" => "feature wiki paragraph formatting",
// "feature wiki paragraph formatting add br" => "feature wiki paragraph formatting add br",
// "feature wiki pictures" => "feature wiki pictures",
// "feature wiki plurals" => "feature wiki plurals",
// "feature wiki print" => "feature wiki print",
// "feature wiki protect email" => "feature wiki protect email",
// "feature wiki rankings" => "feature wiki rankings",
// "feature wiki ratings" => "feature wiki ratings",
// "feature wiki replace" => "feature wiki replace",
// "feature wiki show hide before" => "feature wiki show hide before",
// "feature wiki tables" => "feature wiki tables",
// "feature wiki templates" => "feature wiki templates",
// "feature wiki undo" => "feature wiki undo",
// "feature wiki userpage" => "feature wiki userpage",
// "feature wiki userpage prefix" => "feature wiki userpage prefix",
// "feature wiki usrlock" => "feature wiki usrlock",
// "feature wiki feedback polls" => "feature wiki feedback polls",
// "feature wiki save draft" => "feature wiki save draft",
// "feature wikiwords" => "feature wikiwords",
// "feature wikiwords usedash" => "feature wikiwords usedash",
// "feature wiki pagealias" => "feature wiki pagealias",
// "mailin autocheck" => "mailin autocheck",
// "mailin autocheckFreq" => "mailin autocheckFreq",
// "mailin autocheckLast" => "mailin autocheckLast",
// "page bar position" => "page bar position",
// "warn on edit time" => "warn on edit time",
// "wikiHomePage" => "wikiHomePage",
// "wikiLicensePage" => "wikiLicensePage",
// "wikiSubmitNotice" => "wikiSubmitNotice",
// "wiki authors style" => "wiki authors style",
// "wiki authors style by page" => "wiki authors style by page",
// "wiki dft list pages lang to current" => "wiki dft list pages lang to current",
// "wiki show version" => "wiki show version",
// "wiki bot bar" => "wiki bot bar",
// "wiki cache" => "wiki cache",
// "wiki comments default ordering" => "wiki comments default ordering",
// "wiki comments displayed default" => "wiki comments displayed default",
// "wiki comments per page" => "wiki comments per page",
// "wiki comments allow per page" => "wiki comments allow per page",
// "wiki creator admin" => "wiki creator admin",
// "wiki feature copyrights" => "wiki feature copyrights",
// "wiki forum id" => "wiki forum id",
// "wiki left column" => "wiki left column",
// "wiki list backlinks" => "wiki list backlinks",
// "wiki list comment" => "wiki list comment",
// "wiki list comment len" => "wiki list comment len",
// "wiki list description" => "wiki list description",
// "wiki list description len" => "wiki list description len",
// "wiki list creator" => "wiki list creator",
// "wiki list hits" => "wiki list hits",
// "wiki list lastmodif" => "wiki list lastmodif",
// "wiki list lastver" => "wiki list lastver",
// "wiki list links" => "wiki list links",
// "wiki list name" => "wiki list name",
// "wiki list name len" => "wiki list name len",
// "wiki list size" => "wiki list size",
// "wiki list status" => "wiki list status",
// "wiki list user" => "wiki list user",
// "wiki list versions" => "wiki list versions",
// "wiki list language" => "wiki list language",
// "wiki list categories" => "wiki list categories",
// "wiki list categories path" => "wiki list categories path",
// "wiki list id" => "wiki list id",
// "wiki list sortorder" => "wiki list sortorder",
// "wiki list sortdirection" => "wiki list sortdirection",
// "wiki pagealias tokens" => "wiki pagealias tokens",
// "wiki page regex" => "wiki page regex",
// "wiki page separator" => "wiki page separator",
// "wiki page navigation bar" => "wiki page navigation bar",
// "wiki actions bar" => "wiki actions bar",
// "wiki pagename strip" => "wiki pagename strip",
// "wiki right column" => "wiki right column",
// "wiki top bar" => "wiki top bar",
// "wiki topline position" => "wiki topline position",
// "wiki uses slides" => "wiki uses slides",
// "wiki watch author" => "wiki watch author",
// "wiki watch comments" => "wiki watch comments",
// "wiki watch editor" => "wiki watch editor",
// "wiki watch minor" => "wiki watch minor",
// "feature wiki history full" => "feature wiki history full",
// "feature wiki categorize structure" => "feature wiki categorize structure",
// "feature wiki watch structure" => "feature wiki watch structure",
// "feature wikiapproval" => "feature wikiapproval",
// "wikiapproval prefix" => "wikiapproval prefix",
// "wikiapproval hideprefix" => "wikiapproval hideprefix",
// "wikiapproval delete staging" => "wikiapproval delete staging",
// "wikiapproval master group" => "wikiapproval master group",
// "wikiapproval staging category" => "wikiapproval staging category",
// "wikiapproval approved category" => "wikiapproval approved category",
// "wikiapproval outofsync category" => "wikiapproval outofsync category",
// "wikiapproval block editapproved" => "wikiapproval block editapproved",
// "wikiapproval sync categories" => "wikiapproval sync categories",
// "wikiapproval update freetags" => "wikiapproval update freetags",
// "wikiapproval combine freetags" => "wikiapproval combine freetags",
// "wiki edit section" => "wiki edit section",
// "wiki edit section level" => "wiki edit section level",
// "wiki edit icons toggle" => "wiki edit icons toggle",
// "wiki edit plugin" => "wiki edit plugin",
// "wiki validate plugin" => "wiki validate plugin",
// "wiki edit minor" => "wiki edit minor",
// "feature pagelist" => "feature pagelist",
// "wikiplugin agentinfo" => "wikiplugin agentinfo",
// "wikiplugin alink" => "wikiplugin alink",
// "wikiplugin aname" => "wikiplugin aname",
// "wikiplugin annotation" => "wikiplugin annotation",
// "wikiplugin article" => "wikiplugin article",
// "wikiplugin articles" => "wikiplugin articles",
// "wikiplugin attach" => "wikiplugin attach",
// "wikiplugin avatar" => "wikiplugin avatar",
// "wikiplugin back" => "wikiplugin back",
// "wikiplugin backlinks" => "wikiplugin backlinks",
// "wikiplugin banner" => "wikiplugin banner",
// "wikiplugin bloglist" => "wikiplugin bloglist",
// "wikiplugin box" => "wikiplugin box",
// "wikiplugin calendar" => "wikiplugin calendar",
// "wikiplugin category" => "wikiplugin category",
// "wikiplugin catorphans" => "wikiplugin catorphans",
// "wikiplugin catpath" => "wikiplugin catpath",
// "wikiplugin center" => "wikiplugin center",
// "wikiplugin chart" => "wikiplugin chart",
// "wikiplugin code" => "wikiplugin code",
// "wikiplugin content" => "wikiplugin content",
// "wikiplugin cookie" => "wikiplugin cookie",
// "wikiplugin copyright" => "wikiplugin copyright",
// "wikiplugin countdown" => "wikiplugin countdown",
// "wikiplugin datachannel" => "wikiplugin datachannel",
// "wikiplugin dbreport" => "wikiplugin dbreport",
// "wikiplugin div" => "wikiplugin div",
// "wikiplugin dl" => "wikiplugin dl",
// "wikiplugin draw" => "wikiplugin draw",
// "wikiplugin equation" => "wikiplugin equation",
// "wikiplugin events" => "wikiplugin events",
// "wikiplugin fade" => "wikiplugin fade",
// "wikiplugin fancylist" => "wikiplugin fancylist",
// "wikiplugin fancytable" => "wikiplugin fancytable",
// "wikiplugin file" => "wikiplugin file",
// "wikiplugin files" => "wikiplugin files",
// "wikiplugin flash" => "wikiplugin flash",
// "wikiplugin footnote" => "wikiplugin footnote",
// "wikiplugin footnotearea" => "wikiplugin footnotearea",
// "wikiplugin ftp" => "wikiplugin ftp",
// "wikiplugin gauge" => "wikiplugin gauge",
// "wikiplugin googleanalytics" => "wikiplugin googleanalytics",
// "wikiplugin googledoc" => "wikiplugin googledoc",
// "wikiplugin group" => "wikiplugin group",
// "wikiplugin groupmailcore" => "wikiplugin groupmailcore",
// "wikiplugin groupstat" => "wikiplugin groupstat",
// "wikiplugin html" => "wikiplugin html",
// "wikiplugin iframe" => "wikiplugin iframe",
// "wikiplugin img" => "wikiplugin img",
// "wikiplugin image" => "wikiplugin image",
// "wikiplugin include" => "wikiplugin include",
// "wikiplugin invite" => "wikiplugin invite",
// "wikiplugin jabber" => "wikiplugin jabber",
// "wikiplugin js" => "wikiplugin js",
// "wikiplugin jq" => "wikiplugin jq",
// "wikiplugin lang" => "wikiplugin lang",
// "wikiplugin lastmod" => "wikiplugin lastmod",
// "wikiplugin listpages" => "wikiplugin listpages",
// "wikiplugin listprogress" => "wikiplugin listprogress",
// "wikiplugin lsdir" => "wikiplugin lsdir",
// "wikiplugin map" => "wikiplugin map",
// "wikiplugin mcalendar" => "wikiplugin mcalendar",
// "wikiplugin mediaplayer" => "wikiplugin mediaplayer",
// "wikiplugin memberlist" => "wikiplugin memberlist",
// "wikiplugin miniquiz" => "wikiplugin miniquiz",
// "wikiplugin module" => "wikiplugin module",
// "wikiplugin mono" => "wikiplugin mono",
// "wikiplugin mouseover" => "wikiplugin mouseover",
// "wikiplugin mwtable" => "wikiplugin mwtable",
// "wikiplugin myspace" => "wikiplugin myspace",
// "wikiplugin objecthits" => "wikiplugin objecthits",
// "wikiplugin pagelist" => "wikiplugin pagelist",
// "wikiplugin picture" => "wikiplugin picture",
// "wikiplugin pluginmanager" => "wikiplugin pluginmanager",
// "wikiplugin poll" => "wikiplugin poll",
// "wikiplugin profile" => "wikiplugin profile",
// "wikiplugin proposal" => "wikiplugin proposal",
// "wikiplugin quote" => "wikiplugin quote",
// "wikiplugin rcontent" => "wikiplugin rcontent",
// "wikiplugin realnamelist" => "wikiplugin realnamelist",
// "wikiplugin redirect" => "wikiplugin redirect",
// "wikiplugin regex" => "wikiplugin regex",
// "wikiplugin remarksbox" => "wikiplugin remarksbox",
// "wikiplugin rss" => "wikiplugin rss",
// "wikiplugin screencast" => "wikiplugin screencast",
// "wikiplugin sf" => "wikiplugin sf",
// "wikiplugin share" => "wikiplugin share",
// "wikiplugin sharethis" => "wikiplugin sharethis",
// "wikiplugin sheet" => "wikiplugin sheet",
// "wikiplugin showpages" => "wikiplugin showpages",
// "wikiplugin skype" => "wikiplugin skype",
// "wikiplugin snarf" => "wikiplugin snarf",
// "wikiplugin sort" => "wikiplugin sort",
// "wikiplugin split" => "wikiplugin split",
// "wikiplugin sql" => "wikiplugin sql",
// "wikiplugin stat" => "wikiplugin stat",
// "wikiplugin sub" => "wikiplugin sub",
// "wikiplugin subscribegroup" => "wikiplugin subscribegroup",
// "wikiplugin subscribegroups" => "wikiplugin subscribegroups",
// "wikiplugin sup" => "wikiplugin sup",
// "wikiplugin survey" => "wikiplugin survey",
// "wikiplugin tag" => "wikiplugin tag",
// "wikiplugin tabs" => "wikiplugin tabs",
// "wikiplugin thumb" => "wikiplugin thumb",
// "wikiplugin titlesearch" => "wikiplugin titlesearch",
// "wikiplugin toc" => "wikiplugin toc",
// "wikiplugin topfriends" => "wikiplugin topfriends",
// "wikiplugin trackerfilter" => "wikiplugin trackerfilter",
// "wikiplugin trackeritemfield" => "wikiplugin trackeritemfield",
// "wikiplugin trackerlist" => "wikiplugin trackerlist",
// "wikiplugin trackertimeline" => "wikiplugin trackertimeline",
// "wikiplugin tracker" => "wikiplugin tracker",
// "wikiplugin trackerprefill" => "wikiplugin trackerprefill",
// "wikiplugin trackerstat" => "wikiplugin trackerstat",
// "wikiplugin translated" => "wikiplugin translated",
// "wikiplugin tr" => "wikiplugin tr",
// "wikiplugin usercount" => "wikiplugin usercount",
// "wikiplugin userlist" => "wikiplugin userlist",
// "wikiplugin userpref" => "wikiplugin userpref",
// "wikiplugin versions" => "wikiplugin versions",
// "wikiplugin vote" => "wikiplugin vote",
// "wikiplugin wantedpages" => "wikiplugin wantedpages",
// "wikiplugin webservice" => "wikiplugin webservice",
// "wikiplugin youtube" => "wikiplugin youtube",
// "wikiplugininline agentinfo" => "wikiplugininline agentinfo",
// "wikiplugininline alink" => "wikiplugininline alink",
// "wikiplugininline aname" => "wikiplugininline aname",
// "wikiplugininline annotation" => "wikiplugininline annotation",
// "wikiplugininline article" => "wikiplugininline article",
// "wikiplugininline articles" => "wikiplugininline articles",
// "wikiplugininline attach" => "wikiplugininline attach",
// "wikiplugininline avatar" => "wikiplugininline avatar",
// "wikiplugininline back" => "wikiplugininline back",
// "wikiplugininline backlinks" => "wikiplugininline backlinks",
// "wikiplugininline banner" => "wikiplugininline banner",
// "wikiplugininline bloglist" => "wikiplugininline bloglist",
// "wikiplugininline box" => "wikiplugininline box",
// "wikiplugininline calendar" => "wikiplugininline calendar",
// "wikiplugininline category" => "wikiplugininline category",
// "wikiplugininline catorphans" => "wikiplugininline catorphans",
// "wikiplugininline catpath" => "wikiplugininline catpath",
// "wikiplugininline center" => "wikiplugininline center",
// "wikiplugininline chart" => "wikiplugininline chart",
// "wikiplugininline code" => "wikiplugininline code",
// "wikiplugininline content" => "wikiplugininline content",
// "wikiplugininline cookie" => "wikiplugininline cookie",
// "wikiplugininline copyright" => "wikiplugininline copyright",
// "wikiplugininline countdown" => "wikiplugininline countdown",
// "wikiplugininline datachannel" => "wikiplugininline datachannel",
// "wikiplugininline dbreport" => "wikiplugininline dbreport",
// "wikiplugininline div" => "wikiplugininline div",
// "wikiplugininline dl" => "wikiplugininline dl",
// "wikiplugininline draw" => "wikiplugininline draw",
// "wikiplugininline equation" => "wikiplugininline equation",
// "wikiplugininline events" => "wikiplugininline events",
// "wikiplugininline fade" => "wikiplugininline fade",
// "wikiplugininline fancylist" => "wikiplugininline fancylist",
// "wikiplugininline fancytable" => "wikiplugininline fancytable",
// "wikiplugininline file" => "wikiplugininline file",
// "wikiplugininline files" => "wikiplugininline files",
// "wikiplugininline flash" => "wikiplugininline flash",
// "wikiplugininline footnote" => "wikiplugininline footnote",
// "wikiplugininline footnotearea" => "wikiplugininline footnotearea",
// "wikiplugininline ftp" => "wikiplugininline ftp",
// "wikiplugininline gauge" => "wikiplugininline gauge",
// "wikiplugininline googleanalytics" => "wikiplugininline googleanalytics",
// "wikiplugininline googledoc" => "wikiplugininline googledoc",
// "wikiplugininline group" => "wikiplugininline group",
// "wikiplugininline groupmailcore" => "wikiplugininline groupmailcore",
// "wikiplugininline groupstat" => "wikiplugininline groupstat",
// "wikiplugininline html" => "wikiplugininline html",
// "wikiplugininline iframe" => "wikiplugininline iframe",
// "wikiplugininline img" => "wikiplugininline img",
// "wikiplugininline image" => "wikiplugininline image",
// "wikiplugininline include" => "wikiplugininline include",
// "wikiplugininline invite" => "wikiplugininline invite",
// "wikiplugininline jabber" => "wikiplugininline jabber",
// "wikiplugininline js" => "wikiplugininline js",
// "wikiplugininline jq" => "wikiplugininline jq",
// "wikiplugininline lang" => "wikiplugininline lang",
// "wikiplugininline lastmod" => "wikiplugininline lastmod",
// "wikiplugininline listpages" => "wikiplugininline listpages",
// "wikiplugininline listprogress" => "wikiplugininline listprogress",
// "wikiplugininline lsdir" => "wikiplugininline lsdir",
// "wikiplugininline map" => "wikiplugininline map",
// "wikiplugininline mcalendar" => "wikiplugininline mcalendar",
// "wikiplugininline mediaplayer" => "wikiplugininline mediaplayer",
// "wikiplugininline memberlist" => "wikiplugininline memberlist",
// "wikiplugininline miniquiz" => "wikiplugininline miniquiz",
// "wikiplugininline module" => "wikiplugininline module",
// "wikiplugininline mono" => "wikiplugininline mono",
// "wikiplugininline mouseover" => "wikiplugininline mouseover",
// "wikiplugininline mwtable" => "wikiplugininline mwtable",
// "wikiplugininline myspace" => "wikiplugininline myspace",
// "wikiplugininline objecthits" => "wikiplugininline objecthits",
// "wikiplugininline pagelist" => "wikiplugininline pagelist",
// "wikiplugininline picture" => "wikiplugininline picture",
// "wikiplugininline pluginmanager" => "wikiplugininline pluginmanager",
// "wikiplugininline poll" => "wikiplugininline poll",
// "wikiplugininline profile" => "wikiplugininline profile",
// "wikiplugininline proposal" => "wikiplugininline proposal",
// "wikiplugininline quote" => "wikiplugininline quote",
// "wikiplugininline rcontent" => "wikiplugininline rcontent",
// "wikiplugininline realnamelist" => "wikiplugininline realnamelist",
// "wikiplugininline redirect" => "wikiplugininline redirect",
// "wikiplugininline regex" => "wikiplugininline regex",
// "wikiplugininline remarksbox" => "wikiplugininline remarksbox",
// "wikiplugininline rss" => "wikiplugininline rss",
// "wikiplugininline screencast" => "wikiplugininline screencast",
// "wikiplugininline sf" => "wikiplugininline sf",
// "wikiplugininline share" => "wikiplugininline share",
// "wikiplugininline sharethis" => "wikiplugininline sharethis",
// "wikiplugininline sheet" => "wikiplugininline sheet",
// "wikiplugininline showpages" => "wikiplugininline showpages",
// "wikiplugininline skype" => "wikiplugininline skype",
// "wikiplugininline snarf" => "wikiplugininline snarf",
// "wikiplugininline sort" => "wikiplugininline sort",
// "wikiplugininline split" => "wikiplugininline split",
// "wikiplugininline sql" => "wikiplugininline sql",
// "wikiplugininline stat" => "wikiplugininline stat",
// "wikiplugininline sub" => "wikiplugininline sub",
// "wikiplugininline subscribegroup" => "wikiplugininline subscribegroup",
// "wikiplugininline subscribegroups" => "wikiplugininline subscribegroups",
// "wikiplugininline sup" => "wikiplugininline sup",
// "wikiplugininline survey" => "wikiplugininline survey",
// "wikiplugininline tag" => "wikiplugininline tag",
// "wikiplugininline tabs" => "wikiplugininline tabs",
// "wikiplugininline thumb" => "wikiplugininline thumb",
// "wikiplugininline titlesearch" => "wikiplugininline titlesearch",
// "wikiplugininline toc" => "wikiplugininline toc",
// "wikiplugininline topfriends" => "wikiplugininline topfriends",
// "wikiplugininline trackerfilter" => "wikiplugininline trackerfilter",
// "wikiplugininline trackeritemfield" => "wikiplugininline trackeritemfield",
// "wikiplugininline trackerlist" => "wikiplugininline trackerlist",
// "wikiplugininline trackertimeline" => "wikiplugininline trackertimeline",
// "wikiplugininline tracker" => "wikiplugininline tracker",
// "wikiplugininline trackerprefill" => "wikiplugininline trackerprefill",
// "wikiplugininline trackerstat" => "wikiplugininline trackerstat",
// "wikiplugininline translated" => "wikiplugininline translated",
// "wikiplugininline tr" => "wikiplugininline tr",
// "wikiplugininline usercount" => "wikiplugininline usercount",
// "wikiplugininline userlist" => "wikiplugininline userlist",
// "wikiplugininline userpref" => "wikiplugininline userpref",
// "wikiplugininline versions" => "wikiplugininline versions",
// "wikiplugininline vote" => "wikiplugininline vote",
// "wikiplugininline wantedpages" => "wikiplugininline wantedpages",
// "wikiplugininline webservice" => "wikiplugininline webservice",
// "wikiplugininline youtube" => "wikiplugininline youtube",
// "webservice consume defaultcache" => "webservice consume defaultcache",
// "feature webservices" => "feature webservices",
// "feature semantic" => "feature semantic",
// "feature wysiwyg" => "feature wysiwyg",
// "wysiwyg optional" => "wysiwyg optional",
// "wysiwyg default" => "wysiwyg default",
// "wysiwyg memo" => "wysiwyg memo",
// "wysiwyg wiki parsed" => "wysiwyg wiki parsed",
// "wysiwyg wiki semi parsed" => "wysiwyg wiki semi parsed",
// "wysiwyg toolbar skin" => "wysiwyg toolbar skin",
// "wiki feature 3d" => "wiki feature 3d",
// "wiki 3d width" => "wiki 3d width",
// "wiki 3d height" => "wiki 3d height",
// "wiki 3d navigation depth" => "wiki 3d navigation depth",
// "wiki 3d feed animation interval" => "wiki 3d feed animation interval",
// "wiki 3d existing page color" => "wiki 3d existing page color",
// "wiki 3d missing page color" => "wiki 3d missing page color",
// "feature blogs" => "feature blogs",
// "blog list order" => "blog list order",
// "home blog" => "home blog",
// "feature blog rankings" => "feature blog rankings",
// "feature blog comments" => "feature blog comments",
// "blog comments default ordering" => "blog comments default ordering",
// "blog comments per page" => "blog comments per page",
// "feature blogposts comments" => "feature blogposts comments",
// "blog list user" => "blog list user",
// "blog list title" => "blog list title",
// "blog list title len" => "blog list title len",
// "blog list description" => "blog list description",
// "blog list created" => "blog list created",
// "blog list lastmodif" => "blog list lastmodif",
// "blog list posts" => "blog list posts",
// "blog list visits" => "blog list visits",
// "blog list activity" => "blog list activity",
// "feature blog mandatory category" => "feature blog mandatory category",
// "feature blog heading" => "feature blog heading",
// "feature file galleries" => "feature file galleries",
// "home file gallery" => "home file gallery",
// "fgal root id" => "fgal root id",
// "fgal use db" => "fgal use db",
// "fgal batch dir" => "fgal batch dir",
// "fgal match regex" => "fgal match regex",
// "fgal nmatch regex" => "fgal nmatch regex",
// "fgal use dir" => "fgal use dir",
// "fgal podcast dir" => "fgal podcast dir",
// "feature file galleries comments" => "feature file galleries comments",
// "file galleries comments default ordering" => "file galleries comments default ordering",
// "file galleries comments per page" => "file galleries comments per page",
// "feature file galleries batch" => "feature file galleries batch",
// "feature file galleries rankings" => "feature file galleries rankings",
// "fgal enable auto indexing" => "fgal enable auto indexing",
// "fgal asynchronous indexing" => "fgal asynchronous indexing",
// "fgal allow duplicates" => "fgal allow duplicates",
// "fgal sort mode" => "fgal sort mode",
// "feature file galleries author" => "feature file galleries author",
// "fgal list id" => "fgal list id",
// "fgal list type" => "fgal list type",
// "fgal list name" => "fgal list name",
// "fgal list description" => "fgal list description",
// "fgal list size" => "fgal list size",
// "fgal list created" => "fgal list created",
// "fgal list lastModif" => "fgal list lastModif",
// "fgal list creator" => "fgal list creator",
// "fgal list author" => "fgal list author",
// "fgal list last user" => "fgal list last user",
// "fgal list comment" => "fgal list comment",
// "fgal list files" => "fgal list files",
// "fgal list hits" => "fgal list hits",
// "fgal list lockedby" => "fgal list lockedby",
// "fgal show path" => "fgal show path",
// "fgal show explorer" => "fgal show explorer",
// "fgal show slideshow" => "fgal show slideshow",
// "fgal default view" => "fgal default view",
// "fgal limit hits per file" => "fgal limit hits per file",
// "fgal prevent negative score" => "fgal prevent negative score",
// "fgal quota" => "fgal quota",
// "fgal quota per fgal" => "fgal quota per fgal",
// "fgal quota default" => "fgal quota default",
// "fgal quota show" => "fgal quota show",
// "feature galleries" => "feature galleries",
// "feature gal batch" => "feature gal batch",
// "feature gal slideshow" => "feature gal slideshow",
// "home gallery" => "home gallery",
// "gal use db" => "gal use db",
// "gal use lib" => "gal use lib",
// "gal match regex" => "gal match regex",
// "gal nmatch regex" => "gal nmatch regex",
// "gal use dir" => "gal use dir",
// "gal batch dir" => "gal batch dir",
// "feature gal rankings" => "feature gal rankings",
// "feature image galleries comments" => "feature image galleries comments",
// "image galleries comments default order" => "image galleries comments default order",
// "image galleries comments per page" => "image galleries comments per page",
// "gal list name" => "gal list name",
// "gal list parent" => "gal list parent",
// "gal list description" => "gal list description",
// "gal list created" => "gal list created",
// "gal list lastmodif" => "gal list lastmodif",
// "gal list user" => "gal list user",
// "gal list imgs" => "gal list imgs",
// "gal list visits" => "gal list visits",
// "feature image gallery mandatory category" => "feature image gallery mandatory category",
// "preset galleries info" => "preset galleries info",
// "gal image mouseover" => "gal image mouseover",
// "ProgressBarPlay" => "ProgressBarPlay",
// "ProgressBarLoad" => "ProgressBarLoad",
// "ProgressBarButton" => "ProgressBarButton",
// "ProgressBar" => "ProgressBar",
// "VolumeOn" => "VolumeOn",
// "VolumeOff" => "VolumeOff",
// "VolumeButton" => "VolumeButton",
// "Button" => "Button",
// "ButtonPressed" => "ButtonPressed",
// "ButtonOver" => "ButtonOver",
// "ButtonInfo" => "ButtonInfo",
// "ButtonInfoPressed" => "ButtonInfoPressed",
// "ButtonInfoOver" => "ButtonInfoOver",
// "ButtonInfoText" => "ButtonInfoText",
// "ID3" => "ID3",
// "PlayTime" => "PlayTime",
// "TotalTime" => "TotalTime",
// "PanelDisplay" => "PanelDisplay",
// "AlertMesg" => "AlertMesg",
// "PreloadDelay" => "PreloadDelay",
// "VideoHeight" => "VideoHeight",
// "VideoLength" => "VideoLength",
// "URLAppend" => "URLAppend",
// "LimitedMsg" => "LimitedMsg",
// "MaxPlay" => "MaxPlay",
// "MultimediaGalerie" => "MultimediaGalerie",
// "MultimediaDefaultLength" => "MultimediaDefaultLength",
// "MultimediaDefaultHeight" => "MultimediaDefaultHeight",
// "feature forums" => "feature forums",
// "home forum" => "home forum",
// "feature forum rankings" => "feature forum rankings",
// "feature forum parse" => "feature forum parse",
// "feature forum topics archiving" => "feature forum topics archiving",
// "feature forum replyempty" => "feature forum replyempty",
// "feature forum quickjump" => "feature forum quickjump",
// "feature forums allow thread titles" => "feature forums allow thread titles",
// "feature forum content search" => "feature forum content search",
// "feature forums name search" => "feature forums name search",
// "forums ordering" => "forums ordering",
// "forum list topics" => "forum list topics",
// "forum list posts" => "forum list posts",
// "forum list ppd" => "forum list ppd",
// "forum list lastpost" => "forum list lastpost",
// "forum list visits" => "forum list visits",
// "forum list desc" => "forum list desc",
// "forum list description len" => "forum list description len",
// "feature forum local search" => "feature forum local search",
// "feature forum local tiki search" => "feature forum local tiki search",
// "forum thread defaults by forum" => "forum thread defaults by forum",
// "forum thread user settings" => "forum thread user settings",
// "forum thread user settings threshold" => "forum thread user settings threshold",
// "forum thread user settings keep" => "forum thread user settings keep",
// "forum comments per page" => "forum comments per page",
// "forum comments no title prefix" => "forum comments no title prefix",
// "forum thread style" => "forum thread style",
// "forum thread sort mode" => "forum thread sort mode",
// "forum match regex" => "forum match regex",
// "feature articles" => "feature articles",
// "feature submissions" => "feature submissions",
// "feature cms rankings" => "feature cms rankings",
// "feature cms print" => "feature cms print",
// "feature cms emails" => "feature cms emails",
// "art list title" => "art list title",
// "art list title len" => "art list title len",
// "art list topic" => "art list topic",
// "art list date" => "art list date",
// "art list author" => "art list author",
// "art list rating" => "art list rating",
// "art list reads" => "art list reads",
// "art list size" => "art list size",
// "art list expire" => "art list expire",
// "art list img" => "art list img",
// "art list type" => "art list type",
// "art list visible" => "art list visible",
// "art view type" => "art view type",
// "art view title" => "art view title",
// "art view topic" => "art view topic",
// "art view date" => "art view date",
// "art view author" => "art view author",
// "art view reads" => "art view reads",
// "art view size" => "art view size",
// "art view img" => "art view img",
// "art list lang" => "art list lang",
// "feature article comments" => "feature article comments",
// "article comments default ordering" => "article comments default ordering",
// "article comments per page" => "article comments per page",
// "article image size x" => "article image size x",
// "article image size y" => "article image size y",
// "feature cms templates" => "feature cms templates",
// "cms bot bar" => "cms bot bar",
// "cms left column" => "cms left column",
// "cms right column" => "cms right column",
// "cms top bar" => "cms top bar",
// "cms spellcheck" => "cms spellcheck",
// "art home title" => "art home title",
// "feature trackers" => "feature trackers",
// "t use db" => "t use db",
// "t use dir" => "t use dir",
// "groupTracker" => "groupTracker",
// "userTracker" => "userTracker",
// "trk with mirror tables" => "trk with mirror tables",
// "trackerCreatorGroupName" => "trackerCreatorGroupName",
// "tracker jquery user selector threshold" => "tracker jquery user selector threshold",
// "feature userlevels" => "feature userlevels",
// "userlevels" => "userlevels",
// "userbreadCrumb" => "userbreadCrumb",
// "user assigned modules" => "user assigned modules",
// "user flip modules" => "user flip modules",
// "user show realnames" => "user show realnames",
// "feature mytiki" => "feature mytiki",
// "feature userPreferences" => "feature userPreferences",
// "feature user bookmarks" => "feature user bookmarks",
// "feature tasks" => "feature tasks",
// "w use db" => "w use db",
// "w use dir" => "w use dir",
// "w displayed default" => "w displayed default",
// "uf use db" => "uf use db",
// "uf use dir" => "uf use dir",
// "userfiles quota" => "userfiles quota",
// "feature usermenu" => "feature usermenu",
// "feature minical" => "feature minical",
// "feature notepad" => "feature notepad",
// "feature userfiles" => "feature userfiles",
// "feature community gender" => "feature community gender",
// "feature community mouseover" => "feature community mouseover",
// "feature community mouseover name" => "feature community mouseover name",
// "feature community mouseover gender" => "feature community mouseover gender",
// "feature community mouseover picture" => "feature community mouseover picture",
// "feature community mouseover friends" => "feature community mouseover friends",
// "feature community mouseover score" => "feature community mouseover score",
// "feature community mouseover country" => "feature community mouseover country",
// "feature community mouseover email" => "feature community mouseover email",
// "feature community mouseover lastlogin" => "feature community mouseover lastlogin",
// "feature community mouseover distance" => "feature community mouseover distance",
// "feature community list name" => "feature community list name",
// "feature community list score" => "feature community list score",
// "feature community list country" => "feature community list country",
// "feature community list distance" => "feature community list distance",
// "feature community friends permission" => "feature community friends permission",
// "feature community friends permission dep" => "feature community friends permission dep",
// "change language" => "change language",
// "change theme" => "change theme",
// "login is email" => "login is email",
// "validateUsers" => "validateUsers",
// "validateEmail" => "validateEmail",
// "forgotPass" => "forgotPass",
// "change password" => "change password",
// "available languages" => "available languages",
// "available styles" => "available styles",
// "lowercase username" => "lowercase username",
// "username pattern" => "username pattern",
// "max username length" => "max username length",
// "min username length" => "min username length",
// "users prefs allowMsgs" => "users prefs allowMsgs",
// "users prefs country" => "users prefs country",
// "users prefs diff versions" => "users prefs diff versions",
// "users prefs display timezone" => "users prefs display timezone",
// "users prefs email is public" => "users prefs email is public",
// "users prefs homePage" => "users prefs homePage",
// "users prefs lat" => "users prefs lat",
// "users prefs lon" => "users prefs lon",
// "users prefs mess archiveAfter" => "users prefs mess archiveAfter",
// "users prefs mess maxRecords" => "users prefs mess maxRecords",
// "users prefs mess sendReadStatus" => "users prefs mess sendReadStatus",
// "users prefs minPrio" => "users prefs minPrio",
// "users prefs mytiki blogs" => "users prefs mytiki blogs",
// "users prefs mytiki articles" => "users prefs mytiki articles",
// "users prefs mytiki gals" => "users prefs mytiki gals",
// "users prefs mytiki items" => "users prefs mytiki items",
// "users prefs mytiki msgs" => "users prefs mytiki msgs",
// "users prefs mytiki pages" => "users prefs mytiki pages",
// "users prefs mytiki tasks" => "users prefs mytiki tasks",
// "users prefs mytiki forum topics" => "users prefs mytiki forum topics",
// "users prefs mytiki forum replies" => "users prefs mytiki forum replies",
// "users prefs realName" => "users prefs realName",
// "users prefs gender" => "users prefs gender",
// "users prefs show mouseover user info" => "users prefs show mouseover user info",
// "users prefs tasks maxRecords" => "users prefs tasks maxRecords",
// "users prefs user dbl" => "users prefs user dbl",
// "users prefs user information" => "users prefs user information",
// "users prefs userbreadCrumb" => "users prefs userbreadCrumb",
// "users prefs mailCharset" => "users prefs mailCharset",
// "users prefs mailCurrentAccount" => "users prefs mailCurrentAccount",
// "validateRegistration" => "validateRegistration",
// "validator emails" => "validator emails",
// "url after validation" => "url after validation",
// "urlOnUsername" => "urlOnUsername",
// "feature messages" => "feature messages",
// "messu mailbox size" => "messu mailbox size",
// "messu archive size" => "messu archive size",
// "messu sent size" => "messu sent size",
// "allowmsg by default" => "allowmsg by default",
// "allowmsg is optional" => "allowmsg is optional",
// "feature freetags" => "feature freetags",
// "freetags browse show cloud" => "freetags browse show cloud",
// "freetags cloud colors" => "freetags cloud colors",
// "freetags preload random search" => "freetags preload random search",
// "freetags browse amount tags in cloud" => "freetags browse amount tags in cloud",
// "freetags browse amount tags suggestion" => "freetags browse amount tags suggestion",
// "freetags normalized valid chars" => "freetags normalized valid chars",
// "freetags lowercase only" => "freetags lowercase only",
// "freetags feature 3d" => "freetags feature 3d",
// "freetags 3d width" => "freetags 3d width",
// "freetags 3d height" => "freetags 3d height",
// "freetags 3d navigation depth" => "freetags 3d navigation depth",
// "freetags 3d feed animation interval" => "freetags 3d feed animation interval",
// "freetags 3d existing page color" => "freetags 3d existing page color",
// "freetags 3d missing page color" => "freetags 3d missing page color",
// "freetags 3d autoload" => "freetags 3d autoload",
// "freetags 3d camera distance" => "freetags 3d camera distance",
// "freetags 3d elastic constant" => "freetags 3d elastic constant",
// "freetags 3d eletrostatic constant" => "freetags 3d eletrostatic constant",
// "freetags 3d fov" => "freetags 3d fov",
// "freetags 3d friction constant" => "freetags 3d friction constant",
// "freetags 3d node charge" => "freetags 3d node charge",
// "freetags 3d node mass" => "freetags 3d node mass",
// "freetags 3d node size" => "freetags 3d node size",
// "freetags 3d spring size" => "freetags 3d spring size",
// "freetags 3d text size" => "freetags 3d text size",
// "freetags 3d adjust camera" => "freetags 3d adjust camera",
// "freetags multilingual" => "freetags multilingual",
// "morelikethis algorithm" => "morelikethis algorithm",
// "morelikethis basic mincommon" => "morelikethis basic mincommon",
// "freetags show middle" => "freetags show middle",
// "feature search stats" => "feature search stats",
// "feature search" => "feature search",
// "feature search fulltext" => "feature search fulltext",
// "feature search show forbidden obj" => "feature search show forbidden obj",
// "feature search show forbidden cat" => "feature search show forbidden cat",
// "feature search show object filter" => "feature search show object filter",
// "feature search show search box" => "feature search show search box",
// "feature search show visit count" => "feature search show visit count",
// "feature search show pertinence" => "feature search show pertinence",
// "feature search show object type" => "feature search show object type",
// "feature search show last modification" => "feature search show last modification",
// "search refresh index mode" => "search refresh index mode",
// "search parsed snippet" => "search parsed snippet",
// "feature search preferences" => "feature search preferences",
// "feature webmail" => "feature webmail",
// "webmail max attachment" => "webmail max attachment",
// "webmail view html" => "webmail view html",
// "feature contacts" => "feature contacts",
// "feature faqs" => "feature faqs",
// "feature faq comments" => "feature faq comments",
// "faq comments per page" => "faq comments per page",
// "faq comments default ordering" => "faq comments default ordering",
// "faq prefix" => "faq prefix",
// "feature quizzes" => "feature quizzes",
// "feature polls" => "feature polls",
// "feature poll comments" => "feature poll comments",
// "feature poll anonymous" => "feature poll anonymous",
// "poll comments default ordering" => "poll comments default ordering",
// "poll comments per page" => "poll comments per page",
// "poll list categories" => "poll list categories",
// "poll list objects" => "poll list objects",
// "feature poll revote" => "feature poll revote",
// "feature surveys" => "feature surveys",
// "feature featuredLinks" => "feature featuredLinks",
// "feature directory" => "feature directory",
// "directory columns" => "directory columns",
// "directory links per page" => "directory links per page",
// "directory open links" => "directory open links",
// "directory validate urls" => "directory validate urls",
// "directory cool sites" => "directory cool sites",
// "directory country flag" => "directory country flag",
// "feature calendar" => "feature calendar",
// "feature default calendars" => "feature default calendars",
// "calendar sticky popup" => "calendar sticky popup",
// "default calendars" => "default calendars",
// "calendar view mode" => "calendar view mode",
// "calendar view tab" => "calendar view tab",
// "calendar firstDayofWeek" => "calendar firstDayofWeek",
// "calendar timespan" => "calendar timespan",
// "feature jscalendar" => "feature jscalendar",
// "feature action calendar" => "feature action calendar",
// "calendar start year" => "calendar start year",
// "calendar end year" => "calendar end year",
// "calendar list begins focus" => "calendar list begins focus",
// "feature cal manual time" => "feature cal manual time",
// "server timezone" => "server timezone",
// "long date format" => "long date format",
// "long time format" => "long time format",
// "short date format" => "short date format",
// "short time format" => "short time format",
// "display field order" => "display field order",
// "rss forums" => "rss forums",
// "rss forum" => "rss forum",
// "rss directories" => "rss directories",
// "rss articles" => "rss articles",
// "rss blogs" => "rss blogs",
// "rss image galleries" => "rss image galleries",
// "rss file galleries" => "rss file galleries",
// "rss wiki" => "rss wiki",
// "rss image gallery" => "rss image gallery",
// "rss file gallery" => "rss file gallery",
// "rss blog" => "rss blog",
// "rss tracker" => "rss tracker",
// "rss trackers" => "rss trackers",
// "rss calendar" => "rss calendar",
// "rss mapfiles" => "rss mapfiles",
// "rss cache time" => "rss cache time",
// "title rss forums" => "title rss forums",
// "title rss forum" => "title rss forum",
// "title rss directories" => "title rss directories",
// "title rss articles" => "title rss articles",
// "title rss blogs" => "title rss blogs",
// "title rss image galleries" => "title rss image galleries",
// "title rss file galleries" => "title rss file galleries",
// "title rss wiki" => "title rss wiki",
// "title rss image gallery" => "title rss image gallery",
// "title rss file gallery" => "title rss file gallery",
// "title rss blog" => "title rss blog",
// "title rss tracker" => "title rss tracker",
// "title rss trackers" => "title rss trackers",
// "title rss calendar" => "title rss calendar",
// "title rss mapfiles" => "title rss mapfiles",
// "max rss forums" => "max rss forums",
// "max rss forum" => "max rss forum",
// "max rss directories" => "max rss directories",
// "max rss articles" => "max rss articles",
// "max rss blogs" => "max rss blogs",
// "max rss image galleries" => "max rss image galleries",
// "max rss file galleries" => "max rss file galleries",
// "max rss wiki" => "max rss wiki",
// "max rss image gallery" => "max rss image gallery",
// "max rss file gallery" => "max rss file gallery",
// "max rss blog" => "max rss blog",
// "max rss mapfiles" => "max rss mapfiles",
// "max rss tracker" => "max rss tracker",
// "max rss trackers" => "max rss trackers",
// "max rss calendar" => "max rss calendar",
// "summary rss blogs" => "summary rss blogs",
// "rssfeed default version" => "rssfeed default version",
// "rssfeed language" => "rssfeed language",
// "rssfeed editor" => "rssfeed editor",
// "rssfeed webmaster" => "rssfeed webmaster",
// "rssfeed creator" => "rssfeed creator",
// "rssfeed css" => "rssfeed css",
// "rssfeed publisher" => "rssfeed publisher",
// "rssfeed img" => "rssfeed img",
// "rss basic auth" => "rss basic auth",
// "feature maps" => "feature maps",
// "map path" => "map path",
// "default map" => "default map",
// "map help" => "map help",
// "map comments" => "map comments",
// "gdaltindex" => "gdaltindex",
// "ogr2ogr" => "ogr2ogr",
// "mapzone" => "mapzone",
// "feature gmap" => "feature gmap",
// "gmap defaultx" => "gmap defaultx",
// "gmap defaulty" => "gmap defaulty",
// "gmap defaultz" => "gmap defaultz",
// "gmap key" => "gmap key",
// "allowRegister" => "allowRegister",
// "eponymousGroups" => "eponymousGroups",
// "useRegisterPasscode" => "useRegisterPasscode",
// "registerPasscode" => "registerPasscode",
// "rememberme" => "rememberme",
// "remembertime" => "remembertime",
// "feature clear passwords" => "feature clear passwords",
// "feature crypt passwords" => "feature crypt passwords",
// "feature challenge" => "feature challenge",
// "min user length" => "min user length",
// "min pass length" => "min pass length",
// "pass chr num" => "pass chr num",
// "pass due" => "pass due",
// "email due" => "email due",
// "unsuccessful logins" => "unsuccessful logins",
// "rnd num reg" => "rnd num reg",
// "generate password" => "generate password",
// "auth method" => "auth method",
// "auth pear" => "auth pear",
// "auth ldap url" => "auth ldap url",
// "auth pear host" => "auth pear host",
// "auth pear port" => "auth pear port",
// "auth ldap scope" => "auth ldap scope",
// "auth ldap basedn" => "auth ldap basedn",
// "auth ldap userdn" => "auth ldap userdn",
// "auth ldap userattr" => "auth ldap userattr",
// "auth ldap useroc" => "auth ldap useroc",
// "auth ldap groupdn" => "auth ldap groupdn",
// "auth ldap groupattr" => "auth ldap groupattr",
// "auth ldap groupnameatr" => "auth ldap groupnameatr",
// "auth ldap groupdescatr" => "auth ldap groupdescatr",
// "auth ldap usergroupattr" => "auth ldap usergroupattr",
// "auth ldap groupgroupattr" => "auth ldap groupgroupattr",
// "auth ldap groupoc" => "auth ldap groupoc",
// "auth ldap memberattr" => "auth ldap memberattr",
// "auth ldap memberisdn" => "auth ldap memberisdn",
// "auth ldap adminuser" => "auth ldap adminuser",
// "auth ldap adminpass" => "auth ldap adminpass",
// "auth ldap version" => "auth ldap version",
// "auth ldap nameattr" => "auth ldap nameattr",
// "auth ldap countryattr" => "auth ldap countryattr",
// "auth ldap emailattr" => "auth ldap emailattr",
// "ldap create user tiki" => "ldap create user tiki",
// "ldap create user ldap" => "ldap create user ldap",
// "ldap skip admin" => "ldap skip admin",
// "auth ldap permit tiki users" => "auth ldap permit tiki users",
// "auth ldap debug" => "auth ldap debug",
// "auth ldap ssl" => "auth ldap ssl",
// "auth ldap starttls" => "auth ldap starttls",
// "auth ldap type" => "auth ldap type",
// "auth ldap syncuserattr" => "auth ldap syncuserattr",
// "auth ldap syncgroupattr" => "auth ldap syncgroupattr",
// "https login" => "https login",
// "feature show stay in ssl mode" => "feature show stay in ssl mode",
// "feature switch ssl mode" => "feature switch ssl mode",
// "https port" => "https port",
// "http port" => "http port",
// "login url" => "login url",
// "login scr" => "login scr",
// "register url" => "register url",
// "error url" => "error url",
// "highlight group" => "highlight group",
// "cookie path" => "cookie path",
// "cookie domain" => "cookie domain",
// "cookie name" => "cookie name",
// "user tracker infos" => "user tracker infos",
// "desactive login autocomplete" => "desactive login autocomplete",
// "permission denied login box" => "permission denied login box",
// "permission denied url" => "permission denied url",
// "feature intertiki" => "feature intertiki",
// "feature intertiki server" => "feature intertiki server",
// "feature intertiki slavemode" => "feature intertiki slavemode",
// "interlist" => "interlist",
// "feature intertiki mymaster" => "feature intertiki mymaster",
// "feature intertiki import preferences" => "feature intertiki import preferences",
// "feature intertiki import groups" => "feature intertiki import groups",
// "known hosts" => "known hosts",
// "tiki key" => "tiki key",
// "intertiki logfile" => "intertiki logfile",
// "intertiki errfile" => "intertiki errfile",
// "feature intertiki sharedcookie" => "feature intertiki sharedcookie",
// "search lru length" => "search lru length",
// "search lru purge rate" => "search lru purge rate",
// "search max syllwords" => "search max syllwords",
// "search min wordlength" => "search min wordlength",
// "search refresh rate" => "search refresh rate",
// "search syll age" => "search syll age",
// "feature categories" => "feature categories",
// "feature categoryobjects" => "feature categoryobjects",
// "feature categorypath" => "feature categorypath",
// "feature category reinforce" => "feature category reinforce",
// "feature category use phplayers" => "feature category use phplayers",
// "categorypath excluded" => "categorypath excluded",
// "categories used in tpl" => "categories used in tpl",
// "category jail" => "category jail",
// "expanded category jail" => "expanded category jail",
// "expanded category jail key" => "expanded category jail key",
// "feature html pages" => "feature html pages",
// "feature filegals manager" => "feature filegals manager",
// "feature contact" => "feature contact",
// "contact user" => "contact user",
// "contact anon" => "contact anon",
// "mail crlf" => "mail crlf",
// "feature detect language" => "feature detect language",
// "feature homePage if bl missing" => "feature homePage if bl missing",
// "record untranslated" => "record untranslated",
// "feature best language" => "feature best language",
// "feature translation" => "feature translation",
// "feature urgent translation" => "feature urgent translation",
// "feature translation incomplete notice" => "feature translation incomplete notice",
// "lang use db" => "lang use db",
// "language" => "language",
// "feature babelfish" => "feature babelfish",
// "feature babelfish logo" => "feature babelfish logo",
// "quantify changes" => "quantify changes",
// "feature sync language" => "feature sync language",
// "show available translations" => "show available translations",
// "language inclusion threshold" => "language inclusion threshold",
// "metatag keywords" => "metatag keywords",
// "metatag threadtitle" => "metatag threadtitle",
// "metatag imagetitle" => "metatag imagetitle",
// "metatag freetags" => "metatag freetags",
// "metatag description" => "metatag description",
// "metatag pagedesc" => "metatag pagedesc",
// "metatag author" => "metatag author",
// "metatag geoposition" => "metatag geoposition",
// "metatag georegion" => "metatag georegion",
// "metatag geoplacename" => "metatag geoplacename",
// "metatag robots" => "metatag robots",
// "metatag revisitafter" => "metatag revisitafter",
// "head extra js" => "head extra js",
// "keep versions" => "keep versions",
// "feature custom home" => "feature custom home",
// "site crumb seper" => "site crumb seper",
// "site nav seper" => "site nav seper",
// "feature sitemycode" => "feature sitemycode",
// "sitemycode" => "sitemycode",
// "sitemycode publish" => "sitemycode publish",
// "feature sitelogo" => "feature sitelogo",
// "sitelogo bgcolor" => "sitelogo bgcolor",
// "sitelogo bgstyle" => "sitelogo bgstyle",
// "sitelogo align" => "sitelogo align",
// "sitelogo title" => "sitelogo title",
// "sitelogo src" => "sitelogo src",
// "sitelogo alt" => "sitelogo alt",
// "feature siteloc" => "feature siteloc",
// "feature sitenav" => "feature sitenav",
// "sitenav" => "sitenav",
// "feature sitead" => "feature sitead",
// "sitead" => "sitead",
// "sitead publish" => "sitead publish",
// "feature breadcrumbs" => "feature breadcrumbs",
// "feature siteloclabel" => "feature siteloclabel",
// "feature sitesearch" => "feature sitesearch",
// "feature site login" => "feature site login",
// "feature sitemenu" => "feature sitemenu",
// "feature topbar version" => "feature topbar version",
// "feature topbar debug" => "feature topbar debug",
// "feature topbar id menu" => "feature topbar id menu",
// "feature topbar custom code" => "feature topbar custom code",
// "feature sitetitle" => "feature sitetitle",
// "feature sitedesc" => "feature sitedesc",
// "feature bot logo" => "feature bot logo",
// "feature endbody code" => "feature endbody code",
// "feature custom html head content" => "feature custom html head content",
// "users prefs theme" => "users prefs theme",
// "feature left column" => "feature left column",
// "feature right column" => "feature right column",
// "feature top bar" => "feature top bar",
// "feature bot bar" => "feature bot bar",
// "feature bot bar icons" => "feature bot bar icons",
// "feature bot bar debug" => "feature bot bar debug",
// "feature bot bar rss" => "feature bot bar rss",
// "feature bot bar power by tw" => "feature bot bar power by tw",
// "maxRecords" => "maxRecords",
// "maxArticles" => "maxArticles",
// "maxVersions" => "maxVersions",
// "feature view tpl" => "feature view tpl",
// "slide style" => "slide style",
// "site favicon" => "site favicon",
// "site favicon type" => "site favicon type",
// "style" => "style",
// "style option" => "style option",
// "site style" => "site style",
// "site style option" => "site style option",
// "use context menu icon" => "use context menu icon",
// "use context menu text" => "use context menu text",
// "feature site report" => "feature site report",
// "feature site send link" => "feature site send link",
// "feature layoutshadows" => "feature layoutshadows",
// "main shadow start" => "main shadow start",
// "main shadow end" => "main shadow end",
// "header shadow start" => "header shadow start",
// "header shadow end" => "header shadow end",
// "middle shadow start" => "middle shadow start",
// "middle shadow end" => "middle shadow end",
// "center shadow start" => "center shadow start",
// "center shadow end" => "center shadow end",
// "footer shadow start" => "footer shadow start",
// "footer shadow end" => "footer shadow end",
// "box shadow start" => "box shadow start",
// "box shadow end" => "box shadow end",
// "feature custom center column header" => "feature custom center column header",
// "feature mods provider" => "feature mods provider",
// "mods dir" => "mods dir",
// "mods server" => "mods server",
// "feature experimental" => "feature experimental",
// "feature actionlog" => "feature actionlog",
// "feature actionlog bytes" => "feature actionlog bytes",
// "browsertitle" => "browsertitle",
// "site title location" => "site title location",
// "site title breadcrumb" => "site title breadcrumb",
// "tmpDir" => "tmpDir",
// "feature tell a friend" => "feature tell a friend",
// "feature copyright" => "feature copyright",
// "feature multimedia" => "feature multimedia",
// "feature smileys" => "feature smileys",
// "popupLinks" => "popupLinks",
// "feature autolinks" => "feature autolinks",
// "default rows textarea wiki" => "default rows textarea wiki",
// "default rows textarea comment" => "default rows textarea comment",
// "default rows textarea forum" => "default rows textarea forum",
// "default rows textarea forumthread" => "default rows textarea forumthread",
// "section comments parse" => "section comments parse",
// "toolbar global" => "toolbar global",
// "toolbar global comments" => "toolbar global comments",
// "direct pagination" => "direct pagination",
// "nextprev pagination" => "nextprev pagination",
// "pagination firstlast" => "pagination firstlast",
// "pagination hide if one page" => "pagination hide if one page",
// "pagination icons" => "pagination icons",
// "pagination fastmove links" => "pagination fastmove links",
// "direct pagination max middle links" => "direct pagination max middle links",
// "direct pagination max ending links" => "direct pagination max ending links",
// "feature kaltura" => "feature kaltura",
// "wikiplugin kaltura" => "wikiplugin kaltura",
// "wikiplugininline kaltura" => "wikiplugininline kaltura",
// "default kaltura editor" => "default kaltura editor",
// "partnerId" => "partnerId",
// "secret" => "secret",
// "adminSecret" => "adminSecret",
// "kdpUIConf" => "kdpUIConf",
// "kdpWidget" => "kdpWidget",
// "kcwUIConf" => "kcwUIConf",
// "kseUIConf" => "kseUIConf",
// "kaeUIConf" => "kaeUIConf",
// "anonCanEdit" => "anonCanEdit",
// "cacheimages" => "cacheimages",
// "cachepages" => "cachepages",
// "count admin pvs" => "count admin pvs",
// "default mail charset" => "default mail charset",
// "error reporting adminonly" => "error reporting adminonly",
// "error reporting level" => "error reporting level",
// "smarty notice reporting" => "smarty notice reporting",
// "smarty security" => "smarty security",
// "feature htmlpurifier output" => "feature htmlpurifier output",
// "feature ajax" => "feature ajax",
// "feature ajax autosave" => "feature ajax autosave",
// "feature antibot" => "feature antibot",
// "feature banners" => "feature banners",
// "feature banning" => "feature banning",
// "feature comm" => "feature comm",
// "feature contribution" => "feature contribution",
// "feature contribution display in comment" => "feature contribution display in comment",
// "feature contribution mandatory" => "feature contribution mandatory",
// "feature contribution mandatory blog" => "feature contribution mandatory blog",
// "feature contribution mandatory comment" => "feature contribution mandatory comment",
// "feature contribution mandatory forum" => "feature contribution mandatory forum",
// "feature debug console" => "feature debug console",
// "feature debugger console" => "feature debugger console",
// "feature display my to others" => "feature display my to others",
// "feature dynamic content" => "feature dynamic content",
// "feature edit templates" => "feature edit templates",
// "feature editcss" => "feature editcss",
// "feature events" => "feature events",
// "feature friends" => "feature friends",
// "feature fullscreen" => "feature fullscreen",
// "feature help" => "feature help",
// "feature hotwords" => "feature hotwords",
// "feature hotwords nw" => "feature hotwords nw",
// "feature integrator" => "feature integrator",
// "feature live support" => "feature live support",
// "feature mailin" => "feature mailin",
// "feature menusfolderstyle" => "feature menusfolderstyle",
// "feature mobile" => "feature mobile",
// "feature modulecontrols" => "feature modulecontrols",
// "feature morcego" => "feature morcego",
// "feature multilingual" => "feature multilingual",
// "feature multilingual one page" => "feature multilingual one page",
// "feature multilingual structures" => "feature multilingual structures",
// "feature machine translation" => "feature machine translation",
// "feature newsletters" => "feature newsletters",
// "feature obzip" => "feature obzip",
// "feature perspective" => "feature perspective",
// "feature phplayers" => "feature phplayers",
// "feature cssmenus" => "feature cssmenus",
// "feature projects" => "feature projects",
// "feature ranking" => "feature ranking",
// "feature redirect on error" => "feature redirect on error",
// "feature referer highlight" => "feature referer highlight",
// "feature referer stats" => "feature referer stats",
// "feature score" => "feature score",
// "feature sheet" => "feature sheet",
// "feature shoutbox" => "feature shoutbox",
// "feature source" => "feature source",
// "feature stats" => "feature stats",
// "feature tabs" => "feature tabs",
// "feature theme control" => "feature theme control",
// "feature ticketlib" => "feature ticketlib",
// "feature ticketlib2" => "feature ticketlib2",
// "feature top banner" => "feature top banner",
// "feature usability" => "feature usability",
// "feature use quoteplugin" => "feature use quoteplugin",
// "feature user watches" => "feature user watches",
// "feature group watches" => "feature group watches",
// "feature user watches translations" => "feature user watches translations",
// "feature daily report watches" => "feature daily report watches",
// "feature quick object perms" => "feature quick object perms",
// "feature xmlrpc" => "feature xmlrpc",
// "helpurl" => "helpurl",
// "layout section" => "layout section",
// "limitedGoGroupHome" => "limitedGoGroupHome",
// "minical reminders" => "minical reminders",
// "modallgroups" => "modallgroups",
// "modseparateanon" => "modseparateanon",
// "php docroot" => "php docroot",
// "proxy host" => "proxy host",
// "proxy port" => "proxy port",
// "ip can be checked" => "ip can be checked",
// "sender email" => "sender email",
// "feature site report email" => "feature site report email",
// "session storage" => "session storage",
// "session lifetime" => "session lifetime",
// "session silent" => "session silent",
// "session cookie name" => "session cookie name",
// "shoutbox autolink" => "shoutbox autolink",
// "show comzone" => "show comzone",
// "tikiIndex" => "tikiIndex",
// "urlIndex" => "urlIndex",
// "useGroupHome" => "useGroupHome",
// "useGroupTheme" => "useGroupTheme",
// "useUrlIndex" => "useUrlIndex",
// "use proxy" => "use proxy",
// "user list order" => "user list order",
// "webserverauth" => "webserverauth",
// "feature purifier" => "feature purifier",
// "feature shadowbox" => "feature shadowbox",
// "log sql" => "log sql",
// "log sql perf min" => "log sql perf min",
// "log mail" => "log mail",
// "log tpl" => "log tpl",
// "case patched" => "case patched",
// "site closed" => "site closed",
// "site closed msg" => "site closed msg",
// "use load threshold" => "use load threshold",
// "load threshold" => "load threshold",
// "site busy msg" => "site busy msg",
// "bot logo code" => "bot logo code",
// "feature blogposts pings" => "feature blogposts pings",
// "feature create webhelp" => "feature create webhelp",
// "page n times in a structure" => "page n times in a structure",
// "feature forums search" => "feature forums search",
// "feature trackbackpings" => "feature trackbackpings",
// "feature wiki ext icon" => "feature wiki ext icon",
// "feature wiki mandatory category" => "feature wiki mandatory category",
// "feature intertiki imported groups" => "feature intertiki imported groups",
// "feature wiki history ip" => "feature wiki history ip",
// "pam create user tiki" => "pam create user tiki",
// "pam service" => "pam service",
// "pam skip admin" => "pam skip admin",
// "shib affiliation" => "shib affiliation",
// "shib create user tiki" => "shib create user tiki",
// "shib group" => "shib group",
// "shib skip admin" => "shib skip admin",
// "shib usegroup" => "shib usegroup",
// "wiki 3d camera distance" => "wiki 3d camera distance",
// "wiki 3d elastic constant" => "wiki 3d elastic constant",
// "wiki 3d eletrostatic constant" => "wiki 3d eletrostatic constant",
// "wiki 3d fov" => "wiki 3d fov",
// "wiki 3d friction constant" => "wiki 3d friction constant",
// "wiki 3d node charge" => "wiki 3d node charge",
// "wiki 3d node mass" => "wiki 3d node mass",
// "wiki 3d node size" => "wiki 3d node size",
// "wiki 3d spring size" => "wiki 3d spring size",
// "wiki 3d text size" => "wiki 3d text size",
// "articles feature copyrights" => "articles feature copyrights",
// "blogues feature copyrights" => "blogues feature copyrights",
// "faqs feature copyrights" => "faqs feature copyrights",
// "feature contributor wiki" => "feature contributor wiki",
// "https login required" => "https login required",
// "maxRowsGalleries" => "maxRowsGalleries",
// "replimaster" => "replimaster",
// "rowImagesGalleries" => "rowImagesGalleries",
// "scaleSizeGalleries" => "scaleSizeGalleries",
// "thumbSizeXGalleries" => "thumbSizeXGalleries",
// "thumbSizeYGalleries" => "thumbSizeYGalleries",
// "wiki 3d adjust camera" => "wiki 3d adjust camera",
// "wiki 3d autoload" => "wiki 3d autoload",
// "javascript enabled" => "javascript enabled",
// "feature comments post as anonymous" => "feature comments post as anonymous",
// "feature comments moderation" => "feature comments moderation",
// "feature comments locking" => "feature comments locking",
// "feature template zoom" => "feature template zoom",
// "menus items icons" => "menus items icons",
// "menus items icons path" => "menus items icons path",
// "feature iepngfix" => "feature iepngfix",
// "iepngfix selectors" => "iepngfix selectors",
// "iepngfix elements" => "iepngfix elements",
// "valid email regex" => "valid email regex",
// "feature jquery" => "feature jquery",
// "jquery effect" => "jquery effect",
// "jquery effect direction" => "jquery effect direction",
// "jquery effect speed" => "jquery effect speed",
// "jquery effect tabs" => "jquery effect tabs",
// "jquery effect tabs direction" => "jquery effect tabs direction",
// "jquery effect tabs speed" => "jquery effect tabs speed",
// "feature jquery ui" => "feature jquery ui",
// "feature jquery ui theme" => "feature jquery ui theme",
// "feature jquery tooltips" => "feature jquery tooltips",
// "feature jquery autocomplete" => "feature jquery autocomplete",
// "feature jquery superfish" => "feature jquery superfish",
// "feature jquery reflection" => "feature jquery reflection",
// "feature jquery sheet" => "feature jquery sheet",
// "feature jquery tablesorter" => "feature jquery tablesorter",
// "feature jquery cycle" => "feature jquery cycle",
// "feature sefurl" => "feature sefurl",
// "feature sefurl filter" => "feature sefurl filter",
// "feature sefurl paths" => "feature sefurl paths",
// "feature sefurl title article" => "feature sefurl title article",
// "feature sefurl title blog" => "feature sefurl title blog",
// "feature wiki screencasts" => "feature wiki screencasts",
// "feature wiki screencasts base" => "feature wiki screencasts base",
// "feature wiki screencasts httpbase" => "feature wiki screencasts httpbase",
// "feature wiki screencasts upload type" => "feature wiki screencasts upload type",
// "feature wiki screencasts user" => "feature wiki screencasts user",
// "feature wiki screencasts pass" => "feature wiki screencasts pass",
// "feature wiki screencasts max size" => "feature wiki screencasts max size",
// "feature tikitests" => "feature tikitests",
// "profile sources" => "profile sources",
// "profile channels" => "profile channels",
// "feature minichat" => "feature minichat",
// "memcache enabled" => "memcache enabled",
// "memcache flags" => "memcache flags",
// "memcache servers" => "memcache servers",
// "memcache expiration" => "memcache expiration",
// "memcache prefix" => "memcache prefix",
// "memcache wiki data" => "memcache wiki data",
// "memcache wiki output" => "memcache wiki output",
// "memcache forum output" => "memcache forum output",
// "feature pear date" => "feature pear date",
// "feature bidi" => "feature bidi",
// "feature lastup" => "feature lastup",
// "magic last load" => "magic last load",
// "feature groupalert" => "feature groupalert",
// "zend mail handler" => "zend mail handler",
// "zend mail smtp server" => "zend mail smtp server",
// "zend mail smtp auth" => "zend mail smtp auth",
// "zend mail smtp user" => "zend mail smtp user",
// "zend mail smtp pass" => "zend mail smtp pass",
// "zend mail smtp port" => "zend mail smtp port",
// "zend mail smtp security" => "zend mail smtp security",
// "feature group transition" => "feature group transition",
// "feature category transition" => "feature category transition",
// "terminology profile installed" => "terminology profile installed",
// "multidomain active" => "multidomain active",
// "multidomain config" => "multidomain config",
// "feature use minified scripts" => "feature use minified scripts",
// "tiki minify javascript" => "tiki minify javascript",
// "lib spellcheck" => "lib spellcheck",
// "wiki spellcheck" => "wiki spellcheck",
// "blog spellcheck" => "blog spellcheck",
// "allowMsgs" => "allowMsgs",
// "diff versions" => "diff versions",
// "display timezone" => "display timezone",
// "email is public" => "email is public",
// "homePage" => "homePage",
// "lat" => "lat",
// "lon" => "lon",
// "mess archiveAfter" => "mess archiveAfter",
// "mess maxRecords" => "mess maxRecords",
// "mess sendReadStatus" => "mess sendReadStatus",
// "minPrio" => "minPrio",
// "mytiki blogs" => "mytiki blogs",
// "mytiki articles" => "mytiki articles",
// "mytiki gals" => "mytiki gals",
// "mytiki items" => "mytiki items",
// "mytiki msgs" => "mytiki msgs",
// "mytiki pages" => "mytiki pages",
// "mytiki tasks" => "mytiki tasks",
// "mytiki forum topics" => "mytiki forum topics",
// "mytiki forum replies" => "mytiki forum replies",
// "realName" => "realName",
// "gender" => "gender",
// "show mouseover user info" => "show mouseover user info",
// "tasks maxRecords" => "tasks maxRecords",
// "user dbl" => "user dbl",
// "user information" => "user information",
// "mailCharset" => "mailCharset",
// "mailCurrentAccount" => "mailCurrentAccount",
// "Anti-Bot verification code" => "Anti-Bot verification code",
// "Random Image" => "Random Image",
// "Enter the code you see above" => "Enter the code you see above",
// "more info" => "more info",
// "Click Here to Insert in Wiki Syntax" => "Click Here to Insert in Wiki Syntax",
// "Select Categories" => "Select Categories",
// "Admin Categories" => "Admin Categories",
// "Select/deselect all categories" => "Select/deselect all categories",
// "No categories defined" => "No categories defined",
// "Browse Category" => "Browse Category",
// "top of page" => "top of page",
// "Reply" => "Reply",
// "Report this post" => "Report this post",
// "Group Monitor" => "Group Monitor",
// "Watched by categories" => "Watched by categories",
// "Errors" => "Errors",
// "Move" => "Move",
// "Comments Locked" => "Comments Locked",
// "below your current threshold" => "below your current threshold",
// "Comments are locked" => "Comments are locked",
// "Note" => "Note",
// "New Reply" => "New Reply",
// "Editing reply" => "Editing reply",
// "Reply to the selected post" => "Reply to the selected post",
// "Post new message" => "Post new message",
// "Comment on the selected post" => "Comment on the selected post",
// "required" => "required",
// "Toolbars" => "Toolbars",
// "Maximum size" => "Maximum size",
// "Enter your name" => "Enter your name",
// "optional" => "optional",
// "If you would like to be notified when someone replies to this topic<br />please tell us your e-mail address" => "If you would like to be notified when someone replies to this topic<br />please tell us your e-mail address",
// "Reply to parent post" => "Reply to parent post",
// "Post new reply" => "Post new reply",
// "Please note that the preview does not keep the attached file which you will have to choose before posting" => "Please note that the preview does not keep the attached file which you will have to choose before posting",
// "Post as Anonymous" => "Post as Anonymous",
// "Your comment will have to be approved by the moderator before it is displayed" => "Your comment will have to be approved by the moderator before it is displayed",
// "Posting replies" => "Posting replies",
// "Type of contribution" => "Type of contribution",
// "Contributors" => "Contributors",
// "System error" => "System error",
// "Database is not currently up to date! Visit <a href=\"tiki-install.php\">Tiki Installer</a> to resolve this issue" => "Database is not currently up to date! Visit <a href=\"tiki-install.php\">Tiki Installer</a> to resolve this issue",
// "If you have shell (SSH) access, you can also use the following, on the command line, from the root of your Tiki installation" => "If you have shell (SSH) access, you can also use the following, on the command line, from the root of your Tiki installation",
// "The query was" => "The query was",
// "The built query was likely" => "The built query was likely",
// "Stacktrace" => "Stacktrace",
// "Duplicate File Gallery" => "Duplicate File Gallery",
// "File gallery" => "File gallery",
// "Duplicate categories" => "Duplicate categories",
// "Duplicate permissions" => "Duplicate permissions",
// "View inserted gallery" => "View inserted gallery",
// "System" => "System",
// "Any file" => "Any file",
// "Podcast (audio)" => "Podcast (audio)",
// "Podcast (video)" => "Podcast (video)",
// "Gallery is visible to non-admin users" => "Gallery is visible to non-admin users",
// "Gallery is public" => "Gallery is public",
// "Any user with permission (not only the gallery owner) can upload files" => "Any user with permission (not only the gallery owner) can upload files",
// "Files can be locked at download" => "Files can be locked at download",
// "Maximum number of archives for each file" => "Maximum number of archives for each file",
// "unlimited" => "unlimited",
// "Parent gallery" => "Parent gallery",
// "Owner of the gallery" => "Owner of the gallery",
// "Quota" => "Quota",
// "Used" => "Used",
// "Min" => "Min",
// "Group of users alerted when file gallery is modified" => "Group of users alerted when file gallery is modified",
// "Allows to select each user for small groups" => "Allows to select each user for small groups",
// "Display Properties" => "Display Properties",
// "Default sort order" => "Default sort order",
// "Descending" => "Descending",
// "Ascending" => "Ascending",
// "Max rows per page" => "Max rows per page",
// "Select which items to display when listing galleries" => "Select which items to display when listing galleries",
// "Please login" => "Please login",
// "Perhaps you are looking for" => "Perhaps you are looking for",
// "There are no wiki pages similar to '{\$page}'" => "There are no wiki pages similar to '{\$page}'",
// "Go to Login Page" => "Go to Login Page",
// "Create this page" => "Create this page",
// "(page will be orphaned)" => "(page will be orphaned)",
// "Close Window" => "Close Window",
// "Go to" => "Go to",
// "Private Gallery" => "Private Gallery",
// "Active Perms" => "Active Perms",
// "Archives" => "Archives",
// "Upload New Version" => "Upload New Version",
// "Replace" => "Replace",
// "Download and lock" => "Download and lock",
// "The checkbox is disabled because this preference is disabled globally" => "The checkbox is disabled because this preference is disabled globally",
// "Please, enable the preference globally first" => "Please, enable the preference globally first",
// "You can ask your site Admin to enable the preference" => "You can ask your site Admin to enable the preference",
// "Show as a column" => "Show as a column",
// "Show in popup box" => "Show in popup box",
// "Show an icon in a column" => "Show an icon in a column",
// "Start the Slideshow" => "Start the Slideshow",
// "Pause the Slideshow" => "Pause the Slideshow",
// "Exact&nbsp;match" => "Exact&nbsp;match",
// "any type" => "any type",
// "all topic" => "all topic",
// "any language" => "any language",
// "not in" => "not in",
// "any category" => "any category",
// "Go" => "Go",
// "Clear Filter" => "Clear Filter",
// "Show php error messages" => "Show php error messages",
// "Folksonomy Tags" => "Folksonomy Tags",
// "Put tags separated by spaces. For tags with more than one word, use no spaces and put words together or enclose them with double quotes" => "Put tags separated by spaces. For tags with more than one word, use no spaces and put words together or enclose them with double quotes",
// "Tags" => "Tags",
// "Translate tags" => "Translate tags",
// "Images Galleries" => "Images Galleries",
// "RSS Wiki" => "RSS Wiki",
// "RSS Blogs" => "RSS Blogs",
// "RSS Articles" => "RSS Articles",
// "RSS Image Galleries" => "RSS Image Galleries",
// "RSS File Galleries" => "RSS File Galleries",
// "RSS Forums" => "RSS Forums",
// "RSS Maps" => "RSS Maps",
// "RSS Directories" => "RSS Directories",
// "RSS Calendars" => "RSS Calendars",
// "Show Tree" => "Show Tree",
// "Hide Tree" => "Hide Tree",
// "Perform action with checked" => "Perform action with checked",
// "Are you sure you want to delete the selected files" => "Are you sure you want to delete the selected files",
// "Download the zip" => "Download the zip",
// "Assign Permissions" => "Assign Permissions",
// "Other Sorts" => "Other Sorts",
// "No Additionnal Sort" => "No Additionnal Sort",
// "No information" => "No information",
// "To validate your account and login to the site, please click on the following link" => "To validate your account and login to the site, please click on the following link",
// "The administrator approved your account" => "The administrator approved your account",
// "Confirm your email at %s" => "Confirm your email at %s",
// "A new topic was posted to forum" => "A new topic was posted to forum",
// "New topic" => "New topic",
// "You are invited by" => "You are invited by",
// "You join this group" => "You join this group",
// "Join me on %s" => "Join me on %s",
// "You sent a request with the subject" => "You sent a request with the subject",
// "Use the subject to indicate the operation to apply" => "Use the subject to indicate the operation to apply",
// "GET:WikiName to get a wiki page" => "GET:WikiName to get a wiki page",
// "PUT:WikiName to update/create a wiki page (use the body for the page data)" => "PUT:WikiName to update/create a wiki page (use the body for the page data)",
// "APPEND:WikiName to append data to a Wiki page (use the body for the data to add)" => "APPEND:WikiName to append data to a Wiki page (use the body for the data to add)",
// "PREPEND:WikiName to append the data at the top" => "PREPEND:WikiName to append the data at the top",
// "Tiki mail-in auto-reply" => "Tiki mail-in auto-reply",
// "Page not found" => "Page not found",
// "New message arrived from %s" => "New message arrived from %s",
// "Your account registration request for {\$mail_site} was validated by the site admin and your account is active now" => "Your account registration request for {\$mail_site} was validated by the site admin and your account is active now",
// "To login with your username and password, please follow this link" => "To login with your username and password, please follow this link",
// "User Account Activated" => "User Account Activated",
// "{\$mail_user} <{\$mail_email}> has requested a new password on {\$mail_site}, but you need to validate his account first" => "{\$mail_user} <{\$mail_email}> has requested a new password on {\$mail_site}, but you need to validate his account first",
// "has requested an account on" => "has requested an account on",
// "To validate that account, please follow the link" => "To validate that account, please follow the link",
// "Assign to a group" => "Assign to a group",
// "Best regards" => "Best regards",
// "User Tracker" => "User Tracker",
// "User Registration Request" => "User Registration Request",
// "Go to your friendship network to accept or refuse this request" => "Go to your friendship network to accept or refuse this request",
// "You're invited to join my network of friends" => "You're invited to join my network of friends",
// "Bye bye from %s at %s" => "Bye bye from %s at %s",
// "Welcome to %s at %s" => "Welcome to %s at %s",
// "Someone" => "Someone",
// "requested a reminder of the password for your account" => "requested a reminder of the password for your account",
// "requested password reset for your account" => "requested password reset for your account",
// "Since this is your registered email address we inform that the password for this account is" => "Since this is your registered email address we inform that the password for this account is",
// "Please click on the following link to confirm you wish to reset your password and go to the screen where you must enter a new \"permanent\" password. Please pick a password only you will know, and don't share it with anyone else" => "Please click on the following link to confirm you wish to reset your password and go to the screen where you must enter a new \"permanent\" password. Please pick a password only you will know, and don't share it with anyone else",
// "Important: Username & password are CaSe SenSitiVe" => "Important: Username & password are CaSe SenSitiVe",
// "Important: The old password remains active if you don't click the link above" => "Important: The old password remains active if you don't click the link above",
// "Your account information for %s" => "Your account information for %s",
// "Report for" => "Report for",
// "Last Report sent on" => "Last Report sent on",
// "Changes in detail" => "Changes in detail",
// "New article submitted at %s" => "New article submitted at %s",
// "Look at this link" => "Look at this link",
// "A friend sends you a link from: " => "A friend sends you a link from: ",
// "ItemID {\$mail_itemId} was deleted in the tracker {\$mail_trackerName}" => "ItemID {\$mail_itemId} was deleted in the tracker {\$mail_trackerName}",
// "New status ItemID {\$mail_itemId} for the tracker {\$mail_trackerName}" => "New status ItemID {\$mail_itemId} for the tracker {\$mail_trackerName}",
// "Download the file at" => "Download the file at",
// "Tracker was modified at" => "Tracker was modified at",
// "Please visit this link before login again" => "Please visit this link before login again",
// "Last attempt" => "Last attempt",
// "IP" => "IP",
// "Confirm your account at %s" => "Confirm your account at %s",
// "An administrator of the site below has added you as a new user" => "An administrator of the site below has added you as a new user",
// "If you want to confirm your membership in this site, click on the following link to login for the first time" => "If you want to confirm your membership in this site, click on the following link to login for the first time",
// "Your authentication credentials are" => "Your authentication credentials are",
// "Welcome on the site" => "Welcome on the site",
// "Your personal access to" => "Your personal access to",
// "Your account request has been stored and will be activated by the admin as soon as possible" => "Your account request has been stored and will be activated by the admin as soon as possible",
// "You'll receive email notification once your account is activated" => "You'll receive email notification once your account is activated",
// "Please do not attempt to login until you receive the email notification" => "Please do not attempt to login until you receive the email notification",
// "{\$mail_action} article post" => "{\$mail_action} article post",
// "{\$mail_title} by {\$mail_user} at" => "{\$mail_title} by {\$mail_user} at",
// "New article post" => "New article post",
// "Edited article post" => "Edited article post",
// "Deleted article post" => "Deleted article post",
// "View the article at" => "View the article at",
// "{\$mail_action} article post at" => "{\$mail_action} article post at",
// "New blog post: {\$mail_title}, \"{\$mail_post_title}\", by {\$mail_user|username} at {\$mail_date|tiki_short_datetime}" => "New blog post: {\$mail_title}, \"{\$mail_post_title}\", by {\$mail_user|username} at {\$mail_date|tiki_short_datetime}",
// "New blog post at %s" => "New blog post at %s",
// "View item calendar at" => "View item calendar at",
// "Modified calendar item" => "Modified calendar item",
// "New calendar item" => "New calendar item",
// "A new category was created in" => "A new category was created in",
// "A category was removed in" => "A category was removed in",
// "Removed by" => "Removed by",
// "removed" => "removed",
// "A category was updated" => "A category was updated",
// "Updated by" => "Updated by",
// "Old" => "Old",
// "New" => "New",
// "updated" => "updated",
// "File Gallery %s changed" => "File Gallery %s changed",
// "A file was removed from the file gallery" => "A file was removed from the file gallery",
// "File Name" => "File Name",
// "A new file was posted to file gallery" => "A new file was posted to file gallery",
// "Posted by" => "Posted by",
// "New forum topic in <{\$mail_forum|truncate:20:\"...\"}> by {\$mail_author}" => "New forum topic in <{\$mail_forum|truncate:20:\"...\"}> by {\$mail_author}",
// "New forum post in <{\$mail_forum|truncate:20:\"...\"}> by {\$mail_author}" => "New forum post in <{\$mail_forum|truncate:20:\"...\"}> by {\$mail_author}",
// "Image Gallery {\$galleryName} changed" => "Image Gallery {\$galleryName} changed",
// "A new file was posted to image gallery" => "A new file was posted to image gallery",
// "The map {\$mail_page} was changed by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "The map {\$mail_page} was changed by {\$mail_user} at {\$mail_date|tiki_short_datetime}",
// "You can view the updated map following this link" => "You can view the updated map following this link",
// "You can edit the map following this link" => "You can edit the map following this link",
// "An object was added to category" => "An object was added to category",
// "Added by" => "Added by",
// "An object was removed from category" => "An object was removed from category",
// "A page has been added to your watched sub-structure" => "A page has been added to your watched sub-structure",
// "A page has been removed from your watched sub-structure" => "A page has been removed from your watched sub-structure",
// "A page has been promoted out your watched sub-structure" => "A page has been promoted out your watched sub-structure",
// "A page has been demoted to your watched structure" => "A page has been demoted to your watched structure",
// "Structure modified" => "Structure modified",
// "A new file have been attached to page" => "A new file have been attached to page",
// "File name" => "File name",
// "New attachment on %s, page" => "New attachment on %s, page",
// "The page {\$mail_page} was created by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "The page {\$mail_page} was created by {\$mail_user} at {\$mail_date|tiki_short_datetime}",
// "The page {\$mail_page} was deleted by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "The page {\$mail_page} was deleted by {\$mail_user} at {\$mail_date|tiki_short_datetime}",
// "A file was attached to {\$mail_page}" => "A file was attached to {\$mail_page}",
// "The page {\$mail_page} was deleted but used to be here" => "The page {\$mail_page} was deleted but used to be here",
// "You can view the page by following this link" => "You can view the page by following this link",
// "You can view a diff back to the previous version by following this link" => "You can view a diff back to the previous version by following this link",
// "The changes in this version follow below, followed after by the current full page text" => "The changes in this version follow below, followed after by the current full page text",
// "-Lines: {\$oldd} changed to +Lines: {\$newd}" => "-Lines: {\$oldd} changed to +Lines: {\$newd}",
// "The old page content follows below" => "The old page content follows below",
// "The new page content follows below" => "The new page content follows below",
// "Wiki page %s created by {\$mail_user}" => "Wiki page %s created by {\$mail_user}",
// "Wiki page %s deleted by {\$mail_user}" => "Wiki page %s deleted by {\$mail_user}",
// "A file was attached to %s" => "A file was attached to %s",
// "Wiki page %s changed by {\$mail_user}" => "Wiki page %s changed by {\$mail_user}",
// "The page {\$mail_page} was commented by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "The page {\$mail_page} was commented by {\$mail_user} at {\$mail_date|tiki_short_datetime}",
// "Wiki page %s was commented on by" => "Wiki page %s was commented on by",
// "an anonymous user" => "an anonymous user",
// "Wiki page renamed" => "Wiki page renamed",
// "Old name" => "Old name",
// "Thank you for your registration. You may log in now" => "Thank you for your registration. You may log in now",
// "click on the map to zoom or pan, do not drag" => "click on the map to zoom or pan, do not drag",
// "Query Results" => "Query Results",
// "Querying" => "Querying",
// "Scroll Up" => "Scroll Up",
// "Scroll Down" => "Scroll Down",
// "Scale" => "Scale",
// "Zoom out" => "Zoom out",
// "Query" => "Query",
// "Pan" => "Pan",
// "Zoom in" => "Zoom in",
// "Redraw" => "Redraw",
// "select zoom/pan/query and image size" => "select zoom/pan/query and image size",
// "View the Map Only" => "View the Map Only",
// "Reset Map" => "Reset Map",
// "Click on the map or click redraw" => "Click on the map or click redraw",
// "Overview" => "Overview",
// "Legend" => "Legend",
// "Layer Manager" => "Layer Manager",
// "Layer" => "Layer",
// "On" => "On",
// "Download Layer" => "Download Layer",
// "This layer has been set by the maps administrator to not be downloadable" => "This layer has been set by the maps administrator to not be downloadable",
// "you have requested to download the layer" => "you have requested to download the layer",
// "from the mapfile" => "from the mapfile",
// "Here are the files to download, do not forget to rename them" => "Here are the files to download, do not forget to rename them",
// "Mapfiles" => "Mapfiles",
// "Mapfile" => "Mapfile",
// "Available mapfiles" => "Available mapfiles",
// "hits last 7 days" => "hits last 7 days",
// "monitor this map" => "monitor this map",
// "Stop Monitoring this Map" => "Stop Monitoring this Map",
// "Create a new mapfile" => "Create a new mapfile",
// "Create" => "Create",
// "Mapfile listing" => "Mapfile listing",
// "Reload" => "Reload",
// "You can view this map in your browser using" => "You can view this map in your browser using",
// "Zoom out x2" => "Zoom out x2",
// "Zoom in x2" => "Zoom in x2",
// "Mapfile History" => "Mapfile History",
// "Comparing version {\$old.version} with version {\$new.version}" => "Comparing version {\$old.version} with version {\$new.version}",
// "v=view" => "v=view",
// "c=compare" => "c=compare",
// "d=diff" => "d=diff",
// "Full side-by-side diff" => "Full side-by-side diff",
// "Unified diff" => "Unified diff",
// "Side-by-side view" => "Side-by-side view",
// "Older Version" => "Older Version",
// "Directories" => "Directories",
// "back to" => "back to",
// "Upload Files" => "Upload Files",
// "Bytes maximum" => "Bytes maximum",
// "Create Directory" => "Create Directory",
// "index file (.shp)" => "index file (.shp)",
// "files to index (regexp)" => "files to index (regexp)",
// "Message Archive" => "Message Archive",
// "messages" => "messages",
// "Archive is full" => "Archive is full",
// "Confirmation" => "Confirmation",
// "Please Confirm" => "Please Confirm",
// "If you want people to be able to reply to you, enable <a href='tiki-user_preferences.php'>Allow messages from other users</a> in your preferences" => "If you want people to be able to reply to you, enable <a href='tiki-user_preferences.php'>Allow messages from other users</a> in your preferences",
// "ERROR" => "ERROR",
// "No messages to download" => "No messages to download",
// "Mailbox is full! Delete or archive some messages if you want to receive more messages" => "Mailbox is full! Delete or archive some messages if you want to receive more messages",
// "is reply to" => "is reply to",
// "Find replied message" => "Find replied message",
// "Archive" => "Archive",
// "Auto-archive age for read messages" => "Auto-archive age for read messages",
// "Return to mailbox" => "Return to mailbox",
// "Unflag" => "Unflag",
// "Return to archive" => "Return to archive",
// "Return to outbox" => "Return to outbox",
// "Sent Messages" => "Sent Messages",
// "Replied" => "Replied",
// "Not replied" => "Not replied",
// "move to archive" => "move to archive",
// "receiver" => "receiver",
// "'name' parameter for tikimodule missed" => "'name' parameter for tikimodule missed",
// "Move module up" => "Move module up",
// "Move module down" => "Move module down",
// "Move module to opposite side" => "Move module to opposite side",
// "opp side" => "opp side",
// "Unassign this module" => "Unassign this module",
// "Are you sure you want to unassign this module" => "Are you sure you want to unassign this module",
// "Toggle module contents" => "Toggle module contents",
// "toggle" => "toggle",
// "Toggle Vertically" => "Toggle Vertically",
// "Display type unknown, you have to enter the banner type" => "Display type unknown, you have to enter the banner type",
// "You forgot your Google ad_client number " => "You forgot your Google ad_client number ",
// "More.." => "More..",
// "Thank you for installing Tikiwiki" => "Thank you for installing Tikiwiki",
// "To configure your Tiki" => "To configure your Tiki",
// "Select" => "Select",
// "Admin Home" => "Admin Home",
// "from the menu" => "from the menu",
// "Read the <a class=\"link\" href=\"http://doc.tikiwiki.org/Configuration\" title=\"Tikiwiki Documentation\" target=\"_blank\">configuration documentation</a>" => "Read the <a class=\"link\" href=\"http://doc.tikiwiki.org/Configuration\" title=\"Tikiwiki Documentation\" target=\"_blank\">configuration documentation</a>",
// "Watch the <a class=\"link\" href=\"http://tikiwiki.org/TikiMovies\" title=\"Demos\" target=\"_blank\">demo movies" => "Watch the <a class=\"link\" href=\"http://tikiwiki.org/TikiMovies\" title=\"Demos\" target=\"_blank\">demo movies",
// "To remove this module" => "To remove this module",
// "and remove the assistant module" => "and remove the assistant module",
// "You can also add other modules" => "You can also add other modules",
// "To customize the menu" => "To customize the menu",
// "and edit menu ID 42" => "and edit menu ID 42",
// "Or, create your own menu and add it to a module" => "Or, create your own menu and add it to a module",
// "To begin configuring Tiki, please" => "To begin configuring Tiki, please",
// "as admin" => "as admin",
// "The Tikiwiki Community" => "The Tikiwiki Community",
// "To learn more, visit: <a href=\"http://tikiwiki.org\" title=\"The Tikiwiki Community\" target=\"_blank\">http://tikiwiki.org</a>" => "To learn more, visit: <a href=\"http://tikiwiki.org\" title=\"The Tikiwiki Community\" target=\"_blank\">http://tikiwiki.org</a>",
// "Tikiwiki Documentation" => "Tikiwiki Documentation",
// "For help, visit <a href=\"http://doc.tikiwiki.org\" title=\"Tikiwiki Documentation\" target=\"_blank\">http://doc.tikiwiki.org</a>" => "For help, visit <a href=\"http://doc.tikiwiki.org\" title=\"Tikiwiki Documentation\" target=\"_blank\">http://doc.tikiwiki.org</a>",
// "on blogpost" => "on blogpost",
// "Add event" => "Add event",
// "Missing %0 of the following categories" => "Missing %0 of the following categories",
// "%0 extra of the following categories" => "%0 extra of the following categories",
// "Unknown comparison" => "Unknown comparison",
// "Impossible condition, %0 of" => "Impossible condition, %0 of",
// "Apply" => "Apply",
// "Assign into category" => "Assign into category",
// "Unassign category" => "Unassign category",
// "Tags This Page Has" => "Tags This Page Has",
// "Add tags" => "Add tags",
// "List everything tagged" => "List everything tagged",
// "All Groups" => "All Groups",
// "Your Groups" => "Your Groups",
// "Emulated Groups" => "Emulated Groups",
// "Switch to Groups" => "Switch to Groups",
// "Simulate" => "Simulate",
// "No records to display" => "No records to display",
// "insert original" => "insert original",
// "insert thumbnail" => "insert thumbnail",
// "more" => "more",
// "No avatar" => "No avatar",
// "You" => "You",
// "Logged in as" => "Logged in as",
// "Switch User" => "Switch User",
// "Enter user name and click 'Switch'.<br />Useful for testing permissions" => "Enter user name and click 'Switch'.<br />Useful for testing permissions",
// "Switch user" => "Switch user",
// "Login through CAS" => "Login through CAS",
// "Login as admin" => "Login as admin",
// "Login through Shibboleth" => "Login through Shibboleth",
// "Login as" => "Login as",
// "CapsLock is on" => "CapsLock is on",
// "year" => "year",
// "Click here to register" => "Click here to register",
// "Click here if you've forgotten your password" => "Click here if you've forgotten your password",
// "Click here to login using the default security protocol" => "Click here to login using the default security protocol",
// "Click here to login using a secure protocol" => "Click here to login using a secure protocol",
// "local account" => "local account",
// "OpenID Login" => "OpenID Login",
// "What is OpenID" => "What is OpenID",
// "Wiki feed" => "Wiki feed",
// "Feed" => "Feed",
// "Blogs feed" => "Blogs feed",
// "Articles feed" => "Articles feed",
// "Image Galleries feed" => "Image Galleries feed",
// "File Galleries feed" => "File Galleries feed",
// "Forums feed" => "Forums feed",
// "Maps feed" => "Maps feed",
// "Calendars" => "Calendars",
// "A leading plus sign indicates that this word must be present in every object returned" => "A leading plus sign indicates that this word must be present in every object returned",
// "A leading minus sign indicates that this word must not be present in any row returned" => "A leading minus sign indicates that this word must not be present in any row returned",
// "By default (when neither plus nor minus is specified) the word is optional, but the object that contain it will be rated higher" => "By default (when neither plus nor minus is specified) the word is optional, but the object that contain it will be rated higher",
// "These two operators are used to change a word's contribution to the relevance value that is assigned to a row" => "These two operators are used to change a word's contribution to the relevance value that is assigned to a row",
// "Parentheses are used to group words into subexpressions" => "Parentheses are used to group words into subexpressions",
// "A leading tilde acts as a negation operator, causing the word's contribution to the object relevance to be negative. It's useful for marking noise words. An object that contains such a word will be rated lower than others, but will not be excluded altogether, as it would be with the - operator" => "A leading tilde acts as a negation operator, causing the word's contribution to the object relevance to be negative. It's useful for marking noise words. An object that contains such a word will be rated lower than others, but will not be excluded altogether, as it would be with the - operator",
// "An asterisk is the truncation operator. Unlike the other operators, it should be appended to the word, not prepended" => "An asterisk is the truncation operator. Unlike the other operators, it should be appended to the word, not prepended",
// "The phrase, that is enclosed in double quotes &quot;, matches only objects that contain this phrase literally, as it was typed" => "The phrase, that is enclosed in double quotes &quot;, matches only objects that contain this phrase literally, as it was typed",
// "Advanced search" => "Advanced search",
// "Advanced Search Help" => "Advanced Search Help",
// "Page Relations" => "Page Relations",
// "Are you sure you want to delete this shout" => "Are you sure you want to delete this shout",
// "Shout date" => "Shout date",
// "Delete this shout" => "Delete this shout",
// "Edit this shout" => "Edit this shout",
// "New Tracker Items" => "New Tracker Items",
// "New Calendar Events" => "New Calendar Events",
// "Nothing has changed" => "Nothing has changed",
// "`\$module_params.prefix`" => "`\$module_params.prefix`",
// "Site Language" => "Site Language",
// "Site default" => "Site default",
// "Find term" => "Find term",
// "If not found, you will be given a chance to create it" => "If not found, you will be given a chance to create it",
// "TikiTests Menu" => "TikiTests Menu",
// "List Tests" => "List Tests",
// "Create Test" => "Create Test",
// "There are no translations of this page" => "There are no translations of this page",
// "Up-to-date-ness" => "Up-to-date-ness",
// "Better translations" => "Better translations",
// "update from it" => "update from it",
// "None match your" => "None match your",
// "Set your preferred languages" => "Set your preferred languages",
// "preferred languages" => "preferred languages",
// "Equivalent translations" => "Equivalent translations",
// "Translations that need improvement" => "Translations that need improvement",
// "update it" => "update it",
// "click to view" => "click to view",
// "select" => "select",
// "Group information" => "Group information",
// "You need to activate user and/or group trackers" => "You need to activate user and/or group trackers",
// "Webmail inbox" => "Webmail inbox",
// "Refresh (non-ajax)" => "Refresh (non-ajax)",
// "TAKE" => "TAKE",
// "View contact" => "View contact",
// "on host" => "on host",
// "User does not accept messages" => "User does not accept messages",
// "Send a message" => "Send a message",
// "More Videos" => "More Videos",
// "Changes that need to be reproduced are highlighted below" => "Changes that need to be reproduced are highlighted below",
// "[-]" => "[-]",
// "Use Ctrl+Click to select multiple options" => "Use Ctrl+Click to select multiple options",
// "Requires" => "Requires",
// "You need to set" => "You need to set",
// "Send Newsletter" => "Send Newsletter",
// "Insert/Edit an internal wiki link" => "Insert/Edit an internal wiki link",
// "Wiki Link insert" => "Wiki Link insert",
// "Please make a selection of text in order to create a link" => "Please make a selection of text in order to create a link",
// "Insert an image" => "Insert an image",
// "Tiki Image - Insert an image" => "Tiki Image - Insert an image",
// "Switch to normal (wiki) editor" => "Switch to normal (wiki) editor",
// "By" => "By",
// "Read more" => "Read more",
// "Do not group by item" => "Do not group by item",
// "Group by item" => "Group by item",
// "Calendar View" => "Calendar View",
// "List View" => "List View",
// "Tiki Action Calendar" => "Tiki Action Calendar",
// "Tip" => "Tip",
// "Select <a href=\"tiki-list_banners.php\" title=\"Banners\">Admin &gt; Banners</a> from the menu to create and edit banner zones" => "Select <a href=\"tiki-list_banners.php\" title=\"Banners\">Admin &gt; Banners</a> from the menu to create and edit banner zones",
// "Site Ads and Banners" => "Site Ads and Banners",
// "<strong>Activate</strong> will display content for Admin only. Select <strong>Publish</strong> to display for all users" => "<strong>Activate</strong> will display content for Admin only. Select <strong>Publish</strong> to display for all users",
// "Global site configuration, date formats, admin password etc" => "Global site configuration, date formats, admin password etc",
// "Switches for major features" => "Switches for major features",
// "User resistration, remember me cookie settings and authentication methods" => "User resistration, remember me cookie settings and authentication methods",
// "Community" => "Community",
// "User specific features and settings" => "User specific features and settings",
// "Profiles" => "Profiles",
// "Repository configuration, browse and apply profiles" => "Repository configuration, browse and apply profiles",
// "Look & Feel" => "Look & Feel",
// "Theme selection, layout settings and UI effect controls" => "Theme selection, layout settings and UI effect controls",
// "i18n" => "i18n",
// "Internationalization and localization - mulitlingual features" => "Internationalization and localization - mulitlingual features",
// "Editing and Plugins" => "Editing and Plugins",
// "Text editing settings applicable to many areas. Plugin activation and plugin alias management" => "Text editing settings applicable to many areas. Plugin activation and plugin alias management",
// "Module appearance settings" => "Module appearance settings",
// "Meta Tags" => "Meta Tags",
// "Information to include in the header of each page" => "Information to include in the header of each page",
// "Performance" => "Performance",
// "Server performance settings" => "Server performance settings",
// "Security" => "Security",
// "Site security settings" => "Site security settings",
// "Feeds" => "Feeds",
// "Web feeds" => "Web feeds",
// "Connect" => "Connect",
// "Wiki page settings and features" => "Wiki page settings and features",
// "Defaults and configuration for file galleries" => "Defaults and configuration for file galleries",
// "Settings for blogs" => "Settings for blogs",
// "Defaults and configuration for image galleries (will be phased out in favour of file galleries)" => "Defaults and configuration for image galleries (will be phased out in favour of file galleries)",
// "Settings and features for articles" => "Settings and features for articles",
// "Settings and features for forums" => "Settings and features for forums",
// "Settings and features for trackers" => "Settings and features for trackers",
// "Settings and features for polls" => "Settings and features for polls",
// "Settings and features for calendars" => "Settings and features for calendars",
// "Settings and features for categories" => "Settings and features for categories",
// "Values of actions for users rank score" => "Values of actions for users rank score",
// "Settings and features for freetags" => "Settings and features for freetags",
// "Search configuration" => "Search configuration",
// "Settings and features for FAQs" => "Settings and features for FAQs",
// "Settings and features for directory of links" => "Settings and features for directory of links",
// "Settings and features for maps" => "Settings and features for maps",
// "Defaults and API key for Google Maps" => "Defaults and API key for Google Maps",
// "?" => "?",
// "Site-wide copyright information" => "Site-wide copyright information",
// "Message settings" => "Message settings",
// "User files settings" => "User files settings",
// "Webmail settings" => "Webmail settings",
// "Options for WYSIWYG editor" => "Options for WYSIWYG editor",
// "InterTiki" => "InterTiki",
// "Set up links between Tiki servers" => "Set up links between Tiki servers",
// "Manage semantic wiki links" => "Manage semantic wiki links",
// "Webservices" => "Webservices",
// "Register and manage web services" => "Register and manage web services",
// "Sef URL" => "Sef URL",
// "Search Engine Friendly URLs" => "Search Engine Friendly URLs",
// "Kaltura video configuration" => "Kaltura video configuration",
// "To add/remove blogs, go to \"Create/Edit Blog\" under \"Blogs\" on the application menu, or" => "To add/remove blogs, go to \"Create/Edit Blog\" under \"Blogs\" on the application menu, or",
// "Create a blog" => "Create a blog",
// "Requires a separate download" => "Requires a separate download",
// "Force and limit categorization to within subtree of" => "Force and limit categorization to within subtree of",
// "Blogs Listings" => "Blogs Listings",
// "Select which items to display when listing blogs" => "Select which items to display when listing blogs",
// "To add/remove calendars, look for \"Calendar\" under \"Admin\" on the application menu, or" => "To add/remove calendars, look for \"Calendar\" under \"Admin\" on the application menu, or",
// "Change settings" => "Change settings",
// "General settings" => "General settings",
// "Default calendars to display" => "Default calendars to display",
// "All calendars" => "All calendars",
// "A subset of available calendars" => "A subset of available calendars",
// "Create calendar" => "Create calendar",
// "Default view mode" => "Default view mode",
// "Day" => "Day",
// "Quarter" => "Quarter",
// "Semester" => "Semester",
// "View list begins" => "View list begins",
// "Focus Date" => "Focus Date",
// "Period beginning" => "Period beginning",
// "First day of the week" => "First day of the week",
// "Depends user language" => "Depends user language",
// "Split hours in periods of" => "Split hours in periods of",
// "1 minute" => "1 minute",
// "10 minutes" => "10 minutes",
// "15 minutes" => "15 minutes",
// "30 minutes" => "30 minutes",
// "Manual selection of time/date" => "Manual selection of time/date",
// "JS calendar" => "JS calendar",
// "Year selection is valid when the JS Calendar <strong>is not</strong> enabled" => "Year selection is valid when the JS Calendar <strong>is not</strong> enabled",
// "First year in the dropdown" => "First year in the dropdown",
// "Enter a year or use +/- N to specify a year relative to the current\n\tyear" => "Enter a year or use +/- N to specify a year relative to the current\n\tyear",
// "Last year in the dropdown" => "Last year in the dropdown",
// "Sticky popup" => "Sticky popup",
// "Item view tab" => "Item view tab",
// "Browse categories" => "Browse categories",
// "Administer categories" => "Administer categories",
// "Separate category IDs with a comma (,)" => "Separate category IDs with a comma (,)",
// "Will improve performance, but may show forbidden results" => "Will improve performance, but may show forbidden results",
// "Look under \"Articles\" on the application menu for links to" => "Look under \"Articles\" on the application menu for links to",
// "Admin topics" => "Admin topics",
// "Admin types" => "Admin types",
// "Title of articles home page" => "Title of articles home page",
// "Article properties" => "Article properties",
// "Give only one value (width or height) to keep the image proportions" => "Give only one value (width or height) to keep the image proportions",
// "File format: title,authorName,heading,body,lang,user" => "File format: title,authorName,heading,body,lang,user",
// "Articles Listing" => "Articles Listing",
// "Select which items to display when listing articles" => "Select which items to display when listing articles",
// "Admin Groups" => "Admin Groups",
// "Admin Users" => "Admin Users",
// "User features" => "User features",
// "Highlight group" => "Highlight group",
// "Use the format: trackerId, fieldId1, fieldId2, .." => "Use the format: trackerId, fieldId1, fieldId2, ..",
// "Users can choose to show their gender" => "Users can choose to show their gender",
// "Requires User Preferences feature" => "Requires User Preferences feature",
// "Show user's information on mouseover" => "Show user's information on mouseover",
// "Requires user's information to be public" => "Requires user's information to be public",
// "Real name" => "Real name",
// "Number of friends" => "Number of friends",
// "Feature is disabled" => "Feature is disabled",
// "Enable now" => "Enable now",
// "E-mail" => "E-mail",
// "Distance" => "Distance",
// "Default user preferences" => "Default user preferences",
// "Users Default Preferences" => "Users Default Preferences",
// "Character set for mail" => "Character set for mail",
// "default" => "default",
// "Detect user timezone if browser allows, otherwise site default" => "Detect user timezone if browser allows, otherwise site default",
// "Use double-click to edit pages" => "Use double-click to edit pages",
// "Show user's info on mouseover" => "Show user's info on mouseover",
// "User messages" => "User messages",
// "Notify sender when reading mail" => "Notify sender when reading mail",
// "Auto-archive read messages after x days" => "Auto-archive read messages after x days",
// "never" => "never",
// "My forum topics" => "My forum topics",
// "My forum replies" => "My forum replies",
// "Select which items to display when listing users" => "Select which items to display when listing users",
// "Score ascending" => "Score ascending",
// "Score descending" => "Score descending",
// "Name ascending" => "Name ascending",
// "Name descending" => "Name descending",
// "Login ascending" => "Login ascending",
// "Login descending" => "Login descending",
// "TikiWiki CMS/Groupware is Free and Open Source Software (FOSS). It is a community-driven project which exists and improves thanks to the participation of people just like YOU" => "TikiWiki CMS/Groupware is Free and Open Source Software (FOSS). It is a community-driven project which exists and improves thanks to the participation of people just like YOU",
// "Join the community" => "Join the community",
// "Promote your site" => "Promote your site",
// "To submit your site to TikiWiki.org" => "To submit your site to TikiWiki.org",
// "Submit site" => "Submit site",
// "Help Tiki spread" => "Help Tiki spread",
// "Help improve Tiki" => "Help improve Tiki",
// "To submit a feature request or to report a bug" => "To submit a feature request or to report a bug",
// "Click here to go to our development site" => "Click here to go to our development site",
// "Copyright allows to determine a copyright for all the objects of tikiwiki" => "Copyright allows to determine a copyright for all the objects of tikiwiki",
// "Enable copyright management for" => "Enable copyright management for",
// "To configure your directory, find \"Admin Directory\" under \"Directory\" on the application menu, or" => "To configure your directory, find \"Admin Directory\" under \"Directory\" on the application menu, or",
// "To add/remove FAQs, look for \"Admin FAQs\" under \"FAQs\" on the application menu, or" => "To add/remove FAQs, look for \"Admin FAQs\" under \"FAQs\" on the application menu, or",
// "Please see the <a class='rbox-link' target='tikihelp' href='http://doc.tikiwiki.org/Features'>evaluation of each feature</a> on Tiki's developer site" => "Please see the <a class='rbox-link' target='tikihelp' href='http://doc.tikiwiki.org/Features'>evaluation of each feature</a> on Tiki's developer site",
// "Global features" => "Global features",
// "Main feature" => "Main feature",
// "Additional" => "Additional",
// "Programmer" => "Programmer",
// "These features are relatively new, or recently underwent major renovations. You should expect growing pains and possibly a lack of up to date documentation, as you would of a version 1.0 application" => "These features are relatively new, or recently underwent major renovations. You should expect growing pains and possibly a lack of up to date documentation, as you would of a version 1.0 application",
// "Experimental" => "Experimental",
// "Will be phased out" => "Will be phased out",
// "These features generally work but will probably be phased out in the future, because they are superseded by other features or because of evolution in Web technology" => "These features generally work but will probably be phased out in the future, because they are superseded by other features or because of evolution in Web technology",
// "Seem ok but.." => "Seem ok but..",
// "These features are not reported to be broken, but they are not actively developed and/or widely used" => "These features are not reported to be broken, but they are not actively developed and/or widely used",
// "Need polish" => "Need polish",
// "These features are generally known to have issues, and/or need admin help and/or user patience to work" => "These features are generally known to have issues, and/or need admin help and/or user patience to work",
// "Feedbacks" => "Feedbacks",
// "To create or remove file galleries, select" => "To create or remove file galleries, select",
// "from the application menu" => "from the application menu",
// "If you decide to store files in a directory you must ensure that the user cannot access directly to the directory" => "If you decide to store files in a directory you must ensure that the user cannot access directly to the directory",
// "You have two options to accomplish this:<br /><ul><li>Use a directory outside your document root, make sure your php script can read and write to that directory</li><li>Use a directory inside the document root and use .htaccess to prevent the user from listing the directory contents</li></ul>" => "You have two options to accomplish this:<br /><ul><li>Use a directory outside your document root, make sure your php script can read and write to that directory</li><li>Use a directory inside the document root and use .htaccess to prevent the user from listing the directory contents</li></ul>",
// "To configure the directory path use UNIX like paths for example files/ or c:/foo/files or /www/files/" => "To configure the directory path use UNIX like paths for example files/ or c:/foo/files or /www/files/",
// "Create a Gallery" => "Create a Gallery",
// "Move files from database to directory" => "Move files from database to directory",
// "Move files from directory to database" => "Move files from directory to database",
// "Store in database" => "Store in database",
// "Store in directory" => "Store in directory",
// "Score is disabled" => "Score is disabled",
// "Upload Regex" => "Upload Regex",
// "Gallery Listings" => "Gallery Listings",
// "Changing these settings will <em>not</em> affect existing file galleries. These changes will apply <em>only</em> to new file galleries" => "Changing these settings will <em>not</em> affect existing file galleries. These changes will apply <em>only</em> to new file galleries",
// "Select which items to display when listing galleries: " => "Select which items to display when listing galleries: ",
// "Search Indexing" => "Search Indexing",
// "Automatically index files on upload or change" => "Automatically index files on upload or change",
// "Handlers" => "Handlers",
// "Add custom handlers to make your files &quot;searchable&quot; content" => "Add custom handlers to make your files &quot;searchable&quot; content",
// "Use <strong>%1</strong> as the internal file name. For example, use <strong>strings %1</strong> to convert the document to text, using the Unix <strong>strings</strong> command" => "Use <strong>%1</strong> as the internal file name. For example, use <strong>strings %1</strong> to convert the document to text, using the Unix <strong>strings</strong> command",
// "To delete a handler, leave the <strong>System Command</strong> field blank" => "To delete a handler, leave the <strong>System Command</strong> field blank",
// "MIME Type" => "MIME Type",
// "System Command" => "System Command",
// "Reindex all files for search" => "Reindex all files for search",
// "To add/remove forums, look for \"Admin forums\" under \"Forums\" on the application menu, or" => "To add/remove forums, look for \"Admin forums\" under \"Forums\" on the application menu, or",
// "Create a forum" => "Create a forum",
// "If disabled, replies will quote the original post" => "If disabled, replies will quote the original post",
// "Will be a thread title" => "Will be a thread title",
// "Threads" => "Threads",
// "Allows users to override the defaults" => "Allows users to override the defaults",
// "When listing forums" => "When listing forums",
// "Forums Listing" => "Forums Listing",
// "Select which items to display when listing forums" => "Select which items to display when listing forums",
// "Show tag cloud" => "Show tag cloud",
// "Maximum number of tags in cloud" => "Maximum number of tags in cloud",
// "Show freetags in middle column" => "Show freetags in middle column",
// "Preload freetag random tag" => "Preload freetag random tag",
// "When arriving on <a href=\"tiki-browse_freetags.php\">freetag search page</a>" => "When arriving on <a href=\"tiki-browse_freetags.php\">freetag search page</a>",
// "Random tag cloud colors" => "Random tag cloud colors",
// "Separate colors with a comma (,)" => "Separate colors with a comma (,)",
// "Number of Tags to show in Tag Suggestions" => "Number of Tags to show in Tag Suggestions",
// "Valid characters pattern" => "Valid characters pattern",
// "Alphanumeric ASCII characters only" => "Alphanumeric ASCII characters only",
// "No accents or special characters" => "No accents or special characters",
// "Accept all charactrs" => "Accept all charactrs",
// "Lowercase tags only" => "Lowercase tags only",
// "&quot;More Like This&quot; algorithm" => "&quot;More Like This&quot; algorithm",
// "basic" => "basic",
// "weighted" => "weighted",
// "Minimum amount of tags in common" => "Minimum amount of tags in common",
// "Tag Management" => "Tag Management",
// "Cleanup unused tags" => "Cleanup unused tags",
// "3D Tag Browser" => "3D Tag Browser",
// "Morcego 3D browser disabled" => "Morcego 3D browser disabled",
// "Enable freetags 3D browser" => "Enable freetags 3D browser",
// "Browser width" => "Browser width",
// "Graph appearance" => "Graph appearance",
// "Node color" => "Node color",
// "Camera settinsg" => "Camera settinsg",
// "Physics engine" => "Physics engine",
// "To add/remove image galleries, go to \"Image Galleries\" on the application menu, or" => "To add/remove image galleries, go to \"Image Galleries\" on the application menu, or",
// "You can upload images of a size of " => "You can upload images of a size of ",
// "Alter the php.ini variables file_uploads, upload_max_filesize, post_max_size and database variables (max_allowed_packet for mysql) to change this value" => "Alter the php.ini variables file_uploads, upload_max_filesize, post_max_size and database variables (max_allowed_packet for mysql) to change this value",
// "Home Gallery" => "Home Gallery",
// "No Gallery exists" => "No Gallery exists",
// "Uses Slideshow" => "Uses Slideshow",
// "Note: if you change this directory, you have to move the contents to the new directory. You can also use the 'Mover' below" => "Note: if you change this directory, you have to move the contents to the new directory. You can also use the 'Mover' below",
// "Directory Batch Loading" => "Directory Batch Loading",
// "If you enable Directory Batch Loading, you need to setup a web-readable directory (outside of your web space is better). Then setup a way to upload images in that dir, either by scp, ftp, or other protocols" => "If you enable Directory Batch Loading, you need to setup a web-readable directory (outside of your web space is better). Then setup a way to upload images in that dir, either by scp, ftp, or other protocols",
// "Enable directory batch loading" => "Enable directory batch loading",
// "Batch loading directory" => "Batch loading directory",
// "Display image informations in a mouseover box" => "Display image informations in a mouseover box",
// "yes, and don't display those informations under the image" => "yes, and don't display those informations under the image",
// "Use default max rows, images per row, thumbnails size and scale size for all galleries (set values below)" => "Use default max rows, images per row, thumbnails size and scale size for all galleries (set values below)",
// "Pixels Default" => "Pixels Default",
// "Default scale size" => "Default scale size",
// "pixels" => "pixels",
// "Exterminator" => "Exterminator",
// "Mover" => "Mover",
// "Move images from database storage to filesystem storage" => "Move images from database storage to filesystem storage",
// "Move images from filesystem storage to database storage" => "Move images from filesystem storage to database storage",
// "Move images from old filesystem store to new directory" => "Move images from old filesystem store to new directory",
// "Moved" => "Moved",
// "Change configuration" => "Change configuration",
// "Release Check" => "Release Check",
// "Reset or upgrade your database" => "Reset or upgrade your database",
// "Check for updates now" => "Check for updates now",
// "Site Identity" => "Site Identity",
// "Go to <a href=\"tiki-admin.php?page=look\" title=\"\"><strong>Look & Feel</strong></a> section for additional site related customization preferences" => "Go to <a href=\"tiki-admin.php?page=look\" title=\"\"><strong>Look & Feel</strong></a> section for additional site related customization preferences",
// "Mail" => "Mail",
// "Mail Sender" => "Mail Sender",
// "Sendmail" => "Sendmail",
// "SMTP" => "SMTP",
// "SMTP Server" => "SMTP Server",
// "Authentication" => "Authentication",
// "These values will be stored in plain text in the database" => "These values will be stored in plain text in the database",
// "Logging and Reporting" => "Logging and Reporting",
// "Visible to admin only" => "Visible to admin only",
// "Include Smarty notices" => "Include Smarty notices",
// "Spam protection" => "Spam protection",
// "MultiDomain" => "MultiDomain",
// "Session" => "Session",
// "Advanced configuration warning" => "Advanced configuration warning",
// "Note that storing session data in the database is an advanced systems administration option, and is for admins who have comprehensive access and understanding of the database, in order to deal with any unexpected effects" => "Note that storing session data in the database is an advanced systems administration option, and is for admins who have comprehensive access and understanding of the database, in order to deal with any unexpected effects",
// "Changing this feature will immediately log you out when you save this preference" => "Changing this feature will immediately log you out when you save this preference",
// "Contact" => "Contact",
// "Miscellaneous" => "Miscellaneous",
// "Use TikiWiki feature as homepage" => "Use TikiWiki feature as homepage",
// "Use different URL as home page" => "Use different URL as home page",
// "Redirects" => "Redirects",
// "If a requested page doesn't exist, redirect to a similarly named page" => "If a requested page doesn't exist, redirect to a similarly named page",
// "On permission denied, display login module (for Anonymous)" => "On permission denied, display login module (for Anonymous)",
// "Send to URL" => "Send to URL",
// "Site Access" => "Site Access",
// "Default timezone" => "Default timezone",
// "Use site default to show times" => "Use site default to show times",
// "Detect user timezone (if browser allows). Otherwise use site default" => "Detect user timezone (if browser allows). Otherwise use site default",
// "Sample" => "Sample",
// "Fields display order" => "Fields display order",
// "Change the <strong>Admin</strong> password" => "Change the <strong>Admin</strong> password",
// "Minimum {\$prefs.min_pass_length} characters long" => "Minimum {\$prefs.min_pass_length} characters long",
// "To use Google Maps, you must generate a Google Maps API Key for your web site. See <a href=\"http://www.google.com/apis/maps/signup.html\">http://www.google.com/apis/maps/signup.html</a> for details" => "To use Google Maps, you must generate a Google Maps API Key for your web site. See <a href=\"http://www.google.com/apis/maps/signup.html\">http://www.google.com/apis/maps/signup.html</a> for details",
// "Google Maps API Key" => "Google Maps API Key",
// "Defaults" => "Defaults",
// "Default x for map center" => "Default x for map center",
// "Default y from map center" => "Default y from map center",
// "Default zoom level" => "Default zoom level",
// "whole earth" => "whole earth",
// "country size" => "country size",
// "city size" => "city size",
// "max zoom" => "max zoom",
// "Internationalization" => "Internationalization",
// "Edit or export/import Languages" => "Edit or export/import Languages",
// "Babelfish links" => "Babelfish links",
// "Customized String Translation" => "Customized String Translation",
// "Syntax error" => "Syntax error",
// "Intertiki client" => "Intertiki client",
// "Tiki Unique key" => "Tiki Unique key",
// "InterTiki Slave mode" => "InterTiki Slave mode",
// "Warning: overrides manually registered local users" => "Warning: overrides manually registered local users",
// "as master" => "as master",
// "Import user preferences" => "Import user preferences",
// "Import user groups" => "Import user groups",
// "Limit group import (comma-separated list of imported groups, leave empty to avoid limitation)" => "Limit group import (comma-separated list of imported groups, leave empty to avoid limitation)",
// "Intertiki shared cookie for sliding auth under same domain" => "Intertiki shared cookie for sliding auth under same domain",
// "InterTiki Server" => "InterTiki Server",
// "host" => "host",
// "Add new server" => "Add new server",
// "Intertiki server" => "Intertiki server",
// "Intertiki Server enabled" => "Intertiki Server enabled",
// "Access Log file" => "Access Log file",
// "Errors Log file" => "Errors Log file",
// "Known hosts" => "Known hosts",
// "Key" => "Key",
// "Kaltura Registration" => "Kaltura Registration",
// "If you don't have a Kaltura Partner Id, " => "If you don't have a Kaltura Partner Id, ",
// "to register" => "to register",
// "Kaltura Partner Settings" => "Kaltura Partner Settings",
// "Partner Id" => "Partner Id",
// "User Secret" => "User Secret",
// "Admin Secret" => "Admin Secret",
// "Kaltura Dynamic Player" => "Kaltura Dynamic Player",
// "KDP UI Configuration Id" => "KDP UI Configuration Id",
// "KDP Widget Id" => "KDP Widget Id",
// "Kaltura Contribution Wizard" => "Kaltura Contribution Wizard",
// "KCW UI Configuration Id" => "KCW UI Configuration Id",
// "Kaltura Remix Editors" => "Kaltura Remix Editors",
// "Kaltura Simple Editor UI Configuration Id" => "Kaltura Simple Editor UI Configuration Id",
// "Kaltura Advance Editor UI Configuration Id" => "Kaltura Advance Editor UI Configuration Id",
// "Enable/disable Tiki features in " => "Enable/disable Tiki features in ",
// ", but configure them elsewhere" => ", but configure them elsewhere",
// "Wysiwyg" => "Wysiwyg",
// "Registration" => "Registration",
// "Validate by email" => "Validate by email",
// "You need to set <a href=\"tiki-admin.php?page=general\">Sender Email</a>" => "You need to set <a href=\"tiki-admin.php?page=general\">Sender Email</a>",
// "Validate user's email server" => "Validate user's email server",
// "Require validation by Admin" => "Require validation by Admin",
// "Validator emails (separated by comma) if different than the sender email" => "Validator emails (separated by comma) if different than the sender email",
// "Require passcode to register" => "Require passcode to register",
// "Passcode" => "Passcode",
// "Users must enter this code to register" => "Users must enter this code to register",
// "Use CAPTCHA to prevent automatic/robot registrations" => "Use CAPTCHA to prevent automatic/robot registrations",
// "Requires PHP GD library" => "Requires PHP GD library",
// "Include &quot;Generate Password&quot; option on registration form" => "Include &quot;Generate Password&quot; option on registration form",
// "Users can select a group to join at registration" => "Users can select a group to join at registration",
// "By default, new users automatically join the Registered group" => "By default, new users automatically join the Registered group",
// "Url a user is redirected after account validation" => "Url a user is redirected after account validation",
// "Account validated successfully" => "Account validated successfully",
// "Use tracker to collect more user information" => "Use tracker to collect more user information",
// "Use the <strong><a href=\"tiki-admingroups.php\" title=\"Admin Groups\">Admin: Groups</a></strong> page to select which tracker and fields to display" => "Use the <strong><a href=\"tiki-admingroups.php\" title=\"Admin Groups\">Admin: Groups</a></strong> page to select which tracker and fields to display",
// "Use tracker to collect more group information" => "Use tracker to collect more group information",
// "Re-validate user by email after" => "Re-validate user by email after",
// "Use <strong>-1</strong> for never" => "Use <strong>-1</strong> for never",
// "unsuccessful login attempts" => "unsuccessful login attempts",
// "Create a new group for each user" => "Create a new group for each user",
// "The group will be named identical to the user's username" => "The group will be named identical to the user's username",
// "Disable browser's autocomplete feature for username and password fields" => "Disable browser's autocomplete feature for username and password fields",
// "Confirm that the Admin account has a valid email address or you will not be permitted to login" => "Confirm that the Admin account has a valid email address or you will not be permitted to login",
// "Use HTTPS login" => "Use HTTPS login",
// "Encourage secure (https) login" => "Encourage secure (https) login",
// "Consider we are always in HTTPS, but do not check" => "Consider we are always in HTTPS, but do not check",
// "Users can choose to stay in SSL mode after an HTTPS login" => "Users can choose to stay in SSL mode after an HTTPS login",
// "Users can switch between secured or standard mode at login" => "Users can switch between secured or standard mode at login",
// "User's choice" => "User's choice",
// "Cookie name" => "Cookie name",
// "Use email as username" => "Use email as username",
// "Minimum length" => "Minimum length",
// "Force lowercase" => "Force lowercase",
// "Username pattern" => "Username pattern",
// "Store passwords in plain text is activated. You should never set this unless you know what you are doing" => "Store passwords in plain text is activated. You should never set this unless you know what you are doing",
// "Users can change their password" => "Users can change their password",
// "Require characters and numerals" => "Require characters and numerals",
// "Password expires after" => "Password expires after",
// "LDAP" => "LDAP",
// "You must change the Authentication Method to LDAP for these changes to take effect" => "You must change the Authentication Method to LDAP for these changes to take effect",
// "Create user if not in Tiki" => "Create user if not in Tiki",
// "Create user if not in LDAP" => "Create user if not in LDAP",
// "Use Tiki authentication for Admin login" => "Use Tiki authentication for Admin login",
// "Use Tiki authentication for users created in tiki" => "Use Tiki authentication for users created in tiki",
// "LDAP Bind settings" => "LDAP Bind settings",
// "Will override the Host and Port settings" => "Will override the Host and Port settings",
// "Write LDAP debug Information in Tiki Logs" => "Write LDAP debug Information in Tiki Logs",
// "Use SSL (ldaps)" => "Use SSL (ldaps)",
// "Use TLS" => "Use TLS",
// "LDAP Bind Type" => "LDAP Bind Type",
// "Default: userattr=username,UserDN,BaseDN" => "Default: userattr=username,UserDN,BaseDN",
// "userattr=username,BaseDN" => "userattr=username,BaseDN",
// "Active Directory (username@domain)" => "Active Directory (username@domain)",
// "Plain Username" => "Plain Username",
// "Search scope" => "Search scope",
// "Subtree" => "Subtree",
// "One level" => "One level",
// "Base object" => "Base object",
// "LDAP version" => "LDAP version",
// "Base DN" => "Base DN",
// "LDAP User" => "LDAP User",
// "User DN" => "User DN",
// "User attribute" => "User attribute",
// "User OC" => "User OC",
// "Realname attribute" => "Realname attribute",
// "Country attribute" => "Country attribute",
// "E-mail attribute" => "E-mail attribute",
// "Synchronize user attributes to tiki everytime the user logs in" => "Synchronize user attributes to tiki everytime the user logs in",
// "LDAP Group" => "LDAP Group",
// "Synchronize group attributes to tiki everytime the user logs in" => "Synchronize group attributes to tiki everytime the user logs in",
// "Note: this enables the usage of LDAP groups" => "Note: this enables the usage of LDAP groups",
// "Group DN" => "Group DN",
// "Group attribute" => "Group attribute",
// "Group description attribute" => "Group description attribute",
// "Group OC" => "Group OC",
// "LDAP Group Member - if group membership can be found in group attributes" => "LDAP Group Member - if group membership can be found in group attributes",
// "Member attribute" => "Member attribute",
// "Member is DN" => "Member is DN",
// "LDAP User Group - if group membership can be found in user attributes" => "LDAP User Group - if group membership can be found in user attributes",
// "Group attribute in group entry" => "Group attribute in group entry",
// "LDAP Admin" => "LDAP Admin",
// "Admin user" => "Admin user",
// "Admin password" => "Admin password",
// "PAM" => "PAM",
// "You must change the Authentication Method to PAM for these changes to take effect" => "You must change the Authentication Method to PAM for these changes to take effect",
// "PAM service" => "PAM service",
// "Currently unused" => "Currently unused",
// "Shibboleth Authentication " => "Shibboleth Authentication ",
// "You must change the Authentication Method to Shibboleth for these changes to take effect" => "You must change the Authentication Method to Shibboleth for these changes to take effect",
// "Valid affiliations" => "Valid affiliations",
// "Separate multiple affiliations with commas" => "Separate multiple affiliations with commas",
// "Create with default group" => "Create with default group",
// "CAS" => "CAS",
// "You must change the Authentication Method to CAS for these changes to take effect" => "You must change the Authentication Method to CAS for these changes to take effect",
// "You also need to upload the <a target=\"_blank\" href=\"http://esup-phpcas.sourceforge.net/\">phpCAS library</a> separately to lib/phpcas/" => "You also need to upload the <a target=\"_blank\" href=\"http://esup-phpcas.sourceforge.net/\">phpCAS library</a> separately to lib/phpcas/",
// "CAS server version" => "CAS server version",
// "Version 1.0" => "Version 1.0",
// "Version 2.0" => "Version 2.0",
// "CAS Server" => "CAS Server",
// "Hostname" => "Hostname",
// "You must enable PHP CAS first" => "You must enable PHP CAS first",
// "Themes" => "Themes",
// "Theme options" => "Theme options",
// "The \"users can change theme\" feature will override the theme displayed" => "The \"users can change theme\" feature will override the theme displayed",
// "Theme not saved yet - click \"Apply\"" => "Theme not saved yet - click \"Apply\"",
// "Theme Screenshot" => "Theme Screenshot",
// "Restrict available themes" => "Restrict available themes",
// "Available styles" => "Available styles",
// "Each group can have its theme" => "Each group can have its theme",
// "Slideshow theme" => "Slideshow theme",
// "Tiki Template Viewing" => "Tiki Template Viewing",
// "View Templates" => "View Templates",
// "Custom HTML &lt;head&gt; Content" => "Custom HTML &lt;head&gt; Content",
// "Custom Site Header" => "Custom Site Header",
// "The Custom Site Header will display for the Admin only. Select <strong>Publish</strong> to display the content for </em>all<em> users" => "The Custom Site Header will display for the Admin only. Select <strong>Publish</strong> to display the content for </em>all<em> users",
// "Site Logo and Title" => "Site Logo and Title",
// "Logo source (image path)" => "Logo source (image path)",
// "Logo background color" => "Logo background color",
// "Examples" => "Examples",
// "Logo background style" => "Logo background style",
// "Logo alignment" => "Logo alignment",
// "Logo title (on mouse over)" => "Logo title (on mouse over)",
// "Alt. description (e.g. for text browsers)" => "Alt. description (e.g. for text browsers)",
// "Site title" => "Site title",
// "Subtitle" => "Subtitle",
// "Search Bar" => "Search Bar",
// "Login Bar" => "Login Bar",
// "Top Bar" => "Top Bar",
// "Site menu bar" => "Site menu bar",
// "Requires CSS Menus or PHPLayers" => "Requires CSS Menus or PHPLayers",
// "Menu ID" => "Menu ID",
// "Display current Tiki version" => "Display current Tiki version",
// "Custom code" => "Custom code",
// "Custom Center Column Header" => "Custom Center Column Header",
// "only if module" => "only if module",
// "always" => "always",
// "user decides" => "user decides",
// "Users can Flip Columns" => "Users can Flip Columns",
// "Prefix breadcrumbs with &quot;Location : &quot" => "Prefix breadcrumbs with &quot;Location : &quot",
// "Site location bar" => "Site location bar",
// "Top of page" => "Top of page",
// "Top of center column" => "Top of center column",
// "Larger font for" => "Larger font for",
// "Entire location" => "Entire location",
// "Custom Site Footer" => "Custom Site Footer",
// "Custom End of &lt;body&gt; Code" => "Custom End of &lt;body&gt; Code",
// "Bottom bar icons" => "Bottom bar icons",
// "Bottom bar debug" => "Bottom bar debug",
// "Bottom bar (RSS)" => "Bottom bar (RSS)",
// "Site Report Bar" => "Site Report Bar",
// "Webmaster Report" => "Webmaster Report",
// "Webmaster Email" => "Webmaster Email",
// "Leave <strong>blank</strong> to use the default sender email" => "Leave <strong>blank</strong> to use the default sender email",
// "Email this page" => "Email this page",
// "Shadow layer" => "Shadow layer",
// "Additional layers for shadows, rounded corners or other decorative styling" => "Additional layers for shadows, rounded corners or other decorative styling",
// "Main shadow start" => "Main shadow start",
// "Main shadow end" => "Main shadow end",
// "Header shadow start" => "Header shadow start",
// "Header shadow end" => "Header shadow end",
// "Middle shadow start" => "Middle shadow start",
// "Middle shadow end" => "Middle shadow end",
// "Center shadow start" => "Center shadow start",
// "Center shadow end" => "Center shadow end",
// "Footer shadow start" => "Footer shadow start",
// "Footer shadow end" => "Footer shadow end",
// "Module (box) shadow start" => "Module (box) shadow start",
// "Module (box) shadow end" => "Module (box) shadow end",
// "Pagination links" => "Pagination links",
// "Use relative (next / previous) pagination links" => "Use relative (next / previous) pagination links",
// "Max. number of links around the current item" => "Max. number of links around the current item",
// "Max. number of links after the first or before the last item" => "Max. number of links after the first or before the last item",
// "Display 'First' and 'Last' links" => "Display 'First' and 'Last' links",
// "Display fast move links (by 10 percent of the total number of pages) " => "Display fast move links (by 10 percent of the total number of pages) ",
// "Hide pagination when there is only one page" => "Hide pagination when there is only one page",
// "Use Icons" => "Use Icons",
// "UI Effects" => "UI Effects",
// "JQuery plugins and add-ons" => "JQuery plugins and add-ons",
// "Requires jquery feature" => "Requires jquery feature",
// "Tooltips" => "Tooltips",
// "JQuery Tooltips: Customisable help tips" => "JQuery Tooltips: Customisable help tips",
// "Autocomplete" => "Autocomplete",
// "JQuery Autocomplete" => "JQuery Autocomplete",
// "Superfish" => "Superfish",
// "JQuery Superfish (effects on CSS menus)" => "JQuery Superfish (effects on CSS menus)",
// "Reflection" => "Reflection",
// "JQuery Reflection (reflection effect on images)" => "JQuery Reflection (reflection effect on images)",
// "JQuery UI" => "JQuery UI",
// "JQuery UI: More JQuery functionality" => "JQuery UI: More JQuery functionality",
// "JQuery UI Theme" => "JQuery UI Theme",
// "JQuery UI Theme: Themes for look and feel of JQuery UI widgets" => "JQuery UI Theme: Themes for look and feel of JQuery UI widgets",
// "For future use" => "For future use",
// "Cycle" => "Cycle",
// "slideshow" => "slideshow",
// "JQuery Cycle (slideshow)" => "JQuery Cycle (slideshow)",
// "JQuery Sheet" => "JQuery Sheet",
// "JQuery Spreadsheet" => "JQuery Spreadsheet",
// "JQuery Sortable Tables" => "JQuery Sortable Tables",
// "Standard UI effects" => "Standard UI effects",
// "Effect for modules" => "Effect for modules",
// "Slide" => "Slide",
// "Blind (UI)" => "Blind (UI)",
// "Clip (UI)" => "Clip (UI)",
// "Drop (UI)" => "Drop (UI)",
// "Explode (UI)" => "Explode (UI)",
// "Fold (UI)" => "Fold (UI)",
// "Puff (UI)" => "Puff (UI)",
// "Slide (UI)" => "Slide (UI)",
// "Main JQuery effect" => "Main JQuery effect",
// "Speed" => "Speed",
// "Fast" => "Fast",
// "Slow" => "Slow",
// "Direction" => "Direction",
// "Vertical" => "Vertical",
// "Horizontal" => "Horizontal",
// "Tab UI effects" => "Tab UI effects",
// "Effect for tabs" => "Effect for tabs",
// "JQuery effect for tabs" => "JQuery effect for tabs",
// "Use Tabs" => "Use Tabs",
// "Correct PNG images alpha transparency in IE6 (experimental)" => "Correct PNG images alpha transparency in IE6 (experimental)",
// "CSS selectors to be fixed" => "CSS selectors to be fixed",
// "Separate multiple elements with a comma (&nbsp;,&nbsp;)" => "Separate multiple elements with a comma (&nbsp;,&nbsp;)",
// "HTMLDomElements to be fixed" => "HTMLDomElements to be fixed",
// "Favicon" => "Favicon",
// "Favicon icon file name" => "Favicon icon file name",
// "Favicon icon MIME type" => "Favicon icon MIME type",
// "image/png" => "image/png",
// "image/bmp" => "image/bmp",
// "image/x-icon" => "image/x-icon",
// "Context Menus" => "Context Menus",
// "Currently used in File Galleries only" => "Currently used in File Galleries only",
// "Use context menus for actions (icons)" => "Use context menus for actions (icons)",
// "Use context menus for actions (text)" => "Use context menus for actions (text)",
// "Separators" => "Separators",
// "Generate User Map" => "Generate User Map",
// "Meta tags" => "Meta tags",
// "Geo URL" => "Geo URL",
// "Robots" => "Robots",
// "&quot;Modules&quot; are the boxes of content in the right &amp; left columns" => "&quot;Modules&quot; are the boxes of content in the right &amp; left columns",
// "Admin &gt; Modules" => "Admin &gt; Modules",
// "from the menu to create and edit modules" => "from the menu to create and edit modules",
// "Hint: If you lose your login module, use tiki-login_scr.php to be able to login" => "Hint: If you lose your login module, use tiki-login_scr.php to be able to login",
// "It works with the File Gallery, wiki pages (via a plugin), and a new multimedia tracker item" => "It works with the File Gallery, wiki pages (via a plugin), and a new multimedia tracker item",
// "Save Preferences" => "Save Preferences",
// "ProgressBarPlay Color" => "ProgressBarPlay Color",
// "ProgressBarLoad Color" => "ProgressBarLoad Color",
// "ProgressBarButton Color" => "ProgressBarButton Color",
// "ProgressBar Color" => "ProgressBar Color",
// "Volume On Color" => "Volume On Color",
// "Volume Off Color" => "Volume Off Color",
// "Volume Button Color" => "Volume Button Color",
// "Button Color" => "Button Color",
// "Button Pressed Color" => "Button Pressed Color",
// "Button Over Color" => "Button Over Color",
// "Button Info Color" => "Button Info Color",
// "Button Info Pressed Color" => "Button Info Pressed Color",
// "Button Info Over Color" => "Button Info Over Color",
// "Button Info Text Color" => "Button Info Text Color",
// "ID3 Tag Color" => "ID3 Tag Color",
// "Play Time Color" => "Play Time Color",
// "Total Time Color" => "Total Time Color",
// "Panel Display Color" => "Panel Display Color",
// "Alert Message Color" => "Alert Message Color",
// "Flash Length" => "Flash Length",
// "Flash Heigth" => "Flash Heigth",
// "Video Length" => "Video Length",
// "Video Heigth" => "Video Heigth",
// "Preload Delay" => "Preload Delay",
// "Max Play time" => "Max Play time",
// "URL Append" => "URL Append",
// "Message after limited time" => "Message after limited time",
// "ID of System File Galleries to upload multimedia files" => "ID of System File Galleries to upload multimedia files",
// "Please see the <a class='rbox-link' target='tikihelp' href='http://dev.tikiwiki.org/Performance'>Performance page</a> on Tiki's developer site" => "Please see the <a class='rbox-link' target='tikihelp' href='http://dev.tikiwiki.org/Performance'>Performance page</a> on Tiki's developer site",
// "Output compression is active" => "Output compression is active",
// "Compression is handled by" => "Compression is handled by",
// "Many search options impact performance. Please see <a href=\"tiki-admin.php?page=search\">Search admin panel</a>" => "Many search options impact performance. Please see <a href=\"tiki-admin.php?page=search\">Search admin panel</a>",
// "To add/remove polls, look for \"Polls\" under \"Admin\" on the application menu, or" => "To add/remove polls, look for \"Polls\" under \"Admin\" on the application menu, or",
// "Loading profile" => "Loading profile",
// "Are you sure you want to apply the profile" => "Are you sure you want to apply the profile",
// "Sending" => "Sending",
// "Waiting" => "Waiting",
// "TikiWiki Profiles" => "TikiWiki Profiles",
// "The following list of changes has been applied" => "The following list of changes has been applied",
// "Apply Profiles" => "Apply Profiles",
// "A Friendly Warning" => "A Friendly Warning",
// "Some of your Profiles Repositories are not connecting. This may prevent you from applying certain profiles" => "Some of your Profiles Repositories are not connecting. This may prevent you from applying certain profiles",
// "Option 1: Quick Filter" => "Option 1: Quick Filter",
// "Option 2: Manual Filter" => "Option 2: Manual Filter",
// "Filter the list of profiles" => "Filter the list of profiles",
// "Profile" => "Profile",
// "Repository" => "Repository",
// "applied" => "applied",
// "Profile repository" => "Profile repository",
// "Javascript must be turned <b>ON</b> in order to apply Profiles. Please enable your javascript and try again" => "Javascript must be turned <b>ON</b> in order to apply Profiles. Please enable your javascript and try again",
// "Repositories" => "Repositories",
// "Repository URLs" => "Repository URLs",
// "Enter multiple repository URLs, one per line" => "Enter multiple repository URLs, one per line",
// "Data Channels" => "Data Channels",
// "Data channels create a named pipe to run profiles from user space. One channel per line. Each line is comma delimited and contain <strong>channel name, domain, profile, allowed groups</strong>. " => "Data channels create a named pipe to run profiles from user space. One channel per line. Each line is comma delimited and contain <strong>channel name, domain, profile, allowed groups</strong>. ",
// "More information" => "More information",
// "Profile tester" => "Profile tester",
// "This will run the profile and make potentially unrecoverable changes in your database" => "This will run the profile and make potentially unrecoverable changes in your database",
// "Test Profile Name" => "Test Profile Name",
// "Use this page to configure the feeds generated by Tiki. To syndicate feeds from other sites, use the <strong>Admin</strong> &gt; <strong>External Feeds</strong> menu option, or" => "Use this page to configure the feeds generated by Tiki. To syndicate feeds from other sites, use the <strong>Admin</strong> &gt; <strong>External Feeds</strong> menu option, or",
// "External feeds" => "External feeds",
// "Feed for articles" => "Feed for articles",
// "Maximum number of items to display" => "Maximum number of items to display",
// "Show Author" => "Show Author",
// "Homepage URL" => "Homepage URL",
// "Feed for blogs" => "Feed for blogs",
// "Individual blogs" => "Individual blogs",
// "Feed for image galleries" => "Feed for image galleries",
// "Individual image galleries" => "Individual image galleries",
// "Feed for file galleries" => "Feed for file galleries",
// "Individual file galleries" => "Individual file galleries",
// "Feed for wiki" => "Feed for wiki",
// "Individual forums" => "Individual forums",
// "Individual trackers items" => "Individual trackers items",
// "Calendar events" => "Calendar events",
// "Feed for directory" => "Feed for directory",
// "Map files" => "Map files",
// "Feed for maps" => "Feed for maps",
// "Default RDF version" => "Default RDF version",
// "Specification" => "Specification",
// "Documentation" => "Documentation",
// "Editor" => "Editor",
// "Webmaster" => "Webmaster",
// "Image Path" => "Image Path",
// "Caching time" => "Caching time",
// "Use <strong>0</strong> for no caching" => "Use <strong>0</strong> for no caching",
// "Enabling caching will override existing permissions - all content will be public. Enable this option <strong>only</strong> if your syndicated content should be public" => "Enabling caching will override existing permissions - all content will be public. Enable this option <strong>only</strong> if your syndicated content should be public",
// "You can see users rank by score in the module users_rank, for that go to" => "You can see users rank by score in the module users_rank, for that go to",
// "Admin modules" => "Admin modules",
// "Expiration" => "Expiration",
// "can be seen on page" => "can be seen on page",
// "in Admin menu" => "in Admin menu",
// "Search type" => "Search type",
// "This search uses the MySQL Full-Text feature" => "This search uses the MySQL Full-Text feature",
// "The indexation is always updated" => "The indexation is always updated",
// "Tiki search" => "Tiki search",
// "Specify the Tiki search settings" => "Specify the Tiki search settings",
// "Use <strong>0</strong> for no refresh" => "Use <strong>0</strong> for no refresh",
// "The Tiki search indexes must be refreshed if you turn the Tiki search on" => "The Tiki search indexes must be refreshed if you turn the Tiki search on",
// "Refresh all search index now" => "Refresh all search index now",
// "Refresh wiki search index now" => "Refresh wiki search index now",
// "Refresh trackers search index now" => "Refresh trackers search index now",
// "Refresh tracker search index now" => "Refresh tracker search index now",
// "Refresh files search index now" => "Refresh files search index now",
// "May impact performance" => "May impact performance",
// "Enabling these options will improve performance, but may show forbidden results" => "Enabling these options will improve performance, but may show forbidden results",
// "Search Results" => "Search Results",
// "Select the items to display on the search results page" => "Select the items to display on the search results page",
// "Select the information to display for each result" => "Select the information to display for each result",
// "Please see the <a class='rbox-link' target='tikihelp' href='http://dev.tikiwiki.org/Security'>Security page</a> on Tiki's developer site" => "Please see the <a class='rbox-link' target='tikihelp' href='http://dev.tikiwiki.org/Security'>Security page</a> on Tiki's developer site",
// "See <a href=\"tiki-admin_security.php\" title=\"Security\"><strong>Admin &gt; Security Admin</strong></a> for additional security settings" => "See <a href=\"tiki-admin_security.php\" title=\"Security\"><strong>Admin &gt; Security Admin</strong></a> for additional security settings",
// "CSRF Security" => "CSRF Security",
// "Use these options to protect against cross-site request forgeries (CSRF)" => "Use these options to protect against cross-site request forgeries (CSRF)",
// "SEFURL will not work unless Tiki specific directives are deployed to the .htaccess file. You will need to execute htaccess.sh or manually configure the .htaccess file" => "SEFURL will not work unless Tiki specific directives are deployed to the .htaccess file. You will need to execute htaccess.sh or manually configure the .htaccess file",
// "List of Url Parameters that should go in the path" => "List of Url Parameters that should go in the path",
// "Known Types" => "Known Types",
// "Token" => "Token",
// "Invert" => "Invert",
// "Show Usage" => "Show Usage",
// "Delete &amp; Unreference" => "Delete &amp; Unreference",
// "Invert Relation" => "Invert Relation",
// "Self" => "Self",
// "New Types" => "New Types",
// "Fix" => "Fix",
// "No occurences found" => "No occurences found",
// "Text area (that apply throughout many features)" => "Text area (that apply throughout many features)",
// "Wiki paragraph formatting" => "Wiki paragraph formatting",
// "...but still create line breaks within paragraphs" => "...but still create line breaks within paragraphs",
// "Parse wiki syntax in comments in all sections apart from Forums" => "Parse wiki syntax in comments in all sections apart from Forums",
// "&lt;return&gt; for rows" => "&lt;return&gt; for rows",
// "AutoLinks" => "AutoLinks",
// "Open Hotwords in new window" => "Open Hotwords in new window",
// "Use Quote plugin rather than &ldquo;&gt;&rdquo; for quoting" => "Use Quote plugin rather than &ldquo;&gt;&rdquo; for quoting",
// "Plugin disabled" => "Plugin disabled",
// "Default size" => "Default size",
// "Comments " => "Comments ",
// "Forum reply" => "Forum reply",
// "External links and images" => "External links and images",
// "External links will be identified with" => "External links will be identified with",
// "Plugins" => "Plugins",
// "About plugins" => "About plugins",
// "Tiki plugins add functionality to wiki pages, articles and blogs etc. You can enable and disable them below" => "Tiki plugins add functionality to wiki pages, articles and blogs etc. You can enable and disable them below",
// "You can approve plugin use at <a href=\"tiki-plugins.php\">tiki-plugins.php</a>" => "You can approve plugin use at <a href=\"tiki-plugins.php\">tiki-plugins.php</a>",
// "The edit plugin icon is an easy way for users to edit the parameters of each plugin in wiki pages. It can be disabled for individual plugins below" => "The edit plugin icon is an easy way for users to edit the parameters of each plugin in wiki pages. It can be disabled for individual plugins below",
// "Edit plugin icons" => "Edit plugin icons",
// "Enable" => "Enable",
// "Disable edit plugin icon (make plugin inline)" => "Disable edit plugin icon (make plugin inline)",
// "Plugin Aliases" => "Plugin Aliases",
// "About plugin aliases" => "About plugin aliases",
// "Tiki plugin aliases allow you to define your own custom configurations of existing plugins.<br />Find out more here: {help url=\"Plugin+Alias\"}" => "Tiki plugin aliases allow you to define your own custom configurations of existing plugins.<br />Find out more here: {help url=\"Plugin+Alias\"}",
// "This page is designed to work with JQuery {icon _id=\"arrow_right\" href=\"tiki-admin.php?page=features\"}" => "This page is designed to work with JQuery {icon _id=\"arrow_right\" href=\"tiki-admin.php?page=features\"}",
// "Available Alias" => "Available Alias",
// "Enable Plugins" => "Enable Plugins",
// "General Information" => "General Information",
// "Plugin Name" => "Plugin Name",
// "Base Plugin" => "Base Plugin",
// "Body Label" => "Body Label",
// "Dependencies" => "Dependencies",
// "Validation" => "Validation",
// "Inline (No Plugin Edit UI)" => "Inline (No Plugin Edit UI)",
// "Simple Plugin Arguments" => "Simple Plugin Arguments",
// "Argument" => "Argument",
// "New Argument" => "New Argument",
// "Plugin Parameter Documentation" => "Plugin Parameter Documentation",
// "Safe" => "Safe",
// "Plugin Body" => "Plugin Body",
// "Ignore User Input" => "Ignore User Input",
// "Default Content" => "Default Content",
// "Encoding" => "Encoding",
// "Argument Source (if different)" => "Argument Source (if different)",
// "Default Value" => "Default Value",
// "Composed Plugin Arguments" => "Composed Plugin Arguments",
// "Pattern" => "Pattern",
// "To configure your trackers, look for \"Admin trackers\" under \"Trackers\" on the application menu, or" => "To configure your trackers, look for \"Admin trackers\" under \"Trackers\" on the application menu, or",
// "Tracker attachment preferences" => "Tracker attachment preferences",
// "Tracker attachments" => "Tracker attachments",
// "Storage" => "Storage",
// "Switch storage" => "Switch storage",
// "No records" => "No records",
// "Change all to db" => "Change all to db",
// "Change all to file" => "Change all to file",
// "Trackers with mirror tables" => "Trackers with mirror tables",
// "Use trackers with mirror tables" => "Use trackers with mirror tables",
// "Values are stored in a dedicated table for each tracker, then you can easily manipulate them outside Tikiwiki" => "Values are stored in a dedicated table for each tracker, then you can easily manipulate them outside Tikiwiki",
// "WARNING : Old and New trackers cannot coexist. Trackers created with new library will not work with old library and conversely" => "WARNING : Old and New trackers cannot coexist. Trackers created with new library will not work with old library and conversely",
// "Do not use this feature as it is very buggy and unmaintained. It will be pulled out of the code base later on" => "Do not use this feature as it is very buggy and unmaintained. It will be pulled out of the code base later on",
// "Validate choice" => "Validate choice",
// "Enter the URL of a web services returning either JSON or YAML. Parameters can be specified by enclosing a name between percentage signs. For example: %name%. %service% and %template% are reserved keywords and cannot be used" => "Enter the URL of a web services returning either JSON or YAML. Parameters can be specified by enclosing a name between percentage signs. For example: %name%. %service% and %template% are reserved keywords and cannot be used",
// "Lookup" => "Lookup",
// "Test Input" => "Test Input",
// "Response Information" => "Response Information",
// "OIntegrate Version" => "OIntegrate Version",
// "Not supported" => "Not supported",
// "Schema Version" => "Schema Version",
// "Schema Documentation" => "Schema Documentation",
// "Available" => "Available",
// "Not specified, default used" => "Not specified, default used",
// "Content Type" => "Content Type",
// "Not specified" => "Not specified",
// "Returned Data" => "Returned Data",
// "Proposed Templates" => "Proposed Templates",
// "Register this web service. It will be possible to register the templates afterwards. Service name must only contain letters" => "Register this web service. It will be possible to register the templates afterwards. Service name must only contain letters",
// "Register Service" => "Register Service",
// "Registered Templates" => "Registered Templates",
// "Engine" => "Engine",
// "Output" => "Output",
// "Register Template" => "Register Template",
// "Use the 'Quick Edit' module to easily create or edit wiki pages" => "Use the 'Quick Edit' module to easily create or edit wiki pages",
// "Select <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">Admin &gt; Modules</a> to add this (or other) modules" => "Select <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">Admin &gt; Modules</a> to add this (or other) modules",
// "Page display" => "Page display",
// "Page ID" => "Page ID",
// "Page version" => "Page version",
// "List authors" => "List authors",
// "Allow override per page" => "Allow override per page",
// "Not Installed" => "Not Installed",
// "Warn on edit conflict" => "Warn on edit conflict",
// "Edit idle timeout" => "Edit idle timeout",
// "Edit section" => "Edit section",
// "Edit section level" => "Edit section level",
// "Toggle display of section and plugin edit icons" => "Toggle display of section and plugin edit icons",
// "Allow minor edits" => "Allow minor edits",
// "Minor edits do not flag new content for translation and do not send watch notifications" => "Minor edits do not flag new content for translation and do not send watch notifications",
// "Only user groups granted the tiki_p_minor permission (and admins) will be able to save minor edits when this is enabled" => "Only user groups granted the tiki_p_minor permission (and admins) will be able to save minor edits when this is enabled",
// "Log bytes changes (+/-) in action logs" => "Log bytes changes (+/-) in action logs",
// "Display by default" => "Display by default",
// "Manage attachments" => "Manage attachments",
// "Tag for current wiki" => "Tag for current wiki",
// "Restore wiki to tag" => "Restore wiki to tag",
// "Restore" => "Restore",
// "Use File Galleries to store pictures " => "Use File Galleries to store pictures ",
// "WikiWords" => "WikiWords",
// "Accept dashes and underscores in WikiWords" => "Accept dashes and underscores in WikiWords",
// "Link plural WikiWords to their singular forms" => "Link plural WikiWords to their singular forms",
// "Maximum number of versions" => "Maximum number of versions",
// "Never delete versions younger than" => "Never delete versions younger than",
// "Display IP address" => "Display IP address",
// "Default diff style" => "Default diff style",
// "Only with last version" => "Only with last version",
// "HTML diff" => "HTML diff",
// "Side-by-side diff" => "Side-by-side diff",
// "Side-by-side diff by characters" => "Side-by-side diff by characters",
// "Inline diff" => "Inline diff",
// "Inline diff by characters" => "Inline diff by characters",
// "Full side-by-side diff by characters" => "Full side-by-side diff by characters",
// "Full inline diff" => "Full inline diff",
// "Full inline diff by characters" => "Full inline diff by characters",
// "History all instead of only page data, description, and change comment" => "History all instead of only page data, description, and change comment",
// "Forums are disabled" => "Forums are disabled",
// "Forum for discussion" => "Forum for discussion",
// "View source" => "View source",
// "Polls are disabled" => "Polls are disabled",
// "Similar" => "Similar",
// "like pages" => "like pages",
// "Open page as structure" => "Open page as structure",
// "Make structure from page" => "Make structure from page",
// "Categorize structure pages together" => "Categorize structure pages together",
// "Create webhelp from structure" => "Create webhelp from structure",
// "A page can occur multiple times in a structure" => "A page can occur multiple times in a structure",
// "Import HTML" => "Import HTML",
// "Import pages" => "Import pages",
// "Slideshows" => "Slideshows",
// "User's page" => "User's page",
// "UserPage prefix" => "UserPage prefix",
// "Users can lock pages" => "Users can lock pages",
// "Wiki watch" => "Wiki watch",
// "Create watch for author on page creation" => "Create watch for author on page creation",
// "Enable watch events when I am the editor" => "Enable watch events when I am the editor",
// "Enable watches on comments" => "Enable watches on comments",
// "Watch minor edits" => "Watch minor edits",
// "Staging &amp; Approval" => "Staging &amp; Approval",
// "Use wiki page staging and approval" => "Use wiki page staging and approval",
// "Force bounce of editing of approved pages to staging" => "Force bounce of editing of approved pages to staging",
// "Delete staging pages at approval" => "Delete staging pages at approval",
// "If not in the group, edit is always redirected to the staging page edit" => "If not in the group, edit is always redirected to the staging page edit",
// "Unique page name prefix to indicate staging copy" => "Unique page name prefix to indicate staging copy",
// "Hide page name prefix" => "Hide page name prefix",
// "Staging" => "Staging",
// "Approved" => "Approved",
// "(mandatory for feature to work)" => "(mandatory for feature to work)",
// "Out-of-sync" => "Out-of-sync",
// "Categorize approved pages with categories of staging copy on approval" => "Categorize approved pages with categories of staging copy on approval",
// "Freetags are disabled" => "Freetags are disabled",
// "Replace freetags with that of staging pages, on approval" => "Replace freetags with that of staging pages, on approval",
// "Add new freetags of approved copy (into tags field) when editing staging pages" => "Add new freetags of approved copy (into tags field) when editing staging pages",
// "Page Listings" => "Page Listings",
// "Pages not in structure" => "Pages not in structure",
// "Configuration" => "Configuration",
// "Select which items to display when listing pages" => "Select which items to display when listing pages",
// "Name length" => "Name length",
// "Edit comments" => "Edit comments",
// "Edit Comments length" => "Edit Comments length",
// "Categories path" => "Categories path",
// "Wiki 3D Browser Configuration" => "Wiki 3D Browser Configuration",
// "Camera settings" => "Camera settings",
// "Upload Type" => "Upload Type",
// "Data location" => "Data location",
// "HTTP Prefix" => "HTTP Prefix",
// "WebDav username" => "WebDav username",
// "WebDav password" => "WebDav password",
// "Change" => "Change",
// "Wysiwyg means What You See Is What You Get, and is handled in Tikiwiki by <a href=\"http://fckeditor.net\">FCKeditor</a>" => "Wysiwyg means What You See Is What You Get, and is handled in Tikiwiki by <a href=\"http://fckeditor.net\">FCKeditor</a>",
// "Wysiwyg Editor Features" => "Wysiwyg Editor Features",
// "Development Notice" => "Development Notice",
// "Unless a significant amount of preferences are documented and use dynamic preferences before the 4.0 release, this search feature will become disabled by default" => "Unless a significant amount of preferences are documented and use dynamic preferences before the 4.0 release, this search feature will become disabled by default",
// "Database Version Problem" => "Database Version Problem",
// "Your database requires an update to match the current TikiWiki version. Please proceed to <a href=\"tiki-install.php\">the installer</a>. Using Tiki with an incorrect database version usually provoke errors" => "Your database requires an update to match the current TikiWiki version. Please proceed to <a href=\"tiki-install.php\">the installer</a>. Using Tiki with an incorrect database version usually provoke errors",
// "A new version of Tikiwiki, <b>{\$prefs.tiki_release}</b>, is available. You are currently running <b>{\$tiki_version}</b>. Please visit <a href=\"http://tikiwiki.org/Download\">http://tikiwiki.org/Download</a>" => "A new version of Tikiwiki, <b>{\$prefs.tiki_release}</b>, is available. You are currently running <b>{\$tiki_version}</b>. Please visit <a href=\"http://tikiwiki.org/Download\">http://tikiwiki.org/Download</a>",
// "disabled" => "disabled",
// "enabled" => "enabled",
// "preference" => "preference",
// "preference name" => "preference name",
// "Crosslinks to other features and settings" => "Crosslinks to other features and settings",
// "Other sections" => "Other sections",
// "Spreadsheet" => "Spreadsheet",
// "Shoutbox Words" => "Shoutbox Words",
// "Administration features" => "Administration features",
// "TikiCache/System" => "TikiCache/System",
// "SysLogs" => "SysLogs",
// "Mods" => "Mods",
// "Edit Languages" => "Edit Languages",
// "Transversal features" => "Transversal features",
// "which apply to more than one section" => "which apply to more than one section",
// "Navigation features" => "Navigation features",
// "Look & feel" => "Look & feel",
// "themes" => "themes",
// "Text area features" => "Text area features",
// "features you can use in all text areas, like wiki pages, blogs, articles, forums, etc" => "features you can use in all text areas, like wiki pages, blogs, articles, forums, etc",
// "External Pages Cache" => "External Pages Cache",
// "External Wikis" => "External Wikis",
// "Stats &amp; banners" => "Stats &amp; banners",
// "Search Stats" => "Search Stats",
// "Report" => "Report",
// "Please select some actions to view" => "Please select some actions to view",
// "kb" => "kb",
// "Graph Contributions" => "Graph Contributions",
// "Group Bar Plot" => "Group Bar Plot",
// "Accumulated Bar Plot" => "Accumulated Bar Plot",
// "Legend background color" => "Legend background color",
// "Save graphs to image gallery" => "Save graphs to image gallery",
// "See Statistics" => "See Statistics",
// "contribution" => "contribution",
// "contributor" => "contributor",
// "Edit Action" => "Edit Action",
// "Save Action" => "Save Action",
// "Volumes are equally distributed on each contributors/author" => "Volumes are equally distributed on each contributors/author",
// "connection time" => "connection time",
// "connection seconds" => "connection seconds",
// "mns" => "mns",
// "Volumn per category" => "Volumn per category",
// "Volumn per category and per user" => "Volumn per category and per user",
// "Number of actions per user" => "Number of actions per user",
// "Total number of users" => "Total number of users",
// "Number of actions per object" => "Number of actions per object",
// "Total number of objects" => "Total number of objects",
// "Number of actions per category" => "Number of actions per category",
// "Number of actions per category and per user" => "Number of actions per category and per user",
// "Volumn per the users'group and per contribution" => "Volumn per the users'group and per contribution",
// "Volumn per group and per contribution" => "Volumn per group and per contribution",
// "Volumn per user and per contribution" => "Volumn per user and per contribution",
// "Volumn per users'contribution and time" => "Volumn per users'contribution and time",
// "Volumn per contribution and time" => "Volumn per contribution and time",
// "Setting" => "Setting",
// "recorded" => "recorded",
// "Wiki page actions except viewed will always be recorded but can be not reported" => "Wiki page actions except viewed will always be recorded but can be not reported",
// "Create Calendar" => "Create Calendar",
// "View Calendars" => "View Calendars",
// "Subscription" => "Subscription",
// "Perso" => "Perso",
// "View Calendar" => "View Calendar",
// "Add Event" => "Add Event",
// "Create / Edit Calendar" => "Create / Edit Calendar",
// "Create/Edit Calendars" => "Create/Edit Calendars",
// "Custom Participants" => "Custom Participants",
// "Custom URL" => "Custom URL",
// "Custom Subscription List" => "Custom Subscription List",
// "Personal Calendar" => "Personal Calendar",
// "Start of day" => "Start of day",
// "End of day" => "End of day",
// "Standard Colors" => "Standard Colors",
// "Green" => "Green",
// "Blue" => "Blue",
// "Purple" => "Purple",
// "Red" => "Red",
// "Orange" => "Orange",
// "Yellow" => "Yellow",
// "Let me select my own colors" => "Let me select my own colors",
// "Custom foreground color" => "Custom foreground color",
// "Ex" => "Ex",
// "Custom background color" => "Custom background color",
// "Default event status" => "Default event status",
// "Show in calendar view" => "Show in calendar view",
// "Group of users alerted when calendar event is modified" => "Group of users alerted when calendar event is modified",
// "Delete events older than" => "Delete events older than",
// "Browse the category system" => "Browse the category system",
// "Current Category ID" => "Current Category ID",
// "Child categories" => "Child categories",
// "Edit permissions for this category" => "Edit permissions for this category",
// "Remove from this Category" => "Remove from this Category",
// "Use the Administration page of each enabled feature to allow the use of content templates" => "Use the Administration page of each enabled feature to allow the use of content templates",
// "Use in" => "Use in",
// "No features are configured to use templates" => "No features are configured to use templates",
// "Visible in no sections" => "Visible in no sections",
// "Remove section" => "Remove section",
// "Admin Contributions" => "Admin Contributions",
// "Edit the contribution" => "Edit the contribution",
// "Contributions are mandatory in wiki pages" => "Contributions are mandatory in wiki pages",
// "Contributions are mandatory in forums" => "Contributions are mandatory in forums",
// "Contributions are mandatory in comments" => "Contributions are mandatory in comments",
// "Contributions are mandatory in blogs" => "Contributions are mandatory in blogs",
// "Contributions are displayed in the comment/post" => "Contributions are displayed in the comment/post",
// "Create a new contribution" => "Create a new contribution",
// "List of contributions" => "List of contributions",
// "To use cookie in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{cookie}{/literal}" => "To use cookie in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{cookie}{/literal}",
// "Use Admin DSN to define the database to be used by the SQL plugin" => "Use Admin DSN to define the database to be used by the SQL plugin",
// "Admin External Wikis" => "Admin External Wikis",
// "View template" => "View template",
// "tiki admin external wikis template" => "tiki admin external wikis template",
// "Edit template" => "Edit template",
// "Create/Edit External Wiki" => "Create/Edit External Wiki",
// "Create new forum" => "Create new forum",
// "Duplicate forum" => "Duplicate forum",
// "View this forum" => "View this forum",
// "Import forums" => "Import forums",
// ".." => "..",
// "Create/Edit Forums" => "Create/Edit Forums",
// "Only allow replies to the first message (flat forum)" => "Only allow replies to the first message (flat forum)",
// "Posts can be rated" => "Posts can be rated",
// "Display last post titles" => "Display last post titles",
// "Forward messages to this forum to this e-mail address, in a format that can be used for sending back to the inbound forum e-mail address" => "Forward messages to this forum to this e-mail address, in a format that can be used for sending back to the inbound forum e-mail address",
// "Send mails even when the post is generated by inbound mail" => "Send mails even when the post is generated by inbound mail",
// "Append a reply link to outbound mails" => "Append a reply link to outbound mails",
// "Originating e-mail address for mails from this forum" => "Originating e-mail address for mails from this forum",
// "Set topics preferences" => "Set topics preferences",
// "Show topics preferences" => "Show topics preferences",
// "hide topics preferences" => "hide topics preferences",
// "Set thread preferences" => "Set thread preferences",
// "Show threads preferences" => "Show threads preferences",
// "hide threads preferences" => "hide threads preferences",
// "Default style for threads" => "Default style for threads",
// "Duplicate Forum" => "Duplicate Forum",
// "Duplicate perms" => "Duplicate perms",
// "Duplicate" => "Duplicate",
// "Admin HTML Page Dynamic Zones" => "Admin HTML Page Dynamic Zones",
// "Use {literal}{ed id=name}{/literal} or {literal}{ted id=name}{/literal} to insert dynamic zones" => "Use {literal}{ed id=name}{/literal} or {literal}{ted id=name}{/literal} to insert dynamic zones",
// "Refresh rate (if dynamic)" => "Refresh rate (if dynamic)",
// "Admin dynamic zones" => "Admin dynamic zones",
// "An easier way to integrate content from another site into Tiki is via iframed links using Tiki's <a class=\"rbox-link\" href=\"tiki-admin_links.php\">featured links</a> feature" => "An easier way to integrate content from another site into Tiki is via iframed links using Tiki's <a class=\"rbox-link\" href=\"tiki-admin_links.php\">featured links</a> feature",
// "Edit Repository" => "Edit Repository",
// "Create New Repository" => "Create New Repository",
// "List Repositories" => "List Repositories",
// "New Repository" => "New Repository",
// "View Repository" => "View Repository",
// "Human readable repository name" => "Human readable repository name",
// "Path to repository (local filesystem: relative/absolute web root, remote: prefixed with 'http://')" => "Path to repository (local filesystem: relative/absolute web root, remote: prefixed with 'http://')",
// "File name of start page" => "File name of start page",
// "Start page" => "Start page",
// "CSS file to load when browse this repository" => "CSS file to load when browse this repository",
// "CSS file" => "CSS file",
// "Is repository visible to users" => "Is repository visible to users",
// "Can files from repository be cached" => "Can files from repository be cached",
// "Cacheable" => "Cacheable",
// "Are files from repository can be cached" => "Are files from repository can be cached",
// "Clear all cached pages of this repository" => "Clear all cached pages of this repository",
// "Clear cache" => "Clear cache",
// "Seconds count 'till cached page will be expired" => "Seconds count 'till cached page will be expired",
// "Cache expiration" => "Cache expiration",
// "Human readable text description of repository" => "Human readable text description of repository",
// "Available Repositories" => "Available Repositories",
// "CSS File" => "CSS File",
// "Edit rules" => "Edit rules",
// "Edit Rules for Repository" => "Edit Rules for Repository",
// "Configure Repositories" => "Configure Repositories",
// "Configure this Repository" => "Configure this Repository",
// "View this Repository" => "View this Repository",
// "New Rule" => "New Rule",
// "Copy Rules" => "Copy Rules",
// "view/hide copy rules dialog" => "view/hide copy rules dialog",
// "Source repository" => "Source repository",
// "Copy" => "Copy",
// "According this order rules will be applied ('0' or empty = auto)" => "According this order rules will be applied ('0' or empty = auto)",
// "Rule order" => "Rule order",
// "Text to search for" => "Text to search for",
// "Text to replace" => "Text to replace",
// "Is this regular expression or simple search/replacer" => "Is this regular expression or simple search/replacer",
// "Regex" => "Regex",
// "Is case sensitive (for simple replacer)" => "Is case sensitive (for simple replacer)",
// "Case sensitive" => "Case sensitive",
// "subset of chars: imsxeADSXUu, which is regex modifiers" => "subset of chars: imsxeADSXUu, which is regex modifiers",
// "Regex modifiers" => "Regex modifiers",
// "Human readable text description of rule" => "Human readable text description of rule",
// "Check to enable this rule" => "Check to enable this rule",
// "Enabled" => "Enabled",
// "Preview options" => "Preview options",
// "Apply all rules or just this to generate preview" => "Apply all rules or just this to generate preview",
// "Apply all rules" => "Apply all rules",
// "View source code after rules applied" => "View source code after rules applied",
// "Code preview" => "Code preview",
// "Generate HTML preview" => "Generate HTML preview",
// "HTML preview" => "HTML preview",
// "Test file from repository to generate preview for (empty = configured start page)" => "Test file from repository to generate preview for (empty = configured start page)",
// "Preview Results" => "Preview Results",
// "Rules List" => "Rules List",
// "Case" => "Case",
// "Configure/Options" => "Configure/Options",
// "To use these links, you must assign the featured_links <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a>" => "To use these links, you must assign the featured_links <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a>",
// "Mail-in accounts" => "Mail-in accounts",
// "Account" => "Account",
// "Add new Mail-in account" => "Add new Mail-in account",
// "Edit Mail-in account" => "Edit Mail-in account",
// "article-put" => "article-put",
// "Article Topic" => "Article Topic",
// "Article Type" => "Article Type",
// "Admin Types" => "Admin Types",
// "Allow anonymous acces" => "Allow anonymous acces",
// "Allow attachments" => "Allow attachments",
// "Discard to the end from" => "Discard to the end from",
// "Check Mail-in accounts" => "Check Mail-in accounts",
// "Check automatically" => "Check automatically",
// "mn" => "mn",
// "Show Quick Urls" => "Show Quick Urls",
// "Hide Quick Urls" => "Hide Quick Urls",
// "For wiki page, use ((PageName))" => "For wiki page, use ((PageName))",
// "Separate multiple sections with a comma ( , ) for an AND or a vertical bar ( | ) for an OR" => "Separate multiple sections with a comma ( , ) for an AND or a vertical bar ( | ) for an OR",
// "Separate multiple permissions with a comma ( , ) for an AND or a vertical bar ( | ) for an OR" => "Separate multiple permissions with a comma ( , ) for an AND or a vertical bar ( | ) for an OR",
// "Use Ctrl+Click to select multiple groups" => "Use Ctrl+Click to select multiple groups",
// "Selecting 2 groups means that the option will be seen if the user belongs to the 2 groups. If you want the 2 groups to see the option, create 2 options with one group each" => "Selecting 2 groups means that the option will be seen if the user belongs to the 2 groups. If you want the 2 groups to see the option, create 2 options with one group each",
// "If the url is ((PageName)), you do not need to put the groups, the option will be displayed only if the page can be displayed" => "If the url is ((PageName)), you do not need to put the groups, the option will be displayed only if the page can be displayed",
// "section level 0" => "section level 0",
// "section level 1" => "section level 1",
// "section level 2" => "section level 2",
// "section level 3" => "section level 3",
// "sorted section level 0" => "sorted section level 0",
// "separator" => "separator",
// "Choose" => "Choose",
// "switch with previous option" => "switch with previous option",
// "switch with next option" => "switch with next option",
// "Export CSV data" => "Export CSV data",
// "Import CSV data" => "Import CSV data",
// "To add new options to the menu set the optionId field to 0. To remove an option set the remove field to 'y'" => "To add new options to the menu set the optionId field to 0. To remove an option set the remove field to 'y'",
// "Active Permissions" => "Active Permissions",
// "Create/Edit Menu" => "Create/Edit Menu",
// "Icons" => "Icons",
// "Folder Icon" => "Folder Icon",
// "Path and filename of closed folder icon" => "Path and filename of closed folder icon",
// "To use custom folder icons in menus, enter the path to the icon for the <strong>closed</strong> folder" => "To use custom folder icons in menus, enter the path to the icon for the <strong>closed</strong> folder",
// "In the same directory, include an icon for the opened folder" => "In the same directory, include an icon for the opened folder",
// "The \"opened folder\" icon name must be identical to the \"closed folder\" icon name, prefixed with the letter <strong>o</strong>" => "The \"opened folder\" icon name must be identical to the \"closed folder\" icon name, prefixed with the letter <strong>o</strong>",
// "Configure icons for menu entries" => "Configure icons for menu entries",
// "To use menus in a <a href=\"tiki-admin_modules.php\">module</a>, <a href=\"tiki-admin.php?page=look\">Look and Feel</a> or a template, use {literal}{menu id=x}{/literal}, where x is the ID of the menu" => "To use menus in a <a href=\"tiki-admin_modules.php\">module</a>, <a href=\"tiki-admin.php?page=look\">Look and Feel</a> or a template, use {literal}{menu id=x}{/literal}, where x is the ID of the menu",
// "To use <a target=\"tikihelp\" href=\"http://phplayersmenu.sourceforge.net/\">phplayersmenu</a>, you can use one of the three following syntaxes" => "To use <a target=\"tikihelp\" href=\"http://phplayersmenu.sourceforge.net/\">phplayersmenu</a>, you can use one of the three following syntaxes",
// "This will work well (or not!) depending on your theme. To learn more about <a target=\"tikihelp\" href=\"http://themes.tikiwiki.org\">themes</a>" => "This will work well (or not!) depending on your theme. To learn more about <a target=\"tikihelp\" href=\"http://themes.tikiwiki.org\">themes</a>",
// "To use a menu in a tiki format" => "To use a menu in a tiki format",
// "To use menu in a css/suckerfish format" => "To use menu in a css/suckerfish format",
// "To customize the menu's CSS id (#)" => "To customize the menu's CSS id (#)",
// "The following required parameters are missing" => "The following required parameters are missing",
// "Assign/Edit modules" => "Assign/Edit modules",
// "Move Up" => "Move Up",
// "Move Down" => "Move Down",
// "assign_name\">Module Name" => "assign_name\">Module Name",
// "Params: specific params to the module and/or general params ('lang', 'flip', 'title', 'decorations', 'section', 'overflow', 'page', 'nobox', 'bgcolor', 'color', 'theme', 'notitle', 'nopage'). Separator between params:'&amp;'. E.g. maxlen=15&amp;nonums=y" => "Params: specific params to the module and/or general params ('lang', 'flip', 'title', 'decorations', 'section', 'overflow', 'page', 'nobox', 'bgcolor', 'color', 'theme', 'notitle', 'nopage'). Separator between params:'&amp;'. E.g. maxlen=15&amp;nonums=y",
// "The" => "The",
// "Display Modules to All Groups" => "Display Modules to All Groups",
// "setting will override your selection of specific groups" => "setting will override your selection of specific groups",
// "Visibility" => "Visibility",
// "Displayed now for all eligible users even with personal assigned modules" => "Displayed now for all eligible users even with personal assigned modules",
// "Displayed for the eligible users with no personal assigned modules" => "Displayed for the eligible users with no personal assigned modules",
// "Displayed now, can't be unassigned" => "Displayed now, can't be unassigned",
// "Not displayed until a user chooses it" => "Not displayed until a user chooses it",
// "Because <a class=\"rbox-link\" href=\"tiki-admin.php?page=module\">Users can Configure Modules</a>, select either" => "Because <a class=\"rbox-link\" href=\"tiki-admin.php?page=module\">Users can Configure Modules</a>, select either",
// "to make sure users will notice any newly assigned modules" => "to make sure users will notice any newly assigned modules",
// "Create your new custom module below. Make sure to preview first and make sure all is OK before <a href=\"#assign\">assigning it</a>. Using html, you will be fine. However, if you improperly use wiki syntax or Smarty code, you could lock yourself out of the site" => "Create your new custom module below. Make sure to preview first and make sure all is OK before <a href=\"#assign\">assigning it</a>. Using html, you will be fine. However, if you improperly use wiki syntax or Smarty code, you could lock yourself out of the site",
// "Must be wiki parsed" => "Must be wiki parsed",
// "Random active poll" => "Random active poll",
// "Random current poll" => "Random current poll",
// "phpLayersMenus" => "phpLayersMenus",
// "Use phplayermenu" => "Use phplayermenu",
// "Use Wiki Structure" => "Use Wiki Structure",
// "Edit Newsletter" => "Edit Newsletter",
// "You can add several email addresses by separating them with commas" => "You can add several email addresses by separating them with commas",
// "Add email" => "Add email",
// "Add user" => "Add user",
// "Group users" => "Group users",
// "Group subscription also subscribes included groups" => "Group subscription also subscribes included groups",
// "Don't send confirmation mail" => "Don't send confirmation mail",
// "The user email will be refreshed at each newsletter sending" => "The user email will be refreshed at each newsletter sending",
// "Batch e-mail subscribe" => "Batch e-mail subscribe",
// "txt file, one e-mail per line" => "txt file, one e-mail per line",
// "Export Subscriber Emails" => "Export Subscriber Emails",
// "Subscribe group" => "Subscribe group",
// "Included group, group users and emails will be refreshed at each newsletter sending" => "Included group, group users and emails will be refreshed at each newsletter sending",
// "Add subscribers of another newsletter" => "Add subscribers of another newsletter",
// "Create Newsletter" => "Create Newsletter",
// "Drafts" => "Drafts",
// "Users can subscribe/unsubscribe to this list" => "Users can subscribe/unsubscribe to this list",
// "Users can subscribe any email address" => "Users can subscribe any email address",
// "Add unsubscribe instructions to each newsletter" => "Add unsubscribe instructions to each newsletter",
// "Validate email addresses" => "Validate email addresses",
// "Allow customized text message to be sent with the html version" => "Allow customized text message to be sent with the html version",
// "Mail notifications" => "Mail notifications",
// "You need to set <a href=\"tiki-admin.php?page=general\">Sender Email</a> before creating email notifications" => "You need to set <a href=\"tiki-admin.php?page=general\">Sender Email</a> before creating email notifications",
// "Alert" => "Alert",
// "Preload Admin Account" => "Preload Admin Account",
// "User / Group" => "User / Group",
// "Multiple" => "Multiple",
// "Trackers Outbound Emails" => "Trackers Outbound Emails",
// "Forums Outbound Emails" => "Forums Outbound Emails",
// "Admin page lists" => "Admin page lists",
// "Current lists" => "Current lists",
// "Edit this list" => "Edit this list",
// "Remove this list" => "Remove this list",
// "Edit list" => "Edit list",
// "Add list" => "Add list",
// "Seed with pages from a category" => "Seed with pages from a category",
// "Add page" => "Add page",
// "Page priority" => "Page priority",
// "Page score" => "Page score",
// "Edit {\$list.name|escape}" => "Edit {\$list.name|escape}",
// "Add poll option" => "Add poll option",
// "Edit poll option" => "Edit poll option",
// "Create poll" => "Create poll",
// "Edit poll" => "Edit poll",
// "Toggle Quick Options" => "Toggle Quick Options",
// "Add Option" => "Add Option",
// "Leave box empty for deleting an option" => "Leave box empty for deleting an option",
// "Votes older than these days are no more considered" => "Votes older than these days are no more considered",
// "0 for no limit" => "0 for no limit",
// "Add poll to pages" => "Add poll to pages",
// "This menu shows only Polls with 'status': \"template\"" => "This menu shows only Polls with 'status': \"template\"",
// "Wiki pages" => "Wiki pages",
// "Use Ctrl+Click to select multiple pages" => "Use Ctrl+Click to select multiple pages",
// "Lock the pages" => "Lock the pages",
// "Admin External Feeds" => "Admin External Feeds",
// "Tips" => "Tips",
// "This page is to configure settings of external feeds read/imported by Tiki. To generate/export feeds, look for \"Feeds\" on the admin panel, or" => "This page is to configure settings of external feeds read/imported by Tiki. To generate/export feeds, look for \"Feeds\" on the admin panel, or",
// "To use feeds in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{rss id=x}{/literal}, where x is the ID of the feed" => "To use feeds in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{rss id=x}{/literal}, where x is the ID of the feed",
// "Edit this feed" => "Edit this feed",
// "Create new external feed" => "Create new external feed",
// "show feed title" => "show feed title",
// "show publish date" => "show publish date",
// "Show Date" => "Show Date",
// "View feed" => "View feed",
// "Security Admin" => "Security Admin",
// "To <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://security.tikiwiki.org/tiki-contact.php\">report any security issues</a>" => "To <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://security.tikiwiki.org/tiki-contact.php\">report any security issues</a>",
// "PHP settings" => "PHP settings",
// "PHP variable" => "PHP variable",
// "Risk Factor" => "Risk Factor",
// "Explanation" => "Explanation",
// "PHP functions" => "PHP functions",
// "Function" => "Function",
// "To disallow a function, add a disable_functions=exec,passthru for instance in your php.ini" => "To disallow a function, add a disable_functions=exec,passthru for instance in your php.ini",
// "TikiWiki settings" => "TikiWiki settings",
// "Tiki variable" => "Tiki variable",
// "About WikiPlugins and security: Make sure to only grant the \"tiki_p_plugin_approve\" permission to trusted editors" => "About WikiPlugins and security: Make sure to only grant the \"tiki_p_plugin_approve\" permission to trusted editors",
// "You can deactivate risky plugins at (<a href=\"tiki-admin.php?page=textarea\">tiki-admin.php?page=textarea</a>)" => "You can deactivate risky plugins at (<a href=\"tiki-admin.php?page=textarea\">tiki-admin.php?page=textarea</a>)",
// "Security checks" => "Security checks",
// "Check all tiki files" => "Check all tiki files",
// "Note, that this can take a very long time. You should check your max_execution_time setting in php.ini" => "Note, that this can take a very long time. You should check your max_execution_time setting in php.ini",
// "File checks" => "File checks",
// "Check file permissions" => "Check file permissions",
// "This check tries to find files with problematic file permissions. Some file permissions that are shown here as problematic may be unproblematic or unavoidable in some environments" => "This check tries to find files with problematic file permissions. Some file permissions that are shown here as problematic may be unproblematic or unavoidable in some environments",
// "See end of table for detailed explanations" => "See end of table for detailed explanations",
// "owner" => "owner",
// "special" => "special",
// "other" => "other",
// "uid" => "uid",
// "gid" => "gid",
// "suid" => "suid",
// "sgid" => "sgid",
// "r" => "r",
// "w" => "w",
// "Set User ID (suid) files" => "Set User ID (suid) files",
// "World writable files or directories" => "World writable files or directories",
// "Files or directories the Webserver can write to" => "Files or directories the Webserver can write to",
// "Strange Inodes (not file, not link, not directory)" => "Strange Inodes (not file, not link, not directory)",
// "Executable files" => "Executable files",
// "What to do with these check results" => "What to do with these check results",
// "Suid files are not part of tiki and there is no need for suid files in a webspace. Sometimes intruders that gain elevated privileges leave suid files to \"keep the door open\"" => "Suid files are not part of tiki and there is no need for suid files in a webspace. Sometimes intruders that gain elevated privileges leave suid files to \"keep the door open\"",
// "In some environments where you cannot get root or have no other possibilities, it is unavoidable to let your webserver write to some tiki directories like \"templates_c\" or \"temp\". In any other case this is not needed. A bug in a script or other users could easily put malicious scripts on your webspace or upload illegal content" => "In some environments where you cannot get root or have no other possibilities, it is unavoidable to let your webserver write to some tiki directories like \"templates_c\" or \"temp\". In any other case this is not needed. A bug in a script or other users could easily put malicious scripts on your webspace or upload illegal content",
// "The risk is almost the same in shared hosting environments without proper privilege separation (suexec wrappers). The webserver has to be able to write to some directories like \"templates_c\" or \"temp\". Review the tiki install guide for further information" => "The risk is almost the same in shared hosting environments without proper privilege separation (suexec wrappers). The webserver has to be able to write to some directories like \"templates_c\" or \"temp\". Review the tiki install guide for further information",
// "Inodes that are not files or directories are not part of tiki. Review these Inodes" => "Inodes that are not files or directories are not part of tiki. Review these Inodes",
// "Setting the executable bit can be dangerous if the webserver is configured to execute cgi scripts from that directories. If you use the usual php module (for apache) then php scripts and other files in tiki do not need to have the executable bit. You can safely remove the executable bit with chmod" => "Setting the executable bit can be dangerous if the webserver is configured to execute cgi scripts from that directories. If you use the usual php module (for apache) then php scripts and other files in tiki do not need to have the executable bit. You can safely remove the executable bit with chmod",
// "Admin Shoutbox Words" => "Admin Shoutbox Words",
// "Add Banned Word" => "Add Banned Word",
// "Are you sure you want to delete this word" => "Are you sure you want to delete this word",
// "XML Zip Import" => "XML Zip Import",
// "The structure" => "The structure",
// "has just been created" => "has just been created",
// "You will remove structure" => "You will remove structure",
// "Note that the following pages are also part of another structure. Make sure that access permissions (if any) do not conflict" => "Note that the following pages are also part of another structure. Make sure that access permissions (if any) do not conflict",
// "The following pages have automatically been categorized with the same categories as the structure" => "The following pages have automatically been categorized with the same categories as the structure",
// "The following pages have categories but the structure has none. You may wish to uncategorize them to be consistent" => "The following pages have categories but the structure has none. You may wish to uncategorize them to be consistent",
// "The following pages are in categories that the structure is not in. You may wish to recategorize them in order to be consistent" => "The following pages are in categories that the structure is not in. You may wish to recategorize them in order to be consistent",
// "Edit structure" => "Edit structure",
// "View structure" => "View structure",
// "PDF" => "PDF",
// "Create WebHelp" => "Create WebHelp",
// "View WebHelp" => "View WebHelp",
// "XML Zip" => "XML Zip",
// "Alias" => "Alias",
// "Create New Structure" => "Create New Structure",
// "Add a New Question" => "Add a New Question",
// "This survey stats" => "This survey stats",
// "Edit Survey Question" => "Edit Survey Question",
// "Add a New Question to this survey" => "Add a New Question to this survey",
// "Multiple choices of thumbnails from a file gallery" => "Multiple choices of thumbnails from a file gallery",
// "Wiki textarea" => "Wiki textarea",
// "Rate" => "Rate",
// "Answer is mandatory" => "Answer is mandatory",
// "Number of required answers (for multiple choices)" => "Number of required answers (for multiple choices)",
// "For a multiple answer question put the answers into the following field, separated by a comma. Example: one,two,many,lots" => "For a multiple answer question put the answers into the following field, separated by a comma. Example: one,two,many,lots",
// "For a rate, you can give the maximum value" => "For a rate, you can give the maximum value",
// "For the 'multiple choices of thumbnail from a file gallery' type, options are: Gallery ID. Example: 4" => "For the 'multiple choices of thumbnail from a file gallery' type, options are: Gallery ID. Example: 4",
// "Create/Edit Surveys" => "Create/Edit Surveys",
// "Create New Survey" => "Create New Survey",
// "Closed" => "Closed",
// "Tiki Cache/System Admin" => "Tiki Cache/System Admin",
// "If your Tiki is acting weird, first thing to try is to clear your cache below. Also very important is to clear your cache after an upgrade (by FTP/SSH when needed)" => "If your Tiki is acting weird, first thing to try is to clear your cache below. Also very important is to clear your cache after an upgrade (by FTP/SSH when needed)",
// "Exterminator of cached content" => "Exterminator of cached content",
// "Directory to exterminate" => "Directory to exterminate",
// "Clear all Tiki caches" => "Clear all Tiki caches",
// "Empty" => "Empty",
// "All user prefs sessions" => "All user prefs sessions",
// "Directories to save" => "Directories to save",
// "Full Path to the Zip File" => "Full Path to the Zip File",
// "Generate a zip of those directories" => "Generate a zip of those directories",
// "A zip has been written to {\$zipPath}" => "A zip has been written to {\$zipPath}",
// "Directory is not writeable" => "Directory is not writeable",
// "Advanced feature" => "Advanced feature",
// "Fix UTF-8 Errors in Tables" => "Fix UTF-8 Errors in Tables",
// "Warning: Make a backup of your Database before using this function" => "Warning: Make a backup of your Database before using this function",
// "Warning: If you try to convert large tables, raise the maximum execution time in your php.ini" => "Warning: If you try to convert large tables, raise the maximum execution time in your php.ini",
// "This function converts ISO-8859-1 encoded strings in your tables to UTF-8" => "This function converts ISO-8859-1 encoded strings in your tables to UTF-8",
// "This may be necessary if you created content with tiki &lt; 1.8.4 and Default Charset settings in apache set to ISO-8859-1" => "This may be necessary if you created content with tiki &lt; 1.8.4 and Default Charset settings in apache set to ISO-8859-1",
// "UTF-8 Errors fixed" => "UTF-8 Errors fixed",
// "Investigate" => "Investigate",
// "Fix it" => "Fix it",
// "View mode" => "View mode",
// "Wiki and WYSIWYG" => "Wiki and WYSIWYG",
// "Wiki only" => "Wiki only",
// "WYSIWYG only" => "WYSIWYG only",
// "Load" => "Load",
// "Reset to Global" => "Reset to Global",
// "Reset to defaults" => "Reset to defaults",
// "Auto Reloading" => "Auto Reloading",
// "Row" => "Row",
// "Formatting Tools" => "Formatting Tools",
// "Plugin Tools" => "Plugin Tools",
// "Edit tool" => "Edit tool",
// "Wysiwyg Token" => "Wysiwyg Token",
// "Plugin name" => "Plugin name",
// "Custom Tools" => "Custom Tools",
// "Add a new custom tool" => "Add a new custom tool",
// "To configure the toolbars on the various text editing areas select the section, and optionally check the comments checkbox, you want to edit and drag the icons from the left hand box to the toolbars on the right.<br />\nDrag icons back from the toolbar rows onto the full list to remove them.<br />\nIcons with <strong>bold</strong> labels are for wiki text areas, those that are <em>italic</em> are for WYSIWYG mode, and those that are <strong><em>bold and italic</em></strong> are for both.<br />\nTo save the current set use the dropdown (and optionally check the comments checkbox) at the bottom of the page to set where you want these toolbars to appear, and click Save" => "To configure the toolbars on the various text editing areas select the section, and optionally check the comments checkbox, you want to edit and drag the icons from the left hand box to the toolbars on the right.<br />\nDrag icons back from the toolbar rows onto the full list to remove them.<br />\nIcons with <strong>bold</strong> labels are for wiki text areas, those that are <em>italic</em> are for WYSIWYG mode, and those that are <strong><em>bold and italic</em></strong> are for both.<br />\nTo save the current set use the dropdown (and optionally check the comments checkbox) at the bottom of the page to set where you want these toolbars to appear, and click Save",
// "Inactive - Click to Activate" => "Inactive - Click to Activate",
// "Active - Click to Deactivate" => "Active - Click to Deactivate",
// "Remove with articles" => "Remove with articles",
// "Mandatory" => "Mandatory",
// "Searchable" => "Searchable",
// "Field is public? (viewed in trackerlist plugin)" => "Field is public? (viewed in trackerlist plugin)",
// "Hidden" => "Hidden",
// "New tracker field" => "New tracker field",
// "Select list items that will be displayed" => "Select list items that will be displayed",
// "Field is mandatory" => "Field is mandatory",
// "Multilingual content" => "Multilingual content",
// "Column is searchable" => "Column is searchable",
// "Field is hidden" => "Field is hidden",
// "not hidden" => "not hidden",
// "visible to admin only" => "visible to admin only",
// "editable by admin only" => "editable by admin only",
// "visible by creator &amp; admin only" => "visible by creator &amp; admin only",
// "The option creator needs a field of type user selector and option 1" => "The option creator needs a field of type user selector and option 1",
// "Visible by" => "Visible by",
// "Editable by" => "Editable by",
// "Description text is wiki-parsed" => "Description text is wiki-parsed",
// "Error message" => "Error message",
// "Import/Export Trackers Fields" => "Import/Export Trackers Fields",
// "Export fieldId also" => "Export fieldId also",
// "Check the box to re-import in this tracker and change the fields" => "Check the box to re-import in this tracker and change the fields",
// "Uncheck the box to import in another database" => "Uncheck the box to import in another database",
// "Edit This Tracker's Fields" => "Edit This Tracker's Fields",
// "with" => "with",
// "Edit Tracker" => "Edit Tracker",
// "Create Tracker" => "Create Tracker",
// "Create/Edit Tracker" => "Create/Edit Tracker",
// "Auto create corresponding categories" => "Auto create corresponding categories",
// "Create a group for each item" => "Create a group for each item",
// "Groups will include" => "Groups will include",
// "Creator is assigned to the group" => "Creator is assigned to the group",
// "and it becomes his default group" => "and it becomes his default group",
// "and it becomes the new item group creator" => "and it becomes the new item group creator",
// "But copy the default group in this fiedlId before updating the group" => "But copy the default group in this fiedlId before updating the group",
// "Use \"explicit\" names in the mirror table" => "Use \"explicit\" names in the mirror table",
// "tracker name must be unique, field names must be unique for a tracker and they must be valid in SQL" => "tracker name must be unique, field names must be unique for a tracker and they must be valid in SQL",
// "Show status" => "Show status",
// "Default status displayed in list mode" => "Default status displayed in list mode",
// "Show status to tracker admin only" => "Show status to tracker admin only",
// "Send copies of all activity in this tracker to this e-mail address" => "Send copies of all activity in this tracker to this e-mail address",
// "Use simplified e-mail format" => "Use simplified e-mail format",
// "The tracker will use the text field named Subject if any as subject and will use the user email or for anonymous the email field if any as sender" => "The tracker will use the text field named Subject if any as subject and will use the user email or for anonymous the email field if any as sender",
// "New items are created with status" => "New items are created with status",
// "Authoritative status for modified items" => "Authoritative status for modified items",
// "No change" => "No change",
// "Item creator can modify his items" => "Item creator can modify his items",
// "The tracker needs a user field with the option 1" => "The tracker needs a user field with the option 1",
// "User can take ownership of item created by anonymous" => "User can take ownership of item created by anonymous",
// "Only one item per user or IP" => "Only one item per user or IP",
// "The tracker needs a user or IP field with the option 1" => "The tracker needs a user or IP field with the option 1",
// "Member of the creator group can modify items" => "Member of the creator group can modify items",
// "The tracker needs a group field with the option 1" => "The tracker needs a group field with the option 1",
// "Format if not the default short one" => "Format if not the default short one",
// "Show creation date when viewing tracker item" => "Show creation date when viewing tracker item",
// "Identify creation user in tracker item" => "Identify creation user in tracker item",
// "Show lastModif date when viewing tracker item" => "Show lastModif date when viewing tracker item",
// "Identify lastModif user in tracker item" => "Identify lastModif user in tracker item",
// "What field is used for default sort" => "What field is used for default sort",
// "LastModif" => "LastModif",
// "ItemId" => "ItemId",
// "What is default sort order in list" => "What is default sort order in list",
// "ascending" => "ascending",
// "descending" => "descending",
// "Tracker items allow ratings" => "Tracker items allow ratings",
// "with values" => "with values",
// "and display rating results in listing" => "and display rating results in listing",
// "and display comments in listing" => "and display comments in listing",
// "and display last comment user/date" => "and display last comment user/date",
// "and display attachments in listing" => "and display attachments in listing",
// "Attachment display options (Use numbers to order items, 0 will not be displayed, and negative values display in popups)" => "Attachment display options (Use numbers to order items, 0 will not be displayed, and negative values display in popups)",
// "Filetype" => "Filetype",
// "LongDesc" => "LongDesc",
// "Items can be created only during a certain time" => "Items can be created only during a certain time",
// "Do not show empty fields in item view" => "Do not show empty fields in item view",
// "Show these fields (ID comma separated) in a popup on item link when listing tracker items" => "Show these fields (ID comma separated) in a popup on item link when listing tracker items",
// "Group of users alerted when tracker is modified" => "Group of users alerted when tracker is modified",
// "Import/Export" => "Import/Export",
// "Import/export trackers" => "Import/export trackers",
// "Date Format" => "Date Format",
// "timestamp" => "timestamp",
// "Charset encoding" => "Charset encoding",
// "UTF-8" => "UTF-8",
// "ISO-8859-1" => "ISO-8859-1",
// "Duplicate Tracker" => "Duplicate Tracker",
// "Add new group" => "Add new group",
// "Manage permissions" => "Manage permissions",
// "Inherits Permissions from" => "Inherits Permissions from",
// "User Choice" => "User Choice",
// "Edit group" => "Edit group",
// "Add a New Group" => "Add a New Group",
// "Inherit permissions directly from following groups" => "Inherit permissions directly from following groups",
// "Selected groups only. Use Ctrl+Click to select more than one" => "Selected groups only. Use Ctrl+Click to select more than one",
// "Also inheriting permissions from the following groups (indirect inheritance through the groups selected above)" => "Also inheriting permissions from the following groups (indirect inheritance through the groups selected above)",
// "Group Homepage" => "Group Homepage",
// "Use wiki page name or full URL" => "Use wiki page name or full URL",
// "For other Tiki features, use relative links (such as <em>http:tiki-forums.php</em>)" => "For other Tiki features, use relative links (such as <em>http:tiki-forums.php</em>)",
// "Default category assigned to uncategorized objects edited by a user with this default group" => "Default category assigned to uncategorized objects edited by a user with this default group",
// "Group Theme" => "Group Theme",
// "Use site default" => "Use site default",
// "Group Information Tracker" => "Group Information Tracker",
// "choose a group tracker .." => "choose a group tracker ..",
// "choose a field .." => "choose a field ..",
// "Users Information Tracker" => "Users Information Tracker",
// "choose a users tracker .." => "choose a users tracker ..",
// "Users Information Tracker Fields Asked at Registration Time<br />(fieldIds separated with :)" => "Users Information Tracker Fields Asked at Registration Time<br />(fieldIds separated with :)",
// "User can assign to the group himself" => "User can assign to the group himself",
// "Users are automatically unassigned from the group after" => "Users are automatically unassigned from the group after",
// "0 or empty for never" => "0 or empty for never",
// "Assign group <em>management</em> permissions" => "Assign group <em>management</em> permissions",
// "Group tracker item : {\$groupitemid}" => "Group tracker item : {\$groupitemid}",
// "Group tracker item not found" => "Group tracker item not found",
// "Create Item" => "Create Item",
// "Choose a field .." => "Choose a field ..",
// "Members" => "Members",
// "Members List" => "Members List",
// "Remove from Group" => "Remove from Group",
// "users in group" => "users in group",
// "Add to group" => "Add to group",
// "Download CSV export" => "Download CSV export",
// "Assign users to group" => "Assign users to group",
// "Each user in the file must already exist" => "Each user in the file must already exist",
// "To create users or/and assign them to groups, got to <a href=\"tiki-adminusers.php\">admin->users</a>" => "To create users or/and assign them to groups, got to <a href=\"tiki-adminusers.php\">admin->users</a>",
// "CSV File" => "CSV File",
// "Since this tiki site is in slave mode and import groups, the master groups will be automatically reimported at each login" => "Since this tiki site is in slave mode and import groups, the master groups will be automatically reimported at each login",
// "Since this tiki site is in slave mode and import preferences, the master user preferences will be automatically reimported at each login" => "Since this tiki site is in slave mode and import preferences, the master user preferences will be automatically reimported at each login",
// "Feedback" => "Feedback",
// "Updated users" => "Updated users",
// "More Criteria" => "More Criteria",
// "Group (direct)" => "Group (direct)",
// "Edit Account Settings" => "Edit Account Settings",
// "Registered" => "Registered",
// "ago" => "ago",
// "Need to validate email" => "Need to validate email",
// "Assign to group" => "Assign to group",
// "Edit Included Group" => "Edit Included Group",
// "Edit Group" => "Edit Group",
// "Change user preferences" => "Change user preferences",
// "Validate user" => "Validate user",
// "Confirm user email" => "Confirm user email",
// "Invalid email" => "Invalid email",
// "Remove Users and their Userpages" => "Remove Users and their Userpages",
// "Manage Group Assignments" => "Manage Group Assignments",
// "Set Default Groups" => "Set Default Groups",
// "Send a wiki page by Email" => "Send a wiki page by Email",
// "Assign selected to" => "Assign selected to",
// "Remove selected from" => "Remove selected from",
// "the following groups" => "the following groups",
// "Tip: Hold down CTRL to select multiple" => "Tip: Hold down CTRL to select multiple",
// "Set the default group of the selected users to" => "Set the default group of the selected users to",
// "Template wiki page" => "Template wiki page",
// "Edit user" => "Edit user",
// "Assign user to Groups" => "Assign user to Groups",
// "Use the email as username" => "Use the email as username",
// "Lowercase only" => "Lowercase only",
// "Warning: changing the username could require the user to change his password (for user registered with an old tikiwiki&lt;=1.8)" => "Warning: changing the username could require the user to change his password (for user registered with an old tikiwiki&lt;=1.8)",
// "Warning: it will mess with slave intertiki sites that use this one as master" => "Warning: it will mess with slave intertiki sites that use this one as master",
// "No password is required" => "No password is required",
// "Tikiwiki is configured to delegate the password managment to LDAP" => "Tikiwiki is configured to delegate the password managment to LDAP",
// "Repeat Password" => "Repeat Password",
// "User must change password at first login" => "User must change password at first login",
// "Send an email to the user in order to allow him to validate his account" => "Send an email to the user in order to allow him to validate his account",
// "Last Login" => "Last Login",
// "User tracker item : {\$usersitemid}" => "User tracker item : {\$usersitemid}",
// "You do not have permission to edit this user" => "You do not have permission to edit this user",
// "CSV file layout" => "CSV file layout",
// "login,password,email<br />user1,pass1,email1<br />user2,pass2,email2" => "login,password,email<br />user1,pass1,email1<br />user2,pass2,email2",
// "Overwrite but keep the previous login if the login exists in another case" => "Overwrite but keep the previous login if the login exists in another case",
// "Don't overwrite" => "Don't overwrite",
// "Overwrite groups" => "Overwrite groups",
// "You can export users of a group in <a href=\"tiki-admingroups.php\">admin->groups->a_group</a>" => "You can export users of a group in <a href=\"tiki-admingroups.php\">admin->groups->a_group</a>",
// "Loading.." => "Loading..",
// "More languages are available. To view them, update languages you can read from <a href=\"tiki-user_preferences.php\">user preferences</a> or your browser's preferences" => "More languages are available. To view them, update languages you can read from <a href=\"tiki-user_preferences.php\">user preferences</a> or your browser's preferences",
// "Approve page changes in staging" => "Approve page changes in staging",
// "Page has been approved" => "Page has been approved",
// "New attachments" => "New attachments",
// "Old attachments" => "Old attachments",
// "Changes from the following versions under staging have been merged into the approved version" => "Changes from the following versions under staging have been merged into the approved version",
// "Source" => "Source",
// "Admin Article Types" => "Admin Article Types",
// "List of types" => "List of types",
// "Show Help" => "Show Help",
// "Article type" => "Article type",
// "Shows up in the drop down list of article types" => "Shows up in the drop down list of article types",
// "Allow ratings by the author" => "Allow ratings by the author",
// "Show before publish date" => "Show before publish date",
// "non-admins can view before the publish date" => "non-admins can view before the publish date",
// "Show after expire date" => "Show after expire date",
// "non-admins can view after the expire date" => "non-admins can view after the expire date",
// "Heading only" => "Heading only",
// "No article body, heading only" => "No article body, heading only",
// "Allow comments for this type" => "Allow comments for this type",
// "Comment Can Rate Article" => "Comment Can Rate Article",
// "Allow comments to include a rating value" => "Allow comments to include a rating value",
// "Show image" => "Show image",
// "Show topic or own image" => "Show topic or own image",
// "Show avatar" => "Show avatar",
// "Show author's avatar" => "Show author's avatar",
// "Show author" => "Show author",
// "Show author name" => "Show author name",
// "Show publish date" => "Show publish date",
// "Show expire date" => "Show expire date",
// "Show reads" => "Show reads",
// "Show the number of times the article was read" => "Show the number of times the article was read",
// "Show size" => "Show size",
// "Show the size of the article" => "Show the size of the article",
// "Show topline" => "Show topline",
// "Show a small title over the title" => "Show a small title over the title",
// "Show subtitle" => "Show subtitle",
// "Show the subtitle" => "Show the subtitle",
// "Show source" => "Show source",
// "Show link to source after article body" => "Show link to source after article body",
// "Show Image Caption" => "Show Image Caption",
// "Show a legend under the image" => "Show a legend under the image",
// "Show Language" => "Show Language",
// "Show the language" => "Show the language",
// "Creator can edit" => "Creator can edit",
// "The person who submits an article of this type can edit it" => "The person who submits an article of this type can edit it",
// "Actions on this article type" => "Actions on this article type",
// "Show lang" => "Show lang",
// "Classified" => "Classified",
// "Create a new type" => "Create a new type",
// "This page will be replaced with the Object Permissions page although currently it does not support the \"advanced\" mode of this page.<br />Please try it out and feedback with any improvements or problems" => "This page will be replaced with the Object Permissions page although currently it does not support the \"advanced\" mode of this page.<br />Please try it out and feedback with any improvements or problems",
// "Click this button to try it now" => "Click this button to try it now",
// "Global object permissions" => "Global object permissions",
// "inherited from" => "inherited from",
// "inherited" => "inherited",
// "Level configuration" => "Level configuration",
// "Assign User {\$assign_user|escape} to Groups" => "Assign User {\$assign_user|escape} to Groups",
// "Default Group" => "Default Group",
// "Assign User to Group" => "Assign User to Group",
// "Directory batch upload" => "Directory batch upload",
// "available images" => "available images",
// "Remove File Extension from Image Name" => "Remove File Extension from Image Name",
// "eg. from \"digicam0001.jpg\" then name digicam0001 will be used for the name field" => "eg. from \"digicam0001.jpg\" then name digicam0001 will be used for the name field",
// "Convert the last sub directory to a sub gallery" => "Convert the last sub directory to a sub gallery",
// "eg. from \"misc/screenshots/digicam0001.jpg\" a gallery named \"screenshots\" will be created" => "eg. from \"misc/screenshots/digicam0001.jpg\" a gallery named \"screenshots\" will be created",
// "Use the last sub directory name as description" => "Use the last sub directory name as description",
// "eg. from \"misc/screenshots/digicam0001.jpg\" a description \"screenshots\" will be created" => "eg. from \"misc/screenshots/digicam0001.jpg\" a description \"screenshots\" will be created",
// "Select a Gallery" => "Select a Gallery",
// "Browse File Gallery" => "Browse File Gallery",
// "Please do not use this feature to upload data into the database" => "Please do not use this feature to upload data into the database",
// "Available Files" => "Available Files",
// "Select a File Gallery" => "Select a File Gallery",
// "Process files" => "Process files",
// "If you want to use images please save the post first and you will be able to edit/post images. Use the &lt;img&gt; snippet to include uploaded images in the textarea editor or use the image URL to include images using the WYSIWYG editor. " => "If you want to use images please save the post first and you will be able to edit/post images. Use the &lt;img&gt; snippet to include uploaded images in the textarea editor or use the image URL to include images using the WYSIWYG editor. ",
// "Trash" => "Trash",
// "Mark entry as private" => "Mark entry as private",
// "Report to Webmaster" => "Report to Webmaster",
// "Powered by" => "Powered by",
// "Made with" => "Made with",
// "powered by" => "powered by",
// "Wiki RSS" => "Wiki RSS",
// "Blogs RSS" => "Blogs RSS",
// "Articles RSS" => "Articles RSS",
// "Image Galleries RSS" => "Image Galleries RSS",
// "File Galleries RSS" => "File Galleries RSS",
// "Forums RSS" => "Forums RSS",
// "Maps RSS" => "Maps RSS",
// "The TikiWiki Community" => "The TikiWiki Community",
// "TikiWiki CMS/Groupware" => "TikiWiki CMS/Groupware",
// "Execution time" => "Execution time",
// "Memory usage" => "Memory usage",
// "database queries used in " => "database queries used in ",
// "Server load" => "Server load",
// "Last update from SVN" => "Last update from SVN",
// "Watch Only This Category" => "Watch Only This Category",
// "Watch This Category and Their Descendants" => "Watch This Category and Their Descendants",
// "Stop Watching Only This Category" => "Stop Watching Only This Category",
// "Stop Watching This Category and Their Descendants" => "Stop Watching This Category and Their Descendants",
// "Admin Category" => "Admin Category",
// "Admin the Category System" => "Admin the Category System",
// "Browse in" => "Browse in",
// "Trackers Items" => "Trackers Items",
// "Sheets" => "Sheets",
// "in the current category - and its subcategories: " => "in the current category - and its subcategories: ",
// "Hide subcategories objects" => "Hide subcategories objects",
// "Show subcategories objects" => "Show subcategories objects",
// "Upper level" => "Upper level",
// "Browse related tags" => "Browse related tags",
// "Network of Tags related to" => "Network of Tags related to",
// "With all selected tags" => "With all selected tags",
// "With one selected tag" => "With one selected tag",
// "With last selected tag" => "With last selected tag",
// "More Popular Tags" => "More Popular Tags",
// "Alphabetically" => "Alphabetically",
// "By Size" => "By Size",
// "Cloud" => "Cloud",
// "\$feature_label" => "\$feature_label",
// "results found" => "results found",
// "List Galleries" => "List Galleries",
// "Directory Batch" => "Directory Batch",
// "All Images" => "All Images",
// "Monitor this Gallery" => "Monitor this Gallery",
// "Stop Monitoring this Gallery" => "Stop Monitoring this Gallery",
// "subgallery" => "subgallery",
// "Subgallery" => "Subgallery",
// "Hit" => "Hit",
// "Details" => "Details",
// "You can view this gallery's configured image (first, random, etc.) in your browser using" => "You can view this gallery's configured image (first, random, etc.) in your browser using",
// "You can include the gallery's image in an HTML page using one of these lines" => "You can include the gallery's image in an HTML page using one of these lines",
// "You can include the image in a tiki page using one of these lines" => "You can include the image in a tiki page using one of these lines",
// "Slideshow Forward" => "Slideshow Forward",
// "Cyclic" => "Cyclic",
// "Click to zoom" => "Click to zoom",
// "Latitude (WGS84/decimal degrees)" => "Latitude (WGS84/decimal degrees)",
// "Longitude (WGS84/decimal degrees)" => "Longitude (WGS84/decimal degrees)",
// "Include the image in a tiki page using the following syntax" => "Include the image in a tiki page using the following syntax",
// "To include the image in an HTML page" => "To include the image in an HTML page",
// "To link to this page from another tiki page" => "To link to this page from another tiki page",
// "Browsing Video" => "Browsing Video",
// "Edit Video" => "Edit Video",
// "First Video" => "First Video",
// "Prev Video" => "Prev Video",
// "Next Video" => "Next Video",
// "Last Video" => "Last Video",
// "Video Title" => "Video Title",
// "Move video" => "Move video",
// "You can view this video in your browser using" => "You can view this video in your browser using",
// "You can include the video in a tiki page using one of these lines" => "You can include the video in a tiki page using one of these lines",
// "Admin Calendar" => "Admin Calendar",
// "Export Calendars" => "Export Calendars",
// "Click to export calendars" => "Click to export calendars",
// "Visible Calendars" => "Visible Calendars",
// "Click to select visible calendars" => "Click to select visible calendars",
// "Export calendars" => "Export calendars",
// "advanced parameters" => "advanced parameters",
// "Edit event" => "Edit event",
// "Delete event" => "Delete event",
// "View event" => "View event",
// "All-Day" => "All-Day",
// "Website" => "Website",
// "View this Week" => "View this Week",
// "Change Focus" => "Change Focus",
// "View this Day" => "View this Day",
// "o" => "o",
// "Calendar Item" => "Calendar Item",
// "Edit Calendar" => "Edit Calendar",
// "New event" => "New event",
// "New Calendar Item" => "New Calendar Item",
// "Recurrence" => "Recurrence",
// "This event depends on a recurrence rule" => "This event depends on a recurrence rule",
// "This event is not recurrent" => "This event is not recurrent",
// "On a weekly basis" => "On a weekly basis",
// "Each" => "Each",
// "of the week" => "of the week",
// "On a monthly basis" => "On a monthly basis",
// "of the month" => "of the month",
// "On a yearly basis" => "On a yearly basis",
// "There's no such date as" => "There's no such date as",
// "Starting on" => "Starting on",
// "ending by" => "ending by",
// "ending after" => "ending after",
// "events" => "events",
// "Start period" => "Start period",
// "End after" => "End after",
// "occurrences" => "occurrences",
// "End before" => "End before",
// "Event is repeated" => "Event is repeated",
// "every" => "every",
// "of every month" => "of every month",
// "on each" => "on each",
// "Date and time of end" => "Date and time of end",
// "Events cannot end before they start" => "Events cannot end before they start",
// "No description" => "No description",
// "or new" => "or new",
// "Choose users to alert" => "Choose users to alert",
// "chair" => "chair",
// "default role" => "default role",
// "required participant" => "required participant",
// "optional participant" => "optional participant",
// "non participant" => "non participant",
// "Give participant list separated by commas. Roles have to be given in a prefix separated by a column like in" => "Give participant list separated by commas. Roles have to be given in a prefix separated by a column like in",
// "role:login_or_email,login_or_email" => "role:login_or_email,login_or_email",
// "If no role is provided, default role will be \"Chair participant\"" => "If no role is provided, default role will be \"Chair participant\"",
// "Update this event only" => "Update this event only",
// "Update every unchanged events of this recurrence rule" => "Update every unchanged events of this recurrence rule",
// "Update every events of this recurrence rule" => "Update every events of this recurrence rule",
// "Delete Recurrent events" => "Delete Recurrent events",
// "Calendar import" => "Calendar import",
// "Calendar has been updated" => "Calendar has been updated",
// "D" => "D",
// "W" => "W",
// "M" => "M",
// "%d/%m" => "%d/%m",
// "%m/%d" => "%m/%d",
// "Advanced parameters for iCal export" => "Advanced parameters for iCal export",
// "Calendars to be exported" => "Calendars to be exported",
// "Your account has been validated" => "Your account has been validated",
// "You have to choose a password to use this account" => "You have to choose a password to use this account",
// "Click here to send us an email" => "Click here to send us an email",
// "Send another message" => "Send another message",
// "Group View" => "Group View",
// "Publish this contact to groups" => "Publish this contact to groups",
// "You can browse the generated WebHelp here" => "You can browse the generated WebHelp here",
// "Top page" => "Top page",
// "You cannot add sites until Directory Categories are setup" => "You cannot add sites until Directory Categories are setup",
// "Please contact the Site Administrator" => "Please contact the Site Administrator",
// "<a href=\"tiki-directory_admin_categories.php\">Add a directory category now</a>" => "<a href=\"tiki-directory_admin_categories.php\">Add a directory category now</a>",
// "The following site was added, but may require validation by the admin before appearing on the lists" => "The following site was added, but may require validation by the admin before appearing on the lists",
// "Edit a site" => "Edit a site",
// "Add a site" => "Add a site",
// "Directory Categories" => "Directory Categories",
// "Use Ctrl+Click to select multiple directory categories" => "Use Ctrl+Click to select multiple directory categories",
// "Parent directory category" => "Parent directory category",
// "Most visited directory sub-categories" => "Most visited directory sub-categories",
// "Directory Category description" => "Directory Category description",
// "Random directory sub-categories" => "Random directory sub-categories",
// "Allow sites in this directory category" => "Allow sites in this directory category",
// "Show number of sites in this directory category" => "Show number of sites in this directory category",
// "Directory Subcategories" => "Directory Subcategories",
// "Admin related directory categories" => "Admin related directory categories",
// "Add a related directory category" => "Add a related directory category",
// "Directory Category" => "Directory Category",
// "Related directory categories" => "Related directory categories",
// "Perform action with selected" => "Perform action with selected",
// "Add a Directory Category" => "Add a Directory Category",
// "in current directory category" => "in current directory category",
// "Total directory categories" => "Total directory categories",
// "List Articles" => "List Articles",
// "One of the email addresses you typed is invalid" => "One of the email addresses you typed is invalid",
// "Topline" => "Topline",
// "Article image" => "Article image",
// "Image caption" => "Image caption",
// "Expiration Date" => "Expiration Date",
// "Emails to be notified (separated with commas)" => "Emails to be notified (separated with commas)",
// "-1 for unlimited" => "-1 for unlimited",
// "Max impressions for a user" => "Max impressions for a user",
// "Max clicks" => "Max clicks",
// "Or, create a new zone" => "Or, create a new zone",
// "Use Flash" => "Use Flash",
// "Movie Size" => "Movie Size",
// "FlashPlugin min version" => "FlashPlugin min version",
// "ex" => "ex",
// "Remove Zones (you lose entered info for the banner)" => "Remove Zones (you lose entered info for the banner)",
// "Create Blog" => "Create Blog",
// "A category is mandatory" => "A category is mandatory",
// "Show user avatar" => "Show user avatar",
// "The file will be saved in" => "The file will be saved in",
// "Wiki Syntax" => "Wiki Syntax",
// "For more information, please see" => "For more information, please see",
// "Wiki Page Editor" => "Wiki Page Editor",
// "More help on editing wiki pages" => "More help on editing wiki pages",
// "The syntax system used for creating pages in TikiWiki" => "The syntax system used for creating pages in TikiWiki",
// "Also available here" => "Also available here",
// "Plugins help" => "Plugins help",
// "Bold text" => "Bold text",
// "Italic text" => "Italic text",
// "single quotes" => "single quotes",
// "Underlined text" => "Underlined text",
// "Will display using the indicated HTML color or color name. Color name can contain two colors separated by a comma. In this case, the first color would be the foreground and the second one the background" => "Will display using the indicated HTML color or color name. Color name can contain two colors separated by a comma. In this case, the first color would be the foreground and the second one the background",
// "Deleted text" => "Deleted text",
// "2 dashes" => "2 dashes",
// "Headings" => "Headings",
// "Show/Hide" => "Show/Hide",
// "show/hide heading section. + (shown) or - (hidden) by default" => "show/hide heading section. + (shown) or - (hidden) by default",
// "Autonumbered Headings" => "Autonumbered Headings",
// "{literal}{toc}{/literal}, {literal}{maketoc}{/literal} prints out a table of contents for the current page based on structures (toc) or ! headings (maketoc)" => "{literal}{toc}{/literal}, {literal}{maketoc}{/literal} prints out a table of contents for the current page based on structures (toc) or ! headings (maketoc)",
// "Horizontal rule" => "Horizontal rule",
// "Text box" => "Text box",
// "Centered text" => "Centered text",
// "Dynamic variables" => "Dynamic variables",
// "Inserts an editable variable" => "Inserts an editable variable",
// "use square brackets for an external link: [URL], [URL|link_description],[URL|link_description|relation] or [URL|description|relation|nocache] (that last prevents the local Wiki from caching the linked page; relation can be used to insert rel attribute for the link - useful e.g. for shadowbox)" => "use square brackets for an external link: [URL], [URL|link_description],[URL|link_description|relation] or [URL|description|relation|nocache] (that last prevents the local Wiki from caching the linked page; relation can be used to insert rel attribute for the link - useful e.g. for shadowbox)",
// "For an external Wiki, use ExternalWikiName:PageName or ((External Wiki Name: Page Name))" => "For an external Wiki, use ExternalWikiName:PageName or ((External Wiki Name: Page Name))",
// "Square Brackets" => "Square Brackets",
// "Use [[foo] to show [foo]" => "Use [[foo] to show [foo]",
// "page|#anchor" => "page|#anchor",
// "page|#anchor|desc" => "page|#anchor|desc",
// "for wiki heading/anchor references" => "for wiki heading/anchor references",
// "Indentation" => "Indentation",
// "Creates an indentation for each plus (useful in list to continue at the same level)" => "Creates an indentation for each plus (useful in list to continue at the same level)",
// "row" => "row",
// "col" => "col",
// "Monospace font" => "Monospace font",
// "Code sample" => "Code sample",
// "Line break" => "Line break",
// "(very useful especially in tables)" => "(very useful especially in tables)",
// "to separate pages" => "to separate pages",
// "Prevents wiki parsing of the enclosed data" => "Prevents wiki parsing of the enclosed data",
// "Preformated sections" => "Preformated sections",
// "~pp~ data ~/pp~ Displays preformated text/code; no Wiki processing is done inside these sections (as with np), and the spacing is fixed (no word wrapping is done).  ~pre~ data ~/pre~ also displayes preformatted text with fixed spacing, but wiki processing still occurs on the text" => "~pp~ data ~/pp~ Displays preformated text/code; no Wiki processing is done inside these sections (as with np), and the spacing is fixed (no word wrapping is done).  ~pre~ data ~/pre~ also displayes preformatted text with fixed spacing, but wiki processing still occurs on the text",
// "~tc~ Tiki Comment ~/tc~ makes a Tiki comment.  It will be completely removed from the display, but saved in the file for future reference.  ~hc~ HTML Comment ~/hc~ makes an HTML comment.  It will be inserted as a comment in the output HTML; these are not normally displayed in browsers, but can be seen using \"View Source\" or similar" => "~tc~ Tiki Comment ~/tc~ makes a Tiki comment.  It will be completely removed from the display, but saved in the file for future reference.  ~hc~ HTML Comment ~/hc~ makes an HTML comment.  It will be inserted as a comment in the output HTML; these are not normally displayed in browsers, but can be seen using \"View Source\" or similar",
// "Block Preformatting" => "Block Preformatting",
// "Indent text with any number of spaces to turn it into a monospaced block that still follows other Wiki formatting instructions. It will be indended with the same number of spaces that you used.  Note that this mode does not preserve exact spacing and line breaks; use ~pp~...~/pp~ for that" => "Indent text with any number of spaces to turn it into a monospaced block that still follows other Wiki formatting instructions. It will be indended with the same number of spaces that you used.  Note that this mode does not preserve exact spacing and line breaks; use ~pp~...~/pp~ for that",
// "Insert resp. right-to-left and left-to-right text direction DIV (up to end of text) and markers for langages as arabic or hebrew" => "Insert resp. right-to-left and left-to-right text direction DIV (up to end of text) and markers for langages as arabic or hebrew",
// "Special characters" => "Special characters",
// "hard space" => "hard space",
// "numeric between ~ for html numeric characters entity" => "numeric between ~ for html numeric characters entity",
// "Because the Wiki paragraph formatting feature is on, all groups of non-blank lines are collected into paragraphs.  Lines can be of any length, and will be wrapped together with the next line.  Paragraphs are separated by blank lines" => "Because the Wiki paragraph formatting feature is on, all groups of non-blank lines are collected into paragraphs.  Lines can be of any length, and will be wrapped together with the next line.  Paragraphs are separated by blank lines",
// "Because the Wiki paragraph formatting feature is off, each line will be presented as you write it.  This means that if you want paragraphs to be wrapped properly, a paragraph should be all together on one line" => "Because the Wiki paragraph formatting feature is off, each line will be presented as you write it.  This means that if you want paragraphs to be wrapped properly, a paragraph should be all together on one line",
// "Note that plugin arguments can be enclosed with double quotes (&quot;); this allows them to contain , or = or &gt" => "Note that plugin arguments can be enclosed with double quotes (&quot;); this allows them to contain , or = or &gt",
// "More help here" => "More help here",
// "Wiki plugins extend the function of wiki syntax with more specialized commands" => "Wiki plugins extend the function of wiki syntax with more specialized commands",
// "Browse Images" => "Browse Images",
// "Upload from disk to change the image" => "Upload from disk to change the image",
// "Save and Go Next" => "Save and Go Next",
// "You can include the image in an HTML page using one of these lines" => "You can include the image in an HTML page using one of these lines",
// "Im-Export Languages" => "Im-Export Languages",
// "Toggle interactive translation off" => "Toggle interactive translation off",
// "Toggle interactive translation on" => "Toggle interactive translation on",
// "Immediate feedback" => "Immediate feedback",
// "Show correct answers" => "Show correct answers",
// "Shuffle questions" => "Shuffle questions",
// "Shuffle answers" => "Shuffle answers",
// "Passing Percentage" => "Passing Percentage",
// "Question Type" => "Question Type",
// "Import questions from text" => "Import questions from text",
// "Instructions: Type, or paste, your multiple choice questions below.  One line for the question, then start answer choices on subsequent lines.  Separate additional questions with a blank line.  Indicate correct answers by starting them with a \"*\" (without the quotes) character" => "Instructions: Type, or paste, your multiple choice questions below.  One line for the question, then start answer choices on subsequent lines.  Separate additional questions with a blank line.  Indicate correct answers by starting them with a \"*\" (without the quotes) character",
// "Input" => "Input",
// "Edit quiz results" => "Edit quiz results",
// "Modify Structure" => "Modify Structure",
// "and its subpages from the structure" => "and its subpages from the structure",
// "The page already exists. The page that has been added to the structure is the existing one" => "The page already exists. The page that has been added to the structure is the existing one",
// "The following pages added have automatically been categorized with the same categories as the structure" => "The following pages added have automatically been categorized with the same categories as the structure",
// "Structure Layout" => "Structure Layout",
// "Monitor the Sub-Structure" => "Monitor the Sub-Structure",
// "Stop Monitoring the Sub-Structure" => "Stop Monitoring the Sub-Structure",
// "Promote" => "Promote",
// "Demote" => "Demote",
// "Current Node" => "Current Node",
// "Page alias" => "Page alias",
// "Move in this structure" => "Move in this structure",
// "Move to another structure" => "Move to another structure",
// "at the beginning" => "at the beginning",
// "at the end" => "at the end",
// "Add pages to current node" => "Add pages to current node",
// "Categorize all pages in structure together" => "Categorize all pages in structure together",
// "Remove existing categories from ALL pages before recategorizing" => "Remove existing categories from ALL pages before recategorizing",
// "<b>*</b>=optional" => "<b>*</b>=optional",
// "<b>Topline</b>=small line above Title" => "<b>Topline</b>=small line above Title",
// "<b>Subtitle</b>=small line below Title" => "<b>Subtitle</b>=small line below Title",
// "<b>Source</b>=URL to article source" => "<b>Source</b>=URL to article source",
// "Submit Article" => "Submit Article",
// "Auto-Approve Article" => "Auto-Approve Article",
// "If you go to edit this (or any other TPL file) file via the Tiki built-in TPL editor below, all the javascript can be sanitized or completely stripped out by Tiki security filtering" => "If you go to edit this (or any other TPL file) file via the Tiki built-in TPL editor below, all the javascript can be sanitized or completely stripped out by Tiki security filtering",
// "This would cause you problems (e.g. menus can stop collapsing/expanding)" => "This would cause you problems (e.g. menus can stop collapsing/expanding)",
// "You should only modify default header.tpl and other important files via text code editor, through console, or SSH, or FTP edit commands. And only if you know what you are doing ! ;-)" => "You should only modify default header.tpl and other important files via text code editor, through console, or SSH, or FTP edit commands. And only if you know what you are doing ! ;-)",
// "Maybe You just want to modify the top of your Tiki site" => "Maybe You just want to modify the top of your Tiki site",
// "Please consider using the Look & Feel preferences custom code areas or modify tiki-top_bar.tpl which you can do safely via the web-based interface" => "Please consider using the Look & Feel preferences custom code areas or modify tiki-top_bar.tpl which you can do safely via the web-based interface",
// "Save Only in the Theme" => "Save Only in the Theme",
// "Delete the copy in the theme" => "Delete the copy in the theme",
// "Edit a topic" => "Edit a topic",
// "Add Notification Email" => "Add Notification Email",
// "Admin notifications" => "Admin notifications",
// "View Page" => "View Page",
// "View Article" => "View Article",
// "You must specify the object language" => "You must specify the object language",
// "The object doesn't exist" => "The object doesn't exist",
// "The object doesn't have a language" => "The object doesn't have a language",
// "The object has already a translation for this language" => "The object has already a translation for this language",
// "The object is already in the set of translations" => "The object is already in the set of translations",
// "Language of newly translated page" => "Language of newly translated page",
// "Unspecified" => "Unspecified",
// "Name of newly translated page" => "Name of newly translated page",
// "Create translation" => "Create translation",
// "\"You forgot to specify the language of the translation. Please choose a language in the picklist.\"" => "\"You forgot to specify the language of the translation. Please choose a language in the picklist.\"",
// "\"The page already exists. It was selected in the list below.\"" => "\"The page already exists. It was selected in the list below.\"",
// "Or" => "Or",
// "Add existing page as a translation of this page" => "Add existing page as a translation of this page",
// "Manage existing translations of this page" => "Manage existing translations of this page",
// "detach" => "detach",
// "Change language for this page" => "Change language for this page",
// "Select from available options.." => "Select from available options..",
// "Change Language" => "Change Language",
// "No language is assigned to this page" => "No language is assigned to this page",
// "Please select a language before performing translation" => "Please select a language before performing translation",
// "Set Current Page's Language" => "Set Current Page's Language",
// "Edit Video Information" => "Edit Video Information",
// "Browse Videos" => "Browse Videos",
// "The following video was successfully edited" => "The following video was successfully edited",
// "You can include the video in an HTML page using one of these lines" => "You can include the video in an HTML page using one of these lines",
// "View object" => "View object",
// "Preview your changes" => "Preview your changes",
// "Save the page" => "Save the page",
// "Cancel the edit, you will lose your changes" => "Cancel the edit, you will lose your changes",
// "This edit session will expire in" => "This edit session will expire in",
// "<strong>Preview</strong> or <strong>Save</strong> your work to restart the edit session timer" => "<strong>Preview</strong> or <strong>Save</strong> your work to restart the edit session timer",
// "Update '{\$page|escape}'" => "Update '{\$page|escape}'",
// "You are editing the staging copy of the approved version of this page. Changes will be merged in after approval" => "You are editing the staging copy of the approved version of this page. Changes will be merged in after approval",
// "This is a new staging page that has not been approved before" => "This is a new staging page that has not been approved before",
// "The current staging copy may contain changes that have yet to be approved" => "The current staging copy may contain changes that have yet to be approved",
// "View changes since last approval" => "View changes since last approval",
// "You are editing the approved copy of this page" => "You are editing the approved copy of this page",
// "There are currently changes in the staging copy that have yet to be approved" => "There are currently changes in the staging copy that have yet to be approved",
// "Are you sure you do not want to edit" => "Are you sure you do not want to edit",
// "the staging copy" => "the staging copy",
// "instead" => "instead",
// "Draft written on" => "Draft written on",
// "Warning: new versions of this page have been made after this draft" => "Warning: new versions of this page have been made after this draft",
// "Edit wiki page" => "Edit wiki page",
// "Change the style used to display differences to be translated" => "Change the style used to display differences to be translated",
// "Change diff styles" => "Change diff styles",
// "Edit page" => "Edit page",
// "Edit Comment" => "Edit Comment",
// "Edit comment: Enter some text to describe the changes you are currently making" => "Edit comment: Enter some text to describe the changes you are currently making",
// "Monitor this page" => "Monitor this page",
// "Add another image" => "Add another image",
// "Categories will be inherited from the structure top page" => "Categories will be inherited from the structure top page",
// "Tools" => "Tools",
// "Admin Content Templates" => "Admin Content Templates",
// "Lock this page" => "Lock this page",
// "Allow comments on this page" => "Allow comments on this page",
// "Regex search " => "Regex search ",
// "Replace with" => "Replace with",
// "Case Insensitivity" => "Case Insensitivity",
// "Try to convert HTML to wiki" => "Try to convert HTML to wiki",
// "Upload Screencast" => "Upload Screencast",
// "Incorrect file extension was used for your flash screencast, expecting .swf or .flv" => "Incorrect file extension was used for your flash screencast, expecting .swf or .flv",
// "An unexpected error occurred while uploading your flash screencast" => "An unexpected error occurred while uploading your flash screencast",
// "Incorrect file extension was used for your Ogg screencast, expecting .ogg" => "Incorrect file extension was used for your Ogg screencast, expecting .ogg",
// "A flash screencast is mandatory" => "A flash screencast is mandatory",
// "An unexpected error occurred while uploading your Ogg screencast" => "An unexpected error occurred while uploading your Ogg screencast",
// "Preview not possible" => "Preview not possible",
// "Flash video (required)" => "Flash video (required)",
// "Ogg video (optional)" => "Ogg video (optional)",
// "Add another screencast" => "Add another screencast",
// "Manage structures" => "Manage structures",
// "Authors' style" => "Authors' style",
// "Description (used for metatags)" => "Description (used for metatags)",
// "My Footnotes" => "My Footnotes",
// "Use rating" => "Use rating",
// "There is no available poll template" => "There is no available poll template",
// "You should ask an admin to create them" => "You should ask an admin to create them",
// "or use" => "or use",
// "an existing poll" => "an existing poll",
// "Translation request" => "Translation request",
// "Send urgent translation request" => "Send urgent translation request",
// "List Sheets" => "List Sheets",
// "Graph" => "Graph",
// "Export to file" => "Export to file",
// "Format" => "Format",
// "Autodetect" => "Autodetect",
// "Export Tracker Items" => "Export Tracker Items",
// "Delimitors" => "Delimitors",
// "Carriage Return inside Field Value" => "Carriage Return inside Field Value",
// "Parse as Wiki Text" => "Parse as Wiki Text",
// "Fields visible in items list" => "Fields visible in items list",
// "Fields searchable or visible in items list" => "Fields searchable or visible in items list",
// "Fields visible in an item view" => "Fields visible in an item view",
// "All fields" => "All fields",
// "These fields" => "These fields",
// "Use Ctrl+Click to select multiple fields" => "Use Ctrl+Click to select multiple fields",
// "Edit FAQ question" => "Edit FAQ question",
// "Add FAQ question" => "Add FAQ question",
// "File Archive" => "File Archive",
// "File Galleries tpl" => "File Galleries tpl",
// "Be careful to set the right permissions on the files you link to" => "Be careful to set the right permissions on the files you link to",
// "Create New File Gallery" => "Create New File Gallery",
// "Size (width x height)" => "Size (width x height)",
// "Forum Importer" => "Forum Importer",
// "Import from a Local SQL File" => "Import from a Local SQL File",
// "Forum Type" => "Forum Type",
// "DB Prefix" => "DB Prefix",
// "Local SQL Filename on Server (path will be stripped)" => "Local SQL Filename on Server (path will be stripped)",
// "Must be in tikiroot/{\$tmpdir} or tikiroot/img/wiki_up" => "Must be in tikiroot/{\$tmpdir} or tikiroot/img/wiki_up",
// "Verification" => "Verification",
// "File must be an SQL file and exist in either <i>\$tikiroot/temp</i> or <i>\$tikiroot/img/wiki_up</i>" => "File must be an SQL file and exist in either <i>\$tikiroot/temp</i> or <i>\$tikiroot/img/wiki_up</i>",
// "File was not specified, or could not be found in either location.  Please put the file in either directory and Go Back.  If the file exists in both locations, the \$tikiroot/{\$filecheck} location will be preferred" => "File was not specified, or could not be found in either location.  Please put the file in either directory and Go Back.  If the file exists in both locations, the \$tikiroot/{\$filecheck} location will be preferred",
// "Select a Forum You Wish to Move (ONE at a time!)" => "Select a Forum You Wish to Move (ONE at a time!)",
// "Which Forum Do You Wish to Import this Into" => "Which Forum Do You Wish to Import this Into",
// "Message queue for forum" => "Message queue for forum",
// "Back to forum" => "Back to forum",
// "Search by name" => "Search by name",
// "Search in content" => "Search in content",
// "Configure Forum" => "Configure Forum",
// "Reported messages for forum" => "Reported messages for forum",
// "Perfom action with checked" => "Perfom action with checked",
// "Un-report" => "Un-report",
// "Tag translation" => "Tag translation",
// "Note that tags that were created on pages with no language set will remain\n\tuniversal (i.e. is the same tag in all languages) until a language has been set for the tag" => "Note that tags that were created on pages with no language set will remain\n\tuniversal (i.e. is the same tag in all languages) until a language has been set for the tag",
// "Until then, they cannot be translated" => "Until then, they cannot be translated",
// "Show checkboxes to clear language information on tags" => "Show checkboxes to clear language information on tags",
// "There are no tags on this page in your preferred languages" => "There are no tags on this page in your preferred languages",
// "Set language" => "Set language",
// "Universal" => "Universal",
// "Show the following languages" => "Show the following languages",
// "Pending requests" => "Pending requests",
// "Request Time" => "Request Time",
// "Refuse" => "Refuse",
// "Waiting requests" => "Waiting requests",
// "Cancel friendship request" => "Cancel friendship request",
// "Your friends" => "Your friends",
// "break friendship" => "break friendship",
// "Geographic" => "Geographic",
// "Fields to show during browsing the gallery" => "Fields to show during browsing the gallery",
// "Creation Date" => "Creation Date",
// "XY-Size" => "XY-Size",
// "Gallery Image" => "Gallery Image",
// "Global default" => "Global default",
// "Bounding box" => "Bounding box",
// "default scale" => "default scale",
// "Original image is default scale" => "Original image is default scale",
// "Add scaled images with bounding box of square size" => "Add scaled images with bounding box of square size",
// "Choose a filter" => "Choose a filter",
// "Make Map" => "Make Map",
// "Google Map Locator" => "Google Map Locator",
// "enter address" => "enter address",
// "Find address" => "Find address",
// "Save clicked point" => "Save clicked point",
// "Reset view to default" => "Reset view to default",
// "Save current view as default" => "Save current view as default",
// "Center map to saved point" => "Center map to saved point",
// "Reset view to site default" => "Reset view to site default",
// "Users Map" => "Users Map",
// "Select Graphic Type" => "Select Graphic Type",
// "Pie Chart" => "Pie Chart",
// "Multiline" => "Multiline",
// "Multibar" => "Multibar",
// "Bar Stack" => "Bar Stack",
// "Landscape" => "Landscape",
// "Portrait" => "Portrait",
// "Independant Scale" => "Independant Scale",
// "Horizontal Scale" => "Horizontal Scale",
// "Vertical Scale" => "Vertical Scale",
// "Series" => "Series",
// "Wiki plug-in" => "Wiki plug-in",
// "Ical import / Export" => "Ical import / Export",
// "Select The calendar to export" => "Select The calendar to export",
// "Calendar Import" => "Calendar Import",
// "ICal File" => "ICal File",
// "Modify String in Source Language" => "Modify String in Source Language",
// "Original String" => "Original String",
// "New String" => "New String",
// "Import From File" => "Import From File",
// "Grab Wiki Tables" => "Grab Wiki Tables",
// "Import pages from a Structured Text Dump" => "Import pages from a Structured Text Dump",
// "Name of the dump file (it has to be in dump/)" => "Name of the dump file (it has to be in dump/)",
// "body" => "body",
// "If you are NOT running a new Tiki installation, make a backup of your database before using this importer" => "If you are NOT running a new Tiki installation, make a backup of your database before using this importer",
// "Your PHP is running with safe mode enabled. This might cause problems to the import process as safe mode limits the possibly to change in run time some PHP settings (like max_execution_time). It is recommended to run this script without safe mode" => "Your PHP is running with safe mode enabled. This might cause problems to the import process as safe mode limits the possibly to change in run time some PHP settings (like max_execution_time). It is recommended to run this script without safe mode",
// "Depending on the size of the file from the source software, the import process may take a while to complete. This might be a problem according to your PHP and web server settings. This script tries to change the relevant settings but there are some settings that the script cannot change. So, if you are having problems with the script, please try to increase the value of the following PHP settings: max_input_time, max_execution_time (this setting is limited by the web server setting, if you are running Apache also change its Timeout setting), post_max_size, upload_max_filesize, memory_limit. It is recommended that you run this script on a server where you can change the values of those settings (if needed)" => "Depending on the size of the file from the source software, the import process may take a while to complete. This might be a problem according to your PHP and web server settings. This script tries to change the relevant settings but there are some settings that the script cannot change. So, if you are having problems with the script, please try to increase the value of the following PHP settings: max_input_time, max_execution_time (this setting is limited by the web server setting, if you are running Apache also change its Timeout setting), post_max_size, upload_max_filesize, memory_limit. It is recommended that you run this script on a server where you can change the values of those settings (if needed)",
// "Select the software to import from" => "Select the software to import from",
// "WARNING: make sure to have a backup before running the script. If you do not have a backup this is the last chance to cancel the importer by clicking on the cancel button" => "WARNING: make sure to have a backup before running the script. If you do not have a backup this is the last chance to cancel the importer by clicking on the cancel button",
// "Congratulations! You have successful imported your data to Tikiwiki" => "Congratulations! You have successful imported your data to Tikiwiki",
// "pages imported from a total of" => "pages imported from a total of",
// "You can see the list of wiki pages in your site" => "You can see the list of wiki pages in your site",
// "here" => "here",
// "Importer log" => "Importer log",
// "Tiki installer" => "Tiki installer",
// "Welcome" => "Welcome",
// "Welcome to the Tiki installation and upgrade script" => "Welcome to the Tiki installation and upgrade script",
// "Use this script to install a new Tiki database or upgrade your existing database to release" => "Use this script to install a new Tiki database or upgrade your existing database to release",
// "For the latest information about this release, please read the" => "For the latest information about this release, please read the",
// "Release Notes" => "Release Notes",
// "For complete documentation, please visit" => "For complete documentation, please visit",
// "For more information about Tiki, please visit" => "For more information about Tiki, please visit",
// "Select your language" => "Select your language",
// "Read the License" => "Read the License",
// "Tiki is software distributed under the LGPL license" => "Tiki is software distributed under the LGPL license",
// " <a href=\"http://creativecommons.org/licenses/LGPL/2.1/\" target=\"_blank\">Here is a human-readable summary of the license below, including many translations.</a>" => " <a href=\"http://creativecommons.org/licenses/LGPL/2.1/\" target=\"_blank\">Here is a human-readable summary of the license below, including many translations.</a>",
// "Review the System Requirements" => "Review the System Requirements",
// "Before installing Tiki, <a href=\"http://doc.tikiwiki.org/Requirements\" target=\"_blank\">review the documentation</a> and confirm that your system meets the minimum requirements" => "Before installing Tiki, <a href=\"http://doc.tikiwiki.org/Requirements\" target=\"_blank\">review the documentation</a> and confirm that your system meets the minimum requirements",
// "This installer will perform some basic checks automatically" => "This installer will perform some basic checks automatically",
// "Memory" => "Memory",
// "Success" => "Success",
// "Tiki has not detected your PHP memory_limit" => "Tiki has not detected your PHP memory_limit",
// "This probably means you have no set limit (all is well)" => "This probably means you have no set limit (all is well)",
// "Tiki has detected your PHP memory limit at" => "Tiki has detected your PHP memory limit at",
// "Tiki requires <strong>at least</strong> 32MB of PHP memory for script execution" => "Tiki requires <strong>at least</strong> 32MB of PHP memory for script execution",
// "Allocating too little memory will cause Tiki to display blank pages" => "Allocating too little memory will cause Tiki to display blank pages",
// "To change the memory limit, use the <strong>memory_limit</strong> key in your <strong>php.ini </strong> file (for example: memory_limit = 32M) and restart your webserver" => "To change the memory limit, use the <strong>memory_limit</strong> key in your <strong>php.ini </strong> file (for example: memory_limit = 32M) and restart your webserver",
// "Tiki has detected your PHP memory_limit at" => "Tiki has detected your PHP memory_limit at",
// "Tiki uses the PHP <strong>mail</strong> function to send email notifications and messages" => "Tiki uses the PHP <strong>mail</strong> function to send email notifications and messages",
// "To test your system configuration, Tiki will attempt to send a test message to you" => "To test your system configuration, Tiki will attempt to send a test message to you",
// "Test email" => "Test email",
// "Email address to send test to" => "Email address to send test to",
// "Copy test mail to " => "Copy test mail to ",
// "Send Test Message" => "Send Test Message",
// "Tiki was able to send a test message to" => "Tiki was able to send a test message to",
// "Tiki was not able to send a test message" => "Tiki was not able to send a test message",
// "Review your mail log for details" => "Review your mail log for details",
// "Review the mail settings in your <strong>php.ini</strong> file (for example: confirm that the <strong>sendmail_path</strong> is correct)" => "Review the mail settings in your <strong>php.ini</strong> file (for example: confirm that the <strong>sendmail_path</strong> is correct)",
// "If your host requires SMTP authentication, additional configuration may be necessary" => "If your host requires SMTP authentication, additional configuration may be necessary",
// "Image Processing" => "Image Processing",
// "Tiki detected" => "Tiki detected",
// "Tiki was not able to detect the GD library" => "Tiki was not able to detect the GD library",
// "Tiki uses the GD library to process images for the Image Gallery and CAPTCHA support" => "Tiki uses the GD library to process images for the Image Gallery and CAPTCHA support",
// "Set the Database Connection" => "Set the Database Connection",
// "Tiki requires an active database connection" => "Tiki requires an active database connection",
// "You must create the database and user <em>before</em> completing this page" => "You must create the database and user <em>before</em> completing this page",
// "Tiki cannot find a database connection" => "Tiki cannot find a database connection",
// "This is normal for a new installation" => "This is normal for a new installation",
// "Tiki found an existing database connection in your local.php file" => "Tiki found an existing database connection in your local.php file",
// "Use Existing Connection" => "Use Existing Connection",
// "Use this page to create a new database connection, or use the <a href=\"http://doc.tikiwiki.org/Manual+Installation\" target=\"_blank\" title=\"manual installation\">manual installation process</a>" => "Use this page to create a new database connection, or use the <a href=\"http://doc.tikiwiki.org/Manual+Installation\" target=\"_blank\" title=\"manual installation\">manual installation process</a>",
// "Database information" => "Database information",
// "Enter your database connection information" => "Enter your database connection information",
// "Database type" => "Database type",
// "Select the type of database to use with Tiki" => "Select the type of database to use with Tiki",
// "Only databases supported by your PHP installation are listed here. If your database is not in the list, try to install the appropriate PHP extension" => "Only databases supported by your PHP installation are listed here. If your database is not in the list, try to install the appropriate PHP extension",
// "Host name" => "Host name",
// "Enter the host name or IP for your database" => "Enter the host name or IP for your database",
// "Use <strong>localhost</strong> if the database is running on the same machine as Tiki" => "Use <strong>localhost</strong> if the database is running on the same machine as Tiki",
// "Database name" => "Database name",
// "Enter the name of the database that Tiki will use" => "Enter the name of the database that Tiki will use",
// "The database must already exist. You can create the database using mysqladmin, PHPMyAdmin, cPanel, or ask your hosting provider.  Normally Tiki tables won't conflict with other product names" => "The database must already exist. You can create the database using mysqladmin, PHPMyAdmin, cPanel, or ask your hosting provider.  Normally Tiki tables won't conflict with other product names",
// "Database user" => "Database user",
// "Enter a database user with administrator permission for the Database" => "Enter a database user with administrator permission for the Database",
// "User name" => "User name",
// "Install &amp; Upgrade" => "Install &amp; Upgrade",
// "Install" => "Install",
// "Failed to set max_execution_time to 0 for PHP. You may experience problems when creating/upgrading the database on a slow system. This will manitest itself by a blank page" => "Failed to set max_execution_time to 0 for PHP. You may experience problems when creating/upgrading the database on a slow system. This will manitest itself by a blank page",
// "This install will populate (or upgrade) the database" => "This install will populate (or upgrade) the database",
// "If you want to upgrade from a previous Tiki release, ensure that you have read and understood the <a href=\"http://doc.tikiwiki.org/Upgrade\" target=\"_blank\">Upgrade instructions</a>" => "If you want to upgrade from a previous Tiki release, ensure that you have read and understood the <a href=\"http://doc.tikiwiki.org/Upgrade\" target=\"_blank\">Upgrade instructions</a>",
// "A new install will populate the database" => "A new install will populate the database",
// "Reinstall the database" => "Reinstall the database",
// "This will destroy your current database" => "This will destroy your current database",
// "Reinstall" => "Reinstall",
// "Upgrade" => "Upgrade",
// "Warning: Category Permissions Will Not Be Upgraded" => "Warning: Category Permissions Will Not Be Upgraded",
// "Category permissions have been revamped in version 4. If you have been using category permissions, note that they may not work properly after upgrading to version 4, and it will be necessary to reconfigure them" => "Category permissions have been revamped in version 4. If you have been using category permissions, note that they may not work properly after upgrading to version 4, and it will be necessary to reconfigure them",
// "Automatically upgrade your existing database to v" => "Automatically upgrade your existing database to v",
// "This site has an admin account configured" => "This site has an admin account configured",
// "Please login with your admin password to continue" => "Please login with your admin password to continue",
// "Review the Upgrade" => "Review the Upgrade",
// "Review the Installation" => "Review the Installation",
// "Upgrade complete" => "Upgrade complete",
// "Installation complete" => "Installation complete",
// "Your database has been configured and Tiki is ready to run" => "Your database has been configured and Tiki is ready to run",
// "If this is your first install, your admin password is <strong>admin</strong>" => "If this is your first install, your admin password is <strong>admin</strong>",
// "You can now log in into Tiki as user <strong>admin</strong> and start configuring the application" => "You can now log in into Tiki as user <strong>admin</strong> and start configuring the application",
// "Upgrade operations executed successfully" => "Upgrade operations executed successfully",
// "Installation operations executed successfully" => "Installation operations executed successfully",
// "SQL queries" => "SQL queries",
// "Database was left unchanged" => "Database was left unchanged",
// "Failed" => "Failed",
// "Operations failed" => "Operations failed",
// "Display details" => "Display details",
// "During an upgrade, it is normal to have SQL failures resulting with <strong>Table already exists</strong> messages" => "During an upgrade, it is normal to have SQL failures resulting with <strong>Table already exists</strong> messages",
// ".htaccess File" => ".htaccess File",
// "We recommend enabling the <strong>.htaccess</strong> file for your Tiki" => "We recommend enabling the <strong>.htaccess</strong> file for your Tiki",
// "This will enable you to use SEFURLs (search engine friendly URLs) and help improve site security" => "This will enable you to use SEFURLs (search engine friendly URLs) and help improve site security",
// "To enable this file, simply rename the <strong>_htaccess</strong> file (located in the main directory of your Tiki installation) to <strong>.htaccess</strong>" => "To enable this file, simply rename the <strong>_htaccess</strong> file (located in the main directory of your Tiki installation) to <strong>.htaccess</strong>",
// "Complete these fields to configure common, general settings for your site" => "Complete these fields to configure common, general settings for your site",
// "The information you enter here can be changed later" => "The information you enter here can be changed later",
// "Refer to the <a href=\"http://doc.tikiwiki.org/Admin+Panels\" target=\"_blank\">documentation</a> for complete information on these, and other, settings" => "Refer to the <a href=\"http://doc.tikiwiki.org/Admin+Panels\" target=\"_blank\">documentation</a> for complete information on these, and other, settings",
// "This will appear in the browser title bar" => "This will appear in the browser title bar",
// "Email sent by your site will use this address" => "Email sent by your site will use this address",
// "Secure Login" => "Secure Login",
// "HTTPS login" => "HTTPS login",
// "Administrator" => "Administrator",
// "Admin email" => "Admin email",
// "This is the email address for your administrator account" => "This is the email address for your administrator account",
// "Enter Your Tiki" => "Enter Your Tiki",
// "The installation is complete" => "The installation is complete",
// "Tiki is an open source project, <em>you</em> can <a href='http://info.tikiwiki.org/Join+the+Community' target='_blank'>join the community</a> and help <a href='http://info.tikiwiki.org/Develop+Tiki' target='_blank'>develop Tiki</a>" => "Tiki is an open source project, <em>you</em> can <a href='http://info.tikiwiki.org/Join+the+Community' target='_blank'>join the community</a> and help <a href='http://info.tikiwiki.org/Develop+Tiki' target='_blank'>develop Tiki</a>",
// "Installation" => "Installation",
// "If this is a first time installation, go to <strong>tiki-admin.php</strong> after login to start configuring your new Tiki installation" => "If this is a first time installation, go to <strong>tiki-admin.php</strong> after login to start configuring your new Tiki installation",
// "If this is an upgrade, clean the Tiki caches manually (the <strong>templates_c</strong> directory) or by using the <strong>Admin &gt; System</strong> option from the Admin menu" => "If this is an upgrade, clean the Tiki caches manually (the <strong>templates_c</strong> directory) or by using the <strong>Admin &gt; System</strong> option from the Admin menu",
// "Enter Tiki and Lock Installer" => "Enter Tiki and Lock Installer",
// "Recommended" => "Recommended",
// "Enter Tiki Without Locking Installer" => "Enter Tiki Without Locking Installer",
// "MultiTiki Setup" => "MultiTiki Setup",
// "Default Installation" => "Default Installation",
// "DB OK" => "DB OK",
// "No DB" => "No DB",
// "Adding a new host" => "Adding a new host",
// "To add a new virtual host run the setup.sh with the domain name of the new host as a last parameter" => "To add a new virtual host run the setup.sh with the domain name of the new host as a last parameter",
// "MultiTiki" => "MultiTiki",
// "Are you upgrading an existing Tiki site" => "Are you upgrading an existing Tiki site",
// "Go directly to the <strong>Install/Upgrade</strong> step" => "Go directly to the <strong>Install/Upgrade</strong> step",
// "Install/Upgrade" => "Install/Upgrade",
// "Restart the installer" => "Restart the installer",
// "Database Connection" => "Database Connection",
// "Reset the Database Connection" => "Reset the Database Connection",
// "Install Profile" => "Install Profile",
// "Configure the General Settings" => "Configure the General Settings",
// "Tiki Icon" => "Tiki Icon",
// "TikiWiki Project Web Site" => "TikiWiki Project Web Site",
// "Support Forums" => "Support Forums",
// "TikiWiki CMS/Groupware Project" => "TikiWiki CMS/Groupware Project",
// "Powered by TikiWiki" => "Powered by TikiWiki",
// "Clear cached version and refresh cache" => "Clear cached version and refresh cache",
// "configure rules" => "configure rules",
// "Interactive translator" => "Interactive translator",
// "has been updated" => "has been updated",
// "Close this window" => "Close this window",
// "Go Back" => "Go Back",
// "Clicking 'Close this window' will reload the main window from where it was opened" => "Clicking 'Close this window' will reload the main window from where it was opened",
// "Upload to Kaltura" => "Upload to Kaltura",
// "List Entries" => "List Entries",
// "Upload Successful" => "Upload Successful",
// "You have successfully added {\$count} new entry/entries" => "You have successfully added {\$count} new entry/entries",
// "Change Details" => "Change Details",
// "Remix" => "Remix",
// "Advanced Editor" => "Advanced Editor",
// "Simple Editor" => "Simple Editor",
// "Views" => "Views",
// "Plays" => "Plays",
// "Last 2 days" => "Last 2 days",
// "Last 3 days" => "Last 3 days",
// "Last 5 days" => "Last 5 days",
// "Last week" => "Last week",
// "Last 2 weeks" => "Last 2 weeks",
// "Last month" => "Last month",
// "v" => "v",
// "ExpireDate" => "ExpireDate",
// "To use a banner in a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{banner zone=ABC}{/literal}, where ABC is the name of the zone" => "To use a banner in a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{banner zone=ABC}{/literal}, where ABC is the name of the zone",
// "Max Clicks" => "Max Clicks",
// "The cache is used by" => "The cache is used by",
// "Approval" => "Approval",
// "Rejected" => "Rejected",
// "To use content blocks in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{content id=x}{/literal}, where x is the ID of the content block" => "To use content blocks in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{content id=x}{/literal}, where x is the ID of the content block",
// "You can also use {literal}{content label=x}{/literal}, where x is the label of the content block" => "You can also use {literal}{content label=x}{/literal}, where x is the label of the content block",
// "Edit content block" => "Edit content block",
// "Create content block" => "Create content block",
// "Current Value" => "Current Value",
// "Future vers" => "Future vers",
// "Edit/Create" => "Edit/Create",
// "Create new FAQ" => "Create new FAQ",
// "SlideShow" => "SlideShow",
// "Keep gallery window open" => "Keep gallery window open",
// "Your comment" => "Your comment",
// "Modifications" => "Modifications",
// "Property <b>{\$fgp_name}</b> Changed" => "Property <b>{\$fgp_name}</b> Changed",
// "Media Entries" => "Media Entries",
// "Mix Entries" => "Mix Entries",
// "Kaltura Remix Entries" => "Kaltura Remix Entries",
// "Kaltura Media Entries" => "Kaltura Media Entries",
// "Loads" => "Loads",
// "Browse Entries" => "Browse Entries",
// "Additional Info" => "Additional Info",
// "Media Type" => "Media Type",
// "No entries" => "No entries",
// "No media entries found. " => "No media entries found. ",
// "Click here " => "Click here ",
// "to upload" => "to upload",
// "No mix entries found. " => "No mix entries found. ",
// "to create a new mix" => "to create a new mix",
// "Playlist Type" => "Playlist Type",
// "No playlists found. " => "No playlists found. ",
// "to create a playlist" => "to create a playlist",
// "Object Permissions List" => "Object Permissions List",
// "Manage Permissions" => "Manage Permissions",
// "If an object is not in the special section, then only the default perms are on" => "If an object is not in the special section, then only the default perms are on",
// "Special" => "Special",
// "Take Survey" => "Take Survey",
// "users registered" => "users registered",
// "Distance (km)" => "Distance (km)",
// "List Movies" => "List Movies",
// "Those movies are very good tutorials of tikiwiki use. They have been generated by siridhar with camtasia studio for public use ! Thanks to him. The up-to-date list of movies is on" => "Those movies are very good tutorials of tikiwiki use. They have been generated by siridhar with camtasia studio for public use ! Thanks to him. The up-to-date list of movies is on",
// "Choose a movie" => "Choose a movie",
// "Page aliases found" => "Page aliases found",
// "Last modification" => "Last modification",
// "Page creator" => "Page creator",
// "Status of the page" => "Status of the page",
// "Links to other items in page" => "Links to other items in page",
// "Links to this page in other pages" => "Links to this page in other pages",
// "Backl" => "Backl",
// "Page size" => "Page size",
// " {if \$find ne ''}and {/if}starting with" => " {if \$find ne ''}and {/if}starting with",
// "However, some page aliases fitting the query were found (see Aliases section above)" => "However, some page aliases fitting the query were found (see Aliases section above)",
// "Xml Zip" => "Xml Zip",
// "offline" => "offline",
// "Live support:User window" => "Live support:User window",
// "Back to admin" => "Back to admin",
// "operator" => "operator",
// "For security purposes we must periodically validate your email address to allow continued access to this site" => "For security purposes we must periodically validate your email address to allow continued access to this site",
// "A validation email has been sent to you. Please open that email and follow the instructions to once again gain access to the site" => "A validation email has been sent to you. Please open that email and follow the instructions to once again gain access to the site",
// "Thank you" => "Thank you",
// "Mail-in feature" => "Mail-in feature",
// "Missing dependency. Obtain <a href=\"http://tikiwiki.org/tiki-download_file.php?fileId=50\">visorFreemind.swf</a> and upload it in files/" => "Missing dependency. Obtain <a href=\"http://tikiwiki.org/tiki-download_file.php?fileId=50\">visorFreemind.swf</a> and upload it in files/",
// "Tikiwiki Mods" => "Tikiwiki Mods",
// "Mods Configuration" => "Mods Configuration",
// "Update remote index" => "Update remote index",
// "Rebuild local list" => "Rebuild local list",
// "Republish all" => "Republish all",
// "Publish all" => "Publish all",
// "Unpublish all" => "Unpublish all",
// "Tiki \"mods\" are additional features not included in the public release. Learn more at <a target=\"tikihelp\" href=\"http://mods.tikiwiki.org\">mods.tikiwiki.org</a>" => "Tiki \"mods\" are additional features not included in the public release. Learn more at <a target=\"tikihelp\" href=\"http://mods.tikiwiki.org\">mods.tikiwiki.org</a>",
// "Tiki \"mods\" are undergoing refurbishment" => "Tiki \"mods\" are undergoing refurbishment",
// "You will probably some find mods shown as being compatible with older versions of Tiki will work with later versions with little or no modification" => "You will probably some find mods shown as being compatible with older versions of Tiki will work with later versions with little or no modification",
// "Your help is needed! Please visit <a href=\"http://dev.tikiwiki.org/tiki-index.php?page=Mods\">dev.tikiwiki.org</a> to find out more" => "Your help is needed! Please visit <a href=\"http://dev.tikiwiki.org/tiki-index.php?page=Mods\">dev.tikiwiki.org</a> to find out more",
// "Attention" => "Attention",
// "Apache has the right to write in your file tree, which enables the installation, removal or upgrade of packages. When you are done with those operations, think to fix those permissions back to a safe state (by using \"sh setup.sh\" for example)" => "Apache has the right to write in your file tree, which enables the installation, removal or upgrade of packages. When you are done with those operations, think to fix those permissions back to a safe state (by using \"sh setup.sh\" for example)",
// "To install, remove or upgrade packages you need to give the apache user the right to write files in your web tree (you can use \"sh setup.sh open\" to set it up). After installation you need to remove that permission (using \"sh setup.sh\")" => "To install, remove or upgrade packages you need to give the apache user the right to write files in your web tree (you can use \"sh setup.sh open\" to set it up). After installation you need to remove that permission (using \"sh setup.sh\")",
// "all types" => "all types",
// "for version" => "for version",
// "all versions" => "all versions",
// "or later" => "or later",
// "No mods found" => "No mods found",
// "Display only this type" => "Display only this type",
// "Unpublish" => "Unpublish",
// "Republish" => "Republish",
// "licence" => "licence",
// "Tikiwiki Mods Configuration" => "Tikiwiki Mods Configuration",
// "Mods Install/uninstall" => "Mods Install/uninstall",
// "Enable Mods providing" => "Enable Mods providing",
// "Mods local directory" => "Mods local directory",
// "Mods remote server" => "Mods remote server",
// "Package Config" => "Package Config",
// "y" => "y",
// "Records" => "Records",
// "My Articles" => "My Articles",
// "User Articles" => "User Articles",
// "My User Items" => "My User Items",
// "User Items" => "User Items",
// "User forum topics" => "User forum topics",
// "Forum topics" => "Forum topics",
// "Date of post" => "Date of post",
// "User forum replies" => "User forum replies",
// "Forum replies" => "Forum replies",
// "To display the objects you created or contributed to" => "To display the objects you created or contributed to",
// "MyInfo" => "MyInfo",
// "Contacts Preferences" => "Contacts Preferences",
// "Sent Edition" => "Sent Edition",
// "HTML version" => "HTML version",
// "Text version" => "Text version",
// "Delete errors" => "Delete errors",
// "Not sent" => "Not sent",
// "Removal of your email address failed" => "Removal of your email address failed",
// "Subscription failed" => "Subscription failed",
// "Available Newsletters" => "Available Newsletters",
// "Object Watches" => "Object Watches",
// "Watching Groups" => "Watching Groups",
// "Edit Permissions" => "Edit Permissions",
// "Currently editing Global permissions" => "Currently editing Global permissions",
// "This object's direct permissions override any global permissions or category permissions affecting this object" => "This object's direct permissions override any global permissions or category permissions affecting this object",
// "This category's direct permissions override any global permissions affecting objects in it" => "This category's direct permissions override any global permissions affecting objects in it",
// "To edit global permissions" => "To edit global permissions",
// "No permissions yet applied to this object but category permissions affect this object and are displayed below" => "No permissions yet applied to this object but category permissions affect this object and are displayed below",
// "To edit category permissions" => "To edit category permissions",
// "No direct permissions yet applied to this object. Global permissions apply" => "No direct permissions yet applied to this object. Global permissions apply",
// "Currently inherited permissions displayed" => "Currently inherited permissions displayed",
// "Assign global permissions" => "Assign global permissions",
// "Reset to Global Perms" => "Reset to Global Perms",
// "Reset Perms" => "Reset Perms",
// "This will remove all the settings here and permissions will be reset to inherit any category permissions that are set, or the global sitewide permissions" => "This will remove all the settings here and permissions will be reset to inherit any category permissions that are set, or the global sitewide permissions",
// "This will remove all the settings here and permissions will be reset to inherit the global sitewide permissions" => "This will remove all the settings here and permissions will be reset to inherit the global sitewide permissions",
// "Permissions Clipboard" => "Permissions Clipboard",
// "Copy the permissions set here" => "Copy the permissions set here",
// "Paste" => "Paste",
// "Paste copied permissions from " => "Paste copied permissions from ",
// "Assign or remove permissions on <em>all</em> child categories" => "Assign or remove permissions on <em>all</em> child categories",
// "Are you sure you want to effect all child categories?\\nThere is no undo" => "Are you sure you want to effect all child categories?\\nThere is no undo",
// "Assign or remove permissions on all pages of the sub-structure" => "Assign or remove permissions on all pages of the sub-structure",
// "Are you sure you want to effect all pages in this sub-structure?\\nThere is no undo" => "Are you sure you want to effect all pages in this sub-structure?\\nThere is no undo",
// "Select groups" => "Select groups",
// "Some of your groups have been automatically hidden.<br /> Select the groups below to assign permissions for" => "Some of your groups have been automatically hidden.<br /> Select the groups below to assign permissions for",
// "Select all" => "Select all",
// "Select features" => "Select features",
// "Some of your features have been automatically hidden.<br /> Select the features below to assign permissions for" => "Some of your features have been automatically hidden.<br /> Select the features below to assign permissions for",
// "Show permissions for disabled features" => "Show permissions for disabled features",
// "Feature name" => "Feature name",
// "Quick Permissions" => "Quick Permissions",
// "These permissions override any global permissions or category permissions affecting this object" => "These permissions override any global permissions or category permissions affecting this object",
// "To edit global permissions <a class=\"rbox-link\" href=\"tiki-objectpermissions.php?objectType=global\">click here</a>" => "To edit global permissions <a class=\"rbox-link\" href=\"tiki-objectpermissions.php?objectType=global\">click here</a>",
// "Assign Quick-Permissions to this object" => "Assign Quick-Permissions to this object",
// "A couple of userdefined permissions are currently assigned (See tab Assign Permissions)" => "A couple of userdefined permissions are currently assigned (See tab Assign Permissions)",
// "Your OpenID identity is valid" => "Your OpenID identity is valid",
// "However, no account is associated to the OpenID identifier" => "However, no account is associated to the OpenID identifier",
// "Create a new Tikiwiki account from OpenID" => "Create a new Tikiwiki account from OpenID",
// "Associate OpenID with an existing Tikiwiki account" => "Associate OpenID with an existing Tikiwiki account",
// "Your identity gives you access to multiple user accounts" => "Your identity gives you access to multiple user accounts",
// "Select account" => "Select account",
// "Make Structure" => "Make Structure",
// "{\$atts|@count} files attached" => "{\$atts|@count} files attached",
// "Preview of version" => "Preview of version",
// "(current)" => "(current)",
// "Rollback to this version" => "Rollback to this version",
// "Source of version" => "Source of version",
// "s=source" => "s=source",
// "b=rollback" => "b=rollback",
// "Updated from" => "Updated from",
// "Used to update" => "Used to update",
// "Update Translation" => "Update Translation",
// "Hide translation history" => "Hide translation history",
// "Show translation history" => "Show translation history",
// "no avatar" => "no avatar",
// "icons" => "icons",
// "Avatar Image" => "Avatar Image",
// "File (only .gif, .jpg and .png images approximately 45px × 45px)" => "File (only .gif, .jpg and .png images approximately 45px × 45px)",
// "Plugin execution was denied" => "Plugin execution was denied",
// "Plugin execution pending approval" => "Plugin execution pending approval",
// "After argument validation by an editor, the execution of this plugin was denied. This plugin will eventually be removed or corrected" => "After argument validation by an editor, the execution of this plugin was denied. This plugin will eventually be removed or corrected",
// "This plugin was recently added or modified. Until an editor of the site validates the parameters, execution will not be possible" => "This plugin was recently added or modified. Until an editor of the site validates the parameters, execution will not be possible",
// "You are allowed to" => "You are allowed to",
// "View arguments" => "View arguments",
// "Execute the plugin in preview mode (may be dangerous)" => "Execute the plugin in preview mode (may be dangerous)",
// "Approve the plugin for public execution" => "Approve the plugin for public execution",
// "View Details" => "View Details",
// "This plugin does not contain any arguments" => "This plugin does not contain any arguments",
// "This plugin's body is empty" => "This plugin's body is empty",
// "Insert" => "Insert",
// "Any" => "Any",
// "Items found" => "Items found",
// "Rank" => "Rank",
// "atts" => "atts",
// "List Attachments" => "List Attachments",
// "Sum" => "Sum",
// "Plugin Approval" => "Plugin Approval",
// "For security, grant the <strong>tiki_p_plugin_approve</strong> permission only to trusted user groups" => "For security, grant the <strong>tiki_p_plugin_approve</strong> permission only to trusted user groups",
// "Use the <a href=\"tiki-admin.php?page=textarea\">Admin: Text Area page</a> to deactivate potentially risky plugins" => "Use the <a href=\"tiki-admin.php?page=textarea\">Admin: Text Area page</a> to deactivate potentially risky plugins",
// "This page lists the plugins that require validation, the first time they are encountered" => "This page lists the plugins that require validation, the first time they are encountered",
// "Each plugin contains a unique <em>signature</em> that is preserved" => "Each plugin contains a unique <em>signature</em> that is preserved",
// "If a plugin is no longer in use (for example, it has been removed from the wiki page), use <strong>Clear</strong> to remove it from this list" => "If a plugin is no longer in use (for example, it has been removed from the wiki page), use <strong>Clear</strong> to remove it from this list",
// "The plugin will automatically be added if it is encountered" => "The plugin will automatically be added if it is encountered",
// "Plugins can be individually previewed, approved, or rejected from the particular location that contains the plugin" => "Plugins can be individually previewed, approved, or rejected from the particular location that contains the plugin",
// "For security, you should review each plugin to ensure it is safe to approve" => "For security, you should review each plugin to ensure it is safe to approve",
// "Plugin" => "Plugin",
// "Added By" => "Added By",
// "Signature" => "Signature",
// "Wiki page: <a href=\"%0#{\$plugin.fingerprint}\" title=\"{tr}View this page" => "Wiki page: <a href=\"%0#{\$plugin.fingerprint}\" title=\"{tr}View this page",
// "<a href=\"%0#{\$plugin.fingerprint}\" title=\"{tr}View this page" => "<a href=\"%0#{\$plugin.fingerprint}\" title=\"{tr}View this page",
// "Approve all pending plugins" => "Approve all pending plugins",
// "Using <strong>Approve</strong> or <strong>Approve All</strong> will approve and activate the pending plugins" => "Using <strong>Approve</strong> or <strong>Approve All</strong> will approve and activate the pending plugins",
// "Use this feature <strong>only</strong> if you have verified that all the pending plugins are safe" => "Use this feature <strong>only</strong> if you have verified that all the pending plugins are safe",
// "No plugins pending approval" => "No plugins pending approval",
// "View Results" => "View Results",
// "Poll Results" => "Poll Results",
// "Top Voted Polls" => "Top Voted Polls",
// "Edit Poll" => "Edit Poll",
// "Find the poll" => "Find the poll",
// "Number of top voted polls to show" => "Number of top voted polls to show",
// "Vote range displayed" => "Vote range displayed",
// "All votes with no span consideration" => "All votes with no span consideration",
// "All votes with span consideration" => "All votes with span consideration",
// "All votes" => "All votes",
// "List Votes" => "List Votes",
// "Note: Remember that this is only a preview, and has not yet been saved" => "Note: Remember that this is only a preview, and has not yet been saved",
// "Topic image" => "Topic image",
// "Permission denied. You do not have permission to read complete articles" => "Permission denied. You do not have permission to read complete articles",
// "Selected Structures" => "Selected Structures",
// "Add Structure" => "Add Structure",
// "No structures" => "No structures",
// "Add Pages" => "Add Pages",
// "No pages" => "No pages",
// "Add Page" => "Add Page",
// "Add Pages from Structures" => "Add Pages from Structures",
// "Add Structure Pages" => "Add Structure Pages",
// "Selected Pages" => "Selected Pages",
// "No pages selected" => "No pages selected",
// "Edit quiz" => "Edit quiz",
// "Current Version" => "Current Version",
// "General Options" => "General Options",
// "Publication Date" => "Publication Date",
// "at " => "at ",
// "Use " => "Use ",
// "randomly selected questions" => "randomly selected questions",
// "Test-time Options" => "Test-time Options",
// "Limit questions displayed per page to " => "Limit questions displayed per page to ",
// "&nbsp question(s)" => "&nbsp question(s)",
// "Impose a time limit of " => "Impose a time limit of ",
// "Allow students to store partial results and return to quiz" => "Allow students to store partial results and return to quiz",
// "Allow students to retake this quiz " => "Allow students to retake this quiz ",
// "Grading and Feedback" => "Grading and Feedback",
// "Grading method " => "Grading method ",
// "Show students their score " => "Show students their score ",
// "Show students the correct answers " => "Show students the correct answers ",
// "Publish statistics " => "Publish statistics ",
// "Extra Options" => "Extra Options",
// "Solicit additional questions from students" => "Solicit additional questions from students",
// "Link quiz to forum named: " => "Link quiz to forum named: ",
// "Prologue" => "Prologue",
// "Epilogue" => "Epilogue",
// "time taken" => "time taken",
// "P/F" => "P/F",
// "Passed" => "Passed",
// "star" => "star",
// "half star" => "half star",
// "Send a link" => "Send a link",
// "Received Pages" => "Received Pages",
// "Edit Received Page" => "Edit Received Page",
// "The highlight pages already exist" => "The highlight pages already exist",
// "Please, change the name if you want the page to be uploaded" => "Please, change the name if you want the page to be uploaded",
// "Received Structures" => "Received Structures",
// "Prefix the checked" => "Prefix the checked",
// "Postfix the checked" => "Postfix the checked",
// "Your email could not be validated; make sure you email is correct and click register below" => "Your email could not be validated; make sure you email is correct and click register below",
// "Use your email as login" => "Use your email as login",
// "Minimum {\$prefs.min_username_length} characters long" => "Minimum {\$prefs.min_username_length} characters long",
// "Passcode to register" => "Passcode to register",
// "Not your password" => "Not your password",
// "To request a passcode, {if \$prefs.feature_contact eq 'y'}<a href=\"tiki-contact.php\">{/if}\n\t\t\t\t\t\tcontact the sytem administrator{if \$prefs.feature_contact eq 'y'}</a>{/if}" => "To request a passcode, {if \$prefs.feature_contact eq 'y'}<a href=\"tiki-contact.php\">{/if}\n\t\t\t\t\t\tcontact the sytem administrator{if \$prefs.feature_contact eq 'y'}</a>{/if}",
// "Generate a\tpassword" => "Generate a\tpassword",
// "A valid email is mandatory to register" => "A valid email is mandatory to register",
// "Select your group" => "Select your group",
// "Make sure to whitelist this domain to prevent registration emails being canned by your spam filter" => "Make sure to whitelist this domain to prevent registration emails being canned by your spam filter",
// "Tiki site registered" => "Tiki site registered",
// "You don't have permission to use this feature" => "You don't have permission to use this feature",
// "Please register" => "Please register",
// "Register this site at tikiwiki.org" => "Register this site at tikiwiki.org",
// "Read this first" => "Read this first",
// "On this page you can make your tiki site known to tikiwiki.org. It will get shown there in a list of known tiki sites" => "On this page you can make your tiki site known to tikiwiki.org. It will get shown there in a list of known tiki sites",
// "Registering is voluntary" => "Registering is voluntary",
// "Registering does not give you any benefits except one more link to your site" => "Registering does not give you any benefits except one more link to your site",
// "You don't get any emails, we don't sell the data about your site" => "You don't get any emails, we don't sell the data about your site",
// "Registering is just for us to get an overview of Tiki's usage" => "Registering is just for us to get an overview of Tiki's usage",
// "If your site is private or inside your intranet, you should not register" => "If your site is private or inside your intranet, you should not register",
// "tikiwiki.org" => "tikiwiki.org",
// "Information about your site" => "Information about your site",
// "Enter your username or email" => "Enter your username or email",
// "Enter your email" => "Enter your email",
// "Request Password Reset" => "Request Password Reset",
// "Last Version" => "Last Version",
// "Back to page" => "Back to page",
// "to version" => "to version",
// "Simple search" => "Simple search",
// "Date Search" => "Date Search",
// "All dates" => "All dates",
// "Calendar Items" => "Calendar Items",
// "octets" => "octets",
// "Apply content template" => "Apply content template",
// "Data HTML" => "Data HTML",
// "Data Txt" => "Data Txt",
// "Attached Files" => "Attached Files",
// "To add a file, click here" => "To add a file, click here",
// "Reply To Email" => "Reply To Email",
// "if not" => "if not",
// "Save as Draft" => "Save as Draft",
// "Save your changes" => "Save your changes",
// "Save any changes and send to all subscribers" => "Save any changes and send to all subscribers",
// "Send a structure" => "Send a structure",
// "Ex: http://tikiwiki.org or localhost" => "Ex: http://tikiwiki.org or localhost",
// "Use /commxmlrpc.php if your tikiwiki site is installed at the root, otherwise adapt /tiki to your need" => "Use /commxmlrpc.php if your tikiwiki site is installed at the root, otherwise adapt /tiki to your need",
// "Create a sheet" => "Create a sheet",
// "Edit this sheet" => "Edit this sheet",
// "Create New Sheet" => "Create New Sheet",
// "There are individual permissions set for this sheet" => "There are individual permissions set for this sheet",
// "Class Name" => "Class Name",
// "Header Rows" => "Header Rows",
// "Footer Rows" => "Footer Rows",
// "Create new Sheet" => "Create new Sheet",
// "You can access the sheet using the following URL" => "You can access the sheet using the following URL",
// "Available Sheets" => "Available Sheets",
// "Change shoutbox general settings" => "Change shoutbox general settings",
// "auto-link urls" => "auto-link urls",
// "Location : " => "Location : ",
// "This is the staging copy of" => "This is the staging copy of",
// "the approved version of this page" => "the approved version of this page",
// "Viewing of changes since last approval is possible only after first approval" => "Viewing of changes since last approval is possible only after first approval",
// "Approve changes" => "Approve changes",
// "Latest changes will be synchronized after approval" => "Latest changes will be synchronized after approval",
// "This is a new staging page that has not been approved before. Edit and manually move it to the category for approved pages to approve it for the first time" => "This is a new staging page that has not been approved before. Edit and manually move it to the category for approved pages to approve it for the first time",
// "Content may be out of date" => "Content may be out of date",
// "An urgent request for translation has been sent. Until this page is updated, you can see a corrected version in the following pages" => "An urgent request for translation has been sent. Until this page is updated, you can see a corrected version in the following pages",
// "TOC" => "TOC",
// "Parent page" => "Parent page",
// "Child" => "Child",
// "This text was automatically translated by Google Translate from the following page: " => "This text was automatically translated by Google Translate from the following page: ",
// "page: %0/%1" => "page: %0/%1",
// "Last edited by" => "Last edited by",
// "based on work by" => "based on work by",
// "Contributors to this page" => "Contributors to this page",
// "Page last modified on %0 by %1" => "Page last modified on %0 by %1",
// "Created by %0" => "Created by %0",
// "Last Modification: %0 by %1" => "Last Modification: %0 by %1",
// "You will not see the latest queries" => "You will not see the latest queries",
// "Clean" => "Clean",
// "Params" => "Params",
// "Most viewed objects" => "Most viewed objects",
// "Most viewed objects in the last 7 days" => "Most viewed objects in the last 7 days",
// "Total replies" => "Total replies",
// "Average number of replies per topic" => "Average number of replies per topic",
// "Average posts per weblog" => "Average posts per weblog",
// "FAQ Stats" => "FAQ Stats",
// "Most viewed objects in period" => "Most viewed objects in period",
// "Usage chart image" => "Usage chart image",
// "Daily Usage" => "Daily Usage",
// "Tiki Logs" => "Tiki Logs",
// "Clean logs older than" => "Clean logs older than",
// "months" => "months",
// "Thank you for your submission" => "Thank you for your submission",
// "Send a link to a friend" => "Send a link to a friend",
// "The link was sent to the following addresses" => "The link was sent to the following addresses",
// "Friend's email" => "Friend's email",
// "Separate multiple email addresses with a comma" => "Separate multiple email addresses with a comma",
// "Your name" => "Your name",
// "Your email" => "Your email",
// "I found an interesting page that I thought you would like" => "I found an interesting page that I thought you would like",
// "TikiTests Edit" => "TikiTests Edit",
// "Summary mode" => "Summary mode",
// "Show Page Differences" => "Show Page Differences",
// "Show Tidy Errors and Warnings" => "Show Tidy Errors and Warnings",
// "Show POST Data" => "Show POST Data",
// "Use Current Session/Logout" => "Use Current Session/Logout",
// "Recorded Links" => "Recorded Links",
// "Request" => "Request",
// "Element to compare (Xpath expression)" => "Element to compare (Xpath expression)",
// "Test Xpath Expression" => "Test Xpath Expression",
// "Post Variables" => "Post Variables",
// "Tidy Results" => "Tidy Results",
// "Delete this link" => "Delete this link",
// "TikiTests List" => "TikiTests List",
// "Config" => "Config",
// "Replay" => "Replay",
// "Tidy extension not present" => "Tidy extension not present",
// "PECL HTTP extension present" => "PECL HTTP extension present",
// "cURL extension present" => "cURL extension present",
// "PECL HTTP and cURL extension not present. Replay of the TikiTest will not be possible" => "PECL HTTP and cURL extension not present. Replay of the TikiTest will not be possible",
// "List TikiTests" => "List TikiTests",
// "Create a TikiTest" => "Create a TikiTest",
// "Replay the TikiTest" => "Replay the TikiTest",
// "Edit the TikiTest" => "Edit the TikiTest",
// "TikiTests Record Configuration" => "TikiTests Record Configuration",
// "Start Recording Test" => "Start Recording Test",
// "TikiTests Replay Configuration" => "TikiTests Replay Configuration",
// "Failure" => "Failure",
// "Reference" => "Reference",
// "The pages are different" => "The pages are different",
// "The pages are identical" => "The pages are identical",
// "Recording to pause press the pause button" => "Recording to pause press the pause button",
// "Pause the recording" => "Pause the recording",
// "Paused to resume press the play button" => "Paused to resume press the play button",
// "Resume the recording" => "Resume the recording",
// "Stop the recording" => "Stop the recording",
// "Theme Control Center: Categories" => "Theme Control Center: Categories",
// "Control by Objects" => "Control by Objects",
// "Theme Control Center: Sections" => "Theme Control Center: Sections",
// "Edit File" => "Edit File",
// "Advanced mode" => "Advanced mode",
// "Retry" => "Retry",
// "The following files have been successfully uploaded" => "The following files have been successfully uploaded",
// "You can link to the file from a Wiki page using" => "You can link to the file from a Wiki page using",
// "You can display an image in a Wiki page using" => "You can display an image in a Wiki page using",
// "Or using as a thumbnail with ShadowBox" => "Or using as a thumbnail with ShadowBox",
// "You can link to the file from an HTML page using" => "You can link to the file from an HTML page using",
// "You locked the file" => "You locked the file",
// "The file is locked by {\$fileInfo.lockedby}" => "The file is locked by {\$fileInfo.lockedby}",
// "File title" => "File title",
// "required field for podcasts" => "required field for podcasts",
// "File description" => "File description",
// "Unzip zip files" => "Unzip zip files",
// "Author, if different from the Creator" => "Author, if different from the Creator",
// "Maximum number of downloads" => "Maximum number of downloads",
// "Add File" => "Add File",
// "Maximum file size is around" => "Maximum file size is around",
// "Uploading file.." => "Uploading file..",
// "No File to Upload.." => "No File to Upload..",
// " Syntax tips" => " Syntax tips",
// "Link to file from a Wiki page" => "Link to file from a Wiki page",
// "For image files" => "For image files",
// "To display in a Wiki page" => "To display in a Wiki page",
// "Display thumbnail that enlarges" => "Display thumbnail that enlarges",
// "Image ID thumb" => "Image ID thumb",
// "You can include the image in an Wiki page using" => "You can include the image in an Wiki page using",
// "or use filename" => "or use filename",
// "No gallery available" => "No gallery available",
// "The column is disabled" => "The column is disabled",
// "Folder in" => "Folder in",
// "a folder" => "a folder",
// "a bookmark" => "a bookmark",
// "User Contacts Preferences" => "User Contacts Preferences",
// "Default view" => "Default view",
// "Manage Fields" => "Manage Fields",
// "Basic Data" => "Basic Data",
// "Assign Group" => "Assign Group",
// "User Icon" => "User Icon",
// "(non public)" => "(non public)",
// "Homepage" => "Homepage",
// "Users HomePage" => "Users HomePage",
// "Personal Wiki Page" => "Personal Wiki Page",
// "This user is your friend " => "This user is your friend ",
// "The user requested friendship with you" => "The user requested friendship with you",
// "Accept friendship from this user" => "Accept friendship from this user",
// "Refuse friendship from this user" => "Refuse friendship from this user",
// "Currently waiting for user approval" => "Currently waiting for user approval",
// "Cancel friendship request towards this user" => "Cancel friendship request towards this user",
// "Request friendship from this user" => "Request friendship from this user",
// "Additional Information" => "Additional Information",
// "User Contribution" => "User Contribution",
// "has contributed to the following content" => "has contributed to the following content",
// "has not contributed to any content yet" => "has not contributed to any content yet",
// "Forum comments" => "Forum comments",
// "Send Me A Message" => "Send Me A Message",
// "Send me a message " => "Send me a message ",
// "The following message will be sent to user" => "The following message will be sent to user",
// "Message Body" => "Message Body",
// "Toggle" => "Toggle",
// "Toggle options" => "Toggle options",
// "Personal Information" => "Personal Information",
// "Male" => "Male",
// "Female" => "Female",
// "Use Google Map locator" => "Use Google Map locator",
// "Your personal tracker information" => "Your personal tracker information",
// "View extra information" => "View extra information",
// "Unavailable - please set your e-mail below" => "Unavailable - please set your e-mail below",
// "Does your mail reader need a special charset" => "Does your mail reader need a special charset",
// "Your preferred language" => "Your preferred language",
// "Can you read more languages" => "Can you read more languages",
// "Other languages you can read (select on the left to add to the list on the right)" => "Other languages you can read (select on the left to add to the list on the right)",
// "Select language.." => "Select language..",
// "Display info tooltip on mouseover for every user who allows his/her information to be public" => "Display info tooltip on mouseover for every user who allows his/her information to be public",
// "Notify sender when reading his mail" => "Notify sender when reading his mail",
// "My user items" => "My user items",
// "My level" => "My level",
// "Account Information" => "Account Information",
// "Leave \"New password\" and \"Confirm new password\" fields blank to keep current password" => "Leave \"New password\" and \"Confirm new password\" fields blank to keep current password",
// "Confirm new password" => "Confirm new password",
// "Current password (required)" => "Current password (required)",
// "Change administrative info" => "Change administrative info",
// "Account Deletion" => "Account Deletion",
// "Are you really sure you want to delete your account " => "Are you really sure you want to delete your account ",
// "Check this box if you really want to delete your account" => "Check this box if you really want to delete your account",
// "Delete my account" => "Delete my account",
// "New task" => "New task",
// "Task list" => "Task list",
// "Admin mode off" => "Admin mode off",
// "Admin mode on" => "Admin mode on",
// "Task help" => "Task help",
// "Empty Trash" => "Empty Trash",
// "Received task" => "Received task",
// "You received this task, please read and execute it" => "You received this task, please read and execute it",
// "Send task" => "Send task",
// "You send this task to a other user" => "You send this task to a other user",
// "Shared task" => "Shared task",
// "This task is public to a special group" => "This task is public to a special group",
// "Accepted by Task User and Creator" => "Accepted by Task User and Creator",
// "Accepted User and Creator" => "Accepted User and Creator",
// "Task is accepted by user and creator" => "Task is accepted by user and creator",
// "Not Accepted by One User" => "Not Accepted by One User",
// "Not Accepted User" => "Not Accepted User",
// "Task is rejected by one user" => "Task is rejected by one user",
// "Waiting for Me" => "Waiting for Me",
// "Task is not accepted by you, read the task and accept or reject it" => "Task is not accepted by you, read the task and accept or reject it",
// "Waiting for Other User" => "Waiting for Other User",
// "Task is not accepted/rejected by other user" => "Task is not accepted/rejected by other user",
// "Admin Mode" => "Admin Mode",
// "Edit task" => "Edit task",
// "NOT accept" => "NOT accept",
// "Remove from Trash" => "Remove from Trash",
// "Move into Trash" => "Move into Trash",
// "Task saved" => "Task saved",
// "Edit Task" => "Edit Task",
// "View Task" => "View Task",
// "Open a new task" => "Open a new task",
// "taskId" => "taskId",
// "Task user" => "Task user",
// "Only the creator can delete this task" => "Only the creator can delete this task",
// "Use start date and time" => "Use start date and time",
// "Use end date and time" => "Use end date and time",
// "Open / In Process" => "Open / In Process",
// "Waiting / Not Started" => "Waiting / Not Started",
// "Shared for Group" => "Shared for Group",
// "Accepted by User" => "Accepted by User",
// "No / Rejected" => "No / Rejected",
// "Accepted by Creator" => "Accepted by Creator",
// "This message will be send to users if you are makeing changes of assigned tasks" => "This message will be send to users if you are makeing changes of assigned tasks",
// "Send message with changes" => "Send message with changes",
// "Modified by" => "Modified by",
// "Marked as deleted" => "Marked as deleted",
// "Inform task user by email" => "Inform task user by email",
// "You can only view this task" => "You can only view this task",
// "%m/%d/%Y [%H:%M]" => "%m/%d/%Y [%H:%M]",
// "Select One" => "Select One",
// "Undo Trash" => "Undo Trash",
// "Received" => "Received",
// "Submitted" => "Submitted",
// "Shared" => "Shared",
// "All Shared Tasks" => "All Shared Tasks",
// "completed (100%)" => "completed (100%)",
// "Public for group" => "Public for group",
// "User Watches and preferences" => "User Watches and preferences",
// "You need to set your email to receive email notifications" => "You need to set your email to receive email notifications",
// "Report Preferences" => "Report Preferences",
// "You are not allowed to remove this notification " => "You are not allowed to remove this notification ",
// "Use reports to summarise notifications about objects you are watching" => "Use reports to summarise notifications about objects you are watching",
// "Use reports" => "Use reports",
// "Interval in witch you want to get the reports" => "Interval in witch you want to get the reports",
// "Short report" => "Short report",
// "Detailed report" => "Detailed report",
// "HTML-Email" => "HTML-Email",
// "Send me an email also if nothing happened" => "Send me an email also if nothing happened",
// "Reports are disabled, only standard reporting is available" => "Reports are disabled, only standard reporting is available",
// "Sites you are watching" => "Sites you are watching",
// "Use \"watches\" to monitor wiki pages or other objects" => "Use \"watches\" to monitor wiki pages or other objects",
// "Watch new items by clicking the {icon _id=eye} button on specific pages" => "Watch new items by clicking the {icon _id=eye} button on specific pages",
// "Add Watch" => "Add Watch",
// "Select event type" => "Select event type",
// "All watched events" => "All watched events",
// "A user edited an article" => "A user edited an article",
// "A user deleted an article" => "A user deleted an article",
// "A user submits a blog post" => "A user submits a blog post",
// "A user posts a forum thread" => "A user posts a forum thread",
// "A user posts a forum topic" => "A user posts a forum topic",
// "A user edited a wiki page" => "A user edited a wiki page",
// "A user created a wiki page in a language" => "A user created a wiki page in a language",
// "A user edits an article" => "A user edits an article",
// "A user deletes an article" => "A user deletes an article",
// "Used space" => "Used space",
// "up to" => "up to",
// "no limit for admin" => "no limit for admin",
// "Insert Row" => "Insert Row",
// "Insert Column" => "Insert Column",
// "Remove Row" => "Remove Row",
// "Remove Column" => "Remove Column",
// "Merge Cells" => "Merge Cells",
// "Restore Cells" => "Restore Cells",
// "Copy Calculation" => "Copy Calculation",
// "Format Cell" => "Format Cell",
// "expires" => "expires",
// "No articles yet" => "No articles yet",
// "Add an article" => "Add an article",
// "There are no questions in this FAQ" => "There are no questions in this FAQ",
// "Answers" => "Answers",
// "Add Suggestion" => "Add Suggestion",
// "Manage Message Queue" => "Manage Message Queue",
// "Manage Reported Messages" => "Manage Reported Messages",
// "Monitor Topics of this Forum" => "Monitor Topics of this Forum",
// "Stop Monitoring Topics of this Forum" => "Stop Monitoring Topics of this Forum",
// "Monitor Topics and Threads of this Forum" => "Monitor Topics and Threads of this Forum",
// "Stop Monitoring Topics and Threads of this Forum" => "Stop Monitoring Topics and Threads of this Forum",
// "Group Monitor Topics of this Forum" => "Group Monitor Topics of this Forum",
// "Group Monitor Topics and Threads of this Forum" => "Group Monitor Topics and Threads of this Forum",
// "Editing" => "Editing",
// "Post New" => "Post New",
// "Watch for replies" => "Watch for replies",
// "Send me an e-mail when someone replies to my topic" => "Send me an e-mail when someone replies to my topic",
// "Don't send me any e-mails" => "Don't send me any e-mails",
// "Editing posts" => "Editing posts",
// "HTML tags are not allowed inside posts" => "HTML tags are not allowed inside posts",
// "Emot" => "Emot",
// "Forum Lock" => "Forum Lock",
// "Unarchive" => "Unarchive",
// "posts in this forum" => "posts in this forum",
// "Filter Posts" => "Filter Posts",
// "Posts Filtering" => "Posts Filtering",
// "Last post date" => "Last post date",
// "Show archived posts" => "Show archived posts",
// "Containing posts by" => "Containing posts by",
// "Me" => "Me",
// "Posts with no replies" => "Posts with no replies",
// "Archived" => "Archived",
// "Topic List" => "Topic List",
// "The post has been reported and will be reviewed by a moderator" => "The post has been reported and will be reviewed by a moderator",
// "Print this page only" => "Print this page only",
// "Print all pages" => "Print all pages",
// "Stop Monitor" => "Stop Monitor",
// "Edit Fields" => "Edit Fields",
// "Pending" => "Pending",
// "View inserted item" => "View inserted item",
// "Tracker Item" => "Tracker Item",
// "Filter Tracker Items" => "Filter Tracker Items",
// "Edit/Delete" => "Edit/Delete",
// "Items list" => "Items list",
// "Special Operations" => "Special Operations",
// "close" => "close",
// "Add a new" => "Add a new",
// "Edit this" => "Edit this",
// " mail account" => " mail account",
// "Incoming servers (used in this order)" => "Incoming servers (used in this order)",
// "IMAP server" => "IMAP server",
// "Mbox filepath" => "Mbox filepath",
// "Maildir mail directory" => "Maildir mail directory",
// "Use SSL" => "Use SSL",
// "Outgoing server" => "Outgoing server",
// "Account details" => "Account details",
// "Group (shared mail inbox) or private" => "Group (shared mail inbox) or private",
// "This will be a group mail account" => "This will be a group mail account",
// "This will be a personal mail account" => "This will be a personal mail account",
// "Auto-refresh page time" => "Auto-refresh page time",
// "You do not have the correct permissions to Add or Edit a webmail account. <BR />Please contact your administrator and ask for \"admin_personal_webmail\" or \"admin_group_webmail\" permission" => "You do not have the correct permissions to Add or Edit a webmail account. <BR />Please contact your administrator and ask for \"admin_personal_webmail\" or \"admin_group_webmail\" permission",
// "Personal e-mail accounts" => "Personal e-mail accounts",
// "This is the active account" => "This is the active account",
// "IMAP" => "IMAP",
// "Mbox" => "Mbox",
// "Maildir" => "Maildir",
// "POP3" => "POP3",
// "Group e-mail accounts" => "Group e-mail accounts",
// "Show All" => "Show All",
// "Show Unread" => "Show Unread",
// "Show Flagged" => "Show Flagged",
// "Auto refresh set for every \$autoRefresh seconds" => "Auto refresh set for every \$autoRefresh seconds",
// "Refresh now" => "Refresh now",
// "Group messages" => "Group messages",
// "unFlagged" => "unFlagged",
// "Clip" => "Clip",
// "Part" => "Part",
// "page id" => "page id",
// "View edit icons" => "View edit icons",
// "3d browser" => "3d browser",
// "Group Monitor on Structure" => "Group Monitor on Structure",
// "Jump to Content" => "Jump to Content",
// "Fullscreen" => "Fullscreen",
// "Cancel Fullscreen" => "Cancel Fullscreen",
// "Show/Hide Left Column" => "Show/Hide Left Column",
// "Show/Hide Right Column" => "Show/Hide Right Column",
// "Latitude" => "Latitude",
// "Longitude" => "Longitude",
// "Remove Image" => "Remove Image",
// "Word Limit Exceeded" => "Word Limit Exceeded",
// "Character Limit Exceeded" => "Character Limit Exceeded",
// "Character Count" => "Character Count",
// "Word Count" => "Word Count",
// "Format: x,y,zoom where x is the longitude, and y is the latitude. Zoom is between 0(view Earth) and 19. You can use <a href=\"tiki-gmap_locator.php?for=item&amp;itemId={\$item.itemId}&amp;trackerId={\$item.trackerId}&amp;fieldId={\$field_value.fieldId}\">{tr}Google Map Locator" => "Format: x,y,zoom where x is the longitude, and y is the latitude. Zoom is between 0(view Earth) and 19. You can use <a href=\"tiki-gmap_locator.php?for=item&amp;itemId={\$item.itemId}&amp;trackerId={\$item.trackerId}&amp;fieldId={\$field_value.fieldId}\">{tr}Google Map Locator",
// "Number of votes" => "Number of votes",
// "Your rating" => "Your rating",
// "You did not vote yet" => "You did not vote yet",
// "My rating" => "My rating",
// "Click to vote for this value" => "Click to vote for this value",
// "Clik to delete your vote" => "Clik to delete your vote",
// "You have ever subscribed" => "You have ever subscribed",
// "You have not yet subscribed" => "You have not yet subscribed",
// "friends" => "friends",
// "Unsubscribe" => "Unsubscribe",
// "Google Maps is not enabled" => "Google Maps is not enabled",
// "The main text of this page is available in the following languages" => "The main text of this page is available in the following languages",
// "Use this thread to discuss the page" => "Use this thread to discuss the page",
// "Missing or incorrect trackerId parameter for the plugin" => "Missing or incorrect trackerId parameter for the plugin",
// "list" => "list",
// "Email address the person you want to invite" => "Email address the person you want to invite",
// "Set in these groups" => "Set in these groups",
// "Leave" => "Leave",
// "Undecided" => "Undecided",
// "Last Day" => "Last Day",
// "Last Week" => "Last Week",
// "Last Month" => "Last Month",
// "Last Year" => "Last Year",
// "Your default group" => "Your default group",
// "Change default group" => "Change default group",
// "Subscribe to a group" => "Subscribe to a group",
// "Toggle display" => "Toggle display",
// "Creator &amp; Last Editor" => "Creator &amp; Last Editor",
// "as Creator &amp; Last Editor" => "as Creator &amp; Last Editor",
// "no (disabled)" => "no (disabled)",
// "Save the page as a partial translation" => "Save the page as a partial translation",
// "Partial Translation" => "Partial Translation",
// "Save the page as a completed translation" => "Save the page as a completed translation",
// "Complete Translation" => "Complete Translation",
// "Save the page, but do not send notifications and do not count it as new content to be translated" => "Save the page, but do not send notifications and do not count it as new content to be translated",
// "Save the page as a draft" => "Save the page as a draft",
// "Save Draft" => "Save Draft",
// "Permission denied you cannot view the Tiki calendar" => "Permission denied you cannot view the Tiki calendar",
// "%0 enabled" => "%0 enabled",
// "%0 disabled" => "%0 disabled",
// "%0 set" => "%0 set",
// "%0 unset" => "%0 unset",
// "Help on Configuration Sections" => "Help on Configuration Sections",
// "Current version is up to date : <b>%0</b>" => "Current version is up to date : <b>%0</b>",
// "A new major release branch is available" => "A new major release branch is available",
// "A new %0 major release branch is available" => "A new %0 major release branch is available",
// "Enable/disable Tiki features here, but configure them elsewhere" => "Enable/disable Tiki features here, but configure them elsewhere",
// "User registration, login and authentication" => "User registration, login and authentication",
// "Wiki Attachments" => "Wiki Attachments",
// "Article/CMS settings" => "Article/CMS settings",
// "Configuration options for all blogs on your site" => "Configuration options for all blogs on your site",
// "FAQ comments settings" => "FAQ comments settings",
// "Trackers settings" => "Trackers settings",
// "Feeds settings" => "Feeds settings",
// "Directory settings" => "Directory settings",
// "Maps configuration" => "Maps configuration",
// "Meta Tags settings" => "Meta Tags settings",
// "Search settings" => "Search settings",
// "Score settings" => "Score settings",
// "Community settings" => "Community settings",
// "Calendar settings" => "Calendar settings",
// "Intertiki settings" => "Intertiki settings",
// "Freetags settings" => "Freetags settings",
// "Customize look and feel of your Tiki" => "Customize look and feel of your Tiki",
// "Text area" => "Text area",
// "Configure Site Ads and Banners" => "Configure Site Ads and Banners",
// "Kaltura settings" => "Kaltura settings",
// "Help on \$admintitle Config" => "Help on \$admintitle Config",
// "Must specify actionId" => "Must specify actionId",
// "Users Contributions: Addition" => "Users Contributions: Addition",
// "%s Contributions: Addition" => "%s Contributions: Addition",
// "Users Contributions: Suppression" => "Users Contributions: Suppression",
// "%s Contributions: Suppression" => "%s Contributions: Suppression",
// "Total Contributions Addition per Day" => "Total Contributions Addition per Day",
// "Total Contributions Addition per Week" => "Total Contributions Addition per Week",
// "Total Contributions Suppression per Day" => "Total Contributions Suppression per Day",
// "Total Contributions Suppression per Week" => "Total Contributions Suppression per Week",
// "Total Contributions: Addition" => "Total Contributions: Addition",
// "Total Contributions: Suppression" => "Total Contributions: Suppression",
// "Groups Contributions: Addition" => "Groups Contributions: Addition",
// "Groups Contributions: Suppression" => "Groups Contributions: Suppression",
// "white" => "white",
// "gray" => "gray",
// "silver" => "silver",
// "ivory" => "ivory",
// "whitesmoke" => "whitesmoke",
// "beige" => "beige",
// "darkgrey" => "darkgrey",
// "Object doesn't exists" => "Object doesn't exists",
// "Click here to delete the category" => "Click here to delete the category",
// "You can not create a category with a name already existing at this level" => "You can not create a category with a name already existing at this level",
// "The file does not have the required header" => "The file does not have the required header",
// "Category can`t be parent of itself" => "Category can`t be parent of itself",
// "No display" => "No display",
// "You have to provide a hotword and a URL" => "You have to provide a hotword and a URL",
// "You must specify a directory" => "You must specify a directory",
// "moved %d images, %d errors occured" => "moved %d images, %d errors occured",
// "a timeout occured. Hit the reload button to move the rest" => "a timeout occured. Hit the reload button to move the rest",
// "Detected, Version" => "Detected, Version",
// "Test Image" => "Test Image",
// "Not detected" => "Not detected",
// "Your admin password has been changed" => "Your admin password has been changed",
// "You cannot have a blank password" => "You cannot have a blank password",
// "All Fields except gdaltindex must be filled" => "All Fields except gdaltindex must be filled",
// "Path to mapfiles is invalid" => "Path to mapfiles is invalid",
// "No valid gdaltindex executable" => "No valid gdaltindex executable",
// "You cannot mix old and new trackers" => "You cannot mix old and new trackers",
// "Repository name can't be an empty" => "Repository name can't be an empty",
// "Requested action is not supported on repository" => "Requested action is not supported on repository",
// "No repository" => "No repository",
// "Search is mandatory field" => "Search is mandatory field",
// "File not found " => "File not found ",
// "Requested action in not supported on repository" => "Requested action in not supported on repository",
// "Mail-in account %s incorrect" => "Mail-in account %s incorrect",
// "Mail-in account %s saved" => "Mail-in account %s saved",
// "Frequency should be a positive integer" => "Frequency should be a positive integer",
// "Mail-in accounts set to be checked every %s minutes" => "Mail-in accounts set to be checked every %s minutes",
// "Automatic Mail-in accounts checking disabled" => "Automatic Mail-in accounts checking disabled",
// "Unassign module" => "Unassign module",
// "Cannot create or update module: You need to specify a name to the module" => "Cannot create or update module: You need to specify a name to the module",
// "Cannot create or update module: You cannot leave the data field empty" => "Cannot create or update module: You cannot leave the data field empty",
// "Error opening uploaded file" => "Error opening uploaded file",
// "Any wiki page is changed" => "Any wiki page is changed",
// "Any wiki page is changed, even minor changes" => "Any wiki page is changed, even minor changes",
// "A comment in a wiki page is posted or edited" => "A comment in a wiki page is posted or edited",
// "PHP error" => "PHP error",
// "You need to provide a username or an email" => "You need to provide a username or an email",
// "The list name must be specified" => "The list name must be specified",
// "Sorry, your list could not be added. Please check that it doesn\\'t already exist" => "Sorry, your list could not be added. Please check that it doesn\\'t already exist",
// "Sorry, your list could not be updated. Please check that it already exists" => "Sorry, your list could not be updated. Please check that it already exists",
// "unsafe" => "unsafe",
// "register_globals should be off by default. See the php manual for details" => "register_globals should be off by default. See the php manual for details",
// "safe" => "safe",
// "risky" => "risky",
// "off" => "off",
// "session.use_trans_sid should be off by default. See the php manual for details" => "session.use_trans_sid should be off by default. See the php manual for details",
// "upload_tmp_dir is probably within your Tikiwiki directory. There is a risk that someone can upload any file to this directory and access them via web browser" => "upload_tmp_dir is probably within your Tikiwiki directory. There is a risk that someone can upload any file to this directory and access them via web browser",
// "cannot check if the upload_tmp_dir is accessible via web browser. To be sure you should check your webserver config" => "cannot check if the upload_tmp_dir is accessible via web browser. To be sure you should check your webserver config",
// "setting the xbithack option is unsafe. Depending on the file handling of your webserver and your tiki settings, it may be possible that a attacker can upload scripts to file gallery and execute them" => "setting the xbithack option is unsafe. Depending on the file handling of your webserver and your tiki settings, it may be possible that a attacker can upload scripts to file gallery and execute them",
// "allow_url_fopen may potentially be used to upload remote data or scripts. If you dont use the blog feature, you can switch it off" => "allow_url_fopen may potentially be used to upload remote data or scripts. If you dont use the blog feature, you can switch it off",
// "The Path to store files in the filegallery should be outside the tiki root directory" => "The Path to store files in the filegallery should be outside the tiki root directory",
// "The Path to store files in the imagegallery should be outside the tiki root directory" => "The Path to store files in the imagegallery should be outside the tiki root directory",
// "The feature \"Edit Templates\" is switched on. Do not allow anyone you cannot trust to use this feature. It can easily be used to inject php code" => "The feature \"Edit Templates\" is switched on. Do not allow anyone you cannot trust to use this feature. It can easily be used to inject php code",
// "The \"Snarf Wikiplugin\" is activated. It can be used by wiki editors to include pages from the local network and via regex replacement create any html" => "The \"Snarf Wikiplugin\" is activated. It can be used by wiki editors to include pages from the local network and via regex replacement create any html",
// "The \"Regex Wikiplugin\" is activated. It can be used by wiki editors to create any html via regex replacement" => "The \"Regex Wikiplugin\" is activated. It can be used by wiki editors to create any html via regex replacement",
// "The \"Lsdir Wikiplugin\" is activated. It can be used by wiki editors to view the contents of any directory" => "The \"Lsdir Wikiplugin\" is activated. It can be used by wiki editors to view the contents of any directory",
// "The \"Bloglist Wikiplugin\" is activated. It can be used by wiki editors to disclose private blog posts" => "The \"Bloglist Wikiplugin\" is activated. It can be used by wiki editors to disclose private blog posts",
// "The \"iframe Wikiplugin\" is activated. It can be used by wiki editors for cross site scripting attacks" => "The \"iframe Wikiplugin\" is activated. It can be used by wiki editors for cross site scripting attacks",
// "The \"js Wikiplugin\" is activated. It can be used by wiki editors to use Javascript, which can be used to do all kind of nasty things like cross site scripting attacks, etc" => "The \"js Wikiplugin\" is activated. It can be used by wiki editors to use Javascript, which can be used to do all kind of nasty things like cross site scripting attacks, etc",
// "The \"JQ Wikiplugin\" is activated. It can be used by wiki editors to use Javascript, which can be used to do all kind of nasty things like cross site scripting attacks, etc" => "The \"JQ Wikiplugin\" is activated. It can be used by wiki editors to use Javascript, which can be used to do all kind of nasty things like cross site scripting attacks, etc",
// "The \"Redirect Wikiplugin\" is activated. It can be used by wiki editors for cross site scripting attacks" => "The \"Redirect Wikiplugin\" is activated. It can be used by wiki editors for cross site scripting attacks",
// "The \"Module Wikiplugin\" is activated. It can be used by wiki editors to add modules which permit to access information (see module list)" => "The \"Module Wikiplugin\" is activated. It can be used by wiki editors to add modules which permit to access information (see module list)",
// "The \"Userlist Wikiplugin\" is activated. It can be used by wiki editors to display the list of users" => "The \"Userlist Wikiplugin\" is activated. It can be used by wiki editors to display the list of users",
// "The \"Usercount Wikiplugin\" is activated. It can be used by wiki editors to display a count of the number of users" => "The \"Usercount Wikiplugin\" is activated. It can be used by wiki editors to display a count of the number of users",
// "The \"SQL Wikiplugin\" is activated. It can be used by wiki editors to execute SQL commands" => "The \"SQL Wikiplugin\" is activated. It can be used by wiki editors to execute SQL commands",
// "Path disclosure" => "Path disclosure",
// "Path disclosure through error message" => "Path disclosure through error message",
// "SQL injection" => "SQL injection",
// "SQL injection by authenticated user" => "SQL injection by authenticated user",
// "SQL injection by authenticated user with special privileges" => "SQL injection by authenticated user with special privileges",
// "SQL injection without authentication" => "SQL injection without authentication",
// "PHP command injection" => "PHP command injection",
// "PHP command injection by authenticated user" => "PHP command injection by authenticated user",
// "PHP command injection by authenticated user with special privileges" => "PHP command injection by authenticated user with special privileges",
// "PHP command injection without authentication" => "PHP command injection without authentication",
// "File upload" => "File upload",
// "File is not readable. Unable to check" => "File is not readable. Unable to check",
// "This is not a Tikiwiki file. Check if this file was uploaded and if it is dangerous" => "This is not a Tikiwiki file. Check if this file was uploaded and if it is dangerous",
// "This is a modified File. Cannot check version. Check if it is dangerous" => "This is a modified File. Cannot check version. Check if it is dangerous",
// "This file is from another Tikiwiki version: " => "This file is from another Tikiwiki version: ",
// "You have to provide a word" => "You have to provide a word",
// "You must specify a page name, it will be created if it doesn't exist" => "You must specify a page name, it will be created if it doesn't exist",
// "No Errors detected" => "No Errors detected",
// "Are you sure you want to delete this custom tool" => "Are you sure you want to delete this custom tool",
// "JavaScript is required for this page" => "JavaScript is required for this page",
// "Are you sure you want to remove this topic" => "Are you sure you want to remove this topic",
// "Are you sure you want to remove this topic AND all the articles related" => "Are you sure you want to remove this topic AND all the articles related",
// "Tracker does not allow attachments" => "Tracker does not allow attachments",
// "Remove group: " => "Remove group: ",
// "Remove permission: %s on %s" => "Remove permission: %s on %s",
// "Group name can not be empty" => "Group name can not be empty",
// "The description is mandatory as it is used as mail subject" => "The description is mandatory as it is used as mail subject",
// "Invalid or unknown email" => "Invalid or unknown email",
// "User login or email is required" => "User login or email is required",
// "User does not exist on master" => "User does not exist on master",
// "Created account %s <%s>" => "Created account %s <%s>",
// "Assigned %s in group %s" => "Assigned %s in group %s",
// "Email validation requested but email address not set" => "Email validation requested but email address not set",
// "Password not set" => "Password not set",
// "User %s already exists" => "User %s already exists",
// "User login contains invalid characters" => "User login contains invalid characters",
// "New %s created with %s %s" => "New %s created with %s %s",
// "Impossible to create new %s with %s %s" => "Impossible to create new %s with %s %s",
// "%s %s successfully deleted" => "%s %s successfully deleted",
// "Deleted account %s" => "Deleted account %s",
// "%s %s removed from %s %s" => "%s %s removed from %s %s",
// "%s %s assigned to %s %s" => "%s %s assigned to %s %s",
// "group %s set as the default group of user %s" => "group %s set as the default group of user %s",
// "Login contains invalid characters" => "Login contains invalid characters",
// "%s changed from %s to %s" => "%s changed from %s to %s",
// "Impossible to change %s from %s to %s" => "Impossible to change %s from %s to %s",
// "%s modified successfully" => "%s modified successfully",
// "%s modification failed" => "%s modification failed",
// "approved by " => "approved by ",
// "This function is only for staging pages" => "This function is only for staging pages",
// "Permission denied you cannot approve staging pages" => "Permission denied you cannot approve staging pages",
// "Approved page was last saved after most recent staging edit" => "Approved page was last saved after most recent staging edit",
// "rss feed disabled" => "rss feed disabled",
// "Tiki RSS feed for articles" => "Tiki RSS feed for articles",
// "Last articles" => "Last articles",
// "Unassign perm %s from group %s" => "Unassign perm %s from group %s",
// "You have to indicate a group" => "You have to indicate a group",
// "This group is invalid" => "This group is invalid",
// "Image Galleries Admin Panel" => "Image Galleries Admin Panel",
// "Could not read image %s" => "Could not read image %s",
// "Image %s upload failed" => "Image %s upload failed",
// "Image %s uploaded successfully" => "Image %s uploaded successfully",
// "Image %s removed from Batch directory" => "Image %s removed from Batch directory",
// "Impossible to remove image %s from Batch directory" => "Impossible to remove image %s from Batch directory",
// "Permission denied you cannot use the batch directory loading" => "Permission denied you cannot use the batch directory loading",
// "Incorrect directory chosen for batch upload of images" => "Incorrect directory chosen for batch upload of images",
// "Please setup that dir on " => "Please setup that dir on ",
// "Please contact the website administrator" => "Please contact the website administrator",
// "Invalid directory name" => "Invalid directory name",
// "File Galleries Admin Panel" => "File Galleries Admin Panel",
// "Could not read file %s" => "Could not read file %s",
// "Could not write to file %s" => "Could not write to file %s",
// "File %s upload failed" => "File %s upload failed",
// "Upload was successful" => "Upload was successful",
// "File %s removed from Batch directory" => "File %s removed from Batch directory",
// "Impossible to remove file %s from Batch directory" => "Impossible to remove file %s from Batch directory",
// "Incorrect directory chosen for batch upload of files" => "Incorrect directory chosen for batch upload of files",
// "Tiki RSS feed for blog: " => "Tiki RSS feed for blog: ",
// "Last modifications to the blog" => "Last modifications to the blog",
// "No blogId specified" => "No blogId specified",
// "Tiki RSS feed for weblogs" => "Tiki RSS feed for weblogs",
// "Last posts to weblogs" => "Last posts to weblogs",
// "Nothing tagged yet" => "Nothing tagged yet",
// "You must clear your browser cache" => "You must clear your browser cache",
// "You need to <a href=\"tiki-admin_calendars.php\">create a calendar</a>" => "You need to <a href=\"tiki-admin_calendars.php\">create a calendar</a>",
// "Calendar event : " => "Calendar event : ",
// "Permission denied you can not view this page" => "Permission denied you can not view this page",
// "Access Denied" => "Access Denied",
// "%H:%M %Z" => "%H:%M %Z",
// "Tiki RSS feed for calendars" => "Tiki RSS feed for calendars",
// "Invalid username or activation code. Maybe this code has already been used" => "Invalid username or activation code. Maybe this code has already been used",
// "Invalid old password or unknown user" => "Invalid old password or unknown user",
// "Invalid request. Expecting channels array" => "Invalid request. Expecting channels array",
// "Missing channel name" => "Missing channel name",
// "Authentication required" => "Authentication required",
// "One of the requested channels cannot be requested. It does not exist or permission is denied" => "One of the requested channels cannot be requested. It does not exist or permission is denied",
// "One of the install profiles could not be obtained" => "One of the install profiles could not be obtained",
// "This feature is disabled'.\$prefs['validateUsers']));\n\t\$smarty->display('error.tpl" => "This feature is disabled'.\$prefs['validateUsers']));\n\t\$smarty->display('error.tpl",
// "Problem. Try to log in again to receive new confirmation instructions" => "Problem. Try to log in again to receive new confirmation instructions",
// "ERROR: you must include a subject or a message. You must also make sure to have a valid e-mail in the FROM field" => "ERROR: you must include a subject or a message. You must also make sure to have a valid e-mail in the FROM field",
// "You need to change chmod 'whelp' manually to 777" => "You need to change chmod 'whelp' manually to 777",
// "Tiki RSS feed for directory sites" => "Tiki RSS feed for directory sites",
// "Last sites" => "Last sites",
// "Must enter a name to add a site. " => "Must enter a name to add a site. ",
// "Must enter a url to add a site. " => "Must enter a url to add a site. ",
// "URL already added to the directory. Duplicate site? " => "URL already added to the directory. Duplicate site? ",
// "URL cannot be accessed wrong URL or site is offline and cannot be added to the directory. " => "URL cannot be accessed wrong URL or site is offline and cannot be added to the directory. ",
// "Must select a category. " => "Must select a category. ",
// "URL cannot be accessed: wrong URL or site is offline and cannot be added to the directory" => "URL cannot be accessed: wrong URL or site is offline and cannot be added to the directory",
// "No parent specified" => "No parent specified",
// "Last sites of directory \" . \$rc[\"name\"] . \" " => "Last sites of directory \" . \$rc[\"name\"] . \" ",
// "You cannot download this file right now. Your score is low or file limit was reached" => "You cannot download this file right now. Your score is low or file limit was reached",
// "Error : The file %s doesn't exist" => "Error : The file %s doesn't exist",
// "The language can't be changed as its set of translations has already this language" => "The language can't be changed as its set of translations has already this language",
// "Invalid structure_id or page_ref_id" => "Invalid structure_id or page_ref_id",
// "No topic id specified" => "No topic id specified",
// "Invalid topic id specified" => "Invalid topic id specified",
// "No object indicated" => "No object indicated",
// "Page is a staging copy. Translation must begin from the approved copy" => "Page is a staging copy. Translation must begin from the approved copy",
// "Translation of this page is incomplete" => "Translation of this page is incomplete",
// "No type indicated" => "No type indicated",
// "Not enable for this type of object" => "Not enable for this type of object",
// "Override lock and carry on with edit" => "Override lock and carry on with edit",
// "Page is currently being edited" => "Page is currently being edited",
// "This page is being edited by " => "This page is being edited by ",
// "Please check with the user before editing the page,\n\t\t\totherwise the changes will be stored as two separate versions in the history and\n\t\t\tyou will have to manually merge them later. " => "Please check with the user before editing the page,\n\t\t\totherwise the changes will be stored as two separate versions in the history and\n\t\t\tyou will have to manually merge them later. ",
// "Can't import remote HTML page" => "Can't import remote HTML page",
// "The file you selected is too large to upload" => "The file you selected is too large to upload",
// "Incorrect file extension was used for your 0gg screencast, expecting .ogg" => "Incorrect file extension was used for your 0gg screencast, expecting .ogg",
// "Page already exists. Go back and choose a different name" => "Page already exists. Go back and choose a different name",
// "The translation set already contains a page in this language" => "The translation set already contains a page in this language",
// "No questions group indicated" => "No questions group indicated",
// "Remove archive: " => "Remove archive: ",
// "Remove file gallery: " => "Remove file gallery: ",
// "Tiki RSS feed for file galleries" => "Tiki RSS feed for file galleries",
// "Last files uploaded to the file galleries" => "Last files uploaded to the file galleries",
// "No galleryId specified" => "No galleryId specified",
// "Tiki RSS feed for the file gallery: " => "Tiki RSS feed for the file gallery: ",
// "Form error - no import method selected for some reason" => "Form error - no import method selected for some reason",
// "Form error - no server-side filename entered for selected import method" => "Form error - no server-side filename entered for selected import method",
// "Last replied forum topics" => "Last replied forum topics",
// "No forumId specified" => "No forumId specified",
// "Tiki RSS feed for forum: " => "Tiki RSS feed for forum: ",
// "Tiki RSS feed for forums" => "Tiki RSS feed for forums",
// "Last topics in forums" => "Last topics in forums",
// "Not supported yet" => "Not supported yet",
// "Accepted friendship request from %s" => "Accepted friendship request from %s",
// "Refused friendship request from %s" => "Refused friendship request from %s",
// "Canceled friendship request with %s" => "Canceled friendship request with %s",
// "Broke friendship with %s" => "Broke friendship with %s",
// "I have broken our friendship" => "I have broken our friendship",
// "You must be logged in to use this feature" => "You must be logged in to use this feature",
// "Friendship request sent to %s" => "Friendship request sent to %s",
// "You're already friend of %s" => "You're already friend of %s",
// "I have accepted your friendship request" => "I have accepted your friendship request",
// "I have refused your friendship request" => "I have refused your friendship request",
// "I have canceled my friendship request" => "I have canceled my friendship request",
// "first uploaded image" => "first uploaded image",
// "last uploaded image" => "last uploaded image",
// "random image" => "random image",
// "Permission denied you cannot make the map of this gallery" => "Permission denied you cannot make the map of this gallery",
// "Back to preferences" => "Back to preferences",
// "Back to item" => "Back to item",
// "No valid renderer found. GD or PDFLib required" => "No valid renderer found. GD or PDFLib required",
// "No sheet specified" => "No sheet specified",
// "You must select a renderer" => "You must select a renderer",
// "Invalid Series for current graphic" => "Invalid Series for current graphic",
// "Tiki RSS feed for image galleries" => "Tiki RSS feed for image galleries",
// "Last images uploaded to the image galleries" => "Last images uploaded to the image galleries",
// "Tiki RSS feed for the image gallery: " => "Tiki RSS feed for the image gallery: ",
// "Only the administrator can upload language files" => "Only the administrator can upload language files",
// "updated from structured text import" => "updated from structured text import",
// "created from structured text import" => "created from structured text import",
// "Operations executed successfully" => "Operations executed successfully",
// "Invalid software name" => "Invalid software name",
// "Page saved (version %d)" => "Page saved (version %d)",
// "You have requested that this page be machine translated" => "You have requested that this page be machine translated",
// "However, the Machine Translation feature is not enabled. Please enable this feature, or ask a site admin to do it" => "However, the Machine Translation feature is not enabled. Please enable this feature, or ask a site admin to do it",
// "No repository given" => "No repository given",
// "Error writing in the databse: \$query" => "Error writing in the databse: \$query",
// "Permission denied: You cannot upload videos" => "Permission denied: You cannot upload videos",
// "You need to set your Kaltura account details: " => "You need to set your Kaltura account details: ",
// "Could not establish Kaltura session. Try again" => "Could not establish Kaltura session. Try again",
// "Permission denied: You cannot remix videos" => "Permission denied: You cannot remix videos",
// "Permission denied: You cannot change video version" => "Permission denied: You cannot change video version",
// "Permission denied: You cannot delete kaltura video" => "Permission denied: You cannot delete kaltura video",
// "Permission denied: You cannot download kaltura video" => "Permission denied: You cannot download kaltura video",
// "Permission denied: You cannot edit video information" => "Permission denied: You cannot edit video information",
// "Permission denied: You cannot view video" => "Permission denied: You cannot view video",
// "Delete comments" => "Delete comments",
// "Approved Status" => "Approved Status",
// "Queued" => "Queued",
// "The file is already locked by %s" => "The file is already locked by %s",
// "Remove file: " => "Remove file: ",
// "Quota too big" => "Quota too big",
// "Quota too small" => "Quota too small",
// "Warning: Empty file" => "Warning: Empty file",
// "Please re-upload your file" => "Please re-upload your file",
// "Could not upload the file" => "Could not upload the file",
// "Could not find the file requested" => "Could not find the file requested",
// "Permission denied you can edit this file" => "Permission denied you can edit this file",
// "Cannot read the file" => "Cannot read the file",
// "Upload was not successful. Duplicate file content" => "Upload was not successful. Duplicate file content",
// "File update was successful" => "File update was successful",
// "This gallery does not exist" => "This gallery does not exist",
// "Permission denied: You cannot view this page" => "Permission denied: You cannot view this page",
// "Invalid action" => "Invalid action",
// "You have to enable cookies to be able to login to this site" => "You have to enable cookies to be able to login to this site",
// "Unable to contact remote server" => "Unable to contact remote server",
// "XMLRPC Error: " => "XMLRPC Error: ",
// "Unable to create login" => "Unable to create login",
// "More than %d unsuccessful login attempts have been made" => "More than %d unsuccessful login attempts have been made",
// "An email has been sent to you with the instructions to follow" => "An email has been sent to you with the instructions to follow",
// "Resend" => "Resend",
// "You should have received an email. Check your mailbox and your spam box.Otherwise click on the button to resend the email" => "You should have received an email. Check your mailbox and your spam box.Otherwise click on the button to resend the email",
// "Your default nickname is already in use. A new one has to be selected" => "Your default nickname is already in use. A new one has to be selected",
// "The selected account is not associated with your identity" => "The selected account is not associated with your identity",
// "unknown action" => "unknown action",
// "Authentication method is not OpenID" => "Authentication method is not OpenID",
// "Invalid password" => "Invalid password",
// "Account disabled" => "Account disabled",
// "You must use the right case for your user name" => "You must use the right case for your user name",
// "Sorry, you can't use this feature" => "Sorry, you can't use this feature",
// "Feature Ajax Disabled. Please ask your site administrator to enable" => "Feature Ajax Disabled. Please ask your site administrator to enable",
// "You must first setup MapServer" => "You must first setup MapServer",
// "invalid mapfile name" => "invalid mapfile name",
// "An error as occured with the mapfile" => "An error as occured with the mapfile",
// "Please create a directory named ' . \$prefs['map_path'] . ' to hold your map files" => "Please create a directory named ' . \$prefs['map_path'] . ' to hold your map files",
// "You do not have permissions to view the maps" => "You do not have permissions to view the maps",
// "Maps feature is not correctly setup : Maps path is missing" => "Maps feature is not correctly setup : Maps path is missing",
// "mapfile name incorrect" => "mapfile name incorrect",
// "This mapfile already exists" => "This mapfile already exists",
// "You do not have permission to write to the mapfile" => "You do not have permission to write to the mapfile",
// "You do not have permission to delete the mapfile" => "You do not have permission to delete the mapfile",
// "I could not make a copy" => "I could not make a copy",
// "You do not have permission to read the mapfile" => "You do not have permission to read the mapfile",
// "map edit" => "map edit",
// "You dont have permission to do that" => "You dont have permission to do that",
// "Tiki RSS feed for maps" => "Tiki RSS feed for maps",
// "List of maps available" => "List of maps available",
// "You do not have permissions to view the layers" => "You do not have permissions to view the layers",
// "You do not have permissions to delete a file" => "You do not have permissions to delete a file",
// "You do not have permissions to create a directory" => "You do not have permissions to create a directory",
// "The Directory is not empty" => "The Directory is not empty",
// "You do not have permissions to delete a directory" => "You do not have permissions to delete a directory",
// "You do not have permissions to create an index file" => "You do not have permissions to create an index file",
// "Invalid file name" => "Invalid file name",
// "Invalid files to index" => "Invalid files to index",
// "I do not know where is gdaltindex. Set correctly the Map feature" => "I do not know where is gdaltindex. Set correctly the Map feature",
// "I could not create the index file" => "I could not create the index file",
// "No page provided" => "No page provided",
// "Page \"%0\" does not exist" => "Page \"%0\" does not exist",
// "Welcome at Hawiki" => "Welcome at Hawiki",
// "This Tikiwiki site is prepared for access from a lot of mobile devices, e.g. WAP phones, PDA's, i-mode devices and much more" => "This Tikiwiki site is prepared for access from a lot of mobile devices, e.g. WAP phones, PDA's, i-mode devices and much more",
// "You can browse this site on your mobile device by directing your device's browser towards the following URL here on this site" => "You can browse this site on your mobile device by directing your device's browser towards the following URL here on this site",
// "tiki-mobile.php" => "tiki-mobile.php",
// "You need to run setup.sh :<br />./setup.sh \$APACHEUSER all<br />Common Apache users are www-data, apache or nobody" => "You need to run setup.sh :<br />./setup.sh \$APACHEUSER all<br />Common Apache users are www-data, apache or nobody",
// "Your PHP installation does not have zlib enabled" => "Your PHP installation does not have zlib enabled",
// "Are you sure you want to delete this note" => "Are you sure you want to delete this note",
// "Note not found" => "Note not found",
// "Permission denied you cannot assign permissions for this object" => "Permission denied you cannot assign permissions for this object",
// "Permission denied you cannot view the source of this page" => "Permission denied you cannot view the source of this page",
// "Missing object list type argument" => "Missing object list type argument",
// "Index" => "Index",
// "Index (' . \$code . " => "Index (' . \$code . ",
// "Pageviews" => "Pageviews",
// "You don't have permission to edit quizzes" => "You don't have permission to edit quizzes",
// "You are already logged in" => "You are already logged in",
// "You must choose a group" => "You must choose a group",
// "This is not a valid mail adress" => "This is not a valid mail adress",
// "The passwords don't match" => "The passwords don't match",
// "Username cannot contain uppercase letters" => "Username cannot contain uppercase letters",
// "Username must be at least" => "Username must be at least",
// "Username cannot contain more than" => "Username cannot contain more than",
// "characters" => "characters",
// "Please enter a valid %s.  No spaces, more than %d characters and contain %s" => "Please enter a valid %s.  No spaces, more than %d characters and contain %s",
// "Missing User Name" => "Missing User Name",
// "User Already Exists" => "User Already Exists",
// "Valid User Name" => "Valid User Name",
// "Missing Email" => "Missing Email",
// "Valid Email" => "Valid Email",
// "Unable to send mail. User has not configured email" => "Unable to send mail. User has not configured email",
// "Please contact the Administrator if you do not get the email, or if there is an issue with resetting the password" => "Please contact the Administrator if you do not get the email, or if there is an issue with resetting the password",
// "The mail can't be sent. Contact the administrator" => "The mail can't be sent. Contact the administrator",
// "An email with a link to reset your password has been sent " => "An email with a link to reset your password has been sent ",
// "to the email" => "to the email",
// "last version" => "last version",
// "You cannot rename staging pages. Please rename the approved page instead" => "You cannot rename staging pages. Please rename the approved page instead",
// "Permission denied you cannot rename this page" => "Permission denied you cannot rename this page",
// "Cannot rename page because the new name begins with reserved prefix" => "Cannot rename page because the new name begins with reserved prefix",
// "Cannot rename page because maybe new staging page name already exists" => "Cannot rename page because maybe new staging page name already exists",
// "Error Message" => "Error Message",
// "Tiki RSS Feed Error Message: \$errmsg" => "Tiki RSS Feed Error Message: \$errmsg",
// "A problem occured during file uploading" => "A problem occured during file uploading",
// "File which was causing trouble was at rank" => "File which was causing trouble was at rank",
// "The error was" => "The error was",
// "No newsletters available" => "No newsletters available",
// "invalid email" => "invalid email",
// "Error: " => "Error: ",
// "Notice: this variable may not be empty" => "Notice: this variable may not be empty",
// "Notice: invalid variable value" => "Notice: invalid variable value",
// "Permission denied you cannot remove this sheet" => "Permission denied you cannot remove this sheet",
// "You do not have permission to edit messages \$owner" => "You do not have permission to edit messages \$owner",
// "Clean the sql logs" => "Clean the sql logs",
// "Report to the webmaster" => "Report to the webmaster",
// "empty" => "empty",
// "No trackerId specified" => "No trackerId specified",
// "Tiki RSS feed for individual trackers: " => "Tiki RSS feed for individual trackers: ",
// "You must lock the file before editing it" => "You must lock the file before editing it",
// "Batch file processed" => "Batch file processed",
// "Incorrect file extension" => "Incorrect file extension",
// "The uploaded file ist not recognized as a image" => "The uploaded file ist not recognized as a image",
// "That is not an image (or you have php < 4.0.5)" => "That is not an image (or you have php < 4.0.5)",
// "Your screencast has been uploaded successfully" => "Your screencast has been uploaded successfully",
// "Your screencasts have been uploaded successfully" => "Your screencasts have been uploaded successfully",
// "Usage" => "Usage",
// "Password has been changed" => "Password has been changed",
// "Invalid password. Your current password is required to change administrative information" => "Invalid password. Your current password is required to change administrative information",
// "Email is set to %s" => "Email is set to %s",
// "unicode" => "unicode",
// "was moved into trash" => "was moved into trash",
// "trashed by" => "trashed by",
// "open / in process" => "open / in process",
// "Rights by creator" => "Rights by creator",
// "END" => "END",
// "Percentage" => "Percentage",
// "Task accepted by creator" => "Task accepted by creator",
// "Task accepted by task user" => "Task accepted by task user",
// "Task NOT accepted by creator" => "Task NOT accepted by creator",
// "Task NOT accepted by task user" => "Task NOT accepted by task user",
// "Sorry this task does not exist or you have no rights to view this task" => "Sorry this task does not exist or you have no rights to view this task",
// "Task entries" => "Task entries",
// "Changes" => "Changes",
// "Info message" => "Info message",
// "NEW Task" => "NEW Task",
// "Sorry you are not allowed to send tasks to other users, or the user is not allowed to receive tasks" => "Sorry you are not allowed to send tasks to other users, or the user is not allowed to receive tasks",
// "Changes on Task" => "Changes on Task",
// "You received a new task" => "You received a new task",
// "The priority is" => "The priority is",
// "very low" => "very low",
// "low" => "low",
// "high" => "high",
// "very high" => "very high",
// "You've to start your work at least on" => "You've to start your work at least on",
// "You've to finish your work on" => "You've to finish your work on",
// "Login and click the link below" => "Login and click the link below",
// "Please read the task and work on it" => "Please read the task and work on it",
// "Sorry, there was an error while trying to write data into the database" => "Sorry, there was an error while trying to write data into the database",
// "A new page is created in a language" => "A new page is created in a language",
// "Language watch" => "Language watch",
// "Permission denied: you cannot view this blog post while it is marked private" => "Permission denied: you cannot view this blog post while it is marked private",
// "You must suggest a question; please try again" => "You must suggest a question; please try again",
// "You are not permitted to remove someone else\\'s post" => "You are not permitted to remove someone else\\'s post",
// "Incorrect thread" => "Incorrect thread",
// "A SheetId is required" => "A SheetId is required",
// "That tracker don't use extras" => "That tracker don't use extras",
// "There are a problem connecting to that account" => "There are a problem connecting to that account",
// "There are a problem deleting that mail" => "There are a problem deleting that mail",
// "Mail ID" => "Mail ID",
// "There are a problem deleting mails" => "There are a problem deleting mails",
// "Are you sure you want to delete this account" => "Are you sure you want to delete this account",
// "Taking" => "Taking",
// "Putting back" => "Putting back",
// "Checking" => "Checking",
// "Tiki RSS feed for the wiki pages" => "Tiki RSS feed for the wiki pages",
// "Last modifications to the Wiki" => "Last modifications to the Wiki",
// "Plugin modified by editor" => "Plugin modified by editor",
// "Tidy Extension not present" => "Tidy Extension not present",
// "The TikiTests Replay File is Empty" => "The TikiTests Replay File is Empty",
// "The TikiTests Replay File has an error" => "The TikiTests Replay File has an error",
// "You are about to delete a TikiTest file, do you want to continue " => "You are about to delete a TikiTest file, do you want to continue ",
// "Error deleting the file" => "Error deleting the file",
// "TikiTest List" => "TikiTest List",
// "TikiTest Record" => "TikiTest Record",
// "You need one of the extension pecl HTTP or Curl to replay the TikiTest" => "You need one of the extension pecl HTTP or Curl to replay the TikiTest",
// "The TikiTest Replay File is Empty" => "The TikiTest Replay File is Empty",
// "TikiTest Replay" => "TikiTest Replay",
// "The page is empty" => "The page is empty",
// ### end of untranslated words
// ###

// ###
// ### start of possibly untranslated words
// ###

"Re:" => "Re:",
"ID" => "ID",
"Wiki" => "Wiki",
"Trackers" => "Trackers",
"Newsletter" => "Newsletter",
"blog" => "blog",
"WikiDiff::apply: line count mismatch: %s != %s" => "WikiDiff::apply: line count mismatch: %s != %s",
"WikiDiff::_check: failed" => "WikiDiff::_check: failed",
"WikiDiff::_check: edit sequence is non-optimal" => "WikiDiff::_check: edit sequence is non-optimal",
"WikiDiff Okay: LCS = %s" => "WikiDiff Okay: LCS = %s",
"Blog" => "Blog",
"posted on" => "posted on",
"Rating" => "Rating",
"1" => "1",
"2" => "2",
"3" => "3",
"4" => "4",
"5" => "5",
"Copyright" => "Copyright",
"Shoutbox" => "Shoutbox",
"Webmail" => "Webmail",
"Mail-in" => "Mail-in",
"XMLRPC API" => "XMLRPC API",
"Uploaded filenames must match regex" => "Uploaded filenames must match regex",
"Port" => "Port",
"Top" => "Top",
"Tracker" => "Tracker",
"help" => "help",
"min" => "min",
"text" => "text",
"wiki" => "wiki",
"Tracker was modified at " => "Tracker was modified at ",
"textarea" => "textarea",
"drop down" => "drop down",
"user selector" => "user selector",
"email" => "email",
"url" => "url",
"Start date" => "Start date",
"Avatar" => "Avatar",
"Cookie" => "Cookie",
"Pre" => "Pre",
"sort" => "sort",
"URL" => "URL",
"Stop" => "Stop",
"Filter" => "Filter",
"Font" => "Font",
"Text" => "Text",
"data" => "data",
"Fields" => "Fields",
"Flag" => "Flag",
"valid" => "valid",
"ERROR: No valid users to send the message" => "ERROR: No valid users to send the message",
"id" => "id",
"debug" => "debug",
"stars" => "stars",
"Syntax" => "Syntax",
"registered at your site" => "registered at your site",
"This email address has been removed to the list of subscriptors of:" => "This email address has been removed to the list of subscriptors of:",
"Newsletter:" => "Newsletter:",
"You can unsubscribe from this newsletter following this link" => "You can unsubscribe from this newsletter following this link",
"This email address has been added to the list of subscriptors of:" => "This email address has been added to the list of subscriptors of:",
"OK" => "OK",
"Lowest" => "Lowest",
"Low" => "Low",
"Mailbox" => "Mailbox",
"replyall" => "replyall",
"Admin" => "Admin",
"login" => "login",
"Pages:" => "Pages:",
"Switch" => "Switch",
"Standard" => "Standard",
"Cache" => "Cache",
"Del" => "Del",
"RSS feed" => "RSS feed",
"Permalink" => "Permalink",
"referenced by" => "referenced by",
"references" => "references",
"Trackback pings" => "Trackback pings",
"URI" => "URI",
"Import" => "Import",
"avatar" => "avatar",
"Directory path" => "Directory path",
"Uploaded image names must match regex" => "Uploaded image names must match regex",
"Uploaded image names cannot match regex" => "Uploaded image names cannot match regex",
"port" => "port",
"Undo" => "Undo",
"Export" => "Export",
"MultiPrint" => "MultiPrint",
"phpinfo" => "phpinfo",
"Mail Notifications" => "Mail Notifications",
"Cookies" => "Cookies",
"DSN" => "DSN",
"Username regex matching" => "Username regex matching",
"x" => "x",
"Prio" => "Prio",
"h" => "h",
"CMS" => "CMS",
"Upload" => "Upload",
"cookie" => "cookie",
"Store attachments in:" => "Store attachments in:",
"Dynamic zones" => "Dynamic zones",
"zone" => "zone",
"POP server" => "POP server",
"SMTP server" => "SMTP server",
"wiki-get" => "wiki-get",
"wiki-put" => "wiki-put",
"wiki-append" => "wiki-append",
"Data" => "Data",
"Editions" => "Editions",
"Is column visible when listing tracker items?" => "Is column visible when listing tracker items?",
"Tbl vis" => "Tbl vis",
"Column links to edit/view item?" => "Column links to edit/view item?",
"isMain" => "isMain",
"Tracker items allow comments?" => "Tracker items allow comments?",
"Tracker items allow attachments?" => "Tracker items allow attachments?",
"bcc" => "bcc",
"Review" => "Review",
"Spellcheck" => "Spellcheck",
"RSS" => "RSS",
"+" => "+",
"August" => "August",
"September" => "September",
"November" => "November",
"December" => "December",
"import" => "import",
"editor" => "editor",
"relate" => "relate",
"Directory ranking" => "Directory ranking",
"Style Sheet" => "Style Sheet",
"prevents referencing" => "prevents referencing",
"Shortname" => "Shortname",
"Longname" => "Longname",
"Translate recorded" => "Translate recorded",
"reset table" => "reset table",
"Store quiz results" => "Store quiz results",
"status" => "status",
"summary" => "summary",
"To" => "To",
"Previously remove existing page versions" => "Previously remove existing page versions",
"excerpt" => "excerpt",
"LastChanges" => "LastChanges",
"Img" => "Img",
"Program" => "Program",
"Open client window" => "Open client window",
"Transcripts" => "Transcripts",
"transcripts" => "transcripts",
"Open a support ticket instead" => "Open a support ticket instead",
"Live support:Console" => "Live support:Console",
"Join" => "Join",
"Support chat transcripts" => "Support chat transcripts",
"started" => "started",
"Transcript" => "Transcript",
"Calendar Interval in daily view" => "Calendar Interval in daily view",
"Start hour for days" => "Start hour for days",
"quota" => "quota",
"Discuss" => "Discuss",
"reset" => "reset",
"random" => "random",
"taken" => "taken",
"Top 10" => "Top 10",
"Top 20" => "Top 20",
"Top 50" => "Top 50",
"Top 100" => "Top 100",
"Searched" => "Searched",
"Prepare a newsletter to be sent" => "Prepare a newsletter to be sent",
"Your email was sent" => "Your email was sent",
"Finally if the user didn't select a theme the default theme is used" => "Finally if the user didn't select a theme the default theme is used",
"Thumbnail (optional, overrides automatic thumbnail generation)" => "Thumbnail (optional, overrides automatic thumbnail generation)",
"#" => "#",
"top" => "top",
"Percentage completed" => "Percentage completed",
"May need to refresh twice to see changes" => "May need to refresh twice to see changes",
"Monitor" => "Monitor",
"Cc" => "Cc",
"CC" => "CC",
"BCC" => "BCC",
"TOP" => "TOP",
"event without name" => "event without name",
"Shortname must be 2 Characters" => "Shortname must be 2 Characters",
"You must provide a longname" => "You must provide a longname",
"created from import" => "created from import",
"You must be logged in to subscribe to newsletters" => "You must be logged in to subscribe to newsletters",
"created from notepad" => "created from notepad",
"to the registered email address for" => "to the registered email address for",
// ###
// ### end of possibly untranslated words
// ###

"This feature is disabled" => "Táto funkcia je vypnutá",
"Permission denied. You cannot view pages" => "Nemáte dostatočné oprávnenia na prezeranie stránok",
"The copyright management feature is not enabled." => "Copyright management funkcia nieje zapnutá",
"No page indicated" => "Žiadna stránka nebola nájdená",
"You must supply all the information, including title and year." => "Musíte zadať všetky údaje, včetne nadpisu a roku",
"You do not have permission to use this feature" => "Nemáte dostatočné oprávnenia.",
"Type" => "Typ",
"Name" => "Názov",
"Description" => "Popis",
"Size" => "Velkosť",
"Created" => "Vytvorené",
"Last Modified" => "Posledné zmeny",
"Creator" => "Vytvoril",
"Author" => "Autor",
"Comment" => "Komentár",
"Files" => "Súbory",
"Hits" => "Prístupy",
"Locked by" => "Uzamkol(a)",
"Path" => "Cesta",
"None" => "Žiadny",
"Permission denied" => "Nemáte dostatočné oprávnenia",
"The file is not a CSV file or has not a correct syntax" => "Súbor nieje CSV súborom, alebo nemá správnu syntax",
"locked" => "uzamknuté",
"locked by" => "uzamkol(a)",
"in" => "v",
"continued" => "pokračuje",
"New Image Uploaded by" => "Nový obrázok nahral(a)",
"New Subscriptions" => "Nové prihlásenia k&#160;odberu",
"New Item in Tracker" => "Nová položka v trackeri",
"by" => "&ndash;",
"Image Gallery" => "Galéria obrázkov",
"Articles" => "Články",
"Blogs" => "Blogy",
"Forums" => "Fóra",
"Directory" => "Katalóg odkazov",
"File Gallery" => "Kolekcia súborov",
"FAQs" => "Časté otázky",
"Quizzes" => "Kvízy",
"Survey" => "Prieskum",
"article" => "článok",
"directory" => "katalóg odkazov",
"faq" => "časté otázky",
"forum" => "fórum",
"poll" => "anketa",
"quiz" => "kvíz",
"image" => "obrázok",
"calendar" => "kalendár",
"Invalid filename (using filters for filenames)" => "Invalid filename (using filters na filenames)",
"Cannot upload this file - maximum upload size exceeded" => "Nie je možné uploadnuť tento súbor, je príliž veľký",
"Anonymous" => "Anonymní",
"Wrong password. Cannot post comment" => "Nesprávne heslo. Nemôžem zapísať komentár",
"You have to enter a title and text" => "Musíte zadať nadpis a text",
"Find" => "Nájsť",
"find" => "vyhľadať",
"prev" => "predošlý",
"Page" => "Stránka",
"next" => "další",
"Page name" => "Názov stránky",
"File Galleries" => "Kolekcie súborov",
"Wiki Home" => "Úvodná stránka Wiki",
"Home" => "Úvod",
"previous page" => "predošlá stránka",
"next page" => "daľšia stránka",
"By:" => "Od:",
"Read" => "Čítať",
"List articles" => "Vypísať články",
"Last post" => "Posledný záznam",
"Invalid imagename (using filters for filenames)" => "Invalid imagename (using filters na filenames)",
"Errors detected" => "Detekované chyby",
"Upload was not successful" => "Prenos nebol úspešne dokončený",
"No image yet, sorry." => "Žiadny obrázok, sorry",
"NONE" => "žiadny",
"Language" => "Jazyk (Language)",
"Section" => "Sekcia",
"Theme" => "Vzhľad",
"Rows" => "Riadky",
"Title" => "Názov",
"Topic" => "Téma",
"Reads" => "Návštev",
"Images" => "Obrázky",
"Points" => "Body",
"Authentication method" => "Metóda autentifikácie",
"Web Server" => "Webserver",
"Creation date (desc)" => "Dátum vzniku (zost.)",
"Last modification date (desc)" => "Posledná zmena (zost.)",
"Blog title (asc)" => "Názov blogu (vzost.)",
"Number of posts (desc)" => "Počet príspevkov (zost.)",
"Visits (desc)" => "Návštevy (zost.)",
"Activity (desc)" => "Aktivity (zost.)",
"Disabled" => "Vypnuté",
"Plain text" => "Obyčajný text",
"Link to user information" => "Odkaz na informácie o&nbsp;užívateľovi",
"User avatar" => "Avatar užívateľa",
"Contact user" => "Kontaktovať užívateľa",
"Count admin pageviews" => "Započítavať stránky pozerané administrátorom",
"Validate URLs" => "Overiť platnosť URL",
"Links per page" => "Odkazov na stránku",
"Method to open directory links" => "Metóda pre otváranie odkazov z katalogu",
"replace current window" => "prepísať súčasné okno",
"new window" => "nové okno",
"inline frame" => "vložený rámik",
"Default number of comments per page" => "Počet komentárov na stránku",
"Comments default ordering" => "Zoradenie komentárov",
"Polls" => "Ankety",
"Newsletters" => "Novinky e-mailom",
"Calendar" => "Kalendár",
"Banners" => "Bannery",
"Category" => "Kategória",
"Score" => "Skóre",
"Search" => "Vyhľadávanie",
"FAQ" => "Časté otázky",
"Surveys" => "Prieskumy",
"Featured links" => "Odporúčame",
"Live support system" => "Systém live podpory",
"Contact Us" => "Kontaktujte nás",
"Banning system" => "Systém zamezenia prístupu",
"Stats" => "Štatistiky",
"Referer Stats" => "Štatistiky prístupov",
"Communications (send/receive objects)" => "Komunikácia (poslať/prijať objekt)",
"Custom Home" => "Upravená úvodná stránka",
"Mini Calendar" => "Mini kalendár",
"User Preferences Screen" => "Obrazovka preferencií užívateľa",
"User Notepad" => "Poznámkový blok užívateľa",
"User Bookmarks" => "Záložky užívateľa",
"User Watches" => "Sledované užívateľom",
"User Menu" => "Užívateľské menu",
"User Tasks" => "Úlohy užívateľa",
"User Messages" => "Užívateľské správy",
"User Files" => "Užívateľské súbory",
"Debugger Console" => "Konzola debuggera",
"Smileys" => "Smajlíci",
"Dynamic Content System" => "Systém dynamického obsahu",
"Display menus as folders" => "Zobraziť menu ako zložky",
"Activate" => "Aktivovať",
"Comments" => "Komentáre",
"Submissions" => "Užívateľské príspevky",
"Rankings" => "Hodnotenia",
"Content templates" => "Obsahové šablóny",
"Print" => "Tlač",
"Local" => "Lokálne",
"List pages" => "Vypísať zoznam stránok",
"Last changes" => "Posledné úpravy",
"Orphan pages" => "Samostatné stránky",
"Search stats" => "Štatistiky vyhľadávania",
"Visits" => "Návštevy",
"Accept wiki syntax" => "Akceptovať wiki syntax",
"Mb" => "MB",
"Title (desc)" => "Názov (zost.)",
"Title (asc)" => "Názov (vzost.)",
"Topics" => "Témy",
"Posts" => "Záznamy",
"Posts per day" => "Záznamov denne",
"Creation Date (desc)" => "Dátum vzniku (zost.)",
"Topics (desc)" => "Témy (zost.)",
"Threads (desc)" => "Vlákna (zost.)",
"Last post (desc)" => "Posledný záznam (zost.)",
"Name (desc)" => "Názov (zost.)",
"Name (asc)" => "Názov (vzost.)",
"Browser title" => "Titulok okna prehliadača",
"Home page" => "Úvodná stránka",
"Temporary directory" => "Dočasná zložka",
"Open external links in new window" => "Otvárať externé odkazy v novom okne",
"Display modules to all groups always" => "Vždy zobrazovať moduly pre všetky skupiny",
"Content" => "Obsah",
"Use database for translation" => "Použiť databázu pre preklady",
"Record untranslated strings" => "Zaznamenávať nepreložené",
"Normal" => "Normál",
"Refresh rate" => "Frekvencia obnovovania",
"Database" => "Databáza",
"Publish" => "Publikovať",
"Allow viewing HTML mails?" => "Povoliť zobrazenie HTML správ?",
"Maximum size for each attachment" => "Maximálna veľkosť attachmentu",
"Complete" => "Hotovo",
"no cache" => "nepoužívať cache",
"minute" => "minúta",
"minutes" => "minúty",
"hour" => "hodina",
"hours" => "hodiny",
"Wiki top pages" => "Wiki top stránky",
"Most relevant pages" => "Najrelevantnejšie stránky",
"Relevance" => "Relevancia",
"Wiki last pages" => "Wiki posledné stránky",
"Modified" => "Modifikované",
"Topic date" => "Dátum témy",
"Forums most read topics" => "Fóra: najčítanejšie témy",
"Forums best topics" => "Fóra: top témy",
"Forums most visited forums" => "Fóra: najnavštevovanejšie fóra",
"Forums with most posts" => "Fóra s najväčším počtom príspevkov",
"Wiki top galleries" => "Wiki top galérie",
"Wiki top file galleries" => "Wiki top súborové kolekcie",
"Wiki top images" => "Wiki top obrázky",
"Wiki top files" => "Wiki top súbory",
"Downloads" => "Downloady",
"Wiki last images" => "Wiki posledné obrázky",
"Upload date" => "Upload dátum",
"Wiki last files" => "Wiki posledné súbory",
"Wiki top articles" => "Wiki top články",
"Most visited blogs" => "Najnavštevovanejšie blogy",
"Most active blogs" => "Najživšie blogy",
"Activity" => "Aktivita",
"Blogs last posts" => "Posledné záznamy v blogoch",
"Post date" => "Dátum",
"Wiki top authors" => "Wiki top autori",
"Pages" => "Stránky",
"Top article authors" => "Najaktívnejší autori článkov",
"User already exists" => "Tento užívateľ už existuje",
"Wrong registration code" => "Nesprávny registračný kód",
"Invalid username" => "Neplatné užívateľské meno",
"Username is too long" => "Užívateľské meno je príliš dlhé",
"Username cannot contain whitespace" => "Uživatelské méno nesmie obsahovať mezery",
"Wrong passcode. You need to know the passcode to register at this site" => "Nesprávny tajný kód. Aby ste sa mohli prihlásiť, musíte poznať tajný kód",
"Invalid email address. You must enter a valid email address" => "Problém s emailovou adresou. Musíte zadať platnú emailovú adresu",
"change" => "zmeniť",
"Today" => "Dnes",
"from" => "od",
"Login" => "Prihlásenie",
"Send message" => "Poslať správu",
"Attach file" => "Priložit súbor",
"Gallery" => "Galéria",
"Image" => "Obrázok",
"Forum" => "Fórum",
"Article" => "Článok",
"Blog post" => "Príspevok blogu",
"Prev" => "Pred",
"Next" => "Nasled.",
"comment" => "komentár",
"Click Here" => "Kliknite sem",
"All" => "Všetko",
"days" => "dní",
"day" => "deň",
"mins" => "minúty",
"secs" => "sek",
"done" => "hotovo",
"for" => "pre",
"Priority" => "Priorita",
"Yes" => "Áno",
"No" => "Nie",
"You are not logged in" => "Nie ste prihlásený(á)",
"Page cannot be found" => "Stránka nebola nájdená",
"Permission denied. You cannot view this section" => "Nemáte dostatočné oprávnenia na prezeranie tejto sekcie",
"You are banned from" => "Máte zamezený prístup do",
"faqs" => "časté otázky",
"quizzes" => "kvízy",
"blogs" => "blogy",
"forums" => "fóra",
"sad" => "smutný",
"cool" => "skvelý",
"mad" => "šialený",
"at" => "&ndash;",
"new" => "nová",
"Heading" => "Hlavička",
"Wiki Help" => "Wiki help",
"Item" => "Položka",
"Subject" => "Subjekt",
"text field" => "textové pole",
"size" => "veľkosť",
"checkbox" => "zaškrtávacie políčko",
"group selector" => "selektor skupiny",
"date and time" => "dátum a čas",
"action" => "akcia",
"category" => "kategória",
"attachment" => "príloha",
"open" => "otvorené",
"closed" => "uzatvorená",
"Message" => "Správa",
"child categories" => "podradené kategórie",
"objects in category" => "objekty v kategórii",
"(AT)" => "(zavináč)",
"(DOT)" => "(bodka)",
"Password should be at least" => "Heslo musí mať aspoň",
"characters long" => "znakov",
"Password must contain both letters and numbers" => "Heslo musí obsahovať čísla aj písmená",
"Country" => "Krajina",
"No subject" => "Žiadny subject",
"Location" => "Lokácia",
"Attachment" => "Príloha",
"File" => "Súbor",
"Show description" => "Zobraziť popis",
"Displays the user Avatar" => "Zobrazí avatar užívateľa",
"username" => "užívateľ",
"Back" => "Späť",
"Backlinks" => "Spätné odkazy",
"Zone" => "Zóna",
"Items" => "Položky",
"Insert theme-styled box on wiki page" => "Vložit rámik na wiki stránku",
"Insert list of items with the current/given category in the wiki page" => "Vložit zoznam objektov pre danú kategóriu do wiki stránky",
"Categories are disabled" => "Kategórie sú vypnuté",
"Objects" => "Objekty",
"Insert the full category path for each category that this wiki page belongs to" => "Vložit plnú cestu na kategóriu pre každú kategóriu do ktorej daná stránka patrí",
"Center" => "Vycentrovať",
"Centers the plugin content in the wiki page" => "Vycentruje obsah pluginu na wiki stránke",
"Chart" => "Graf",
"title" => "titulok",
"Code" => "Kód",
"code" => "kód",
"Dynamic Content" => "Dynamický obsah",
"Insert copyright notices" => "Vložit poznámku o copyright",
"Example" => "Príklad",
"seconds" => "sekundy",
"Clear" => "Vyčistiť",
"term" => "termín",
"definition" => "definícia",
"Desc" => "Popis",
"Upcoming events" => "Nastávajúce udalosti",
"Displays the data using the Tikiwiki odd/even table style" => "Zobrazí dáta v Tikiwiki tabulke zo striedavými podkladmi riadkov",
"description" => "popis",
"Value" => "Hodnota",
"Displays a graphical GAUGE" => "Zobrazí grafický identifikátor (teplomer)",
"type" => "typ",
"Group" => "Skupina",
"groups" => "skupiny",
"HTML code" => "HTML kód",
"name" => "názov",
"Image size" => "Velkosť obrázku",
"Thumbnail" => "Náhľad obrázku",
"Browse" => "Prezerať",
"Include" => "Zahrnúť",
"Start" => "Štart",
"Last Modification" => "Posledná modifikácia",
"List Pages" => "Prehľad stránok",
"Sort" => "Zoradiť",
"or" => "alebo",
"articles" => "články",
"Map" => "Mapa",
"Feature disabled" => "Funkcia je vypnutá",
"Template" => "Šablóna",
"Groups" => "Skupiny",
"Module Name" => "Názov modulu",
"Please choose a module" => "Prosím, vyberte si modul",
"to be used as argument" => "použiť ako argument",
"Displays a module inline in a wiki page" => "Zobrazí obsah modulu v stránke",
"Sorry, no such module" => "Ospravedlňujeme sa, ale žiadny taký modul tu nie je",
"Displays the data using a monospace font" => "Zobrazí dáta neproporčným písmom",
"Sticky" => "Prilepené",
"Object" => "Objekt",
"Days" => "Dni",
"Status" => "Stav",
"picture not found" => "obrázok nenájdený",
"No version indicated" => "Nebola zadaná žiadna verzia",
"Poll" => "Anketa",
"Preferences" => "Preferencie",
"User Information" => "Informace o užívateľovi",
"Close" => "Zatvoriť",
"Date" => "Dátum",
"Action" => "Akcia",
"Sorts the plugin content in the wiki page" => "Zoradí obsah pluginu vo Wiki stránke",
"Order" => "Poradie",
"First" => "Prvá",
"Edit" => "Upraviť",
"Missing db param" => "Chýba db parameter",
"Subscribe" => "Přihlásiť sa k odberu",
"Url" => "URL",
"Id" => "ID",
"Tag Name" => "Názov značky",
"Original" => "Originál",
"Translate" => "Preložiť",
"Email" => "E-mail",
"to" => "do",
"template" => "šablóna",
"Preview" => "Náhľad",
"preview" => "náhľad",
"Error" => "Chyba",
"Filters" => "Filtre",
"Mode" => "Mód",
"Real Name" => "Skutočné meno",
"users" => "užívatelia",
"Versions" => "Verzie",
"Vote" => "Hlasovať",
"ERROR: Either the subject or body must be non-empty" => "CHYBA: Buď subjekt alebo telo správy musia niečo obsahovať",
"Invalid user" => "Neplatný užívateľ",
"Message will be sent to: " => "Správa bude poslaná týmto adresátom: ",
"No more messages" => "žiadne daľšie správy",
"Categories" => "Kategórie",
"Unassign" => "Zrušiť priradenie",
"Assign" => "Priradiť",
"Received objects" => "Prijaté objekty",
"File galleries" => "Kolekcie súborov",
"Topics only" => "Len témy",
"Most commented forums" => "Najkomentovanejšie diskusné fóra",
"Most read topics" => "Najčítanejšie témy",
"Most visited forums" => "Najnavštevovanejšie diskusné fóra",
"Google Search" => "Vyhľadať pomocou Google",
"Last blog posts" => "Posledné záznamy blogu",
"Last Created blogs" => "Najnovšie blogy",
"Last Created FAQs" => "Posledné vytvorené FAQ",
"Last Created Quizzes" => "Posledné vytvorené kvízy",
"Last modified file galleries" => "Posledná upravená kolekcia súborov",
"Last Files" => "Posledné súbory",
"Last Modified blogs" => "Naposledy upravené blogy",
"Last submissions" => "Posledné užív. príspevky",
"Last Items" => "Posledné položky",
"Last Modified Items" => "Posledné modifikované položky",
"Live support" => "Live podpora",
"Messages" => "Správy",
"Waiting Submissions" => "Očakávané uživ. príspevky",
"Old articles" => "Archív článkov",
"Create/Edit" => "Vytvoriť/upraviť",
"Quick Edit a Wiki Page" => "Rýchla úprava Wiki stránky",
"Random Pages" => "Náhodné stránky",
"New user registration" => "Nová registrácia užívateľa",
"Post" => "Odoslať",
"Since your last visit" => "Od Vašej poslednej návštevy",
"new comments" => "nových kometárov",
"wiki pages changed" => "zmenených stránok",
"new images" => "nových obrázkov",
"new files" => "nových súborov",
"new users" => "nových užívateľov",
"Most Active blogs" => "Najaktívnejšie blogy",
"Top articles" => "Top články",
"Top File Galleries" => "Top kolekcie súborov",
"Top Images" => "Top obrázky",
"Top Pages" => "Top stránky",
"Top Quizzes" => "Top kvízy",
"Top Visited FAQs" => "Top navštívené otázky",
"User Blogs" => "Blogy uživateľa",
"My blogs" => "Moje blogy",
"User bookmarks" => "Záložky užívateľa",
"My galleries" => "Moje galérie",
"User Pages" => "Stránky užívateľa",
"My Pages" => "Vlastné stránky",
"User tasks" => "Úlohy",
"Online users" => "Užívatelia on-line",
"Invalid username or password" => "Nesprávne užívateľské meno alebo heslo",
"country" => "krajina",
"theme" => "vzhľad",
"List of attached files" => "Zoznam priložených súborov",
"desc" => "popis",
"uploaded" => "uploadnuté",
"Remove" => "Odstrániť",
"Upload file" => "Nahrať súbor",
"Attach" => "Priložiť",
"Attach a file to this item" => "Priložiť súbor k tejto položke",
"Version" => "Verzia",
"Attachments" => "Prílohy",
"No attachments for this item" => "Žiadne súbory niesú pripojené k tejto položke",
"Fatal error" => "Závažná chyba",
"Created by" => "Vytvoril(a)",
"on" => "v",
"Activity=" => "Aktivita=",
"Actions" => "Akcie",
"Properties" => "Vlastnosti",
"No records found" => "Nebol nájdený žiadny záznam",
"User Level" => "Užívateľ level",
"private message" => "Súkromná správa",
"Send eMail to User" => "Poslať email užívateľovi",
"user online" => "užívateľ online",
"user offline" => "užívateľ offline",
"Approve" => "Schváliť",
"Reject" => "Neprijať",
"Save to notepad" => "Uložiť do poznámkového bloku",
"Monitor this Topic" => "Sledovať tento topic",
"Stop Monitoring this Topic" => "Ukončiť sledovanie tejto témy",
"Moderator actions" => "Moderátorské funkcie",
"reported:" => "nahlásené:",
"queued:" => "zaradené:",
"Move to topic:" => "Presunúť na tému:",
"Delete Selected" => "Zmazať vybrané",
"Unlock" => "Odomknúť",
"Lock" => "Uzamknúť",
"Threshold" => "Prah",
"Set" => "Nastaviť",
"Replies" => "Odpovede",
"Editing comment" => "Upravovánie komentára",
"Post new comment" => "Pridať nový komentár",
"Cancel" => "Zrušit",
"Posting comments" => "Pridávane komentárov",
"Add Comment" => "Pridať komentár",
"1 comment" => "1 komentár",
"Go back" => "Speť",
"Return to home page" => "Späť na úvodnú stránku",
"Copyrights" => "Copyright",
"Year" => "Rok",
"Authors" => "Autori",
"Add" => "Pridať",
"Tiki Debugger Console" => "Tiki debug konzola",
"Current URL" => "Súčasná URL",
"Command" => "Príkaz",
"exec" => "spustiť",
"Type <code>help</code> to get list of available commands" => "Zadajte <code>help</code> pre výpis použiteľných príkazov",
"Page generation debugging log" => "Generovanie stránky: debugging log",
"Features state" => "Stav funkcií",
"Total" => "Celkovo",
"features matched" => "zhodné súčasti",
"Watchlist" => "Zoznam sledovaného",
"duplicate" => "duplikát",
"There are individual permissions set for this file gallery" => "Platia tu individuálne oprávnenia pre túto kolekciu súborov",
"Save" => "Uložiť",
"Use" => "Použiť",
"none" => "žiadny",
"Max description display size" => "Max description display velkosť",
"Perms" => "Práva",
"List" => "Zoznam",
"Name-filename" => "Názov",
"Filename only" => "Iba názov súboru",
"Number of displayed rows" => "Počet zobrazených riadkov",
"in:" => "v:",
"Move Selected Files" => "Presunúť vybraté súbory",
"Move to" => "Presunúť do",
"Filename" => "Názov súboru",
"Hi {\$mail_user} has sent you this link:" => "Dobrý deň, {\$mail_user} Vám zaslal(a) tento odkaz:",
"Blog post:" => "Príspevok blogu:",
"at:" => "&ndash;",
"Somebody or you tried to subscribe this email address at our site:" => "Vy, alebo niekdo iný, sa pokúsil u nás prihlásiť s touto e-mailovou adresou:",
"To the newsletter:" => "Pre odber newsletteru:",
"Description:" => "Popis:",
"In order to confirm your subscription you must access the following URL:" => "Pre potvrdenie kliknite prosím na nasledujúcu linku:",
"User:" => "Užívateľ:",
"A new message was posted to forum" => "Do fóra bola poslaná nová správa",
"Tiki mail-in instructions" => "Tiki mail-in inštrukcie",
"Hi," => "Dobrý deň,",
"A new message was posted to you at {\$mail_machine}" => "Bola Vám poslaná nová správa z {\$mail_machine}",
"From" => "Od",
"Hi" => "Ahoj",
"Enjoy the site!" => "Prajeme vám prijemne chvile stravene na nasom webe!",
"The user" => "Užívateľ",
"Bye bye!" => "Dovidenia!",
"Welcome to our newsletter!" => "Vítejte k odberu nášho newsletteru!",
"You can always cancel your subscription using:" => "Kedykoľvek môžete zrušiť Vaše prihlásenie pomocou tohoto odkazu:",
"Email notification" => "Tiki email upozornenia",
"A new article was submitted by {\$mail_user} to {\$mail_site} at {\$mail_date|tiki_short_datetime}" => "Nový článok od {\$mail_user} bol odoslaný na {\$mail_site} v {\$mail_date|tiki_short_datetime}",
"You can edit the submission following this link:" => "Prihlásenie môžete upraviť nasledovaním tohoto odkazu:",
"Title:" => "Názov:",
"Heading:" => "Hlavička:",
"Body:" => "Telo:",
"You or someone registered this email address at" => "vy alebo niekto iny zaregistroval tuto email adresu na",
"If you want to be a registered user in this site you will have to use the following link to login for the first time:" => "Ak sa chcete stat registrovanym uzivatelom tohto webu, pouzite nasledujuci odkaz pre prve prihlasenie:",
"Your registration confirmation" => "Your Tiki information registration",
"You will receive an email with information to login for the first time into this site" => "You will receive an email s information to login for the first time into this site",
"If you don't want to receive these notifications follow this link:" => "Ak nechcete dostávať tieto upozornenia, nasledujte túto linku:",
"View the blog at:" => "Zobraziť blog v:",
"changed" => "zmenené",
"created" => "vytvorené",
"File Description" => "Popis súboru",
"The page {\$mail_page} was changed by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "Stránka {\$mail_page} bola zmenená. Zmenu previedol(a) {\$mail_user} v {\$mail_date|tiki_short_datetime}",
"Comment:" => "Komentár:",
"New name" => "Nový názov",
"Last modification date" => "Dátum poslednej úpravy",
"History" => "História",
"of" => "",
"Compare" => "Porovnať",
"Current" => "Súčasná",
"Versions are identical" => "Verzie sú identické",
"User" => "Užívateľ",
"Ip" => "IP",
"Diff" => "Rozdiely",
"Unread" => "Neprečítané",
"Flagged" => "Označené",
"Unflagged" => "Odznačené",
"Containing" => "Obsahujúce",
"Sender" => "odosielateľ",
"No messages to display" => "Žiadne zobraziteľné správy",
"Broadcast message" => "Poslať správu všetkým",
"All users" => "Všetci užívatelia",
"High" => "Vysoká",
"Very High" => "Veľmi vysoká",
"Send" => "Odoslať",
"Compose message" => "Napísať správu",
"Invalid" => "Neplatný",
"Mark as read" => "Označiť ako prečítané",
"Mark as unread" => "Označiť ako neprečítané",
"Mark as flagged" => "Označiť vlajočkou",
"Mark as unflagged" => "Odstrániť vlajočku",
"Mark" => "označiť",
"Compose" => "Napísať",
"Broadcast" => "Poslať všetkým",
"Read message" => "Čítať správu",
"Flag this message" => "Označiť túto správu",
"From:" => "Od:",
"Up" => "Nahor",
"Down" => "Nadol",
"Admin Modules" => "Administrácia modulov",
"Modules" => "Moduly",
"Admin Menus" => "Administrácia menu",
"Menus" => "Menu",
"Register" => "Registrácia",
"Open operator console" => "Otvor operátorskú konzolu",
"Logout" => "Odhlásiť",
"eMail" => "Email",
"Password" => "Heslo",
"Remember me" => "Zapamätaj si ma",
"week" => "týždňa",
"month" => "mesiace",
"I forgot my password" => "Zabudol som heslo",
"Secure" => "Bezpečný",
"Stay in ssl Mode" => "Zostať v ssl móde",
"You have" => "Máte",
"new messages" => "nových správ",
"new message" => "novú správu",
"You have 0 new messages" => "Máte 0 nových správ",
"We have" => "Máme",
"submissions waiting to be examined" => "príspevky čakajúce na kontrolu",
"Image Galleries" => "Galérie obrázkov",
"Entire Site" => "Celý web",
"Wiki Pages" => "Wiki stránky",
"Image Gals" => "Galérie obrázkov",
"Blog Posts" => "Záznamy blogu",
"Search Wiki PageName" => "Vyhľadať Wiki PageName",
"Read More" => "Čítajte viac",
"Since your last visit on" => "Od poslednej návštevy",
"New Images" => "Nových obrázkov",
"Wiki Pages Changed" => "Zmenených stránok",
"New Files" => "Nových súborov",
"New Comments" => "Nových kometárov",
"New Users" => "Nových užívateľov",
"click to edit" => "kliknite pre editáciu",
"Top galleries" => "Top galérie",
"view" => "zobraziť",
"Bookmarks" => "Záložky",
"Done" => "hotovo",
"Refresh" => "Obnoviť",
"online users" => "on-line užívateľov",
"online user" => "užívateľ on-line",
"Send a message to" => "Poslať správu pre",
"vote" => "hlasovať",
"Warning" => "Upozornenie",
"Users" => "Užívatelia",
"Edit blog" => "Upraviť blog",
"Monitor this Blog" => "Sledovať tento blog",
"Stop Monitoring this Blog" => "Ukončiť sledovanie tohoto blogu",
"Find:" => "Nájsť:",
"pages" => "stránky",
"To edit the copyright notices" => "Pre úpravu copyright poznámok",
"The content on this page is licensed under the terms of the" => "Obsah tejto stránky je licencovaný podľa podmienok",
"comments" => "&times; komentované",
"First page" => "Prvá stránka",
"Previous page" => "Predošlá stránka",
"page" => "stránka",
"Next page" => "Nasledujúca stránka",
"Last page" => "Posledná stránka",
"View Comments" => "Zobraziť komentáre",
"Blog name" => "Názov blogu",
"Tools Calendars" => "Nástroje kalendára",
"Check / Uncheck All" => "Zaškrtnúť všetko / zrušiť zaškrtnutie všetkého",
"Cancel Edit" => "Zrušit editáciu",
"Change preferences" => "Zmeniť preferencie",
"General" => "Všeobecné",
"Features" => "Možnosti a funkcie",
"Module" => "Modul",
"User files" => "Súbory užívateľa",
"General Settings" => "Všeobecné nastavenia",
"Home Blog (main blog)" => "Úvodný blog (hlavný blog)",
"Week" => "Týždeň",
"Month" => "Mesiac",
"Saturday" => "Sobota",
"Sunday" => "Nedeľa",
"Monday" => "Pondelok",
"5 minutes" => "5 minút",
"Permissions" => "Práva",
"Import CSV file" => "Importovat CSV súbor",
"Batch upload (CSV file)" => "Hromadný prenos (CSV súbor)",
"Last login" => "Posledné prihlásenie",
"Number of visited pages to remember" => "Počet navštívených stránok na&nbsp;zapamätanie",
"Displayed time zone" => "Zobrazené časové pásmo",
"User information" => "Informácie o užívateľovi",
"Private" => "Súkromné",
"public" => "verejné",
"Tasks per page" => "Úloh na stránku",
"Messages per page" => "Správ na stránku",
"Allow messages from other users" => "Povoliť správy od ostatných užívateľov",
"Send me an email for messages with priority equal or greater than" => "Poslať mi e-mailom upozornenie na správy s prioritou rovnakou alebo väčšou než",
"My Tiki" => "Moje Tiki",
"My pages" => "Moje stránky",
"My messages" => "Moje správy",
"My tasks" => "Moje úlohy",
"My items" => "Moje položky",
"Settings" => "Nastavenia",
"Watches" => "Sledovanie",
"Home Gallery (main gallery)" => "Úvodná galéria (hlavná galéria)",
"Home Forum (main forum)" => "Úvodné fórum (hlavné fórum)",
"Searches" => "Vyhľadávania",
"Galleries features" => "Možnosti galerií",
"Use database to store images" => "Použiť databázu pre ukladanie obrázkov",
"Use a directory to store images" => "Použiť adresár pre ukladánie obrázkov",
"Library to use for processing images" => "Knižnica použitá pre spracovanie obrázkov",
"Max Rows per page" => "Max. riadkov na stránku",
"Images per row" => "Obrázkov na riadok",
"Thumbnails size X" => "Náhľad obrázku rozmer X",
"Thumbnails size Y" => "Náhľad obrázku rozmer Y",
"Set features" => "Nastaviť možnosti",
"Remove images in the system gallery not being used in Wiki pages, articles or blog posts" => "Odstrániť obrázky v systémovej galérii, ktoré nie su použité vo Wiki stránkach, článkoch alebo blogoch",
"All galleries" => "Všetky kolekce",
"System Gallery" => "Systémová galéria",
"Gallery listing configuration" => "Konfigurácia výpisu",
"Parent" => "Rodič",
"Last modified" => "Posledné úpravy",
"Image galleries comments settings" => "Galérie obrázkov: nastavenie komentárov",
"General Preferences" => "Všeobecné preferencie",
"Username" => "Užívateľ",
"Home Page" => "Úvodná stránka",
"Custom home" => "Moja úvodná stránka",
"Date and Time Formats" => "Formát datumu a času",
"Date and Time Format Help" => "Help ohľadom formátu dátumu a času",
"Change admin password" => "Zmeniť heslo administrátora",
"Change password" => "Zmena hesla",
"click here" => "kliknite sem",
"Tiki and HTTP Auth" => "Tiki a HTTP autentifikácia",
"Users can register" => "Užívatelia sa môžu registrovat",
"Use challenge/response authentication" => "Použiť challenge/response autentifikáciu",
"Allow secure (https) login" => "Umožniť bezpečné (https) prihlásenie",
"Require secure (https) login" => "Require secure (https) přihlášení",
"Duration:" => "Trvanie:",
"Users can change theme" => "Reg. užívatelia môžu meniť výzor",
"Edit CSS" => "Upraviť CSS",
"Theme Control" => "Ovládanie vzhľadu",
"Edit Templates" => "Upraviť šablóny",
"General Layout options" => "Všeobecné možnosti layoutu",
"logged as" => "prihlásený ako",
"Left column" => "Ľavý stĺpec",
"Right column" => "Pravý stĺpec",
"Bottom bar" => "Spodný pruh",
"Maximum number of records in listings" => "Maximum záznamov v zoznamoch",
"Use direct pagination links" => "Použiť direct pagination links",
"Layout per section" => "Layout podle sekce",
"Admin layout per section" => "Správa vzhľadu podľa sekcie",
"Last update" => "Naposledy obnovený",
"Image galleries" => "Obrázky",
"Feed for forums" => "Základ pre diskusné fóra",
"Automonospaced text" => "Automatický text s pevnou šírkou znakov",
"Tables syntax" => "Syntax tabuliek",
"|| for rows" => "|| pre riadky",
"Hotwords" => "Kľúčové slová",
"rows" => "riadkov",
"Required" => "Požadované",
"Parameters" => "Parametre",
"Use database to store files" => "Použiť databázu pre ukladanie súborov",
"Use a directory to store files" => "Použiť adresár pre ukladánie súborov",
"dls" => "stiahnutí",
"Quota (Mb)" => "Kvóta (MB)",
"Use database to store userfiles" => "Použiť databázu pre ukladanie užívateľských súborov",
"Use a directory to store userfiles" => "Použiť adresár pre ukládanie užívateľských súborov",
"Create New" => "Vytvoriť nový",
"Footnotes" => "Poznámky pod čiarou (footnotes)",
"Permission" => "Práva",
"Allow HTML" => "Povoliť HTML",
"Sandbox" => "Pieskovisko",
"Dumps" => "Výpisy do súboru",
"Remove a tag" => "Odstrániť značku",
"Generate dump" => "Vytvoriť dump",
"Download last dump" => "Stiahnuť posledný dump",
"Pictures" => "Obrázky",
"Remove unused pictures" => "Odstrániť nepoužívané obrázky",
"Export Wiki Pages" => "Export Wiki stránky",
"Discuss pages on forums" => "Diskutovať o stránkach v diskusných fórach",
"Structures" => "Štruktúry",
"Page creators are admin of their pages" => "Tvorcovia stránok sú zároveň administrátori svojich stránok",
"Links" => "Odkazy",
"Wiki attachments" => "Wiki prílohy",
"Live Support" => "Live podpora",
"Contact us" => "Kontakty",
"Banning" => "Zamezenie prístupu",
"Content Templates" => "Obsahové šablóny",
"bytes" => "bajtov",
"Statistics" => "Štatistiky",
"Weeks" => "Týždne",
"viewed" => "zobrazených",
"Add or edit a rule" => "Pridať alebo upraviť pravidlo",
"Rule title" => "Nadpis pravidla",
"IP regex matching" => "IP zodpovedajúce regulárnemu výrazu",
"Banned from sections" => "Zamedzený prístup do sekcií",
"Rule activated by dates" => "Pravidlo aktivované dátumami",
"Rule active from" => "Pravidlo aktívne od",
"Rule active until" => "Pravidlo aktivované do",
"Custom message to the user" => "Užívateľsky upravená správa užívateľovi",
"Rules" => "Pravidlá",
"User/IP" => "Užívateľ/IP",
"Sections" => "Sekcie",
"Admin Calendars" => "Administrácia kalendárov",
"List of Calendars" => "Zoznam kalendárov",
"Loc" => "Lok",
"Participants" => "Účastníci",
"Cat" => "Kat",
"Lang" => "Jazyk",
"Custom Locations" => "Užívateľsky upravené odkazy",
"Custom Categories" => "Užívateľsky upravené kategórie",
"Custom Languages" => "Užívateľsky upravené jazyky",
"Custom Priorities" => "Užívateľsky upravené priority",
"Current category" => "Súčasná Kategória",
"Edit this category:" => "Upraviť túto kategóriu:",
"Add new category" => "Pridať novú kategóriu",
"Objects in category" => "Objekty v kategórii",
"Add objects to category" => "Pridať objekty do kategórie",
"Admin templates" => "Administrácia šablón",
"Edit this template:" => "Upraviť túto šablonu:",
"Create new template" => "Vytvoriť novú šablónu",
"Use wysiwyg editor" => "Použiť wysiwyg editor",
"Use normal editor" => "Použiť bežný editor",
"HTML Pages" => "HTML stránky",
"Templates" => "Šablóny",
"Admin cookies" => "Administrácia cookies",
"Create/edit cookies" => "Vytvoriť/upraviť cookies",
"Upload Cookies from textfile" => "Nahrať cookies z textového súboru",
"Upload from disk:" => "Nahrať z disku:",
"Remove all cookies" => "Odstrániť všetky cookies",
"Admin dsn" => "Administrácia dsn",
"Create/edit dsn" => "Vytvoriť/upraviť dsn",
"Admin external wikis" => "Administrácia externých wiki",
"URL (use \$page to be replaced by the page name in the URL example: http://www.example.com/tiki-index.php?page=\$page)" => "URL (použite \$page pre výmenu za názov stránky v URL; napr.: http://www.example.com/tiki-index.php?page=\$page)",
"ExtWiki" => "Extwiki",
"Admin Forums" => "Administrácia fór",
"List forums" => "Vypísať diskusné fóra",
"Coms" => "Kom.",
"Age" => "Vek",
"PPD" => "Ppd",
"Edit this Forum:" => "Upraviť toto fórum:",
"Create New Forum" => "Vytvoriť nové fórum",
"There are individual permissions set for this forum" => "Platia tu individuálne oprávnenia pre toto fórum",
"Create new" => "Vytvoriť nový",
"Password protected" => "Ochránené heslom",
"Forum password" => "Fórum: heslo",
"Topic list configuration" => "Konfigurácia zoznamu tém",
"Add messages from this email to the forum" => "Pridať správy z tohoto e-mailu do diskusného fóra",
"Use topic smileys" => "Používať smajlíky v témach",
"Show topic summary" => "Zobraziť zhrnutie témy",
"User information display" => "Obrazovka informácií o užívateľovi",
"Online" => "On-line",
"Approval type" => "Typ schválenia",
"Admin Hotwords" => "Administrácia kľúčových slov",
"Add Hotword" => "Pridať kľúčové slovo",
"Word" => "Slovo",
"Admin HTML pages" => "Administrácia HTML stránok",
"Edit this page" => "Upraviť túto stránku",
"View page" => "Zobraziť stránku",
"Edit zone" => "Upraviť zónu",
"content" => "obsah",
"Mass update" => "Masový update",
"Create new HTML page" => "Vytvoriť novú HTML stránku",
"Edit this HTML page:" => "Upraviť túto HTML stránku:",
"Apply template" => "Aplikovať šablónu",
"Dynamic" => "Dynamické",
"Static" => "Statické",
"Last Modif" => "Posledná úprava",
"Admin layout" => "Administrácia vzhľadu",
"Theme control" => "Ovládanie vzhľadu",
"layout options" => "možnosti layoutu",
"Top bar" => "Horný pruh",
"Generate positions by hits" => "Generovať pozície podľa prístupov",
"List of featured links" => "Zoznam odporúčaných odkazov",
"Position" => "Pozícia",
"Add Featured Link" => "Pridať odporúčaný odkaz",
"Edit this Featured Link:" => "Upraviť tento odporučený odkaz:",
"Create new Featured Link" => "Vytvoriť nový odporúčaný odkaz:",
"disables the link" => "deaktivuje odkaz",
"Link type" => "Typ odkazu",
"replace current page" => "zameniť súčasnú stránku",
"framed" => "v rámci",
"open new window" => "otvoriť v novom okně",
"Account name" => "Názov účtu",
"SMTP requires authentication" => "SMTP vyžaduje autentifikáciu",
"Admin Topics" => "Administrácia tém",
"Active" => "Aktívne",
"Frequency" => "Frekvencia",
"List menus" => "Vypísať zoznam menu",
"Edit this menu" => "Upraviť toto menu",
"Edit menu options" => "Upraviť možnosti menu",
"Some useful URLs" => "Pár užitočných odkazov",
"option" => "možnost",
"Home Blog" => "Úvodný blog",
"Home Image Gal" => "Úvodná obr. galéria",
"Home Image Gallery" => "Úvodná galéria obrázkov",
"Home File Gal" => "Úvodná kolekcia súborov",
"Home File Gallery" => "Úvodná kolekcia súborov",
"User preferences" => "Užívateľské nastavenia",
"User prefs" => "Pref. užívateľa",
"List galleries" => "Vypísať galérie",
"List image galleries" => "Vypśať galérie obrázkov",
"Upload image" => "Nahrať obrázok",
"Gallery Rankings" => "Rebríčky",
"Browse a gallery" => "Prezerať galériu",
"Articles home" => "Úvodná stránka článkov",
"All articles" => "Všetky články",
"Submit" => "Odoslať",
"List Blogs" => "Vypísať blogy",
"Create blog" => "Vytvoriť blog",
"View a forum" => "Zobraziť fórum",
"View a thread" => "Zobraziť vlákno",
"View a FAQ" => "Zobraziť časté otázky",
"Take a quiz" => "Vylúštite si kvíz",
"Quiz stats" => "Štatistiky kvízu",
"Stats for a Quiz" => "Štatistiky pre kvíz",
"Preview menu" => "Náhľad menu",
"Menu options" => "Možnosti menu",
"Options" => "Možnosti",
"Edit this Menu:" => "Upraviť toto menu:",
"Create new Menu" => "Vytvoriť nové menu",
"dynamic collapsed" => "dynamické zbalené",
"dynamic extended" => "dynamické rozbalené",
"fixed" => "fixný",
"Clear Cache" => "Vyčistiť cache",
"Assigned Modules" => "Priradené moduly",
"Left Modules" => "Moduly vľavo",
"Move to Right Column" => "Presunúť do pravého stĺpca",
"Right Modules" => "Moduly vpravo",
"Move to Left Column" => "Presunúť do ľavého stĺpca",
"Assign new module" => "Priradiť nový modul",
"Edit this assigned module:" => "Upraviť tento priradený modul:",
"Cache Time" => "Čas cache",
"User Modules" => "Užívateľské moduly",
"Create new user module" => "Vytvoriť nový uživatelský modul",
"Edit this user module:" => "Upraviť tento užívateľský modul:",
"Objects that can be included" => "Objekty, ktoré môžu byť pridané",
"Use Poll" => "Použiť anketu",
"Use Gallery" => "Použiť galériu",
"Use Dynamic Content" => "Použiť dynamický obsah",
"Use RSS Module" => "Použiť RSS modul",
"Use Menu" => "Použiť menu",
"Use Banner Zone" => "Použiť banner zone",
"Admin newsletter subscriptions" => "Administrácia prihlásení k odberu newsletterov",
"List Newsletters" => "Vypísať newslettery",
"Admin Newsletters" => "Administrácia newsletterov",
"Send Newsletters" => "Poslať Newsletters",
"Add a subscription newsletters" => "pridať prihlásenie k odberu newsletteru",
"Email:" => "E-mail:",
"Subscriptions" => "Přihlásenie k odberu",
"Valid" => "Platný",
"Subscribed" => "subscribed",
"Admin newsletters" => "Administrácia newsletterov",
"Last Sent" => "Posledný poslaný",
"Create/Edit Newsletters" => "Vytvoriť/upraviť newslettery",
"There are individual permissions set for this newsletter" => "Platia tu individuálne oprávnenia pre tento newsletter",
"Add notification" => "Pridať upozorňovanie",
"Event" => "Udalosť",
"edit" => "upraviť",
"remove" => "odstrániť",
"Update" => "Aktualizovať",
"List polls" => "Vypísať ankety",
"Edit this poll" => "Upraviť túto anketu",
"Preview poll" => "Náhľad ankety",
"Poll options" => "Nastavenia pre ankety",
"Votes" => "Hlasy",
"Admin Polls" => "Administrácia ankiet",
"Set last poll as current" => "Nastaviť poslednú anketu ako aktuálnu",
"Close all polls but last" => "Zavrieť všetky polls okrem posledného",
"Activate all polls" => "Aktivovať všetky ankety",
"active" => "aktívny",
"current" => "súčasná",
"object" => "objekt",
"PublishDate" => "Zverejnené",
"Results" => "Výsledky",
"Content for the feed" => "Obsah pre zdroj",
"user" => "užívateľ",
"group" => "skupina",
"sticky" => "prilepené",
"Destroy the structure leaving the wiki pages" => "Vymaž štruktúru ale stránky nechaj",
"Destroy the structure and remove the pages" => "Vymaž štruktúru spolu zo stránkami",
"Export Pages" => "Export stránky",
"Dump Tree" => "Vypísať strom do súboru",
"Create new structure" => "Vytvoriť novú štruktúru",
"Tree" => "Strom",
"Use single spaces to indent structure levels" => "Použiť medzery na vnorenie úrovní štruktúr",
"List surveys" => "Vypísať prieskumy",
"Survey Stats" => "Survey stats",
"Edit this Survey" => "Upraviť tento prieskum",
"Admin Surveys" => "Administrácia prieskumov",
"Question" => "Otázka",
"One choice" => "Jedna voľba",
"Multiple choices" => "Viacero volieb",
"Short text" => "Krátky text",
"Rate (1..5)" => "Ohodnoť (1..5)",
"Rate (1..10)" => "Ohodnoť (1..10)",
"Options (if apply)" => "Možnosti (ak aplikovatľné)",
"Questions" => "Otázky",
"Admin surveys" => "Administrácia prieskumov",
"List Surveys" => "Vypísať prieskumy",
"Edit this Survey:" => "Upraviť tento prieskum:",
"There are individual permissions set for this survey" => "Platia tu individuálne oprávnenia pre tento prieskum",
"Open" => "Otvorené",
"Create a new topic" => "Vytvoriť novú tému",
"Topic Name" => "Názov témy",
"Upload Image" => "Upload obrázok",
"List of topics" => "Zoznam tém",
"Articles (subs)" => "Články (podčl.)",
"topic image" => "obrázok k téme",
"Deactivate" => "Deaktivovať",
"List Trackers" => "Vypísať Trackers",
"Admin Trackers" => "Administrácia prehľadov",
"Edit This Tracker" => "Upraviť tento prehľad",
"View This Tracker's Items" => "Zobraziť položky tohoto prehľade",
"Tracker fields" => "Tracker polia",
"Edit tracker field" => "Upraviť prehľadové polia",
"Found" => "Nájdené",
"trackers" => "trackery",
"There are individual permissions set for this tracker" => "Platia tu individuálne oprávnenia pre tento prehľad",
"No individual permissions. Global permissions apply." => "Žiadne individuálne práva; budú aplikované práva globálne",
"Show creation date when listing tracker items?" => "Zobraziť dátum vytvorenia v zozname tracker items?",
"Show lastModif date when listing tracker items?" => "zobraziť lastModif date when listing tracker items?",
"Filesize" => "Veľkosť súboru",
"Admin groups" => "Administrácia skupín",
"Admin users" => "Administrácia užívateľov",
"List of existing groups" => "Zoznam existujúcích skupín",
"Edit Item" => "Upraviť položku",
"Add a New User" => "Pridať nového uživateľa",
"Reason" => "Dôvod",
"to groups" => "ku skupinám",
"Generate a password" => "Vygenerovať heslo",
"Overwrite" => "Prepísať",
"Group Information" => "Info o skupine",
"level" => "úroveň",
"Create level" => "Vytvoriť úroveň",
"all permissions in level" => "všetky práva pre úroveň",
"backlinks to" => "spätné odkazy na",
"No backlinks to this page" => "Žiadne spätné odkazy na túto stránku",
"Browse Gallery" => "Prezerať kolekciu",
"Upload From Disk" => "Nahrať z disku",
"Process" => "Proces",
"Edit Post" => "Upraviť záznam",
"View Blog" => "Zobraziť blog",
"Use ...page... to separate pages in a multi-page post" => "použite ...page... pre oddelenie stránok vo viacstránkových príspevkoch",
"Body" => "Telo",
"Upload image for this post" => "Nahrať obrázok pre tento záznam",
"Save and Exit" => "Uložiť a ukončiť",
"Edit Gallery" => "Upraviť kolekciu",
"Rebuild Thumbnails" => "Pregenerovať náhľady obrázkov",
"List Gallery" => "Vypísať galérie",
"Sort Images by" => "Zoradiť obrázky podľa",
"Original Size" => "Pôvodná veľkosť",
"rotate right" => "otočiť doprava",
"rotate" => "otočiť",
"popup" => "pop-up",
"Return to Gallery" => "Späť do galérie",
"Edit Image" => "Upraviť obrázok",
"First Image" => "Prvý obrázok",
"Prev Image" => "Predošlý obrázok",
"Smaller" => "Menší",
"Bigger" => "Väčší",
"Popup window" => "Pop-up okno",
"Next Image" => "Další obrázok",
"Last Image" => "Posledný obrázok",
"Image Name" => "Názov obrázku",
"Image Scale" => "Imagescale",
"Move image" => "Presunúť obrázok",
"Stop Monitoring this Page" => "Ukončiť sledovanie tejto stránky",
"Monitor this Page" => "Sledovať túto stránku",
"Group Calendars" => "Skupinové kalendáre",
"Tentative" => "Nezáväzné",
"Confirmed" => "Potvdené",
"Cancelled" => "Zrušené",
"Edit Calendar Item" => "Upraviť položku kalendára",
"Tuesday" => "Utorok",
"Wednesday" => "Streda",
"Thursday" => "Štvrtok",
"Friday" => "Piatok",
"January" => "Január",
"February" => "Február",
"March" => "Marec",
"April" => "Apríl",
"May" => "Máj",
"June" => "Jún",
"July" => "Júl",
"October" => "Október",
"times" => "&times;",
"End" => "Koniec",
"Duration" => "Trvanie",
"Organized by" => "Organizované podľa",
"Roles" => "Role",
"Change password enforced" => "Vynútená zmena hesla",
"Change your password" => "Zmeniť heslo",
"Send a message to us" => "Pošlite nám správu",
"Contact us by email" => "Kontaktujte nás e-mailom",
"Contacts" => "Kontakty",
"Create/edit contacts" => "Vytvoriť/upraviť kontakty",
"First Name" => "Meno",
"Last Name" => "Priezvisko",
"Nickname" => "Prezývka",
"Structure" => "Štruktúra",
"Add a new site" => "Pridať nový web",
"Site added" => "Odkaz pridaný",
"Directory Administration" => "Administrácia adresárov",
"There are" => "Sú tu",
"invalid sites" => "neplatné weby",
"valid sites" => "platné weby",
"Users have visited" => "Užívatelia navštívili",
"sites from the directory" => "odkazy z katalógu",
"Users have searched" => "Užívatelia vyhľadávali",
"times from the directory" => "&times; v adresári",
"Related" => "Príbuzné",
"Sites" => "Weby",
"Validate" => "Validovat",
"Admin directory categories" => "Administrácia kategórií katalógu odkazov",
"Add a directory category" => "Pridať kategóriu pre katalóg odkazov",
"Edit this directory category" => "Upraviť túto kategóriu katalógu",
"Children type" => "Typ potomka",
"Maximum number of children to show" => "Maximálny počet ukazovaných potomkov",
"Editor group" => "Skupina redaktorov",
"cType" => "cTyp",
"allow" => "povoliť",
"count" => "počet",
"Mutual" => "Vzájomné",
"Admin sites" => "Administrácia webov",
"Is valid" => "Je platný",
"New Sites" => "Nové odkazy",
"Cool Sites" => "Skvelé odkazy",
"Add a Site" => "Pridať odkaz",
"any" => "akýkoľvek",
"in entire directory" => "v celom katalógu",
"Sort by" => "Zoradiť podľa",
"name (desc)" => "názov (sest.)",
"name (asc)" => "názov (vzest.)",
"hits (desc)" => "prístupy (zost.)",
"hits (asc)" => "prístupy (vzost.)",
"creation date (desc)" => "dátum vzniku (zost.)",
"creation date (asc)" => "dátum vzniku (vzost.)",
"last updated (desc)" => "posledná zmena (zost.)",
"last updated (asc)" => "posledná zmena (vzost.)",
"Added" => "Pridané",
"Last updated" => "Naposledy obnovený",
"Total links" => "Celkovo odkazov",
"Links to validate" => "Linky čakajúce na overenie",
"Searches performed" => "Vyhľadaní",
"Total links visited" => "Celkovo navštívených odkazov",
"Search results" => "Výsledky vyhľadávania",
"Validate sites" => "Overiť platnosť webov",
"Edit article" => "Upraviť článok",
"View Articles" => "Zobraziť články",
"Author Name" => "Meno autora",
"Own Image" => "Vlastný obrázok",
"Use own image" => "Použiť vlastný obrázok",
"Float text around image" => "Obtekať textom obrázok",
"Own image size x" => "Vlastný rozmer obrázku x",
"Own image size y" => "Vlastný rozmer obrázku y",
"Publish Date" => "Dátum zverejnenia",
"Edit or create banners" => "Upraviť alebo vytvoriť bannery",
"List banners" => "Vypísať bannery",
"URL to link the banner" => "URL pre banner",
"Client" => "Klient",
"Max impressions" => "Maximum impresií",
"Show the banner only between these dates" => "Zobraziť banner len medzi tymito dátumami",
"From date" => "Odo dňa",
"To date" => "Do dňa",
"Use dates" => "Použiť dátumy",
"Show the banner only in this hours" => "Zobraziť banner iba v týchto hodinách",
"Show the banner only on" => "Zobraziť banner iba v",
"Mon" => "Po",
"Tue" => "Ut",
"Wed" => "Str",
"Thu" => "Št",
"Fri" => "Pia",
"Sat" => "So",
"Sun" => "Ne",
"Select ONE method for the banner" => "Vybrať JEDNU metódu pre banner",
"Use HTML" => "Použiť HTML",
"Use image" => "Použiť obrázok",
"Image:" => "Obrázok:",
"Current Image" => "Súčasný obrázok",
"Use image generated by URL (the image will be requested at the URL for each impression)" => "Použiť obrázok generovaný z URL (o obrázok bude požiadané prístupom na URL pri každej impresii)",
"Use text" => "Použiť text",
"Save the Banner" => "Uložiť banner",
"Current heading" => "Súčasná hlavička",
"There are individual permissions set for this blog" => "Pre tento blog platia individuálne práva",
"Number of posts to show" => "Počet zobrazených záznamov",
"Allow other user to post in this blog" => "Povoliť iným užívateľom prispievať do tohoto blogu",
"Allow search" => "Povoliť vyhľadávanie",
"Allow comments" => "Povoliť komentáre",
"Blog heading" => "Hlavička blogu",
"Edit Style Sheet" => "Upraviť Style Sheet",
"choose a stylesheet" => "vybrať stylesheet",
"Try" => "Skús",
"Colored text" => "Farebný text",
"Box content" => "Obsah boxu",
"External links" => "Externé odkazy",
"Wiki References" => "Wiki referencie",
"JoinCapitalizedWords or use" => "SpojSlovaSVelkymiPismenami alebo použi",
"page|description" => "stránka|popis",
"for wiki references" => "pre wiki referencie",
"SomeName" => "NejakéMeno",
"Lists" => "Zoznamy",
"for bullet lists" => "pre odrážkové zoznamy",
"for numbered lists" => "pre číslované zoznamy",
"for definiton lists" => "pre definičné zoznamy",
"Tables" => "Tabuľky",
"Title bar" => "Titulková lišta",
"Multi-page pages" => "Viacstránkové stránky",
"Non parsed sections" => "Neparsované sekcie",
"No description available" => "Popiska nie je k dispozici",
"Edit successful!" => "Upravené!",
"The following image was successfully edited" => "Nasledujúci obrázok bol úspešne upravený",
"Image Description" => "Popis obrázku",
"You can view this image in your browser using" => "Môžete vidieť tento obrázok vo svojom browseri použitím",
"Edit or ex/import Languages" => "Upraviť alebo ex/importovať jazyky",
"Edit and create Languages" => "Upraviť a vytvorit jazyky",
"Edit and create languages" => "Upraviť a vytvoriť jazyky",
"Create Language" => "Vytvoriť jazyk",
"like" => "ako",
"Select the language to edit" => "Vybrať jazyk pre úpravu",
"Add a translation" => "Pridať preklad",
"Edit translations" => "Upraviť preklady",
"Translation" => "Preklad",
"Create New Block" => "Vytvoriť nový blok",
"Return to block listing" => "Späť na výpis blokov",
"Block description: " => "Popis bloku: ",
"You are editing block:" => "Upravujete blok:",
"Publishing date" => "Dátum publikácie",
"Publishing Date" => "Dátum publikácie",
"Edit question options" => "Upraviť možnosti otázky",
"List Quizzes" => "Vypísať kvízy",
"Quiz Stats" => "Štatistiky kvízov",
"This Quiz Stats" => "štatistiky",
"Edit this Quiz" => "Upraviť tento kvíz",
"Admin Quizzes" => "Administrácia kvízov",
"Create/edit options for question" => "Vytvoriť/upraviť možnosti pre otázku",
"Option" => "Možnosť",
"points" => "body",
"Quiz" => "Kvíz",
"canRepeat" => "môžeOpakovat",
"timeLimit" => "časový limit",
"Create/edit quizzes" => "Vytvoriť/upraviť kvízy",
"There are individual permissions set for this quiz" => "Platia tu individuálne oprávnenia pre tento kvíz",
"Quiz can be repeated" => "Kvíz sa môže opakovať",
"Quiz is time limited" => "Kvíz je časovo obmedzený",
"Maximum time" => "Maximálny čas",
"Edit quiz questions" => "Upraviť otázku kvízu",
"Create/edit questions for quiz" => "Vytvoriť/upraviť otázky pre kvíz",
"maxScore" => "maxSkóre",
"From Points" => "Od bodov",
"To Points" => "Do bodov",
"Answer" => "Odpoveď",
"You will remove" => "Odstránite",
"and its subpages from the structure, now you have two options:" => "a jeho podstránky zo štruktúr; teraz máte dve možnosti:",
"Remove only from structure" => "Odstrániť iba zo štruktúry",
"Remove from structure and remove page too" => "Vyhodiť zo štruktúty a vymazať stránku",
"Previous" => "Predošlá",
"After page" => "Za stránkou",
"Create Page" => "Vytvoriť stránku",
"Use pre-existing page" => "Použiť existujúcu stránku",
"Submit article" => "Poslať článok",
"List Submissions" => "Vypísať uživ. príspevky",
"Edit templates" => "Upraviť šablóny",
"Template listing" => "Výpis šablón",
"Available templates" => "Šablóny k dispozícii",
"The SandBox is a page where you can practice your editing skills, use the preview feature to preview the appearance of the page, no versions are stored for this page." => "Pieskovisko je stránka, kde sa môžete pohrať a vyskúšať si Vaše schopnosti upravovať tiki wiki stránky. Využite možnosť náhľadu pre predstavu, ako bude stránka vyzerať po Vašej úprave. Pre túto stránku niesú uchovávané žiadne verzie jej posledného stavu",
"Upload picture" => "Nahrať obrázok",
"Import page" => "Import stránky",
"export all versions" => "export všetkých verzí",
"Year:" => "Rok:",
"Authors:" => "Autori:",
"License" => "Licencia",
"Important" => "Dôležité",
"votes" => "hlasy",
"lastModif" => "poslednáModif",
"Admin FAQ" => "Administrácia častých otázok",
"List FAQs" => "Vypísať FAQ",
"View FAQ" => "Zobraziť časté otázky",
"Edit this FAQ" => "Upraviť tieto časté otázky",
"New Question" => "Nová otázka",
"Use a question from another FAQ" => "Použiť otázku z iných častých otázok",
"FAQ questions" => "Časté otázky - otázky",
"Suggested questions" => "Odporučené otázky",
"No suggested questions" => "Žiadne odporúčané otázky",
"Upload File" => "Upload súbor",
"You can access the file gallery using the following URL" => "Môžete pristúpiť na súborovaú kolekciu použitím nasledujúceho odkazu",
"Admin forums" => "Administrácia fór",
"Edit queued message" => "Upraviť správu vo fronte",
"make this a thread of" => "zmeniť toto na vlákno z",
"None, this is a thread message" => "Žiadny, toto je vláknová správa",
"normal" => "bežné",
"announce" => "oznámenie",
"hot" => "horúce",
"no feeling" => "žiadny pocit",
"frown" => "grrr!",
"exclaim" => "dôležitý",
"idea" => "nápad",
"neutral" => "neutrálny",
"question" => "otázka",
"happy" => "šťastný",
"wink" => "mrk!",
"Save and Approve" => "Uložiť a schváliť",
"convert to topic" => "previesť na téma",
"List of messages" => "Zoznam správ",
"New Topic" => "Nová téma",
"no summary" => "žiadne zhrnutie",
"No messages queued yet" => "Zatiaľ niesú vo fronte žiadne správy",
"Last Post" => "Posledný záznam",
"Reported by" => "Ohlásené kým:",
"Accept" => "Prijať",
"Galleries" => "Galérie",
"Create New Gallery" => "Vytvoriť novú kolekciu",
"Create a gallery" => "Vytvoriť galériu",
"Edit this gallery:" => "Upraviť túto galériu:",
"There are individual permissions set for this gallery" => "Platia tu individuálne oprávnenia pre túto kolekciu",
"Gallery is visible to non-admin users?" => "Galéria je viditeľná neadminom?",
"Available scales" => "Merítka k dispozícii",
"No scales available" => "Niesú k dispozícii žiadne zmenšenia",
"Other users can upload images to this gallery" => "Ostatní užívatelia môžu uploadovať obrázky do tejto galérie",
"You can access the gallery using the following URL" => "Môžete navštívit galériu pomocou nasledujúceho URL",
"Available Galleries" => "Galérie k dispozícii",
"Imgs" => "Obr.",
"Im- Export languages" => "Import/Export jazykov",
"Select the language to Import" => "Vybrať jazyk pre Import",
"Select the language to Export" => "Vybrať jazyk pre Export",
"Overwrite existing pages if the name is the same" => "Prepísať existujúce stránky s rovnakým menom",
"Result" => "Výsledok",
"Locked" => "Uzamknuté",
"Configure General Settings" => "Všeobecné nastavenia",
"Last Changes" => "Posledné zmeny",
"Search by Date" => "Vyhľadať podľa dátumu",
"Rollback" => "Vrátiť späť",
"Pages like" => "Podobné stránky",
"No pages found" => "Žiadne stránky neboli nájdené",
"Edit New Article" => "Upraviť nový článok",
"View Submissions" => "Zobraziť odoslané",
"AuthorName" => "Autor",
"Create banner" => "Vytvoriť banner",
"Method" => "Metóda",
"Use Dates?" => "Použiť dátumy?",
"Max Impressions" => "Maximum impresií",
"Impressions" => "Impresie",
"Clicks" => "Klepnutí",
"Create New Blog" => "Vytvoriť nový blog",
"Dynamic content system" => "Systém dynamického obsahu",
"Available content blocks" => "Bloky s obsahom k dispozícii",
"Current ver" => "Súčasná ver.",
"Next ver" => "Nasledujúca ver.",
"Available FAQs" => "Dostupné Časté Otázky",
"Edit this FAQ:" => "Upraviť túto častú otázku:",
"Create New FAQ:" => "Vytvoriť nové časté otázky:",
"Users can suggest questions" => "Užívatelia môžu odporúčať otázky",
"Create a File Gallery" => "Vytvoriť kolekciu súborov",
"Gallery Images" => "Prehľad obrázkov",
"Edit Blog" => "Upraviť Blog",
"Blog Title" => "Titulok blogu",
"Edit New Submission" => "Upraviť nový zaslaný príspevok",
"Survey stats" => "Štatistiky prieskumu",
"Last mod" => "Zmenené",
"Last author" => "Posledný autor",
"Last version" => "Posledná verzia",
"unlocked" => "odomknuté",
"Generate HTML" => "Vygenerovať HTML",
"Online operators" => "Online operátori",
"Operator" => "Operátor",
"Offline operators" => "Offline operátori",
"Add an operator to the system" => "Pridať operátora do systému",
"Operators must be tiki users" => "Operátori musia byť registrovaní užívatelia",
"Set as Operator" => "Nastaviť ako operátor",
"Chat started" => "Začíname",
"Operator:" => "Operátor:",
"Request live support" => "Požiadať o live podporu",
"Request support" => "Požiadať o podporu",
"Your request is being processed" => "Vaša požiadavka sa spracováva",
"cancel request and exit" => "zrušit požiadavku a odísť",
"cancel request and leave a message" => "zrušiť požiadavku a opustiť správu",
"be online" => "zostať on-line",
"be offline" => "zostať off-line",
"Support requests" => "Žiadosti o podporu",
"Requested" => "Požiadané",
"reason" => "dôvod",
"msgs" => "správ",
"Prefs" => "Preferencie",
"Daily" => "Denne",
"Weekly" => "Týždenne",
"Remove old events" => "Odstrániť staré udalosti",
"duration" => "trvanie",
"Mini Calendar: Preferences" => "Mini kalendár: Preferencie",
"End hour for days" => "Deň končí v túto hodinu",
"Reminders" => "Pripomienky",
"no reminders" => "žiadne upozornenia",
"Or enter path or URL" => "Alebo zadaj cestu alebo URL",
"Add Topic" => "Pridať tému",
"User Galleries" => "Užívateľské galérie",
"Unread Messages" => "Neprečítané správy",
"Tasks" => "Úlohy",
"MyTiki" => "Moje Tiki",
"Notepad" => "Poznámkový blok",
"MyFiles" => "Moje súbory",
"My Watches" => "Moje sledovanie",
"Sent editions" => "Odoslané úpravy",
"The newsletter was sent to {\$sent} email addresses" => "Newsletter bol zaslaný na {\$sent}",
"Thanks for your subscription. You will receive an email soon to confirm your subscription. No newsletters will be sent to you until the subscription is confirmed." => "Dakujeme za Vaše prihlásenie k odberu. Čoskoro obdržíte e-mail potvrdzujúci Vaše prihlásenie. Nebudú Vám zasielané žiadne správy pokým nebude toto prihlásenie k odberu potvrdené",
"Your email address was removed from the list of subscriptors." => "Your email address was removed from the list of subscriptors",
"Subscription confirmed!" => "Přihlásenie k odberu potvrdené!",
"Subscribe to Newsletter" => "Prihlásiť sa k odberu newsletteru",
"Subscribe to this Newsletter" => "Přihlásiť sa k odberu",
"Notes" => "Poznámky",
"Write a note" => "Napísať poznámku",
"No notes yet" => "Zatiaľ žiadne poznámky",
"Merge selected notes into" => "zlúčiť zvolené poznámky do",
"Reading note:" => "Čítať poznámku:",
"List notes" => "Vypísať poznámky",
"Write note" => "Napísať poznámku",
"Wiki Create" => "Wiki create",
"Wiki Overwrite" => "Wiki overwrite",
"Assign permissions to " => "Priradiť práva pre ",
"Assign permissions to this object" => "Priradiť práva tomuto objektu",
"Published" => "Zverejnené",
"Passcode to register (not your user password)" => "Tajný kód pre registráciu (nie vaše heslo)",
"Orphan Pages" => "Samostatné stránky",
"Browser not supported" => "Prehliadač nie je podporovaný :(",
"Rename" => "Premenovať",
"Slides" => "Slideshow",
"Attach File" => "Priložiť súbor",
"1 File Attached" => "Priložený 1 súbor",
"Pick your avatar" => "Vyberte si avatar",
"User Preferences" => "Preferencie užívateľa",
"Your current avatar" => "Váš súčasný avatar",
"Pick avatar from the library" => "Vybrať avatar zo zoznamu",
"Pick user Avatar" => "Vyberte si avatar",
"Hide all" => "Skryť všetko",
"Show all" => "Zobraziť všetko",
"Upload your own avatar" => "Uploadni svoj vlastný avatar",
"Average" => "priemerne",
"Vote poll" => "Hlasujte v ankete",
"Other Polls" => "Ostatné ankety",
"on:" => "v(e)",
"Viewing blog post" => "Prezeranie záznamu",
"Return to blog" => "Späť na blog",
"The original document is available at" => "Pôvodný dokument je k dispozícii na",
"Print multiple pages" => "Tlač viacerých stránok",
"Quiz result stats" => "Štatistiky výsledkov kvízu",
"Time" => "Čas",
"User answers" => "Odpovede užívateľa",
"Stats for quizzes" => "Štatistiky pre kvízy",
"Av score" => "Priemerné skóre",
"Av time" => "Priemerná doba",
"Clear Stats" => "Vyčistiť štatistiky",
"Stats for this quiz Questions " => "Štatistiky pre otázky tohto kvízu ",
"Received articles" => "Prijaté články",
"Edit received article" => "Upraviť prijatý článok",
"Use Image" => "Použiť obrázok",
"Image x size" => "Velkosť obrázku x",
"Image y size" => "Velkosť obrázku y",
"Image name" => "Názov obrázku",
"Accept Article" => "Prijať článok",
"Site" => "Web",
"Referer stats" => "Štatistiky prístupov",
"Last" => "V&#160;rozmedzí",
"Register as a new user" => "Registrovať ako nový užívateľ",
"Repeat password" => "Zopakovať heslo",
"The following site was added and validation by admin may be needed before appearing on the lists" => "Nasledujúci odkaz bol pridaný. Kým sa odkaz objaví vo výpisoch, môže být požadované jeho schválenie správcom odkazov",
"Send me my Password" => "Pošli mi moje heslo",
"Remove page" => "Odstrániť stránku",
"You are about to remove the page" => "Chcete odstrániť stránku",
"permanently" => "navždy",
"Remove all versions of this page" => "Odstrániť všetky verzie tejto stránky",
"Rollback page" => "Roll-back stránky",
"Search in" => "Vyhľadať v",
"No pages matched the search criteria" => "Žiadna stránka nesplňuje kritéria vyhľadávania",
"This newsletter will be sent to {\$subscribers} email addresses." => "This newsletter will be sent to {\$subscribers} email addresses",
"Send objects" => "Poslať objekty",
"Transmission results" => "Výsledky prenosu",
"Send Wiki Pages" => "Poslať Wiki stránky",
"Send Articles" => "Poslať články",
"Add Article" => "Pridať článok",
"Send objects to this site" => "Poslať objekty na tento web",
"Post or edit a message" => "Pridať alebo upraviť správu",
"Site Stats" => "Štatistiky webu",
"Started" => "Začiatok",
"Days online" => "Dní on-line",
"Total pageviews" => "Celkovo prezretí",
"Average pageviews per day" => "Priemerne prezretí stránky za deň",
"pvs" => "zobr.",
"Best day" => "Najlepší deň",
"Worst day" => "Najhorší deň",
"Wiki Stats" => "Wiki štatistiky",
"Size of Wiki Pages" => "Velkosť Wiki stránok",
"Average page length" => "Priemerná dĺžka stránky",
"Average versions per page" => "Priemerne verzií na stránku",
"Visits to wiki pages" => "Návštev wiki stránok",
"Average links per page" => "Priemerne odkazov na stránku",
"Image galleries Stats" => "Galérie obrázkov: štatistiky",
"Average images per gallery" => "Priemerne obrázkov na galériu",
"Total size of images" => "Celková velkosť obrázkov",
"Average image size" => "Priemerná velkosť obrázku",
"Visits to image galleries" => "Návštev obrázkových galerií",
"File galleries Stats" => "Kolekcie súborov: štatistiky",
"Average files per gallery" => "Priemerne súborov na kolekciu",
"Total size of files" => "Celková velkosť súborov",
"Average file size" => "Priemerná velkosť súboru",
"Visits to file galleries" => "Návštev súborových kolekcií",
"CMS Stats" => "CMS štatistiky",
"Total reads" => "Celkovo prečítaní",
"Average reads per article" => "Priemerne prečítaní na článok",
"Total articles size" => "Celková velkosť článkov",
"Average article size" => "Priemerná velkosť článku",
"Forum Stats" => "štatistiky fór",
"Total topics" => "Celkovo tém",
"Average topics per forums" => "Priemerne tém na diskusné fórum",
"Visits to forums" => "Návštev diskusných fór",
"Blog Stats" => "Štatistiky blogov",
"Weblogs" => "Weblogy",
"Total posts" => "Celkovo záznamov",
"Total size of blog posts" => "Celková velkosť záznamov blogu",
"Average posts size" => "Priemerná veľkosť záznamov",
"Visits to weblogs" => "Návštev weblogov",
"Poll Stats" => "Štatistiky ankiet",
"Total votes" => "Celkovo hlasovaní",
"Average votes per poll" => "Priemerne hlasov na jednu anketu",
"Total questions" => "Celkovo otázok",
"Average questions per FAQ" => "Priemerne otázok na jedny časté otázky",
"User Stats" => "Užívateľské štatistiky",
"Average bookmarks per user" => "Priemerne záložiek na užívateľa",
"Average questions per quiz" => "Priemerne otázok na kvíz",
"Quizzes taken" => "Urobených kvízov",
"Average quiz score" => "Priemerné skóre na jeden kvíz",
"Average time per quiz" => "Priemerne času na jeden kvíz",
"Usage chart" => "Graf použitia",
"Stats for surveys" => "Štatistiky pre prieskumy",
"Last taken" => "Posledný",
"Time Left" => "Zostávajúci čas",
"Send Answers" => "Poslať odpovede",
"Theme is selected as follows" => "Bol vybraný nasledujúci vzhľad",
"If a theme is assigned to the individual object that theme is used." => "Ak je téma priradená individuálnemu objektu, bude použitá táto téma",
"If not then if a theme is assigned to the object's category that theme is used" => "Ak nie, tak ak je priradená téma ku kategórii do ktorej objekt patrí, bude použitá táto téma",
"If not then a theme for the section is used" => "Ak nie, bude použitá téma pre sekciu",
"If none of the above was selected the user theme is used" => "Ak nebolo použité nič z hore uvedeného, bude použitá užívateľská téma",
"Control by Sections" => "Riadiť podľa sekcií",
"Assign themes to categories" => "Priradiť vzhľad kategóriám",
"Assigned categories" => "Priradené kategórie",
"Theme Control Center: Objects" => "Ovládacie centrum vzhľadu: Objekty",
"Control by Categories" => "Riadiť podľa kategorií",
"Assign themes to objects" => "Priradiť vzhľad k objektom",
"Assigned objects" => "Priradené objekty",
"Assign themes to sections" => "Priradiť vzhľad k sekciám",
"Assigned sections" => "Priradené sekce",
"The following file was successfully uploaded" => "Nasledujúci súbor bol úspešne nahratý",
"You can download this file using" => "Môžete si stiahnuť tento súbor použitím",
"Batch Upload Results" => "Výsledky hromadného prenosu",
"Upload successful!" => "Uploadovanie bolo úspešné!",
"The following image was successfully uploaded" => "Nasledujúci obrázok bol úspešne nahratý",
"Now enter the image URL" => "Teraz zadajte URL obrázku",
"or upload a local image from your disk" => "alebo nahrajte obrázok z Vášho disku",
"Batch Upload" => "Hromadný prenos",
"You have to create a gallery first!" => "Musíte najprv vytvoriť galériu!",
"User assigned modules" => "Užívateľsky priradené moduly",
"Restore defaults" => "Obnoviť pôvodné",
"act" => "akt.",
"Assign module" => "Priradiť modul",
"Column" => "Stĺpec",
"Folders" => "Zložky",
"Remove Folder" => "Remove folder",
"Refresh Cache" => "Refresh cache",
"Admin folders and bookmarks" => "Administrácia zložiek a záložiek",
"Send me a message" => "Poslať mi správu",
"Is email public? (uses scrambling to prevent spam)" => "Zverejniť e-mail? (s ošetrením proti spamu)",
"Completed" => "Hotovo",
"No tasks entered" => "Neboli zadané žiadne úlohy",
"Monthly" => "Mesačne",
"A user submits an article" => "Užívateľ posiela článok",
"Add top level bookmarks to menu" => "Pridať záložky najvyššej úrovne do menu",
"Add or edit an item" => "Pridať alebo upraviť položku",
"New Window" => "Nové okno",
"replace window" => "prepísať okno",
"Pos" => "Poz",
"User_versions_for" => "Užívateľské verzie pre",
"This page is being edited by" => "Táto stránka je práve editovaná užívateľom",
"Proceed at your own peril" => "Pokračovať na vlastné nebezpečenstvo",
"Banner stats" => "Štatistiky banneru",
"Create new banner" => "Vytvoriť nový banner",
"Banner Information" => "Informácie o banneri",
"Click ratio" => "Pomer klepnutí",
"Hours" => "Hodiny",
"Weekdays" => "Dni týždňa",
"mon" => "po",
"tue" => "ut",
"wed" => "st",
"thu" => "čt",
"fri" => "pi",
"sat" => "so",
"sun" => "ne",
"Banner raw data" => "Čisté dáta banneru",
"Cached" => "V cache",
"This is a cached version of the page." => "Toto je verzia stránky uložená v cache",
"Click here to view the Google cache of the page instead." => "Click here to view the Google cache of the page instead",
"Forum List" => "Fórum: výpis",
"Edit Forum" => "Upraviť fórum",
"Summary" => "Súhrn",
"for links" => "pre linky",
"Moderator Actions" => "Moderátorské akcie",
"Move Selected Topics" => "Presunúť vybraté topics",
"Unlock Selected Topics" => "Unlock selected topics",
"Lock Selected Topics" => "Uzamknúť vybrané témy",
"Delete Selected Topics" => "Zmazať vybrané témy",
"Merge" => "Zlúčiť",
"Merge Selected Topics" => "Zlúčiť zvolené témy",
"Reported Messages:" => "Nahlásené záznamy:",
"Queued Messages:" => "Správy vo fronte:",
"Merge into topic" => "Zlúčiť do témy",
"pts" => "body",
"Announce" => "Oznámenie",
"Hot" => "Horúce",
"No topics yet" => "Zatiaľ neboli vytvorené žiadne témy",
"Jump to forum" => "Prejsť na fórum",
"All posts" => "Všetky záznamy",
"Last hour" => "Posledná hodina",
"Last 24 hours" => "Posledných 24 hodín",
"Last 48 hours" => "Posledných 48 hodín",
"prev topic" => "nasledujúci obrázok",
"next topic" => "daľšía téma",
"Show posts" => "Zobraziť príspevky",
"Insert New Item" => "Vložiť novú položku",
"Tracker Items" => "Tracker položky",
"Insert new item" => "Vložiť novú položku",
"View Item" => "Zobraziť položku",
"Add a Comment" => "Pridať komentár",
"Back To Mailbox" => "späť do mailboxu",
"Full Headers" => "celé hlavičky",
"Normal Headers" => "normálne hlavičky",
"Reply To All" => "odpovedať všetkým",
"Forward" => "preposlať",
"Select from address book" => "vybrať z address book",
"Use HTML mail" => "Použiť HTML mail",
"The following addresses are not in your address book" => "Nasledujúce adresy niesú vo Vašej knihe adries",
"Add Contacts" => "Pridať kontakty",
"Attachment 1" => "Príloha 1",
"Attachment 2" => "Príloha 2",
"Attachment 3" => "Príloha 3",
"Address book" => "Adresár",
"Save Minor Edit" => "Minor",
"Administration" => "Administrácia",
"General preferences and settings" => "Všeobecné preferencie a nastavenia",
"Wiki settings" => "Nastavenia Wiki",
"Poll comments settings" => "Nastavenia komentárov pre ankety",
"Forums settings" => "Fóra: nastavenia",
"Upload failed" => "Upload sa nepodaril",
"All posted" => "Všetky zaslané",
"Queue anonymous posts" => "Anonymné príspevky do fronty",
"Queue all posts" => "Všetky príspevky do fronty",
"No attachments" => "Žiadne pripojené súbory",
"Everybody can attach" => "Každý môže prikladať prílohy",
"Only users with attach permission" => "Len používatelia ktorí môžu pripájať súbory",
"Moderators and admin can attach" => "Moderátori a admini môžu pripájať súbory",
"Date (desc)" => "Dátum (zost.)",
"Date (asc)" => "Dátum (vzost.)",
"Score (desc)" => "Skóre (sest.)",
"Replies (desc)" => "Odpovede (zost.)",
"Reads (desc)" => "Návštevy (sest.)",
"Owner" => "Vlastník",
"Tag already exists" => "Táto značka už existuje",
"Tag not found" => "Značka nebola nájdená",
"Non-existent link" => "Odkaz neexistuje",
"No menu indicated" => "Žiadne menu nebolo zadané",
"No newsletter indicated" => "Žiadny newsletter nebol nájdený",
"A user registers" => "Užívateľ sa registruje",
"No poll indicated" => "Žiadny prieskum nebol zadaný",
"Permission denied. You cannot view this page." => "Nemáte dostatočné oprávnenia na prezeranie tejo stránky",
"Permission denied you cannot edit this page" => "Nemáte dostatočné oprávnenia na úpravy tejto stránky",
"page not added (Exists)" => "stránka alebola pridaná (existuje)",
"No survey indicated" => "Nebol zadaný žiadny prieskum",
"No tracker indicated" => "Žiadny tracker nebol nájdený",
"Group already exists" => "Táto skupina už existuje",
"User doesn't exist" => "Neexistujúci užívateľ",
"No records were found. Check the file please!" => "Neboli nájdené žiadne záznamy. Skontrolujte súbor prosím!",
"User login is required" => "Užívateľský login je povinná položka",
"Password is required" => "Heslo je povinná položka",
"Email is required" => "E-mail je povinná položka",
"User is duplicated" => "Užívateľ je duplikovaný",
"password" => "heslo",
"Unknown group" => "Neznáma skupina",
"Group doesn't exist" => "Neexistujúca skupina",
"Permission denied you cannot view backlinks for this page" => "Nemáte dostatočné oprávnenia na prezeranie spätných odkazov na túto stránku",
"The page cannot be found" => "Tato stránka nebola nájdená",
"It isn't possible to post in any blog. You may need to create a blog first." => "Nemôžete prispievať do žiadneho z blogov. Možno by ste mal(a) najprv nejaký blog vytvoriť",
"Permission denied you cannot post" => "Nemáte dostatočné oprávnenia. Nemôžete prispievať",
"Permission denied you cannot edit this post" => "Nemáte dostatočné oprávnenia. Nemôžete upravovať tento príspevok",
"Top visited blogs" => "Najnavštevovanejšie blogy",
"Last posts" => "Posledné záznamy",
"Top active blogs" => "Najaktívnejšie blogy",
"Permission denied you cannot access this gallery" => "Nemáte dostatočné oprávnenia. Nemáte prístup do tejto galérie",
"No gallery indicated" => "Nebola zadaná žiadna galéria",
"Permission denied you can not view this section" => "Nemáte dostatočné oprávnenia pre používanie tejto sekcie",
"Permission denied you cannot remove images from this gallery" => "Nemáte dostatočné oprávnenia. Nemôžete odstraňovať obrázky z tejto galérie",
"Permission denied you cannot rebuild thumbnails in this gallery" => "Nemáte dostatočné oprávnenia. Nemôžete pregenerovať náhľady v tejto galérii",
"Permission denied you cannot rotate images in this gallery" => "Nemáte dostatočné oprávnenia. Nemôžete rotovať obrázky v tejto galérii",
"No image indicated" => "Nebol zadaný žiadny obrázok",
"Permission denied you cannot move images from this gallery" => "Nemáte dostatočné oprávnenia na presun obrázkov z tejto galérie",
"Permission denied you cannot view the calendar" => "Nemáte dostatočné oprávnenia. Nemôžete prezerať kalendár",
"Mo" => "Po",
"Tu" => "Ut",
"We" => "St",
"Th" => "Št",
"Fr" => "Pia",
"Sa" => "So",
"Su" => "Ne",
"You can not use the same password again" => "Nemôžete znova použiť to isté heslo",
"Top authors" => "Top autori",
"Message sent to" => "Správa poslaná adresátom",
"This feature has been disabled" => "Táto funkcia je vypnutá",
"Must enter a name to add a site" => "Aby ste mohli pridať web, musíte zadať jeho názov",
"Must enter a url to add a site" => "Aby ste mohli pridať web, musíte zadať jeho URL",
"URL already added to the directory. Duplicate site?" => "URL bolo už přidané. Duplikovaný odkaz?",
"Must select a category" => "Musíte zvoliť kategóriu",
"No site indicated" => "Nebol zadaný žiadny web",
"Article not found" => "Článok nebol nájdený",
"Permission denied you cannot edit this article" => "Nemáte dostatočné oprávnenia. Nemôžete upravovať tento článok",
"You do not have permissions to edit banners" => "Nemáte dostatočné oprávnenia. Nemôžete upravovať bannery",
"Banner not found" => "Banner nebol nájdený",
"You do not have permission to edit this banner" => "Nemáte dostatočné oprávnenia. Nemôžete upravovať tento banner",
"Permission denied you cannot create or edit blogs" => "Nemáte dostatočné oprávnenia. Nemôžete vytvárať alebo upravovať blogy",
"Permission denied you cannot edit this blog" => "Nemáte dostatočné oprávnenia. Nemôžete upravovať tento blog",
"You do not have permission to write the style sheet" => "Nemáte dostatočné oprávnenia. Nie je možné uložiť style sheet",
"Invalid request to edit an image" => "Neplatná požiadavka na úpravu obrázku",
"Permission denied you cannot edit images" => "Nemáte dostatočné oprávnenia. Nemôžete upravovať obrázky",
"Permission denied you can edit images but not in this gallery" => "Nemáte dostatočné oprávnenia. Môžete upravovať obrázky, ale nie v tejto galé©rii",
"Failed to edit the image" => "Nepodarilo sa upraviť obrázok",
"Permission denied to use this feature" => "Nemáte dostatočné oprávnenia na použitie tejto funkcie",
"Language created" => "Jazyk vytorený",
"No content id indicated" => "Nebol zadaný content id",
"No question indicated" => "Žiadna otázka nebola zadaná",
"No quiz indicated" => "Žiadny kvíz nebol zadaný",
"No structure indicated" => "Nebola zadaná žiadna štruktúra",
"Permission denied you cannot send submissions" => "Nemáte dostatočné oprávnenia. Nemôžete posielať užív. príspevky",
"Permission denied you cannot edit submissions" => "Nemáte dostatočné oprávnenia. Nemôžete upravovať uživ. príspevky",
"You have to create a topic first" => "Musíte najprv vytvoriť tému",
"You do not have permission to do that" => "Nemáte dostatočné oprávnenia.",
"You do not have permission to read the template" => "Nemáte dostatočné oprávnenia. Nemôžete načítať šablónu",
"page imported" => "stránka importovaná",
"The SandBox is disabled" => "Pieskovisko je vypnuté",
"Cannot edit page because it is locked" => "Stránka sa nedá upravovať lebo je zamknutá",
"Permission denied you cannot edit this file" => "Nemáte dostatočné oprávnenia. Nemôžete upravovať tento súbor",
"Permission denied you cannot remove files from this gallery" => "Nemáte dostatočné oprávnenia. Nemôžete odstraňovať súbory z tejto kolekcie",
"Top visited file galleries" => "Najnavštevovanejšie kolekcie súborov",
"Most downloaded files" => "Najsťahovanejšie súbory",
"Last files" => "Posledné súbory",
"No forum indicated" => "Žiadne fórum nebolo zadané",
"Last forum topics" => "Posledné témy na fórach",
"Top topics" => "Top témy",
"Forum posts" => "Fórum: príspevky",
"first image" => "prvý obrázok",
"last image" => "posledný obrázok",
"Permission denied you cannot create galleries and so you cant edit them" => "Nemáte dostatočné oprávnenia. Nemôžete vytvárať galérie, a preto ich nemôžete ani editovať",
"Permission denied you cannot edit this gallery" => "Nemáte dostatočné oprávnenia. Nemôžete upravovať túto kolekciu",
"Permission denied you cannot remove this gallery" => "Nemáte dostatočné oprávnenia. Nemôžete odstrániť túto kolekciu",
"Top images" => "Top obrázky",
"Last images" => "Posledné obrázky",
"overwriting old page" => "prepísať starú stránku",
"page created" => "stránka vytvorená",
"No name indicated for wiki page" => "Žiadne meno nebolo zadané pre wiki stránku",
"Permission denied. You cannot view pages like this page" => "Nemáte dostatočné oprávnenia na prezeranie stránok, ako je táto",
"Permission denied you cannot remove articles" => "Nemáte dostatočné oprávnenia. Nemôžete odstraňovať články",
"Permission denied you cannot remove banners" => "Nemáte dostatočné oprávnenia. Nemôžete odstraňovať bannery",
"Permission denied you cannot remove this blog" => "Nemáte dostatočné oprávnenia. Nemôžete odstrániť tento blog",
"Non-existent gallery" => "Galéria neexistuje",
"Permission denied you can upload files but not to this file gallery" => "Nemáte dostatočné oprávnenia. Môžete nahrávat súbory, ale nie do tejto súborovej kolekcie",
"Permission denied you can't upload files so you can't edit them" => "Nemáte dostatočné oprávnenia. Nemôžete uplaodovať súbory, ani ich upravovať",
"You cannot admin blogs" => "Nemôžete spravovat blogy",
"Permission denied you cannot remove submissions" => "Nemáte dostatočné oprávnenia. Nemôžete odstraňovať užív. príspevky",
"Permission denied you cannot approve submissions" => "Nemáte dostatočné oprávnenia. Nemôžete overovať užív. príspevky",
"Must be logged to use this feature" => "Aby ste mohli použiť túto funkciu, musíte byť prihlásený ako registrovaný užívateľ",
"About" => "Všetko o &hellip;",
"You must log in to use this feature" => "Aby ste mohli používať túto funkciu, musíte byť prihlásení.",
"You do not have permission to view other users data" => "Nemáte dostatočné oprávnenia. Nemôžete prezerať dáta ostatných užívateľov",
"No note indicated" => "Žiadna poznámka nebola zadaná",
"merged note:" => "zlúčená poznámka:",
"File is too big" => "Súbor je príliž veľký",
"No item indicated" => "žiadna item nebyla nalezena",
"Page already exists" => "Stránka už existuje",
"Not enough information to display this page" => "Nie je k dispozícii dostatok informácií pre zobrazenie tejto stránky",
"Permission denied you cannot browse this page history" => "Nemáte dostatočné oprávnenia na prezeranie histórie tejto stránky",
"No article indicated" => "Žiadny článok nebol nájdený",
"Article is not published yet" => "Článok zatiaľ nebol publikovaný",
"No post indicated" => "Žiadny post nebol zadaný",
"Blog not found" => "Blog nebol nájdený",
"No pages indicated" => "Žiadne stránky neboli zadané",
"No result indicated" => "Nebol zadaný žiadny výsledok",
"Invalid or unknown username" => "Nesprávne alebo neznáme užívateľské meno",
"A password reminder email has been sent " => "Pripomenutie hesla bolo poslané na e-mail ",
"Permission denied you cannot remove versions from this page" => "Nemáte dostatočné oprávnenia na odstraňovanie verzií z tejto stránky",
"Cannot rename page maybe new page already exists" => "Nie je možné premenovať stránku. Možno taká stránka už existuje",
"Non-existent version" => "Neexistujúca verzia",
"Permission denied you cannot rollback this page" => "Nemáte dostatočné oprávnenia na prevedenie rollbacku tejto stránky",
"successfully sent" => "úspešne odoslané",
"not sent" => "neodoslané",
"Page must be defined inside a structure to use this feature" => "Pre využitie tejto funkcie musí byť stránka definovaná v štruktúre",
"You cannot take this quiz twice" => "Nie je možné robiť tento kvíz dvakrát",
"Quiz time limit exceeded quiz cannot be computed" => "Časový limit pre kvíz bol prekročený, výsledky nemôžu byť zarátané",
"You cannot take this survey twice" => "Nie je možné robiť tento prieskum dvakrát",
"Please create a category first" => "Prosím, vytvorte najprv kategóriu",
"No permission to upload zipped file packages" => "žiadna permission to upload zipped file packages",
"Error processing zipped image package" => "Chyba pri spracování komprimovaného archívu s obrázkami",
"No permission to upload zipped image packages" => "Nemáte dostatočné práva na uploadovanie zozipovných obrázkov",
"Permission denied you cannot upload images" => "Nemáte dostatočné oprávnenia. Nemôžete nahrávať obrázky",
"Permission denied you can upload images but not to this gallery" => "Nemáte dostatočné oprávnenia. Môžete uploadovať obrázky, ale nie do tejto galérie",
"Cannot get image from URL" => "Z URL sa nedá získať obrázok",
"No url indicated" => "Nebola zadaná žiadna URL",
"Unknown user" => "Neznámy užívatel",
"You are not logged in and no user indicated" => "Nie ste prihlásený(á) a nenašiel sa žiadny podobný užívateľ",
"The user has chosen to make his information private" => "Užívateľ si nepraje zverejňovať osobné informácie",
"The passwords did not match" => "Heslá sa nezhodovali",
"no" => "nie",
"Cannot upload this file not enough quota" => "Nie je možné uploadnuť tento súbor, nemáte dosť miesta",
"No user indicated" => "Nebol zadaný žiadny užívateľ",
"Non-existent user" => "Neexistujúci užívateľ",
"No banner indicated" => "Žiadny banner nebol zadaný",
"No blog indicated" => "Nebol zadaný žiadny blog",
"Permission denied you cannot remove the post" => "Nemáte dostatočné oprávnenia. Nemôžete odstrániť tento záznam",
"No cache information available" => "Žiadna informácia o cache nie je k dispozici",
"No faq indicated" => "Žiadne FAQ nebolo zadané",
"No thread indicated" => "Nebolo zadané žiadne vlákno",
"Aborted" => "Prerušené",
"Top pages" => "Top stránky",
"Last pages" => "Posledné stránky",
"###end###"=>"###end###");
